<?php
include_once("config_bd.php");
$chave_definida = '10340593634';
if (!isset($_GET['chave']) || $_GET['chave'] !== $chave_definida) {
    echo json_encode(['erro' => 'Acesso negado']);
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['suprimido']) && $_GET['suprimido'] == 1) {
    // Menu suprimido 1 //Procedimento URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&suprimido=1
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
             SELECT 
            
            IFNULL(t2.nome_grupo_procedimento, 'SEM ESPECIFICAÇÃO') AS nome_grupo,
            COUNT(t1.id_solicitacao) AS total_solicitacoes
            FROM 
                reg_tb_solicitacoes t1
            LEFT JOIN 
                reg_tb_procedimento_grupo t2 ON t1.id_grupo_procedimento = t2.id_grupo_procedimento
            WHERE
             id_statussolicitacao = 2
        
            GROUP BY 
                t2.nome_grupo_procedimento
            ORDER BY 
                total_solicitacoes desc
            limit 15;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Relatório de Demanda Reprimida por Grupo:* \n\n";
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Relatório ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_grupo'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "🟢 - *{$nome}* - {$quantidade}\n";
            }
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['suprimido']) && $_GET['suprimido'] == 2) {
    // Menu suprimido 2 //Procedimento URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&suprimido=2
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
             SELECT 
            IFNULL(t2.codigo_sus, 'SEM ESPECIFICAÇÃO') AS codigo_sus,
            IFNULL(TRIM(REPLACE(REPLACE(t2.nome_procedimento, '  ', ' '), '\t', '')), 'SEM ESPECIFICAÇÃO') AS nome_procedimento,
            COUNT(t1.id_solicitacao) AS total_solicitacoes
            FROM 
                reg_tb_solicitacoes t1
            LEFT JOIN 
                reg_tb_procedimento t2 ON t1.id_procedimento = t2.id_procedimento
            WHERE
             id_statussolicitacao = 2
             
            
            GROUP BY 
                t2.codigo_sus, t2.nome_procedimento
            ORDER BY 
                total_solicitacoes desc
            limit 20;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Relatório de Demanda Reprimida por Procedimentos:* \n\n";
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Relatório ainda não disponível.";
        } else {
            $contadorPosicao = 0;
            foreach ($resultados as $linha) {
                $contadorPosicao = $contadorPosicao + 1;
                $nome = $linha['nome_procedimento'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "$contadorPosicao)º - *{$nome}* - {$quantidade}\n";
            }
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['menu']) && $_GET['menu'] == 2) {
    // Menu ranking 2 URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&menu=2
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
             SELECT 
    IFNULL(t2.codigo_sus, 'SEM ESPECIFICAÇÃO') AS codigo_sus,
    IFNULL(TRIM(REPLACE(REPLACE(t2.nome_procedimento, '  ', ' '), '\t', '')), 'SEM ESPECIFICAÇÃO') AS nome_procedimento,
    COUNT(t1.id_solicitacao) AS total_solicitacoes
            FROM 
                reg_tb_solicitacoes t1
            LEFT JOIN 
                reg_tb_procedimento t2 ON t1.id_procedimento = t2.id_procedimento
            WHERE 
              t1.datahora_cadastro >= CURDATE()
            AND t1.datahora_cadastro IS NOT NULL
            
            GROUP BY 
                t2.codigo_sus, t2.nome_procedimento
            ORDER BY 
                total_solicitacoes desc
            limit 10;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Ranking de Procedimentos mais solicitados do dia:* \n\n";
        $totalGeral = 0;
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Ranking ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_procedimento'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "🩺 - *{$nome}* - {$quantidade}\n";
                $totalGeral += $quantidade;
            }

            $mensagem .= "\n\n🔢 *Total Geral de Solicitações*: {$totalGeral}";
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['menu']) && $_GET['menu'] == 3) {
    // Menu solicitacao mes 3 URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&menu=3
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
             SELECT 
    IFNULL(t2.codigo_sus, 'SEM ESPECIFICAÇÃO') AS codigo_sus,
    IFNULL(TRIM(REPLACE(REPLACE(t2.nome_procedimento, '  ', ' '), '\t', '')), 'SEM ESPECIFICAÇÃO') AS nome_procedimento,
    COUNT(t1.id_solicitacao) AS total_solicitacoes
            FROM 
                reg_tb_solicitacoes t1
            LEFT JOIN 
                reg_tb_procedimento t2 ON t1.id_procedimento = t2.id_procedimento
            WHERE 
             t1.datahora_cadastro >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)
            AND t1.datahora_cadastro < CURDATE()
            GROUP BY 
                t2.codigo_sus, t2.nome_procedimento
            ORDER BY 
                total_solicitacoes desc
            limit 10;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Ranking de Procedimentos mais solicitados do mês:* \n\n";
        $totalGeral = 0;
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Ranking ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_procedimento'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "🩺 - *{$nome}* - {$quantidade}\n";
                $totalGeral += $quantidade;
            }

            $mensagem .= "\n\n🔢 *Total Geral de Solicitações*: {$totalGeral}";
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['menu']) && $_GET['menu'] == 4) {
    // Menu ranking 4 URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&menu=4
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
            SELECT  
    IFNULL(t3.nfantasia_estabelecimento, 'SEM ESPECIFICAÇÃO') AS nfantasia_estabelecimento,
    COUNT(t1.id_solicitacao) AS total_solicitacoes
FROM 
    reg_tb_solicitacoes t1
LEFT JOIN 
    (
        SELECT 
            t2.id_usuario, 
            t2.id_unidadeassociada
        FROM 
            reg_tb_usuario_perfil t2
       
        WHERE 
            LENGTH(t2.id_unidadeassociada) <= 3
            AND t2.id_usuarioperfil = (
                SELECT MAX(id_usuarioperfil)
                FROM reg_tb_usuario_perfil
                WHERE id_usuario = t2.id_usuario
            )
    ) t2 ON t1.id_usuario_cadastrou = t2.id_usuario
            LEFT JOIN 
                tb_estabelecimento t3 ON t2.id_unidadeassociada = t3.codigoestabelecimento_cnes
            WHERE 
            t1.datahora_cadastro >= CURDATE()
                AND t1.datahora_cadastro IS NOT NULL
            GROUP BY 
                t3.cnes_estabelecimento, t3.nfantasia_estabelecimento
            ORDER BY 
                total_solicitacoes DESC
            LIMIT 10;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Ranking de solicitações por unidade:* \n\n";
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Ranking ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_unidade'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "🏥 - *{$nome}*: {$quantidade}\n";
            }
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['menu']) && $_GET['menu'] == 5) {
    // Menu ranking 5 URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&menu=5
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
            SELECT  
            UPPER(IFNULL(t3.nome_usuario, 'SEM ESPECIFICAÇÃO')) AS nome_usuario,
            COUNT(t1.id_solicitacao) AS total_solicitacoes
            FROM 
                reg_tb_solicitacoes t1
            LEFT JOIN 
                reg_tb_usuario t3 ON t1.id_usuario_cadastrou = t3.id_usuario
            WHERE
            t3.id_usuario != 79 AND t3.id_usuario != 80 
               AND t1.datahora_cadastro >= CURDATE()
              AND t1.datahora_cadastro IS NOT NULL
              
            GROUP BY 
                t3.nome_usuario
            ORDER BY 
                total_solicitacoes DESC
            LIMIT 10;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Ranking de solicitações por profissional solicitante:* \n\n";
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Ranking ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_usuario'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "👩🏿‍💻 Solicitante: *{$nome}*: {$quantidade}\n";
            }
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['menu']) && $_GET['menu'] == 6) {
    // Menu ranking 6 URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&menu=6
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "
            SELECT  
            UPPER(IFNULL(t3.nome_usuario, 'SEM ESPECIFICAÇÃO')) AS nome_usuario,
            COUNT(t1.id_agendamento) AS total_solicitacoes
            FROM 
                reg_tb_agendamentos  t1
            LEFT JOIN 
                reg_tb_usuario t3 ON t1.id_usuario_agendou = t3.id_usuario
            WHERE  (t1.status_agendamento = 'A')
            AND  t3.id_usuario != 79 AND t3.id_usuario != 80 
            and datahora_agendamento >= CURDATE()
            GROUP BY 
                t3.nome_usuario
            ORDER BY 
                total_solicitacoes DESC
            LIMIT 10;
        ";

        $stmt = $pdo->prepare($consulta);
        $stmt->execute();

        $mensagem = "📊 *Ranking de agendamentos por usuário:* \n\n";
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($resultados)) {
            $mensagem .= "Ranking ainda não disponível.";
        } else {
            foreach ($resultados as $linha) {
                $nome = $linha['nome_usuario'];
                $quantidade = number_format($linha['total_solicitacoes'], 0, '', '.');
                $mensagem .= "👩🏿‍💻{$nome}: {$quantidade}\n";
            }
        }

        echo json_encode(['mensagem' => $mensagem]);
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
    exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (isset($_GET['valida']) && isset($_GET['telefone'])) {
    $telefone_bruto = $_GET['telefone'];


    if (strpos($telefone_bruto, '@') !== false) {
        $telefone_bruto = explode('@', $telefone_bruto)[0];
    }


    $telefone_limpo = preg_replace('/\D/', '', $telefone_bruto);


    if (substr($telefone_limpo, 0, 2) === '55') {
        $telefone_limpo = substr($telefone_limpo, 2);
    }


    if (strlen($telefone_limpo) === 10) {
        $telefone = substr($telefone_limpo, 0, 2) . '9' . substr($telefone_limpo, 2);
    } elseif (strlen($telefone_limpo) === 11) {
        $telefone = substr($telefone_limpo, 2);
    } else {
        echo json_encode(['erro' => 'Telefone inválido']);
        exit;
    }
    // Validação do numero, Gestor. URL: https://laurodefreitas.portalgsaude.app.br/bot/regulacao/gestor.php?chave=10340593634&valida=1&telefone=71988721170@whatsapp.net
    try {
        $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $consulta = "SELECT nome_usuario, e_gestor 
            FROM reg_tb_usuario 
            WHERE REPLACE(REPLACE(REPLACE(REPLACE(fonecelular, '(', ''), ')', ''), '-', ''), ' ', '') = :telefone
            AND e_gestor = 'S' AND ativo='1'";
        $stmt = $pdo->prepare($consulta);
        $stmt->bindValue(':telefone', $telefone, PDO::PARAM_STR);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
            $explodeUsuario = explode(" ", $resultado['nome_usuario']);
            $nomeUsuario    = $explodeUsuario[0];
            echo json_encode([
                'GESTOR' => 1,
                'usuario' => ucwords(strtolower($nomeUsuario))
            ]);
        } else {
            echo json_encode([
                'GESTOR' => 0,
                'usuario' => null,
                'telefone' => $telefone
            ]);
        }
    } catch (PDOException $e) {
        echo json_encode(['erro' => 'Erro na conexão com o banco de dados.', 'detalhes' => $e->getMessage()]);
    }
} else {
    echo json_encode(['erro' => 'Parâmetros insuficientes']);
}
