<?php
    require __DIR__ . '/src/BuscaViaCEP_inc.php';
    use Jarouche\ViaCEP\HelperViaCep;

$numeroCEP =  $_GET['cep'];
BuscaCEP($numeroCEP,'');

function BuscaCEP($numcep,$opcao_cep){
  $array_tipos =['Querty','Piped','JSON','JSONP','XML'];    
  $concatenaRetoenoCEP = "";

  foreach ($array_tipos as $tipo){
    $class_cep = HelperViaCep::getBuscaViaCEP($tipo,"$numcep");
  } 
     
  $jsonObj   = json_encode($class_cep);
  $dadoJson  = json_decode($jsonObj);
  $retorno = $dadoJson->result;

  if(isset($retorno->cep)){
    $v_cep      = $retorno->cep;
    $v_end      = $retorno->logradouro;
    $v_bairro   = $retorno->bairro;
    $v_nmcidade = $retorno->localidade;
    $v_uf       = $retorno->uf;
    $v_ibge     = substr($retorno->ibge, 0, -1);      
  }else{
    $v_cep      = "0";
    $v_end      = "";
    $v_bairro   = "";
    $v_nmcidade = "";
    $v_uf       = "";
    $v_ibge     = "";
  }

  switch ($opcao_cep){
    case "cep":
      return mb_strtoupper($v_cep);
      break;
    case "end":
      return mb_strtoupper($v_end);
      break;
    case "bairro":
      return mb_strtoupper($v_bairro);
      break;
    case "nmcidade":
      return mb_strtoupper($v_nmcidade);
      break;
    case "uf":
      return mb_strtoupper($v_uf);
      break;
    case "ibge":
      return mb_strtoupper($v_ibge);
      break;      
  }

  $concatenaRetoenoCEP = mb_strtoupper($v_end) . "#" . mb_strtoupper($v_bairro) . "#" . mb_strtoupper($v_nmcidade) . "#" . mb_strtoupper($v_uf) . "#" . mb_strtoupper($v_ibge);
  
  echo $concatenaRetoenoCEP;

}


?>