<?php
session_start();
require("../../database/dbConection.php");

$opcaoExclusao        = $_POST['opcaoExclusao'];
$idRegistroExclusao   = $_POST['idRegistroExclusao'];

$formatarOrigem = array(
  'lista_unica' => 'LISTA ÚNICA',
  'policlinica' => 'POLICLÍNICA',
  'sisreg' => 'SISREG',
  'sistema_vida' => 'VIDA+',
);

switch ($opcaoExclusao) {

  case 'procedimento_agendamento_b':
    $idPaciente           = $_POST['idPaciente'];
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_agendamentos WHERE id_agendamento='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();

    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_agendamentos AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    /* carregar lista atualizada */
    $sqlDemandas  = "SELECT reg_tb_agendamentos.*, date_format(data_atendimento,'%d/%m/%Y') dataAtendimento, date_format(data_retirada,'%d/%m/%Y') dataRetirada,
    tb_usuario.nome_usuario AS nomeUsuarioCadastrou, tb_usuario_1.nome_usuario AS nomeUsuarioAlterou, reg_tb_procedimento.nome_procedimento FROM reg_tb_agendamentos 
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento) 
    INNER JOIN tb_usuario ON (reg_tb_agendamentos.id_usuario_cadastrou = tb_usuario.id_usuario)
    LEFT OUTER JOIN tb_usuario tb_usuario_1 ON (tb_usuario_1.id_usuario = reg_tb_agendamentos.id_usuario_alterou) WHERE id_paciente='$idPaciente'";
    $stmDemandas  = $rsConexao->prepare($sqlDemandas);
    $stmDemandas->execute();
    $rsDemandas = $stmDemandas->fetchAll(PDO::FETCH_ASSOC);
    $totalRegistros  = $stmDemandas->rowCount();

    if ($totalRegistros > 0) {
      foreach ($rsDemandas as $fieldDemanda) {
        $idAgendamento      = $fieldDemanda['id_agendamento'];
        $numeroSolicitacao  = mb_strtoupper($fieldDemanda['numero_solicitacao']);
        $nomeProcedimento    = mb_strtoupper($fieldDemanda['nome_procedimento']);
        $sistemaOrigem      = $formatarOrigem[$fieldDemanda['origem_agendamento']];
        $dataAtendimento    = $fieldDemanda['dataAtendimento'];
        $dataRetirada        = $fieldDemanda['dataRetirada'];
        $statusAgendamento  = mb_strtoupper($fieldDemanda['status_agendamento']);
        $dataEditar          = mb_strtoupper($fieldDemanda['data_retirada']);

        if (date("Y-m-d") > $dataEditar) {
          $backgroundColor = "style='background-color:#860000; color:#fff !important'";
        } else {
          $backgroundColor = "";
        }

        if ($fieldDemanda['id_usuario_alterou'] == "") {
          $ultimoUsuario = $fieldDemanda['nomeUsuarioCadastrou'];
        } else {
          $ultimoUsuario = $fieldDemanda['nomeUsuarioAlterou'];
        }

        if ($statusAgendamento == "AGENDADO") {
          $linkEditarAgendamento    = '"editarAgendamento(' . "'$idAgendamento')" . '"';
          $comandoEditarAgendamento = " <i class='icofont icofont-edit nova_fonte' title='Editar registro de procedimento agendado.'  onclick=$linkEditarAgendamento></i>&nbsp;";

          $linkExcluirAgendamento    = '"excluirAgendamento(' . "'$idAgendamento')" . '"';
          $comandoExcluirAgendamento  = "<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de procedimento agendado.'  onclick=$linkExcluirAgendamento></i>&nbsp;";
        } else {
          $comandoEditarAgendamento    = "N/A";
          $comandoExcluirAgendamento  = "";
        }

        if ($fieldDemanda['observacoes_demanda'] != "") {
          $linkVerObservacao  = '"verObservacaoRegistroAgendamento(' . "'$idAgendamento')" . '"';
          $linkVerObservacao  = "<i class='icofont icofont-info-square nova_fonte' title='Ver Observação.'  onclick=$comandoEditarAgendamento></i>";
        } else {
          $linkVerObservacao  = "&nbsp&nbsp&nbsp&nbsp&nbsp";
        }
        echo "<tr>
          <td style='text-align:center'>
            $comandoEditarAgendamento
            $comandoExcluirAgendamento
          </td>	
          <td align='center'>$numeroSolicitacao</td>
          <td>$nomeProcedimento</td>
          <td>$sistemaOrigem</td>
          <td align='center'>$dataAtendimento</td>
          <td align='center' $backgroundColor>$dataRetirada</td>
          <td align='center'>$statusAgendamento</td>
          <td>$ultimoUsuario</td>
        </tr>";
      }
    }
    break;

  case 'procedimento_agendamento':
    $stmExisteDemanda     = $rsConexao->prepare("SELECT id_agendamento FROM reg_tb_agendamentos WHERE id_procedimento='$idRegistroExclusao'");
    $stmExisteDemanda->execute();
    $registrosExistentes  = $stmExisteDemanda->rowCount();

    if ($registrosExistentes > 0) {
      echo "ExisteDemanda";
    } else {

      $stmlRegistroExclusao         = $rsConexao->prepare("DELETE FROM reg_tb_procedimento WHERE id_procedimento='$idRegistroExclusao'");
      $stmlRegistroExclusao->execute();
      $stmlReiniciarAutoIntremento  = $rsConexao->prepare("ALTER TABLE reg_tb_procedimento AUTO_INCREMENT=1");
      $stmlRegistroExclusao->execute();

      $grupoProcedimento            = $_POST['grupoProcedimento'];
      //******* carregar lista atualizada *******/  
      $sqlProcedimento = "SELECT reg_tb_procedimento.*, reg_tb_procedimento_grupo.nome_grupo_procedimento FROM reg_tb_procedimento INNER JOIN
      reg_tb_procedimento_grupo ON (reg_tb_procedimento.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
      WHERE reg_tb_procedimento.id_grupo_procedimento='$grupoProcedimento' ORDER BY nome_procedimento;";
      $stmProcedimento    = $rsConexao->prepare($sqlProcedimento);
      $stmProcedimento->execute();
      $rsProcedimento     = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
      $totalProcedimentos = $stmProcedimento->rowCount();


      if ($totalProcedimentos > 0) {

        foreach ($rsProcedimento as $fieldProcedimento) {
          $idProcedimento            = $fieldProcedimento['id_procedimento'];
          $nomeProcedimento          = mb_strtoupper($fieldProcedimento['nome_procedimento']);
          $codigoSisreg              = $fieldProcedimento['codigo_sus'];
          $sexoPermitidoExibir      = $formatarSexo[$fieldProcedimento['sexo_permitido']];
          $sexoPermitido            = $fieldProcedimento['sexo_permitido'];
          $faixaEtariaIdadeInicial  = $fieldProcedimento['faixaetaria_idadeinicial'];
          $faixaEtariaIdadeFinal    = $fieldProcedimento['faixaetaria_idadefinal'];
          $faixaEtariaExibir        = "$faixaEtariaIdadeInicial - $faixaEtariaIdadeFinal";
          $idGrupo                  = $fieldProcedimento['id_grupo_procedimento'];
          $nomeGrupo                = mb_strtoupper($fieldProcedimento['nome_grupo_procedimento']);
          $disponivelGuiche         = $fieldProcedimento['disponivel_guiche'];
          $getPreparosProcedimentos = $fieldProcedimento['preparo_procedimento'];
          $getObervacaoProcedimento = $fieldProcedimento['observacao_procedimento'];

          $disponivelGuicheExibir = $fieldProcedimento['disponivel_guiche'] == "S" ? "SIM" : "NÃO";

          $linkEditarProcedimento   = '"editarProcedimento(' . "'$idProcedimento#$idGrupo#$nomeProcedimento#$codigoSisreg#$sexoPermitido#$faixaEtariaIdadeInicial#$faixaEtariaIdadeFinal#$disponivelGuiche#$getPreparosProcedimentos')" . '"';
          $linkExcluirProcedimento  = '"excluirProcedimento(' . "'$idProcedimento')" . '"';

          echo "<tr>
            <td style='text-align:center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar registro de procedimento.'  onclick=$linkEditarProcedimento></i>&nbsp;
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de procedimento.'  onclick=$linkExcluirProcedimento></i>&nbsp;
            </td>      
            <td style='text-align:left'>$nomeGrupo</td>
            <td>$nomeProcedimento</td>
            <td style='text-align:center'>$codigoSisreg</td>
            <td style='text-align:center'>$sexoPermitidoExibir</td>
            <td style='text-align:center'>$faixaEtariaExibir</td>
            <td style='text-align:center'>$disponivelGuicheExibir</td>
          </tr>";
        }
      }
    }
    break;

  case 'grupo_cadastrado':
    $stmExisteDemanda     = $rsConexao->prepare("SELECT id_grupo_procedimento FROM reg_tb_procedimento WHERE id_grupo_procedimento='$idRegistroExclusao'");
    $stmExisteDemanda->execute();
    $registrosExistentes  = $stmExisteDemanda->rowCount();

    if ($registrosExistentes > 0) {
      echo "ExisteProcedimento";
      exit;
    } else {
      $stmlRegistroExclusao         = $rsConexao->prepare("DELETE FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento='$idRegistroExclusao'");
      $stmlRegistroExclusao->execute();
      $stmlReiniciarAutoIntremento  = $rsConexao->prepare("ALTER TABLE reg_tb_procedimento_grupo AUTO_INCREMENT=1");
      $stmlRegistroExclusao->execute();

      //******* carregar lista atualizada */  
      $stmGrupo    = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1'");
      $stmGrupo->execute();
      $rsGrupo     = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
      $totalGrupo  = $stmGrupo->rowCount();

      if ($totalGrupo > 0) {
        foreach ($rsGrupo as $fieldGrupo) {
          $idGrupo    = $fieldGrupo['id_grupo_procedimento'];
          $nomeGrupo  = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);

          $linkEditarGrupo  = '"editarGrupo(' . "'$idGrupo##$nomeGrupo')" . '"';
          $linkExcluirGrupo  = '"excluirGrupo(' . "'$idGrupo')" . '"';
          echo "<tr>
            <td style='text-align:center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar registro de Grupo.' onclick=$linkEditarGrupo></i>&nbsp;
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de Grupo.'  onclick=$linkExcluirGrupo></i>
            </td>
            <td>$nomeGrupo</td>
          </tr>";
        }
      }
    }
    break;

  case 'documento_anexo':
    $stmlRegistroExclusao         = $rsConexao->prepare("DELETE FROM reg_tb_solicitacoes_anexos WHERE id_sca_documentoanexo='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlReiniciarAutoIntremento  = $rsConexao->prepare("ALTER TABLE reg_tb_solicitacoes_anexos AUTO_INCREMENT=1");
    $stmlRegistroExclusao->execute();

    unlink($_POST['anexoExcluir']);

    $tokenSolicitacao = $_POST['tokenSolicitacao'];
    //******* carregar lista atualizada */  
    $diretorioBase  = "docsolicitacoes/";
    $diretorioData  = date("Ym");

    $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, reg_tb_solicitacoes_anexos.id_sca_solicitacao, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) WHERE token_solicitacao='$tokenSolicitacao'";

    $stmDocumento = $rsConexao->prepare($sqlDocumento);
    $stmDocumento->execute();

    if ($stmDocumento->rowCount() > 0) {
      $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
      $contarDocs   = 0;
      foreach ($rsDocumento as $fieldDocumento) {
        $contarDocs         = $contarDocs + 1;
        $idDocumento        = $fieldDocumento['id_sca_documentoanexo'];
        $idSolicitacaoAnexo = $fieldDocumento['id_sca_solicitacao'];
        $dataHoraInclusao   = $fieldDocumento['dataInclusao'] . ' ÀS ' . $fieldDocumento['horaInclusao'];
        $tipoDocumento      = $fieldDocumento['nome_tipodocumento'];
        $idTipoDocumento    = $fieldDocumento['id_tipodocumento'];
        $pastaDocumento     = $fieldDocumento['pasta_documento'];
        $nomeArquivo        = mb_strtoupper($fieldDocumento['nomearquivo_documento']);
        $arquivoAnexo       = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];

        $cliqueBotaoVisualizarDocumento = 'onClick="window.open(' . "'$arquivoAnexo')" . '"';
        $botaoVisualizarDocumento  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;

        if ($idSolicitacaoAnexo == "") {
          $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo(' . "'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
          $botaoExcluirAnexo  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;
        } else {
          $botaoExcluirAnexo  = "";
        }

        echo "<tr>
          <td align='center'>$botaoVisualizarDocumento&nbsp;$botaoExcluirAnexo</td>
          <td style='display:none' align='center' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
          <td align='center'>$dataHoraInclusao</td>
          <td>$tipoDocumento</td>
          <td id='tdNomeArquivo$contarDocs'>$nomeArquivo</td>
        </tr>";
      }
    }
    break;

  case 'documento_agendado':

    $stmlRegistroExclusao         = $rsConexao->prepare("DELETE FROM reg_tb_solicitacoes_agendado WHERE id_sca_documentoagendado='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlReiniciarAutoIntremento  = $rsConexao->prepare("ALTER TABLE reg_tb_solicitacoes_agendado AUTO_INCREMENT=1");
    $stmlRegistroExclusao->execute();


    $idSolicitacao = $_POST['idSolicitacao'];
    //******* carregar lista atualizada */  
    $diretorioBase  = "docagendamentos/";
    unlink("../" . $_POST['anexoExcluir']);

    $sqlDocumentoAgendado = "SELECT reg_tb_solicitacoes_agendado.id_sca_documentoagendado, 
    date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
    date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%H:%i') AS horaInclusao, 
    reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_agendado.pasta_documento, 
    reg_tb_solicitacoes_agendado.nomearquivo_documento, 
    reg_tb_solicitacoes_agendado.id_tipodocumento, 
    reg_tb_usuario.nome_usuario, tb_estabelecimento.nfantasia_estabelecimento
    FROM reg_tb_solicitacoes_agendado 
    INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_agendado.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
    INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes_agendado.id_usuario_cadastrou = reg_tb_usuario.id_usuario) 
    INNER JOIN tb_estabelecimento ON (reg_tb_solicitacoes_agendado.id_unidade_cadastrou = tb_estabelecimento.codigoestabelecimento_cnes)
    WHERE id_sca_solicitacao='$idSolicitacao'";

    $stmDocumentoAgendado = $rsConexao->prepare($sqlDocumentoAgendado);
    $stmDocumentoAgendado->execute();

    if ($stmDocumentoAgendado->rowCount() > 0) {
      $rsDocumentoAgendado  = $stmDocumentoAgendado->fetchAll(PDO::FETCH_ASSOC);
      $contarDocsAgendado   = 0;
      foreach ($rsDocumentoAgendado as $fieldDocumentoAgendado) {
        $contarDocsAgendado       = $contarDocsAgendado + 1;
        $idDocumentoAgendado      = $fieldDocumentoAgendado['id_sca_documentoagendado'];
        $dataHoraInclusaoAgendado = $fieldDocumentoAgendado['dataInclusao'] . ' ÀS ' . $fieldDocumentoAgendado['horaInclusao'];
        $tipoDocumentoAgendado    = $fieldDocumentoAgendado['nome_tipodocumento'];
        $idTipoDocumentoAgendado  = $fieldDocumentoAgendado['id_tipodocumento'];
        $pastaDocumentoAgendado   = $fieldDocumentoAgendado['pasta_documento'];
        $numeracaoArquivo         = $fieldDocumentoAgendado['numeracao_arquivo'];
        $incluidoPor              = $fieldDocumentoAgendado['nome_usuario'] . "<br>(" . $fieldDocumentoAgendado['nfantasia_estabelecimento'] . ")";
        $nomeArquivoAgendado      = mb_strtoupper($fieldDocumentoAgendado['nomearquivo_documento']);

        $arquivoAnexoAgendado     = $diretorioBase . $pastaDocumentoAgendado . '/' . $numeracaoArquivo . '_' . $fieldDocumentoAgendado['nomearquivo_documento'];

        $cliqueBotaoVisualizarDocumentoAg = 'onClick="window.open(' . "'$arquivoAnexoAgendado')" . '"';
        $botaoVisualizarDocumentoAgendado  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumentoAg></i>";;

        $cliqueBotaoExcluirAnexoAgendado = 'onClick="excluirAnexo(' . "'$idDocumentoAgendado','$arquivoAnexoAgendado','$idSolicitacao')" . '"';
        $botaoExcluirAnexoAgendado  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexoAgendado></i>";;

        echo "<tr>
          <td style='text-align: center !important; width:20px !important'>
            $botaoVisualizarDocumentoAgendado
            $botaoExcluirAnexoAgendado
          </td>
          <td style='display:none' id='idTipoDoc$contarDocsAgendado'>$idTipoDocumentoAgendado</td>
          <td style='width: 80px; text-align:center'>$dataHoraInclusaoAgendado</td>
          <td style='width: 200px;'>$tipoDocumentoAgendado</td>
          <td style='width: 50%;'>$nomeArquivoAgendado</td>
          <td style='font-size:7pt;width: 15%;'>$incluidoPor</td>
        </tr>";
      }
    }
    break;

  case 'feriado_cadastrado':
    # --- atualizar suspensão de agendas do feriado --- #
    $stmFeriadoAtivar   = $rsConexao->prepare("SELECT data_inicioferiado, data_fimferiado FROM reg_tb_feriados WHERE id_feriado='$idRegistroExclusao'");
    $stmFeriadoAtivar->execute();
    $rsFeriadoAtivar    = $stmFeriadoAtivar->fetch(PDO::FETCH_OBJ);
    $dataAtivarInicial  = $rsFeriadoAtivar->data_inicioferiado;
    $dataAtivarFinal    = $rsFeriadoAtivar->data_fimferiado;
    $sqlAtivaAgenda = "UPDATE reg_tb_agenda_sub SET
      status_agenda='A'
      WHERE (concat(reg_tb_agenda_sub.ano_agenda,'-',lpad(reg_tb_agenda_sub.mes_agenda,2,'0'),'-',lpad(reg_tb_agenda_sub.dia_agenda,2,'0')) BETWEEN '$dataAtivarInicial' AND '$dataAtivarFinal')";
    $stmAtivaAgenda = $rsConexao->prepare($sqlAtivaAgenda);
    $stmAtivaAgenda->execute();
    # -------------------------------------------------- #  

    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_feriados WHERE id_feriado='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_feriados AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    /* carregar lista atualizada */
    $sqlFeriado  = "SELECT *, id_feriado, date_format(data_inicioferiado,'%d/%m/%Y') as dataInicial, date_format(data_fimferiado,'%d/%m/%Y') as dataFinal, date_format(data_fimferiado,'%Y-%m-%d') as dataFimValidacao, descricao_feriado FROM reg_tb_feriados ORDER BY data_fimferiado DESC";
    $stmFeriado  = $rsConexao->prepare($sqlFeriado);
    $stmFeriado->execute();
    if ($stmFeriado->rowCount() > 0) {
      $rsFeriado  = $stmFeriado->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsFeriado as $fieldFeriado) {
        $idFeriado          = $fieldFeriado['id_feriado'];
        $dataInicial        = $fieldFeriado['dataInicial'];
        $dataFinal          = $fieldFeriado['dataFinal'];
        $dataInicioFeriado  = $fieldFeriado['data_inicioferiado'];
        $dataFinalFeriado    = $fieldFeriado['data_fimferiado'];
        $descricaoFeriado    = mb_strtoupper($fieldFeriado['descricao_feriado']);

        $esconderComando      = $fieldFeriado['dataFimValidacao'] < date("Y-m-d") ? "style='display:none'" : "";
        $corFundoDatafinal    = $fieldFeriado['dataFimValidacao'] < date("Y-m-d") ? "style='background-color: #e2aaaa !important; color: #700000'" : "";

        $linkEditarFeriado  = '"editarFeriado(' . "'$idFeriado##$dataInicioFeriado##$dataFinalFeriado##$descricaoFeriado')" . '"';
        $linkExcluirFeriado  = '"excluirFeriado(' . "'$idFeriado')" . '"';
        echo "<tr>
          <td style='text-align:center'>
            <i class='icofont icofont-edit nova_fonte' title='Editar registro de feriado.' $esconderComando onclick=$linkEditarFeriado></i>&nbsp;
            <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de feriado.' $esconderComando onclick=$linkExcluirFeriado></i>
          </td>
          <td align='center'>$dataInicial</td>
          <td align='center' $corFundoDatafinal>$dataFinal</td>
          <td>$descricaoFeriado</td>
        </tr>";
      }
    };
    break;

  case 'afastamento-profissional':
    $htmlRetorno = "";
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_afastamento_profissional WHERE id_afastamento_profissional='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_afastamento_profissional AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    # -- ATUALIZAR AFASTAMENTO DO PROFISSIONAL NA AGENDA -- #
    $sqlAtualizaAgenda = "UPDATE reg_tb_agenda_sub 
    INNER JOIN reg_tb_agenda ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda) 
    SET reg_tb_agenda_sub.profissional_afastado='N', reg_tb_agenda_sub.id_afastamento=null
    WHERE (reg_tb_agenda_sub.id_afastamento='$idRegistroExclusao')";
    $stmAtualizaAgenda  = $rsConexao->prepare($sqlAtualizaAgenda);
    $stmAtualizaAgenda->execute();
    $stmAtualizaAgenda->closeCursor();

    $idUnidade      = $_POST['idUnidade'];
    $idProfissional = $_POST['idProfissional'];
    # --  carregar lista atualizada -- #
    $sqlAfastamento  = "SELECT reg_tb_afastamento_profissional.id_afastamento_profissional,
    tb_profissional.codigoprofissional_cnes,
    tb_profissional.nome_profissional,      
    tb_estabelecimento.codigoestabelecimento_cnes,
    tb_estabelecimento.nfantasia_estabelecimento,
    reg_tb_procedimento_grupo.nome_grupo_procedimento,
    reg_tb_procedimento.nome_procedimento,
    reg_tb_afastamento_profissional.id_grupo_procedimento,
    reg_tb_afastamento_profissional.id_procedimento,
    reg_tb_afastamento_profissional.datainicio_afastamento,
    reg_tb_afastamento_profissional.datafim_afastamento,      
    date_format(reg_tb_afastamento_profissional.datainicio_afastamento,'%d/%m/%Y') as dataInicioAfastamento,
    date_format(reg_tb_afastamento_profissional.datafim_afastamento,'%d/%m/%Y') as dataFimAfastamento,
    date_format(reg_tb_afastamento_profissional.datafim_afastamento,'%Y-%m-%d') as dataFimValidacao,
    date_format(reg_tb_afastamento_profissional.datahora_cadastro,'%d/%m/%Y %H:%i') as dataRegistro,
    date_format(reg_tb_afastamento_profissional.horainicio_afastamento,'%H:%i') AS horaInicioAfastamento,
    date_format(reg_tb_afastamento_profissional.horafim_afastamento,'%H:%i') AS horaFimAfastamento,
    reg_tb_afastamento_profissional.motivo_afastamento
    FROM reg_tb_afastamento_profissional
    INNER JOIN tb_estabelecimento ON (reg_tb_afastamento_profissional.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
    INNER JOIN tb_profissional ON (reg_tb_afastamento_profissional.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
    LEFT OUTER JOIN reg_tb_procedimento_grupo ON (reg_tb_afastamento_profissional.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_afastamento_profissional.id_procedimento = reg_tb_procedimento.id_procedimento)
    WHERE (tb_estabelecimento.codigoestabelecimento_cnes='$idUnidade') AND (tb_profissional.codigoprofissional_cnes='$idProfissional')
    ORDER BY reg_tb_afastamento_profissional.datafim_afastamento DESC";

    $stmAfastamento  = $rsConexao->prepare($sqlAfastamento);
    $stmAfastamento->execute();
    if ($stmAfastamento->rowCount() > 0) {
      $rsAfastamento  = $stmAfastamento->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAfastamento as $fieldAfastamento) {
        $idAfastamento        = $fieldAfastamento['id_afastamento_profissional'];
        $idProfissionalEditar = mb_strtoupper($fieldAfastamento['codigoprofissional_cnes']);
        $nomeProfissional     = mb_strtoupper($fieldAfastamento['nome_profissional']);
        $idUnidadeEditar      = mb_strtoupper($fieldAfastamento['codigoestabelecimento_cnes']);
        $nomeUnidade          = mb_strtoupper($fieldAfastamento['nfantasia_estabelecimento']);
        $esconderComando      = $fieldAfastamento['dataFimValidacao'] < date("Y-m-d") ? "style='display:none'" : "";
        $corFundoDatafinal    = $fieldAfastamento['dataFimValidacao'] < date("Y-m-d") ? "style='background-color: #e2aaaa !important; color: #700000'" : "";
        $nomeProcedimentoGrupo  = $fieldAfastamento['nome_procedimento'] != "" ? mb_strtoupper($fieldAfastamento['nome_procedimento']) : mb_strtoupper($fieldAfastamento['nome_grupo_procedimento']);
        $idProcedimentoGrupoEditar  = $fieldAfastamento['id_procedimento'] != "" ? "PROCEDIMENTO##" . $fieldAfastamento['id_procedimento'] : "GRUPO##" . $fieldAfastamento['id_grupo_procedimento'];
        $dataInicioEditar = $fieldAfastamento['datainicio_afastamento'];
        $dataFimEditar    = $fieldAfastamento['datafim_afastamento'];
        $dataInicioAfastamento  = $fieldAfastamento['dataInicioAfastamento'];
        $motivoAfastamento      = mb_strtoupper($fieldAfastamento['motivo_afastamento']);
        $dataFimAfastamento     = $fieldAfastamento['dataFimAfastamento'];
        $intervaloAfastamento   = "das " . $fieldAfastamento['horaInicioAfastamento'] . " às " . $fieldAfastamento['horaFimAfastamento'];
        $horaInicioAfastamento  = $fieldAfastamento['horaInicioAfastamento'];
        $horaFimAfastamento     = $fieldAfastamento['horaFimAfastamento'];
        $dataRegistro           = $fieldAfastamento['dataRegistro'];

        $linkEditarAfastamento  = '"editarAfastamento(' . "'$idAfastamento%%$idUnidadeEditar%%$idProfissionalEditar%%$idProcedimentoGrupoEditar%%$dataInicioEditar%%$dataFimEditar%%$horaInicioAfastamento%%$horaFimAfastamento%%$motivoAfastamento')" . '"';
        $linkExcluirAfastamento  = '"excluirAfastamento(' . "'$idAfastamento','$idUnidadeEditar','$idProfissionalEditar')" . '"';
        $htmlRetorno .= "<tr>
          <td style='text-align:center'>
            <i class='icofont icofont-edit nova_fonte' title='Editar registro de Afastamento.' $esconderComando onclick=$linkEditarAfastamento></i>&nbsp;
            <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de Afastamento.' $esconderComando  onclick=$linkExcluirAfastamento></i>
          </td>
          <td>$nomeProfissional</td>
          <td>$nomeUnidade</td>
          <td>$nomeProcedimentoGrupo</td>
          <td align='center'>$dataInicioAfastamento</td>
          <td align='center' $corFundoDatafinal>$dataFimAfastamento</td>
          <td align='center'>$intervaloAfastamento</td>
          <td>$motivoAfastamento</td>
          <td style='text-align:center'>$dataRegistro</td>
        </tr>";
      }
    }
    echo $htmlRetorno;
    break;

  case 'afastamento-unidade':
    $idUnidade  = $_POST['idUnidade'];
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_afastamento_unidade WHERE id_afastamento_unidade='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_afastamento_unidade AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    # -- ATUALIZAR AFASTAMENTO DO PROFISSIONAL NA AGENDA -- #

    $sqlAtualizaAgenda = "UPDATE reg_tb_agenda_sub 
      INNER JOIN reg_tb_agenda ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda) 
      SET reg_tb_agenda_sub.unidade_afastada = 'N' 
      WHERE (reg_tb_agenda_sub.id_afastamento_unidade='$idRegistroExclusao')";
    $stmAtualizaAgenda  = $rsConexao->prepare($sqlAtualizaAgenda);
    $stmAtualizaAgenda->execute();
    $stmAtualizaAgenda->closeCursor();

    $sqlAfastramento  = "SELECT reg_tb_afastamento_unidade.id_afastamento_unidade,
    tb_estabelecimento.codigoestabelecimento_cnes,
    ucase(tb_estabelecimento.nfantasia_estabelecimento) AS nomeUnidade,
    date_format(reg_tb_afastamento_unidade.datainicio_afastamento,'%d/%m/%Y') AS inicioAfastramento,
    date_format(reg_tb_afastamento_unidade.datafim_afastamento,'%d/%m/%Y') AS fimAfastramento,
    reg_tb_afastamento_unidade.datainicio_afastamento,
    date_format(reg_tb_afastamento_unidade.datafim_afastamento,'%Y-%m-%d') as dataFimValidacao,
    reg_tb_afastamento_unidade.datafim_afastamento,
    ucase(reg_tb_afastamento_unidade.motivo_afastamento) AS motivoAfastamento,
    date_format(reg_tb_afastamento_unidade.horainicio_afastamento,'%H:%i') AS horaInicioAfastamento,
     date_format(reg_tb_afastamento_unidade.horafim_afastamento,'%H:%i') AS horaFimAfastamento,    
    date_format(reg_tb_afastamento_unidade.datahora_cadastro,'%d/%m/%Y') AS dataHoraCadastro
    FROM reg_tb_afastamento_unidade
    INNER JOIN tb_estabelecimento ON (reg_tb_afastamento_unidade.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
    WHERE tb_estabelecimento.codigoestabelecimento_cnes='$idUnidade'";
    $stmAfastramento  = $rsConexao->prepare($sqlAfastramento);
    $stmAfastramento->execute();
    if ($stmAfastramento->rowCount() > 0) {
      $rsAfastramento = $stmAfastramento->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAfastramento as $fieldAfastamento) {
        $idAfastamento      = $fieldAfastamento['id_afastamento_unidade'];
        $nomeUnidade        = $fieldAfastamento['nomeUnidade'];
        $inicioAfastramento = $fieldAfastamento['inicioAfastramento'];
        $fimAfastramento    = $fieldAfastamento['fimAfastramento'];
        $motivoAfastamento  = $fieldAfastamento['motivoAfastamento'];
        $dataHoraCadastro   = $fieldAfastamento['dataHoraCadastro'];
        $idUnidadeEditar    = $fieldAfastamento['codigoestabelecimento_cnes'];
        $dataInicioEditar   = $fieldAfastamento['datainicio_afastamento'];
        $dataFimEditar      = $fieldAfastamento['datafim_afastamento'];
        $intervaloAfastamento   = "das " . $fieldAfastamento['horaInicioAfastamento'] . " às " . $fieldAfastamento['horaFimAfastamento'];
        $horaInicioAfastamento  = $fieldAfastamento['horaInicioAfastamento'];
        $horaFimAfastamento     = $fieldAfastamento['horaFimAfastamento'];

        $esconderComando      = $fieldAfastamento['dataFimValidacao'] < date("Y-m-d") ? "style='display:none'" : "";
        $corFundoDatafinal    = $fieldAfastamento['dataFimValidacao'] < date("Y-m-d") ? "style='background-color: #e2aaaa !important; color: #700000'" : "";

        $linkEditarAfastamento  = '"editarAfastamento(' . "'$idAfastamento%%$dataInicioEditar%%$dataFimEditar%%$horaInicioAfastamento%%$horaFimAfastamento%%$motivoAfastamento')" . '"';
        $linkExcluirAfastamento  = '"excluirAfastamento(' . "'$idAfastamento','$idUnidadeEditar')" . '"';

        echo "<tr>
          <td align='center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar registro de Afastamento.' $esconderComando onclick=$linkEditarAfastamento></i>&nbsp;
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de Afastamento.' $esconderComando  onclick=$linkExcluirAfastamento></i>
          </td>
          <td align='center'>$inicioAfastramento</td>
          <td align='center'>$fimAfastramento</td>
          <td align='center'>$intervaloAfastamento</td>
          <td>$motivoAfastamento</td>
          <td align='center'>$dataHoraCadastro</td>
        </tr>";
      }
    }
    break;
  case 'parametro-profissional':
    $formataSexo = array(
      "A" => "AMBOS",
      "M" => "MASCULINO",
      "F" => "FEMININO"
    );
    $idUnidade  = $_POST['idUnidade'];
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_parametro_profissional WHERE id_parametro_profissional='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_parametro_profissional AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    # --  carregar lista atualizada -- #
    $sqlParametro = "SELECT reg_tb_parametro_profissional.id_parametro_profissional,
      tb_profissional.nome_profissional,
      tb_profissional.codigoprofissional_cnes,
      reg_tb_parametro_profissional.sexo_permitido,
      reg_tb_parametro_profissional.idade_minima,
      reg_tb_parametro_profissional.idade_maxima
      FROM reg_tb_parametro_profissional
      INNER JOIN tb_profissional ON (reg_tb_parametro_profissional.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
      WHERE (reg_tb_parametro_profissional.codigoestabelecimento_cnes='$idUnidade')
      ORDER BY tb_profissional.nome_profissional";
    $stmParametro = $rsConexao->prepare($sqlParametro);
    $stmParametro->execute();
    if ($stmParametro->rowCount() > 0) {
      $rsParametro  = $stmParametro->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsParametro as $fieldParametro) {
        $idParametro          = $fieldParametro['id_parametro_profissional'];
        $idProfissional       = $fieldParametro['codigoprofissional_cnes'];
        $nomeProfissional     = mb_strtoupper($fieldParametro['nome_profissional']);
        $sexoPermitidoExibir  = $formataSexo[$fieldParametro['sexo_permitido']];
        $sexoPermitido        = $fieldParametro['sexo_permitido'];
        $idadeMinima          = $fieldParametro['idade_minima'];
        $idadeMaxima          = $fieldParametro['idade_maxima'];

        $linkEditarParametro  = '"editarParametro(' . "'$idParametro#$idProfissional#$sexoPermitido#$idadeMinima#$idadeMaxima')" . '"';
        $linkExcluirParametro = '"excluirParametro(' . "'$idParametro','$idUnidade')" . '"';

        echo "<tr>
            <td align='center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar registro de parâmetro.' onclick=$linkEditarParametro></i>&nbsp;
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de parâmetro.' onclick=$linkExcluirParametro></i>
            </td>
            <td>$nomeProfissional</td>
            <td align='center'>$sexoPermitidoExibir</td>
            <td align='center'>$idadeMinima</td>
            <td align='center'>$idadeMaxima</td>
          </tr>";
      }
    }
    break;

  case 'bloquear-usuario':
    $whereStatus  = $_POST['statusUsuario'] != "" ? " AND (reg_tb_usuario.ativo='" . $_POST['statusUsuario'] . "')" : "";
    $valorAtivacao  = $_POST['valorAtivacao'];
    $stmlRegistroExclusao = $rsConexao->prepare("UPDATE reg_tb_usuario SET ativo='$valorAtivacao' WHERE id_usuario='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();

    # -- Carregar lista atualizada --#
    $sqlUsuario = "SELECT reg_tb_usuario.* FROM reg_tb_usuario WHERE (id_usuario!='119') $whereStatus ORDER BY nome_usuario ASC";
    $stmUsuario  = $rsConexao->prepare($sqlUsuario);
    $stmUsuario->execute();
    $totalRegistrosUsuario = $stmUsuario->rowCount();
    $rsUsuario      = $stmUsuario->fetchAll(PDO::FETCH_ASSOC);
    if ($totalRegistrosUsuario > 0) {

      foreach ($rsUsuario as $fieldUsuario) {
        $idUsuario          = $fieldUsuario['id_usuario'];
        $nomeUsuario        = mb_strtoupper($fieldUsuario['nome_usuario']);
        $emailUsuario        = $fieldUsuario['email_usuario'];
        $telefoneCelular    = $fieldUsuario['fonecelular'];
        $cpfUsuario          = $fieldUsuario['cpf_usuario'];
        $usuarioAtivo       = $fieldUsuario['ativo'];
        $eGestor             = $fieldUsuario['e_gestor'] == "S" ? "SIM" : "NÃO";
        $autorizaCNS        = $fieldUsuario['autoriza_cns'] == "S" ? "SIM" : "NÃO";
        $autorizaCNSEditar  = $fieldUsuario['autoriza_cns'];

        $conteudoEdicao     = $idUsuario . "#" . $nomeUsuario . "#" . $cpfUsuario . "#" . $emailUsuario . "#" . $telefoneCelular . "#" . $fieldUsuario['e_gestor'] . "#" . $autorizaCNSEditar;
        $linkEditarUsuario    = '"editarDados(' . "'cadastro_usuario','$conteudoEdicao')" . '"';
        $linkAlteraSenha      = '"gerarNovaSenha(' . "'nova_senha_aleatoria','$idUsuario','$nomeUsuario')" . '"';

        if ($usuarioAtivo == 0) {
          $corLinha = "style='background-color:#f3b5b5 !important; color: #700000'";
          $linkBloqueioUsuario  = '"bloquearDesbloquearUsuario(' . "'$idUsuario','1')" . '"';
          $botaoBloqueioUsuario  = "<i class='icofont icofont-tick-boxed nova_fonte_blue' title='Ativar usuário.'  onclick=$linkBloqueioUsuario></i>";
        } else {
          $corLinha  = "";
          $linkBloqueioUsuario  = '"bloquearDesbloquearUsuario(' . "'$idUsuario','0')" . '"';
          $botaoBloqueioUsuario  = "<i class='icofont icofont-not-allowed nova_fonte_delete' title='Bloquear usuário.'  onclick=$linkBloqueioUsuario></i>";
        }

        $linkPerfilAcesso  = '"window.open(' . "'usuario_perfilacesso_atribuir?idu=$idUsuario')" . '"';

        echo "<tr $corLinha>
			<td style='text-align:center'>																			
				<i class='icofont icofont-id-card nova_fonte' title='Atribuir perfil de acesso.'  onclick=$linkPerfilAcesso style='font-size:16pt; color:#006DB3'></i>
				<i class='ft-edit nova_fonte' title='Editar dados do usuário.'  onclick=$linkEditarUsuario></i>
				<i class='icofont icofont-key nova_fonte' style='color:#147500' title='Gerar uma nova senha.'  onclick=$linkAlteraSenha></i>
				$botaoBloqueioUsuario
			</td>
			<td>$nomeUsuario</td>
			<td style='text-align:center' class='cpf-inputmask'>$cpfUsuario</td>
			<td>$emailUsuario</td>
			<td style='text-align:center'>$telefoneCelular</td>
			<td style='text-align:center'>$eGestor</td>
			<td style='text-align:center'>$autorizaCNS</td>
		</tr>";
      }
    }
    break;

  case 'status-estabelecimento-saude':
    $statusEstabelecimento  = $_POST['statusEstabelecimento'] == "ativar" ? "A" : "I";
    $stmlRegistroExclusao   = $rsConexao->prepare("UPDATE tb_estabelecimento SET status_estabelecimento='$statusEstabelecimento' WHERE codigoestabelecimento_cnes='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();

    //******* carregar lista atualizada *******/    
    $stmEstabelecimentos  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE codigoestabelecimento_cnes!='9999999999999' ORDER BY nfantasia_estabelecimento");
    $stmEstabelecimentos->execute();
    $rsEstabelecimentos    = $stmEstabelecimentos->fetchAll(PDO::FETCH_ASSOC);
    foreach ($rsEstabelecimentos as $fieldEstabelecimentos) {
      $codigoEstabelecimento        = $fieldEstabelecimentos['codigoestabelecimento_cnes'];
      $nomeFantasiaEstabelecimento  = $fieldEstabelecimentos['nfantasia_estabelecimento'];
      $razaoSocialEstabelecimento    = $fieldEstabelecimentos['nempresarial_estabelecimento'];
      $cnesEstabelecimento          = $fieldEstabelecimentos['cnes_estabelecimento'];
      $telefoneEstabelecimento      = $fieldEstabelecimentos['telefone_estabelecimento'];
      $bairroEstabelecimento        = $fieldEstabelecimentos['bairro_estabelecimento'];
      $statusEstabelecimento        = $fieldEstabelecimentos['status_estabelecimento'];
      $styloRegistroDesativado      = $fieldEstabelecimentos['status_estabelecimento'] == "A" ? "" : "style='background-color: #ffadad;color: #860000;'";


      $linkEditarCadastro  = '"editarEstabelecimento(' . "'$codigoEstabelecimento')" . '"';
      if ($fieldEstabelecimentos['status_estabelecimento'] == "A") {
        $linkComandoBloqueio  = '"statusEstabelecimento(' . "'$codigoEstabelecimento','desativar')" . '"';
        $btnComandoBloqueio    = "<i class='icofont icofont-close-squared nova_fonte_delete' title='Desativar registro do estabelecimento.' onclick=$linkComandoBloqueio></i>";
      } else {
        $linkComandoBloqueio  = '"statusEstabelecimento(' . "'$codigoEstabelecimento','ativar')" . '"';
        $btnComandoBloqueio    = "<i class='icofont icofont-checked nova_fonte_blue' style='font-size:16pt' title='ativar registro do estabelecimento.' onclick=$linkComandoBloqueio></i>";
      }

      echo "<tr $styloRegistroDesativado>
        <td align='center'>
          <i class='icofont icofont-edit nova_fonte' title='Editar registro do estabelecimento.' onclick=$linkEditarCadastro></i>&nbsp;													
          $btnComandoBloqueio
        </td>
        <td>$nomeFantasiaEstabelecimento</td>
        <td>$razaoSocialEstabelecimento</td>
        <td align='center'>$cnesEstabelecimento</td>
        <td align='center'>$telefoneEstabelecimento</td>
        <td>$bairroEstabelecimento</td>
      </tr>";
    }
    break;

  case 'status-profissional-saude':
    $statusProfissional     = $_POST['statusProfissional'] == "ativar" ? "A" : "I";
    $codigoEstabelecimento  = $_POST['codigoEstabelecimento'];
    $stmlRegistroExclusao   = $rsConexao->prepare("UPDATE tb_profissional_vinculo SET status_vinculos_profissional='$statusProfissional' WHERE (codigoestabelecimento_cnes='$codigoEstabelecimento') AND (codigoprofissional_cnes='$idRegistroExclusao')");

    $stmlRegistroExclusao->execute();

    //******* carregar lista atualizada *******/    
    $sqlProfissinoal  = "SELECT 
    tb_profissional.codigoprofissional_cnes,
    tb_profissional.nome_profissional,
    tb_profissional.cpf_profissional,
    tb_profissional.cns_profissional,
    rl_cbo.nome_cbo,
    tb_profissional_vinculo.status_vinculos_profissional,
    tb_profissional_vinculo.codigoestabelecimento_cnes
    FROM tb_profissional_vinculo
    INNER JOIN tb_profissional ON (tb_profissional_vinculo.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
    INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
    WHERE tb_profissional_vinculo.codigoestabelecimento_cnes='$codigoEstabelecimento' ORDER BY nome_profissional";
    $stmProfissinoal  = $rsConexao->prepare($sqlProfissinoal);
    $stmProfissinoal->execute();

    if ($stmProfissinoal->rowCount() > 0) {
      $rsProfissinoal   = $stmProfissinoal->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsProfissinoal as $fiedProfissinoal) {
        $codigoEstabelecimento  = $fiedProfissinoal['codigoestabelecimento_cnes'];
        $idProfissinoal         = $fiedProfissinoal['codigoprofissional_cnes'];
        $nomeProfissinoal       = $fiedProfissinoal['nome_profissional'];
        $nomeCBO                = $fiedProfissinoal['nome_cbo'];
        $cpfProfissinoal        = $fiedProfissinoal['cpf_profissional'];
        $cnsProfissinoal        = $fiedProfissinoal['cns_profissional'];
        $styleRegistroDesativado  = $fiedProfissinoal['status_vinculos_profissional'] == "A" ? "" : "style='background-color: #ffadad;color: #860000;'";

        $linkEditarCadastro  = '"editarProfissional(' . "'$codigoEstabelecimento','$idProfissinoal')" . '"';
        if ($fiedProfissinoal['status_vinculos_profissional'] == "A") {
          $linkComandoBloqueio  = '"statusProfissional(' . "'$codigoEstabelecimento','$idProfissinoal','desativar')" . '"';
          $btnComandoBloqueio    = "<i class='icofont icofont-close-squared nova_fonte_delete' title='Desativar registro do profissional.' onclick=$linkComandoBloqueio></i>";
        } else {
          $linkComandoBloqueio  = '"statusProfissional(' . "'$codigoEstabelecimento','$idProfissinoal','ativar')" . '"';
          $btnComandoBloqueio    = "<i class='icofont icofont-checked nova_fonte_blue' style='font-size:16pt' title='Ativar registro do profissional.' onclick=$linkComandoBloqueio></i>";
        }
        echo "<tr $styleRegistroDesativado>
          <td align='center'>
            <i class='icofont icofont-edit nova_fonte' title='Editar registro do profissional.' onclick=$linkEditarCadastro></i>&nbsp;
            $btnComandoBloqueio
          </td>
          <td>$nomeProfissinoal</td>
          <td>$nomeCBO</td>
          <td align='center'>$cpfProfissinoal</td>
          <td align='center'>$cnsProfissinoal</td>
        </tr>";
      }
    }
    break;

  case "procedimento_cadastrado":
  case "teto-procedimento-unidadde":
    $htmlRetorno          = "";
    $unidadeSaude         = $_POST['unidadeSaude'];
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_tetounidade WHERE id_tetounidade='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_tetounidade AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    //******* carregar lista atualizada */  
    $sqlTetoUnidade = "SELECT reg_tb_tetounidade.id_tetounidade,
    reg_tb_procedimento_grupo.id_grupo_procedimento,
    reg_tb_procedimento_grupo.nome_grupo_procedimento,
    reg_tb_procedimento.id_procedimento,
    reg_tb_procedimento.nome_procedimento,
    reg_tb_procedimento.codigo_sus,
    format(reg_tb_procedimento.valor_vigente, 2, 'de_DE') AS valorVigente,
    ucase(reg_tb_tetounidade.tipo_apuracao) AS tipoApuracao,
    reg_tb_tetounidade.quantidade_programada,
    format(reg_tb_tetounidade.valor_programado, 2, 'de_DE') AS valorProgramado
    FROM reg_tb_tetounidade
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_tetounidade.id_procedimento = reg_tb_procedimento.id_procedimento)
    LEFT OUTER JOIN reg_tb_procedimento_grupo ON (reg_tb_tetounidade.id_grupo_procedimento=reg_tb_procedimento_grupo.id_grupo_procedimento)
    WHERE codigoestabelecimento_cnes='$unidadeSaude' ORDER BY nome_procedimento, nome_grupo_procedimento";

    $stmTetoUnidade = $rsConexao->prepare($sqlTetoUnidade);
    $stmTetoUnidade->execute();

    if ($stmTetoUnidade->rowCount() > 0) {
      $rsTetoUnidade  = $stmTetoUnidade->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsTetoUnidade as $fieldTetoUnidade) {
        $idTetoUnidade          = $fieldTetoUnidade['id_tetounidade'];
        $nomeProcedimentoGrupo  = $fieldTetoUnidade['nome_procedimento'] != "" ? $fieldTetoUnidade['nome_procedimento'] : "GRUPO - " . $fieldTetoUnidade['nome_grupo_procedimento'];
        $codigoProcedimento     = $fieldTetoUnidade['codigo_sus'] != "" ? $fieldTetoUnidade['codigo_sus'] : "GRUPO";
        $tipoApuracao           = $fieldTetoUnidade['tipoApuracao'] == "FISICO"  ? "FÍSICO" : "FINANCEIRO";
        $tipoApuracaoEditar     = mb_strtolower($fieldTetoUnidade['tipoApuracao']);
        $quantidadeValor        = ($fieldTetoUnidade['quantidade_programada'] != '0' || $fieldTetoUnidade['quantidade_programada'] != "") ? $fieldTetoUnidade['quantidade_programada'] : $fieldTetoUnidade['valorProgramado'];
        $idGrupoProcedimento    = $fieldTetoUnidade['id_grupo_procedimento'];
        $idProcedimento         = $fieldTetoUnidade['id_procedimento'];
        $valorVigente           = $fieldTetoUnidade['valorVigente'];
        $alinhaQuantidadeValor  = $tipoApuracao == "FÍSICO" ? "center" : "right";

        $linkEditarTeto   = '"editarTeto(' . "'$idTetoUnidade--$idGrupoProcedimento--$valorVigente##$idProcedimento--$tipoApuracaoEditar--$quantidadeValor')" . '"';
        $linkExcluirTeto  = '"excluirTeto(' . "'$idTetoUnidade')" . '"';

        if ($codigoProcedimento == "GRUPO") {
          $linkSelProcedimentosGrupo  = '"selecionarProcedimentosTeto(' . "'$idTetoUnidade')" . '"';
          $iconeCmdSelProcedimento    = "<i class='icofont icofont-prescription nova_fonte_blue' title='Atribuir procedimentos ao grupo.'  onclick=$linkSelProcedimentosGrupo></i>";
        } else {
          $iconeCmdSelProcedimento    = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        $htmlRetorno .= "<tr>
        <td align='center'>
          $iconeCmdSelProcedimento
          <i class='icofont icofont-edit nova_fonte' title='Editar registro de teto.'  onclick=$linkEditarTeto></i>&nbsp;
          <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de teto.'  onclick=$linkExcluirTeto></i>&nbsp;
        </td>
        <td>$nomeProcedimentoGrupo</td>
        <td align='center'>$codigoProcedimento</td>
        <td>$tipoApuracao</td>
        <td align='$alinhaQuantidadeValor'>$quantidadeValor</td>
      </tr>";
      }
    } else {
      $htmlRetorno = "";
    }
    echo $htmlRetorno;
    //**************************************************** */    
    break;


  case 'perfil-acesso':

    $htmlRetorno  = "";
    $idUsuario    = $_POST['idUsuario'];
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_usuario_perfil WHERE id_usuarioperfil='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_usuario_perfil AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    /* carregar lista atualizada */
    $sqlPerfilAcesso = "SELECT reg_tb_usuario_perfil.id_usuarioperfil,
    reg_rl_usuario_perfil.id_usuario_perfil,
    reg_rl_usuario_perfil.descricao_usuario_perfil,
    tb_estabelecimento.codigoestabelecimento_cnes,
    tb_estabelecimento.nfantasia_estabelecimento,
    tb_estabelecimento.cnes_estabelecimento,
    reg_tb_usuario_perfil.ibge_municipioacesso,
    reg_tb_usuario_perfil.visualiza_vagasdisponiveis,
    CASE
      WHEN (reg_tb_usuario_perfil.agenda_visivel='' OR reg_tb_usuario_perfil.agenda_visivel IS NULL) THEN 'N/A'
      WHEN (reg_tb_usuario_perfil.agenda_visivel='G') THEN 'GERAL'
      WHEN (reg_tb_usuario_perfil.agenda_visivel='L') THEN 'LOCAL'
    END AS agendaVisivel,
    reg_tb_usuario_perfil.agenda_visivel,
    tb_cidades.nome_cidade
    FROM reg_tb_usuario_perfil
    INNER JOIN reg_rl_usuario_perfil ON (reg_tb_usuario_perfil.id_pefilusuario = reg_rl_usuario_perfil.id_usuario_perfil)
    INNER JOIN tb_cidades ON (reg_tb_usuario_perfil.ibge_municipioacesso = tb_cidades.codigoibge_cidade)
    INNER JOIN reg_tb_usuario ON (reg_tb_usuario_perfil.id_usuario = reg_tb_usuario.id_usuario)
    INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_usuario_perfil.id_unidadeassociada)
    WHERE reg_tb_usuario.id_usuario='$idUsuario'";
    $stmPerfilAcesso  = $rsConexao->prepare($sqlPerfilAcesso);
    $stmPerfilAcesso->execute();

    if ($stmPerfilAcesso->rowCount() > 0) {
      $rsPerfilAcesso  = $stmPerfilAcesso->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsPerfilAcesso as $fieldPerfilAcesso) {
        $idPerfilAcesso    = $fieldPerfilAcesso['id_usuario_perfil'];
        $idUsuarioPerfil  = $fieldPerfilAcesso['id_usuarioperfil'];
        $nomePerfilAcesso  = mb_strtoupper($fieldPerfilAcesso['descricao_usuario_perfil']);
        $nomeUnidadeSaude  = mb_strtoupper($fieldPerfilAcesso['nfantasia_estabelecimento']);
        $cnesUnidadeSaude  = $fieldPerfilAcesso['cnes_estabelecimento'];
        $idUnidade        = $fieldPerfilAcesso['codigoestabelecimento_cnes'];
        $codigoCidade      = $fieldPerfilAcesso['ibge_municipioacesso'];
        $nomeCidade        = $fieldPerfilAcesso['nome_cidade'];
        $vagaDisponivel    = $fieldPerfilAcesso['visualiza_vagasdisponiveis'];
        $verVagaDisponivel  = ($idPerfilAcesso != 4 && $idPerfilAcesso != 17 && $idPerfilAcesso != 19) ? "N/A" : ($fieldPerfilAcesso['visualiza_vagasdisponiveis'] == "S" ? "SIM" : "NÃO");
        $agendaVisivel   = $fieldPerfilAcesso['agendaVisivel'];
        $agendaVisivelEdit  = $fieldPerfilAcesso['agenda_visivel'];

        $linkEditarPerfil   = '"editarPerfil(' . "'$idUsuarioPerfil','$codigoCidade','$idUnidade','$idPerfilAcesso','$vagaDisponivel','$agendaVisivelEdit')" . '"';
        $linkExcluirPerfil  = '"excluirPerfil(' . "'$idUsuarioPerfil')" . '"';

        echo "<tr>
            <td align='center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar dados do perfil de acesso.' onclick=$linkEditarPerfil></i>&nbsp;
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir perfil de acesso.' onclick=$linkExcluirPerfil></i>
            </td>
            <td>$nomeCidade</td>
            <td>$cnesUnidadeSaude - $nomeUnidadeSaude</td>
            <td>$nomePerfilAcesso</td>
            <td align='center'>$verVagaDisponivel</td>
            <td align='center'>$agendaVisivel</td>
          </tr>";
      }
    }
    echo $htmlRetorno;
    break;

  case "excluir-agenda":

    $stmTemAgendamento  = $rsConexao->prepare("SELECT id_agendamento FROM reg_tb_agendamentos WHERE id_agenda='$idRegistroExclusao'");
    $stmTemAgendamento->execute();
    if ($stmTemAgendamento->rowCount() > 0) {
      echo "ExisteAgendamento";
      exit;
    }
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_agenda WHERE id_agenda='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_agenda AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();
    $stmlAltoIncremento->closeCursor();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_agenda_sub AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();
    break;

  case "vinculo-profissional":

    $codigoCBO        = $_POST['codigoCBO'];
    $unidadeVinculada = $_POST['unidadeVinculada'];
    $valorRegistro    = $_POST['valorRegistro'];

    $sqlDadosVinculo  = "UPDATE tb_profissional_vinculo SET 
    status_vinculos_profissional='$valorRegistro'
    WHERE (codigoestabelecimento_cnes='$unidadeVinculada')
    AND (codigoprofissional_cnes='$idRegistroExclusao')
    AND (codigo_cbo='$codigoCBO')";
    $stmDadosVinculo  = $rsConexao->prepare($sqlDadosVinculo);
    $stmDadosVinculo->execute();
    # carregar lista atualizada
    $sqlVinculo = "SELECT rl_cbo.codigo_cbo,
    rl_cbo.nome_cbo,
    tb_profissional_vinculo.codigoestabelecimento_cnes,
    tb_estabelecimento.nfantasia_estabelecimento,
    tb_profissional_vinculo.registro_conselho,
    tb_profissional_vinculo.status_vinculos_profissional
    FROM tb_profissional_vinculo
    INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
    INNER JOIN tb_estabelecimento
    ON (tb_profissional_vinculo.codigoestabelecimento_cnes =
    tb_estabelecimento.codigoestabelecimento_cnes) 
    WHERE (tb_profissional_vinculo.codigoprofissional_cnes='$idRegistroExclusao')";
    $stmVinculo  = $rsConexao->prepare($sqlVinculo);
    $stmVinculo->execute();
    if ($stmVinculo->rowCount() > 0) {

      $rsVinculo  = $stmVinculo->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsVinculo as $fieldVinculo) {
        $codigoCBO          = $fieldVinculo['codigo_cbo'];
        $nomeCBO            = mb_strtoupper($fieldVinculo['nome_cbo']);
        $codigoUnidade      = mb_strtoupper($fieldVinculo['codigoestabelecimento_cnes']);
        $nomeUnidade        = mb_strtoupper($fieldVinculo['nfantasia_estabelecimento']);
        $registroConselho    = mb_strtoupper($fieldVinculo['registro_conselho']);
        $statusVinculo      = $fieldVinculo['status_vinculos_profissional'];
        $linkEditarVinculo  = '"editarVinculo(' . "'$codigoCBO','$nomeCBO','$codigoUnidade',$registroConselho)" . '"';

        if ($statusVinculo == "I") {
          $corLinha = "style='background-color:#f3b5b5 !important; color: #700000'";
          $linkAcaoVinculo  = '"ativarDesativarVinculo(' . "'ativar','$codigoCBO','$codigoUnidade')" . '"';
          $iconeComando      = "icofont icofont-tick-boxed nova_fonte_blue";
        } else {
          $corLinha = "style=";
          $linkAcaoVinculo  = '"ativarDesativarVinculo(' . "'desativar','$codigoCBO','$codigoUnidade')" . '"';
          $iconeComando      = "icofont icofont-ui-block nova_fonte_delete";
        }
        echo "<tr $corLinha>
            <td align='center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar dados do vínculo do profissional.' onclick=$linkEditarVinculo></i>&nbsp;
              <i class='$iconeComando' title='desativar vínculo do profissional.' onclick=$linkAcaoVinculo></i>
            </td>
            <td>$codigoCBO - $nomeCBO</td>
            <td>$nomeUnidade</td>
            <td align='center'>$registroConselho</td>
          </tr>";
      }
    }
    break;

  case "setor-estabelecimento":
    $idEstabelecimento  = $_POST['idEstabelecimento'];
    $statusSetor        = $_POST['statusSetor'];
    $stmStatus  = $rsConexao->prepare("UPDATE reg_tb_setoratendimento SET status_setor='$statusSetor' WHERE id_setoratendimento='$idRegistroExclusao'");
    $stmStatus->execute();

    $stmSetorEstabelecimento  = $rsConexao->prepare("SELECT * FROM reg_tb_setoratendimento WHERE codigo_estabelecimento='$idEstabelecimento'");
    $stmSetorEstabelecimento->execute();
    if ($stmSetorEstabelecimento->rowCount() > 0) {
      $rsSetorEstabelecimento  = $stmSetorEstabelecimento->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsSetorEstabelecimento as $fieldSetorEstabelecimento) {
        $idSetor        = $fieldSetorEstabelecimento['id_setoratendimento'];
        $nomeSertor      = mb_strtoupper($fieldSetorEstabelecimento['nome_setoratendimento']);
        $servicoSetor    = mb_strtoupper($fieldSetorEstabelecimento['servico_realizado']);
        $comoSeReferir  = $fieldSetorEstabelecimento['comochamar_setor'];
        $statusSetor    = $fieldSetorEstabelecimento['status_setor'] == "I" ? "style='background-color: #ffadad;color: #860000;'" : "";


        $linkEditarSetor  = '"editarSetor(' . "'$idSetor##$nomeSertor##$servicoSetor##$comoSeReferir')" . '"';

        if ($fieldSetorEstabelecimento['status_setor'] == "I") {
          $linkBloquearSetor  = '"bloqueioSetor(' . "'$idSetor','A')" . '"';
          $comandoBloqueio  = "<i class='icofont icofont-tick-boxed nova_fonte_blue' title='Bloquear setor.' onclick=$linkBloquearSetor></i>";
        } else {
          $linkBloquearSetor  = '"bloqueioSetor(' . "'$idSetor','I')" . '"';
          $comandoBloqueio  = "<i class='icofont icofont-not-allowed nova_fonte_delete' title='Bloquear setor.' onclick=$linkBloquearSetor></i>";
        }
        echo "<tr $statusSetor>
            <td align='center'>
              <i class='icofont icofont-edit nova_fonte' title='Editar dados do perfil de acesso.' onclick=$linkEditarSetor></i>&nbsp;
              $comandoBloqueio
            </td>
            <td>$nomeSertor</td>
            <td>$servicoSetor</td>
            <td align='center'>$comoSeReferir</td>
          </tr>";
      }
    }
    break;

  case "painel-chamada":
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_painelchamada WHERE id_painelchamada='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_painelchamada AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    # -- carregar listagem atualizada -- #
    $sqlListaPaineis = "SELECT reg_tb_painelchamada.id_painelchamada,
    reg_tb_painelchamada.codigoestabelecimento_cnes,
    reg_tb_painelchamada.nome_painel,
    tb_estabelecimento.nfantasia_estabelecimento
    FROM tb_estabelecimento
    INNER JOIN reg_tb_painelchamada ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_painelchamada.codigoestabelecimento_cnes)
    ORDER BY tb_estabelecimento.nfantasia_estabelecimento,reg_tb_painelchamada.nome_painel";
    $stmListaPaineis = $rsConexao->prepare($sqlListaPaineis);
    $stmListaPaineis->execute();

    if ($stmListaPaineis->rowCount()) {
      $rsListaPaineis  = $stmListaPaineis->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsListaPaineis as $fieldListaPaineis) {
        $idPainel       = $fieldListaPaineis['id_painelchamada'];
        $codigoUnidade  = mb_strtoupper($fieldListaPaineis['codigoestabelecimento_cnes']);
        $nomePainel     = mb_strtoupper($fieldListaPaineis['nome_painel']);
        $nomeUnidade     = mb_strtoupper($fieldListaPaineis['nfantasia_estabelecimento']);

        $linkEditarPainel    = '"editarPainel(' . "'$idPainel##$codigoUnidade##$nomePainel')" . '"';
        $linkExcluirPainel  = '"excluirPainel(' . "'$idPainel')" . '"';
        $associarSetores    = '"' . "$('#boxPainelSetores').modal()" . '"';

        echo "<tr>
      <td align='center'>
        <i class='icofont icofont-edit nova_fonte' title='Editar registro do painel.' onclick=$linkEditarPainel></i>&nbsp;
        <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro do painel.' onclick=$linkExcluirPainel></i>&nbsp;
        <i class='icofont icofont-share nova_fonte_blue' title='Associar setores de atendimento.' onclick=$associarSetores></i>
      </td>
      <td>$nomePainel</td>
      <td>$nomeUnidade</td>
    </tr>";
      }
    }
    break;

  case "painel-chamada-setor":

    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_painelchamada_setor WHERE id_painelchamada_setor='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_painelchamada_setor AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    # -- carregar listagem atualizada -- #
    $idPainelChamada = $_POST['idPainelChamada'];
    $idUnidadePainel = $_POST['idUnidadePainel'];

    $sqlSetoresPainel = "SELECT reg_tb_painelchamada_setor.id_painelchamada_setor,
     ucase(reg_tb_setoratendimento.nome_setoratendimento) AS nomeSetor,
     reg_tb_painelchamada_setor.id_painelchamada
     FROM reg_tb_setoratendimento
     INNER JOIN reg_tb_painelchamada_setor ON (reg_tb_setoratendimento.id_setoratendimento = reg_tb_painelchamada_setor.id_setoratendimento)
     WHERE reg_tb_painelchamada_setor.id_painelchamada='$idPainelChamada' AND reg_tb_painelchamada_setor.codigoestabelecimento_cnes='$idUnidadePainel'
     ORDER BY reg_tb_setoratendimento.nome_setoratendimento";
    $stmSetoresPainel  = $rsConexao->prepare($sqlSetoresPainel);
    $stmSetoresPainel->execute();
    $htmlRetornoListagem  = "";
    if ($stmSetoresPainel->rowCount() > 0) {
      $rsSetoresPainel  = $stmSetoresPainel->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsSetoresPainel as $fiedSetoresPainel) {
        $idSetorPainel    = $fiedSetoresPainel['id_painelchamada_setor'];
        $nomeSetor  = $fiedSetoresPainel['nomeSetor'];

        $linkExcluirSetorPainel  = '"excluirSetorPainel(' . "'$idSetorPainel')" . '"';

        echo "<tr>
          <td style='text-align:center; border:1px solid'>
            <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro do setor.' onclick=$linkExcluirSetorPainel></i>&nbsp;
          </td>
          <td style='border:1px solid'>$nomeSetor</td>
        </tr>";
      }
    } else {
      echo "<td colspan='2' style='text-align:center; border:1px solid'><b>Sem setor cadastrado...</b></td>";
    }
    break;

  case "excluir-unidade-referencia":
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_unidadereferencia WHERE id_unidadereferencia='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_unidadereferencia AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    $idUnidadeBase = $_POST['idUnidadeBase'];
    $sqlUnidadeReferencia = "SELECT reg_tb_unidadereferencia.id_unidadereferencia,
		  reg_tb_unidadereferencia.codigo_estabelecimento_referencia,
			tb_estabelecimento.nfantasia_estabelecimento,
			tb_estabelecimento.cnes_estabelecimento,
			concat(endereco_estabelecimento,', ',numeroend_estabelecimento,', ',bairro_estabelecimento,' -> MUNICÍPIO: ',nome_cidade) as enderecoUnidade
			FROM reg_tb_unidadereferencia
			INNER JOIN tb_estabelecimento ON (reg_tb_unidadereferencia.codigo_estabelecimento_referencia =tb_estabelecimento.codigoestabelecimento_cnes)
			INNER JOIN tb_cidades ON (tb_cidades.codigoibge_cidade = tb_estabelecimento.codigoibge_cidade)
			WHERE (reg_tb_unidadereferencia.codigo_estabelecimento_base = '$idUnidadeBase')";

    $stmUnidadeReferencia  = $rsConexao->prepare($sqlUnidadeReferencia);
    $stmUnidadeReferencia->execute();
    if ($stmUnidadeReferencia->rowCount() > 0) {
      $rsUnidadeReferencia  = $stmUnidadeReferencia->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsUnidadeReferencia as $fieldUnidadeReferencia) {
        $idUnidadeReferencia      = $fieldUnidadeReferencia['id_unidadereferencia'];
        $codigoUnidadeReferencia  = $fieldUnidadeReferencia['codigo_estabelecimento_referencia'];
        $nomeUnidadeReferencia    = mb_strtoupper($fieldUnidadeReferencia['nfantasia_estabelecimento']);
        $cnesUnidadeReferencia    = $fieldUnidadeReferencia['cnes_estabelecimento'];
        $enderecoUnidade          = mb_strtoupper($fieldUnidadeReferencia['enderecoUnidade']);
        $linkExcluirUnidade  = '"excluirUnidadeReferencia(' . "'$idUnidadeReferencia','$idUnidadeBase')" . '"';
        echo "<tr>
          <td align='center'>
            <i class='icofont icofont-close-squared nova_fonte_delete' title='Bloquear setor.' onclick=$linkExcluirUnidade></i>
          </td>
          <td>$nomeUnidadeReferencia</td>
          <td align='center'>$cnesUnidadeReferencia</td>
          <td>$enderecoUnidade</td>
        </tr>";
      }
    }
    break;

  case "cota-unidadde":
    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_cotas WHERE id_registrocota='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_cotas AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    $idUnidade = $_POST['idUnidade'];
    $sqlCotaCadastrada = "SELECT reg_tb_cotas.id_registrocota,
    reg_tb_procedimento.nome_procedimento,
    reg_tb_procedimento_grupo.nome_grupo_procedimento,
    ucase(tb_estabelecimento.nfantasia_estabelecimento) AS unidadeExecutante,
    format(reg_tb_cotas.cota_percentual, 1, 'de_DE') AS percentualCota,
    reg_tb_cotas.cota_quantidade,
    ucase(reg_tb_cotas.cota_tipoanalise) AS tipoAnalise
    FROM reg_tb_cotas
    INNER JOIN tb_estabelecimento ON (reg_tb_cotas.estabelecimento_executante = tb_estabelecimento.codigoestabelecimento_cnes)
    LEFT OUTER JOIN reg_tb_procedimento_grupo ON (reg_tb_cotas.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_cotas.id_procedimento = reg_tb_procedimento.id_procedimento)
    WHERE estabelecimento_solicitante='$idUnidade'";
    $stmCotaCadastrada  = $rsConexao->prepare($sqlCotaCadastrada);
    $stmCotaCadastrada->execute();
    if ($stmCotaCadastrada->rowCount() > 0) {
      $rsCotaCadastrada = $stmCotaCadastrada->fetchAll(PDO::FETCH_ASSOC);

      foreach ($rsCotaCadastrada as $fieldCota) {
        $idCota = $fieldCota['id_registrocota'];
        $grupoPorcedimento  = $fieldCota['nome_procedimento'] != "" ? $fieldCota['nome_procedimento'] : $fieldCota['nome_grupo_procedimento'];
        $unidadeExecutante  = $fieldCota['unidadeExecutante'];
        $percentualCota     = $fieldCota['percentualCota'];
        $quantidadeCota     = $fieldCota['cota_quantidade'];
        $tipoAnalise        = $fieldCota['tipoAnalise'];

        # -- editar cota --# 
        $linkEditarCota   = '"editarCota(' . "'$idCota')" . '"';
        # -- excluir cota --# 
        $linkExcluirCota  = '"excluirCota(' . "'$idCota','$idUnidade')" . '"';
        echo "<tr>
          <td align='center'>
            <i class='icofont icofont-edit nova_fonte' title='Editar registro de teto.'  onclick=$linkEditarCota></i>&nbsp;
            <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de cota.'  onclick=$linkExcluirCota></i>
          </td>
          <td>$grupoPorcedimento</td>
          <td>$unidadeExecutante</td>
          <td align='right'>$percentualCota</td>
          <td align='center'>$quantidadeCota</td>
          <td>$tipoAnalise</td>
        </tr>";
      }
    }
    break;

  case "procedimento-oci-associado":

    $stmlRegistroExclusao = $rsConexao->prepare("DELETE FROM reg_tb_procedimentos_oci WHERE id_automatico_chave='$idRegistroExclusao'");
    $stmlRegistroExclusao->execute();
    $stmlAltoIncremento   = $rsConexao->prepare("ALTER TABLE reg_tb_procedimentos_oci AUTO_INCREMENT=1");
    $stmlAltoIncremento->execute();

    $idProcedimentoOCI = $_POST['idProcedimentoOCI'];
    $sqlProcedimentoAssociado = "SELECT reg_tb_procedimentos_oci.id_automatico_chave,
    reg_tb_procedimento.codigo_sus,
    ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
    reg_tb_procedimentos_oci.procedimento_obrigatorio,
    reg_tb_procedimentos_oci.id_procedimento_associado
    FROM reg_tb_procedimento 
    INNER JOIN reg_tb_procedimentos_oci ON (reg_tb_procedimento.id_procedimento = reg_tb_procedimentos_oci.id_procedimento_associado)
    WHERE (id_procedimento_oci='$idProcedimentoOCI')
    ORDER BY reg_tb_procedimentos_oci.id_automatico_chave ASC";
    $stmProcedimentoAssociado = $rsConexao->prepare($sqlProcedimentoAssociado);
    $stmProcedimentoAssociado->execute();
    if ($stmProcedimentoAssociado->rowCount() > 0) {
      $rsProcedimentoAssociado  = $stmProcedimentoAssociado->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsProcedimentoAssociado as $fieldProcedimentoAssociado) {
        $idRegistroChave  = $fieldProcedimentoAssociado['id_automatico_chave'];
        $idProcedimentoAssociado = $fieldProcedimentoAssociado['id_procedimento_associado'];
        $codigoSUS        = $fieldProcedimentoAssociado['codigo_sus'];
        $nomeProcedimento = $fieldProcedimentoAssociado['nomeProcedimento'];
        $procedimentoObrigatorio = $fieldProcedimentoAssociado['procedimento_obrigatorio'] == "S" ? "SIM" : "NÃO";
        $eObrigatorio     = $fieldProcedimentoAssociado['procedimento_obrigatorio'];
        $linkExcluirItem  = '"excluirItemLista(' . "'$idRegistroChave')" . '"';
        $linkEditarProcedimento  = '"editarProcedimentoOCI(' . "'$idRegistroChave##$idProcedimentoAssociado##$nomeProcedimento##$eObrigatorio')" . '"';
        echo "<tr>
      <td style='text-align:center; font-size:9pt; width:8%'>
        <i class='icofont icofont-edit nova_fonte' title='Editar procedimento.' onclick=$linkEditarProcedimento></i>&nbsp;      
        <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir item da lista.' onclick=$linkExcluirItem></i>
      </td>
      <td style='text-align:center; font-size:9pt;width:8%'>$codigoSUS</td>
      <td style='font-size:9pt'>$nomeProcedimento</td>
      <td style='font-size:9pt; text-align:center;width:8%;'>$procedimentoObrigatorio</td>
    </tr>";
      }
    }
    break;
}
