<?php
session_start();
require("../../database/dbConection.php");

$usuarioLogado    = $_SESSION['idUsuarioLogado'];
$chaveConfirmacao = rand(10000000, 99999999);
$dataHoraRegistro = date('Y-m-d H:i');

$opcaoAgendamento = $_POST['opcaoAgendamento'];

switch ($opcaoAgendamento) {
  case "LAB-D":
    $idPaciente               = $_POST['idPaciente'];
    $idVaga                   = $_POST['idVaga'];
    $idVagaSub                = $_POST['idVagaSub'];
    $prazoRetirada            = $_POST['prazoRetirada'];
    $tipoVagaOcupada          = mb_strtoupper($_POST['tipoVagaOcupada']);
    $idGrupoProcedimento      = $_POST['idGrupoProcedimento'];
    # -- pegar dados da agenda para armazenar
    $sqlAgendaSub = "SELECT concat(reg_tb_agenda_sub.ano_agenda,'-',lpad(reg_tb_agenda_sub.mes_agenda, 2, '0'),'-',lpad(reg_tb_agenda_sub.dia_agenda, 2, '0'))AS dataAtendimento,
    reg_tb_agenda_sub.horario_inicioagenda,
    reg_tb_agenda_sub.id_grupo_procedimento,
    reg_tb_agenda_sub.id_procedimento,
    reg_tb_agenda_sub.quantidadegendada_pvez,
    reg_tb_agenda_sub.quantidadeagendada_retorno,
    reg_tb_agenda_sub.quantidadeagendada_reserva,
    reg_tb_agenda.codigoestabelecimento_cnes,
    reg_tb_agenda.codigoprofissional_cnes
    FROM reg_tb_agenda_sub
    INNER JOIN reg_tb_agenda ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
    WHERE reg_tb_agenda_sub.id_agenda_sub = '$idVagaSub'";
    $stmAgendaSub = $rsConexao->prepare($sqlAgendaSub);
    $stmAgendaSub->execute();
    $rsAgendaSub  = $stmAgendaSub->fetch(PDO::FETCH_OBJ);

    $dataAtendimento      = $rsAgendaSub->dataAtendimento;
    $horaAtendimento      = $rsAgendaSub->horario_inicioagenda;
    $estabelecimentoSaude = $rsAgendaSub->codigoestabelecimento_cnes;
    $profissionalSaude    = $rsAgendaSub->codigoprofissional_cnes;

    if ($tipoVagaOcupada == "PVEZ") {
      $calculaVagasOcupadas         = $rsAgendaSub->quantidadegendada_pvez;
      $variavelAtualizaVagaOcupada  = 'quantidadegendada_pvez';
    } else {
      $calculaVagasOcupadas         = $rsAgendaSub->quantidadeagendada_reserva;
      $variavelAtualizaVagaOcupada  = 'quantidadeagendada_reserva';
    }

    function getIPCliente()
    {
      $ipaddress = '';
      if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
      else if (getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
      else if (getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
      else if (getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
      else if (getenv('HTTP_FORWARDED'))
        $ipaddress = getenv('HTTP_FORWARDED');
      else if (getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
      else
        $ipaddress = 'UNKNOWN';

      return $ipaddress;
    }

    $ipUsuarioAgendou       = getIPCliente();
    $conexaoUsuarioAgendou  = gethostbyaddr(getIPCliente());

    # -- Verificar a existência de agendamento de laboratório pendente para o mesmo paciente -- #
    $sqlAgendamento = "SELECT id_agendamento 
      FROM reg_tb_agendamentos
      WHERE id_paciente='$idPaciente' 
      AND (id_grupo_procedimento='$idGrupoProcedimento')
      AND (status_agendamento='A' OR status_agendamento='E' OR status_agendamento='P')
      AND (timestampdiff(DAY,data_atendimento,curdate())<21)";
    $stmAgendamento = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento ->execute();
    if($stmAgendamento->rowCount()>0){
      echo "JáExiste";
      exit;
    }

    $sqlGravarAgendamento = "INSERT INTO reg_tb_agendamentos(
    origem_agendamento,
    id_paciente,
    id_agenda,
    id_agenda_sub,
    id_grupo_procedimento,
    data_atendimento,
    horario_atendimento,
    dataprazo_retirada,  
    tipo_vagaocupada,
    chave_confirmacao,
    encaminhado_ligacao,
    em_comunicacao,
    id_usuario_agendou,
    ip_usuario_agendou,
    conexao_usuario_agendou
    )VALUES(
      :setOrigemAgendamento,
      :setIdPaciente,
      :setIdAgenda,
      :setIdAgendaSub,
      :setIdGrupoProcedimento,
      :setDataAtendimento,
      :setHorarioAtendimento,
      :setDataPrazoRetirada,
      :setTipoVagaOcupada,
      :setChaveConfirmacao,
      :setEmLigacao,
      :setEmComunicacao,
      :setIdUsuarioAgendou,
      :setIPUsuarioAgendou,
      :setConexaoUsuarioAgendou
    )";

    $emLigacao            = "S";
    $emComunicacao        = "N";
    $stmGravarAgendamento = $rsConexao->prepare($sqlGravarAgendamento);
    $stmGravarAgendamento->bindParam(":setOrigemAgendamento", $opcaoAgendamento, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIdPaciente", $idPaciente, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIdAgenda", $idVaga, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIdAgendaSub", $idVagaSub, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIdGrupoProcedimento", $idGrupoProcedimento, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setDataAtendimento", $dataAtendimento, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setHorarioAtendimento", $horaAtendimento, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setDataPrazoRetirada", $prazoRetirada, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setTipoVagaOcupada", $tipoVagaOcupada, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setChaveConfirmacao", $chaveConfirmacao, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setEmLigacao", $emLigacao, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setEmComunicacao", $emComunicacao, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIdUsuarioAgendou", $usuarioLogado, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setIPUsuarioAgendou", $ipUsuarioAgendou, PDO::PARAM_STR);
    $stmGravarAgendamento->bindParam(":setConexaoUsuarioAgendou", $conexaoUsuarioAgendou, PDO::PARAM_STR);
    $stmGravarAgendamento->execute();
    $idAgendamento  = $rsConexao->lastInsertId();
    $_SESSION['idAgendamento']  = $idAgendamento;

    # -- atualizar número protocolo de agendamento -- #
    $protocoloAgendamento = date("Ym") . str_pad($idAgendamento, 4, "0", STR_PAD_LEFT);
    $stmAtualizaProtocolo = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET protocolo_agendamento='$protocoloAgendamento' WHERE id_agendamento='$idAgendamento'");
    $stmAtualizaProtocolo->execute();
    # ------------------------------------------------#
    $calculaSaldoVaga = $calculaVagasOcupadas + 1;
    $stmAtualizaVagaOcupada = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET $variavelAtualizaVagaOcupada='$calculaSaldoVaga' WHERE id_agenda_sub='$idVagaSub'");
    $stmAtualizaVagaOcupada->execute();
    # ----------------------------------- #

    # - anexar procedimentos de laboratório ao agendamento - #
    $procedimentoSelecionado  = $_POST['procedimentoSelecionado'];
    $contarProceimentos       =  count($procedimentoSelecionado);
    $calcularLoop       = 0;
    $idProcedimento     = "";

    for ($contaReg = 0; $contaReg < $contarProceimentos; $contaReg++){
      $idProcedimento = $procedimentoSelecionado[$contaReg];
      $stmGravarProcedimento = $rsConexao->prepare("INSERT INTO reg_tb_agendamentos_laboratorio(id_agendamento,id_procedimento_agendado)VALUES('$idAgendamento','$idProcedimento')");
      $stmGravarProcedimento ->execute();
    }
    
    $sqlAtualizaEntrega = "UPDATE reg_tb_agendamentos SET
    status_agendamento='E',
    marcacao_entregue='S',
    id_usuario_entregou='$usuarioLogado',
    datahora_entrega='$dataHoraRegistro',
    documento_portador='id do Usuario=$usuarioLogado',
    telefone_portador='id do Usuario=$usuarioLogado',
    observacoes_entrega='AGENDAMENTO DIRETO - ENTREGUE NA HORA'
    WHERE id_agendamento='$idAgendamento'";
    $stmAtualizaEntrega = $rsConexao->prepare($sqlAtualizaEntrega);
    $stmAtualizaEntrega->execute();
    $_SESSION['origemAgendamento'] = $opcaoAgendamento;
    break;

  case "alterar-procedimento-agendado":
    $idAgendaentoLaboratorio  = $_POST['idAgendaentoLaboratorio'];
    $idProcedimento           = $_POST['idProcedimento']!="" ? $_POST['idProcedimento'] : 'null';

    $sqlAtualizar = "UPDATE reg_tb_agendamentos_laboratorio
    SET id_procedimento_executado=$idProcedimento,
    id_usuarioregistrou_executado='$usuarioLogado',
    datahoraregistrou_executado='$dataHoraRegistro'
    WHERE id_agendamento_laboratorio='$idAgendaentoLaboratorio'";

    $stmAtualizar = $rsConexao->prepare($sqlAtualizar);
    $stmAtualizar ->execute();
    break;

}
