<?php
session_start();
require("../../database/dbConection.php");

$idUsuarioLogado  = $_SESSION['idUsuarioLogado'];
$idUnidadeLogada  = $_SESSION['unidadeLogada'];
$dataHoraHoje     = date("Y-m-d H:i:s");
$opcaoGravacao    = $_POST['opcaoGravacao'];

$idSolicitacaoMovimento = "";
$idStatusMovimento      = "";
$tipoMovimento          = "";
$gerarHistorico         = "S";

function getIPCliente() {
  $ipaddress = '';
  if (getenv('HTTP_CLIENT_IP'))
      $ipaddress = getenv('HTTP_CLIENT_IP');
  else if(getenv('HTTP_X_FORWARDED_FOR'))
      $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
  else if(getenv('HTTP_X_FORWARDED'))
      $ipaddress = getenv('HTTP_X_FORWARDED');
  else if(getenv('HTTP_FORWARDED_FOR'))
      $ipaddress = getenv('HTTP_FORWARDED_FOR');
  else if(getenv('HTTP_FORWARDED'))
     $ipaddress = getenv('HTTP_FORWARDED');
  else if(getenv('REMOTE_ADDR'))
      $ipaddress = getenv('REMOTE_ADDR');
  else
      $ipaddress = 'UNKNOWN';

  //$ipUsuario = file_get_contents('https://ipinfo.io/ip');
  return $ipaddress;
}

switch ($opcaoGravacao) {

  case 'solicitacao-registro':
    $idSolicitacao            = $_POST['idSolicitacao'];
    $idPaciente               = $_POST['idPaciente'];
    $grupoProcedimento        = $_POST['grupoProcedimento'];
    $nomeProcedimento         = $_POST['nomeProcedimento'];
    $idProcedimentoEditado    = $_POST['idProcedimentoEditado'];
    $observacaoSolicitacao    = $_POST['observacaoSolicitacao'];
    $tokenSolicitacao         = $_POST['tokenSolicitacao'];
    $cidSolicitacao           = mb_strtoupper($_POST['cidSolicitacao']);
    $profissionalSolicitante  = $_POST['profissionalSolicitante'];
    $retornoSolicitacao       = $_POST['retornoSolicitacao'];
    $classificacaoPrioridade  = $_POST['classificacaoPrioridade'];


    # -- atualizar condição de saúde do paciente -- #
    $pacienteOncologico   = $_POST['pacienteOncologico'];
    $pacienteDiabetico    = $_POST['pacienteDiabetico'];
    $pacienteHipertenso   = $_POST['pacienteHipertenso'];
    $pacienteRenalCronico = $_POST['pacienteRenalCronico'];
    $pacientePCD          = $_POST['pacientePCD'];
    $descricaoDeficiencia = $_POST['descricaoDeficiencia'];
    $pacienteAlergico     = $_POST['pacienteAlergico'];
    $descricaoAlergia     = $_POST['descricaoAlergia'];
    $sqlPaciente = "UPDATE tb_paciente SET
      condicaosaude_oncolocia='$pacienteOncologico',
      condicaosaude_diabetes='$pacienteDiabetico',
      condicaosaude_hipertensao='$pacienteHipertenso',
      condicaosaude_renalcronico='$pacienteRenalCronico',
      condicaosaude_pcd='$pacientePCD',
      condicaosaude_pcddescricao='$descricaoDeficiencia',
      condicaosaude_alergia='$pacienteAlergico',
      condicaosaude_alergiadescricao='$descricaoAlergia',
      usuarioregistrou_condicaodesaude='$idUsuarioLogado',
      datahoraregistrou_condicaodesaude='$dataHoraHoje'
    WHERE id_paciente='$idPaciente'";
    $stmPaciente = $rsConexao->prepare($sqlPaciente);
    $stmPaciente->execute();
    # -- --------------------------------------- -- #


    // validar informações para definir status da solicitação de serverá ser enviada pra análise //
    $stmConfiguracoes = $rsConexao->prepare("SELECT * FROM reg_tb_configuracoes");
    $stmConfiguracoes ->execute();
    $rsConfiguracoes  = $stmConfiguracoes->fetch(PDO::FETCH_OBJ);
    $enviarSolicitacaoParaAnalise = $rsConfiguracoes->solicitacao_paraanalise;

    if($enviarSolicitacaoParaAnalise=="nenhuma"){
      $setStatusAnaliseSolicitacao = "2";
    }else{
      if($enviarSolicitacaoParaAnalise=="emergência" && $classificacaoPrioridade=="1"){
        $setStatusAnaliseSolicitacao = "1";
      }else if($enviarSolicitacaoParaAnalise=="emergência-murgente" && ($classificacaoPrioridade=="1" || $classificacaoPrioridade=="2")){
        $setStatusAnaliseSolicitacao = "1";
      }else if($enviarSolicitacaoParaAnalise=="todas"){
        $setStatusAnaliseSolicitacao = "1";
      }else{
        $setStatusAnaliseSolicitacao = "2";
      }
    }
    $idStatusMovimento = $setStatusAnaliseSolicitacao;

    # ----- validar existência de solicitação pendente ----- #
    if ($idSolicitacao == "" || ($idProcedimentoEditado!="" && $idProcedimentoEditado!=$nomeProcedimento)) {
      $sqlExiste  = "SELECT COUNT(id_solicitacao) AS totalSolicitacoes FROM reg_tb_solicitacoes WHERE (id_statussolicitacao=1 OR id_statussolicitacao=2 OR 
      id_statussolicitacao=3 OR id_statussolicitacao=9 OR id_statussolicitacao=10) AND (id_procedimento='$nomeProcedimento' AND id_paciente='$idPaciente')";
      $stmExiste  = $rsConexao->prepare($sqlExiste);
      $stmExiste->execute();
      $rsExiste   = $stmExiste->fetch(PDO::FETCH_OBJ);
      if ($rsExiste->totalSolicitacoes > 0) {
        echo "JáExiste";
        exit;
      }
    }
    # ----- ----- ----- ----- ----- ----- ----- ----- ------ #
    
    # --- pegar último da fila para o procedimento --- #
    $stmUltimoFila = $rsConexao->prepare("SELECT MAX(posicao_fila) AS ultimoFila FROM reg_tb_solicitacoes WHERE id_statussolicitacao=2 AND id_procedimento='$nomeProcedimento'");
    $stmUltimoFila ->execute();
    $rsmUltimoFila = $stmUltimoFila->fetch(PDO::FETCH_OBJ);
    if($stmUltimoFila->rowCount()>0){
      $posicaoFila = $rsmUltimoFila->ultimoFila+1;
    }else{
      $posicaoFila = 1;
    }

    if ($idSolicitacao == "") {
      $tipoMovimento      = "INCLUSÃO";
      $sqlSolicitatao = "INSERT INTO reg_tb_solicitacoes(
        id_paciente,
        cid_solicitacao,
        codigoprofissional_cnes,
        solicitacao_retorno,
        id_grupo_procedimento,
        id_procedimento,
        observacoes_solicitacao,
        id_statussolicitacao,
        id_classificacaorisco,
        id_usuario_cadastrou,
        id_unidade_cadastrou,
        datahora_cadastro,
        posicao_fila,
        token_solicitacao
      )VALUES(
        :setIdPaciente,
        :setCidSolicitacao,
        :setProfissionalSolicitante,
        :setSolicitacaoRetorno,
        :setGrupoProcedimento,
        :setNomeProcedimento,
        :setObservacaoSolicitacao,
        :setStatusSolicitacao,
        :setClassificacaoRisco,
        :setUsuarioLogado,
        :setUnidadeLogada,
        :setDataHoraHoje,
        :setPosicaoFila,
        :setTokenSolicitacao
      )";
    } else {
      $tipoMovimento  = "ALTERAÇÃO";
      $sqlSolicitatao = "UPDATE reg_tb_solicitacoes SET
        id_paciente=:setIdPaciente,
        cid_solicitacao=:setCidSolicitacao,
        codigoprofissional_cnes=:setProfissionalSolicitante,
        solicitacao_retorno=:setSolicitacaoRetorno,
        id_grupo_procedimento=:setGrupoProcedimento,
        id_procedimento=:setNomeProcedimento,
        observacoes_solicitacao=:setObservacaoSolicitacao,
        id_statussolicitacao=:setStatusSolicitacao,
        id_classificacaorisco=:setClassificacaoRisco,
        id_usuario_alterou=:setUsuarioLogado,
        data_ultima_alteracao=:setDataHoraHoje,
        posicao_fila=:setPosicaoFila,
        token_solicitacao=:setTokenSolicitacao
        WHERE id_solicitacao='$idSolicitacao'
      ";
    }

    # -- apenas município de Candeias por 4 meses -- #
    /*$filaAntigaExiste = $rsConexao->prepare("SELECT TABLE_NAME FROM information_schema.tables WHERE TABLE_SCHEMA = 'gsaude_candeias' AND TABLE_NAME = 'reg_tb_solicitacoes_fv'");
    $filaAntigaExiste ->execute();
    if($filaAntigaExiste->rowCount()>0){
      
      $sqlDataFilaVelha = "SELECT reg_tb_solicitacoes_fv.datahora_cadastro
      FROM tb_paciente
      INNER JOIN reg_tb_solicitacoes_fv ON (tb_paciente.id_paciente = reg_tb_solicitacoes_fv.id_paciente)
      WHERE (tb_paciente.id_paciente='$idPaciente')
      AND (reg_tb_solicitacoes_fv.id_procedimento='$nomeProcedimento')
      AND (reg_tb_solicitacoes_fv.id_statussolicitacao='2')";
      $stmDataFilaVelha = $rsConexao->prepare($sqlDataFilaVelha);
      $stmDataFilaVelha ->execute();
      if($stmDataFilaVelha->rowCount()>0){
        $rsDataFilaVelha = $stmDataFilaVelha->fetch(PDO::FETCH_OBJ);
        $dataHoraHoje = $rsDataFilaVelha->datahora_cadastro;
      }else{
        $dataHoraHoje = $dataHoraHoje;
      }     
    }*/

    $stmSolicitatao = $rsConexao->prepare($sqlSolicitatao);
    $stmSolicitatao->bindParam(":setIdPaciente", $idPaciente, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setCidSolicitacao", $cidSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setProfissionalSolicitante", $profissionalSolicitante, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setSolicitacaoRetorno", $retornoSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setGrupoProcedimento", $grupoProcedimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setNomeProcedimento", $nomeProcedimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setObservacaoSolicitacao", $observacaoSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setClassificacaoRisco", $classificacaoPrioridade, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);    
    $stmSolicitatao->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setPosicaoFila", $posicaoFila, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setTokenSolicitacao", $tokenSolicitacao, PDO::PARAM_STR);
    if ($idSolicitacao == "") {
      $stmSolicitatao->bindParam(":setUnidadeLogada", $idUnidadeLogada, PDO::PARAM_STR);      
    }    
    $stmSolicitatao->execute();

    if ($idSolicitacao == "") {
      $ultimoIdSolicitacao  = $rsConexao->lastInsertId();
    } else {
      $ultimoIdSolicitacao  = $idSolicitacao;
    }

    $idSolicitacaoMovimento = $ultimoIdSolicitacao;

    #---- ATUALIZA VÍNCULO DOS ANEXOS COM A SOLICITAÇÃO -----#
    $stmAtualizaAnexo = $rsConexao->prepare("UPDATE reg_tb_solicitacoes_anexos SET id_sca_solicitacao='$ultimoIdSolicitacao' WHERE token_solicitacao='$tokenSolicitacao'");
    $stmAtualizaAnexo->execute();

    #---- GERAR NÚMERO DO PROTOCOLO -----#
    $idUsuarioLogado          = $_SESSION['idUsuarioLogado'];
    $dataHoraHoje           = date("Y-m-d H:i");
    $idPaciente              = $_POST['idPaciente'];
    $idSolicitacao          = $_POST['idSolicitacao'];

    if ($idSolicitacao == "") {
      $numeroProtocolo      = date("Ym") . str_pad($ultimoIdSolicitacao, 4, "0", STR_PAD_LEFT);
      $stmAtualizaProtocolo = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET numero_procotolo='$numeroProtocolo' WHERE id_solicitacao='$ultimoIdSolicitacao'");
      $stmAtualizaProtocolo->execute();
    } else {
      $numeroProtocolo  = $_POST['numeroProtocolo'];
    }
    echo $ultimoIdSolicitacao . "##" . $numeroProtocolo;

    #-------- ATUALIZAR STATUS DE RELATÓRIO MÉDICO --------#
    $stmPegarAnexos = $rsConexao->prepare("SELECT COUNT(id_tipodocumento) AS totalRelatorios FROM reg_tb_solicitacoes_anexos WHERE id_sca_solicitacao='$ultimoIdSolicitacao' AND id_tipodocumento='4'");
    $stmPegarAnexos->execute();
    $rsPegarAnexos  = $stmPegarAnexos->fetch(PDO::FETCH_OBJ);

    if ($rsPegarAnexos->totalRelatorios > 0) {
      $statusRelatorioMedico  = "S";
      $triagemLiberada        = "N";
    } else {
      $statusRelatorioMedico  = "N";
      $triagemLiberada        = "S";
    }
    $stmAtualizaRelatorioMedico = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET tem_relatoriomedico='$statusRelatorioMedico', triagem_liberada='$triagemLiberada' WHERE id_solicitacao='$ultimoIdSolicitacao'");
    $stmAtualizaRelatorioMedico->execute();
    $gerarHistorico = "S";
      
    break;

  case 'solicitacao-analise':

    $idSolicitacao          = $_POST['idSolicitacao'];
    $classificacaoRisco     = $_POST['classificacaoRisco'];
    $statusSolicitacao      = $_POST['statusSolicitacao'];
    $enviarEnfermeiroMedico = $_POST['enviarEnfermeiroMedico'];
    $observacoesAnalise     = $_POST['observacoesAnalise'];
    $triagemLiberada        = $enviarEnfermeiroMedico == "S" ? "N" : "S";

    $sqlSolicitatao = "UPDATE reg_tb_solicitacoes SET
    id_classificacaorisco=:setClassificacaoRisco,
    id_statussolicitacao=:setStatusSolicitacao,
    observacoes_analise=:setObservacaoAnalisa,
    id_usuario_analisou=:setUsuarioLogado,
    datahora_analise=:setDataHoraAnalise,
    tem_relatoriomedico=:setRelatorioMedico,
    triagem_liberada=:setTriagemLiberada
    WHERE id_solicitacao='$idSolicitacao'";

    $stmSolicitatao = $rsConexao->prepare($sqlSolicitatao);
    $stmSolicitatao->bindParam(":setClassificacaoRisco", $classificacaoRisco, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setObservacaoAnalisa", $observacoesAnalise, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setDataHoraAnalise", $dataHoraHoje, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setRelatorioMedico", $enviarEnfermeiroMedico, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setTriagemLiberada", $triagemLiberada, PDO::PARAM_STR);
    $stmSolicitatao->execute();

    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "ANÁLISE";
    $idStatusMovimento  = $_POST['statusSolicitacao'];
    $gerarHistorico     = "S";
    break;

  case 'solicitacao-analise-assistente-social':

    $idSolicitacao          = $_POST['idSolicitacao'];
    $classificacaoRisco     = $_POST['classificacaoRisco'];
    $statusSolicitacao      = $_POST['statusSolicitacao'];
    $enviarEnfermeiroMedico = $_POST['enviarEnfermeiroMedico'];
    $observacoesAnalise     = $_POST['observacoesAnalise'];
    $triagemLiberada        = $enviarEnfermeiroMedico == "S" ? "N" : "S";

    $sqlSolicitatao = "UPDATE reg_tb_solicitacoes SET
    id_classificacaorisco=:setClassificacaoRisco,
    id_statussolicitacao=:setStatusSolicitacao,
    observacoes_analise_asocial=:setObservacaoAnalisa,
    id_usuario_analisou=:setUsuarioLogado,
    datahora_analise=:setDataHoraAnalise,
    tem_relatoriomedico=:setRelatorioMedico,
    triagem_liberada=:setTriagemLiberada
    WHERE id_solicitacao='$idSolicitacao'";

    $stmSolicitatao = $rsConexao->prepare($sqlSolicitatao);
    $stmSolicitatao->bindParam(":setClassificacaoRisco", $classificacaoRisco, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setObservacaoAnalisa", $observacoesAnalise, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setDataHoraAnalise", $dataHoraHoje, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setRelatorioMedico", $enviarEnfermeiroMedico, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setTriagemLiberada", $triagemLiberada, PDO::PARAM_STR);
    $stmSolicitatao->execute();

    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "ANÁLISE SSISTENTE SOCIAL";
    $idStatusMovimento  = $_POST['statusSolicitacao'];
    $gerarHistorico     = "S";
    break;

  case 'agendamento-registro':

    $idSolicitacao                = $_POST['idSolicitacao'];
    $idPaciente                   = $_POST['idPaciente'];
    $horaRegistroAgendamento      = substr($_POST['dataHoraRegistro'], -5);
    $dataRegistroAgendamento      = substr($_POST['dataHoraRegistro'], 0, 10);
    $dataRegistroAgendamento      = explode("/", $dataRegistroAgendamento);
    $dataRegistroAgendamento      = $dataRegistroAgendamento[2] . '-' . $dataRegistroAgendamento[1] . '-' . $dataRegistroAgendamento[0];
    $dataHoraRegistroAgendamento  = $dataRegistroAgendamento . ' ' . $horaRegistroAgendamento;
    $dataAtendimentoPost          = $_POST['dataAtendimento'];
    $dataPrazoRetirada            = $_POST['prazoRetirada'];
    $origemAgendamento            = $_POST['origemAgendamento'];
    $observacaoAgendamento        = $_POST['observacaoAgendamento'];
    $statusSolicitacao            = 3;

    # ---- REALIZAR VALIDAÇÃO DA DATA DE RETIRADA ---- #

    $formatarDiaSemana = array(
      '0' => 'DOMINGO',
      '1' => 'SEGUNDA-FEIRA',
      '2' => 'TERÇA-FEIRA',
      '3' => 'QUARTA-FEIRA',
      '4' => 'QUINTA-FEIRA',
      '5' => 'SEXTA-FEIRA',
      '6' => 'SÁBADO'
    );

    $validarDiaRetirada = date('w', strtotime($dataPrazoRetirada));
    if ($validarDiaRetirada == 0 || $validarDiaRetirada == 6) {
      echo "diaInvalido#A data estabelecida como prazo para retirada da marcação cai em um [ " . $formatarDiaSemana[$validarDiaRetirada] . " ]. Recomenda-se não utilizar esses dias como prazo para retirada.";
      exit;
    }

    $sqlValidarFeriado  = "SELECT id_feriado FROM reg_tb_feriados WHERE (date_format(data_inicioferiado,'%Y-%m-%d')<='$dataPrazoRetirada' AND date_format(data_fimferiado,'%Y-%m-%d')>='$dataPrazoRetirada') AND (date_format(NOW(),'%Y-%m-%d')<'$dataPrazoRetirada')";
    $stmValidarFeriado  = $rsConexao->prepare($sqlValidarFeriado);
    $stmValidarFeriado->execute();
    if ($stmValidarFeriado->rowCount()) {
      echo "diaInvalido#A data estabelecida como prazo para retirada da marcação esta cadastrada como feriado ou ponto facultativo. Recomenda-se não utilizar esses dias como prazo para retirada.";
      exit;
    }
    # ------------------------------------------------ #    
    $sqlAgendamento = "UPDATE reg_tb_solicitacoes SET
    id_statussolicitacao=:setStatusSolicitacao,
    dataprazo_retirada=:setDataPrazoRetirada,
    data_atendimento=:setDataAtendimentoPost,
    origem_agendamento=:setOrigemAgendamento,
    observacao_agendamento=:setObservacaoAgendamento,
    datahora_registroagendamento=:setDataHoraRegistroAgendamento,
    idusuario_registrouagendamento=:setUsuarioRegistrouAgendamento
    WHERE id_solicitacao='$idSolicitacao'";

    $stmAgendamento = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataPrazoRetirada", $dataPrazoRetirada, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataAtendimentoPost", $dataAtendimentoPost, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setOrigemAgendamento", $origemAgendamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setObservacaoAgendamento", $observacaoAgendamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataHoraRegistroAgendamento", $dataHoraRegistroAgendamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioRegistrouAgendamento", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->execute();

    # ---- atualizar teledones do paciente ---#
    $telefoneCelular1            = $_POST['telefoneCelular1'];
    $telefoneCelular1Whatsapp   = $_POST['telefoneCelular1Whatsapp'];
    $telefoneCelular2           = $_POST['telefoneCelular2'];
    $telefoneCelular2Whatsapp   = $_POST['telefoneCelular2Whatsapp'];
    $telefoneCelular3           = $_POST['telefoneCelular3'];
    $telefoneCelular3Whatsapp   = $_POST['telefoneCelular3Whatsapp'];
    $sqlPaciente = "UPDATE tb_paciente SET
      celular1=:setTelefone1,
      celular1_whatsapp=:setWhatsapp1,
      celular2=:setTelefone2,
      celular2_whatsapp=:setWhatsapp2,
      celular3=:setTelefone3,
      celular3_whatsapp=:setWhatsapp3 
      WHERE id_paciente='$idPaciente'
    ";
    $stmPaciente = $rsConexao->prepare($sqlPaciente);
    $stmPaciente->bindParam(":setTelefone1", $telefoneCelular1, PDO::PARAM_STR);
    $stmPaciente->bindParam(":setWhatsapp1", $telefoneCelular1Whatsapp, PDO::PARAM_STR);
    $stmPaciente->bindParam(":setTelefone2", $telefoneCelular2, PDO::PARAM_STR);
    $stmPaciente->bindParam(":setWhatsapp2", $telefoneCelular2Whatsapp, PDO::PARAM_STR);
    $stmPaciente->bindParam(":setTelefone3", $telefoneCelular3, PDO::PARAM_STR);
    $stmPaciente->bindParam(":setWhatsapp3", $telefoneCelular3Whatsapp, PDO::PARAM_STR);
    $stmPaciente->execute();

    # -- INSERIR REGISTRO DE AGENDAMENTOS -- #
      # -- pegar ptotocolo da solicitação -- #
        $stmProcotoloSolicitacao    = $rsConexao->prepare("SELECT numero_procotolo, id_grupo_procedimento, id_procedimento FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'");
        $stmProcotoloSolicitacao    -> execute();
        $rsProcotoloSolicitacao     = $stmProcotoloSolicitacao->fetch(PDO::FETCH_OBJ);
        $protocoloAgendamento       = $rsProcotoloSolicitacao->numero_procotolo;
        $idProcedimentoAgendamento  = $rsProcotoloSolicitacao->id_procedimento;
        $idGrupoProcedimentoAgendam = $rsProcotoloSolicitacao->id_grupo_procedimento;
        $origemAgendamento          = "S-FG";
        $tipoVagaOcupada            = $_POST['origemAgendamento'];
        $dataAtendimento            = $dataAtendimentoPost;
        $horaAtendimento            = null;
      # ------------------------------------ #
        $ipUsuarioAgendou       = getIPCliente();
        $conexaoUsuarioAgendou  = gethostbyaddr(getIPCliente());

        $sqlGravarAgendamento = "INSERT INTO reg_tb_agendamentos(
            origem_agendamento,
            protocolo_agendamento,
            id_paciente,
            id_solicitacao,
            id_grupo_procedimento,
            id_procedimento,
            data_atendimento,
            horario_atendimento,
            dataprazo_retirada,
            tipo_vagaocupada,
            observacao_agendamento,
            id_usuario_agendou,
            ip_usuario_agendou,
            conexao_usuario_agendou
          ) VALUES (
            :setOrigemAgendamento,
            :setProtocoloAgendamento,
            :setIdPaciente,
            :setIdSolicitacao,
            :setIdGrupoProcedimento,
            :setIdProcedimento,
            :setDataAtendimento,
            :setHorarioAtendimento,
            :setDataPrazoRetirada,
            :setTipoVagaOcupada,
            :setObservacaoAgendamento,
            :setIdUsuarioAgendou,
            :setIPUsuarioAgendou,
            :setConexaoUsuarioAgendou
          )";

          $stmAgendamento = $rsConexao->prepare($sqlGravarAgendamento);
          $stmAgendamento ->bindParam(":setOrigemAgendamento", $origemAgendamento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setProtocoloAgendamento", $protocoloAgendamento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIdPaciente", $idPaciente, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIdSolicitacao", $idSolicitacao, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIdProcedimento", $idProcedimentoAgendamento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIdGrupoProcedimento", $idGrupoProcedimentoAgendam, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setDataAtendimento", $dataAtendimento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setHorarioAtendimento", $horaAtendimento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setDataPrazoRetirada", $dataPrazoRetirada, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setTipoVagaOcupada", $tipoVagaOcupada, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setObservacaoAgendamento", $observacaoAgendamento, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIdUsuarioAgendou", $idUsuarioLogado, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setIPUsuarioAgendou", $ipUsuarioAgendou, PDO::PARAM_STR);
          $stmAgendamento ->bindParam(":setConexaoUsuarioAgendou", $conexaoUsuarioAgendou, PDO::PARAM_STR);
          $stmAgendamento->execute();
    # -- ----------------------------------- #    
    $stmComunicacao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET idusuario_comunicacao=null, encaminhado_ligacao='S', em_comunicacao='N' WHERE id_solicitacao='$idSolicitacao'");
    $stmComunicacao ->execute();
    $stmComunicacao ->closeCursor();

    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "AGENDAMENTO";
    $idStatusMovimento  = 3;
    $gerarHistorico     = "S";
    break;

  case 'solicitacao-solicitar-cancelamento':

    $idSolicitacao              = $_POST['idSolicitacao'];
    $justificativaCancelamento  = $_POST['justificativaCancelamento'];
    $statusSolicitacao          = 4;
    $sqlCancelamento = "UPDATE reg_tb_solicitacoes SET
    id_statussolicitacao=:setStatusSolicitacao,
    justificativa_solicitacaocancelamento=:setJustificativaCancelamento,
    id_usuario_solicitoucancelamento=:setUsuarioSolicitouCancelamento,
    datahora_solicitoucancelamento=:setDataHoraSolicitacaoCancelamento
    WHERE id_solicitacao='$idSolicitacao'";

    $stmAgendamento = $rsConexao->prepare($sqlCancelamento);
    $stmAgendamento->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setJustificativaCancelamento", $justificativaCancelamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioSolicitouCancelamento", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataHoraSolicitacaoCancelamento", $dataHoraHoje, PDO::PARAM_STR);
    $stmAgendamento->execute();

    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "SOLICITOU CANCELAMENTO";
    $idStatusMovimento  = 4;
    $gerarHistorico     = "S";
    break;

  case 'solicitacao-confirmar-cancelamento':

    $idSolicitacao            = $_POST['idSolicitacao'];
    $dataRegistroCancelamento = substr($_POST['dataRegistroCancelamento'], 0, 10);
    $dataRegistroCancelamento = explode("/", $dataRegistroCancelamento);
    $dataRegistroCancelamento = $dataRegistroCancelamento[2] . '-' . $dataRegistroCancelamento[1] . '-' . $dataRegistroCancelamento[0];
    $dataHoraCancelamento     = $dataRegistroCancelamento . " " . substr($_POST['dataRegistroCancelamento'], -5);
    $statusSolicitacao        = 5;

    $informacoesCancelamento = $_POST['informacoesCancelamento'];
    $sqlCancelamento = "UPDATE reg_tb_solicitacoes SET
    id_statussolicitacao=:setStatusSolicitacao,
    datahora_cancelamento=:setDataRegistroCancelamento,
    informacoes_cancelamento=:setJustificativaCancelamento,
    id_usuario_cancelou=:setUsuarioCancelou
    WHERE (id_solicitacao='$idSolicitacao')";
    $stmAgendamento = $rsConexao->prepare($sqlCancelamento);
    $stmAgendamento->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataRegistroCancelamento", $dataHoraCancelamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setJustificativaCancelamento", $informacoesCancelamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioCancelou", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->execute();
    $stmAgendamento->closeCursor();

    # -- cancelar agendamento e devolver vaga à agenda --- #
    $temAgendamento = "";
    $stmAgendamento = $rsConexao->prepare("SELECT * FROM reg_tb_agendamentos WHERE id_solicitacao='$idSolicitacao'");
    $stmAgendamento->execute();
    if ($stmAgendamento->rowCount() > 0) {
      $temAgendamento = "S";
      $rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);
      $idAgendamento  = $rsAgendamento->id_agendamento;
      $idAgendaSub    = $rsAgendamento->id_agenda_sub;
      if (mb_strtoupper($rsAgendamento->tipo_vagaocupada) == "PVEZ") {
        $campoVagaAgenda  = "quantidadegendada_pvez";
      } else if (mb_strtoupper($rsAgendamento->tipo_vagaocupada) == "RETORNO") {
        $campoVagaAgenda  = "quantidadeagendada_retorno";
      } else {
        $campoVagaAgenda  = "quantidadeagendada_reserva";
      }

      $stmCancelaAgendamento  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='C' WHERE id_agendamento='$idAgendamento'");
      $stmCancelaAgendamento->execute();

      # -- devolver vaga à agenda 
      $stmTotalOcupado  = $rsConexao->prepare("SELECT $campoVagaAgenda FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      if (mb_strtoupper($rsAgendamento->tipo_vagaocupada) == "PVEZ") {
        $totalOcupado = $rsTotalOcupado->quantidadegendada_pvez != "" ? $rsTotalOcupado->quantidadegendada_pvez : 0;
      } else if (mb_strtoupper($rsAgendamento->tipo_vagaocupada) == "RETORNO") {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_retorno != "" ? $rsTotalOcupado->quantidadeagendada_retorno : 0;
      } else {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_reserva != "" ? $rsTotalOcupado->quantidadeagendada_reserva : 0;
      }
      $novoTotalOcupado = $totalOcupado != 0 ? $totalOcupado - 1 : $totalOcupado;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET $campoVagaAgenda='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      # gerar histórico de cancelamento do agendamento
      if ($temAgendamento == "S") {
        $sqlMovimento = "INSERT INTO reg_tb_solicitacoes_historico(
          id_solicitacao,
          datahora_registro,
          texto_movimentacao,
          id_statussolicitacao,
          idusuario_registrou
        )VALUES(
          :setIdSolicitacao,
          :setDataHoraHoje,
          :setTextoMovimento,
          :setStatusSolicitacao,
          :setUsuarioLogado
        )";
        $tipoMovimento = "MARCAÇÃO CANCELADA";
        $idStatusMovimento = 5;
        $stmMovimento = $rsConexao->prepare($sqlMovimento);
        $stmMovimento->bindParam(":setIdSolicitacao", $idSolicitacao, PDO::PARAM_STR);
        $stmMovimento->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
        $stmMovimento->bindParam(":setTextoMovimento", $tipoMovimento, PDO::PARAM_STR);
        $stmMovimento->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
        $stmMovimento->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);
        $stmMovimento->execute();
      }
    }

    # -- --------------------------------------------- --- #
    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "CANCELOU SOLICITAÇÃO";
    $idStatusMovimento  = 5;
    $gerarHistorico     = "S";

    break;

  case 'solicitacao-entregar-marcacao':

    $idSolicitacao                  = $_POST['idSolicitacao'];
    $nomePortador                   = $_POST['nomePortador'];
    $documentoPortador              = $_POST['documentoPortador'];
    $telefonePortador               = $_POST['telefonePortador'];
    $carroPoliclinica               = $_POST['carroPoliclinica'];
    $precisaAcompanhantePoliclinica = $_POST['acompanhantePoliclinica'];
    $nomeAcompanhante               = $_POST['nomeAcompanhante'];
    $documentoAcompanhante          = $_POST['documentoAcompanhante'];
    $maeAcompanhante                = $_POST['maeAcompanhante'];
    $dataNascimentoAcompanhanete    = $_POST['dataNascimentoAcompanhanete'] == "" ? null : $_POST['dataNascimentoAcompanhanete'];
    $localPartidaTransporte         = $_POST['localPartidaTransporte'];
    $statusSolicitacao              = 6;

    # -- reigstrar entrega na slicitação -- #
    $sqlEntrega = "UPDATE reg_tb_solicitacoes SET
    nome_portador=:setPortadorEntrega,
    documento_portador=:setDocumentoPortadorEntrega,
    telefone_portador=:setTelefonePortadorEntrega,
    carro_policlinica=:setCarroPoliclinica,
    precisaacompanhante_policlinica=:setPrecisaAcompanhantePoliclinica,
    nomeacompanhante_policlinica=:setNomeAcompanhantePoliclinica,
    documentoacompanhante_policlinica=:setDocAcompanhantePoliclinica,
    maeacompanhante_policlinica=:setMaeAcompanhantePoliclinica,
    nascimentocompanhante_policlinica=:setNascimentoAcompanhantePoliclinica,
    localpartida_policlinica=:setLocalPartidaPoliclinica,
    id_statussolicitacao=:setStatusSolicitacao,
    datahora_entrega=:setDataHoraEntrega,
    id_usuario_entregou=:setUsuarioEntregou
    WHERE id_solicitacao='$idSolicitacao'";

    $stmAgendamento = $rsConexao->prepare($sqlEntrega);
    $stmAgendamento->bindParam(":setPortadorEntrega", $nomePortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDocumentoPortadorEntrega", $documentoPortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setTelefonePortadorEntrega", $telefonePortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setCarroPoliclinica", $carroPoliclinica, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setPrecisaAcompanhantePoliclinica", $precisaAcompanhantePoliclinica, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setNomeAcompanhantePoliclinica", $nomeAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDocAcompanhantePoliclinica", $documentoAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setMaeAcompanhantePoliclinica", $maeAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setNascimentoAcompanhantePoliclinica", $dataNascimentoAcompanhanete, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setLocalPartidaPoliclinica", $localPartidaTransporte, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setStatusSolicitacao", $statusSolicitacao, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataHoraEntrega", $dataHoraHoje, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioEntregou", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->execute();
    $stmAgendamento->closeCursor();
   
    $idSolicitacaoMovimento = $idSolicitacao;
    $tipoMovimento      = "ENTREGOU MARCAÇÃO";
    $idStatusMovimento  = 6;
    $gerarHistorico     = "S";

    # -- reigstrar entrega no agendamento -- #
    $sqlEntrega = "UPDATE reg_tb_agendamentos SET
    nome_portador=:setPortadorEntrega,
    documento_portador=:setDocumentoPortadorEntrega,
    telefone_portador=:setTelefonePortadorEntrega,
    carro_policlinica=:setCarroPoliclinica,
    precisaacompanhante_policlinica=:setPrecisaAcompanhantePoliclinica,
    nomeacompanhante_policlinica=:setNomeAcompanhantePoliclinica,
    documentoacompanhante_policlinica=:setDocAcompanhantePoliclinica,
    maeacompanhante_policlinica=:setMaeAcompanhantePoliclinica,
    nascimentocompanhante_policlinica=:setNascimentoAcompanhantePoliclinica,
    localpartida_policlinica=:setLocalPartidaPoliclinica,
    status_agendamento='E',
    marcacao_entregue='S',
    datahora_entrega=:setDataHoraEntrega,
    id_usuario_entregou=:setUsuarioEntregou
    WHERE id_solicitacao='$idSolicitacao'";
    $stmAgendamento = $rsConexao->prepare($sqlEntrega);
    $stmAgendamento->bindParam(":setPortadorEntrega", $nomePortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDocumentoPortadorEntrega", $documentoPortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setTelefonePortadorEntrega", $telefonePortador, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setCarroPoliclinica", $carroPoliclinica, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setPrecisaAcompanhantePoliclinica", $precisaAcompanhantePoliclinica, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setNomeAcompanhantePoliclinica", $nomeAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDocAcompanhantePoliclinica", $documentoAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setMaeAcompanhantePoliclinica", $maeAcompanhante, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setNascimentoAcompanhantePoliclinica", $dataNascimentoAcompanhanete, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setLocalPartidaPoliclinica", $localPartidaTransporte, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataHoraEntrega", $dataHoraHoje, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioEntregou", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->execute();
    $stmAgendamento->closeCursor();
    break;

  case 'solicitacao-statusagendamento-não':
    $idSolicitacao          = $_POST['idSolicitacao'];
    $idSolicitacaoMovimento = $_POST['idSolicitacao'];
    $stmEmAgendamentoNao  = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_agendamento='N', id_usuario_em_agendamento=null  WHERE (id_solicitacao='$idSolicitacao') AND (id_usuario_em_agendamento='$idUsuarioLogado')");
    $gerarHistorico       = "N";
    $stmEmAgendamentoNao->execute();
    echo "UPDATE reg_tb_solicitacoes SET em_agendamento='N', id_usuario_em_agendamento=null  WHERE (id_solicitacao='$idSolicitacao') AND (id_usuario_em_agendamento='$idUsuarioLogado')";
    break;

  case 'solicitacao-statusanalise-não':
    $idSolicitacao          = $_POST['idSolicitacao'];
    $idSolicitacaoMovimento = $_POST['idSolicitacao'];
    $stmEmAnalise  = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_analise='N' WHERE id_solicitacao='$idSolicitacao'");
    $stmEmAnalise->execute();
    $gerarHistorico       = "N";
    break;

  case 'solicitacao-statuscomunicacao-não':
    $idPaciente             = $_POST['idPaciente'];
    $stmCancelarComunicacao =  $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET id_statussolicitacao='3', idusuario_comunicacao=null, em_comunicacao='N' WHERE id_paciente='$idPaciente' AND em_comunicacao='S'");
    $stmCancelarComunicacao->execute();
    $stmCancelarComunicacao->closeCursor();

    $stmCancelarComunicacao =  $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='A', idusuario_comunicacao=null, em_comunicacao='N' WHERE id_paciente='$idPaciente' AND em_comunicacao='S'");
    $stmCancelarComunicacao->execute();    
    $gerarHistorico         = "N";
    break;

  case 'solicitacao-statusligacao-não':
    $idPaciente             = $_POST['idPaciente'];
    $idSolicitacaoMovimento = $_POST['idSolicitacao'];
    $idPaciente = $_POST['idPaciente'];
    $stmCancelarComunicacao  =  $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET idusuario_comunicacao=null, encaminhado_ligacao='S', em_comunicacao='N' WHERE id_paciente='$idPaciente' AND  id_statussolicitacao='3'");
    $stmCancelarComunicacao->execute();
    $stmCancelarComunicacao->closeCursor();

    $stmCancelarComunicacao =  $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='A', idusuario_comunicacao=null, encaminhado_ligacao='N', em_comunicacao='N' WHERE id_paciente='$idPaciente' AND em_comunicacao='S'");
    $stmCancelarComunicacao->execute();    


    $gerarHistorico = "N";
    break;

  case 'atualizar-status-comunicacao-ligacao':
    $explodeIdReferencia    = explode("##",$_POST['idReferencia']);
    $idAgendamento          = $explodeIdReferencia[0];
    $idSolicitacao          = $explodeIdReferencia[1];
    $idSolicitacaoMovimento = $explodeIdReferencia[1];
    
    $valorStatus            = $_POST['valorStatus'];
    $observacoesComunicacao = $_POST['observacoesComunicacao'];
    $meioComunicacao        = $_POST['meioComunicacao'];
    //Atualiza status da solicitação na fila
    if($idSolicitacao!="0"){
      $statusSolicitacaoAgendamento = mb_strtoupper($valorStatus)=="CANCELAR" ? 4 : 3;
      $statusAgendamentoGravar      = mb_strtoupper($valorStatus)=="CANCELAR" ? "C" : "A";
      $sqlAtualizaStatus    = "UPDATE reg_tb_solicitacoes SET status_comunicacao='$valorStatus', idusuario_comunicacao='$idUsuarioLogado', datahora_registrocomunicacao='$dataHoraHoje', id_statussolicitacao='$statusSolicitacaoAgendamento', justificativa_solicitacaocancelamento='$observacoesComunicacao', meio_comunicacao='$meioComunicacao' 
      WHERE id_solicitacao='$idSolicitacao'";
      $stmAtualizaStatus  =  $rsConexao->prepare($sqlAtualizaStatus);
      $stmAtualizaStatus->execute();
      $tipoMovimento      = "REALIZOU COMUNICAÇÃO " . mb_strtoupper($meioComunicacao);
      $idStatusMovimento  = $statusSolicitacaoAgendamento;
      $gerarHistorico     = "S";
      $stmAtualizaStatus->closeCursor();
    }else{
      $statusSolicitacaoAgendamento  = mb_strtoupper($valorStatus)=="CANCELAR" ? "E" : "A";
      $statusAgendamentoGravar       = mb_strtoupper($valorStatus)=="CANCELAR" ? "C" : "A";
      $gerarHistorico     = "N";
    }    

    //Atualiza status do agendamento
    $sqlAtualizaStatus = "UPDATE reg_tb_agendamentos SET status_comunicacao='$statusAgendamentoGravar', idusuario_comunicacao='$idUsuarioLogado', datahora_registrocomunicacao=now(), status_agendamento='$statusAgendamentoGravar', justificativa_solicitacaocancelamento='$observacoesComunicacao', meio_comunicacao='$meioComunicacao' 
    WHERE id_agendamento='$idAgendamento'";
    $stmAtualizaStatus  =  $rsConexao->prepare($sqlAtualizaStatus);
    $stmAtualizaStatus->execute();
    break;

  case "atualizacao-comunicacao-ligacoes":
    $idPaciente                   = $_POST['idPaciente'];
    $dataRetirada                 = $_POST['dataRetirada'];
    $stmAtuaizaStatusComunicacao  = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET encaminhado_ligacao='S' WHERE id_statussolicitacao='3' AND id_paciente='$idPaciente' AND dataprazo_retirada='$dataRetirada'");    
    $stmAtuaizaStatusComunicacao->execute();
    $stmAtuaizaStatusComunicacao->closeCursor();

    $stmAtuaizaStatusComunicacao  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET encaminhado_ligacao='S' WHERE status_agendamento='A' AND id_paciente='$idPaciente' AND dataprazo_retirada='$dataRetirada'");    
    $stmAtuaizaStatusComunicacao->execute();

    $gerarHistorico     = "N";
    break;

  case "atualizacao-comunicacao-whatsapp":
    
    $idPaciente                   = $_POST['idPaciente'];
    $dataRetirada                 = $_POST['dataRetirada'];
    $stmAtuaizaStatusComunicacao  = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET encaminhado_ligacao='N', em_comunicacao='N' WHERE id_statussolicitacao='3' AND id_paciente='$idPaciente' AND dataprazo_retirada='$dataRetirada'");
    $stmAtuaizaStatusComunicacao->execute();
    $stmAtuaizaStatusComunicacao->closeCursor();

    $stmAtuaizaStatusComunicacao  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET encaminhado_ligacao='N', em_comunicacao='N' WHERE status_agendamento='A' AND id_paciente='$idPaciente' AND dataprazo_retirada='$dataRetirada'");
    $stmAtuaizaStatusComunicacao->execute();

    $gerarHistorico     = "N";
    break;

  case "solicitacao-agendamento-obsextra":
    $idSolicitacao              = $_POST['idSolicitacao'];
    $agendamentoObservacaoExtra = $_POST['agendamentoObservacaoExtra'];
    $dataHora = date("d/m/Y H:i");

    # -- PEGAR OBSERVAÇÃO EXISTENTE -- #
    $stmTemObservacao = $rsConexao->prepare("SELECT observacaoextra_agendamento FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'");
    $stmTemObservacao ->execute();
    $rsTemObservacao  = $stmTemObservacao->fetch(PDO::FETCH_OBJ);
    if($rsTemObservacao->observacaoextra_agendamento!=''){
      $sqlObservacao = "UPDATE reg_tb_solicitacoes 
      SET observacaoextra_agendamento=concat(observacaoextra_agendamento,'<br>','$dataHora: $agendamentoObservacaoExtra')
      WHERE id_solicitacao='$idSolicitacao'";
    }else{
      $sqlObservacao = "UPDATE reg_tb_solicitacoes SET observacaoextra_agendamento='$dataHora: $agendamentoObservacaoExtra' WHERE id_solicitacao='$idSolicitacao'";
    }
    $stmAtualizaObservacao  =  $rsConexao->prepare($sqlObservacao);
    $stmAtualizaObservacao->execute();
    $gerarHistorico     = "N";
    break;

  case "confirmar-transporte-policlinica":
    $idPaciente       = $_POST['idPaciente'];
    $prazoRetirada    = $_POST['prazoRetirada'];
    $opcaoRegistro    = $_POST['opcaoRegistro'];
    $transporteGerado = "S";

    if ($opcaoRegistro == "sol") {
      $sqlTrannsporte = "UPDATE reg_tb_solicitacoes SET
      transporte_gerado=:setTransporteGerado,
      id_usuario_confirmoutransporte=:setUsuarioLogado,
      datahora_confirmoutransporte=:setDataHoraConfirmacao
      WHERE (id_statussolicitacao='6' OR id_statussolicitacao='7') AND id_paciente='$idPaciente' AND (date_format(dataprazo_retirada,'%Y%m%d')='$prazoRetirada')";
    } else {
      $sqlTrannsporte = "UPDATE reg_tb_agendamentos SET
      transporte_gerado=:setTransporteGerado,
      id_usuario_confirmoutransporte=:setUsuarioLogado,
      datahora_confirmoutransporte=:setDataHoraConfirmacao
      WHERE (origem_agendamento!='S-FG' AND status_agendamento='A') AND (id_paciente='$idPaciente') AND (date_format(dataprazo_retirada,'%Y%m%d')='$prazoRetirada')";
    }
    $stmTrannsporte = $rsConexao->prepare($sqlTrannsporte);
    $stmTrannsporte->bindParam(":setTransporteGerado", $transporteGerado, PDO::PARAM_STR);
    $stmTrannsporte->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);
    $stmTrannsporte->bindParam(":setDataHoraConfirmacao", $dataHoraHoje, PDO::PARAM_STR);
    $stmTrannsporte->execute();
    $gerarHistorico = "N";
    break;

  case 'agendamento-confirmar-cancelamento':

    $idAgendamento            = $_POST['idAgendamento'];
    $idAgendaSub              = $_POST['idAgendaSub'];
    $dataRegistroCancelamento = substr($_POST['dataRegistroCancelamento'], 0, 10);
    $dataRegistroCancelamento = explode("/", $dataRegistroCancelamento);
    $dataRegistroCancelamento = $dataRegistroCancelamento[2] . '-' . $dataRegistroCancelamento[1] . '-' . $dataRegistroCancelamento[0];
    $dataHoraCancelamento     = $dataRegistroCancelamento . " " . substr($_POST['dataRegistroCancelamento'], -5);
    $statusAgendamento        = 'A';

    $informacoesCancelamento = $_POST['informacoesCancelamento'];
    $tipoVagaOcupada         = $_POST['tipoVagaOcupada'];

    $sqlCancelamento = "UPDATE reg_tb_agendamentos SET
    status_agendamento=:setStatusAgendamento,
    datahora_cancelamento=:setDataRegistroCancelamento,
    informacoes_cancelamento=:setJustificativaCancelamento,
    id_usuario_cancelou=:setUsuarioCancelou
    WHERE id_agendamento='$idAgendamento'";
    $stmAgendamento = $rsConexao->prepare($sqlCancelamento);
    $stmAgendamento->bindParam(":setStatusAgendamento", $statusAgendamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setDataRegistroCancelamento", $dataHoraCancelamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setJustificativaCancelamento", $informacoesCancelamento, PDO::PARAM_STR);
    $stmAgendamento->bindParam(":setUsuarioCancelou", $idUsuarioLogado, PDO::PARAM_STR);
    $stmAgendamento->execute();
    $stmAgendamento->closeCursor();

    # -- cancelar agendamento e devolver vaga à agenda --- #
    $stmCancelaAgendamento  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='C' WHERE id_agendamento='$idAgendamento'");
    $stmCancelaAgendamento->execute();

    if ($idAgendaSub != "") {
      if (mb_strtoupper($tipoVagaOcupada) == "PVEZ") {
        $campoVagaAgenda  = "quantidadegendada_pvez";
      } else if (mb_strtoupper($tipoVagaOcupada) == "RETORNO") {
        $campoVagaAgenda  = "quantidadeagendada_retorno";
      } else {
        $campoVagaAgenda  = "quantidadeagendada_reserva";
      }
      # -- devolver vaga à agenda 
      $stmTotalOcupado  = $rsConexao->prepare("SELECT $campoVagaAgenda FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      if (mb_strtoupper($tipoVagaOcupada) == "PVEZ") {
        $totalOcupado = $rsTotalOcupado->quantidadegendada_pvez != "" ? $rsTotalOcupado->quantidadegendada_pvez : 0;
      } else if (mb_strtoupper($tipoVagaOcupada) == "RETORNO") {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_retorno != "" ? $rsTotalOcupado->quantidadeagendada_retorno : 0;
      } else {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_reserva != "" ? $rsTotalOcupado->quantidadeagendada_reserva : 0;
      }
      $novoTotalOcupado = $totalOcupado != 0 ? $totalOcupado - 1 : $totalOcupado;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET $campoVagaAgenda='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();
    }

    #-- registrar cancelamento na tabela de procedimentos da OCI
    $stmCancelaAgendamentoOCI  = $rsConexao->prepare("UPDATE reg_tb_agendamentos_oci SET status_agendamento='CANCELADO' WHERE id_registro_agendamento='$idAgendamento'");
    $stmCancelaAgendamentoOCI->execute();

    $gerarHistorico     = "N";
    break;
  
  case "solicitacao-laboratorio":
    $idSolicitacao            = $_POST['idSolicitacao'];
    $idPaciente               = $_POST['idPaciente'];
    $grupoProcedimento        = $_POST['grupoProcedimento'];
    $observacaoSolicitacao    = $_POST['observacaoSolicitacao'];
    $tokenSolicitacao         = $_POST['tokenSolicitacao'];
    $cidSolicitacao           = mb_strtoupper($_POST['cidSolicitacao']);
    $profissionalSolicitante  = $_POST['profissionalSolicitante'];
    $classificacaoPrioridade  = $_POST['classificacaoPrioridade'];
    $solicitacaoRetorno       = "N";
    $idStatusMovimento        = 2;
    $idProcedimento           = null;

    # -- atualizar condição de saúde do paciente -- #
    $pacienteOncologico   = $_POST['pacienteOncologico'];
    $pacienteDiabetico    = $_POST['pacienteDiabetico'];
    $pacienteHipertenso   = $_POST['pacienteHipertenso'];
    $pacienteRenalCronico = $_POST['pacienteRenalCronico'];
    $pacientePCD          = $_POST['pacientePCD'];
    $descricaoDeficiencia = $_POST['descricaoDeficiencia'];
    $pacienteAlergico     = $_POST['pacienteAlergico'];
    $descricaoAlergia     = $_POST['descricaoAlergia'];
    $sqlPaciente = "UPDATE tb_paciente SET
      condicaosaude_oncolocia='$pacienteOncologico',
      condicaosaude_diabetes='$pacienteDiabetico',
      condicaosaude_hipertensao='$pacienteHipertenso',
      condicaosaude_renalcronico='$pacienteRenalCronico',
      condicaosaude_pcd='$pacientePCD',
      condicaosaude_pcddescricao='$descricaoDeficiencia',
      condicaosaude_alergia='$pacienteAlergico',
      condicaosaude_alergiadescricao='$descricaoAlergia',
      usuarioregistrou_condicaodesaude='$idUsuarioLogado',
      datahoraregistrou_condicaodesaude='$dataHoraHoje'
    WHERE id_paciente='$idPaciente'";
    $stmPaciente = $rsConexao->prepare($sqlPaciente);
    $stmPaciente->execute();
    # -- --------------------------------------- -- #

    

    # ----- validar existência de solicitação pendente ----- #
    /*if ($idSolicitacao == "" || ($idProcedimentoEditado!="" && $idProcedimentoEditado!=$nomeProcedimento)) {
      $sqlExiste  = "SELECT COUNT(id_solicitacao) AS totalSolicitacoes FROM reg_tb_solicitacoes WHERE (id_statussolicitacao=1 OR id_statussolicitacao=2 OR 
      id_statussolicitacao=3 OR id_statussolicitacao=9 OR id_statussolicitacao=10) AND (id_procedimento='$nomeProcedimento' AND id_paciente='$idPaciente')";
      $stmExiste  = $rsConexao->prepare($sqlExiste);
      $stmExiste->execute();
      $rsExiste   = $stmExiste->fetch(PDO::FETCH_OBJ);
      if ($rsExiste->totalSolicitacoes > 0) {
        echo "JáExiste";
        exit;
      }
    }*/
    # ----- ----- ----- ----- ----- ----- ----- ----- ------ #
    if ($idSolicitacao == "") {
      $tipoMovimento      = "INCLUSÃO";
      $sqlSolicitatao = "INSERT INTO reg_tb_solicitacoes(
        id_paciente,
        cid_solicitacao,
        codigoprofissional_cnes,
        solicitacao_retorno,
        id_grupo_procedimento,
        id_procedimento,
        observacoes_solicitacao,
        id_statussolicitacao,
        id_classificacaorisco,
        id_usuario_cadastrou,
        id_unidade_cadastrou,
        datahora_cadastro,
        token_solicitacao
      )VALUES(
        :setIdPaciente,
        :setCidSolicitacao,
        :setProfissionalSolicitante,
        :setSolicitacaoRetorno,
        :setGrupoProcedimento,
        :setIdProcedimento,
        :setObservacaoSolicitacao,
        :setStatusSolicitacao,
        :setClassificacaoRisco,
        :setUsuarioLogado,
        :setUnidadeLogada,
        :setDataHoraHoje,
        :setTokenSolicitacao
      )";
    } else {
      $tipoMovimento  = "ALTERAÇÃO";
      $sqlSolicitatao = "UPDATE reg_tb_solicitacoes SET
        id_paciente=:setIdPaciente,
        cid_solicitacao=:setCidSolicitacao,
        codigoprofissional_cnes=:setProfissionalSolicitante,
        solicitacao_retorno=:setSolicitacaoRetorno,
        id_grupo_procedimento=:setGrupoProcedimento,
        id_procedimento=:setIdProcedimento,
        observacoes_solicitacao=:setObservacaoSolicitacao,
        id_statussolicitacao=:setStatusSolicitacao,
        id_classificacaorisco=:setClassificacaoRisco,
        id_usuario_alterou=:setUsuarioLogado,
        data_ultima_alteracao=:setDataHoraHoje,
        token_solicitacao=:setTokenSolicitacao
        WHERE id_solicitacao='$idSolicitacao'
      ";
    }


    $stmSolicitatao = $rsConexao->prepare($sqlSolicitatao);
    $stmSolicitatao->bindParam(":setIdPaciente", $idPaciente, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setCidSolicitacao", $cidSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setProfissionalSolicitante", $profissionalSolicitante, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setSolicitacaoRetorno", $solicitacaoRetorno, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setGrupoProcedimento", $grupoProcedimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setIdProcedimento", $idProcedimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setObservacaoSolicitacao", $observacaoSolicitacao, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setClassificacaoRisco", $classificacaoPrioridade, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);    
    $stmSolicitatao->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
    $stmSolicitatao->bindParam(":setTokenSolicitacao", $tokenSolicitacao, PDO::PARAM_STR);
    if ($idSolicitacao == "") {
      $stmSolicitatao->bindParam(":setUnidadeLogada", $idUnidadeLogada, PDO::PARAM_STR);      
    }    
    $stmSolicitatao->execute();

    if ($idSolicitacao == "") {
      $ultimoIdSolicitacao  = $rsConexao->lastInsertId();
    } else {
      $ultimoIdSolicitacao  = $idSolicitacao;
    }
    
    #---- GERAR NÚMERO DO PROTOCOLO -----#
    $idUsuarioLogado  = $_SESSION['idUsuarioLogado'];
    $dataHoraHoje     = date("Y-m-d H:i");
    $idPaciente       = $_POST['idPaciente'];
    
    if ($idSolicitacao == "") {
      $numeroProtocolo      = date("Ym") . str_pad($ultimoIdSolicitacao, 4, "0", STR_PAD_LEFT);
      $stmAtualizaProtocolo = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET numero_procotolo='$numeroProtocolo' WHERE id_solicitacao='$ultimoIdSolicitacao'");
      $stmAtualizaProtocolo->execute();
    } else {
      $numeroProtocolo  = $_POST['numeroProtocolo'];
    }
    echo $ultimoIdSolicitacao . "##" . $numeroProtocolo;
  
    # - anexar procedimentos de laboratório à solicitação - #
    $procedimentoSelecionado  = $_POST['procedimentoSelecionado'];
    $contarProceimentos       =  count($procedimentoSelecionado);
    $calcularLoop             = 0;
    $idProcedimentoLab        = "";

    # -- limpar lista de procedimentos de laboratório -- #
    $stmLimparLaboratorio = $rsConexao->prepare("DELETE FROM reg_tb_solicitacoes_laboratorio WHERE id_solicitacao='$ultimoIdSolicitacao'");
    $stmLimparLaboratorio ->execute();    
    for ($contaReg = 0; $contaReg < $contarProceimentos; $contaReg++){
      $idProcedimentoLab = $procedimentoSelecionado[$contaReg];
      $stmGravarProcedimento = $rsConexao->prepare("INSERT INTO reg_tb_solicitacoes_laboratorio(id_solicitacao,id_procedimento_solicitado)VALUES('$ultimoIdSolicitacao','$idProcedimentoLab')");
      $stmGravarProcedimento ->execute();
    }
    $gerarHistorico = "S";
  break;

}


#-------------REGISTRAR HISTÓRICO DA MOVIMENTAÇÃO-------------#
if ($gerarHistorico == "S") {
  $sqlMovimento = "INSERT INTO reg_tb_solicitacoes_historico(
      id_solicitacao,
      datahora_registro,
      texto_movimentacao,
      id_statussolicitacao,
      idusuario_registrou
    )VALUES(
      :setIdSolicitacao,
      :setDataHoraHoje,
      :setTextoMovimento,
      :setStatusSolicitacao,
      :setUsuarioLogado
    )";
  $stmMovimento = $rsConexao->prepare($sqlMovimento);
  $stmMovimento->bindParam(":setIdSolicitacao", $ultimoIdSolicitacao, PDO::PARAM_STR);
  $stmMovimento->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
  $stmMovimento->bindParam(":setTextoMovimento", $tipoMovimento, PDO::PARAM_STR);
  $stmMovimento->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
  $stmMovimento->bindParam(":setUsuarioLogado", $idUsuarioLogado, PDO::PARAM_STR);
  $stmMovimento->execute();
}
#-------------------------------------------------------------#
?>