<?php
session_start();
require("../../database/dbConection.php");
require("../include/funcoes_gsaudereg.php");
$usuarioLogado    = $_SESSION['idUsuarioLogado'];
$ibgeSedeSistema  = $_SESSION['ibgeSedeSistema'];
$htmlReultado     = "";

switch ($_POST['opcaoProcessamento']) {

  case "processar-arquivo":
    // Pegar características do arquivo anexado
    $arquivoParaImportacao  = $_FILES['arquivoParaImportacao'];
    $tipoArquivo  = $arquivoParaImportacao["type"];
    $arquivoTemp  = $arquivoParaImportacao["tmp_name"];
    $arquivoImportado = "temp/" . removerAcentos($arquivoParaImportacao["name"]);

    if ($tipoArquivo != "application/x-zip-compressed") {
      echo "erro##Tipo de arquivo inválido. Você deve carregar o arquivo em formato ZIP que contenha os arquivo TXT do CNES.";
      exit;
    }

    if (move_uploaded_file($arquivoTemp, $arquivoImportado)) {

      $zipCNES = new ZipArchive;
      if ($zipCNES->open($arquivoImportado) === TRUE) {
        $zipCNES->extractTo("temp");
        $zipCNES->close();
      } else {
        echo "erro##Arquivo ZIP inválido. Selecione o arquivo correto!";
        exit;
      }
      $arquivoEstabelecimento = "temp/LFCES004.txt";
      $arquivoProfissional    = "temp/LFCES018.txt";
      $arquivoVinculo         = "temp/LFCES021.txt";
      $arquivoSUS             = "temp/LFCES032.txt";

      # -- limpar tabelas temporárias -- #
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_estabelecimento");
      $stmLimparTemp ->execute();
      $stmLimparTemp ->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_profissional");
      $stmLimparTemp ->execute();
      $stmLimparTemp->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_profissional_vinculo");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_estabelecimento_sus");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      # -- Processar arquivo de estabelecimentos -- # 

      $contadorLinhas = 0;
      $lerArquivoTXT  = fopen($arquivoEstabelecimento, 'r');
      if ($lerArquivoTXT) {
        while (($registroTXT = fgets($lerArquivoTXT)) !== false) {
          if ($contadorLinhas == 0) {
            $competenciaArquivo = substr($registroTXT, 4, 2) . '/' . substr($registroTXT, 0, 4);
            $dataTXTCNES        = substr($registroTXT, 0, 4) . '-' . substr($registroTXT, 4, 2) . '-01 00:00:00';
            $dataTXTCNES        = new DateTime($dataTXTCNES);
            $dataHoje           = date('Y-m-d H:i:s');
            $dataDirefenca      = new DateTime($dataHoje);
            $validadorCompetencia = $dataTXTCNES->diff($dataDirefenca);
            $totalDiasArquivo     = $validadorCompetencia->days;
            if ($totalDiasArquivo > 150) {
              echo "erro##Os arquivos TXT são da competência $competenciaArquivo. Ou seja, já têm mais de $totalDiasArquivo dias de gerados. Só é possível importar arquivo com no máximo 30 dias.";
              exit;
            }
          } else if ($contadorLinhas >= 1) {
            $ibgeCNES = substr($registroTXT, 0, 6);
            if ($ibgeCNES != $ibgeSedeSistema) {
              echo "erro##O arquivo TXT selecionado não pertence ao CNES do município.";
              exit;
            }
            $idUnidade      = substr($registroTXT, 0, 13);
            $trimCNPJManten = trim(substr($registroTXT, 38, 14));
            $cnpjMantenedor = str_replace(" ", "-", $trimCNPJManten);
            $trimCNPJPrivad = trim(substr($registroTXT, 184, 14));
            $cnpjPrivado    = str_replace(" ", "-", $trimCNPJPrivad);
            $cnesUnidade    = substr($registroTXT, 31, 7);
            $razaoSocial    = substr($registroTXT, 53, 60);
            $nomeFantasia   = substr($registroTXT, 113, 60);
            $cnpjUnidade    = $cnpjMantenedor != "" ? $cnpjMantenedor : $cnpjPrivado;
            $prestadorPrivado = $cnpjMantenedor == "" ? "S" : "N";

            $sqlInsertUnidade = "INSERT IGNORE INTO ztemp_estabelecimento(
                codigoestabelecimento_cnes,
                cnpj_estabelecimento,
                cnes_estabelecimento,
                nempresarial_estabelecimento,
                nfantasia_estabelecimento,
                prestador_privado
              )VALUES(
                '$idUnidade',
                '$cnpjUnidade',
                '$cnesUnidade',
                '$razaoSocial',
                '$nomeFantasia',
                '$prestadorPrivado'
              )";
            $stmInsertUnidade = $rsConexao->prepare($sqlInsertUnidade);
            $stmInsertUnidade->execute();
          }
          $contadorLinhas = $contadorLinhas + 1;
        }
        fclose($lerArquivoTXT);
      }

      # -- Processar arquivo de profissionais -- #    
      $lerArquivoTXT  = fopen($arquivoProfissional, 'r');
      if ($lerArquivoTXT) {
        $contadorLinhas = 0;
        while (($registroTXT = fgets($lerArquivoTXT)) !== false) {
          $contadorLinhas = $contadorLinhas + 1;
          if ($contadorLinhas > 0) {
            $codigoProfissional = substr($registroTXT, 0, 16);
            $cpfProfissional    = substr($registroTXT, 16, 11);
            $cnsProfissional    = substr($registroTXT, 87, 15);
            $nomeProfissional   = substr($registroTXT, 27, 60);

            $sqlInsertProfissional = "INSERT IGNORE INTO ztemp_profissional(
              codigoprofissional_cnes,
              cpf_profissional,
              cns_profissional,
              nome_profissional
            )VALUES(
              '$codigoProfissional',
              '$cpfProfissional',
              '$cnsProfissional',
              '$nomeProfissional'
            )";

            $stmInsertProfissional  = $rsConexao->prepare($sqlInsertProfissional);
            $stmInsertProfissional->execute();
          }
        }
        fclose($lerArquivoTXT);
      }

      # -- Processar arquivo de vinculos -- #    
      $lerArquivoTXT  = fopen($arquivoVinculo, 'r');
      if ($lerArquivoTXT) {
        $contadorLinhas = 0;
        while (($registroTXT = fgets($lerArquivoTXT)) !== false) {
          $contadorLinhas = $contadorLinhas + 1;
          if ($contadorLinhas > 0) {
            $codigoUnidade      = substr($registroTXT, 0, 14);
            $codigoProfissional = substr($registroTXT, 31, 16);
            $codigoCBO          = substr($registroTXT, 47, 6);

            $sqlInsertVinculo = "INSERT IGNORE INTO ztemp_profissional_vinculo(
              codigoestabelecimento_cnes,
              codigoprofissional_cnes,
              codigo_cbo
            )VALUES(
              '$codigoUnidade',
              '$codigoProfissional',
              '$codigoCBO'
            )";
            $stmInsertVinculo = $rsConexao->prepare($sqlInsertVinculo);
            $stmInsertVinculo->execute();
          }
        }
        fclose($lerArquivoTXT);
      }

      # -- Processar arquivo de dados SUS -- #  
      $lerArquivoTXT  = fopen($arquivoSUS, 'r');
      if ($lerArquivoTXT) {
        $contadorLinhas = 0;
        while (($registroTXT = fgets($lerArquivoTXT)) !== false) {
          $contadorLinhas = $contadorLinhas + 1;

          if ($contadorLinhas > 0) {
            $codigoUnidade  = substr($registroTXT, 0, 14);
            $servicoAmbSUS  = substr($registroTXT, 38, 1);
            $servicoHospSUS = substr($registroTXT, 40, 1);
            $unidadeSUS     = ($servicoAmbSUS == 1 || $servicoHospSUS == 1) ? "S" : "N";

            if ($unidadeSUS == "S") {

              $sqlInsertSUS = "INSERT IGNORE INTO ztemp_estabelecimento_sus(
                codigoestabelecimento_cnes
              )VALUES(
                '$codigoUnidade'
              )";
              $stmInsertSUS = $rsConexao->prepare($sqlInsertSUS);
              $stmInsertSUS->execute();
            }
          }
        }
        fclose($lerArquivoTXT);
      }

      # -- Apagar arquivos temporários -- #
      $arquivos = scandir("temp");
      foreach ($arquivos as $arquivo) {
        if ($arquivo != "." && $arquivo != "..") {
          $caminhoCompleto = "temp/" . $arquivo;
          if (is_file($caminhoCompleto)) {
            unlink($caminhoCompleto);
          }
        }
      }

      # -- carregar listagem de estabelecimentos -- #
      $stmEstabelecimentosTemp  = $rsConexao->prepare("SELECT * FROM ztemp_estabelecimento ORDER BY nfantasia_estabelecimento");
      $stmEstabelecimentosTemp->execute();
      if ($stmEstabelecimentosTemp->rowCount() > 0) {
        $rsEstabelecimentosTemp = $stmEstabelecimentosTemp->fetchAll(PDO::FETCH_ASSOC);
        $contarUnidades = 0;
        foreach ($rsEstabelecimentosTemp as $fieldEstabelecimentosTemp) {
          $contarUnidades         = $contarUnidades + 1;
          $codigoEstabelecimento  = $fieldEstabelecimentosTemp['codigoestabelecimento_cnes'];
          $nomeEstabelecimento    = $fieldEstabelecimentosTemp['nfantasia_estabelecimento'];
          $rsNomeEstabelecimento  = $fieldEstabelecimentosTemp['nempresarial_estabelecimento'];
          $cnpjEstabelecimento    = $fieldEstabelecimentosTemp['cnpj_estabelecimento'];
          $cnesEstabelecimento    = $fieldEstabelecimentosTemp['cnes_estabelecimento'];
          $eSetorPrivado          = $fieldEstabelecimentosTemp['prestador_privado'] == "S" ? "SIM" : "NÃO";

          $onChangeSelecionar = 'onchange="selectionaImportaCNES(this.checked,' . "'$codigoEstabelecimento')" . '"';
          $selecionaUnidade = "<input type=checkbox style='height: 25px; width: 25px;	cursor: pointer !important' id='selecionaUnidade$contarUnidades' $onChangeSelecionar>";

          #-- contar profissionais da unidade --
          $sqlProfissionais = "SELECT codigoestabelecimento_cnes, codigoprofissional_cnes
          FROM ztemp_profissional_vinculo
          WHERE codigoestabelecimento_cnes='$codigoEstabelecimento'
          GROUP BY codigoestabelecimento_cnes, codigoprofissional_cnes";
          $stmProfissionais = $rsConexao->prepare($sqlProfissionais);
          $stmProfissionais -> execute();
          $totalProfissionais = $stmProfissionais->rowCount();
          $htmlReultado .= "<tr>
            <td align='center'>
              $selecionaUnidade
            </td>
            <td style='font-size:10pt; width:33%'>
              <b>$nomeEstabelecimento
              <div style='width:auto; padding:2px; color:#027fbe; font-size:9pt'>
                Profissionais vinculados: $totalProfissionais
              </div>
              </b>
            </td>
            <td style='font-size:10pt'>$rsNomeEstabelecimento</td>
            <td style='font-size:10pt; text-align:center'>$cnesEstabelecimento</td>
            <td style='font-size:10pt; text-align:center'>$cnpjEstabelecimento</td>
            <td style='font-size:10pt; text-align:center'>$eSetorPrivado</td>
          </tr>";
        }
      }
      echo "Arquivo TXT processado com sucesso. Selecione os estabelecimentos a serem importados ou atualizados e confirme a importação.##$htmlReultado";
    } else {
      echo "erro##$sqlAtualizaAgendamentos";
    }
    break;

  case "seleciona-estabelecimentos-importar-individual":
    $codigoEstabelecimento  = $_POST['codigoEstabelecimento'];
    $valorSelecao           = $_POST['valorSelecao'];
    $sqlSelecionaEstabelecimento = $rsConexao->prepare("UPDATE ztemp_estabelecimento SET selecionar_importacao='$valorSelecao' WHERE codigoestabelecimento_cnes='$codigoEstabelecimento'");
    $sqlSelecionaEstabelecimento->execute();
    break;

  case "seleciona-estabelecimentos-importar-todos":
    $valorSelecao = $_POST['valorSelecao'];
    $sqlSelecionaEstabelecimento = $rsConexao->prepare("UPDATE ztemp_estabelecimento SET selecionar_importacao='$valorSelecao'");
    $sqlSelecionaEstabelecimento->execute();
    break;


  case "confirmar-importacao":

    # -- ATUALIZAR CADASTRO DA BASE LOCAL -- #       
    # -- estabelecimentos -- #
    $sqlAtualizaUnidade = "UPDATE tb_estabelecimento 
    INNER JOIN ztemp_estabelecimento ON tb_estabelecimento.codigoestabelecimento_cnes = ztemp_estabelecimento.codigoestabelecimento_cnes 
    SET tb_estabelecimento.cnpj_estabelecimento=ztemp_estabelecimento.cnpj_estabelecimento,
    tb_estabelecimento.cnes_estabelecimento=ztemp_estabelecimento.cnes_estabelecimento,
    tb_estabelecimento.nempresarial_estabelecimento=ztemp_estabelecimento.nempresarial_estabelecimento,
    tb_estabelecimento.nfantasia_estabelecimento=ztemp_estabelecimento.nfantasia_estabelecimento,
    tb_estabelecimento.prestador_privado=ztemp_estabelecimento.prestador_privado";
    $stmAtualizaUnidade = $rsConexao->prepare($sqlAtualizaUnidade);
    $stmAtualizaUnidade->execute();

    # -- profissionais -- #
    $sqlAtualizaProfissional = "UPDATE tb_profissional
    INNER JOIN ztemp_profissional ON tb_profissional.codigoprofissional_cnes = ztemp_profissional.codigoprofissional_cnes
    SET tb_profissional.cpf_profissional=ztemp_profissional.cpf_profissional, 
    tb_profissional.cns_profissional=ztemp_profissional.cns_profissional,
    tb_profissional.nome_profissional=ztemp_profissional.nome_profissional";
    $stmAtualizaProfissional = $rsConexao->prepare($sqlAtualizaProfissional);
    $stmAtualizaProfissional->execute();

    # -- INSERIR OS CADASTROS DE UNIDADES, PROFISSIONAIS E VÍNCULOS -- #
    # -- estabelecimentos -- #
    $sqlInserirEstabelecimento = "INSERT IGNORE INTO tb_estabelecimento(
      codigoestabelecimento_cnes,
      cnpj_estabelecimento,
      cnes_estabelecimento,
      nempresarial_estabelecimento,
      nfantasia_estabelecimento,
      prestador_privado,
      origem_cadastro)
      SELECT codigoestabelecimento_cnes,
      cnpj_estabelecimento,
      cnes_estabelecimento,
      nempresarial_estabelecimento,
      nfantasia_estabelecimento,
      prestador_privado,
      'txt-cnes'
      FROM ztemp_estabelecimento
      WHERE selecionar_importacao='S'";
    $stmInserirEstabelecimento  = $rsConexao->prepare($sqlInserirEstabelecimento);
    $stmInserirEstabelecimento  -> execute();

    # -- profissionais -- #
    $sqlInserirProfissional = "INSERT IGNORE INTO tb_profissional(
      codigoprofissional_cnes,
      cpf_profissional,
      cns_profissional,
      nome_profissional,
      datahora_cadastro,
      origem_cadastro)
      SELECT ztemp_profissional.codigoprofissional_cnes,
        ztemp_profissional.cpf_profissional,
        ztemp_profissional.cns_profissional,
        ztemp_profissional.nome_profissional,
        now(),
        'txt-cnes'
      FROM ztemp_profissional
      INNER JOIN ztemp_profissional_vinculo ON (ztemp_profissional.codigoprofissional_cnes =ztemp_profissional_vinculo.codigoprofissional_cnes)
      INNER JOIN ztemp_estabelecimento ON (ztemp_estabelecimento.codigoestabelecimento_cnes = ztemp_profissional_vinculo.codigoestabelecimento_cnes)
      WHERE (ztemp_estabelecimento.selecionar_importacao='S')
      AND (ztemp_profissional_vinculo.codigo_cbo!='515105')
      AND (ztemp_profissional_vinculo.codigo_cbo!='322255')";
    $stmInserirProfissional = $rsConexao->prepare($sqlInserirProfissional);
    $stmInserirProfissional -> execute();

      # -- profissionais -- #
    $sqlInserirVinculo = "INSERT IGNORE INTO tb_profissional_vinculo(
      codigoestabelecimento_cnes,
      codigoprofissional_cnes,
      codigo_cbo,
      origem_cadastro)
      SELECT ztemp_profissional_vinculo.codigoestabelecimento_cnes,
      ztemp_profissional_vinculo.codigoprofissional_cnes,
      ztemp_profissional_vinculo.codigo_cbo,
      'txt-cnes'
      FROM ztemp_estabelecimento
      INNER JOIN ztemp_profissional_vinculo ON (ztemp_estabelecimento.codigoestabelecimento_cnes = ztemp_profissional_vinculo.codigoestabelecimento_cnes)
      WHERE (ztemp_estabelecimento.selecionar_importacao = 'S')
      AND (ztemp_profissional_vinculo.codigo_cbo!='515105')
      AND (ztemp_profissional_vinculo.codigo_cbo!='322255')";
      $stmInserirVinculo = $rsConexao->prepare($sqlInserirVinculo);
      $stmInserirVinculo -> execute();   

    
      # -- limpar tabelas temporárias -- #
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_estabelecimento");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_profissional");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_profissional_vinculo");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      $stmLimparTemp = $rsConexao->prepare("DELETE FROM ztemp_estabelecimento_sus");
      $stmLimparTemp->execute();
      $stmLimparTemp->closeCursor();
      # -- Processar arquivo de estabelecimentos -- # 
    break;
          
}
