<?php
session_start();
if(!isset($_SESSION['idUsuarioLogado'])){
	header("location: ./");
}
include_once("header.php");
require("database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];
/* TRATAS DADOS PARA MOTRAR PACIENTE */
$idPacienteGet = $_GET['idpac'];
$sqlPaciente	= "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente	= $rsConexao->prepare($sqlPaciente);
$stmPaciente	-> execute();
$rsPaciente		= $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente 				= $rsPaciente->id_paciente;
$nomePaciente 			= $rsPaciente->nome_paciente;
$idadePaciente			= $rsPaciente->idadePaciente;
$sexoPaciente				= $rsPaciente->sexo;
$cnsPaciente				= $rsPaciente->cns_paciente;
$municipioPaciente	= $rsPaciente->nome_cidade;
$bairrroPaciente		= $rsPaciente->bairro_paciente;
$ibgeCidade					= $rsPaciente->codigocidade;

//Cor alerta fora de Lauro!
if($ibgeCidade!=$_SESSION['ibgeSedeSistema']){
  $setCorCidade = "style='background-color:#ae0000 !important;color:#fff'";
}else{
  $setCorCidade = "";
}

$formatarOrigem = array(
	'lista_unica'=>'LISTA ÚNICA',
	'policlinica'=>'POLICLÍNICA',
	'sisreg'=>'SISREG',
	'sistema_vida'=>'VIDA+',
);

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-checked" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Agendamento Realizado
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
            <div class="card-content collapse show" style="margin-top: -15px;">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b></h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente;?>" disabled />
                          <input type="hidden" id="idPaciente" value="<?php echo $idPaciente;?>" disabled />
                          <input type="hidden" id="idAgendamento" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cnsPaciente">Cartão SUS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente;?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="municipioPaciente">Município:</label>
                          <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $municipioPaciente;?>" <?php echo $setCorCidade;?> disabled>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="bairroPaciente">Bairro:</label>
                          <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $bairrroPaciente;?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body" style="margin-top: -15px;">
                    <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações do Agendamento Realizado</b></h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="numeroSolicitacao">Nº Solicitação:</label>
                          <input type="text" class="form-control text-center" id="numeroSolicitacao" />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="numeroChave">Nº Chave:</label>
                          <input type="text" class="form-control text-center" id="numeroChave" />
                        </div>
                      </div>                      
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="grupoProcedimento">Grupo:</label>
                          <select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
                            <option value="">SELECIONE GRUPO...</option>
                            <?php
                              if($idPerfilLogado=='6' || $idPerfilLogado=='7'){                                
                                $stmGrupo	= $rsConexao->prepare("SELECT * FROM reg_tb_procedimentos_grupo WHERE disponivel_guiche='S' ORDER BY nome_grupo_procedimento");
                              }else{
                                $stmGrupo	= $rsConexao->prepare("SELECT * FROM reg_tb_procedimentos_grupo ORDER BY nome_grupo_procedimento");
                              }
															$stmGrupo	->execute();
															$rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
															$totalGrupo	= $stmGrupo->rowCount();
															if($totalGrupo>0){
																foreach($rsGrupo as $fieldGrupo){
																	$idGrupo = $fieldGrupo['id_grupo_procedimento'];
																	$nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
																	echo "<option value='$idGrupo'>GRUPO - $nomeGrupo</option>";
																}
															}
														?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="nomeProcedimento">Nome de Procedimentos:</label>
                          <select class="form-control" id="nomeProcedimento">
                            <option value="">SELECIONE O GRUPO...</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top: -15px;">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="origemAgendamento">Origem:</label>
                          <select class="form-control" id="origemAgendamento">
                            <option value="">SELECIONE....</option>
                            <option value="lista_unica">LISTA ÚNICA</option>
                            <option value="policlinica">POLICLÍNICA</option>
                            <option value="sisreg">SISREG</option>
                            <option value="sistema_vida">VIDA</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="dataAtendimento">Data Atendimento:</label>
                          <input type="date" id="dataAtendimento" class="form-control text-center" />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="dataRetirada">Prazo Retirada:</label>
                          <input type="date" id="dataRetirada" class="form-control text-center" />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top: -15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="observacaoAgendamento">Observação:</label>
                          <input type="text" id="observacaoAgendamento" class="form-control" />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-8">
                      <div class="form-group">
                        <button type="button" class="btn btn-info" onClick="salvarProcedimentoAgendado()"><i class="fa fa-check-square-o"></i> Salvar na Lista</button>
                        <button type="button" class="btn btn-danger" id="btnCancelar" onClick="cancelarAlteracao()" disabled><i class="fa fa-times"></i> Cancelar</button>
                        <button type="button" class="btn btn-success" id="btnNovoPaciente" onClick="location.href='paciente_buscar'"><i class="ft-file"></i> Novo Paciente</button>
                      </div>
                    </div>
                  </div>
                  <div class="form-actions" style="margin-top: -15px !important;"></div>
                </form>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top: -55px !important;">
              <div class="card-body card-dashboard">
                <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="dados_procedimentos_listados">
                  <thead>
                    <tr style='background-color:#005186; color:#fff'>
                      <th style="text-align: center !important;" width="10%">OPÇÕES</th>
                      <th align="center" style="width: 100px;">Nº SOLICITAÇÃO</th>
                      <th>PROCEDIMENTO</th>
                      <th style="width: 150px;">ORIGEM</th>
                      <th align="center" style="width: 100px;">ATENDIMENTO</th>
                      <th align="center" style="width: 100px;">RETIRADA</th>
                      <th style="width: 100px;">STATUS</th>
                      <th style="width: 150px;">ÚLTIMO USUÁRIO</th>
                    </tr>
                  </thead>
                  <tbody style="background-color: #ececec;">
                    <?php
                      $sqlDemandas  = "SELECT reg_tb_agendamentos.*, date_format(data_atendimento,'%d/%m/%Y') dataAtendimento, date_format(data_retirada,'%d/%m/%Y') dataRetirada,
                      tb_usuario.nome_usuario AS nomeUsuarioCadastrou, tb_usuario_1.nome_usuario AS nomeUsuarioAlterou, reg_tb_procedimento.nome_procedimento FROM reg_tb_agendamentos 
                      INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento) 
                      INNER JOIN tb_usuario ON (reg_tb_agendamentos.id_usuario_cadastrou = tb_usuario.id_usuario)
                      LEFT OUTER JOIN tb_usuario tb_usuario_1 ON (tb_usuario_1.id_usuario = reg_tb_agendamentos.id_usuario_alterou) WHERE id_paciente='$idPaciente'";
                      $stmDemandas  = $rsConexao->prepare($sqlDemandas);
                      $stmDemandas  ->execute();
                      $rsDemandas = $stmDemandas->fetchAll(PDO::FETCH_ASSOC);
                      $totalRegistros	= $stmDemandas->rowCount();
                        
                      if($totalRegistros > 0){
                        foreach($rsDemandas as $fieldDemanda){
                          $idAgendamento			= $fieldDemanda['id_agendamento'];
                          $numeroSolicitacao	= mb_strtoupper($fieldDemanda['numero_solicitacao']);
                          $nomeProcedimento		= mb_strtoupper($fieldDemanda['nome_procedimento']);
                          $sistemaOrigem			= $formatarOrigem[$fieldDemanda['origem_agendamento']];
                          $dataAtendimento		= $fieldDemanda['dataAtendimento'];
                          $dataRetirada				= $fieldDemanda['dataRetirada'];
                          $statusAgendamento	= mb_strtoupper($fieldDemanda['status_agendamento']);
                          $dataEditar					= mb_strtoupper($fieldDemanda['data_retirada']);
                          
                          if(date("Y-m-d")>$dataEditar){
                            $backgroundColor = "style='background-color:#860000; color:#fff !important'";
                          }else{
                            $backgroundColor = "";
                          }

                          if($fieldDemanda['id_usuario_alterou']==""){
                            $ultimoUsuario = $fieldDemanda['nomeUsuarioCadastrou'];
                          }else{
                            $ultimoUsuario = $fieldDemanda['nomeUsuarioAlterou'];
                          }

                          if($statusAgendamento=="AGENDADO" || $statusAgendamento=="CONFIRMADO" || $statusAgendamento=="CANCELAR"){
                            $linkEditarAgendamento		= '"editarAgendamento(' . "'$idAgendamento')" . '"';
                            $comandoEditarAgendamento =" <i class='icofont icofont-edit nova_fonte' title='Editar registro de procedimento agendado.'  onclick=$linkEditarAgendamento></i>&nbsp;";

                            $linkExcluirAgendamento		= '"excluirAgendamento(' . "'$idAgendamento')" . '"';
                            $comandoExcluirAgendamento	= "<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de procedimento agendado.'  onclick=$linkExcluirAgendamento></i>&nbsp;";
                          }else{
                            $comandoEditarAgendamento		= "N/A";
                            $comandoExcluirAgendamento	= "";
                          }

                          if($fieldDemanda['observacoes_demanda']!=""){
                            $linkVerObservacao	= '"verObservacaoRegistroAgendamento(' . "'$idAgendamento')" . '"';
                            $linkVerObservacao	= "<i class='icofont icofont-info-square nova_fonte' title='Ver Observação.'  onclick=$comandoEditarAgendamento></i>";
                          }else{
                            $linkVerObservacao	= "&nbsp&nbsp&nbsp&nbsp&nbsp";
                          }
                          echo "<tr>
                            <td style='text-align:center'>
                              $comandoEditarAgendamento
                              $comandoExcluirAgendamento
                            </td>	
                            <td align='center'>$numeroSolicitacao</td>
                            <td>$nomeProcedimento</td>
                            <td>$sistemaOrigem</td>
                            <td align='center'>$dataAtendimento</td>
                            <td align='center' $backgroundColor>$dataRetirada</td>
                            <td align='center'>$statusAgendamento</td>
                            <td>$ultimoUsuario</td>
                          </tr>";
                        }
                      }  
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<?php
  include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>        
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
$("#liCadastroDemanda"). attr('class', 'active');
$("#liCadastroDemanda").css("border-bottom", "2px solid #c4c8ca");	
function salvarProcedimentoAgendado(){

	var idPaciente						= $("#idPaciente").val();
	var idAgendamento					= $("#idAgendamento").val();
	var numeroSolicitacao			= $("#numeroSolicitacao").val();
  var numeroChave           = $("#numeroChave").val();
	var grupoProcedimento			= $("#grupoProcedimento").val();
	var nomeProcedimento			= $("#nomeProcedimento").val();
	var origemAgendamento			= $("#origemAgendamento").val();
	var dataAtendimento				= $("#dataAtendimento").val();
	var dataRetirada					= $("#dataRetirada").val();
	var observacaoAgendamento	= $("#observacaoAgendamento").val();

	if(grupoProcedimento == "" || nomeProcedimento == "" || origemAgendamento=="" || dataAtendimento=="" && dataRetirada==""){
		swal("Dados Obrigatórios","Você deve preencher todos os dados do agendamento.", "error");
		return false;
	}		

		$("#embacado").css("display","block");

		$.ajax({				

  	  url: 'action/gravar_agendamento',
    	type: 'post',
    	dataType: 'html',
    	data: {
				'idPaciente'						: idPaciente,				
				'idAgendamento'					: idAgendamento,
				'numeroSolicitacao'			: numeroSolicitacao,
        'numeroChave'           : numeroChave,
				'grupoProcedimento'			: grupoProcedimento,
				'nomeProcedimento'			: nomeProcedimento,
				'origemAgendamento'			: origemAgendamento,
				'dataAtendimento'				: dataAtendimento,
				'dataRetirada'					: dataRetirada,
				'observacaoAgendamento'	: observacaoAgendamento
			}
			
  	}).done(function(resultadoRetorno){     

			$("#embacado").css("display","none");
			var mensagemRetorno = "";

			if(resultadoRetorno=="JaExisteData"){
				swal("Registro Existente","Já existe um registro de agendamento desse paciente com o mesmo procedimento na mesma data.", "info");		
				return false;
			}else if(resultadoRetorno=="JaExisteNumeroSolicitacao"){
				mensagemRetorno = "ATENÇÃO! O Procedimento foi registrado na lista do paciente. Mas favor observar que existe outro procedimento registrado "
				swal("Registro Existente","Já existe um registro de agendamento com o número de solicitação informado.", "info");		
			}else{

				retornoResultado = resultadoRetorno.split("##");
				$('#dados_procedimentos_listados').DataTable().destroy();
    		$('#dados_procedimentos_listados tbody').empty().append(retornoResultado[1]);
  			$('#dados_procedimentos_listados').DataTable();
				$("#idAgendamento").val('');
				$("#numeroSolicitacao").val('');
        $("#numeroChave").val('');
				$("#nomeProcedimento").val('');
				$("#origemAgendamento").val('');
				$("#dataAtendimento").val('');
				$("#dataRetirada").val('');
				$("#observacaoAgendamento").val('');
					if(retornoResultado[0]=="JaExisteProcedimento"){
					swal("Registro Existente","ATENÇÃO! O Procedimento foi registrado na lista do paciente. Mas, favor observar que existe outro procedimento registrado na mesma data de atendimento.", "warning");														
					}
			}

  	});

}

function editarAgendamento(idAgendamento){
	$("#embacado").css("display","block");
	$.ajax({				
		url: 'filtros/buscar_dados_edicao',
		type: 'post',
		dataType: 'html',
		data: {
			'opcaoBusca'		:	'editar-agendamento',
			'idAgendamento'	: idAgendamento
		}
	}).done(function(resultadoRetorno){     

		var objetoJson = JSON.parse(resultadoRetorno);
		
		$("#idAgendamento").val(idAgendamento);
		$("#numeroSolicitacao").val(objetoJson['numeroSolicitacao']);
    $("#numeroChave").val(objetoJson['numeroChave']);
		$("#grupoProcedimento").val(objetoJson['grupoProcedimento']);
		$("#origemAgendamento").val(objetoJson['origemAgendamento']);
		$("#dataAtendimento").val(objetoJson['dataAtendimento']);
		$("#dataRetirada").val(objetoJson['dataRetirada']);
		$("#observacaoAgendamento").val(objetoJson['observacaoAgendamento']);
		$("#btnCancelar").prop('disabled',false);
		$("#grupoProcedimento").trigger("change");
		setTimeout(function(){ 
			$("#nomeProcedimento").val(objetoJson['nomeProcedimento']);
		}, 1000);
		
		$("#embacado").css("display","none");
	});	

}

function cancelarAlteracao(){
	$("#idAgendamento").val('');
	$("#numeroSolicitacao").val('');
	$("#grupoProcedimento").val('');
	$("#nomeProcedimento").html("<option value=''>SELECIONE O GRUPO...</option>");
	$("#origemAgendamento").val('');
	$("#dataAtendimento").val('');
	$("#dataRetirada").val('')
	$("#observacaoAgendamento").val('');	
	$("#btnCancelar").prop('disabled',true);
}

function verObservacaoRegistroAgendamento(idDemandaReprimida){

	$.ajax({				
		url: 'action/ver_observacaoAgendamento',
		type: 'post',
		dataType: 'html',
		data: {
			'idDemandaReprimida'	: idDemandaReprimida
		}

	}).done(function(retornoResultado){     
		swal("Observação Registrada",retornoResultado, "info");	
	});

}

function excluirAgendamento(idDemandaReprimida){

	swal({
		
		title: "Exclusão de Registro",
    text: "Confirma exclusão do procedimento do registro de agendamentos?",
    icon: "../app-assets/images/question.png",
  
		buttons:{
			confirm: {
       	text: "Sim, Confirmar!",
        value: true,
        visible: true,
        className: "btn-success",
        closeModal: false
      },
      cancel:{
       	text: "Não, Foi engano!",
        value: null,
        visible: true,
        className: "btn-danger",
        closeModal: false,
      }								
	  }

	}).then((isConfirm) => {

			if (isConfirm) {	
				$.ajax({				
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao'				: 'procedimento_agendamento',
						'idRegistroExclusao'	: idDemandaReprimida,
						'idPaciente'					: $("#idPaciente").val()
					}
				}).done(function(resultadoRetorno){     	
					$('#dados_procedimentos_listados').DataTable().destroy();
    			$('#dados_procedimentos_listados tbody').empty().append(resultadoRetorno);
  				$('#dados_procedimentos_listados').DataTable();
					swal("Exclusão de Registro.", "Procedimento excluído com sucesso.", "info");
				});

		  } else {
		    swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
		  }

	});  	

}

function filtrarProcedimentos(){

$("#embacado").css("display","block");

$.ajax({
	url: 'filtros/filtrar_procedimento',
	type: 'post',
	dataType: 'html',
	data: {
		'opcaoPesquisa'			: 'cadastrar-agendamento',
		'grupoProcedimento'	: $("#grupoProcedimento").val()
	}
}).done(function(resultadoRetorno){
	$("#nomeProcedimento").html("");
	$("#nomeProcedimento").html(resultadoRetorno);
	$("#embacado").css("display","none");		
});

}
</script>