<?php
session_start();

$dataHoraImpressao  = date("d/m/Y H:i");
/************************************************************************************/
require("../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$idAgendamento      = $_SESSION['idAgendamento'];

$tamanhoEtiqueta    = [79,150];

$sqlAgendamento = "SELECT reg_tb_agendamentos.*,
date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
reg_tb_procedimento.nome_procedimento,
tb_estabelecimento.nfantasia_estabelecimento,
tb_estabelecimento.endereco_estabelecimento,
tb_estabelecimento.numeroend_estabelecimento,
tb_estabelecimento.bairro_estabelecimento,
tb_estabelecimento.pontoreferencia_estabelecimento,
tb_cidades.nome_cidade,
tb_estabelecimento.telefone1_estabelecimento,
tb_profissional.nome_profissional,
tb_paciente.nome_paciente,
tb_paciente.nomemae,
tb_paciente.cns_paciente,
tb_paciente.cpf_paciente,
date_format(tb_paciente.datanasc, '%d/%m/%Y') AS nascimentoPaciente,
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente,
tb_paciente.sexo,
tb_paciente.datanasc,
tb_paciente.celular1,
tb_paciente.celular2,
tb_paciente.celular3,
reg_tb_procedimento.preparo_procedimento
FROM reg_tb_agenda
INNER JOIN reg_tb_agendamentos ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN tb_cidades ON (tb_cidades.codigoibge_cidade = tb_estabelecimento.codigoibge_cidade)
INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente) 
WHERE (reg_tb_agendamentos.id_agendamento='$idAgendamento')";

$stmAgendamento = $rsConexao->prepare($sqlAgendamento);
$stmAgendamento ->execute();  
$rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);

$codigoChave          = $rsAgendamento->chave_confirmacao;
$numeroProtocolo      = $rsAgendamento->protocolo_agendamento;
$dataAtendimento      = $rsAgendamento->dataAtendimento;
$horaAtendimento      = $rsAgendamento->horario_atendimento.'h.';
$nomeUnidade          = mb_strtoupper($rsAgendamento->nfantasia_estabelecimento);
$enderecoUnidade      = mb_strtoupper($rsAgendamento->endereco_estabelecimento . ", " . $rsAgendamento->numeroend_estabelecimento . " - " . $rsAgendamento->pontoreferencia_estabelecimento);
$bairroUnidade        = mb_strtoupper($rsAgendamento->bairro_estabelecimento);
$nomeProfissional     = mb_strtoupper($rsAgendamento->nome_profissional);
$nomePaciente         = $rsAgendamento->nome_paciente;
$cnsPaciente          = $rsAgendamento->cns_paciente;
$idadePaciente        = $rsAgendamento->nascimentoPaciente . " ($rsAgendamento->idadePaciente anos)";
$telefonePaciente     = $rsAgendamento->celular1.' - '.$rsAgendamento->celular2.' - '.$rsAgendamento->celular3;
$nomeMae              = $rsAgendamento->nomemae;
$nomeProcedimento     = mb_strtoupper($rsAgendamento->nome_procedimento);
$preparoProcedimento  = mb_strtoupper($rsAgendamento->preparo_procedimento);
$textoCancelado       = ($rsAgendamento->status_agendamento == "A" || $rsAgendamento->status_agendamento == "E" || $rsAgendamento->status_agendamento == "P") ? "" : "text-decoration: line-through";

ob_start();

include_once("include/php-qrcode/vendor/autoload.php");
$urlSiteCentralMarcacao = "https://regulacaomunicipal.pmlf.ba.gov.br";
$setQRCode      = (new \chillerlan\QRCode\QRCode())->render($urlSiteCentralMarcacao);

echo "
<table class='tb_protocolo' style='margin-top:-15px '>
  <tr>
    <td style='font-size:8pt; padding-left:5px'>
      <b>CHAVE:</b> <font style='$textoCancelado'>$codigoChave<br></font>
      <b>PROTOCOLO:</b> <font style='$textoCancelado'>$numeroProtocolo</font>
    </td>
  </tr>  
</table><br>
<table class='tb_protocolo' style='margin-top:-15px'>
  <tr>
    <td style='font-size:10pt; padding-left:5px;'>
      <b>DATA DO ATENDIMENTO:</b> <font style='$textoCancelado'>$dataAtendimento<br></font>
      <b>HORÁRIO:</b> <font style='$textoCancelado'>$horaAtendimento</font>
    </td>
  </tr>  
</table><br>
<table class='tb_protocolo' style='margin-top:-15px'>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:9pt; font-weight: bold;'>UNIDADE EXECUTANTE:</font><br>
      <font style='font-size:8pt; font-weight: normal;'>
        $nomeUnidade
      </font><br>
      <font style='font-size:8pt; font-weight: normal;'>
      <b>Endereço:</b> $enderecoUnidade, $bairroUnidade
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:9pt; font-weight: bold;'>PROFISSIONAL EXECUTANTE:</font><br>
      <font style='font-size:8pt; font-weight: normal;'>
        $nomeProfissional
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:9pt; font-weight: bold;'>DADOS DO PACIENTE:</font><br>
      <font style='font-size:8pt; font-weight: normal;'>
        Nome: $nomePaciente<br>
        Nascimento: $idadePaciente<br>
        CNS: $cnsPaciente<br>
        Telefone: $telefonePaciente<br>
        Mãe/Resp: $nomeMae<br>
      </font><br>
    </td>
  </tr>  
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:9pt; font-weight: bold;'>PROCEDIMENTO AGENDADO:</font><br>
      <font style='font-size:8pt; font-weight: normal; $textoCancelado'>
        $nomeProcedimento
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:9pt; font-weight: bold;'>PREPARO PARA O PROCEDIMENTO:</font><br>
      <font style='font-size:8pt; font-weight: normal;'>
        $preparoProcedimento
      </font><br>
    </td>
  </tr>  
</table><br>
<table class='tb_protocolo' style='margin-top:-15px; border:0px'>
  <tr>
    <td style='font-size:7pt; padding-left:5px'>  
    </td>
  </tr>  
</table>";
require_once '../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
	'margin_left'   => 3,
	'margin_right'  => 3,
	'margin_top'    => 14.5,
	'margin_header' => 2.5,  
  'margin_bottom' => 1,
  'mode'          => 'utf-8',
  'default_font'  => 'tahoma',
  'format'        => $tamanhoEtiqueta
]);
$nomeMunicipioSede = $_SESSION['nomeMunicipioSede'];
$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorios/relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_protocolo'>
    <tr>
		  <td class='titulo_protocolo' style='font-size:8pt'>
        PREFEITURA DE $nomeMunicipioSede<br>
        SECRETARIA DE SAÚDE<br>
        REGULAÇÃO MUNICIPAL
      </td>
    </tr>
    </table>";

$header;
$footer = "<table style='width:100%; font-size:8pt; font-weight: bold;'>
  <tr>
    <td>G-Saúde</td>
    <td align='right'>Impresso em: $dataHoraImpressao</td>
  </tr>
</table>";
$mpdf->SetHTMLHeader($header);
$mpdf->SetFooter($footer);
$mpdf->SetTitle('Impressão de Agendamento');
$mpdf->WriteHTML($html);
$mpdf->Output("ImpressaoAgendamento$numeroProtocolo.pdf",'I');
exit;