<?php
session_start();
$servername_mysql   = "localhost";
$username_mysql     = "portalgsaude_gestor";
$password_mysql     = "CGm57KsElcsmagalhaes";
$database_mysql     = "portalgsaude_gsaude_candeias";

try {
  $conn_mysql = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
  $conn_mysql->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  die("Connection failed: " . $e->getMessage());
}

if (!function_exists('formataCNS')) {
  function formataCNS($numeroCNS)
  {
    $numeroInicio = substr($numeroCNS, 0, 3);
    $numeroMeio1  = substr($numeroCNS, 3, 4);
    $numeroMeio2  = substr($numeroCNS, 7, 4);
    $numeroMeio3  = substr($numeroCNS, 11, 4);
    return $numeroInicio . ' ' . $numeroMeio1 . ' ' . $numeroMeio2 . ' ' . $numeroMeio3;
  }
}

require_once '../../../lib_sistemas/mpdf8/vendor/autoload.php';
$dataHoraImpressao = date("d/m/Y H:i");
$tamanhoEtiqueta = [79, 150];
$mpdf = new \Mpdf\Mpdf([
  'margin_left'   => 12,
  'margin_right'  => 12,
  'margin_top'    => 35,
  'margin_header' => 12,
  'margin_bottom' => 2.5,
  'mode'          => 'utf-8',
  'default_font'  => 'tahoma',
  'format'        => 'A4'
]);


if (isset($_GET['id'])) {
  $idsAgendamento = json_decode($_GET['id'], true);
  if ($idsAgendamento === null) {
    $idsAgendamento = [$_GET['id']];
  }

  foreach ($idsAgendamento as $currentIndex => $idAgendamento) {
    $idAgendamento = preg_replace('/[^0-9]/', '', $idAgendamento);
    $sql = "SELECT reg_tb_agendamentos.*,
                date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
                reg_tb_procedimento.nome_procedimento,
                tb_estabelecimento.nfantasia_estabelecimento,
                tb_estabelecimento.endereco_estabelecimento,
                tb_estabelecimento.numeroend_estabelecimento,
                tb_estabelecimento.bairro_estabelecimento,
                tb_estabelecimento.pontoreferencia_estabelecimento,
                tb_cidades.nome_cidade,
                tb_estabelecimento.telefone1_estabelecimento,
                tb_profissional.nome_profissional,
                tb_paciente.nome_paciente,
                tb_paciente.nomemae,
                tb_paciente.cns_paciente,
                tb_paciente.cpf_paciente,
                date_format(tb_paciente.datanasc, '%d/%m/%Y') AS nascimentoPaciente,
                TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente,
                tb_paciente.sexo,
                tb_paciente.datanasc,
                tb_paciente.celular1,
                tb_paciente.celular2,
                tb_paciente.celular3,
                reg_tb_procedimento.preparo_procedimento
                FROM reg_tb_agenda
                INNER JOIN reg_tb_agendamentos ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
                INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
                INNER JOIN tb_cidades ON (tb_cidades.codigoibge_cidade = tb_estabelecimento.codigoibge_cidade)
                INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
                INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
                INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente) 
                WHERE reg_tb_agendamentos.id_agendamento=:idAgendamento";
    $stmAgendamento = $conn_mysql->prepare($sql);
    $stmAgendamento->bindParam(':idAgendamento', $idAgendamento, PDO::PARAM_INT);
    $stmAgendamento->execute();
    $rsAgendamento = $stmAgendamento->fetch(PDO::FETCH_OBJ);

    if ($rsAgendamento) {
      ob_start();

      $codigoChave          = $rsAgendamento->chave_confirmacao;
      $numeroProtocolo      = $rsAgendamento->protocolo_agendamento;
      $dataAtendimento      = $rsAgendamento->dataAtendimento;
      $horaAtendimento      = $rsAgendamento->horario_atendimento;
      $nomeUnidade          = $rsAgendamento->nfantasia_estabelecimento;
      $enderecoUnidade      = $rsAgendamento->endereco_estabelecimento . ", " . $rsAgendamento->numeroend_estabelecimento . " - " . $rsAgendamento->pontoreferencia_estabelecimento;
      $bairroUnidade        = $rsAgendamento->bairro_estabelecimento;
      $nomeProfissional     = $rsAgendamento->nome_profissional;
      $nomePaciente         = $rsAgendamento->nome_paciente;
      $cnsPaciente          = formataCNS($rsAgendamento->cns_paciente);
      $idadePaciente        = $rsAgendamento->nascimentoPaciente . " ($rsAgendamento->idadePaciente anos)";
      $telefonePaciente     = $rsAgendamento->celular1 . ' - ' . $rsAgendamento->celular2 . ' - ' . $rsAgendamento->celular3;
      $nomeMae              = $rsAgendamento->nomemae;
      $nomeProcedimento     = mb_strtoupper($rsAgendamento->nome_procedimento);
      $preparoProcedimento  = mb_strtoupper($rsAgendamento->preparo_procedimento);
      $textCancelado        = ($rsAgendamento->status_agendamento == "A" || $rsAgendamento->status_agendamento == "E") ? "" : "text-decoration: line-through";
      include_once("../include/php-qrcode/vendor/autoload.php");
      $urlSiteCentralMarcacao = "https://regulacaomunicipal.pmlf.ba.gov.br";
      $setQRCode      = (new \chillerlan\QRCode\QRCode())->render($urlSiteCentralMarcacao);

      echo "
<table style='background-color:#e7e7e7; width:100%;'>
  <tr>
    <td style='font-size:12pt; font-weight: bold; padding:3px; text-align:center'>
      DADOS DO PACIENTE
    </td>
  </tr>
</table>
<div class='dados-agendamento-A4'>
  <table width='100%'>
    <tr>
      <td>
        <b>Nome:</b> $nomePaciente
      </td>
      <td align='right' width='190px'>
        <b>CNS:</b> $cnsPaciente
      </td>
    </tr>
  </table>
  <table width='100%'>
    <tr>
      <td>
        <b>Nascimento/Idade: </b> $idadePaciente
      </td>
      <td align='right'>
        <b>Mãe/Resp:</b> $nomeMae
      </td>
    </tr>
  </table> 
  <table width='100%'>
    <tr>
      <td>
        <b>Telefone(s) para contato:</b> $telefonePaciente
      </td>
    </tr>
  </table>    
</div>
<table style='background-color:#e7e7e7; width:100%;'>
  <tr>
    <td style='font-size:12pt; font-weight: bold; padding:3px; text-align:center'>
      DADOS DO AGENDAMENTO
    </td>
  </tr>
</table>
<table class='tb_protocolo'>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>UNIDADE EXECUTANTE:</font><br>
      <font style='font-size:10pt; font-weight: normal;'>
        $nomeUnidade
      </font><br>
      <font style='font-size:10pt; font-weight: normal;'>
      <b>Endereço:</b> $enderecoUnidade, $bairroUnidade
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>PROFISSIONAL EXECUTANTE:</font><br>
      <font style='font-size:10pt; font-weight: normal;'>
        $nomeProfissional
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>PROCEDIMENTO AGENDADO:</font><br>
      <font style='font-size:10pt; font-weight: normal; $textCancelado'>
        $nomeProcedimento
      </font><br>
    </td>
  </tr>
</table><br>
<table style='width:100%; margin-top:-15px; border-bottom:2px dotted '>
  <tr>
    <td style='font-size:14pt; text-align:center'>
      <font style='font-size:14pt'><b>DATA DO ATENDIMENTO</b><br></font>
      <font style='$textCancelado;font-size:14pt'>
        $dataAtendimento
      </font>    
    </td>
  </tr>
  <tr>
    <td style='font-size:14pt; text-align:center'>
      <font style='font-size:14pt'><b>HORÁRIO</b><br></font>
      <font style='$textCancelado'>
        $horaAtendimento
      </font>        
    </td>        
  </tr>
</table>
<table style='width:100%; border-bottom:2px dotted '>
  <tr>
    <td style='font-size:12pt; padding:10px;'>
      <table>
        <tr>
          <td>
            <b>CHAVE:</b>
          </td>
          <td>
            <font style='$textCancelado'>$codigoChave<br></font>
          </td>
        </tr>
        <tr>
          <td>
            <b>PROTOCOLO:</b>
          </td>
          <td>
            <font style='$textCancelado'>$numeroProtocolo</font>
          </td>
        </tr>
      </table>
    </td>
  </tr>  
</table><br>
<table class='tb_protocolo' style='margin-top:-15px; border:0px'>
  <tr>
    <td style='font-size:11pt; padding:5px; background-color:#e7e7e7; border-bottom: 1px dotted'>
      <b>Preparo e outras informações:</b>
    </td>
  </tr>
  <tr>
    <td style='padding:5px; text-align:justify'>
      <font style='font-size:10pt; font-weight: normal;'>
        $preparoProcedimento
      </font>        
    </td>
  </tr>
</table>";
      $header = "
    <table align='center' class='tb_protocolo'>
        <tr>
            <td style='text-align:center; width:100px'>
                <img src='../../app-assets/images/brasao-prefeitura.png' height='80px'>
            </td>
            <td class='titulo_protocolo' style='border-left:0px; border-right:0px; text-align:left; font-size:13pt'>
                CANDEIAS-BA<br>
                SECRETARIA DE SAÚDE<br>
                REGULAÇÃO MUNICIPAL
            </td>
            <td style='text-align:center; width:100px; padding-right:10px'>
                <img src='../css/images/logo-dark.png' height='60px'>
            </td>      
        </tr>
    </table>";

      $footer = "<table style='width:100%; font-size:8pt; font-weight: bold;'>
    <tr>
        <td>G-Saúde</td>
        <td align='right'>Impresso em: $dataHoraImpressao</td>
    </tr>
    </table>";
      $mpdf->SetHTMLHeader($header, 'O');
      $mpdf->SetHTMLFooter($footer, 'O');
      $html = ob_get_clean();
      $mpdf->mirrorMargins = 1;
      $stylesheet = file_get_contents('relatorio.css');
      $mpdf->WriteHTML($stylesheet, 1);
      $mpdf->WriteHTML($html);
      if ($currentIndex < count($idsAgendamento) - 1) {
        $mpdf->AddPage();
      }
    }
  }
  $cnsPacienteSalvar  = str_replace(" ","",$cnsPaciente);
  $mpdf->Output("ComprovanteAgendamentoCNS_".$cnsPacienteSalvar.".pdf", 'F');
  exit;
}
