<?php
include_once("config_bd.php");


try {
    $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


    $idMenuAvaliacaoBot = $_GET['id_menuavaliacaobot'] ?? '';
    $nomeUsuarioAvaliou = $_GET['nomeusuario_avaliou'] ?? '';
    $telefoneUsuarioAvaliou = $_GET['telefoneusuario_avaliou'] ?? '';


    $explodeTelefone = explode("@", $telefoneUsuarioAvaliou);
    $telefoneDocumentoUsuario = $explodeTelefone[0] ?? '';

    
    $observacaoDigitada = 'Nao opinou';
    if (isset($_GET['observacao'])) {
        if ($_GET['observacao'] === '1') {
            $observacaoDigitada = $_GET['observacao_digitada'] ?? '';
        }
    }


    $insertQuery = "
        INSERT INTO reg_tb_avaliacao_bot (
            id_menuavaliacaobot, nomeusuario_avaliou, telefoneusuario_avaliou, observacao_digitada, datahora_registro
        ) VALUES (
            :id_menuavaliacaobot, :nomeusuario_avaliou, :telefoneusuario_avaliou, :observacao_digitada, NOW()
        )
    ";

    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':id_menuavaliacaobot', $idMenuAvaliacaoBot, PDO::PARAM_INT);
    $stmt->bindParam(':nomeusuario_avaliou', $nomeUsuarioAvaliou, PDO::PARAM_STR);
    $stmt->bindParam(':telefoneusuario_avaliou', $telefoneDocumentoUsuario, PDO::PARAM_STR);
    $stmt->bindParam(':observacao_digitada', $observacaoDigitada, PDO::PARAM_STR);
    $stmt->execute();

    $response = [
        'status' => 'success',
        'message' => 'Dados inseridos com sucesso!'
    ];

    echo json_encode($response);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Erro: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['error' => 'Erro: ' . $e->getMessage()]);
}
?>
