<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-chart-pie" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Cotas para Agendamento
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" style='margin-top:-10px'>
                  <div class="form-body">
                    <h4 class="form-section"><i class="icofont icofont-edit"></i> <b>Informações para pesquisa</b>
                      <input type='hidden' id="idCotaUnidade" disabled>
                    </h4>
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="unidadeSolicitante">Unidade Solicitante:</label>
                          <select id="unidadeSolicitante" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <?php
                            $sqlUnidadeSolicitante = "SELECT codigoestabelecimento_cnes,
                              nfantasia_estabelecimento
                              FROM tb_estabelecimento
                              WHERE (perfil_estabelecimento = 'S' OR perfil_estabelecimento = 'A')
                              AND (respeita_cota = 'S')
                              ORDER BY nfantasia_estabelecimento";
                            $stmUnidadeSolicitante = $rsConexao->prepare($sqlUnidadeSolicitante);
                            $stmUnidadeSolicitante->execute();
                            if ($stmUnidadeSolicitante->rowCount() > 0) {
                              $rsUnidadeSolicitante = $stmUnidadeSolicitante->fetchAll(PDO::FETCH_ASSOC);
                              foreach ($rsUnidadeSolicitante as $fieldUnidade) {
                                $codigoUnidade  = $fieldUnidade['codigoestabelecimento_cnes'];
                                $nomeUnidade    = $fieldUnidade['nfantasia_estabelecimento'];
                                echo "<option value='$codigoUnidade'>$nomeUnidade</option>";
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="grupoProcedimentoCota">Grupo / Procedimento:</label>
                          <select id="grupoProcedimentoCota" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <?php
                            # -- carregar grupos -- #
                            $sqlGrupo = "SELECT reg_tb_tetounidade.id_grupo_procedimento,
															reg_tb_procedimento_grupo.nome_grupo_procedimento
															FROM reg_tb_tetounidade
															INNER JOIN reg_tb_procedimento_grupo ON (reg_tb_tetounidade.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
															WHERE (reg_tb_tetounidade.id_grupo_procedimento!=1)
															GROUP BY reg_tb_procedimento_grupo.nome_grupo_procedimento
															ORDER BY reg_tb_procedimento_grupo.nome_grupo_procedimento ASC";
                            $stmGrupo = $rsConexao->prepare($sqlGrupo);
                            $stmGrupo->execute();
                            if ($stmGrupo->rowCount() > 0) {
                              $rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
                              echo "<optgroup label='GRUPOS:'>";
                              foreach ($rsGrupo as $fieldGrupo) {
                                $idGrupo  = $fieldGrupo['id_grupo_procedimento'];
                                $nomeGrupo  = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
                                echo "<option value='GRUPO##$idGrupo'>$nomeGrupo</option>";
                              }
                              echo "</optgroup>";

                              # -- carregar procedimentos -- #
                              $sqlProcedimento = "SELECT reg_tb_tetounidade.id_procedimento,
																reg_tb_procedimento.nome_procedimento
																FROM reg_tb_tetounidade 
																INNER JOIN reg_tb_procedimento ON (reg_tb_tetounidade.id_procedimento = reg_tb_procedimento.id_procedimento)
																GROUP BY reg_tb_procedimento.nome_procedimento
																ORDER BY reg_tb_procedimento.nome_procedimento ASC";

                              $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
                              $stmProcedimento->execute();
                              if ($stmProcedimento->rowCount() > 0) {
                                $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                echo "<optgroup label='PROCEDIMENTOS:'>";
                                foreach ($rsProcedimento as $fieldProcedimento) {
                                  $idProcedimento   = $fieldProcedimento['id_procedimento'];
                                  $nomeProcedimento = mb_strtoupper($fieldProcedimento['nome_procedimento']);
                                  echo "<option value='PROCEDIMENTO##$idProcedimento'>$nomeProcedimento</option>";
                                }
                                echo "</optgroup>";
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="unidadeExecutante">Unidade Executante:</label>
                          <select id="unidadeExecutante" class="form-control">
                            <option value=''>SELECIONE...</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="tetoDisponivel">Saldo / Teto:</label>
                          <input class="form-control-personalizado text-center" id="tetoDisponivel" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="percentualCota">% Alocado:</label>
                          <input type="text" class="form-control text-right" id="percentualCota" placeholder="0,0" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="quantidadeCota">Quantidade/Valor:</label>
                          <input type="text" class="form-control text-center" id="quantidadeCota" disabled>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="tipoAnaliseCota">Tipo de Análise:</label>
                          <select id="tipoAnaliseCota" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='mensal'>MENSAL</option>
                            <option value='semanal'>SEMANAL</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label>&nbsp;</label><br>
                          <button type="button" class="btn btn-info" onClick="salvarCota()">
                            <i class="icofont icofont-checked"></i> Confirmar
                          </button>
                          <button type="button" class="btn btn-danger" id="btnCancelar" disabled>
                            <i class="fa fa-times"></i> Cancelar
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="form-actions" style="margin-top:-15px !important"></div>
                    <div class="row" style='margin-top:-40px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                            <div class="media align-items-stretch">
                              <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                              </div>
                              <div class="media-body p-1" style='padding:10px !important; padding-left:10px !important; font-family:Arial, Helvetica, sans-serif'>
                                <strong>ATENÇÃO! Ao selecionar o tipo de análise SEMANAL, o sistema considerará a cota do mês divindindo-a por quatro desconsiderando finais de semana.</strong>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row" style='margin-top:-20px;'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <input type='hidden' id='tipoApuracao'>
                          <table class="table table-striped table-bordered default-ordering" id='dados_cotaunidade'>
                            <thead>
                              <tr>
                                <th style='text-align:center' width='80px'>OPÇÕES</th>
                                <th>GRUPO/PROCEDIMENTO</th>
                                <th>UNIDADE EXECUTANTE</th>
                                <th style='text-align:center' width='20px'>%</th>
                                <th style='text-align:center' width='50px'>QUANTIDADE</th>
                                <th width='150px'>TIPO DE ANÁLISE</th>
                              </tr>
                            </thead>
                            <tbody style="background-color:#ececec">
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" onClick="gravarCota()" id="gravarCota"><i class="icofont icofont-checked"></i> Confirmar</button>
  <button type='button' class='btn btn-warning' id='btnVoltar' onClick='voltarAgendamentoDireto()' style='width:100px'>
    <i class='ft-log-out botaoOk'></i> Voltar
  </button>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liCotas").attr('class', 'active');
  $("#liCotas").css("border-bottom", "2px solid #c4c8ca");

  $('#dados_cotaunidade').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });


  $("#unidadeSolicitante").change(function() {
    $("#grupoProcedimentoCota").val('');
    $("#grupoProcedimentoCota").trigger('change');
    $("#tetoDisponivel").val('');
    $("#percentualCota").val('');
    $("#quantidadeCota").val('');
    $("#tipoAnaliseCota").val('');
    $("#percentualCota").prop("disabled", true);

    if (this.value != "") {
      $.ajax({
        url: 'filtros/filtrar_registrocota',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoFiltroCota': 'pegar-cotascadastrada',
          'idUnidade': this.value
        }
      }).done(function(resultadoRetorno) {
        $('#dados_cotaunidade').DataTable().destroy();
        $('#dados_cotaunidade tbody').empty().append(resultadoRetorno);
        $('#dados_cotaunidade').DataTable({
          "paging": false,
          "filter": false,
          "lengthChange": false,
          "info": false
        });
      });
    } else {
      $('#dados_cotaunidade').DataTable().destroy();
      $('#dados_cotaunidade tbody').empty().append();
      $('#dados_cotaunidade').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
    }

  });

  $("#grupoProcedimentoCota").change(function() {

    var procedimentoSelecionado = this.value.split("##");
    var itemPtocedimentoSelecionado = procedimentoSelecionado[0];
    var idProcedimentoGrupo = procedimentoSelecionado[1];

    if (this.value != "") {
      if ($("#unidadeSolicitante").val() == "") {
        swal("Solicitante Obrigatório", "Você deve informar o solicitante antes de selecionar o procedimento.", "error");
        $("#grupoProcedimentoCota").val('');
        return false;
      }
      $.ajax({
        url: 'filtros/filtrar_unidadesaude',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoFiltro': 'unidade-executante-cota',
          'idUnidade': $("#unidadeSolicitante").val(),
          'itemPtocedimentoSelecionado': itemPtocedimentoSelecionado,
          'idProcedimentoGrupo': idProcedimentoGrupo,
          'tipoAnaliseCota': $("#tipoAnaliseCota").val()
        }
      }).done(function(resultadoRetorno) {
        $("#unidadeExecutante").html(resultadoRetorno);
      });
    } else {
      $("#unidadeExecutante").html("<option value=''>SELECIONE...</option>");
    }
    $("#tetoDisponivel").val('');
    $("#percentualCota").val('');
    $("#quantidadeCota").val('');
    $("#tipoAnaliseCota").val('');
    $("#percentualCota").prop("disabled", true);
  });

  $("#unidadeExecutante").change(function() {

    var procedimentoSelecionado = $("#grupoProcedimentoCota").val().split("##");
    var itemPtocedimentoSelecionado = procedimentoSelecionado[0];
    var idProcedimentoGrupo = procedimentoSelecionado[1];

    if (this.value != "") {
      $.ajax({
        url: 'filtros/filtrar_registrocota',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoFiltroCota': 'pegar-tetoalocado',
          'idUnidade': this.value,
          'itemPtocedimentoSelecionado': itemPtocedimentoSelecionado,
          'idProcedimentoGrupo': idProcedimentoGrupo
        }
      }).done(function(resultadoRetorno) {
        var retornoResultado = resultadoRetorno.split("##")
        $("#tipoApuracao").val(retornoResultado[0]);
        $("#tetoDisponivel").val(retornoResultado[1]);
        $("#percentualCota").prop("disabled", false);
      });
    } else {
      $("#tetoDisponivel").val('');
      $("#tetoDisponivel").val('');
      $("#percentualCota").prop("disabled", true);
    }
    $("#tetoDisponivel").val('');
    $("#percentualCota").val('');
    $("#quantidadeCota").val('');
    $("#tipoAnaliseCota").val('');
  });

  $("#percentualCota").blur(function() {

    if (this.value != "" && parseInt(this.value) != 0) {
      var percentualCota = this.value;
      percentualCota = percentualCota.replace(".", "");
      percentualCota = parseFloat(percentualCota.replace(",", "."));
      var splitTetoDisponivel = $("#tetoDisponivel").val().split(" / ");
      tetoExistente = parseFloat(splitTetoDisponivel[1]);
      tetoDisponivel = parseFloat(splitTetoDisponivel[0]);
      var cotaCalculada = parseInt((percentualCota / 100) * tetoExistente);
      if (cotaCalculada > tetoDisponivel) {
        $("#quantidadeCota").val('');
        swal("Cota Inválida", "O percentual informado [" + this.value + "] representa um cota de [" + cotaCalculada + "] que é superior ao teto disponível.", "error");
        $("#percentualCota").val('');
        return false;
      }
      $("#quantidadeCota").val(cotaCalculada);
    } else {
      $("#quantidadeCota").val('');
    }

  })

  function salvarCota() {


    if (($("#quantidadeCota").val() == "" || $("#quantidadeCota").val() == 0 || $("#quantidadeCota").val() == "0,0") || $("#tipoAnaliseCota").val() == "") {
      swal("Dados Obgigatórios", "Você deve informar a cota que deve ser atribuída e o tipo de análise para salvar o registro.", "error");
      return false;
    }

    var procedimentoSelecionado = $("#grupoProcedimentoCota").val().split("##");
    var itemPtocedimentoSelecionado = procedimentoSelecionado[0];
    var idProcedimentoGrupo = procedimentoSelecionado[1];

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_cota',
      type: 'post',
      dataType: 'html',
      data: {
        'idCotaUnidade': $("#idCotaUnidade").val(),
        'idUnidadeSolicitante': $("#unidadeSolicitante").val(),
        'idUnidadeExecutante': $("#unidadeExecutante").val(),
        "procedimentoSelecionado": procedimentoSelecionado,
        "itemPtocedimentoSelecionado": itemPtocedimentoSelecionado,
        'idProcedimentoGrupo': idProcedimentoGrupo,
        'tetoDisponivel': $("#tetoDisponivel").val(),
        'percentualCota': $("#percentualCota").val(),
        'quantidadeCota': $("#quantidadeCota").val(),
        'tipoAnaliseCota': $("#tipoAnaliseCota").val(),
        'tipoApuracao': $("#tipoApuracao").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");

      if (resultadoRetorno == "JáExiste") {
        swal("Cota já Existe", "Já existe uma cota cadastrada do procedimento selecionado para a unidade solicitante na mesma unidade executante.", "error");
        return false;
      }

      if (resultadoRetorno == "saldoInsuficiente") {
        swal("Saldo Insufiente", "A cota alocada para o mesmo procedimento ultrapasa o saldo disponível a unidade.", "error");
        return false;
      }
      $('#dados_cotaunidade').DataTable().destroy();
      $('#dados_cotaunidade tbody').empty().append(resultadoRetorno);
      $('#dados_cotaunidade').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
    });

  }

  function calcularCota(idCalcular) {
    var calcularQuantidade = 0;
    var totalUnidades = $("#dados_cotaunidade").dataTable().fnSettings().fnRecordsTotal();
    var contadorLinhas = 0;
    var cotaQuantidade = 0;
    var totalTetoCalculo = parseInt($("#totalTetoCalculo").val());

    for (contadorLinhas = 1; contadorLinhas <= totalUnidades - 1; contadorLinhas++) {
      cotaQuantidade = $("#idCotaDigitada" + contadorLinhas).val() != "" ? parseInt(cotaQuantidade) + parseInt($("#idCotaDigitada" + contadorLinhas).val()) : cotaQuantidade;
    }
    if (cotaQuantidade > totalTetoCalculo) {
      $("#gravarCota").prop("")
      swal("Total Invalido", "O total alocado em cotas não pode ser superior ao teto geral.", 'error');
      return false;
    }
    $("#totalAlocadoCota").html("TOTAL: " + cotaQuantidade);

  }

  function excluirCota(idCota, idUnidade) {

    swal({
      title: "Exclusão de Registro",
      text: "Confirma exclusão do registro selecionado?",
      icon: "../app-assets/images/question.png",

      buttons: {
        confirm: {
          text: "Sim, Confirmar!",
          value: true,
          visible: true,
          className: "btn-success",
          closeModal: false
        },
        cancel: {
          text: "Não, Foi engano!",
          value: null,
          visible: true,
          className: "btn-danger",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'cota-unidadde',
            'idRegistroExclusao': idCota,
            'idUnidade': idUnidade
          }
        }).done(function(resultadoRetorno) {

          $('#dados_cotaunidade').DataTable().destroy();
          $('#dados_cotaunidade tbody').empty().append(resultadoRetorno);
          $('#dados_cotaunidade').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          swal("Exclusão de Registro", "Registro do cota excluído com sucesso.", "success");
          $("#embacado").css("display", "none");

        });

      } else {
        swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
      }

    });

  }

  function editarCota(idCota) {
    $("#embacado").css("display", "block");

    $.ajax({
      url: 'filtros/buscar_dados_edicao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoBusca': 'dados-cota-unidade',
        'idCota': idCota
      }
    }).done(function(resultadoRetorno) {
      var objetoJson = JSON.parse(resultadoRetorno);
      $("#idCotaUnidade").val(idCota);
      $("#grupoProcedimentoCota").val(objetoJson['grupoProcedimento'])
      $("#grupoProcedimentoCota").trigger("change");
      setTimeout(function() {
        $("#unidadeExecutante").val(objetoJson['unidadExecutante']);
        $("#tetoDisponivel").val(objetoJson['saldoTeto']);
        $("#percentualCota").val(objetoJson['percentualCota']);
        $("#quantidadeCota").val(objetoJson['quantidadeCota']);
        $("#tipoAnaliseCota").val(objetoJson['tipoAnalise']),
        $("#percentualCota").prop("disabled",false);
        $("#btnCancelar").prop("disabled",false);
        $("#percentualCota").focus();
        $("#embacado").css("display", "none");
      }, 1000);  
    });
  }

  $("#btnCancelar").click(function(){
    $("#grupoProcedimentoCota").val('')
    $("#grupoProcedimentoCota").trigger("change");
    $("#grupoProcedimentoCota").focus();
  })

  $('#percentualCota').mask('#.##0,0', {
    reverse: true
  });
</script>