<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$formatarPerfil = array(
	'A'	=> 'AMBOS',
	'E'	=> 'EXECUTANTE',
	'S'	=> 'SOLICITANTE',
	''	=> 'NÃO INFORMADO'
);

$ibgeEstabelecimento = $_SESSION['ibgeSedeSistema'];
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-hospital" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Estabelecimento de Saúde
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body novo-padding-cardbody">
								<div class="row">
									<div class="col-md-12">
										<ul class="nav nav-tabs nav-topline">
											<li class="nav-item">
												<a class="nav-link active" id="base-dadosEstabelecimento" data-toggle="tab" aria-controls="dadosEstabelecimento" href="#dadosEstabelecimento" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DO ESTABELECIMENTO&nbsp;&nbsp;</b></a>
											</li>
											<li class="nav-item">
												<a class="nav-link" id="base-profissionaisVinculados" data-toggle="tab" aria-controls="profissionaisVinculados" href="#profissionaisVinculados" aria-expanded="true"><b><i class="icofont icofont-doctor"></i><i class="icofont icofont-nurse" style='margin-lefT:-5px'></i> PROFISSIONAIS VINCULADOS&nbsp;&nbsp;</b></a>
											</li>
											<li class="nav-item">
												<a class="nav-link" id="base-usuariosAtivos" data-toggle="tab" aria-controls="usuariosAtivos" href="#usuariosAtivos" aria-expanded="true">
													&nbsp;&nbsp;<b><i class="icofont icofont-users" style='margin-lefT:-5px'></i> USUÁRIO ATIVOS&nbsp;&nbsp;</b>
												</a>
											</li>
										</ul>
										<div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
											<div role="tabpanel" class="tab-pane active" id="dadosEstabelecimento" aria-expanded="true" aria-labelledby="base-dadosEstabelecimento">
												<form class="form" style='margin-top:-10px'>
													<div class="form-body">
														<h4 class="form-section"><i class="icofont icofont-edit"></i><b>Dados de Idetificação</b>
															<input type="hidden" id="codigoEstabelecimento">
															<input type="hidden" id="ibgeEstabelecimento" value="<?php echo $ibgeEstabelecimento; ?>">
														</h4>
													</div>
													<div class="row">
														<div class="col-md-3">
															<div class="form-group">
																<fieldset id='field-cnpj'>
																	<label for="cnpjEstabelecimento">CNPJ:</label>
																	<div class="input-group">
																		<input type="text" id="cnpjEstabelecimento" class="form-control text-center cnpj-inputmask" onblur="validaCNPJ(this.id)" autofocus>
																		<div class="input-group-prepend">
																			<button class="btn btn-blue" type="button" onClick="pesquisarCNPJ(cnpjEstabelecimento.value)" title="Consultar CNPJ na Receita Federal"><i class="ft-search"></i></button>
																		</div>
																	</div>
																</fieldset>
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="razaoSocialEstabelecimento">Razão Social:</label>
																<input type="text" id="razaoSocialEstabelecimento" class="form-control" disabled>
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="nomeFantasiaEstabelecimento">Nome Fantasia:</label>
																<input type="text" id="nomeFantasiaEstabelecimento" class="form-control">
															</div>
														</div>
														<div class="col-md-2">
															<div class="form-group">
																<label for="cnesEstabelecimento">Nº do CNES:</label>
																<input type="text" id="cnesEstabelecimento" class="form-control text-center" maxlength="7">
															</div>
														</div>
													</div>
													<h4 class="form-section" style='margin-top:-5px'>
														<i class="icofont icofont-location-pin"></i><b>Localização e Contato</b>
													</h4>
													<div class="row">
														<div class="col-md-2">
															<div class="form-group">
																<label for="cepEstabelecimento">CEP:</label>
																<input type="text" id="cepEstabelecimento" class="form-control text-center cep-inputmask">
															</div>
														</div>
														<div class="col-md-5">
															<div class="form-group">
																<label for="enderecoEstabelecimento">Endereço:</label>
																<input type='text' id="enderecoEstabelecimento" class="form-control">
															</div>
														</div>
														<div class="col-md-2">
															<div class="form-group">
																<label for="numeroEstabelecimento">Nº:</label>
																<input type='text' id="numeroEstabelecimento" class="form-control text-center">
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="bairroEstabelecimento">Bairro:</label>
																<input type='text' id="bairroEstabelecimento" class="form-control">
															</div>
														</div>
													</div>
													<div class="row">
														<div class="col-md-6">
															<div class="form-group">
																<label for="complementoEstabelecimento">Referência:</label>
																<input type='text' id="complementoEstabelecimento" class="form-control">
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="telefoneEstabelecimento1">Telefone 1:</label>
																<input type="text" id="telefoneEstabelecimento1" class="form-control text-center fonecelular-inputmask">
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="telefoneEstabelecimento2">Telefone 2:</label>
																<input type="text" id="telefoneEstabelecimento2" class="form-control text-center fonecelular-inputmask">
															</div>
														</div>
													</div>
													<div class="row">
														<div class="col-md-6">
															<div class="form-group">
																<label for="emailEstabelecimento">E-Mail:</label>
																<input type="email" id="emailEstabelecimento" class="form-control text-lowercase">
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="latitudeEstabelecimento">Latitude:</label>
																<input type='text' id="latitudeEstabelecimento" class="form-control text-center localizacaogeo-inputmask">
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="longitudeEstabelecimento">Longitude:</label>
																<input type='text' id="longitudeEstabelecimento" class="form-control text-center localizacaogeo-inputmask">
															</div>
														</div>
													</div>
													<h4 class="form-section" style='margin-top:-15px'>
														<i class="icofont icofont-building-alt"></i><b>Catacterísticas do Estabelecimento</b>
													</h4>
													<div class="row" style='margin-top:-5px'>
														<div class="col-md-8">
															<div class="form-group">
																<table width='100%'>
																	<tr>
																		<td style='width:200px'>
																			<label for="prestadorPrivado">Credenciado?</label><br>
																			<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																				<input type="checkbox" class="switch" id="prestadorPrivado" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" />
																			</div>
																		</td>
																		<td style='width:200px'>
																			<label for="postoDescentralizado">Mostrar no Site?</label><br>
																			<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																				<input type="checkbox" class="switch" id="postoDescentralizado" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" />
																			</div>
																		</td>
																		<td>
																			<label for="nomeAbreviadoEstabelecimento">Nome Abreviado (<b>Como aparecerá no site</b>):</label><br>
																			<input type='text' id="nomeAbreviadoEstabelecimento" class="form-control-personalizado" disabled>
																		</td>
																	</tr>
																</table>
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="perfilEstabelecimento">Perfil de Acesso:</label>
																<select id="perfilEstabelecimento" class="form-control">
																	<option value=''>SELECIONE...</option>
																	<option value='A'>AMBOS</option>
																	<option value='E'>EXECUTANTE</option>
																	<option value='S'>SOLICITANTE</option>
																</select>
															</div>
														</div>
													</div>
													<div class="row" style='margin-top:-5px'>
														<div class="col-md-3">
															<div class="form-group">
																<label for="respeitaCotaEstabelecimento">Respeirta Cota:</label>
																<select id="respeitaCotaEstabelecimento" class="form-control">
																	<option value='NA'>NÃO SE APLICA</option>
																	<option value='N'>NÃO</option>
																	<option value='S'>SIM</option>
																</select>
															</div>
														</div>
														<div class="col-md-3">
															<div class="form-group">
																<label for="usaPainelSenha">Usa Painel de Senha:</label>
																<select id="usaPainelSenha" class="form-control">
																	<option value=''>SELECIONE...</option>
																	<option value='S'>SIM</option>
																	<option value='N'>NÃO</option>
																</select>
															</div>
														</div>
														<div class="col-md-6">
															<label></label><br>
															<button type="button" class="btn btn-info" onClick="cadastrarEstabelecimento()">
																<i class="icofont icofont-checked"></i> Confirmar
															</button>
															<button type="button" class="btn btn-danger" id="btnCancelar" onClick="cancelarAlteracao()" disabled>
																<i class="fa fa-times"></i> Cancelar
															</button>
														</div>
													</div>
													<hr>
													<div class="row" style='margin-top:-5px'>
														<div class="col-md-12">
															<div class="form-group">
																<table class="table table-striped table-bordered default-ordering" id='dados_estabelecimentos'>
																	<thead>
																		<th style='text-align:center' width='100px'>OPÇÕES</th>
																		<th>NOME DO ESTABELECIMENTO</th>
																		<th style='text-align:center' width='150px'>Nº CNES</th>
																		<th style='text-align:center' width='150px'>TELEFONE(S)</th>
																		<th style='text-align:center' width='150px'>BAIRRO/LOCALIDADE</th>
																		<th style='text-align:center' width='150px'>PERFIL DE ACESSO</th>
																		</tr>
																	</thead>
																	<tbody style="background-color:#ececec">
																		<?php
																		$stmEstabelecimentos  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
																		$stmEstabelecimentos->execute();
																		$rsEstabelecimentos		= $stmEstabelecimentos->fetchAll(PDO::FETCH_ASSOC);
																		foreach ($rsEstabelecimentos as $fieldEstabelecimentos) {
																			$codigoEstabelecimento				= $fieldEstabelecimentos['codigoestabelecimento_cnes'];
																			$nomeFantasiaEstabelecimento	= mb_strtoupper($fieldEstabelecimentos['nfantasia_estabelecimento']);
																			$cnesEstabelecimento					= $fieldEstabelecimentos['cnes_estabelecimento'];
																			$telefoneEstabelecimento			= $fieldEstabelecimentos['telefone1_estabelecimento'] != "" ? $fieldEstabelecimentos['telefone1_estabelecimento'] : "";
																			$telefoneEstabelecimento			= $fieldEstabelecimentos['telefone2_estabelecimento'] != "" ? $telefoneEstabelecimento . "<br>" . $fieldEstabelecimentos['telefone2_estabelecimento'] : $telefoneEstabelecimento;
																			$statusEstabelecimento				= mb_strtoupper($fieldEstabelecimentos['status_estabelecimento']);
																			$styloRegistroDesativado			= $fieldEstabelecimentos['status_estabelecimento'] == "A" ? "" : "style='background-color: #ffadad;color: #860000;'";
																			$bairroEstabelecimento				= mb_strtoupper($fieldEstabelecimentos['bairro_estabelecimento']);
																			$perfilEstabelecimento				= $formatarPerfil[$fieldEstabelecimentos['perfil_estabelecimento']];
																			$prestadorPrivado							= mb_strtoupper($fieldEstabelecimentos['prestador_privado']);

																			$linkEditarCadastro	= '"editarEstabelecimento(' . "'$codigoEstabelecimento')" . '"';
																			if ($fieldEstabelecimentos['status_estabelecimento'] == "A") {
																				$linkComandoBloqueio	= '"statusEstabelecimento(' . "'$codigoEstabelecimento','desativar')" . '"';
																				$btnComandoBloqueio		= "<i class='icofont icofont-close-squared nova_fonte_delete' title='Desativar registro do estabelecimento.' onclick=$linkComandoBloqueio></i>&nbsp;";
																			} else {
																				$linkComandoBloqueio	= '"statusEstabelecimento(' . "'$codigoEstabelecimento','ativar')" . '"';
																				$btnComandoBloqueio		= "<i class='icofont icofont-checked nova_fonte_blue' style='font-size:16pt' title='ativar registro do estabelecimento.' onclick=$linkComandoBloqueio></i>&nbsp;";
																			}
																			if ($prestadorPrivado != "S") {
																				$linkComandoSetor	= '"window.open(' . "'cadastrar_estabelecimento_setor?id=$codigoEstabelecimento')" . '"';
																				$btnComandoSetor	.= "<i class='icofont icofont-architecture-alt nova_fonte blue' title='Setores do estabelecimento.' onclick=$linkComandoSetor></i>";
																			} else {
																				$btnComandoSetor	= "";
																			}

																			if(($fieldEstabelecimentos['perfil_estabelecimento']== "A" || $fieldEstabelecimentos['perfil_estabelecimento']== "S") && $prestadorPrivado != "S") {
																				$linkUnidadeReferencia = '"window.open(' . "'cadastrar_estabelecimento_unidaderef?id=$codigoEstabelecimento')" . '"';
																				$btnUnidadeReferencia	= "<i class='icofont icofont-building-alt nova_fonte green' style='font-size:13pt' title='Unidades de referência.' onclick=$linkUnidadeReferencia></i>";
																			} else {
																				$btnUnidadeReferencia	 = "";
																			}

																			echo "<tr $styloRegistroDesativado>
																				<td>
																					<i class='icofont icofont-edit nova_fonte' title='Editar registro do estabelecimento.' onclick=$linkEditarCadastro></i>&nbsp;
																					$btnComandoBloqueio
																					$btnComandoSetor
																					$btnUnidadeReferencia
																				</td>
																				<td>$nomeFantasiaEstabelecimento</td>
																				<td align='center'>$cnesEstabelecimento</td>
																				<td align='center'>$telefoneEstabelecimento</td>
																				<td>$bairroEstabelecimento</td>
																				<td>$perfilEstabelecimento</td>
																			</tr>";
																			$btnComandoSetor = "";
																		}
																		?>
																	</tbody>
																</table>
															</div>
														</div>
													</div>
												</form>
											</div>
											<div class="tab-pane" id="profissionaisVinculados" aria-labelledby="base-profissionaisVinculados">
												<form class="form" style='margin-top:-10px'>
													<div class="form-body">
														<h4 class="form-section"><i class="icofont icofont-share"></i><b>Profissionais Vinculados</b>
															<input type="hidden" id="codigoEstabelecimento">
															<input type="hidden" id="ibgeEstabelecimento" value="<?php echo $ibgeEstabelecimento; ?>">
														</h4>
													</div>
													<div class="row" style='margin-top:-20px'>
														<div class="col-md-12">
															<div class="form-group">
																<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_profissionais'>
																	<thead>
																		<tr>
																			<th style='width:60% !important'>NOME PROFISSIONAL</th>
																			<th style='text-align:center; width:10% !important'>CPF</th>
																			<th style='text-align:center; width:10% !important'>CNS</th>
																		</tr>
																	</thead>
																	<tbody style="background-color:#f5f5f5"></tbody>
																</table>
															</div>
														</div>
													</div>
												</form>
											</div>
											<div class="tab-pane" id="usuariosAtivos" aria-labelledby="base-usuariosAtivos">
												<form class="form" style='margin-top:-10px'>
													<div class="form-body">
														<h4 class="form-section"><i class="icofont icofont-users	"></i><b>Usuário ativos vinculados ao estabelecimento</b></h4>
													</div>
													<div class="row" style='margin-top:-20px'>
														<div class="col-md-12">
															<div class="form-group">
																<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_usuarios'>
																	<thead>
																		<tr>
																			<th style='width:70% !important'>NOME DO USUÁRIO ATIVO</th>
																			<th>PERFIL DE ACESSO</th>
																			<th align='center'>TELEFONE</th>
																		</tr>
																	</thead>
																	<tbody style="background-color:#f5f5f5"></tbody>
																</table>
															</div>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liEstabelecimentos").attr('class', 'active');
	$("#liEstabelecimentos").css("border-bottom", "2px solid #c4c8ca");

	$('#dados_profissionais').DataTable({
		"filter": false,
		"lengthChange": false
	});

	$('#dados_estabelecimentos').DataTable({
		'order': [
			[1, 'asc']
		]
	});

	$('#dados_usuarios').DataTable({
		"filter": false,
		"lengthChange": false
	});

	function pesquisarCNPJ(numeroCNPJ) {

		if (numeroCNPJ == "") {
			swal("CNPJ Obrigatório", "Informe o CNPJ que deseja pesquisar.", "info");
			return false;
		}
		$('#processandoDados').html('Aguarde! Consultando Receita Federal...');
		$('#embacado').css('display', 'block');

		$.ajax({
			url: 'filtros/filtrar_empresa_rf',
			type: 'post',
			dataType: 'html',
			data: {
				'numeroCNPJ': numeroCNPJ
			}
		}).done(function(resultadoRetorno) {
			var objetoJson = JSON.parse(resultadoRetorno);
			$('#embacado').css('display', 'none');
			if (objetoJson['mensagemRetorno'] == "erro") {
				swal("CNPJ Inválido", "CNPJ digitado é inválido ou não foi encontrado na receita federal.", "error");
				return false;
			} else {
				$('#razaoSocialEstabelecimento').val(objetoJson['jsonNomeEmpresa']);
				$('#nomeFantasiaEstabelecimento').val(objetoJson['jsonFantasiaEmpresa']);
				$('#cepEstabelecimento').val(objetoJson['jsonCepEmpresa']);
				$('#enderecoEstabelecimento').val(objetoJson['jsonEnderecoEmpresa']);
				$('#numeroEstabelecimento').val(objetoJson['jsonNumeroEnderecoEmpresa']);
				$('#bairroEstabelecimento').val(objetoJson['jsonBairroEmpresa']);
				$('#complementoEstabelecimento').val(objetoJson['jsonComplementoEnderecoEmpresa']);
				$('#telefoneEstabelecimento').val(objetoJson['jsonTelefoneEmpresa']);
				$('#ibgeEstabelecimento').val(objetoJson['ibgeCidadeCNPJ']);
			}

		});

	}

	function cadastrarEstabelecimento() {
		var cnpjEstabelecimento = $("#cnpjEstabelecimento").val();
		var razaoSocialEstabelecimento = $("#razaoSocialEstabelecimento").val();
		var nomeFantasiaEstabelecimento = $("#nomeFantasiaEstabelecimento").val();
		var cnesEstabelecimento = $("#cnesEstabelecimento").val();
		var numeroEstabelecimento = $("#numeroEstabelecimento").val();
		var usaPainelSenha = $("#usaPainelSenha").val();

		if (cnpjEstabelecimento == "" || razaoSocialEstabelecimento == "" || nomeFantasiaEstabelecimento == "" || cnesEstabelecimento == "" || numeroEstabelecimento == "") {
			swal("Dados Obrigatórios", "Você deve preencher as informações de preenchimento obrigatório.", "error");
			return false;
		}

		if ($("#postoDescentralizado").is(':checked') && $("#nomeAbreviadoEstabelecimento").val() == "") {
			swal("Nome Abreviado", "Você deve informar um nome abreviado para o posto descentralizado de marcação.", "error");
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_estabelecimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'cadastrar-estabelecimento',
				'codigoEstabelecimento': $("#codigoEstabelecimento").val(),
				'cnpjEstabelecimento': $("#cnpjEstabelecimento").val(),
				'razaoSocialEstabelecimento': $("#razaoSocialEstabelecimento").val(),
				'nomeFantasiaEstabelecimento': $("#nomeFantasiaEstabelecimento").val(),
				'cnesEstabelecimento': $("#cnesEstabelecimento").val(),
				'cepEstabelecimento': $("#cepEstabelecimento").val(),
				'enderecoEstabelecimento': $("#enderecoEstabelecimento").val(),
				'numeroEstabelecimento': $("#numeroEstabelecimento").val(),
				'bairroEstabelecimento': $("#bairroEstabelecimento").val(),
				'complementoEstabelecimento': $("#complementoEstabelecimento").val(),
				'telefoneEstabelecimento1': $("#telefoneEstabelecimento1").val(),
				'telefoneEstabelecimento2': $("#telefoneEstabelecimento2").val(),
				'emailEstabelecimento': $("#emailEstabelecimento").val(),
				'latitudeEstabelecimento': $("#latitudeEstabelecimento").val(),
				'longitudeEstabelecimento': $("#longitudeEstabelecimento").val(),
				'prestadorPrivado': $("#prestadorPrivado").is(':checked') ? "S" : "N",
				'postoDescentralizado': $("#postoDescentralizado").is(':checked') ? "S" : "N",
				'nomeAbreviadoEstabelecimento': $("#nomeAbreviadoEstabelecimento").val(),
				'perfilEstabelecimento': $("#perfilEstabelecimento").val(),
				'respeitaCotaEstabelecimento': $("#respeitaCotaEstabelecimento").val(),
				'ibgeEstabelecimento': $("#ibgeEstabelecimento").val(),
				'usaPainelSenha': $("#usaPainelSenha").val()
			}
		}).done(function(resultadoRetorno) {

			$("#embacado").css("display", "none");

			if (resultadoRetorno == "JaExiste") {
				swal("Registro Existente", "Já existe um estabelecimento de saúde cadastrado com o CNES informado.", "info");
				return false;
			} else {

				$('#dados_estabelecimentos').DataTable().destroy();
				$('#dados_estabelecimentos tbody').empty().append(resultadoRetorno);
				$('#dados_estabelecimentos').DataTable({
					'order': [
						[1, 'asc']
					]
				});


				$("#codigoEstabelecimento").val('');
				$("#cnpjEstabelecimento").val('');
				$("#razaoSocialEstabelecimento").val('');
				$("#nomeFantasiaEstabelecimento").val('');
				$("#cnesEstabelecimento").val('');
				$("#cepEstabelecimento").val('');
				$("#enderecoEstabelecimento").val('');
				$("#numeroEstabelecimento").val('');
				$("#bairroEstabelecimento").val('');
				$("#complementoEstabelecimento").val('');
				$("#latitudeEstabelecimento").val('');
				$("#longitudeEstabelecimento").val('');
				$("#telefoneEstabelecimento1").val('');
				$("#telefoneEstabelecimento2").val('');
				$("#emailEstabelecimento").val('');
				$("#nomeAbreviadoEstabelecimento").val('');
				$("#perfilEstabelecimento").val('');
				$("#respeitaCotaEstabelecimento").val('NA');
				$("#ibgeEstabelecimento").val('');
				$("#usaPainelSenha").val('');

				$("#postoDescentralizado").prop("checked", false);
				$("#prestadorPrivado").prop("checked", false);
				$('#btnCancelar').prop('disabled', true);
			}

		});

	}

	function editarEstabelecimento(idEstabelecimento) {

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/buscar_dados_edicao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoBusca': 'editar-estabelecimento',
				'idEstabelecimento': idEstabelecimento
			}
		}).done(function(resultadoRetorno) {
			var objetoJson = JSON.parse(resultadoRetorno);
			$("#codigoEstabelecimento").val(idEstabelecimento);
			$("#ibgeEstabelecimento").val(objetoJson['ibgeEstabelecimento']);
			$("#cnpjEstabelecimento").val(objetoJson['cnpjEstabelecimento']);
			$("#razaoSocialEstabelecimento").val(objetoJson['razaoSocialEstabelecimento']);
			$("#nomeFantasiaEstabelecimento").val(objetoJson['nomeFantasiaEstabelecimento']);
			$("#cnesEstabelecimento").val(objetoJson['cnesEstabelecimento']);
			$("#cepEstabelecimento").val(objetoJson['cepEstabelecimento']);
			$("#enderecoEstabelecimento").val(objetoJson['enderecoEstabelecimento']);
			$("#numeroEstabelecimento").val(objetoJson['numeroEstabelecimento']);
			$("#bairroEstabelecimento").val(objetoJson['bairroEstabelecimento']);
			$("#complementoEstabelecimento").val(objetoJson['complementoEstabelecimento']);
			$("#telefoneEstabelecimento1").val(objetoJson['telefoneEstabelecimento1']);
			$("#telefoneEstabelecimento2").val(objetoJson['telefoneEstabelecimento2']);
			$("#emailEstabelecimento").val(objetoJson['emailEstabelecimento']);
			$("#latitudeEstabelecimento").val(objetoJson['latitudeEstabelecimento']);
			$("#longitudeEstabelecimento").val(objetoJson['longitudeEstabelecimento']);
			var prestadorPrivado = objetoJson['prestadorPrivado'] == "S" ? true : false;
			$("#prestadorPrivado").prop("checked", prestadorPrivado);
			var postoDescentralizado = objetoJson['postoDescentralizado'] == "S" ? true : false;
			$("#postoDescentralizado").prop("checked", postoDescentralizado);
			$("#nomeAbreviadoEstabelecimento").val(objetoJson['nomeAbreviado']);
			$("#perfilEstabelecimento").val(objetoJson['perfilEstabelecimento']);
			$("#respeitaCotaEstabelecimento").val(objetoJson['respeitaCotaEstabelecimento']);
			$("#usaPainelSenha").val(objetoJson['usaPainelSenha']);
			$('#btnCancelar').prop('disabled', false);

			$.ajax({
				url: 'filtros/buscar_dados_edicao',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoBusca': 'estabelecimento-profissionais-vinculados',
					'idEstabelecimento': idEstabelecimento
				}
			}).done(function(resultadoRetorno) {
				$('#dados_profissionais').DataTable().destroy();
				$('#dados_profissionais tbody').empty().append(resultadoRetorno);
				$('#dados_profissionais').DataTable({
					"filter": false,
					"lengthChange": false
				});

				$.ajax({
					url: 'filtros/buscar_dados_edicao',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoBusca': 'estabelecimento-usuarios-ativos',
						'idEstabelecimento': idEstabelecimento
					}
				}).done(function(resultadoRetorno) {
					$('#dados_usuarios').DataTable().destroy();
					$('#dados_usuarios tbody').empty().append(resultadoRetorno);
					$('#dados_usuarios').DataTable({
						"filter": false,
						"lengthChange": false
					});
					$("#embacado").css("display", "none");
				});
			});
		});

	}

	function cancelarAlteracao() {
		$("#codigoEstabelecimento").val('');
		$("#cnpjEstabelecimento").val('');
		$("#razaoSocialEstabelecimento").val('');
		$("#nomeFantasiaEstabelecimento").val('');
		$("#cnesEstabelecimento").val('');
		$("#cepEstabelecimento").val('');
		$("#enderecoEstabelecimento").val('');
		$("#numeroEstabelecimento").val('');
		$("#bairroEstabelecimento").val('');
		$("#complementoEstabelecimento").val('');
		$("#telefoneEstabelecimento1").val('');
		$("#telefoneEstabelecimento2").val('');
		$("#emailEstabelecimento").val('');
		$("#latitudeEstabelecimento").val('');
		$("#longitudeEstabelecimento").val('');
		$("#prestadorPrivado").prop("checked", false);
		$("#postoDescentralizado").prop("checked", false);
		$("#nomeAbreviadoEstabelecimento").val('');
		$("#perfilEstabelecimento").val('');
		$("#respeitaCotaEstabelecimento").val('NA');
		$("#cnpjEstabelecimento").focus();
		$('#btnCancelar').prop('disabled', true);
		$('#dados_profissionais').DataTable().destroy();
		$('#dados_profissionais tbody').empty().append();
		$('#dados_profissionais').DataTable({
			"filter": false,
			"lengthChange": false
		});
	}

	function statusEstabelecimento(codigoEstabelecimento, statusEstabelecimento) {


		var tituloMensagem = statusEstabelecimento == "ativar" ? "Ativação do Cadastro" : "Detivação do Cadastro";
		var mensagemConfirmacao = statusEstabelecimento == "ativar" ? "Confirma ativação do cadastro do estabelecimento?" : "Confirma desativação do cadastro do estabelecimento?";
		var mensagemResultado = statusEstabelecimento == "ativar" ? "Cadastro do estabelecimento ativado com sucesso." : "Cadastro do estabelecimento desativado com sucesso.";

		swal({
			title: tituloMensagem,
			text: mensagemConfirmacao,
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$("#embacado").css("display", "block");
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'status-estabelecimento-saude',
						'idRegistroExclusao': codigoEstabelecimento,
						'statusEstabelecimento': statusEstabelecimento
					}
				}).done(function(resultadoRetorno) {
					$('#dados_estabelecimentos').DataTable().destroy();
					$('#dados_estabelecimentos tbody').empty().append(resultadoRetorno);
					$('#dados_estabelecimentos').DataTable();
					swal(tituloMensagem, mensagemResultado, "success");
					$("#embacado").css("display", "none");
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi alterado.", "info");
			}

		});

	}

	$("#prestadorPrivado").change(function() {
		if (this.checked) {
			$("#postoDescentralizado").prop("disabled", true);
			$("#postoDescentralizado").prop("checked", false);
		} else {
			$("#postoDescentralizado").prop("disabled", false);
		}
	})

	$("#postoDescentralizado").change(function() {
		if (this.checked) {
			$("#nomeAbreviadoEstabelecimento").prop("disabled", false);
		} else {
			$("#nomeAbreviadoEstabelecimento").val('');
			$("#nomeAbreviadoEstabelecimento").prop("disabled", true);
		}
	})
</script>