<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}

include_once("header.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-edit" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Paciente
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="ft-user"></i> <b>Dados de Idetificação</b><input type="hidden" id="idPaciente"></h4>
										<div class="row">
											<div class="col-md-6">
												<div class="form-group">
													<label for="nomePaciente">Nome:</label>
													<input type="text" id="nomePaciente" class="form-control" value="MARCUS OLIVEIRA" autofocus>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="numeroCNS">Nº Cartão SUS:</label>
													<input type="text" id="numeroCNS" class="form-control cns-inputmask" style="text-align:center" value="709002863635814" onblur="validaCNS(this.value)">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="numeroCPF">Nº CPF:</label>
													<input type="text" id="numeroCPF" class="form-control cpf-inputmask" style="text-align:center" value="10164333606" onblur="validaCPF(this.value)">
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeSocialPaciente">Nome Social:</label>
													<input type="text" id="nomeSocialPaciente" class="form-control">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="dataNascimento">Data Nascimento:</label>
													<input type="date" id="dataNascimento" class="form-control" value="20/09/1989">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="sexoPaciente">Sexo:</label>
													<input type="text" id="sexoPaciente" class="form-control" value="Masculino">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeMaePaciente">Nome da Mãe ou Responsável:</label>
													<input type="text" id="nomeMaePaciente" class="form-control" value="MARIA ROSA OLIVEIRA">
												</div>
											</div>
										</div>
									</div>
									<div class="form-body">
										<h4 class="form-section"><i class="ft-globe"></i> <b>Dados Residenciais</b></h4>
										<div class="row">
											<div class="col-md-3">
												<div class="form-group">
													<label for="cepPaciente">CEP:</label>
													<div class="input-group">
														<input type="text" id="cepPaciente" class="form-control cep-inputmask" onblur="PesquisaCEP(this.value,enderecoPaciente.id,bairroPaciente.id,nomeCidadePaciente.id,ibgeCidade.id,'')" value="38408310" />
														<div class="input-group-append">
															<button class="btn btn-success" type="button" onClick="window.open('https://buscacepinter.correios.com.br/app/endereco/index.php')" title="Clicar para buscar nos correios."><img src="../app-assets/images/correios.png" alt="Ver nos correios"></button>
														</div>
													</div>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="enderecoPaciente">Endereço Completo:</label>
													<input type="text" id="enderecoPaciente" class="form-control" value="JOAQUIM CARLOS FONSECA">
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="numeroEnderecoPaciente">Nº:</label>
													<input type="text" id="numeroEnderecoPaciente" class="form-control" value="S/N">
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="pontoRederencia">Pronto de Referência:</label>
													<input type="text" id="pontoRederencia" class="form-control">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="bairroPaciente">Bairro:</label>
													<input type="text" id="bairroPaciente" class="form-control" value="SEGISMUNDO PEREIRA">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeCidadePaciente">Cidade:</label>
													<input type="text" id="nomeCidadePaciente" class="form-control" disabled value="Uberlândia">
													<input type="hidden" id="ibgeCidade" class="form-control" disabled value="">
												</div>
											</div>
										</div>
									</div>
									<div class="form-body">
										<h4 class="form-section"><i class="ft-mail"></i> <b>Dados de Contato</b></h4>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="telefoneCelular1">Telefone 1 | (É Whatsapp?):</label>
													<div class="input-group">
														<input type="text" id="telefoneCelular1" class="form-control fonecelular-inputmask" value="61998123456">
														<div class="input-group-append">
															<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																<input type="checkbox" class="switch" id="telefoneCelular1Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" />
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="telefoneCelular2">Telefone 2 | (É Whatsapp?):</label>
													<div class="input-group">
														<input type="text" id="telefoneCelular2" class="form-control fonecelular-inputmask" value="">
														<div class="input-group-append">
															<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																<input type="checkbox" class="switch" id="telefoneCelular2Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" />
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="telefoneCelular3">Telefone 3 | (É Whatsapp?):</label>
													<div class="input-group">
														<input type="text" id="telefoneCelular3" class="form-control fonecelular-inputmask" value="">
														<div class="input-group-append">
															<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																<input type="checkbox" class="switch" id="telefoneCelular3Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" />
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
							</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<div class="barra-flutuante">
	<button type="button" class="btn btn-info" onClick="gravarPaciente()" style="width:130px">
		<i class="fa fa-check-square-o"></i> Confirmar
	</button>
	<button type="button" class="btn btn-warning" onClick="window.location.href='paciente_buscar?op=cs'">
		<i class="icofont icofont-search"></i>&nbsp;&nbsp;Voltar à Pesquisa
	</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/forms/extended/maxlength/bootstrap-maxlength.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-maxlength.min.js"></script>

<script>
	//Setar valores de campos select de acordo com o que vem do Banco de Dadios
	var liMenu = "<?php echo $liMenu; ?>";
	$("#" + liMenu).attr('class', 'active');
	$("#" + liMenu).css("border-bottom", "2px solid #c4c8ca");

	//Função para gravar dados do cidadão
	function gravarPaciente() {

		if ($("#nomePaciente").val() == "") {
			swal("Nome do Paciente", "Você deve preencher o nome do paciente", "warning");
			return false;
		} else if ($("#numeroCNS").val() == "" && $("#numeroCPF").val() == "") {
			swal("Documento do Paciente", "Você deve informar cartão SUS ou CPF do paciente", "warning");
			return false;
		} else if ($("#dataNascimento").val() == "") {
			swal("Data de Nascimento", "A data de nascimento do paciente é obrigatória", "warning");
			$("#box_informa").modal();
			return false;
		} else if ($("#sexoPaciente").val() == "") {
			swal("Sexo de Nascimento", "Você deve preencher a informação de sexo", "warning");
			return false;
		} else if (!validaCNS($("#numeroCNS").val())) {
			swal("Cartão SUS", "Número do cartão SUS inválido. Digite um número válido!", "warning");
			return false;
		} else if (!validaCPF($("#numeroCPF").val())) {
			swal("Número do CPF", "Número do CPF inválido. Digite um número válido!", "warning");
			return false;
		}


		$("#processandoDados").html("Aguarde! Salvando dados...");
		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_paciente',
			type: 'post',
			dataType: 'html',
			data: {
				'idPaciente': $("#idPaciente").val(),
				'nomePaciente': $("#nomePaciente").val(),
				'numeroCNS': $("#numeroCNS").val(),
				'numeroCPF': $("#numeroCPF").val(),
				'nomeSocialPaciente': $("#nomeSocialPaciente").val(),
				'dataNascimento': $("#dataNascimento").val(),
				'sexoPaciente': "<?php echo $sexoGravar; ?>",
				'nomeMaePaciente': $("#nomeMaePaciente").val(),
				'cepPaciente': $("#cepPaciente").val(),
				'enderecoPaciente': $("#enderecoPaciente").val(),
				'numeroEnderecoPaciente': $("#numeroEnderecoPaciente").val(),
				'pontoRederencia': $("#pontoRederencia").val(),
				'bairroPaciente': $("#bairroPaciente").val(),
				'ibgeCidade': $("#ibgeCidade").val(),
				'telefoneCelular1': $("#telefoneCelular1").val(),
				'telefoneCelular1Whatsapp': $("#telefoneCelular1Whatsapp").is(':checked') ? "S" : "N",
				'telefoneCelular2': $("#telefoneCelular2").val(),
				'telefoneCelular2Whatsapp': $("#telefoneCelular2Whatsapp").is(':checked') ? "S" : "N",
				'telefoneCelular3': $("#telefoneCelular3").val(),
				'telefoneCelular3Whatsapp': $("#telefoneCelular3Whatsapp").is(':checked') ? "S" : "N",
			}

		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			swal("Cadastro de Paciente", "Dados confirmados com sucesso! Direcionando para registro de agendamento...", "success");

			var paginaOpcao = "<?php echo $_GET['op']; ?>";
			var paginaDestino = paginaOpcao == "ca" ? "cadastrar_agendamento" : "solicitacao_cadastro";
			setTimeout("window.location.href='" + paginaDestino + "?idpac=" + resultadoRetorno + "&op=" + paginaOpcao + "'", 2000);
		});

	}
</script>