<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];

$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPacienteExibir = $rsPaciente->sexo == "M" ? "MASCULINO" : "FEMININO";
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade          = $rsPaciente->codigocidade;

//Cor alerta fora de Lauro!
if ($ibgeCidade != $_SESSION['ibgeSedeSistema']) {
  $setCorCidade = "style='background-color:#ae0000 !important;color:#fff'";
} else {
  $setCorCidade = "";
}

$formatarOrigem = array(
  'lista_unica' => 'LISTA ÚNICA',
  'policlinica' => 'POLICLÍNICA',
  'sisreg' => 'SISREG',
  'sistema_vida' => 'VIDA+',
);

if (isset($_GET['idsol'])) {

  $idSolicitacao    = $_GET['idsol'];
  $sqlSolicitacao  = "SELECT * FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'";
  $stmSolicitacao  = $rsConexao->prepare($sqlSolicitacao);
  $stmSolicitacao->execute();
  $rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ);

  $numeroProtocolo        = $rsSolicitacao->numero_procotolo;
  $tokenSolicitacao       = $rsSolicitacao->token_solicitacao;
  $grupoProcedimento      = $rsSolicitacao->id_grupo_procedimento;
  $idProcedimento         = $rsSolicitacao->id_procedimento;
  $observacoesSolicitacao = $rsSolicitacao->observacoes_solicitacao;
  $liberarBotao           = "";
} else {
  $idSolicitacao          = "";
  $numeroProtocolo        = "";
  $tokenSolicitacao       = "";
  $grupoProcedimento      = "";
  $idProcedimento         = "";
  $observacoesSolicitacao = "";
  $tokenSolicitacao       = strtoupper(substr(md5(uniqid(rand(), true)), 0, 20));
  $liberarBotao           = " disabled";
}

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-stack-overflow" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Solicitação de Procedimento
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top: -15px;">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                      <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                      <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao; ?>" />
                      <input type="hidden" id="tokenSolicitacao" value="<?php echo $tokenSolicitacao; ?>" disabled />
                    </h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cpfPaciente">CPF:</label>
                          <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cnsPaciente">Cartão SUS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="idadePaciente">Idade:</label>
                          <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="sexoPaciente">Sexo:</label>
                          <input type="text" id="sexoPaciente" class="form-control text-center" value="<?php echo $sexoPacienteExibir; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="municipioPaciente">Município:</label>
                          <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $municipioPaciente; ?>" <?php echo $setCorCidade; ?> disabled>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="bairroPaciente">Bairro:</label>
                          <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $bairrroPaciente; ?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body" style="margin-top: -15px;">
                    <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="numeroProtocolo">Nº Protocolo:</label>
                          <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="grupoProcedimento">Grupo:</label>
                          <select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
                            <option value="">SELECIONE GRUPO...</option>
                            <?php
                            if ($idPerfilLogado == '6' || $idPerfilLogado == '7') {
                              $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimentos_grupo WHERE disponivel_guiche='S' AND id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                            } else {
                              $stmGrupo  = $rsConexao->prepare("SELECT * FROM reg_tb_procedimentos_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
                            }
                            $stmGrupo->execute();
                            $rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
                            $totalGrupo  = $stmGrupo->rowCount();
                            if ($totalGrupo > 0) {
                              echo "<option value='1'>NÃO AGRUPADOS</option>";
                              foreach ($rsGrupo as $fieldGrupo) {
                                $idGrupo = $fieldGrupo['id_grupo_procedimento'];
                                $nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
                                if ($nomeGrupo != "NÃO AGRUPADOS") {
                                  echo "<option value='$idGrupo'>GRUPO - $nomeGrupo</option>";
                                } else {
                                  echo "<option value='$idGrupo'>$nomeGrupo</option>";
                                }
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="nomeProcedimento">Nome de Procedimentos:</label>
                          <select class="form-control" id="nomeProcedimento">
                            <option value="">SELECIONE O GRUPO...</option>
                          </select>
                          <input type="hidden" id="procedimentoSelecionado" class="form-control" />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-30px !important; display:none" id='div-observacaoProcedimento'>
                      <div class='col-md-12'>
                        <div class="bs-callout-danger callout-square callout-bordered mt-1">
                          <div class="media align-items-stretch">
                            <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                              <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                            </div>
                            <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important' id='texto-observacao-procedimento'>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="observacaoSolicitacao">Observação:</label>
                          <input type="text" id="observacaoSolicitacao" class="form-control" value="<?php echo $observacoesSolicitacao; ?>" />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="tipoDocumento">Tipo de Documento:</label>
                          <select class="form-control" id="tipoDocumento">
                            <option value="">SELECIONE....</option>
                            <?php
                            $stmTipoDocumento = $rsConexao->prepare("SELECT * FROM reg_rl_tipodocumento ORDER BY nome_tipodocumento");
                            $stmTipoDocumento->execute();
                            $rsTipoDocumento  = $stmTipoDocumento->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($rsTipoDocumento as $fieldTipoDocumento) {
                              $idTipoDocumento    = $fieldTipoDocumento['id_tipodocumento'];
                              $nomeTipoDocumento  = $fieldTipoDocumento['nome_tipodocumento'];
                              echo "<option value='$idTipoDocumento'>$nomeTipoDocumento</option>";
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-9">
                        <div class="form-group">
                          <label for="documentoMedico">Anexar Arquivo:</label>
                          <div class="input-group">
                            <input type="text" id="nomeArquivoDocumento" name="nomeArquivoDocumento" class="form-control upload-fake" disabled style='width:100%;'>
                            <input type="file" id="arquivoDocumento" name="arquivoDocumento" class="form-control upload-real" accept=".pdf, .PDF">
                            <div class="input-group-append">
                              <div class="float-left" style="margin-top:-41px">
                                <button type="button" class="btn btn-info" onClick="adicionarArquivo()">
                                  <i class="fa fa-check-square-o"></i>Adicionar
                                </button>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-74px !important">
                      <div class='col-md-12'>
                        <div class="bs-callout-warning callout-square callout-bordered mt-1">
                          <div class="media align-items-stretch">
                            <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                              <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                            </div>
                            <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                              <strong>ATENÇÃO!</strong> <b>São aceitos pelo sistema apenas arquivos em formado PDF. Arquivos aleatórios anexados à solicitação impedirá a realização do agendamento do paciente. Possíveis questionamentos do paciente ou ouvidoria serão direcionados ao responsável pelo registro da solicitação.</b>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top: -45px !important;">
              <div class="card-body card-dashboard">
                <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_anexos">
                  <thead>
                    <tr>
                      <th style="text-align: center !important;" width="100px">OPÇÕES</th>
                      <th style='display:none'>idtipodoc</th>
                      <th style="width: 200px; text-align:center">DATA/HORA INCLUSÃO</th>
                      <th style="width: 250px;">TIPO DE DOCUMENTO</th>
                      <th>NOME DO ARQUIVO</th>
                    </tr>
                  </thead>
                  <tbody style="background-color: #ececec;">
                    <?php
                    $diretorioBase  = "docsolicitacoes/";
                    $diretorioData  = date("Ymd");
                    $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) WHERE token_solicitacao='$tokenSolicitacao'";

                    $stmDocumento = $rsConexao->prepare($sqlDocumento);
                    $stmDocumento->execute();

                    if ($stmDocumento->rowCount() > 0) {
                      $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
                      $contarDocs   = 0;
                      foreach ($rsDocumento as $fieldDocumento) {
                        $contarDocs       = $contarDocs + 1;
                        $idDocumento      = $fieldDocumento['id_sca_documentoanexo'];
                        $dataHoraInclusao = $fieldDocumento['dataInclusao'] . ' ÀS ' . $fieldDocumento['horaInclusao'];
                        $tipoDocumento    = $fieldDocumento['nome_tipodocumento'];
                        $idTipoDocumento  = $fieldDocumento['id_tipodocumento'];
                        $pastaDocumento   = $fieldDocumento['pasta_documento'];
                        $nomeArquivo      = mb_strtoupper($fieldDocumento['nomearquivo_documento']);

                        $arquivoAnexo     = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];

                        $cliqueBotaoVisualizarDocumento = 'onClick="window.open(' . "'$arquivoAnexo')" . '"';
                        $botaoVisualizarDocumento  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;

                        $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo(' . "'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
                        $botaoExcluirAnexo  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;

                        echo "<tr>
                            <td align='center'>$botaoVisualizarDocumento $botaoExcluirAnexo</td>
                            <td style='display:none' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
                            <td align='center'>$dataHoraInclusao</td>
                            <td>$tipoDocumento</td>
                            <td>$nomeArquivo</td>
                          </tr>";
                      }
                    }
                    ?>
                  </tbody>
                </table><br><br>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante" style='margin-left:-150px'>
  <button type="button" class="btn btn-blue" onClick="gravarSolicitacao()"><i class="fa fa-check-square-o"></i> Salvar</button>
  <button type="button" class="btn btn-dark" id="imprimirProtocolo" onClick="imprimirProtocolo()" <?php echo $liberarBotao; ?>><i class="icofont icofont-printer"></i> Protocolo</button>
  <button type="button" class="btn btn-green" id="btnNovoPaciente" onClick="novaSolicitacao()" <?php echo $liberarBotao; ?>><i class="ft-file"></i> Nova Solicitação</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.location.href='paciente_buscar?op=<?php echo $opcaoTela; ?>'"><i class="fa fa-times"></i> Voltar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liCadastroSolicitacao").attr('class', 'active');
  $("#liCadastroSolicitacao").css("border-bottom", "2px solid #c4c8ca");

  $('#documentos_anexos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $("#arquivoDocumento").change(function() {
    var nomeArquivo = this.files[0].name;
    $("#nomeArquivoDocumento").val(nomeArquivo);
  })

  function adicionarArquivo() {


    if ($("#tipoDocumento").val() == "" || $("#nomeArquivoDocumento").val() == "") {
      swal("Documento Obrigatórios", "Você deve selecionar um arquivo para adicionar à lista de documentos.", "error");
      return false;
    }

    if ($("#nomeArquivoDocumento").val() != "") {
      let extensoesValidas = /(\.pdf)$/i;
      let nomeArquivo = $('#arquivoDocumento')[0].files[0].name;
      if (extensoesValidas.test(nomeArquivo) == false) {
        swal("Arquivo Inválido", "Tipo de arquivo inválido. Só são permitidos arquivos em formato PDF.", "error");
        return false;
      }
    }
    $('#embacado').css('display', 'block');
    var formData = new FormData();
    formData.append('idPaciente', $("#idPaciente").val());
    formData.append('idSolicitacao', $("#idSolicitacao").val());
    formData.append('tipoDocumento', $("#tipoDocumento").val());
    formData.append('tokenSolicitacao', $("#tokenSolicitacao").val());
    formData.append('arquivoDocumento', $('#arquivoDocumento')[0].files[0]);

    $.ajax({
      type: 'POST',
      url: 'action/gravar_solicitacao_anexo',
      data: formData,
      processData: false,
      contentType: false
    }).done(function(resultadoRetorno) {
      $('#embacado').css('display', 'none');
      if (resultadoRetorno == "JáExiste") {
        swal("Documento já Adicionado", "O tipo de documento informado já foi adicionado à lista.", "error");
        return false;
      }
      $('#documentos_anexos').DataTable().destroy();
      $('#documentos_anexos tbody').empty().append(resultadoRetorno);
      $('#documentos_anexos').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#tipoDocumento").val('');
      $("#nomeArquivoDocumento").val('');
    });

  }

  $('#nomeProcedimento').change(function() {
    var nomeProcedimento = "";
    if ($("#nomeProcedimento").val() != "") {
      nomeProcedimento = $('#nomeProcedimento').find(":selected").text();
    } else {
      nomeProcedimento = "";
    }
    $("#procedimentoSelecionado").val(nomeProcedimento);

    if (this.value != "") {
      $.ajax({
        url: 'filtros/filtrar_procedimento',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoPesquisa': 'buscar_observacao',
          'idProcedimento': this.value
        }
      }).done(function(resultadoRetorno) {
        if (resultadoRetorno != "NãoExiste") {
          var textObservacao = "<strong>&there4; OBSERVAÇÕES DO PROCEDIMENTO &there4;</strong><br><b>" + resultadoRetorno + "</b>";
          $('#texto-observacao-procedimento').html(textObservacao);
          $("#div-observacaoProcedimento").css('display', 'block');
        } else {
          $("#div-observacaoProcedimento").css('display', 'none');
          $('#texto-observacao-procedimento').html('');
        }
      });
    } else {
      $("#div-observacaoProcedimento").css('display', 'none');
      $('#texto-observacao-procedimento').html('');
    }
  });


  function gravarSolicitacao() {

    var totalAnexos = $("#documentos_anexos").dataTable().fnSettings().fnRecordsTotal();
    var procedimentoSelecionado = $("#procedimentoSelecionado").val();
    var idadePaciente = $("#idadePaciente").val();
    var validarUltrassonMama = true;
    var validarMamogradia = true;
    var validarRequisicao = false;
    var linhaAnexo = 0;

    //#----------------------------VALIDAR ULTRASSONOGRAFIA DE MAMA----------------------------#//
    if (idadePaciente > 40) {
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRA-SONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSONOGRAFIA MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASON DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASON DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSON DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("ULTRASSON DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG DE MAMA") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG DE MAMAS") != -1) {
        validarUltrassonMama = false;
      }
      if (procedimentoSelecionado.indexOf("USG MAMARIA") != -1) {
        validarUltrassonMama = false;
      }
    }
    //#----------------------------------------------------------------------------------------#//  

    //#----------------------------------VALIDAR MAMOGRAFIA------------------------------------#//
    if (procedimentoSelecionado.indexOf("MAMOGRAFIA") != -1) {
      validarMamogradia = false;
    }
    //#----------------------------------------------------------------------------------------#//  

    if ($("#grupoProcedimento").val() == "" || $("#nomeProcedimento").val() == "") {
      swal("Dados Obrigatórios", "Você deve preencher todos os dados do agendamento.", "error");
      return false;
    }
    if (totalAnexos == 0) {
      swal("Documento Obrigatório", "Você deve anexar pelo menos a requisição do paciente.", "error");
      return false;
    }

    if (validarUltrassonMama == false) {
      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if ($("#idTipoDoc" + linhaAnexo).html() == "5") {
          validarUltrassonMama = true;
        }
      }
    }
    if (validarUltrassonMama == false) {
      swal("Documento Obrigatório", "Para solicitar " + procedimentoSelecionado + ", você deve anexar o resultado da mamografia, sem isto não é possível realizar a solicitação.", "error");
      return false;
    }

    if (validarMamogradia == false) {
      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if ($("#idTipoDoc" + linhaAnexo).html() == "6") {
          validarMamogradia = true;
        }
      }
    }
    if (validarMamogradia == false) {
      swal("Documento Obrigatório", "Para solicitar " + procedimentoSelecionado + ", você deve anexar o formulário específico da mamografia, sem isto não é possível realizar a solicitação.", "error");
      return false;
    }

    if (validarUltrassonMama == true && validarMamogradia == true) {

      for (linhaAnexo = 1; linhaAnexo <= totalAnexos; linhaAnexo++) {
        if ($("#idTipoDoc" + linhaAnexo).html() == "6" || $("#idTipoDoc" + linhaAnexo).html() == "3") {
          validarRequisicao = true;
        }
      }
      if (validarRequisicao == false) {
        swal("Documento Obrigatório", "Você não adicionou nenhuma requisição à solicitação.", "error");
        return false;
      }

      $("#embacado").css("display", "block");
      $.ajax({
        url: 'action/gravar_solicitacao',
        type: 'post',
        dataType: 'html',
        data: {
          'idPaciente': $("#idPaciente").val(),
          'idSolicitacao': $("#idSolicitacao").val(),
          'grupoProcedimento': $("#grupoProcedimento").val(),
          'nomeProcedimento': $("#nomeProcedimento").val(),
          'observacaoSolicitacao': $("#observacaoSolicitacao").val(),
          'tokenSolicitacao': $("#tokenSolicitacao").val(),
          'numeroProtocolo': $("#numeroProtocolo").val(),
        }
      }).done(function(resultadoRetorno) {
        retornoResultado = resultadoRetorno.split("##");
        $("#idSolicitacao").val(retornoResultado[0]);
        $("#numeroProtocolo").val(retornoResultado[1]);
        $("#imprimirProtocolo").prop('disabled', false);
        $("#btnNovoPaciente").prop('disabled', false);
        $("#embacado").css("display", "none");
        swal("Registro de Solicitação", "Solicitação registrada com sucesso. Imprima o Protocolo!", "success");
      });
    }
  }

  function novaSolicitacao() {

    swal({

      title: "Cadastrar Nova Solicitação",
      text: "Informe se a nova solicitação é para o mesmo paciente ou para outro paciente!",
      icon: "warning",

      buttons: {
        confirm: {
          text: "MESMO PACIENTE",
          value: true,
          visible: true,
          className: "btn-blue",
          closeModal: false
        },
        cancel: {
          text: "OUTRO PACIENTE",
          value: null,
          visible: true,
          className: "btn-green",
          closeModal: false,
        },
        cancel: {
          text: "OUTRO PACIENTE",
          value: null,
          visible: true,
          className: "btn-green",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        window.location.href = "cadastrar_solicitacao?idpac=<?php echo $idPaciente; ?>&op=<?php echo $opcaoTela; ?>";
      } else {
        window.location.href = "paciente_buscar?op=<?php echo $opcaoTela; ?>";
      }

    });

  }

  function filtrarProcedimentos() {

    $("#embacado").css("display", "block");

    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'cadastrar-agendamento',
        'grupoProcedimento': $("#grupoProcedimento").val(),
        'sexoPaciente': "<?php echo $sexoPaciente; ?>"
      }
    }).done(function(resultadoRetorno) {
      $("#procedimentoSelecionado").val("");
      $("#nomeProcedimento").html("");
      $("#nomeProcedimento").html(resultadoRetorno);
      $("#embacado").css("display", "none");
    });

  }

  function excluirAnexo(idDocumento, anexoExcluir, tokenSolicitacao) {
    var idPerfilLogado = "<?php echo $idPerfilLogado; ?>";
    if ((idPerfilLogado == '5' || idPerfilLogado == '6' || idPerfilLogado == '7') && numeroProtocolo != "") {
      swal("Não Autorizado.", "Esta solicitação já foi salva. Você não pode mais excluir documentos. Entre em contato com a Coordenação da Regulação.", "error");
      return false;
    }

    swal({
      title: "Exclusão de Documento",
      text: "Confirma exclusão do documento selecionado?",
      icon: "../app-assets/images/question.png",

      buttons: {
        confirm: {
          text: "Sim, Confirmar!",
          value: true,
          visible: true,
          className: "btn-success",
          closeModal: false
        },
        cancel: {
          text: "Não, Foi engano!",
          value: null,
          visible: true,
          className: "btn-danger",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'documento_anexo',
            'idRegistroExclusao': idDocumento,
            'anexoExcluir': anexoExcluir,
            'tokenSolicitacao': tokenSolicitacao,
          }
        }).done(function(resultadoRetorno) {
          $('#documentos_anexos').DataTable().destroy();
          $('#documentos_anexos tbody').empty().append(resultadoRetorno);
          $('#documentos_anexos').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          $("#embacado").css("display", "none");
          swal("Exclusão de Documento.", "Exclusão de procedimento realizada com sucesso.", "info");
        });

      } else {
        swal("Operação Cancelada.", "O documento selecionado não foi excluído.", "info");
      }

    });

  }

  function imprimirProtocolo() {

    window.open("imprimir_protocolo?ids=" + $("#idSolicitacao").val());

  }


  /* ATRIBUIR VALORES DOS COMBOS */
  $("#grupoProcedimento").val("<?php echo $grupoProcedimento ?>");
  $("#grupoProcedimento").trigger("change");
  setTimeout(function() {
    $("#nomeProcedimento").val("<?php echo $idProcedimento ?>");
  }, 1500);
</script>