<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-search" style='margin-top:-15px !important'></i>&nbsp;Consultar CNS do Cidadão
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i> <b>Informações para pesquisa</b></h4>
                    <div class="row">
                      <div class="col-md-6 col-sm-12">
                        <fieldset class="text-left">
                          <label for="radio-cns">Por CNS</label>
                          <input type="radio" name="jui-radio-buttons" id="radio-cns" class="jui-radio-buttons" checked onChange="selecionaBuscaPaciente(this.id)" />
                          <label for="radio-cpf">Por CPF</label>
                          <input type="radio" name="jui-radio-buttons" id="radio-cpf" class="jui-radio-buttons" onChange="selecionaBuscaPaciente(this.id)" />
                          <input type="hidden" id="opcaoPesquisa" class="form-control" value="radio-cns" />
                        </fieldset>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="pesquisaCNS">Nº Cartão SUS:</label>
                          <input type="text" id="pesquisaCNS" class="form-control cns-inputmask text-center" autofocus />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="pesquisaCPF">Nº CPF:</label>
                          <input type="text" id="pesquisaCPF" class="form-control cpf-inputmask  text-center" disabled />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>&nbsp;</label><br>
                          <button type="button" class="btn btn-info" onClick="buscarPaciente(opcaoPesquisa.value)"><i class="fa fa-search"></i> Pesquisar</button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-actions" style="margin-top: -15px !important;"></div>
                  <div class="form-body" style='display:none' id='bodyResultado'>
                    <h4 class="form-section" style='background-color:#4bbfc7; margin-top:-25px'><i class="ft-user"></i> <b>Informações Encontradas</b></h4>
                    <div class="row" style='margin-top:-10px'>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" autofocus disabled>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="numeroCNS">Nº Cartão SUS:</label>
                          <input type="text" id="numeroCNS" class="form-control cns-inputmask" style="text-align:center" disabled>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="numeroCPF">Nº CPF:</label>
                          <input type="text" id="numeroCPF" class="form-control cpf-inputmask" style="text-align:center" disabled>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomeSocialPaciente">Nome Social:</label>
                          <input type="text" id="nomeSocialPaciente" class="form-control" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="dataNascimento">Data Nascimento:</label>
                          <input type="date" id="dataNascimento" class="form-control text-center" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="sexoPaciente">Sexo:</label>
                          <input type="text" id="sexoPaciente" class="form-control" disabled>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomeMaePaciente">Nome da Mãe ou Responsável:</label>
                          <input type="text" id="nomeMaePaciente" class="form-control" disabled>
                        </div>
                      </div>
                    </div>
                    <h4 class="form-section" style='margin-top:-15px'>
                      <i class="icofont icofont-social-google-map"></i> <b>Dados Residenciais</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cepPaciente">CEP:</label>
                          <input type="text" id="cepPaciente" class="form-control cep-inputmask" disabled />
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="enderecoPaciente">Endereço Completo:</label>
                          <input type="text" id="enderecoPaciente" class="form-control" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="numeroEnderecoPaciente">Nº:</label>
                          <input type="text" id="numeroEnderecoPaciente" class="form-control" disabled>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="pontoRederencia">Pronto de Referência:</label>
                          <input type="text" id="pontoRederencia" class="form-control" disabled>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="bairroPaciente">Bairro:</label>
                          <input type="text" id="bairroPaciente" class="form-control" disabled>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomeCidadePaciente">Cidade:</label>
                          <input type="text" id="nomeCidadePaciente" class="form-control" disabled>
                        </div>
                      </div>
                    </div>
                    <h4 class="form-section" style='margin-top:-15px'>
                      <i class="ft-mail"></i> <b>Dados de Contato</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefoneCelular1">Telefone 1 | (É Whatsapp?):</label>
                          <div class="input-group">
                            <input type="text" id="telefoneCelular1" class="form-control fonecelular-inputmask" disabled>
                            <div class="input-group-append">
                              <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                <input type="checkbox" class="switch" id="telefoneCelular1Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" disabled/>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefoneCelular2">Telefone 2 | (É Whatsapp?):</label>
                          <div class="input-group">
                            <input type="text" id="telefoneCelular2" class="form-control fonecelular-inputmask"  disabled>
                            <div class="input-group-append">
                              <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                <input type="checkbox" class="switch" id="telefoneCelular2Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle"  disabled/>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="telefoneCelular3">Telefone 3 | (É Whatsapp?):</label>
                          <div class="input-group">
                            <input type="text" id="telefoneCelular3" class="form-control fonecelular-inputmask"  disabled>
                            <div class="input-group-append">
                              <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                <input type="checkbox" class="switch" id="telefoneCelular3Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle"  disabled/>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
  </div>
  </section>
</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liConsultarCartaoSUS").attr('class', 'active');
  $("#liConsultarCartaoSUS").css("border-bottom", "2px solid #c4c8ca");

  function buscarPaciente(selOpcao) {

    var cnsPaciente = $('#pesquisaCNS').val();
    var cpfPaciente = $('#pesquisaCPF').val();
    var opcaoDocumento = "";
    var numeroDocumento = "";
    var tituloMensagem = "";
    var textoMensagem = "";

    switch (selOpcao) {
      case "radio-cns":
        opcaoDocumento = "cns";
        numeroDocumento = cnsPaciente;
        tituloMensagem = "Cartão SUS";
        textoMensagem = "Informe o número do cartão SUS para pesquisa!";
        mensagemNãoEncontrato = "Não foi encontrato nenhum paciente com o Cartão SUS informado.";
        break;
      case "radio-cpf":
        opcaoDocumento = "cpf";
        numeroDocumento = cpfPaciente;
        tituloMensagem = "Número de CPF";
        textoMensagem = "Informe o número do CPF para pesquisa!";
        mensagemNãoEncontrato = "Não foi encontrato nenhum paciente com o CPF informado.";
        break;
    }

    if (numeroDocumento == "") {
      swal(tituloMensagem, textoMensagem, "error");
      return false;
    } else {
      $("#bodyResultado").css("display","none");
      $("#embacado").css("display", "block");
      $.ajax({
        url: 'filtros/filtrar_paciente_cns',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoDocumento': opcaoDocumento,
          'numeroDocumento': numeroDocumento
        }
      }).done(function(resultadoRetorno) {
        $("#embacado").css("display", "none");
        if (resultadoRetorno == "NaoEncontrado") {
          swal("Não Encontrado", mensagemNãoEncontrato, "error");
          return false;          
        } else {
          var objetoJson = JSON.parse(resultadoRetorno);
          $('#nomePaciente').val(objetoJson['nomePaciente']);
          $('#numeroCNS').val(objetoJson['numeroCNS']);
          $('#numeroCPF').val(objetoJson['numeroCPF']);
          $('#nomeSocialPaciente').val(objetoJson['nomeSocialPaciente']);
          $('#dataNascimento').val(objetoJson['dataNascimento']);
          $('#sexoPaciente').val(objetoJson['sexoPaciente']);
          $('#nomeMaePaciente').val(objetoJson['nomeMaePaciente']);
          $('#cepPaciente').val(objetoJson['cepPaciente']);
          $('#enderecoPaciente').val(objetoJson['enderecoPaciente']);
          $('#numeroEnderecoPaciente').val(objetoJson['numeroEnderecoPaciente']);
          $('#pontoRederencia').val(objetoJson['pontoRederencia']);
          $('#bairroPaciente').val(objetoJson['bairroPaciente']);
          $('#nomeCidadePaciente').val(objetoJson['nomeCidadePaciente']);
          $('#telefoneCelular1').val(objetoJson['telefoneCelular1']);
          $telefoneCelular1Whatsapp = objetoJson['telefoneCelular1Whatsapp']=="S" ? true : false;
          $('#telefoneCelular1Whatsapp').prop("checked",$telefoneCelular1Whatsapp);
          $('#telefoneCelular2').val(objetoJson['telefoneCelular2']);
          $telefoneCelular2Whatsapp = objetoJson['telefoneCelular2Whatsapp']=="S" ? true : false;
          $('#telefoneCelular2Whatsapp').prop("checked",$telefoneCelular2Whatsapp);
          $('#telefoneCelular3').val(objetoJson['telefoneCelular3']);
          $telefoneCelular3Whatsapp = objetoJson['telefoneCelular3Whatsapp']=="S" ? true : false;
          $('#telefoneCelular3Whatsapp').prop("checked",$telefoneCelular3Whatsapp);
          $("#bodyResultado").css("display","block");
        }
      });



    }
  }
</script>