<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php");
$usuarioLogado		= $_SESSION['idUsuarioLogado'];
$ibgeSedeSistema	= $_SESSION['ibgeSedeSistema'];
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-download-alt" style='margin-top:-15px !important'></i>&nbsp;Importar TXT CNES
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="icofont icofont-checked"></i><b>Selecionar arquivo compactado (formato ZIP)</b></h4>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label for="arquivoParaImportacao">Anexar arquivo:</label>
													<input type="text" id="nomeCompletoArquivo" name="nomeCompletoArquivo" class="form-control upload-fake" disabled>
													<input type="file" id="arquivoParaImportacao" name="arquivoParaImportacao" class="form-control upload-real" accept=".zip, .ZIP">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-50px'>
											<div class="col-md-12">
												<div class="form-group">
													<div class="bs-callout-danger callout-square callout-bordered mt-1">
														<div class="media align-items-stretch">
															<div class="media-left d-flex align-items-center bg-danger" style='padding:7px !important;'>
																<i class="icofont icofont-info-circle white font-medium-5"></i>
															</div>
															<div class="media-body" style='padding:7px !important; padding-left:10px !important'>
																<b>Atenção!</b> Este é um procedimento demorado que pode levar alguns minutos. Recomenda-se realizar esta importação em horário de pouco uso do do sistema.<br><br>
																<u><b>Ações que serão realizadas:</b></u><br>
																<b>1</b> - Atualização dos cadastros já existes.<br>
																<b>2</b> - Importação de novos estabelecimentos cadastrados.<br>
																<b>3</b> - Importação de novos profissionais cadastrados.<br>
																<b>4</b> - Importação dos vínculos dos profissional aos estabelecimentos.<br>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-34px'>
											<div class="col-md-12">
												<div class="form-group">
													<div class="bs-callout-warning callout-square callout-bordered mt-1">
														<div class="media align-items-stretch">
															<div class="media-left d-flex align-items-center bg-warning" style='padding:7px !important;'>
																<i class="icofont icofont-info-circle white font-medium-5"></i>
															</div>
															<div class="media-body" style='padding:7px !important; padding-left:10px !important'>
                                Após realizar o processamento do arquivo do CNES selecione na lista que será exibida, os o estabelecimentos que deseja atualizar e/importar.
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>										
										<h4 class="form-section" style='margin-top:-15px'>
											<table style='width:100%'>
												<tr>
													<td>
														<i class="icofont icofont-checked"></i><b>Selecione as unidades a serem importadas</b>
													</td>
													<td align='right'>
														<label style='color:#046B97; font-weight:bold'>Selecionar todos os estabelecimentos:</label>&nbsp;
													</td>
													<td style='text-align:right; width:10px; padding-right:15px'>
														<input type="checkbox" id="chkEstabelecimentoTodos" class="form-control checkbox-seleciona-procedimento-grupo" style='margin-top:-5px' onchange="selecionaEstabelecimentoTodos(this.checked)" disabled>
													</td>
												</tr>
											</table>
										</h4>
										<div class="row" style='margin-top:-20px'>
											<div class="col-md-12">
												<div class="form-group">
													<table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_unidades_importar'>
														<thead>
															<tr>
																<th style='text-align:center; width:50px'>IMPORTAR</th>
																<th style='width:33%'>NOME FANTASIA</th>
																<th>RAZÃO SOCIAL</th>
																<th style='text-align:center; width:150px'>Nº CNES</th>
																<th style='text-align:center; width:150px'>CNPJ</th>
																<th style='text-align:center; width:50px'>É PRIVADO</th>
															</tr>
														</thead>
														<tbody style="background-color:#ececec">
														</tbody>
													</table>
												</div>
											</div>
										</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<div class="barra-flutuante" style='margin-left:-150px'>
	<button type="button" class="btn btn-blue" onClick="ImportarCNES('processar-arquivo')">
		<i class="icofont icofont-inbox"></i> Processar Arquivo
	</button>
	<button type="button" class="btn btn-success" onClick="ImportarCNES('confirmar-importacao')" disabled id="btnConfirmarImportacao">
		<i class="icofont icofont-checked"></i> Confirmar Importação
	</button>
</div>


<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liImportarCNES").attr('class', 'active');
	$("#liImportarCNES").css("border-bottom", "2px solid #c4c8ca");

	$('#dados_unidades_importar').DataTable({
		"paging": false,
		"filter": false,
		"lengthChange": false,
		"info": false
	});


	$("#arquivoParaImportacao").change(function() {
		var nomeArquivo = this.files[0].name;
		$("#nomeCompletoArquivo").val(nomeArquivo);
	})

	function ImportarCNES(qOpcao) {
		var formularioDados = new FormData();
		switch (qOpcao) {
			case 'processar-arquivo':
				var nomeCompletoArquivo = $("#nomeCompletoArquivo").val();
				if (nomeCompletoArquivo == "") {
					swal("Carregar Arquivo.", "Você deve selecionar o arquivo a ser processado.", "error");
					return false;
				}
				$('#embacado').css('display', 'block');
				formularioDados.append('arquivoParaImportacao', $('#arquivoParaImportacao')[0].files[0]);
				formularioDados.append('opcaoProcessamento', 'processar-arquivo');

				$.ajax({
					type: 'POST',
					url: 'action/processar_txtcnes',
					data: formularioDados,
					processData: false,
					contentType: false
				}).done(function(resultadoRetorno) {
					var splitResultadoRetorno = resultadoRetorno.split("##");
					if (splitResultadoRetorno[0] == "erro") {
						$('#embacado').css('display', 'none');
						swal("Arquivo inválido", splitResultadoRetorno[1], "error");
						return false;
					} else {
						$('#embacado').css('display', 'none');
						swal("Arquivo Processado", splitResultadoRetorno[0], "success");
						$('#dados_unidades_importar').DataTable().destroy();
						$('#dados_unidades_importar tbody').empty().append(splitResultadoRetorno[1]);
						$('#dados_unidades_importar').DataTable({
							"paging": false,
							"filter": false,
							"lengthChange": false,
							"info": false
						});
						$("#chkEstabelecimentoTodos").prop('disabled', false);
					}
				});
				break;

			case 'confirmar-importacao':
				$('#embacado').css('display', 'block');
				formularioDados.append('opcaoProcessamento', 'confirmar-importacao');
				$.ajax({
					type: 'POST',
					url: 'action/processar_txtcnes',
					data: formularioDados,
					processData: false,
					contentType: false
				}).done(function(resultadoRetorno) {
					$('#embacado').css('display', 'none');
					swal("Importação Processada", "Os estabelecimentos selecionados, bem como os profissionais e seus respectivos vínculos foram importados e/ou atualizados com sucesso.", "success");
				});
				break;
		}
	}

	function selectionaImportaCNES(checkSelecionado, codigoEstabelecimento) {
		var valorSelecao = checkSelecionado == true ? "S" : "N";
		$.ajax({
			url: 'action/processar_txtcnes',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoProcessamento': "seleciona-estabelecimentos-importar-individual",
				'codigoEstabelecimento': codigoEstabelecimento,
				'valorSelecao': valorSelecao
			}
		}).done(function(resultadoRetorno) {
			var totalEstabelecimentos = $("#dados_unidades_importar").dataTable().fnSettings().fnRecordsTotal();
			var temUnidadeSelecionada = "N";
			for (itemSelecao = 1; itemSelecao <= totalEstabelecimentos; itemSelecao++) {
				if($("#selecionaUnidade" + itemSelecao).is(":checked")){
					temUnidadeSelecionada = "S";
				}
			}
			if(temUnidadeSelecionada=="S"){
				$("#btnConfirmarImportacao").prop('disabled',false);
			}else{
				$("#btnConfirmarImportacao").prop('disabled',true);
			}
		});
	}

	function selecionaEstabelecimentoTodos(checkSelecionado) {
		var totalEstabelecimentos = $("#dados_unidades_importar").dataTable().fnSettings().fnRecordsTotal();
		for (itemSelecao = 1; itemSelecao <= totalEstabelecimentos; itemSelecao++) {
			$("#selecionaUnidade" + itemSelecao).prop("checked", checkSelecionado);
		}
		var valorSelecao = checkSelecionado == true ? "S" : "N";
		$.ajax({
			url: 'action/processar_txtcnes',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoProcessamento': "seleciona-estabelecimentos-importar-todos",
				'valorSelecao': valorSelecao
			}
		}).done(function(resultadoRetorno) {
			if (valorSelecao == "S") {
				$("#btnConfirmarImportacao").prop('disabled', false);
			} else {
				$("#btnConfirmarImportacao").prop('disabled', true);
			}
		});

	}
</script>