<?php
session_start();
if(!isset($_SESSION['idUsuarioLogado'])){
	header("location: ./");
}
include_once("header.php");

$opcaoRelatorio			= $_GET['qrelatorio'];
$classActiveMenu		= "";
switch($opcaoRelatorio){
	case "agendamentos":
		$complementoTitulo				= "AGENDAMENTOS";
		$idPerfilUsuarioRelatorio = 4;
		$nomePerfil								= "AGENDADOR";
		$classActiveMenu					= "liRelAgendamentos";
	break;

	case "analises":
		$complementoTitulo				= "ANALISES";
		$idPerfilUsuarioRelatorio = 5;
		$nomePerfil								= "ANALISTA";
		$classActiveMenu					= "liRelAnalises";
	break;

	case "cancelamentos":
		$complementoTitulo				= "CANCELAMENTOS";
		$idPerfilUsuarioRelatorio = 5;
		$nomePerfil								= "ANALISTA";
		$classActiveMenu					= "liRelCancelamentos";
	break;

	case "entregas":
		$complementoTitulo				= "ENTREGAS DE MARCAÇÃO";
		$idPerfilUsuarioRelatorio = 3;
		$nomePerfil								= "SOLICITANTE";
		$classActiveMenu					= "liRelEntregas";
	break;

	case "solicitacoes":
		$complementoTitulo				= "SOLICITAÇÕES";
		$idPerfilUsuarioRelatorio = 3;
		$nomePerfil								= "SOLICITANTE";
		$classActiveMenu					= "liRelSolicitacoes";
	break;

	default:
		$idPerfilUsuarioRelatorio = "";
		$nomePerfil	= "";
	break;
}
?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
        <section id="ordering">
            <div class="row">							
                <div class="col-12">									
									<div class="card" style='border:gray 1px solid;' id="card-tela">
                        <div class="card-header" style="background: url(css/images/bg-title.png); background-repeat: repeat-x; height: 45px !important;">
                            <h4 class="card-title" style="font-size: 11pt; margin-top: -8px; color: #fff;">
                                <b><i class="fa fa-print"></i>&nbsp;IMPRESSÃO DE RELATÓRIOS - <?php echo $complementoTitulo;?></b>
                            </h4>
                            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                            <div class="heading-elements">
                                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                                    <li>
                                        <a data-action="collapse"><i class="ft-minus"></i></a>
                                    </li>
                                    <li>
                                        <a data-action="expand"><i class="ft-maximize"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-content collapse show">
													<div class="card-body">
														<form class="form">
															<div class="form-body">
																<h4 class="form-section" style='margin-top:-10px'>
																	<i class="ft-filter"></i> <b>Filtros para emissão do relatório.</b>
																</h4>
																<div class="row">

																</div>
																<div class="row">
																	<div class="col-md-2">
																		<div class="form-group">
																			<label for="documentoPaciente">CNS/CPF:</label>
																			<input type='text' id="documentoPaciente" class="form-control text-center" autofocus>
																		</div>
																	</div>																	
																	<div class="col-md-6">
																		<div class="form-group">
																			<table width='100%' style='margin-top:-3px'>
																				<tr>
																					<td colspan='3'><label for="">Período de Análise (Data Inicial e Data Final):</label></td>
																				</tr>
																				<tr>
																					<td width='50%'>
																						<input type="date" class="form-control text-center" id="dataInicial">
																					</td>
																					<td width='50%'>
																						<input type="date" class="form-control text-center" id="dataFinal">
																					</td>
																				</tr>
																			</table>
																		</div>
																	</div>
																	<div class="col-md-4">
																		<div class="form-group">
																			<label for="operadorSistema">Operador (<b>Consolidar ?</b>):</label>
																			<div class="input-group">
																				<select id="operadorSistema" class="form-control">
																					<optgroup label='TODOS OS OPERADORES'>
																						<option value='todos'>TODOS OS OPERADORES</option>
																					</optgroup>
																					<optgroup label='OPERADORES COM PERFIL ADMINISTRADOR'>
																						<?php
																							$stmOperadores	= $rsConexao->prepare("SELECT * FROM reg_tb_usuario WHERE (id_usuario_perfil='1' AND ativo='1' AND id_usuario!=1) GROUP BY (nome_usuario) ORDER BY nome_usuario");
																							$stmOperadores	-> execute();
																							$rsOperadores		= $stmOperadores->fetchAll(PDO::FETCH_ASSOC);
																							
																							foreach($rsOperadores AS $fieldOperador){
																								$idOperador		= $fieldOperador['id_usuario'];
																								$nomeOperador	= $fieldOperador['nome_usuario'];																																																																	
																								echo "<option value='$idOperador'>$nomeOperador</option>";
																							}	
																						?>
																					</optgroup>
																					<optgroup label="OPERADORES COM PERFIL <?php echo $nomePerfil;?>">
																					<?php
																						$stmOperadores	= $rsConexao->prepare("SELECT * FROM reg_tb_usuario WHERE (id_usuario_perfil='$idPerfilUsuarioRelatorio' AND ativo='1' AND id_usuario!=1) GROUP BY (nome_usuario) ORDER BY nome_usuario");
																						$stmOperadores	-> execute();
																						$rsOperadores		= $stmOperadores->fetchAll(PDO::FETCH_ASSOC);
																						
																						foreach($rsOperadores AS $fieldOperador){
																							$idOperador		= $fieldOperador['id_usuario'];
																							$nomeOperador	= $fieldOperador['nome_usuario'];																																																																	
																							echo "<option value='$idOperador'>$nomeOperador</option>";
																						}	
																					?>
																					</optgroup>
																				</select>
																				<div class="input-group-append">
																					<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																						<input type="checkbox" class="switch" id="consolidarOperador" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle"/>
																					</div>
																				</div>																				
																			</div>										
																		</div>
																	</div>
																</div>
																<div class="row">
																	<div class="col-md-4">
																		<div class="form-group">
																			<label for="grupoProcedimento">Grupo:</label>
																			<select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
																				<option value="">TODOS</option>
																				<?php
																					$stmGrupo	= $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE id_grupo_procedimento!='1' ORDER BY nome_grupo_procedimento");
																					$stmGrupo	->execute();
																					$rsGrupo = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
																					$totalGrupo	= $stmGrupo->rowCount();
																					if($totalGrupo>0){
																						echo "<option value='1'>NÃO AGRUPADOS</option>";
																						foreach($rsGrupo as $fieldGrupo){
																							$idGrupo = $fieldGrupo['id_grupo_procedimento'];
																							$nomeGrupo = mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
																							echo "<option value='$idGrupo'>$nomeGrupo</option>";
																						}
																					}
																				?>
																			</select>
																		</div>
																	</div>
																	<div class="col-md-5">
																		<div class="form-group">
																			<label for="nomeProcedimento">Nome de Procedimentos:</label>
																			<select class="form-control" id="nomeProcedimento">
																				<option value="">SELECIONE O GRUPO...</option>
																			</select>
																		</div>
																	</div>
																	<div class="col-md-3">
																		<div class="form-group">
																			<label for="dadosPaciente">Dados do Paciente:</label>
																			<div class="input-group">
																				<div class="input-group-append">
																					<div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
																						<input type="checkbox" class="switch" id="dadosPaciente" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle"/>
																					</div>
																				</div>
																			</div>																			
																		</div>	
																	</div>
																</div>
																<div class="row" style="margin-top:-30px !important">
																	<div class='col-md-12'>
																		<div class="form-group">
																		<div class="bs-callout-warning callout-square callout-bordered mt-1">
																			<div class="media align-items-stretch">
																				<div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
																					<i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
																				</div>
																				<div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
																					<strong>ATENÇÃO!</strong> <b>É importante que o relatório seja gerando realizando algum tipo de filtro. Relatórios sem filtro pode demorar muito para ser carregado e até causar lentidão ou travamento do sistema</b><br>
																					<strong>OBS!</strong><b> Ao informar que o sistema deve consolidar os dados do operadores, o sistema gerará um relatório com os quantitativos de cada operador que tiver registro no relatório selecionado.</b>
																				</div>
																			</div>
																		</div>
																		</div>
																	</div>
																</div>
																<div class="row">
																	<div class="col-md-12">
																		<div class="form-group">
																			<button type="button" class="btn btn-dark" onClick="imprimirRelatorio()">
																				<i class="ft-printer"></i> Visualizar e Imprimir
																			</button>
																		</div>
																	</div>
																</div>
															</div>															
														</form>
													</div>
												</div>
                </div>
            </div>
        </section>
    </div>
</div>

<?php
	include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>        
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>

$("#<?php echo $classActiveMenu;?>").attr('class', 'active');	
$("#<?php echo $classActiveMenu;?>").css("border-bottom", "2px solid #c4c8ca");	

function imprimirRelatorio(){

	var documentoPaciente	= $("#documentoPaciente").val();
	var dataInicial				= $("#dataInicial").val();
	var dataFinal					= $("#dataFinal").val();
	var operadorSistema		= $("#operadorSistema").val();	
	var grupoProcedimento	= $("#grupoProcedimento").val();
	var nomeProcedimento	= $("#nomeProcedimento").val();

	if((dataInicial!="" && dataFinal!="") && (dataInicial > dataFinal)){
		swal("Período Inváido","A data inicial não pode ser maior do que a data final", "error");
		return false;		
	}	

	if((dataInicial!="" && dataFinal=="") || (dataInicial=="" && dataFinal!="")){
		swal("Período Inváido","Para gerar o relatório por período você deve preencher corretamente os campos de data", "error");
		return false;		
	}	

	$("#embacado").css("display","block");
	$.ajax({				
    url: 'action/gerar_dadosrelatorio',
    type: 'post',
		dataType: 'html',
    data: {
			'opcaoRelatorio'		: "<?php echo $opcaoRelatorio;?>",
			'documentoPaciente'	:	documentoPaciente,
			'dataInicial'				:	dataInicial,
			'dataFinal'					:	dataFinal,
			'operadorSistema'		: operadorSistema,
			'grupoProcedimento'	: grupoProcedimento,
			'nomeProcedimento'	: nomeProcedimento,
			'dadosPaciente'			: document.getElementById('dadosPaciente').checked == true ? "S" : "N"
    }
  }).done(function(resultadoRetorno){		
		$("#embacado").css("display","none");		
		var urlRelatorio = document.getElementById('consolidarOperador').checked==false ? 'relatorios/imprimir_relatorio' : 'relatorios/imprimir_relatorio_consolidado';
		window.open(urlRelatorio);
  });
}

function filtrarProcedimentos(){

	$("#embacado").css("display","block");

	$.ajax({
		url: 'filtros/filtrar_procedimento',
		type: 'post',
		dataType: 'html',
		data: {
			'opcaoPesquisa'			: 'consultar-solicitacao',
			'grupoProcedimento'	: $("#grupoProcedimento").val()
		}
	}).done(function(resultadoRetorno){
		$("#procedimentoSelecionado").val("");
		$("#nomeProcedimento").html("");
		$("#nomeProcedimento").html(resultadoRetorno);
		$("#embacado").css("display","none");		
	});

}

</script>