<?php
$anoBase = date("Y");
if ($anoBase == '2022') {
  $copyRight = $anoBase;
} else {
  $copyRight = "2022 - " . $anoBase;
}
require("../database/dbConection.php");
// PEGAR DADOS DAS CONFIGURAÇÕES 
$sqlConfiguracoes = "SELECT reg_tb_configuracoes.*,
ucase(tb_cidades.nome_cidade) nomeMunicipio,
tb_cidades.sigla_estado
FROM tb_cidades
INNER JOIN reg_tb_configuracoes ON (tb_cidades.codigoibge_cidade = reg_tb_configuracoes.ibge_municipiogestor)";
$stmConfiguracoes	= $rsConexao->prepare($sqlConfiguracoes);
$stmConfiguracoes->execute();
$rsConfiguracoes    = $stmConfiguracoes->fetch(PDO::FETCH_OBJ);
$nomeMunicipioSede  = mb_strtoupper($rsConfiguracoes->nomeMunicipio);
$siglaEstado        = mb_strtoupper($rsConfiguracoes->sigla_estado);

?>
<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="Expansão Tecnologia e Consultoria">
  <meta name="author" content="Cláudio Magalhães">
  <title>G-Saúde - Módulo Regulação</title>
  <link rel="shortcut icon" type="image/x-icon" href="../app-assets/images/favicon.png">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i%7CMuli:300,400,500,700" rel="stylesheet">
  <!-- BEGIN VENDOR CSS-->
  <link rel="stylesheet" type="text/css" href="../app-assets/css/vendors.min.css">
  <link rel="stylesheet" type="text/css" href="../app-assets/vendors/css/ui/prism.min.css">
  <!-- END VENDOR CSS-->
  <!-- BEGIN ROBUST CSS-->
  <link rel="stylesheet" type="text/css" href="../app-assets/css/app.min.css">
  <!-- END ROBUST CSS-->
  <!-- BEGIN Page Level CSS-->
  <link rel="stylesheet" type="text/css" href="../app-assets/css/core/menu/menu-types/vertical-menu.min.css">
  <link rel="stylesheet" type="text/css" href="../app-assets/css/core/colors/palette-gradient.min.css">
  <!-- END Page Level CSS-->
  <!-- BEGIN Custom CSS-->
  <link rel="stylesheet" type="text/css" href="../assets/css/style.css">
  <link rel="stylesheet" type="text/css" href="css/mod_regulacao.css">
  <!-- END Custom CSS-->
  <link href="../app-assets/css/vegas.css" rel="stylesheet" type="text/css" />

  <style type="text/css">
    .titleColorbox {
      padding: 20px;
      background-color: #3e6298;
      border-radius: 6px;
      box-sizing: border-box;
      color: white;
      font-family: din-blackregular, Arial;
      font-size: 22px;
    }

    input:-webkit-autofill {
      -webkit-box-shadow: 0 0 0px 1000px #fbfafa inset !important;
      -webkit-text-fill-color: #bbbbbb !important;
    }

    body {
      background: url('../app-assets/images/telalogin/tela1.jpg') no-repeat center center fixed;
      -webkit-background-size: cover;
      -moz-background-size: cover;
      -o-background-size: cover;
      background-size: cover;
    }

    @media (max-width: 1024px) {
      .ChamadasTelaInicial {
        display: none;
      }

      .vegas-overlayMobile {
        opacity: .5;
        background: #7EBCA1 url(../assets/overlay/overlay-home.png) center center repeat;
        width: 100%;
        height: 100%;
        position: fixed;
      }

    }
  </style>

</head>

<body class="vertical-layout vertical-menu 1-column  bg-cyan bg-lighten-2 menu-expanded fixed-navbar" data-open="click" data-menu="vertical-menu" data-col="1-column" style="background-color:#0B2F3A !important">

  <div class="vegas-overlayDots">&nbsp;</div>
  <span class="vegas-overlayMobile"></span>

  <style type="text/css">
    .black_overlay {
      display: block;
      position: absolute;
      top: 0%;
      left: 0%;
      width: 100%;
      height: 100%;
      background-color: black;
      z-index: 999999999;
      -moz-opacity: 0.3;
      opacity: .30;
      filter: alpha(opacity=30);
    }

    .container {
      width: 100vw;
      height: 100vh;
      display: flex;
      flex-direction: row;
      justify-content: center;
      align-items: center
    }
  </style>


  <div id="embacado" style="top:0px">
    <table align="center" class="tbEmbacado">
      <tr>
        <td align="center"><br>
          <img src="../app-assets/images/processando.gif" width="100px" height="100px">
          <div id="processandoDados" style="margin-top:20px;">Aguarde! Validando acesso...</div>
        </td>
      </tr>
    </table>
  </div>
  <div class="app-content content">
    <div class="content-wrapper">
      <div class="content-header row">
      </div>
      <div class="content-body"><br><br>
        <section class="flexbox-container">
          <div class="col-12 d-flex align-items-center justify-content-center">
            <div class="col-md-3 col-10 box-shadow-2 p-0" style="border: 2px solid #346aff">
              <div class="card border-grey border-lighten-3 m-0">
                <div class="card-header border-0 bglogin-title-login">
                  <div class="card-title text-center">
                    <img src="css/images/logo-dark.png" alt="logomarca sistema">
                  </div>
                </div>
                <div class="card-content" style='margin-top:10px'>
                  <div class="card-body pt-0">
                    <form id="login-form" class="form-horizontal" role="form" action="validar_acesso" method="post">
                      <label for="login_acesso"><b>Seu CPF:</b></label>
                      <fieldset class="form-group position-relative has-icon-left">
                        <input type="text" class="form-control input-lg cpf-inputmask" id="login_acesso" autofocus autocomplete="off" onkeypress="teclouEnter()" onblur="validaCPF(this.value)">
                        <div class="form-control-position" style='margin-top:-4px'>
                          <i class="fa fa-address-card"></i>
                        </div>
                      </fieldset>
                      <label for="senha_acesso"><b>Sua senha:</b></label>
                      <fieldset class="form-group position-relative has-icon-left">
                        <input type="password" class="form-control input-lg" id="senha_acesso" onkeypress="teclouEnter()">
                        <div class="form-control-position" style='margin-top:-4px'>
                          <i class="fa fa-key"></i>
                        </div>
                      </fieldset>
                      <button type="button" class="btn btn-info btn-lg btn-block" id="btn-login" onclick="validarLogin()"><i class="fa fa-check-square-o"></i> CONFIRMAR</button>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
    </div>
  </div>
  <!-- ////////////////////////////////////////////////////////////////////////////-->
  <div class="buy-now" style='text-align:right !important'>
    <a href="https://www.essencial.tec.br" target="_blank" class="btn bg-gradient-directional-blue white btn-blue btn-glow">
      Uso autorizado para: <b><?php echo $nomeMunicipioSede.'-'.$siglaEstado;?></b>
    </a>
  </div>
  <div class="buy-now" style='text-align:right !important'>
    <a href="https://www.essencial.tec.br" target="_blank" class="btn bg-gradient-directional-blue white btn-blue btn-glow">
      Uso autorizado para: <b><?php echo $nomeMunicipioSede.'-'.$siglaEstado;?></b>
    </a>
  </div>
  <footer class="footer fixed-bottom footer-dark navbar-border">
    <p class="clearfix blue-grey lighten-2 text-sm-center mb-0 px-2"><span class="float-md-left d-block d-md-inline-block">Copyright &copy; <?php echo $copyRight; ?> Todos os direitos reservados.</span>
      <span class="float-md-right d-block d-md-inline-blockd-none d-lg-block">
        Desenvolvido por:&nbsp;
        <a href='https://www.essencial.tec.br/' target='_blank'>
          <img src='https://www.essencial.tec.br/assets/images/favicon.png' style='height:20px; margin-top:-5px'>&nbsp;
          Expansão Tecnologia e Consultoria
        </a>
      </span>
    </p>
  </footer>
  <!-- BEGIN VENDOR JS-->
  <script src="../app-assets/vendors/js/vendors.min.js"></script>
  <!-- BEGIN VENDOR JS-->
  <!-- BEGIN PAGE VENDOR JS-->
  <script src="../app-assets/vendors/js/forms/validation/jqBootstrapValidation.js"></script>
  <!-- END PAGE VENDOR JS-->
  <!-- BEGIN ROBUST JS-->
  <script src="../app-assets/js/core/app-menu.min.js"></script>
  <script src="../app-assets/js/core/app.min.js"></script>
  <script src="../app-assets/js/scripts/customizer.min.js"></script>
  <!-- END ROBUST JS-->
  <!-- BEGIN PAGE LEVEL JS-->
  <script src="../app-assets/js/scripts/forms/form-login-register.min.js"></script>
  <!-- END PAGE LEVEL JS-->
  <script src="../app-assets/js/scripts/vegas/vegas.min.js" type="text/javascript"></script>
</body>

</html>

<script>
  function validaCPF(numeroCPF) {

    var numeros, digitos, soma, i, resultado, digitos_iguais;
    digitos_iguais = 1;

    var cpfLimpo = numeroCPF.replace(/[^a-z0-9]/gi, '');

    if (cpfLimpo != "") {
      for (i = 0; i < cpfLimpo.length - 1; i++)
        if (cpfLimpo.charAt(i) != cpfLimpo.charAt(i + 1)) {
          digitos_iguais = 0;
          break;
        }
      if (!digitos_iguais) {
        numeros = cpfLimpo.substring(0, 9);
        digitos = cpfLimpo.substring(9);
        soma = 0;
        for (i = 10; i > 1; i--)
          soma += numeros.charAt(10 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0)) {
          $("#login_acesso").val("");
          swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
          return false;
        }
        numeros = cpfLimpo.substring(0, 10);
        soma = 0;
        for (i = 11; i > 1; i--)
          soma += numeros.charAt(11 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1)) {
          $("#login_acesso").val("");
          swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
          return false;
        } else {
          return true;
        }
      } else {
        $("#login_acesso").val("");
        swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
        return false;
      }
      return false;
    } else {
      return true;
    }
  }

  function validarLogin() {

    if ($("#login_acesso").val() == "" || $("#senha_acesso").val() == "") {
      swal("Acesso ao Sistema", "Informe CPF e Senha para acessar o sistema!", "warning");
      return false;
    }
    if (document.getElementById('embacado').style.display == "block") {
      return false;
    }
    $('#embacado').css("display", "block");
    $.ajax({
      url: 'validar_acesso',
      type: 'post',
      dataType: 'html',
      data: {
        'loginAcesso': $("#login_acesso").val(),
        'senhaAcesso': $("#senha_acesso").val()
      }
    }).done(function(resultadoRetorno) {

      var retornoResultado = resultadoRetorno.split("##");
      if (retornoResultado[0] == "sucesso") {
        window.location.href = retornoResultado[1];
      } else {
        $('#embacado').css("display", "none");
        swal("Acesso ao Sistema", retornoResultado[1], "error");
      }
    });
  }

  function teclouEnter() {

    var keyNum;
    if (window.event) {
      keyNum = event.keyCode
    } else if (e.which) {
      keyNum = event.which
    }

    if (keyNum == 13) {
      validarLogin();
    }

  }
</script>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/forms/extended/maxlength/bootstrap-maxlength.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-maxlength.min.js"></script>
<script src="../app-assets/vendors/js/extensions/sweetalert2.all.min.js"></script>

<script type="text/javascript">
  $(document).ready(function() {
    $(".ChamadasTelaInicial").animate({
      opacity: 0
    }, 1000).animate({
      "opacity": "1"
    }, 4000, 'easeInOutQuint', null);
  });

  $("#example, body").vegas({
    delay: 6000,
    overlay: true,
    animation: 'random',
    animationDuration: 6000,
    timer: false,
    transition: 'blur',
    slides: [{
        src: "../app-assets/images/telalogin/tela1.jpg"
      },
      {
        src: "../app-assets/images/telalogin/tela2.jpg"
      },
      {
        src: "../app-assets/images/telalogin/tela3.jpg"
      },
      {
        src: "../app-assets/images/telalogin/tela4.jpg"
      }
    ]
  });
</script>