const { Client } = require('pg');
const dotenv = require('dotenv');
const fs = require('fs');

dotenv.config();

const envData = fs.readFileSync('conecta.env', 'utf8');
const envVariables = dotenv.parse(envData);

const { DB_PG_SERVER, DB_PG_PORT, DB_PG_USERNAME, DB_PG_PASSWORD, DB_PG_NAME } = envVariables;

// Ativa debug do pg
process.env.DEBUG = 'pg*';

async function testPg() {
  const pgClient = new Client({
    host: DB_PG_SERVER,
    port: Number(DB_PG_PORT),
    user: DB_PG_USERNAME,
    password: DB_PG_PASSWORD,
    database: DB_PG_NAME,
    connectionTimeoutMillis: 20000,
    searchPath: ['public'],
  });

  try {
    
    await pgClient.connect();
    console.log('Conectado');

    console.log('fazendo teste');
    const res = await pgClient.query('SELECT 1 AS teste');
    console.log('resultado ', res.rows);
    const queryTeste = `
       SELECT table_schema, table_name 
  FROM information_schema.tables 
  WHERE table_name = 'tb_atend_prof';
    `;
    const res2 = await pgClient.query(queryTeste);
    console.log('Query real ', res2.rows);

  } catch (err) {
    console.error('Erro ao executar:', err);
  } finally {
    await pgClient.end();
    console.log('encerrada');
  }
}

testPg();
