const { exec } = require('child_process');
const path = require('path');
const fs = require('fs');

function executeScript(scriptPath) {
  return new Promise((resolve, reject) => {
    exec(`node "${scriptPath}"`, (error, stdout, stderr) => {
      if (error) {
        reject(`Erro ao executar ${scriptPath}: ${error.message}`);
      } else if (stderr) {
        reject(`Erro na execução de ${scriptPath}: ${stderr}`);
      } else {
        resolve(stdout);
      }
    });
  });
}

async function main() {
  const startTime = Date.now();
  const gerar_tokenPath = path.resolve(__dirname, 'gerar_token.js');  

  //---------- ENVIO SEM OCI --------------//
  const envio_pentende_antigo = path.resolve(__dirname, 'envio_solicitacao_pendente_antigo.js');
  const envio_pentende_atual_semoci = path.resolve(__dirname, 'envio_solicitacao_pendente_atual_semoci.js');
  const envio_solicitacao_cancelada = path.resolve(__dirname, 'envio_solicitacao_cancelada.js');
  const envio_agendado_semoci = path.resolve(__dirname, 'envio_solicitacao_agendada_semoci.js');  
  const envio_agendado_atendido_semoci = path.resolve(__dirname, 'envio_solicitacao_agendadaatendida_semoci.js');

  //---------- ENVIO COM OCI --------------//
  //const envio_pentende_atual_comoci = path.resolve(__dirname, 'envio_solicitacao_pendente_atual_comoci.js');
  //const envio_agendado_comoci = path.resolve(__dirname, 'envio_solicitacao_agendada_semoci.js.js');  
  
  console.log(`
    _____             _____        _    _ _____  ______            
   / ____|           / ____|  /\\  | |  | |  __ \\|  ____|           
  | |  __   ______  | (___   /  \\ | |  | | |  | | |__              
  | | |_ | |______|  \\___ \\ / /\\ \\| |  | | |  | |  __|             
  | |__| |           ____) / ____ \\ |__| | |__| | |____            
   \\_____|______ ___|_____/_/ _  \\_\\____/|_____/|______|     ____  
  |  __ \\|  ____/ ____| |  | | |        /\\   / ____|   /\\   / __ \\ 
  | |__) | |__ | |  __| |  | | |       /  \\ | |       /  \\ | |  | |
  |  _  /|  __|| | |_ | |  | | |      / /\\ \\| |      / /\\ \\| |  | |
  | | \\ \\| |___| |__| | |__| | |____ / ____ \\ |____ / ____ \\ |__| |
  |_|  \\_\\______\\_____|\____/|______/_/    \\_\\_____/_/    \\_\\____/  
  `);
  
  console.log('SINCRONIZANDO');

  await executeScript(gerar_tokenPath);
  const tokenInterval = setInterval(async () => {
    try {
      const output = await executeScript(gerar_tokenPath);
      console.log(`Geração de token: ${output}`);
    } catch (err) {
      console.error(err);
    }
  }, 28 * 60 * 1000);

  try {
   
    await Promise.all([      
      executeScript(envio_pentende_antigo),
      executeScript(envio_pentende_atual_semoci),
      executeScript(envio_solicitacao_cancelada),
      executeScript(envio_agendado_semoci),
      executeScript(envio_agendado_atendido_semoci)      
      //executeScript(envio_agendado),	
      //executeScript(envio_compareceu)
    ]);

    console.log('Todos os envios concluídos.');
  } catch (error) {
    console.error(error);
  } finally {
   
    clearInterval(tokenInterval);

    const endTime = Date.now();
    const executionTime = (endTime - startTime) / 1000; 

    const minutes = Math.floor(executionTime / 60);
    const seconds = Math.floor(executionTime % 60);
    const dataExecucao = new Date().toISOString(); 

    const logMessage = `SINCRONIZADO EM ${minutes} MINUTOS E ${seconds} SEGUNDOS - DATA DE EXECUÇÃO: ${dataExecucao}\n`;

    
    fs.appendFile('tempo_envio.txt', logMessage, (err) => {
      if (err) {
        console.error('Erro ao salvar no arquivo:', err);
      } else {
        console.log('Tempo de execução salvo em tempo_envio.txt');
      }
    });

    console.log(`SINCRONIZADO EM ${minutes} MINUTOS E ${seconds} SEGUNDOS`);
  }
}

main(); 