<?php
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$unidadeLogada      = $_SESSION['unidadeLogada'];
$dataHoje           = date("Y-m-d");
$contadorRegistros  = 0;
$unidadeLogadaUsaPeinel = $_SESSION['unidadeLogadaUsaPeinel'];
$executanteAtendimentoConsultorio = $_SESSION['executanteAtendimentoConsultorio'];
if ($unidadeLogadaUsaPeinel == "N") {
?>
  <div class="app-content content" style="background-color: #e9e9e7;">
    <div class="content-wrapper" style="padding: 10px;">
      <div class="content-body">
        <div class="row">
          <div class="col-12">
            <div class="card" style='margin-top:-5px'>
              <div class="card-content">
                <div class="card-body">
                  <div class="form-body">
                    <h4 class="form-section h4-painel">
                      <i class="icofont icofont-calendar" style='font-size:16pt'></i><b>&nbsp;Pacientes agendados para hoje:</b>
                    </h4>
                  </div>
                  <div class="row">
                    <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
                      <div class="pb-1">
                        <div class="clearfix mb-1" style='border-bottom: 2px solid #2196F3'>
                          <i class="icofont icofont-files font-large-1 blue float-left mt-1 novo-tamanho-icofont">
                            <font class='font-painel'>&nbsp;Atendimentos Esperados</font>
                          </i>
                          <span class="font-large-2 text-bold-600 blue float-right" id='totalAtendimentos'>&nbsp;</span>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top: -20px;">
                    <div class="col-md-12">
                      <div class="form-group">
                        <table width='100%' style="border-left: 0px;border-right: 0px;">
                          <thead style='background-color:#06abfdb4; color:#000'>
                            <tr style='height: 30px;'>
                              <th scope='col' style='border:1px solid gray; padding:8px; text-align:left'>NOME DO PACIENTE:</th>
                              <th scope='col' style='border:1px solid gray; padding:8px;text-align: center'>IDADE</th>
                              <th scope='col' style='border:1px solid gray; padding:8px;text-align: center'>CARTÃO SUS</th>
                              <th scope='col' style='border:1px solid gray; padding:8px;text-align: center'>CPF</th>
                              <th scope='col' style='border:1px solid gray; padding:8px;text-align: center'>TELEFONE</th>
                              <th scope='col' style='border:1px solid gray; padding:8px;text-align: center'>PROTOCOLO</th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php
                            $nomeProcedimentoHeader = "";
                            $sqlAgendamentos = "SELECT ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
                              reg_tb_agendamentos.horario_atendimento,
                              reg_tb_agendamentos.data_atendimento,
                              reg_tb_agendamentos.protocolo_agendamento,
                              ucase(tb_paciente.nome_paciente) AS nomePaciente,
                              TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
                              tb_paciente.celular1,
                              tb_paciente.cns_paciente,
                              tb_paciente.cpf_paciente,
                              tb_paciente.condicaosaude_pcd,
                              tb_paciente.condicaosaude_pcddescricao
                              FROM tb_paciente
                              INNER JOIN reg_tb_agendamentos ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
                              INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
                              INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
                              WHERE (reg_tb_agenda.codigoestabelecimento_cnes='$unidadeLogada')
                              AND (reg_tb_agendamentos.data_atendimento='$dataHoje')
                              AND (reg_tb_agendamentos.status_agendamento='E' OR reg_tb_agendamentos.status_agendamento='V' OR reg_tb_agendamentos.status_agendamento='A')
                              GROUP BY reg_tb_procedimento.nome_procedimento,
                              reg_tb_agendamentos.data_atendimento,
                              tb_paciente.nome_paciente
                              ORDER BY horario_atendimento, nome_paciente";
                            $stmAtendimentos = $rsConexao->prepare($sqlAgendamentos);
                            $stmAtendimentos->execute();
                            if ($stmAtendimentos->rowCount() > 0) {
                              $rsAtendimentos = $stmAtendimentos->fetchAll(PDO::FETCH_ASSOC);
                              foreach ($rsAtendimentos as $fieldAtendimentos) {
                                $contadorRegistros  = $contadorRegistros + 1;
                                $nomePaciente     = $fieldAtendimentos['nomePaciente'];
                                $idadePaciente    = $fieldAtendimentos['idadePaciente'];
                                $cnsPaciente      = $fieldAtendimentos['cns_paciente'];
                                $cpfPaciente      = $fieldAtendimentos['cpf_paciente'];
                                $telefonePaciente = $fieldAtendimentos['celular1'];
                                $horaAtendimento  = $fieldAtendimentos['horario_atendimento'];
                                $numeroProtocolo  = $fieldAtendimentos['protocolo_agendamento'];
                                $pacientePCD      = $fieldAtendimentos['condicaosaude_pcd'] == "S" ? $iconePCD = "- <b><i class='icofont icofont-paralysis-disability'></i></b>" : "";
                                if (mb_strtoupper($fieldAtendimentos['nomeProcedimento']) != $nomeProcedimentoHeader) {
                                  $nomeProcedimento = $fieldAtendimentos['nomeProcedimento'];
                                  $nomeProcedimentoHeader = $nomeProcedimento;
                                  echo "<tr><td style='font-size:1pt'>&nbsp;</td></tr>
                                      <tr style='background:#eeeeee;border-bottom:1px dotted gray''>
                                        <td colspan='6' style='padding:6px'>
                                          <b>PROCEDIMENTO: $nomeProcedimento</b>
                                        </td>
                                      </tr>";
                                }

                                echo "<tr>
                                      <td style='border:1px solid gray; padding:5px; text-align:left'>$horaAtendimento - $nomePaciente</td>
                                      <td style='border:1px solid gray; padding:5px; text-align:center'>$idadePaciente</td>
                                      <td style='border:1px solid gray; padding:5px; text-align:center'>$cnsPaciente</td>
                                      <td style='border:1px solid gray; padding:5px; text-align:center'>$cpfPaciente</td>
                                      <td style='border:1px solid gray; padding:5px; text-align:center'>$telefonePaciente</td>
                                      <td style='border:1px solid gray; padding:5px; text-align:center'>$numeroProtocolo</td>
                                    </tr>";
                              }
                            }
                            echo "
                                </tbody>
                                </table>";
                            ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
} else {
  if ($executanteAtendimentoConsultorio == "N") {
    include_once("include/box_incluir_atendimentoextra.php")
  ?>
    <div class="app-content content" style="background-color: #e9e9e7;">
      <div class="content-wrapper" style="padding: 15px;">
        <div class="content-body">
          <div class="row">
            <div class="col-12">
              <div class="card barra-titulo" style="height: 70px; border:1px dotted #289CD4">
                <div class="card-content">
                  <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                    <div class="form-body">
                      <h4 class="form-section" style='font-size:16pt'>
                        <i class="icofont icofont-architecture-alt nova_fonte_blue" style='font-size:20pt'></i><b>&nbsp;Atendimentos para hoje:</b>
                      </h4>
                    </div>
                  </div>
                </div>
              </div>
              <div class="card barra-titulo" style="height: autp; border:1px dotted #289CD4; margin-top:-20px">
                <div class="card-content">
                  <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                    <h4 class="form-section success" style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                      <table width='100%'>
                        <tr>
                          <td style='text-align:left'>
                            <i class="icofont icofont-list"></i> <b>Lista de Pacientes</b>
                          </td>
                          <td style='text-align:right'>
                            <button type="button" class="btn btn-green" onClick="adicionarVagaExtra('abrir-popup')" id="btnVagaExtra">
                              <i class="icofont icofont-medical-sign"></i>&nbsp;&nbsp;Adicionar Atendimento Extra
                            </button>
                          </td>
                        </tr>
                      </table>
                    </h4><br>
                    <div class="row" style='margin-top:-20px'>
                      <div class="col-md-12">
                        <div class="form-group">
                          <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='pacientes_hoje'>
                            <thead>
                              <th style='text-align:center; width:100px'>OPÇÃO</th>
                              <th style='text-align:center; width:40px'>HORÁRIO</th>
                              <th>NOME DO PACIENTE / PROFISSIONAL / PROCEDIMENTO</th>
                              <th style='text-align:center; width:100px'>CNS</th>
                              <th style='text-align:center; width:50px'>IDADE</th>
                              <th style='text-align:center; width:80px'>SEXO</th>
                              <th style='text-align:center; width:100px'>TELEFONES</th>
                            </thead>
                            <tbody style="background-color:#ececec">
                              <?php
                              $sqlAgendamentos = "SELECT tb_paciente.id_paciente,
                                ucase(tb_paciente.nome_paciente) AS nomePaciente,
                                TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
                                tb_paciente.celular1,
                                tb_paciente.celular2,
                                tb_paciente.celular3,
                                tb_paciente.cns_paciente,
                                tb_paciente.sexo,
                                tb_paciente.condicaosaude_pcd,
                                tb_paciente.condicaosaude_pcddescricao,
                                ucase(tb_profissional.nome_profissional) AS nomeProfissional,
                                tb_profissional.codigoprofissional_cnes,
                                reg_tb_agendamentos.horario_atendimento,
                                reg_tb_agendamentos_atender.status_atendimento_painel,
                                reg_tb_agendamentos_atender.tipo_atendimento_painel,
                                reg_tb_agendamentos_atender.observacao_recepcao_painel,
                                reg_tb_agenda.id_agenda
                                FROM reg_tb_agenda
                                INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
                                INNER JOIN reg_tb_agendamentos ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
                                INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
                                LEFT OUTER JOIN reg_tb_agendamentos_atender ON (reg_tb_agendamentos.id_paciente = reg_tb_agendamentos_atender.id_paciente)
                                WHERE (reg_tb_agenda.codigoestabelecimento_cnes = '$unidadeLogada')
                                AND (reg_tb_agendamentos.status_agendamento = 'E' OR reg_tb_agendamentos.status_agendamento = 'V' OR reg_tb_agendamentos.status_agendamento = 'A')
                                AND (reg_tb_agendamentos.data_atendimento = '$dataHoje')
                                GROUP BY tb_paciente.nome_paciente
                                ORDER BY reg_tb_agendamentos.horario_atendimento ASC, tb_paciente.nome_paciente ASC";

                              $stmAtendimentos = $rsConexao->prepare($sqlAgendamentos);
                              $stmAtendimentos->execute();

                              if ($stmAtendimentos->rowCount() > 0) {
                                $rsAtendimentos = $stmAtendimentos->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($rsAtendimentos as $fieldAtendimentos) {
                                  $idPaciente         = $fieldAtendimentos['id_paciente'];
                                  $idAgenda           = $fieldAtendimentos['id_agenda'];
                                  $nomePaciente       = $fieldAtendimentos['nomePaciente'];
                                  $cnsPaciente        = $fieldAtendimentos['cns_paciente'];
                                  $idadePaciente      = $fieldAtendimentos['idadePaciente'];
                                  $sexoPaciente       = $fieldAtendimentos['sexo'] == "M" ? "MASCULINO" : "FEMININO";
                                  $telefonePaciente   = $fieldAtendimentos['celular1'] != "" ? $fieldAtendimentos['celular1'] : "";
                                  $telefonePaciente   = $fieldAtendimentos['celular2'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentos['celular2'] : $telefonePaciente;
                                  $telefonePaciente   = $fieldAtendimentos['celular3'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentos['celular3'] : $telefonePaciente;
                                  $horaAtendimento    = $fieldAtendimentos['horario_atendimento'];
                                  $chaveHorarioAtend  = str_replace(":", "", $fieldAtendimentos['horario_atendimento']);
                                  $nomeProfissional   = $fieldAtendimentos['nomeProfissional'];
                                  $codigoProfissional = $fieldAtendimentos['codigoprofissional_cnes'];
                                  $descricaoPCD       = $fieldAtendimentos['condicaosaude_pcddescricao'];
                                  $pacientePCD        = $fieldAtendimentos['condicaosaude_pcd'] == "S" ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
                                  $statusAtendimentoPainel = $fieldAtendimentos['status_atendimento_painel'];

                                  $tipoAtendimentopainel  = $fieldAtendimentos['tipo_atendimento_painel'];
                                  $observacaorecepcao     = $fieldAtendimentos['observacao_recepcao_painel'];

                                  # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
                                  switch ($statusAtendimentoPainel) {
                                    case "":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
                                        Status: Não Confirmado
                                      </div>";
                                      break;
                                    case "Aguardando":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                    case "Em Atendimento":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                    case "Atendido":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                  }

                                  $cmdConfirmarPresenca = 'onClick="confirmarPresenca(' . "'abrir-popup','$idPaciente##$idAgenda##$nomePaciente')" . '"';
                                  $btnConfirmarPresenca = "<i id='btnConfirma$idPaciente' class='icofont icofont-checked nova_fonte_blue' style='font-size:18pt !important' title='Confirmar presença.' $cmdConfirmarPresenca></i>";

                                  if ($fieldAtendimentos['status_atendimento_painel'] != "Em Atendimento" && $fieldAtendimentos['status_atendimento_painel'] != "Finalizado") {
                                    $cmdCancelarConfirmacao = 'onclick="cancelarConfirmacaoPresenca(' . "'$idPaciente')" . '"';
                                    $btnCancelarConfirmacao = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' style='font-size:17pt !important' title='Cancelar confirmação de presença.' $cmdCancelarConfirmacao></i>";
                                  } else {
                                    $btnCancelarConfirmacao = "";
                                  }

                                  # -- CARREGAR PROCEDIMENTOS AGENDADOS --#
                                  $sqlProcedimento = "SELECT reg_tb_procedimento.nome_procedimento,
                                  reg_tb_agendamentos.id_paciente,
                                  reg_tb_agendamentos.id_agendamento
                                  FROM reg_tb_procedimento
                                  INNER JOIN reg_tb_agendamentos ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
                                  INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
                                  INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
                                  INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
                                  WHERE (reg_tb_agenda.codigoestabelecimento_cnes='$unidadeLogada')
                                  AND (reg_tb_agendamentos.status_agendamento='E' OR reg_tb_agendamentos.status_agendamento='V' OR reg_tb_agendamentos.status_agendamento='A')
                                  AND (reg_tb_agendamentos.data_atendimento='$dataHoje')        
                                  AND (reg_tb_agendamentos.horario_atendimento='$horaAtendimento')        
                                  AND (reg_tb_agendamentos.id_paciente='$idPaciente')
                                  GROUP BY (reg_tb_procedimento.nome_procedimento)
                                  ORDER BY (reg_tb_procedimento.nome_procedimento)";
                                  $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
                                  $stmProcedimento->execute();
                                  if ($stmProcedimento->rowCount()) {
                                    $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                    $nomeProcedimento    = "";
                                    foreach ($rsProcedimento as $fieldProcedimento) {
                                      if ($nomeProcedimento == "") {
                                        $nomeProcedimento  = "&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
                                      } else {
                                        $nomeProcedimento  = "$nomeProcedimento<br>&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
                                      }
                                    }
                                  }

                                  echo "<tr style='background-color:#fff'>
                                    <td align='center' style='width:100px'>
                                      $btnConfirmarPresenca
                                      $btnCancelarConfirmacao
                                    </td>
                                    <td align='center' style='font-size:10pt;width:40px'>$horaAtendimento</td>
                                    <td style='font-size:9pt; padding:8px;'>
                                      <b>
                                        <table width='100%' style='background-color:transparent !important;'>
                                          <tr>
                                            <td style='background-color:transparent; border:0px; padding:0px; font-size:11pt'>
                                              Paciente: $nomePaciente $pacientePCD
                                            </td>
                                            <td style='background-color:transparent; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                                              <table align='right'>
                                                <tr>
                                                  <td style='padding:2px; border:0px' id='tdStatus$idPaciente-$idAgenda'>
                                                    $htmlAtendimentoPainel
                                                  </td>
                                              </tr>
                                            </table>
                                          </td>
                                        </tr>
                                      </table>              
                                      <hr style='margin-top:1px; border-top: 1px dashed #860000'>
                                      <div style='width:auto; padding:2px; color:#027fbe;margin-top:-10px'>
                                        Profissional: $nomeProfissional
                                      </div>
                                      <div style='width:auto; padding:2px; color:#0d5e03'>
                                          $nomeProcedimento
                                      </div>
                                    </b>
                                  </td>
                                    <td align='center' style='font-size:9pt; width:100px'>$cnsPaciente</td>
                                    <td align='center' style='font-size:9pt; width:50px'>$idadePaciente</td>
                                    <td align='center' style='font-size:9pt; width:80px'>$sexoPaciente</td>
                                    <td align='center' style='font-size:8pt; width:100px'>$telefonePaciente</td>
                                </tr>";
                                }
                              }
                              # -- exibir pacientes de atendimento extra -- #
                              $sqlAtendimentoExtra = "SELECT tb_paciente.id_paciente,
                                ucase(tb_paciente.nome_paciente) AS nomePaciente,
                                tb_paciente.cns_paciente,
                                timestampdiff(year,tb_paciente.datanasc,curdate()) AS idadePaciente,
                                tb_paciente.sexo,
                                tb_paciente.celular1,
                                tb_paciente.celular2,
                                tb_paciente.celular3,
                                tb_paciente.condicaosaude_pcd,
                                tb_paciente.condicaosaude_pcddescricao,
                                ucase(tb_profissional.nome_profissional) AS nomeProfissional,
                                tb_profissional.codigoprofissional_cnes,
                                reg_tb_agendamentos_atender.id_agenda,
                                reg_tb_agendamentos_atender.status_atendimento_painel,
                                reg_tb_agendamentos_atender.tipo_atendimento_painel,
                                reg_tb_agendamentos_atender.observacao_recepcao_painel,
                                reg_tb_agendamentos_atender.horario_atendimento
                                FROM tb_paciente
                                INNER JOIN reg_tb_agendamentos_atender ON (tb_paciente.id_paciente = reg_tb_agendamentos_atender.id_paciente)
                                INNER JOIN tb_profissional ON (tb_profissional.codigoprofissional_cnes = reg_tb_agendamentos_atender.codigoprofissional_cnes)
                                WHERE (reg_tb_agendamentos_atender.codigoestabelecimento_cnes = '$unidadeLogada')
                                AND (reg_tb_agendamentos_atender.data_atendimento = '$dataHoje')
                                AND (reg_tb_agendamentos_atender.origem_atendimento = 'extra')
                                GROUP BY tb_paciente.nome_paciente
                                ORDER BY reg_tb_agendamentos_atender.horario_atendimento ASC, tb_paciente.nome_paciente ASC";
                              $stmAtendimentoExtra = $rsConexao->prepare($sqlAtendimentoExtra);
                              $stmAtendimentoExtra->execute();

                              if ($stmAtendimentoExtra->rowCount() > 0) {
                                $rsAtendimentoExtra = $stmAtendimentoExtra->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($rsAtendimentoExtra as $fieldAtendimentoExtra) {
                                  $idPaciente         = $fieldAtendimentoExtra['id_paciente'];
                                  $idAgenda           = $fieldAtendimentoExtra['id_agenda'];
                                  $nomePaciente       = $fieldAtendimentoExtra['nomePaciente'];
                                  $cnsPaciente        = $fieldAtendimentoExtra['cns_paciente'];
                                  $idadePaciente      = $fieldAtendimentoExtra['idadePaciente'];
                                  $sexoPaciente       = $fieldAtendimentoExtra['sexo'] == "M" ? "MASCULINO" : "FEMININO";
                                  $telefonePaciente   = $fieldAtendimentoExtra['celular1'] != "" ? $fieldAtendimentoExtra['celular1'] : "";
                                  $telefonePaciente   = $fieldAtendimentoExtra['celular2'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentoExtra['celular2'] : $telefonePaciente;
                                  $telefonePaciente   = $fieldAtendimentoExtra['celular3'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentoExtra['celular3'] : $telefonePaciente;
                                  $horaAtendimento    = $fieldAtendimentoExtra['horario_atendimento'];
                                  $nomeProfissional   = $fieldAtendimentoExtra['nomeProfissional'];
                                  $codigoProfissional = $fieldAtendimentoExtra['codigoprofissional_cnes'];
                                  $descricaoPCD       = $fieldAtendimentoExtra['condicaosaude_pcddescricao'];
                                  $pacientePCD        = $fieldAtendimentoExtra['condicaosaude_pcd'] == "S" ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
                                  $statusAtendimentoPainel = $fieldAtendimentoExtra['status_atendimento_painel'];

                                  $tipoAtendimentopainel  = $fieldAtendimentoExtra['tipo_atendimento_painel'];
                                  $observacaorecepcao     = $fieldAtendimentoExtra['observacao_recepcao_painel'];

                                  # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
                                  switch ($statusAtendimentoPainel) {
                                    case "":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
                                        Status: Não Confirmado
                                      </div>";
                                      break;
                                    case "Aguardando":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                    case "Em Atendimento":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                    case "Atendido":
                                      $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
                                        Status: $statusAtendimentoPainel
                                      </div>";
                                      break;
                                  }

                                  $cmdConfirmarPresenca = 'onClick="confirmarPresenca(' . "'abrir-popup','$idPaciente##$idAgenda##$nomePaciente')" . '"';
                                  $btnConfirmarPresenca = "<i id='btnConfirma$idPaciente' class='icofont icofont-checked nova_fonte_blue' style='font-size:18pt !important' title='Confirmar presença.' $cmdConfirmarPresenca></i>";

                                  if ($fieldAtendimentoExtra['status_atendimento_painel'] != "Em Atendimento" && $fieldAtendimentoExtra['status_atendimento_painel'] != "Finalizado") {
                                    $cmdCancelarConfirmacao = 'onclick="cancelarConfirmacaoPresenca(' . "'$idPaciente')" . '"';
                                    $btnCancelarConfirmacao = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' style='font-size:17pt !important' title='Cancelar confirmação de presença.' $cmdCancelarConfirmacao></i>";
                                  } else {
                                    $btnCancelarConfirmacao = "";
                                  }

                                  echo "<tr style='background-color:#fde3e3'>
                                      <td align='center'>
                                        $btnConfirmarPresenca
                                        $btnCancelarConfirmacao
                                      </td>
                                      <td align='center' style='font-size:10pt'>$horaAtendimento</td>
                                      <td style='font-size:9pt; padding:8px;'>
                                        <b>
                                          <table width='100%' style='background-color:transparent !important;'>
                                            <tr>
                                              <td style='background-color:#fde3e3; border:0px; padding:0px; font-size:11pt'>
                                                Paciente: $nomePaciente $pacientePCD - <font color='#860000'><b>EXTRA</b></font>
                                              </td>                
                                              <td style='background-color:#fde3e3; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                                                <table align='right'>
                                                  <tr>
                                                    <td style='padding:2px; border:0px;background-color:#fde3e3' id='tdStatus$idPaciente-$idAgenda'>
                                                      $htmlAtendimentoPainel
                                                    </td>
                                                </tr>
                                              </table>                    
                                            </td>
                                          </tr>
                                        </table>              
                                        <hr style='margin-top:1px; border-top: 1px dashed #860000'>
                                        <div style='width:auto; padding:2px; color:#027fbe;margin-top:-10px'>
                                          Profissional: $nomeProfissional
                                        </div>
                                      </b>
                                    </td>
                                    <td align='center' style='font-size:9pt'>$cnsPaciente</td>
                                    <td align='center' style='font-size:9pt'>$idadePaciente</td>
                                    <td align='center' style='font-size:9pt'>$sexoPaciente</td>
                                    <td align='center' style='font-size:8pt'>$telefonePaciente</td>
                                  </tr>";
                                }
                              }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
<?php
  } else if ($_SESSION['atendimentoIniciado'] == "N") {
    include_once("include/box_iniciar_atendimento_exec.php");
    echo "<div class='app-content content' style='background-color: #e9e9e7;'>
    <div class='content-wrapper' style='padding: 10px;'>
      <div class='content-body'>
        <div class='row'>
          <div class='col-12'>
            <div class='card' style='margin-top:-5px' id='card-tela'>
              <div class='card-content'>
                <div class='card-body'>
                  <table width='100%' style='margin-top:150px;'>
                    <tr>
                      <td class='td_bemvindo' align='center'>
                      </td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>";
  } else {
    echo "  <div class='app-content content' style='background-color: #e9e9e7;'>
    <div class='content-wrapper' style='padding: 15px;'>
      <div class='content-body'>
        <div class='row'>
          <div class='col-12'>
            <div class='card barra-titulo' style='height: 70px; border:1px dotted #289CD4'>
              <div class='card-content'>
                <div class='card-body' style='padding-left: 20px; padding-top: 20px;'>
                  <div class='form-body'>
                    <h4 class='form-section' style='font-size:16pt'>
                      <i class='icofont icofont-architecture-alt nova_fonte_blue' style='font-size:20pt'></i><b>&nbsp;Atendimentos para hoje:</b>
                    </h4>
                  </div>
                </div>
              </div>
            </div>
            <div class='card barra-titulo' style='height: autp; border:1px dotted #289CD4; margin-top:-20px'>
              <div class='card-content'>
                <div class='card-body' style='padding-left: 20px; padding-top: 20px;'>
                  <h4 class='form-section success' style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                    <i class='icofont icofont-list'></i> <b>Lista de Pacientes</b>
                  </h4><br>
                  <div class='row' style='margin-top:-20px'>
                    <div class='col-md-12'>
                      <div class='form-group'>
<table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='paciente_atendimento'>
  <thead>
    <th style='text-align:center; width:60px'>OPÇÃO</th>
    <th style='text-align:center; width:40px'>HORÁRIO</th>
    <th style='text-align:center; width:40px'>TIPO</th>
    <th>NOME DO PACIENTE</th>
    <th style='text-align:center; width:30px'>IDADE</th>
    <th style='text-align:center; width:30px'>SEXO</th>
    <th style='text-align:center; width:200px'>OBS</th>
  </thead>
  <tbody style='background-color:#ececec'>";
    $cpfValidaProfissional = $_SESSION['cpfValidaProfissional'];
    $sqlAgendamentos = "SELECT reg_tb_agendamentos_atender.id_agendamentos_atender,
    reg_tb_agendamentos_atender.tipo_atendimento_painel,
    reg_tb_agendamentos_atender.horario_atendimento,
    ucase(tb_paciente.nome_paciente) AS nomePaciente,
    TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
    tb_paciente.sexo,
    tb_paciente.condicaosaude_pcd,
    tb_paciente.condicaosaude_pcddescricao,
    tb_paciente.id_paciente,
    reg_tb_agendamentos_atender.status_atendimento_painel,
    reg_tb_agendamentos_atender.status_atendimento_painel_mostrar,
    reg_tb_agendamentos_atender.observacao_recepcao_painel,
    reg_tb_agendamentos_atender.origem_atendimento
    FROM tb_paciente
    INNER JOIN reg_tb_agendamentos_atender ON (tb_paciente.id_paciente = reg_tb_agendamentos_atender.id_paciente)
    WHERE (reg_tb_agendamentos_atender.codigoestabelecimento_cnes='$unidadeLogada')
    AND (reg_tb_agendamentos_atender.codigoprofissional_cnes='00000$cpfValidaProfissional')
    AND (reg_tb_agendamentos_atender.data_atendimento='$dataHoje')
    GROUP BY reg_tb_agendamentos_atender.data_atendimento,tb_paciente.nome_paciente
    ORDER BY reg_tb_agendamentos_atender.tipo_atendimento_painel DESC,
    reg_tb_agendamentos_atender.id_agendamentos_atender ASC";

    //AND (reg_tb_agendamentos_atender.status_atendimento_painel='Aguardando' OR reg_tb_agendamentos_atender.status_atendimento_painel='Chamando')

    $stmAtendimentos = $rsConexao->prepare($sqlAgendamentos);
    $stmAtendimentos->execute();
    if ($stmAtendimentos->rowCount() > 0) {
      $rsAtendimentos = $stmAtendimentos->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAtendimentos as $fieldAtendimentos) {
        $idPaciente         = $fieldAtendimentos['id_paciente'];
        $idAgendamento      = $fieldAtendimentos['id_agendamentos_atender'];
        $nomePaciente       = $fieldAtendimentos['nomePaciente'];
        $idadePaciente      = $fieldAtendimentos['idadePaciente'];
        $sexoPaciente       = $fieldAtendimentos['sexo'] == 'M' ? 'MASCULINO' : 'FEMININO';
        $horaAtendimento    = $fieldAtendimentos['horario_atendimento'];
        $descricaoPCD       = $fieldAtendimentos['condicaosaude_pcddescricao'];
        $pacientePCD        = $fieldAtendimentos['condicaosaude_pcd'] == 'S' ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
        $statusAtendimentoPainel  = $fieldAtendimentos['status_atendimento_painel_mostrar'];
        $tipoAtendimento          = $fieldAtendimentos['tipo_atendimento_painel'] == "N" ? "NORMAL" : "PRIORIDADE";
        $corTipoAtendimento       = $fieldAtendimentos['tipo_atendimento_painel'] == "P" ? "style='background-color: #fde3e3; color: #860000; font-weight: bold'" : "";
        $observacaoAtendimento    = mb_strtoupper($fieldAtendimentos['observacao_recepcao_painel']);
        # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
        switch ($statusAtendimentoPainel) {
          case '':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
              Status: Ausente
            </div>";
            break;
          case 'Aguardando':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
                Status: $statusAtendimentoPainel
            </div>";
            break;

          case 'Chamando':
          case 'Chamado':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Chamado'>
                Status: Chamado
            </div>";
            break;

          case 'Em Atendimento':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
              Status: $statusAtendimentoPainel
            </div>";
            break;
          case 'Atendido':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
              Status: $statusAtendimentoPainel
            </div>";
            break;
        }
        
        if ($fieldAtendimentos['status_atendimento_painel'] != "Atendido") {
          $cmdChamarPaciente = 'onClick="chamarPaciente(' . "'abrir-popup','$idPaciente#$horaAtendimento#$nomePaciente')" . '"';
          $btnChamarPaciente = "<i id='btnChamar$idPaciente' class='icofont icofont-megaphone-alt nova_fonte_blue' style='font-size:18pt !important' title='Chamar paciente.' $cmdChamarPaciente></i>";
        }else{
          $btnChamarPaciente = "";
        }

        if ($fieldAtendimentos['status_atendimento_painel'] == "Em Atendimento") {
          $cmdFinalizarAtendimento = 'onclick="confirmacaoAtendimento(' . "'$idPaciente#$horaAtendimento#$nomePaciente')" . '"';
          $btnFinalizarAtendimento = "<i class='icofont icofont-checked nova_fonte' style='font-size:17pt !important' title='Finalizar atendimento do paciente.' $cmdFinalizarAtendimento></i>";
        } else {
          $btnFinalizarAtendimento = "";
        }

        # -- CARREGAR PROCEDIMENTOS AGENDADOS --#
        $sqlProcedimento = "SELECT reg_tb_procedimento.nome_procedimento,
        reg_tb_agendamentos.id_paciente,
        reg_tb_agendamentos.id_agendamento
        FROM reg_tb_procedimento
        INNER JOIN reg_tb_agendamentos ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
        INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
        INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
        INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
        WHERE (reg_tb_agenda.codigoestabelecimento_cnes='$unidadeLogada')
        AND (reg_tb_agenda.codigoprofissional_cnes='00000$cpfValidaProfissional')
        AND (reg_tb_agendamentos.data_atendimento='$dataHoje')
        AND (reg_tb_agendamentos.horario_atendimento='$horaAtendimento')
        AND (reg_tb_agendamentos.id_paciente='$idPaciente')
        GROUP BY (reg_tb_procedimento.nome_procedimento)
        ORDER BY reg_tb_procedimento.nome_procedimento";
        $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
        $stmProcedimento->execute();
        if ($stmProcedimento->rowCount()) {
          $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
          $nomeProcedimento    = "";
          foreach ($rsProcedimento as $fieldProcedimento) {
            if ($nomeProcedimento == "") {
              $nomeProcedimento  = "&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            } else {
              $nomeProcedimento  = "$nomeProcedimento<br>&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            }
          }
        }

        $corLinhaExtra = $fieldAtendimentos['origem_atendimento'] != "extra" ?  "style='background-color:#fff'" : "style='background-color:#fde3e3'";
        echo "<tr $corLinhaExtra>
              <td align='center'>
                $btnChamarPaciente
                $btnFinalizarAtendimento
              </td>
              <td align='center' style='font-size:8pt'>$horaAtendimento</td>
              <td align='center' $corTipoAtendimento>$tipoAtendimento</td>
              <td style='font-size:9pt; padding:8px'>
                <b>
                  <table width='100%' style='background-color:transparent !important;'>
                    <tr>
                      <td style='background-color:transparent; border:0px; padding:0px; font-size:11pt'>
                        Paciente: $nomePaciente $pacientePCD
                      </td>                
                      <td style='background-color:transparent; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                        <table align='right'>
                          <tr>
                          <td style='padding:2px; border:0px' id='tdStatus$idPaciente'>
                            $htmlAtendimentoPainel
                          </td>
                          </tr>
                        </table>                    
                      </td>
                    </tr>
                  </table>              
                  <hr style='margin-top:1px; border-top: 1px dashed #860000'>
                  <div style='width:auto; padding:2px; color:#027fbe; margin-top:-10px'>
                    $nomeProcedimento
                  </div>
                </b>
              </td>
              <td align='center' style='font-size:9pt'>$idadePaciente</td>
              <td align='center' style='font-size:9pt'>$sexoPaciente</td>
              <td style='font-size:8pt;'>$observacaoAtendimento</td>
            </tr>";
      }
    }
    echo "</tbody>
      </table>
                          </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>";
  }
}
include_once("footer.php");
include_once("include/box_confirmar_chavepresenca.php");
include_once("include/box_executante_chamarpaciente.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  var executanteAtendimentoConsultorio = "<?php echo $executanteAtendimentoConsultorio; ?>";
  var unidadeLogadaUsaPeinel = "<?php echo $_SESSION['unidadeLogadaUsaPeinel']; ?>";
  var atendimentoIniciado = "<?php echo $_SESSION['atendimentoIniciado']; ?>";

  if (unidadeLogadaUsaPeinel == "S" && executanteAtendimentoConsultorio == "S" && atendimentoIniciado == "N") {

    var alturaTela = window.innerHeight;
    var alturaCardTelaDefinida = document.getElementById("card-tela").offsetHeight;
    var alturaCardTelaAplicada = alturaTela - 120;

    if (alturaCardTelaDefinida < alturaCardTelaAplicada) {
      $("#card-tela").css("height", alturaTela - 120);
    }

    $("#box_iniciar_atendimento_exec").modal();
  }

  function iniciarAtendimento() {
    $.ajax({
      url: 'action/acessar_sistema',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAcesso': 'iniciar-atendimento-painel-executante',
        'setorAtendimentoIniciar': $("#setorAtendimentoIniciar").val()
      }
    }).done(function(resultadoRetorno) {
      window.location.reload();
    });
  }

  function chamarPaciente(opcaoChamado, dadosPaciente) {
    var splitPaciente = dadosPaciente.split("#");
    switch (opcaoChamado) {
      case "abrir-popup":
        var nomwPaciente = splitPaciente[1];
        $("#idPacienteChamado").val(splitPaciente[0]);
        $("#idHorarioAtendimentoChamado").val(splitPaciente[1]);
        $("#nomePacienteChamado").val(splitPaciente[2]);
        $("#box_executante_chamarpaciente").modal();
        break;

      case "chamar-nopainel":
        $("#processandoDados").html("Aguarde! Chamando paciente...")
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/chamarpaciente_painel',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoChamada': 'atendimento-painel-setorconsultorio',
            'idPacienteChamado': $("#idPacienteChamado").val(),
            'idHorarioAtendimentoChamado': $("#idHorarioAtendimentoChamado").val()
          }
        }).done(function(resultadoRetorno) {
          setTimeout(function() {
            $("#embacado").css("display", "none");
            $("#processandoDados").html("Aguarde! Processando dados...")
          }, 10000);
        });
        break;

      case "atender-nopainel":
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/chamarpaciente_painel',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoChamada': 'atendimento-painel-atender',
            'idPacienteChamado': $("#idPacienteChamado").val(),
            'idHorarioAtendimentoChamado': $("#idHorarioAtendimentoChamado").val()
          }
        }).done(function(resultadoRetorno) {
          window.location.reload();
        });
        break;
    }
  }

  $("#totalAtendimentos").html("<?php echo $contadorRegistros; ?>");
  $('#pacientes_hoje').DataTable({
    "order": [
      [1, "asc"]
    ]
  });

  $('#paciente_atendimento').DataTable({
    "order": [
      [1, "asc"]
    ]
  });

  function confirmarPresenca(opcaoExecucao, dadocConfirmacao) {
    var splitDados = dadocConfirmacao.split('##');

    switch (opcaoExecucao) {

      case "abrir-popup":


        $("#idPacienteConfirmacao").val(splitDados[0]);
        $("#idAgendaConfirmacao").val(splitDados[1]);
        $("#nomePacienteConfirmacao").val(splitDados[2]);

        /** carregar dados já informados */
        $.ajax({
          url: 'filtros/buscar_dados_edicao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoBusca': 'dados-confirmacao-atual',
            'idPaciente': splitDados[0],
            'idAgenda': splitDados[1]
          }
        }).done(function(resultadoRetorno) {
          var objetoJson = JSON.parse(resultadoRetorno);
          $("#tipoAtendimento").val(objetoJson['tipoAtendimento']);
          $("#observacaoAtendimento").val(objetoJson['observacaoAtendimento']);
          $("#box_confirmar_chavepresenca").modal();
        });
        break;

      case "executa-confirmacao":

        if ($("#tipoAtendimento").val() == "") {
          swal("Informação Obrigatória", "Informe o tipo de atendimento.", "error")
          return false;
        }
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/gravar_chaveconfirmacao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoConfirmacao': 'confirmar-telainicial',
            'idPaciente': $("#idPacienteConfirmacao").val(),
            'idAgenda': $("#idAgendaConfirmacao").val(),
            'tipoAtendimento': $("#tipoAtendimento").val(),
            'observacaoAtendimento': $("#observacaoAtendimento").val()
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          if (resultadoRetorno == "chaveInvalida") {
            swal("Chave Inválida", "A chave de confirmação digitada não é válida para este atendimento.", "error");
            return false;
          }

          swal("Presença Confirmada", "O registro da presença do paciente foi confirmado com sucesso.", "success");
          $("#tdStatus" + $("#idPacienteConfirmacao").val() + '-' + $("#idAgendaConfirmacao").val()).html("<div class='div-statuPainel-Aguardando'>Status: Aguardando</div>");
        });

        break;
    }
  }


  setInterval(function() {
    if (unidadeLogadaUsaPeinel == "S" && executanteAtendimentoConsultorio == "N") {
      $.ajax({
        url: 'filtros/filtrar_agendamentos',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoListagem': 'agendamentos-executante-painel'
        }
      }).done(function(resultadoRetorno) {
        $('#pacientes_hoje').DataTable().destroy();
        $('#pacientes_hoje tbody').empty().append(resultadoRetorno);
        $('#pacientes_hoje').DataTable({
          "order": [
            [1, "asc"]
          ]
        });
      });
    }
  }, 300000);

  setInterval(function() {
    if (unidadeLogadaUsaPeinel == "S" && executanteAtendimentoConsultorio == "S") {
      $.ajax({
        url: 'filtros/filtrar_agendamentos',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoListagem': 'agendamentos-executante-painel-atualizastatus'
        }
      }).done(function(resultadoRetorno) {
        $('#paciente_atendimento').DataTable().destroy();
        $('#paciente_atendimento tbody').empty().append(resultadoRetorno);
        $('#paciente_atendimento').DataTable({
          "order": [
            [1, "asc"]
          ]
        });
      });
    }
  }, 300000);

  function adicionarVagaExtra(opcaoExecucao) {

    switch (opcaoExecucao) {
      case 'abrir-popup':
        $("#documentoPacienteAdd").val("");
        $("#idPacienteAdd").val("");
        $("#nomePacienteAdd").val("");
        $("#dataNascPacienteAdd").val("");
        $("#sexoPacienteAdd").val("");
        $("#profissionalAtendimentoExtra").val("");
        $("#profissionalAtendimentoExtra").trigger("change");
        $("#profissionalAtendimentoExtra").prop("disabled", true);
        $("#procedimentoAtendimentoExtra").prop("disabled", true);
        $("#box_incluir_atendimentoextra").modal();
        setTimeout(function() {
          $("#documentoPacienteAdd").focus();
        }, 1000);
        break;
    }

  }

  function somenteNumero(getEvento) {
    var oEvento = getEvento || window.event;
    var chaveEvento = oEvento.keyCode || oEvento.which;
    chaveEvento = String.fromCharCode(chaveEvento);

    var expressaoEvento = /^[0-9.]+$/;
    if (!expressaoEvento.test(chaveEvento)) {
      expressaoEvento.returnValue = false;
      if (oEvento.preventDefault) oEvento.preventDefault();
    }
  }

  function buscarPaciente() {

    if ($("#documentoPacienteAdd").val() == "") {
      swal("Documento Obrigatório", "Você deve informar CPF ou Cartão SUS do paciente para realizar a busca.", "error");
      return false;
    }
    if ($("#documentoPacienteAdd").val().length < 11) {
      swal("Documento Inválido", "O número de documento digitado é inválido.", "error");
      return false;
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_paciente_ws',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'adicionar-atendimento-extra',
        'numeroDocumento': $("#documentoPacienteAdd").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno == "NaoEncontrado") {
        swal("Não Encontrado", "Paciente não encontrado ou documento inválido.", "error");
        $("#profissionalAtendimentoExtra").prop("disabled", true);
        $("#procedimentoAtendimentoExtra").prop("disabled", true);
        return false;
      } else {
        var objetoJson = JSON.parse(resultadoRetorno);
        $("#idPacienteAdd").val(objetoJson['idPaciente']);
        $("#nomePacienteAdd").val(objetoJson['nomePaciente']);
        $("#dataNascPacienteAdd").val(objetoJson['dataNascimento']);
        $("#sexoPacienteAdd").val(objetoJson['sexoPaciente']);

        $("#profissionalAtendimentoExtra").prop("disabled", false);
        $("#procedimentoAtendimentoExtra").prop("disabled", false);
      }
    });

  }

  $("#profissionalAtendimentoExtra").change(function() {

    if (this.value != "") {
      $("#embacado").css("display", "block");
      $.ajax({
        url: 'filtros/filtrar_procedimento',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoPesquisa': 'executante-adicionar-atendimento-extra',
          'codigoProfissional': this.value
        }
      }).done(function(resultadoRetorno) {
        $("#embacado").css("display", "none");
        $("#procedimentoAtendimentoExtra").html(resultadoRetorno);
      });
    } else {
      $("#procedimentoAtendimentoExtra").html("<option value=''>SELECIONE...</option>");
    }
  });


  function IncluirAtendimento() {

    if ($("#idPacienteAdd").val() == "" || $("#profissionalAtendimentoExtra").val() == "" || $("#procedimentoAtendimentoExtra").val() == "") {
      swal("Dados Obrigatórios", "Você deve preencher todas as informações para incluir no atendimento extra.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_atendimentoextra',
      type: 'post',
      dataType: 'html',
      data: {
        'OpcaoAtendimento': 'executante-adicionar-atendimento-extra',
        'idPaciente': $("#idPacienteAdd").val(),
        'idProfissional': $("#profissionalAtendimentoExtra").val(),
        'idProcedimento': $("#procedimentoAtendimentoExtra").val()
      }
    }).done(function(resultadoRetorno) {
      $('#pacientes_hoje').DataTable().destroy();
      $('#pacientes_hoje tbody').empty().append(resultadoRetorno);
      $('#pacientes_hoje').DataTable({
        "order": [
          [1, "asc"]
        ]
      });
      $("#embacado").css("display", "none");
      swal("Gravado com Sucesso", "O registro para atendimento extra foi salvo com sucesso no final da fila.", "success");
    });

  }

  function confirmacaoAtendimento(dadosConfirmacao){
    var splitDados = dadosConfirmacao.split("#");
		swal({
			title: "Confirmar Atendimento",
			text: "Confirma conlusão do atendimento do(a) paciente "+splitDados[2]+" ?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/chamarpaciente_painel',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoChamada': 'atendimento-painel-confirmaratendimento',
            'idPacienteChamado': splitDados[0],
            'idHorarioAtendimentoChamado': splitDados[1]
          }
        }).done(function(resultadoRetorno) {
          setTimeout(function() {
            $("#embacado").css("display", "none");
            window.location.reload();
          }, 2000);
        });

			} else {
				swal("Operação Cancelada.", "O atendimento não foi finalizar.", "info");
			}

		});
  }
</script>