<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
$idUsuarioLogado  = $_SESSION['idUsuarioLogado'];
?>
<div class="app-content content" style="background-color: #e9e9e7;">
  <div class="content-wrapper" style="padding: 15px;">
    <div class="content-body">
      <div class="row">
        <div class="col-12">
          <div class="card barra-titulo" style="height: 70px; border:1px dotted #289CD4">
            <div class="card-content">
              <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                <div class="form-body">
                  <h4 class="form-section" style='font-size:16pt'>
                    <i class="icofont icofont-chart-bar-graph nova_fonte_blue" style='font-size:20pt'></i><b>&nbsp;Dashboard Informativo:</b>
                  </h4>
                </div>
              </div>
            </div>
          </div>
          <div class="card barra-titulo" style="height: autp; border:1px dotted #289CD4; margin-top:-20px">
            <div class="card-content">
              <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                <h4 class="form-section success" style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                  <i class="icofont icofont-info-square"></i> <b>Dados de hoje (informação em tempo real)</b>
                </h4><br>
                <div class="row" style='margin-top:-20px'>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#289CD4 solid 1px">
                        <div class="card-body">
                          <div id="chartTotalSolicitacoesHoje" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalSolicitacoesHoje" style="font-size: 20px; font-weight: bold;background: #289CD4;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#4caf50 solid 1px">
                        <div class="card-body">
                          <div id="chartAgendadoFilaHoje" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAgendadoFilaHoje" style="font-size: 20px; font-weight: bold;background: #4caf50;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#4caf50 solid 1px">
                        <div class="card-body">
                          <div id="chartAgendadoAvulsoHoje" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAgendadoAvulsoHoje" style="font-size: 20px; font-weight: bold;background: #4caf50;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#ca0202 solid 1px">
                        <div class="card-body">
                          <div id="chartCancelamentoHoje" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalCancelamentoHoje" style="font-size: 20px; font-weight: bold;background: #ca0202;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <h4 class="form-section" style='border-bottom: dotted 1px #1177ca; padding-bottom:5px;font-size:12pt; color:#1177ca'>
                  <i class="icofont icofont-chart-flow-alt-2"></i> <b>Ranking de solicitações (os 10+):</b>
                </h4><br>
                <div class="row" style='margin-top:-27px'>
                  <div class="col-md-12">
                    <div class="form-group">
                      <table style='width:100%'>
                        <tr>
                          <td width='33.33%'>
                            <table width='100%'>
                              <thead style='background: #289CD4; color:#fff; font-size:10pt;'>
                                <th colspan='2' style='padding:2px; border:1px gray dotted; line-height:18pt'>Usuário solicitante</th>
                                <th style='text-align:center; width:105px; border:1px gray dotted'>Quant</th>
                              </thead>
                              <tbody style="background-color:#ececec" id="ranking_usuario">
                              </tbody>
                            </table>
                          </td>
                          <td width='33.33%'>
                            <table width='100%'>
                              <thead style='background: #4caf50; color:#fff; font-size:10pt;'>
                                <th colspan='2' style='padding:2px; border:1px gray dotted; line-height:18pt'>Unidade solicitante</th>
                                <th style='text-align:center; width:105px; border:1px gray dotted'>Quant</th>
                              </thead>
                              <tbody style="background-color:#ececec" id="ranking_unidade">
                              </tbody>
                            </table>
                          </td>
                          <td width='33.33%'>
                            <table width='100%' id='tb-ranking-procedimento'>
                              <thead style='background: #FFC107; color:#fff; font-size:10pt;'>
                                <th colspan='2' style='padding:2px; border:1px gray dotted; line-height:18pt'>Proced mais solicitados</th>
                                <th style='text-align:center; width:90px; border:1px gray dotted' id='coluna-quant-proced'>Quant</th>
                              </thead>
                              <tbody style="background-color:#ececec" id="ranking_procedimento">
                              </tbody>
                            </table>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card barra-titulo" style="height: auto; border:1px dotted #289CD4; margin-top:-20px">
            <div class="card-content">
              <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                <h4 class="form-section success" style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                  <i class="icofont icofont-info-square"></i> <b>Dados dos últimos 15 dias</b>
                </h4><br>
                <div class="row" style='margin-top:-20px'>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#289CD4 solid 1px">
                        <div class="card-body">
                          <div id="chartTotalSolicitacoes" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalSolicitacoes" style="font-size: 20px; font-weight: bold;background: #289CD4;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#8B0000 solid 1px">
                        <div class="card-body">
                          <div id="chartAguardandoAgendamento" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAguardandoAgendamento" style="font-size: 20px; font-weight: bold;background: #8B0000;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#4caf50 solid 1px">
                        <div class="card-body">
                          <div id="chartAgendadoFila" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAgendadoFila" style="font-size: 20px; font-weight: bold;background: #4caf50;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#4caf50 solid 1px">
                        <div class="card-body">
                          <div id="chartAgendadoAvulso" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAgendadoAvulso" style="font-size: 20px; font-weight: bold;background: #4caf50;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row" style='margin-top:-10px;'>
                  <div class="col-md-12">
                    <div class="form-group" style='border-top: 1px dotted gray; padding-top:5pt'>
                      <div class="height-300">
                        <canvas id="agendamentos-entregues-cancelados"></canvas>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card barra-titulo" style="height: auto; border:1px dotted #289CD4; margin-top:-20px">
            <div class="card-content">
              <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                <h4 class="form-section success" style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                  <i class="icofont icofont-info-square"></i> <b>Solicitações X Agendamentos (últimos 12 meses)</b>
                </h4><br>
                <div class="row" style='margin-top:-10px;'>
                  <div class="col-md-12">
                    <div class="form-group">
                      <div class="height-400">
                        <canvas id="solicitacoes-agendamentos"></canvas>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card barra-titulo" style="height: auto; border:1px dotted #289CD4; margin-top:-20px">
            <div class="card-content">
              <div class="card-body" style='padding-left: 20px; padding-top: 20px;'>
                <h4 class="form-section success" style='border-bottom: dotted 1px #37BC9B; padding-bottom:10px;font-size:16pt'>
                  <i class="fa fa-user-times"></i> <b>Análise de Absenteísmo (últimos 12 meses)</b>
                </h4><br>
                <div class="row" style='margin-top:-20px'>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#289CD4 solid 1px">
                        <div class="card-body">
                          <div id="chartTotalAgendamentos12Meses" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAgendamentos12Meses" style="font-size: 20px; font-weight: bold;background: #289CD4;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#ca0202 solid 1px">
                        <div class="card-body">
                          <div id="chartAbsenteismo12Meses" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAbsenteismo12Meses" style="font-size: 20px; font-weight: bold;background: #ca0202;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#FFC107 solid 1px">
                        <div class="card-body">
                          <div id="chartAbsenteismoTrimestre" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAbsenteismoTrimestre" style="font-size: 20px; font-weight: bold;background: #FFC107;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <div class="card-title text-center" style="border-radius: 4%; border:#4caf50 solid 1px">
                        <div class="card-body">
                          <div id="chartAbsenteismoMes" style="height: 250px;"></div>
                        </div>
                        <div>
                          <p id="totalAbsenteismoMes" style="font-size: 20px; font-weight: bold;background: #4caf50;padding:5px; color:#fff">...</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <h4 class="form-section" style='border-bottom: dotted 1px #1177ca; padding-bottom:5px;font-size:12pt; color:#1177ca; margin-top:-10px'>
                  <i class="fa fa-calendar-times-o"></i> <b>Agendamentos X Absenteísmo (mensal):</b>
                </h4><br>
                <div class="row" style='margin-top:-10px;'>
                  <div class="col-md-12">
                    <div class="form-group">
                      <div class="height-400">
                        <canvas id="agendamento-absenteismo"></canvas>
                      </div>
                    </div>
                  </div>
                </div>
                <h4 class="form-section" style='border-bottom: dotted 1px #1177ca; padding-bottom:5px;font-size:12pt; color:#1177ca; margin-top:-10px' id='percentual-medio-abs'>
                  <i class='fa fa-user-times'></i> <b>Percentual médio mensal:</b>
                </h4><br>                
              </div>
            </div>
          </div><br>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
include_once("footer.php"); // Rodapé padrão de todoas as páginas
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.1/chart.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
  function formatarNumero(numero) {
    return numero.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
  }

  function renderChart(selector, value, color, isPercentage = true, title = '') {
    const options = {
      chart: {
        height: 280,
        type: 'radialBar',
      },
      series: [value],
      colors: [color],
      plotOptions: {
        radialBar: {
          startAngle: -135,
          endAngle: 135,
          hollow: {
            size: '70%',
          },
          dataLabels: {
            value: {
              fontSize: '22px',
              color: '#111',
              formatter: function(val) {
                return isPercentage ? `${val.toFixed(2)}%` : `${val}`;
              }
            },

            style: {
              fontSize: '16px',
              lineHeight: '24px',
              fontWeight: '600',
              fill: '#111111'
            }
          }
        }
      },
      labels: title.split('\n'),
      tooltip: {
        enabled: false
      }
    };

    const chart = new ApexCharts(document.querySelector(selector), options);
    chart.render();
  }

  async function fetchDados() {

    try {
      var larguraDisponivelProcedimento = $('#tb-ranking-procedimento').width();
      var larguraQuantidadeProcedimento = $('#coluna-quant-proced').width();
      var larguraColuna = (larguraDisponivelProcedimento - (larguraQuantidadeProcedimento + 13) - 13);

      const capturarDados = await fetch('action/carregar_dadosdashboard.php?larguraColuna=' + larguraColuna);
      const resultadoRetorno = await capturarDados.json();
      // Hoje


      if (resultadoRetorno.dadosHoje.totalSolicitacoesHoje != 0) {
        var percentualAgendadoFilaHoje = parseFloat((resultadoRetorno.dadosHoje.totalAgendadoFilaHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100);
        var percentualAgendadoAvulsoHoje = parseFloat((resultadoRetorno.dadosHoje.totalAgendadoAvulsoHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100)
        var percentualCanceladoHoje = parseFloat((resultadoRetorno.dadosHoje.totalCancelamentoHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100)
      } else {
        var percentualAgendadoFilaHoje = parseFloat('0,0');
        var percentualAgendadoAvulsoHoje = parseFloat('0,0');
        var percentualCanceladoHoje = parseFloat('0,0');
      }

      renderChart('#chartTotalSolicitacoesHoje', resultadoRetorno.dadosHoje.totalSolicitacoesHoje, '#03a9f4', false, 'SOLICITAÇÕES');
      renderChart('#chartAgendadoFilaHoje', percentualAgendadoFilaHoje, '#4caf50', true, 'AGENDADAS FILA');
      renderChart('#chartAgendadoAvulsoHoje', percentualAgendadoAvulsoHoje, '#4caf50', true, 'AGENDADAS AVULSO');
      renderChart('#chartCancelamentoHoje', percentualCanceladoHoje, '#ca0202', true, 'CANCELADAS');

      document.getElementById('totalSolicitacoesHoje').textContent = `${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
      document.getElementById('totalAgendadoFilaHoje').textContent = `${resultadoRetorno.dadosHoje.totalAgendadoFilaHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
      document.getElementById('totalAgendadoAvulsoHoje').textContent = `${resultadoRetorno.dadosHoje.totalAgendadoAvulsoHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
      document.getElementById('totalCancelamentoHoje').textContent = `${resultadoRetorno.dadosHoje.totalCancelamentoHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;

      $("#ranking_usuario").html(resultadoRetorno.dadosHojeRankingUsuario)
      $("#ranking_unidade").html(resultadoRetorno.dadosHojeRankingUnidade)
      $("#ranking_procedimento").html(resultadoRetorno.dadosHojeRankingProcedimento)

      // 15 dias

      renderChart('#chartTotalSolicitacoes', resultadoRetorno.dadosCard15Dias.total_solicitacoes, '#03a9f4', false, 'SOLICITAÇÕES');
      renderChart('#chartAguardandoAgendamento', (resultadoRetorno.dadosCard15Dias.total_aguardando_agendamento / resultadoRetorno.dadosCard15Dias.total_solicitacoes) * 100, '#8B0000', true, 'AGUARDANDO');
      renderChart('#chartAgendadoFila', (resultadoRetorno.dadosCard15Dias.total_agendadoFila / resultadoRetorno.dadosCard15Dias.total_solicitacoes) * 100, '#4caf50', true, 'AGENDADAS FILA');
      renderChart('#chartAgendadoAvulso', (resultadoRetorno.dadosCard15Dias.total_agendadoAvulso / resultadoRetorno.dadosCard15Dias.total_solicitacoes) * 100, '#4caf50', true, 'AGENDADAS AVULSO');
      document.getElementById('totalSolicitacoes').textContent = `${resultadoRetorno.dadosCard15Dias.total_solicitacoes}`;
      document.getElementById('totalAguardandoAgendamento').textContent = `${resultadoRetorno.dadosCard15Dias.total_aguardando_agendamento} / ${resultadoRetorno.dadosCard15Dias.total_solicitacoes}`;
      document.getElementById('totalAgendadoFila').textContent = `${resultadoRetorno.dadosCard15Dias.total_agendadoFila} / ${resultadoRetorno.dadosCard15Dias.total_solicitacoes}`;
      document.getElementById('totalAgendadoAvulso').textContent = `${resultadoRetorno.dadosCard15Dias.total_agendadoAvulso} / ${resultadoRetorno.dadosCard15Dias.total_solicitacoes}`;

      //Absenteísmo 12 meses
      renderChart('#chartTotalAgendamentos12Meses', resultadoRetorno.dadosAbsenteismoGeral.agendamentosEntregues, '#03a9f4', false, 'AGENDADOS');
      renderChart('#chartAbsenteismo12Meses', (resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo / resultadoRetorno.dadosAbsenteismoGeral.agendamentosEntregues) * 100, '#ca0202', true, 'TOTAL ABSENTEÍSMO');
      renderChart('#chartAbsenteismoTrimestre', (resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismoTrimestre / resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo) * 100, '#FFC107', true, 'NO TRIMESTRE');
      renderChart('#chartAbsenteismoMes', (resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismoMesAtual / resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo) * 100, '#4caf50', true, 'NO MÊS');


      document.getElementById('totalAgendamentos12Meses').textContent = `${resultadoRetorno.dadosAbsenteismoGeral.agendamentosEntregues}`;
      document.getElementById('totalAbsenteismo12Meses').textContent = `${resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo} / ${resultadoRetorno.dadosAbsenteismoGeral.agendamentosEntregues}`;
      document.getElementById('totalAbsenteismoTrimestre').textContent = `${resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismoTrimestre} / ${resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo}`;
      document.getElementById('totalAbsenteismoMes').textContent = `${resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismoMesAtual} / ${resultadoRetorno.dadosAbsenteismoGeral.totalAbsenteismo}`;
      gerarGrafico("linha-12meses-agendamento-absenteismo");
    } catch (error) {
      console.error('Erro ao buscar dados:', error);
    }
  }

  function gerarGrafico(opcaoGrafico) {

    switch (opcaoGrafico) {

      case "linha-15dias-entregues-cancelados":

        $.ajax({
          url: 'action/carregar_dadosdashboard',
          type: 'post',
          dataType: 'html',
          data: {
            'seletorDadosGrafico': opcaoGrafico
          }
        }).done(function(resultadoRetornoGrafico) {

          var arrayDiaSemana = [];
          var arrayEntregues = [];
          var arrayCancelados = [];

          const dadosRetornados = JSON.parse(resultadoRetornoGrafico);
          const contarRegistros = dadosRetornados['dadosEntregeCancelado'].length;

          for (indexGrafico = 0; indexGrafico < contarRegistros - 1; indexGrafico++) {
            if ((contarRegistros - indexGrafico) <= 16) {
              arrayDiaSemana.push(dadosRetornados['dadosEntregeCancelado'][indexGrafico]['diaSemanaEntrega']);
              arrayEntregues.push(dadosRetornados['dadosEntregeCancelado'][indexGrafico]['totalRegistroEntrega']);
              arrayCancelados.push(dadosRetornados['dadosEntregeCancelado'][indexGrafico]['totalRegistroCancelado']);
            }
          }

          /* MONTAGEM DO GRÁFICO */
          var graficoContratos = $("#agendamentos-entregues-cancelados");
          new Chart(graficoContratos, {
            type: 'line',
            data: {
              labels: arrayDiaSemana,
              datasets: [{
                  label: "Agendamentos Entregues",
                  borderColor: "#006DB3",
                  pointBorderColor: "#006DB3",
                  pointBackgroundColor: "#3d45e0",
                  pointBorderWidth: 2,
                  pointHoverBorderWidth: 2,
                  data: arrayEntregues,
                  datalabels: {
                    align: 'start',
                    anchor: 'start'
                  }
                },
                {
                  label: "Agendamentos Cancelados",
                  backgroundColor: "transparent",
                  borderDash: [2, 2],
                  borderColor: "#aa0404",
                  pointBorderColor: "#aa0404",
                  pointBackgroundColor: "#f31c1c",
                  pointBorderWidth: 2,
                  pointHoverBorderWidth: 2,
                  data: arrayCancelados,
                  datalabels: {
                    align: 'end',
                    anchor: 'end'
                  }
                }
              ]
            },
            options: {
              responsive: true,
              maintainAspectRatio: false,
              plugins: {
                datalabels: {
                  backgroundColor: function(context) {
                    return context.dataset.borderColor;
                  },
                  borderRadius: 4,
                  color: '#fff',
                  font: {
                    weight: 'bold'
                  },
                  formatter: function(value, context) {
                    return formatarNumero(value);
                  },
                }
              },

              // Core options
              aspectRatio: 5 / 3,
              layout: {
                padding: {
                  top: 32,
                  right: 16,
                  bottom: 16,
                  left: 8
                }
              },
              elements: {
                line: {
                  fill: false,
                  tension: 0.4
                }
              },
              scales: {
                y: {
                  stacked: true
                }
              }
            },
            plugins: [ChartDataLabels],
          });
          /***********************/
        });
        break;

      case "linha-12meses-solicitacoes-agendamentos":
        $.ajax({
          url: 'action/carregar_dadosdashboard',
          type: 'post',
          dataType: 'html',
          data: {
            'seletorDadosGrafico': opcaoGrafico
          }
        }).done(function(resultadoRetornoGrafico) {

          var arrayMesAno = [];
          var arraySolicitacoes = [];
          var arrayAgendamentos = [];

          const dadosRetornados = JSON.parse(resultadoRetornoGrafico);
          const contarRegistros = dadosRetornados['dadosSolicitacaoAgendamento'].length;

          for (indexGrafico = 0; indexGrafico < contarRegistros - 1; indexGrafico++) {
            arrayMesAno.push(dadosRetornados['dadosSolicitacaoAgendamento'][indexGrafico]['mesSolicitacao']);
            arraySolicitacoes.push(dadosRetornados['dadosSolicitacaoAgendamento'][indexGrafico]['totalRegistroSolicitacoes']);
            arrayAgendamentos.push(dadosRetornados['dadosSolicitacaoAgendamento'][indexGrafico]['totalRegistroAgendamentos']);
          }

          /* MONTAGEM DO GRÁFICO */
          const graficoContratos = document.getElementById('solicitacoes-agendamentos').getContext('2d');

          const gradientSolicitacoes = graficoContratos.createLinearGradient(0, 0, 0, 300);
          gradientSolicitacoes.addColorStop(0, "rgb(62, 128, 55)");
          gradientSolicitacoes.addColorStop(1, "rgb(71, 212, 55)");

          const gradientAgendamentos = graficoContratos.createLinearGradient(0, 0, 0, 300);
          gradientAgendamentos.addColorStop(0, "hsl(202, 100.00%, 25.90%)");
          gradientAgendamentos.addColorStop(1, "rgb(4, 156, 247)");

          graficoContratos.fillStyle = gradientAgendamentos;
          graficoContratos.fillRect(0, 0, 300, 300);

          new Chart(graficoContratos, {
            type: "bar",
            data: {
              labels: arrayMesAno,
              datasets: [{
                  label: "Solicitaçõs Registradas",
                  data: arraySolicitacoes,
                  backgroundColor: gradientSolicitacoes
                },
                {
                  label: "Agendamentos Registrados",
                  data: arrayAgendamentos,
                  backgroundColor: gradientAgendamentos
                },
              ],
            },
            options: {
              responsive: true,
              maintainAspectRatio: !1,
              legend: {
                position: "bottom",
                labels: {
                  fontSize: 14,
                  fontColor: 'black',
                  family: 'Arial',
                  style: 'bold',
                }
              },
              hover: {
                mode: "label"
              },
              title: {
                display: false,
              },
              plugins: {
                datalabels: {
                  anchor: 'end',
                  align: 'end',
                  color: function(context) {
                    return context.dataset.backgroundColor; // Utiliza a cor da barra
                  },
                  formatter: function(value, context) {
                    return formatarNumero(value);
                  },
                  font: {
                    size: 12,
                    family: 'Tahoma',
                    weight: 'bold'
                  }
                }
              },
              interaction: {
                intersect: false,
                mode: 'index',
              },
              scales: {
                xAxes: [{
                  ticks: {
                    fontSize: 12,
                    fontColor: 'black',
                    family: 'Arial',
                    style: 'bold',
                  }
                }],
                yAxes: [{
                  display: true,
                }]
              },

            },
            plugins: [ChartDataLabels],
          });
          /***********************/
        });
        break;

      case "linha-12meses-agendamento-absenteismo":
        $.ajax({
          url: 'action/carregar_dadosdashboard',
          type: 'post',
          dataType: 'html',
          data: {
            'seletorDadosGrafico': opcaoGrafico
          }
        }).done(function(resultadoRetornoGrafico) {

          var arrayMesAno = [];
          var arrayAgendamentos = [];
          var arrayAbsenteismo = [];
          var totalAgendamentos = parseInt(0);
          var totalAbsenteismo = parseInt(0);
          var percentualMedioMes = 0;
          const dadosRetornados = JSON.parse(resultadoRetornoGrafico);
          const contarRegistros = dadosRetornados['dadosAgendamentoAbsenteismo'].length;

          for (indexGrafico = 0; indexGrafico < contarRegistros; indexGrafico++) {
            arrayMesAno.push(dadosRetornados['dadosAgendamentoAbsenteismo'][indexGrafico]['mesAtendimento']);
            arrayAgendamentos.push(dadosRetornados['dadosAgendamentoAbsenteismo'][indexGrafico]['totalRegistroAgendamentos']);
            arrayAbsenteismo.push(dadosRetornados['dadosAgendamentoAbsenteismo'][indexGrafico]['totalRegistroAbsenteismo']);
            totalAgendamentos = parseInt(totalAgendamentos)+parseInt(dadosRetornados['dadosAgendamentoAbsenteismo'][indexGrafico]['totalRegistroAgendamentos']);
            totalAbsenteismo = parseInt(totalAbsenteismo)+parseInt(dadosRetornados['dadosAgendamentoAbsenteismo'][indexGrafico]['totalRegistroAbsenteismo']);
          }

          percentualMedioMes  = parseFloat((totalAbsenteismo/totalAgendamentos)*100);
          percentualMedioMes  = percentualMedioMes.toFixed(2).replace(".",",");
          $("#percentual-medio-abs").html("<i class='fa fa-user-times'></i> <b>Percentual médio mensal: "+percentualMedioMes+"</b>");
          /* MONTAGEM DO GRÁFICO */
          const graficoAgAb = document.getElementById('agendamento-absenteismo').getContext('2d');

          const gradientAgendamentos = graficoAgAb.createLinearGradient(0, 0, 0, 300);
          gradientAgendamentos.addColorStop(0, "hsl(202, 100.00%, 25.90%)");
          gradientAgendamentos.addColorStop(1, "rgb(4, 156, 247)");

          const gradientAbsenteismo = graficoAgAb.createLinearGradient(0, 0, 0, 300);
          gradientAbsenteismo.addColorStop(0, "rgb(185, 3, 3)");
          gradientAbsenteismo.addColorStop(1, "rgb(226, 0, 0)");

          graficoAgAb.fillStyle = gradientAgendamentos;
          graficoAgAb.fillRect(0, 0, 300, 300);

          new Chart(graficoAgAb, {
            type: "bar",
            data: {
              labels: arrayMesAno,
              datasets: [{
                  label: "Agendamentos",
                  data: arrayAgendamentos,
                  backgroundColor: gradientAgendamentos
                },
                {
                  label: "Absenteísmo",
                  data: arrayAbsenteismo,
                  backgroundColor: gradientAbsenteismo
                },
              ],
            },
            options: {
              responsive: true,
              maintainAspectRatio: false,
              legend: {
                position: "bottom",
                labels: {
                  fontSize: 14,
                  fontColor: 'black',
                  family: 'Arial',
                  style: 'bold',
                }
              },
              hover: {
                mode: "label"
              },
              title: {
                display: false,
              },
              plugins: {
                datalabels: {
                  anchor: 'end',
                  align: 'end',
                  color: function(context) {
                    return context.dataset.backgroundColor; // Utiliza a cor da barra
                  },
                  formatter: function(value, context) {
                    return formatarNumero(value);
                  },
                  font: {
                    size: 12,
                    family: 'Tahoma',
                    weight: 'bold'
                  }
                }
              },
              interaction: {
                intersect: false,
                mode: 'index',
              },
              scales: {
                xAxes: [{
                  ticks: {
                    fontSize: 12,
                    fontColor: 'black',
                    family: 'Arial',
                    style: 'bold',
                  }
                }],
                yAxes: [{
                  display: true,
                }]
              },

            },
            plugins: [ChartDataLabels],
          });
          /***********************/
        });
        break;
    }

  }

  fetchDados();
  gerarGrafico("linha-15dias-entregues-cancelados");
  gerarGrafico("linha-12meses-solicitacoes-agendamentos");
  setInterval(async function() {
    var larguraDisponivelProcedimento = $('#tb-ranking-procedimento').width();
    var larguraQuantidadeProcedimento = $('#coluna-quant-proced').width();
    var larguraColuna = (larguraDisponivelProcedimento - (larguraQuantidadeProcedimento + 13) - 13);

    const capturarDados = await fetch('action/carregar_dadosdashboard.php?larguraColuna=' + larguraColuna);
    const resultadoRetorno = await capturarDados.json();

    $('#chartTotalSolicitacoesHoje').html('');
    $('#chartAgendadoFilaHoje').html('');
    $('#chartAgendadoAvulsoHoje').html('');
    $('#chartCancelamentoHoje').html('');
    document.getElementById('totalSolicitacoesHoje').textContent = "...";
    document.getElementById('totalCancelamentoHoje').textContent = "...";
    document.getElementById('totalAgendadoFilaHoje').textContent = "...";
    document.getElementById('totalAgendadoAvulsoHoje').textContent = "...";

    if (resultadoRetorno.dadosHoje.totalSolicitacoesHoje != 0) {
      var percentualAgendadoFilaHoje = parseFloat((resultadoRetorno.dadosHoje.totalAgendadoFilaHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100);
      var percentualAgendadoAvulsoHoje = parseFloat((resultadoRetorno.dadosHoje.totalAgendadoAvulsoHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100)
      var percentualCanceladoHoje = parseFloat((resultadoRetorno.dadosHoje.totalCancelamentoHoje / resultadoRetorno.dadosHoje.totalSolicitacoesHoje) * 100)
    } else {
      var percentualAgendadoFilaHoje = parseFloat('0,0');
      var percentualAgendadoAvulsoHoje = parseFloat('0,0');
      var percentualCanceladoHoje = parseFloat('0,0');
    }

    renderChart('#chartTotalSolicitacoesHoje', resultadoRetorno.dadosHoje.totalSolicitacoesHoje, '#03a9f4', false, 'SOLICITAÇÕES');
    renderChart('#chartAgendadoFilaHoje', percentualAgendadoFilaHoje, '#4caf50', true, 'AGENDADAS FILA');
    renderChart('#chartAgendadoAvulsoHoje', percentualAgendadoAvulsoHoje, '#4caf50', true, 'AGENDADAS AVULSO');
    renderChart('#chartCancelamentoHoje', percentualCanceladoHoje, '#ca0202', true, 'CANCELADAS');

    document.getElementById('totalSolicitacoesHoje').textContent = `${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
    document.getElementById('totalAgendadoFilaHoje').textContent = `${resultadoRetorno.dadosHoje.totalAgendadoFilaHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
    document.getElementById('totalAgendadoAvulsoHoje').textContent = `${resultadoRetorno.dadosHoje.totalAgendadoAvulsoHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;
    document.getElementById('totalCancelamentoHoje').textContent = `${resultadoRetorno.dadosHoje.totalCancelamentoHoje} / ${resultadoRetorno.dadosHoje.totalSolicitacoesHoje}`;

    $("#ranking_usuario").html(resultadoRetorno.dadosHojeRankingUsuario)
    $("#ranking_unidade").html(resultadoRetorno.dadosHojeRankingUnidade)
    $("#ranking_procedimento").html(resultadoRetorno.dadosHojeRankingProcedimento)

  }, 300000)
</script>