<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-ui-block" style='margin-top:-15px !important'></i>&nbsp;Afastrar Profissional
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section"><i class="icofont icofont-edit"></i> <b>Informações para pesquisa</b></h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-5">
												<div class="form-group">
													<label for="unidadeSaude">Unidade de Saúde:</label>
													<select type="text" id="unidadeSaude" class="form-control">
														<option value=''>SELECIONE A UNIDADE DE SAÚDE...</option>
														<?php
														$stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="profissinoalSaude">Profissional:</label>
													<select type="text" id="profissinoalSaude" class="form-control">
														<option value=''>TODOS...</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-3">
												<div class="form-group">
													<label for="grupoProcedimento">Grupo/Procedimento:</label>
													<select id="grupoProcedimento" class="form-control">
														<option value=''>SELECIONE...</option>
														<?php
														?>
													</select>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicial">Início:</label>
													<input type="date" id="dataInicial" class="form-control text-center"/>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataFinal">Fim:</label>
													<input type="date" id="dataFinal" class="form-control text-center"/>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label>&nbsp;</label><br>
													<button type="button" class="btn btn-success" onClick="pesquisarAgenda()" id="btnPesquisarAgenda" style='width:120px'><i class="icofont icofont-checked"></i> Afastar</button>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_agendas'>
									<thead>
										<tr>
											<th style="text-align:center; width:90px">
												<div style='margin-top:-22px'>OPÇÕES</div>
											</th>
											<th style="text-align:center; width:60px">
												<div style='margin-top:-22px'>STATUS</div>
											</th>											
											<th style="text-align:center; width:60px">
												<div style='margin-top:-22px'>CÓDIGO</div>
											</th>
											<th>
												<div style='margin-top:-22px'>PROFISSIONAL</div>
											</th>
											<th style="text-align:center; width:50px">
												<div style='margin-top:-22px'>MÊS</div>
											</th>
											<th style="text-align:center; width:40px">
												<div style='margin-top:-22px'>HORÁRIO</div>
											</th>
											<th style="text-align:center; width:60px">OFERTA<br>(1ª vez)</th>
											<th style="text-align:center; width:60px">OFERTA<br>(retorno)</th>
											<th style="text-align:center; width:60px">OFERTA<br>(reserva)</th>
											<th style="text-align:center; width:70px">DATA<br>(inclusão)</th>
											<th style="text-align:center; width:60px">DATA<br>(alteração)</th>
										</tr>
									</thead>
									<tbody style="background-color:#f5f5f5">
									</tbody>
									<tfoot style='background-color:#289CD4; color:#fff'>
										<tr>
											<th colspan='6' style='padding:8px'>Total de vagas alocadas de acordo com a pesquisa:</th>
											<th style='text-align:center;padding:8px'>0</th>
											<th style='text-align:center;padding:8px'>0</th>
											<th style='text-align:center;padding:8px'>0</th>
											<th colspan='2' style='background-color:#046b97; color:#fff;padding:8px'>Total : 0</th>
										</tr>
									</tfoot>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_envio_cancelar.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	setClassTable("dados_solicitacoes");
	$("#liAgendaConfigurar").attr('class', 'active');
	$("#liAgendaConfigurar").css("border-bottom", "2px solid #c4c8ca");

	$("#unidadeSaude").change(function() {

		if (this.value != "") {
			$.ajax({
				url: 'filtros/filtrar_profissionalagenda',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro': 'agenda-configuracao',
					'idUnidadeSaude': this.value
				}
			}).done(function(resultadoRetorno) {
				$("#profissinoalSaude").html(resultadoRetorno);
			});

		} else {
			$("#profissinoalSaude").html("<option value=''>SELECIONE PRIMEIRO A UNIDADE</option>");
		}

	})

	function filtrarProcedimentos() {

		var itemSelecionado = $('#grupoProcedimento').find(":selected").text();
		if (itemSelecionado.substr(0, 5) == "GRUPO") {
			$("#nomeProcedimento").prop('disabled', true);
		} else {
			$("#nomeProcedimento").prop('disabled', false);
		}
		$("#embacado").css("display", "block");

		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'consultar-solicitacao',
				'grupoProcedimento': $("#grupoProcedimento").val()
			}
		}).done(function(resultadoRetorno) {
			$("#procedimentoSelecionado").val("");
			$("#nomeProcedimento").html("");
			$("#nomeProcedimento").html(resultadoRetorno);
			$("#embacado").css("display", "none");
		});

	}

	function novaAgenda() {
		var idAgenda = 0;
		var idUnidadeSaude = $("#unidadeSaude").val();
		var nomeUnidade = $('#unidadeSaude').find(":selected").text();
		var idProfissinoalSaude = $("#profissinoalSaude").val();
		var nomeProfissinoalSaude = $('#profissinoalSaude').find(":selected").text().replace("NÃO ", "NAO ");
		var idGrupoProcedimento = $("#grupoProcedimento").val();
		var nomeGrupoProcedimento = $('#grupoProcedimento').find(":selected").text().replace("NÃO ", "NAO ");
		var eGrupoSelecionado = nomeGrupoProcedimento.substr(0, 5) == "GRUPO" ? "SIM" : "NÃO";
		var idProcedimento = $("#nomeProcedimento").val();
		var nomeProcedimento = $('#nomeProcedimento').find(":selected").text();
		var idMesAgenda = $("#mesAgenda").val();
		var nomeMesAgenda = $('#mesAgenda').find(":selected").text();
		var anoAgenda = $("#anoAgenda").val();

		// validar preenchimento dos campos
		if (idUnidadeSaude == "") {
			swal("Unidade de Saúde", "Selecione a unidade de saúde para criar agenda!", "error");
			return false;
		}
		if (idProfissinoalSaude == "") {
			swal("Profissional de Saúde", "Selecione o profissional de saúde para criar agenda!", "error");
			return false;
		}
		if (idGrupoProcedimento == "") {
			swal("Profissional de Saúde", "Selecione o grupo ou a opção 'NÃO AGRUPADOS'!", "error");
			return false;
		}
		if (idProcedimento == "") {
			if (eGrupoSelecionado != "SIM") {
				swal("Procedimento", "Selecione o procedimento para criação da agenda.", "error");
				return false;
			}
		}
		if (idMesAgenda == "") {
			swal("Mês da Agenda", "Selecione o mês para criação da agenda!", "error");
			return false;
		}

		// abrir tela para configuração da agenda

		var stringAutorization = btoa(idAgenda + '#' + idUnidadeSaude + '#' + nomeUnidade + '#' + idProfissinoalSaude + '#' + nomeProfissinoalSaude + '#' + idGrupoProcedimento + '#' + nomeGrupoProcedimento + '#' + eGrupoSelecionado + '#' + idProcedimento + '#' + nomeProcedimento + '#' + idMesAgenda + '#' + nomeMesAgenda + '#' + anoAgenda);
		var urlConfigurarAgenda = "agenda_configurar?authorization=" + stringAutorization;
		window.open(urlConfigurarAgenda);

	}

	function pesquisarAgenda() {

		var unidadeSaude = $("#unidadeSaude").val();
		var profissinoalSaude = $("#profissinoalSaude").val();
		var grupoProcedimento = $("#grupoProcedimento").val();
		var nomeProcedimento = $("#nomeProcedimento").val();
		var mesAgenda = $("#mesAgenda").val();
		var anoAgenda = $("#anoAgenda").val();
		var statusAgenda = $("#statusAgenda").val();

		if (unidadeSaude == "") {
			swal("Informação Obrigatória", "Você deve selecionar a unidade de saúde para pesquisar.", "info");
			return false;
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'filtros/filtrar_agendas',
			type: 'post',
			dataType: 'html',
			data: {
				'unidadeSaude': unidadeSaude,
				'profissinoalSaude': profissinoalSaude,
				'grupoProcedimento': grupoProcedimento,
				'nomeProcedimento': nomeProcedimento,
				'mesAgenda': mesAgenda,
				'anoAgenda': anoAgenda,
				'statusAgenda': statusAgenda,
			}
		}).done(function(resultadoRetorno) {
			var retornoResultado	= resultadoRetorno.split("###");			
			$("#embacado").css("display", "none");
			if (retornoResultado[0] != "semRegistros") {
				$('#dados_agendas').DataTable().destroy();
				$('#dados_agendas tbody').empty().append(retornoResultado[0]);
				$('#dados_agendas tfoot').empty().append(retornoResultado[1]);
				$('#dados_agendas').DataTable();
			} else {
				swal("Sem Registros", 'Não foram encontrados registros com os parâmetros informados.', 'error');
				$('#dados_agendas').DataTable().destroy();
				$('#dados_agendas tbody').empty().append();
				$('#dados_agendas tfoot').empty().append(retornoResultado[1]);
				$('#dados_agendas').DataTable();
				return false;
			}
		});

	}
</script>