<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header-clean.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$idPaciente	= $_GET['opc'];

$sqlAgendamentoPaciente = "SELECT reg_tb_agendamentos.id_agendamento, tb_paciente.nome_paciente, tb_paciente.cns_paciente, tb_paciente.celular1, tb_paciente.celular1_whatsapp,
tb_paciente.celular2, tb_paciente.celular2_whatsapp, tb_paciente.celular3, tb_paciente.celular3_whatsapp, reg_tb_procedimento.id_procedimento, reg_tb_procedimento.nome_procedimento, 
date_format(reg_tb_agendamentos.data_retirada,'%d/%m/%Y') as dataRetirada, reg_tb_agendamentos.status_agendamento FROM reg_tb_agendamentos INNER JOIN 
tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente) INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento) 
WHERE reg_tb_agendamentos.id_paciente='$idPaciente' AND (reg_tb_agendamentos.status_agendamento='Agendado' OR reg_tb_agendamentos.status_agendamento='Confirmado' OR reg_tb_agendamentos.status_agendamento='Devolvido') 
ORDER BY reg_tb_agendamentos.data_retirada";

$stmDadosPaciente = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosPaciente->execute();
$rsDadosPaciebte  = $stmDadosPaciente->fetch(PDO::FETCH_OBJ);

/* dados do paciente */
$nomePaciente       = $rsDadosPaciebte->nome_paciente;
$cnsPaciente        = $rsDadosPaciebte->cns_paciente;
$telefone1          = $rsDadosPaciebte->celular1_whatsapp == "S" ? $rsDadosPaciebte->celular1 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular1;
$telefone2          = $rsDadosPaciebte->celular2_whatsapp == "S" ? $rsDadosPaciebte->celular2 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular2;
$telefone3          = $rsDadosPaciebte->celular3_whatsapp == "S" ? $rsDadosPaciebte->celular3 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular3;
$gerarDadosPaciente = "$nomePaciente##$cnsPaciente##$telefone1##$telefone2##$telefone3";

/* dados do agendamento */
$stmDadosAgendamento	= $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosAgendamento->execute();
$rsDadosAgendamento		= $stmDadosAgendamento->fetchAll(PDO::FETCH_ASSOC);
$totalRegistros				= $stmDadosAgendamento->rowCount();

if ($totalRegistros == 0) {
	echo "<script>
		window.close();
	</script>";
}

$htmlAgendamento     = "";
foreach ($rsDadosAgendamento as $fieldAgendamento) {
	$idAgendamento      = $fieldAgendamento['id_agendamento'];
	$dataRetirada       = $fieldAgendamento['dataRetirada'];
	$nomeProcedimento   = mb_strtoupper($fieldAgendamento['nome_procedimento']);
	$statusProcedimento	= mb_strtoupper($fieldAgendamento['status_agendamento']);
	$selectStatus				= $fieldAgendamento['status_agendamento'];
	$linkAtualizarStatus = 'onChange="atualizarStatus(' . "'$idAgendamento',this.value + '#$selectStatus')" . '"';
	$comboStatus = "<select id='setStatus$idAgendamento' class='form-control' $linkAtualizarStatus>
		<option value='$selectStatus'>SELECIONE...</option>
		<option value='Entregue'>ENTREGUE</option>
		<option value='Cancelar'>CANCELAR</option>
	</select>";
	$htmlAgendamento .= "<tr>
		<td align='center' style='border: 1px solid gray; height: 30px;'>$dataRetirada</td>
		<td style='border: 1px solid gray'>&nbsp;$nomeProcedimento</td>
		<td style='border: 1px solid gray' id='status-$idAgendamento'>$statusProcedimento</td>		
		<td style='border: 1px solid gray'>$comboStatus</td>
	</tr>";
}

$tokenEntrega	= strtoupper(substr(md5(uniqid(rand(), true)), 0, 20));
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-phone" style='margin-top:-15px !important'></i>&nbsp;Registro de Entrega de Marcações
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" id="formularioConsumo">
									<div class="form-body" style='margin-top:-15px'>
										<h4 class="form-section"><i class="icofont icofont-user"></i> <b>Dados do Paciente:</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-6">
												<div class="form-group">
													<label for="nomePacienteLigacao">Nome do Paciente:</label>
													<input type="text" id="nomePacienteLigacao" class="form-control" readonly value="<?php echo $nomePaciente; ?>">
													<input type="hidden" id="idPacienteEntrega" value="<?php echo $idPaciente; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="cnsPaciente">CNS:</label>
													<input type="text" id="cnsPacienteLigacao" class="form-control text-center" readonly value="<?php echo $cnsPaciente; ?>">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataEntrega">Data da Entrega:</label>
													<input type="date" id="dataEntrega" class="form-control text-center" value="<?php echo date('Y-m-d'); ?>">
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomePortador">Nome do Portador:</label>
													<input type="text" id="nomePortador" class="form-control">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="rgPortador">RG do Portador:</label>
													<input type="text" id="rgPortador" class="form-control">
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="telefonePortador">Telefone do Portador:</label>
													<input type="text" id="telefonePortador" class="form-control">
												</div>
											</div>
											<div class="col-md-3" hidden>
												<div class="form-group">
													<label for="pacienteEPortador">O Próprio Paciente:</label>
													<input type="checkbox" id="pacienteEPortador" class="form-control checkbox-novo" style='margin-top:-5px'>
													<input type="hidden" id="tokenEntrega" class="form-control" value="<?php echo $tokenEntrega; ?>">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-15px'>
											<div class="col-md-12">
												<div class="form-group">
													<table style='width:100%; border: 1px solid gray'>
														<thead>
															<tr style="background: url(css/images/bg-tr.png); background-repeat: repeat-x; height: 40px !important;">
																<th style='text-align:center; border: 1px solid gray' width='180px !important'>RETIRAR ATÉ</th>
																<th style='border: 1px solid gray'>&nbsp;PROCEDIMENTO</th>
																<th style='border: 1px solid gray; width:250px'> STATUS ATUAL</th>
																<th style='border: 1px solid gray; width:220px'> NOVO STATUS</th>
															</tr>
														</thead>
														<tbody id='dados_procedimentos_listados'>
															<?php echo $htmlAgendamento; ?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-15px' hidden>
											<div class="col-md-12">
												<div class="form-group">
													<label for="observacaoEntrega">Obseração:</label>
													<input type="text" id="observacaoEntrega" class="form-control">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-12">
												<div class="form-group">
													<table align="center">
														<tr>
															<td width="75px">
																<button type="button" class="btn btn-info" onclick="confirmarEntregaMarcacao()"><i class="fa fa-check-square-o botaoOk"></i><b>&nbsp;Confirmar</b></button>
															</td>
															<td width="75px">
																<button type="button" class="btn btn-danger" id="botao_modal_info" onclick="fecharAba()"><i class="ft-log-out botaoOk"></i><b>&nbsp;Fechar</b></button>
															</td>
														</tr>
													</table>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	/* atualizar status do agendamento*/
	function fecharAba(opcaoFecharAba) {
		window.close();
	}

	/* atualizar status do agendamento*/
	function atualizarStatus(idAgendamento, valorStatus) {

		var selectStatus = valorStatus.split("#");

		if (valorStatus != "") {
			if ($("#nomePortador").val() == "" || $("#rgPortador").val() == "" || $("#telefonePortador").val() == "") {
				$("#setStatus" + idAgendamento).val(selectStatus[1]);
				swal("Dados Obrigatórios", "Você deve informar os dados do portador antes de mudar o status.", "error");
				return false;
			}
		}

		$.ajax({
			url: 'action/gravar_atualizacaostatus',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAtualizacao': 'status-entrega',
				'idAgendamento': idAgendamento,
				'valorStatus': selectStatus[0],
				'nomePortador': $("#nomePortador").val(),
				'rgPortador': $("#rgPortador").val(),
				'telefonePortador': $("#telefonePortador").val(),
				'tokenEntrega': $("#tokenEntrega").val()
			}
		}).done(function(resultadoRetorno) {});

	}

	$("#pacienteEPortador").change(function() {

		if (this.checked) {
			$("#nomePortador").val('');
			$("#rgPortador").val('');
			$("#telefonePortador").val('');
			$("#nomePortador").prop('disabled', true);
			$("#telefonePortador").prop('disabled', true);
			$("#rgPortador").prop('disabled', true);
		} else {
			$("#nomePortador").prop('disabled', false);
			$("#nomePortador").focus();
			$("#rgPortador").prop('disabled', false);
			$("#telefonePortador").prop('disabled', false);
		}
	})


	function confirmarEntregaMarcacao() {

		var pacientePortador = document.getElementById('pacienteEPortador').checked == true ? "S" : "N";

		if (pacientePortador == "N") {
			if ($("#dataEntrega").val() == "" || $("#nomePortador").val() == "" || $("#rgPortador").val() == "") {
				swal("Dados Obrigatórios", "Dados do portador devem ser preenchidos.", "error");
				return false;
			}
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'action/gravar_entregamarcacao',
			type: 'post',
			dataType: 'html',
			data: {
				'IdPaciente': $("#idPacienteEntrega").val(),
				'dataEntrega': $("#dataEntrega").val(),
				'nomePortador': $("#nomePortador").val(),
				'rgPortador': $("#rgPortador").val(),
				'telefonePortador': $("#telefonePortador").val(),
				'observacaoEntrega': $("#observacaoEntrega").val(),
				'pacientePortador': pacientePortador,
				'tokenEntrega': $("#tokenEntrega").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			swal("Entrega Registrada", "Dados da entrega registrados com sucesso.", "success");
		});

	}
</script>