<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");

$idPaciente      = $_GET['idp'];
$prazoRetirada  =  $_GET['dr'];
$opcaoRegistro  = $_GET['op'];

if ($opcaoRegistro == "sol") {
  $sqlAgendamentoPaciente = "SELECT reg_tb_solicitacoes.*, tb_paciente.nome_paciente, tb_paciente.cns_paciente, tb_paciente.nomemae, tb_paciente.celular1, tb_paciente.celular1_whatsapp, 
	tb_paciente.celular2, tb_paciente.celular2_whatsapp, tb_paciente.celular3, tb_paciente.celular3_whatsapp,reg_tb_procedimento.id_procedimento, reg_tb_procedimento.nome_procedimento, 
	date_format(reg_tb_solicitacoes.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada, reg_tb_solicitacoes.origem_agendamento, reg_rl_mensagem_padrao.mensagem, reg_rl_mensagem_padrao.mensagem, 
	date_format(datanasc,'%d/%m/%Y') AS dataNascimento, date_format(nascimentocompanhante_policlinica,'%d/%m/%Y') AS nascimentoAcompanhante, reg_tb_solicitacoes_agendado.pasta_documento, 
	reg_tb_solicitacoes_agendado.nomearquivo_documento FROM reg_tb_solicitacoes
	INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente = tb_paciente.id_paciente)
	INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento)
	INNER JOIN reg_rl_mensagem_padrao ON (reg_rl_mensagem_padrao.sistema_origem=reg_tb_solicitacoes.sistema_origem)
	INNER JOIN reg_tb_solicitacoes_agendado ON (reg_tb_solicitacoes_agendado.id_sca_solicitacao=reg_tb_solicitacoes.id_solicitacao)
	WHERE (reg_tb_solicitacoes.id_paciente='$idPaciente') AND (id_statussolicitacao='3' OR id_statussolicitacao='6' OR id_statussolicitacao='7')
	AND (carro_policlinica='S')
	AND (transporte_gerado='N')
	AND (date_format(dataprazo_retirada,'%Y%m%d')='$prazoRetirada')";
} else {
  $sqlAgendamentoPaciente = "SELECT reg_tb_agendamentos.*, tb_paciente.nome_paciente, tb_paciente.cns_paciente, tb_paciente.nomemae, tb_paciente.celular1, tb_paciente.celular1_whatsapp, 
	tb_paciente.celular2, tb_paciente.celular2_whatsapp, tb_paciente.celular3, tb_paciente.celular3_whatsapp,reg_tb_procedimento.id_procedimento, reg_tb_procedimento.nome_procedimento, 
	date_format(reg_tb_agendamentos.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada, reg_tb_agendamentos.origem_agendamento, 
	date_format(datanasc,'%d/%m/%Y') AS dataNascimento, date_format(nascimentocompanhante_policlinica,'%d/%m/%Y') AS nascimentoAcompanhante, reg_tb_solicitacoes_agendado.pasta_documento, 
	reg_tb_solicitacoes_agendado.nomearquivo_documento FROM reg_tb_agendamentos
	INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
	INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento)
	INNER JOIN reg_tb_solicitacoes_agendado ON (reg_tb_solicitacoes_agendado.id_agendamento_direto=reg_tb_agendamentos.id_agendamento)
	WHERE (reg_tb_agendamentos.id_paciente='$idPaciente') AND (origem_agendamento!='S-FG' AND status_agendamento='A')
	AND (carro_policlinica='S')
	AND (transporte_gerado='N')
	AND (date_format(dataprazo_retirada,'%Y%m%d')='$prazoRetirada')";
}

$stmDadosPaciente = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosPaciente->execute();
$rsDadosPaciebte  = $stmDadosPaciente->fetch(PDO::FETCH_OBJ);

/* dados do paciente */
$nomePaciente       = $rsDadosPaciebte->nome_paciente;
$cnsPaciente        = $rsDadosPaciebte->cns_paciente;
$nascimentoPaciente  = $rsDadosPaciebte->dataNascimento;
$maePaciente        = $rsDadosPaciebte->nomemae;
$telefone1          = $rsDadosPaciebte->celular1_whatsapp == "S" ? $rsDadosPaciebte->celular1 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular1;
$telefone2          = $rsDadosPaciebte->celular2_whatsapp == "S" ? $rsDadosPaciebte->celular2 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular2;
$telefone3          = $rsDadosPaciebte->celular3_whatsapp == "S" ? $rsDadosPaciebte->celular3 . " - <i class='icofont icofont-brand-whatsapp'></i>" : $rsDadosPaciebte->celular3;

$mensagemWhatsapp    = "";
/* dados do agendamento */
$stmDadosAgendamento = $rsConexao->prepare($sqlAgendamentoPaciente);
$stmDadosAgendamento->execute();
$rsDadosAgendamento  = $stmDadosAgendamento->fetchAll(PDO::FETCH_ASSOC);

$formatarPontoPartida = array(
  'AREIA-BRANCA'      =>  'AREIA BRANCA (POSTO DE SAÚDE ACR)',
  'FINAL-LINHA'        =>  'FINAL DE LINHA DE LAURO',
  'PASSARELA-FLORES'  =>  'PASSARELA DAS FLORES - (ANTIGO MAXXI)',
  'UPA-ITINGA'        =>  'UPA DE ITINGA',
  'PORTÃO'            =>  'PORTÃO'
);
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-edit" style='margin-top:-15px !important'></i>&nbsp;Registro de Transporte para Policlínica
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" id="formularioConsumo">
                  <div class="form-body" style='margin-top:-15px'>
                    <h4 class="form-section"><i class="icofont icofont-user"></i> <b>Dados do Paciente:</b></h4>
                    <div class="row" style='margin-top:-10px'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomePacienteTransporte">Nome do Paciente:</label>
                          <input type="text" id="nomePacienteTransporte" class="form-control" readonly value="<?php echo $nomePaciente; ?>">
                          <input type="hidden" id="idPacienteTransporte" value="<?php echo $idPaciente; ?>">
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cnsPaciente">CNS:</label>
                          <input type="text" id="cnsPacienteTransporte" class="form-control text-center" readonly value="<?php echo $cnsPaciente; ?>">
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="nascimentoPaciente">Nascimento:</label>
                          <input type="text" id="nascimentoPaciente" class="form-control text-center" readonly value="<?php echo $nascimentoPaciente; ?>">
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomeMae">Nome da Mãe:</label>
                          <input type="text" id="nomeMae" class="form-control" readonly value="<?php echo $maePaciente; ?>">
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12" style="margin-top:-10px">
                        <div class="form-group">
                          <label for="telefone1">Telefones de Contato:</label>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4" style="margin-top:-25px">
                        <div class="form-group">
                          <label id="telefone1" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone1; ?></label>
                        </div>
                      </div>
                      <div class="col-md-4" style="margin-top:-25px">
                        <div class="form-group">
                          <label id="telefone2" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone2; ?></label>
                        </div>
                      </div>
                      <div class="col-md-4" style="margin-top:-25px">
                        <div class="form-group">
                          <label id="telefone3" class="form-control" style='background-color:#bdf2ff'><?php echo $telefone3; ?></label>
                        </div>
                      </div>
                    </div>
                    <div class="row" style='display:none'>
                      <div class="col-md-12" style="margin-top:-15px">
                        <div class="form-group">
                          <label for="meioComunicacao">Meio de Comunicação:</label>
                          <select type="text" id="meioComunicacao" class="form-control" disabled>
                            <option value='whatsapp' selected>WHATSAPP</option>
                            <option value='Transporte_telefonica'>LIGAÇÃO TELEFÔNICA</option>
                            <option value='ambos'>AMBOS</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <?php
                    if ($stmDadosAgendamento->rowcount() > 0) {
                      echo "<h4 class='form-section'><i class='icofont icofont-bus-alt-1'></i> <b>Dados para o transporte:</b></h4>";
                      echo "<div class='row' style='margin-top:-15px;'>";
                      foreach ($rsDadosAgendamento as $fieldDadosAgendamento) {
                        $idSolicitacao          = $fieldDadosAgendamento['id_solicitacao'];
                        $nomeProcedimento        = mb_strtoupper($fieldDadosAgendamento['nome_procedimento']);
                        $comAcompanhante        = mb_strtoupper($fieldDadosAgendamento['precisaacompanhante_policlinica']) == "S" ? "SIM" : "NÃO";
                        $nomeAcompanhante        = mb_strtoupper($fieldDadosAgendamento['nomeacompanhante_policlinica']);
                        $documentoAcompanhanete  = mb_strtoupper($fieldDadosAgendamento['documentoacompanhante_policlinica']);
                        $maeAcompanhanete        = mb_strtoupper($fieldDadosAgendamento['maeacompanhante_policlinica']);
                        $nascimentoAcompanhante  = $fieldDadosAgendamento['nascimentoAcompanhante'];
                        $localPartida            = $fieldDadosAgendamento['localpartida_policlinica'];
                        $diretorioBase          = "docagendamentos/";
                        $pastaDocumento          = $fieldDadosAgendamento['pasta_documento'];
                        $arquivoAgendamento      = $fieldDadosAgendamento['nomearquivo_documento'];
                        $numeracaoArquivo       = str_pad($idSolicitacao, 10, "0");

                        $linkArquivo            = $diretorioBase . $pastaDocumento . "/" . $numeracaoArquivo . "_" . $arquivoAgendamento;
                        $comandoOnClick  = 'onclick="' . "imprimirMarcacao('$linkArquivo')" . '"';
                        echo "
																			<div class='col-md-6'>
																			<div class='form-group'>
																				<label>Procedimento:</label>
																				<div class='input-group'>																					
																					<div class='input-group-append'>
																						<button type='button' class='btn btn-blue' id='btnImprimirMarcacao' $comandoOnClick>
																							<i class='icofont icofont-print botaoOk'></i>
																						</button>
																					</div>
																					<input type='text' id='nomeProcedimento' class='form-control' disabled value='$nomeProcedimento '>
																				</div>																			
																			</div>	
																		</div>
																		<div class='col-md-2'>
																			<div class='form-group'>
																				<label>Acompanhate?</label>
																				<input type='text' id='comAcompanhante' class='form-control text-center' value='$comAcompanhante' disabled>
																			</div>
																		</div>
																		<div class='col-md-4'>
																			<div class='form-group'>
																				<label>Nome Acompanhanete:</label>
																				<input type='text' id='nomeAcompanhanete' class='form-control' value='$nomeAcompanhante' disabled>
																			</div>
																		</div>
																		<div class='col-md-2'>
																			<div class='form-group'>
																				<label>Nº Documento:</label>
																				<input type='text' id='docAcompanhanete' class='form-control text-center' value='$documentoAcompanhanete' disabled>
																			</div>
																		</div>
																		<div class='col-md-4'>
																			<div class='form-group'>
																				<label>Nome da Mãe:</label>
																				<input type='text' id='maeAcompanhanete' class='form-control' value='$maeAcompanhanete' disabled>
																			</div>
																		</div>
																		<div class='col-md-2'>
																			<div class='form-group'>
																				<label>Data Nascimento:</label>
																				<input type='text' id='nascAcompanhante' class='form-control text-center' value='$nascimentoAcompanhante' disabled>
																			</div>
																		</div>
																		<div class='col-md-4'>
																			<div class='form-group'>
																				<label>Local de Partida:</label>
																				<input type='text' id='localPartida' class='form-control' value='$localPartida' disabled>
																			</div>
																		</div>
																		";
                      }
                      echo "</div>";
                    }
                    ?>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" id="btnConfirmarTransporte" onclick="confirmarTransporte()"><i class="icofont icofont-checked"></i><b>&nbsp;Confirmar</b></button>
  <button type="button" class="btn btn-danger" id="btnFechar" onclick="fecharAbaTransporte()"><i class="ft-log-out botaoOk"></i><b>&nbsp;Fechar</b></button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  /* atualizar status do agendamento*/
  function fecharAbaTransporte(opcaoFecharAba) {
    window.close();
  }

  /* confirmar registros da comunicação com o paciente */
  function confirmarTransporte() {

    var idPaciente = $("#idPacienteTransporte").val();
    Swal.fire({
      title: "Emissão de Transporte",
      html: "Esta confirmação só deve ser realizada após a emissão dos transporte para o paciente no sistema da Policlínica. <b>Confirma?</b>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/gravar_solicitacao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoGravacao': 'confirmar-transporte-policlinica',
            'opcaoRegistro': "<?php echo $opcaoRegistro; ?>",
            'idPaciente': idPaciente,
            'prazoRetirada': "<?php echo $prazoRetirada; ?>",
            "idSolicitacao": null
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          swal("Emissão de Transporte.", "Confirmação registrada com sucesso.", "success");
        });
      }
    });
  }

  function imprimirMarcacao(linkArquivo) {
    window.open(linkArquivo);
  }
</script>