<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoraImpressao  = date("d/m/Y H:i");

$dataInicial    = $_GET['dti'];
$dataFinal      = $_GET['dtf'];
$idGrupo        = $_GET['grupo'];
$idProcedimento = $_GET['idproc'];
$tipoRelatorio  = $_GET['tipo'];
$totalGeral     = 0;
$rotuloPeriodo  = $dataInicial == "" ? "CADASTRO COMPLETO" : "ENTRE: $dataInicial e $dataFinal";
$rotuloGrupo    = $_GET['grupo'] == "" ? "TODOS" : $_GET['nomegp'];
$rotuloProcedim = $_GET['idproc'] == "" ? "TODOS" : $_GET['nomeproced'];
$rotuloTipo     = $_GET['tipo'] == "sintetico" ? "SINTÉTICO" : "DETALHADO";

$htmpCabecalho = "<table style='font-size:10pt;font-weight:bold;'>
  <tr>
    <td>Período analisado</td>
    <td>:</td>
    <td style='padding-left:2px'>$rotuloPeriodo</td>          
  </tr>
  <tr>
    <td>Grupo analisado</td>
    <td>:</td>
    <td style='padding-left:2px'>$rotuloGrupo</td>          
  </tr>
  <tr>
    <td>Procedimento analisado</td>
    <td>:</td>
    <td style='padding-left:2px'>$rotuloProcedim</td>          
  </tr>
  <tr>
    <td>Tipo de relatório</td>
    <td>:</td>
    <td style='padding-left:2px'>$rotuloTipo</td>          
  </tr>  
</table><br>";

ob_start();
switch ($tipoRelatorio) {
  case "sintetico":

    $orientacaoPagina = "P";
    echo $htmpCabecalho;
    echo "<table class='tabela-dados-relatorio'>
        <thead>
          <tr>
            <th scope='col' style='text-align: left'>NOME DO GRUPO/PROCEDIMENTOS</th>
            <th scope='col' style='text-align: center' width='150px'>QUANTIDADE NA FILA</th>
          </tr>
        </thead>
      <tbody>";
    $whereRelatorio = "WHERE (reg_tb_solicitacoes.id_statussolicitacao=2)";
    $whereRelatorio = $dataInicial == "" ? $whereRelatorio : $whereRelatorio . " AND (date_format(datahora_cadastro,'%Y-%m-%d') BETWEEN '$dataInicial' AND '$dataFinal')";
    $whereRelatorio = $_GET['grupo'] == "" ? $whereRelatorio : $whereRelatorio . " AND (reg_tb_solicitacoes.id_grupo_procedimento='$idGrupo')";
    $whereRelatorio = $idProcedimento == "" ? $whereRelatorio : $whereRelatorio . " AND (reg_tb_solicitacoes.id_procedimento='$idProcedimento')";

    if ($_GET['grupo'] == "") {
      $sqlRelatorio = "SELECT UCASE(reg_tb_procedimento_grupo.nome_grupo_procedimento) AS nomeGrupoProcedimento,
      COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeFila
      FROM reg_tb_procedimento_grupo INNER JOIN reg_tb_solicitacoes ON (reg_tb_procedimento_grupo.id_grupo_procedimento = reg_tb_solicitacoes.id_grupo_procedimento)
      $whereRelatorio
      GROUP BY reg_tb_procedimento_grupo.nome_grupo_procedimento
      ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC";
    } else {
      $sqlRelatorio = "SELECT UCASE(reg_tb_procedimento.nome_procedimento) AS nomeGrupoProcedimento,
      COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeFila
      FROM reg_tb_procedimento INNER JOIN reg_tb_solicitacoes ON (reg_tb_procedimento.id_procedimento = reg_tb_solicitacoes.id_procedimento)
      $whereRelatorio
      GROUP BY reg_tb_procedimento.nome_procedimento
      ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC";      
    }
    $stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
    $stmRelatorio->execute();
    $rsRelatorio    = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
    $totalRegistros = $stmRelatorio->rowCount();

    if ($totalRegistros > 0) {
      foreach ($rsRelatorio as $fieldRelatorio) {
        $nomeGrupoProcedimento  = $fieldRelatorio['nomeGrupoProcedimento'];
        $quantidadeFila         = number_format($fieldRelatorio['quantidadeFila'], 0, '', '.');
        $totalGeral             = $totalGeral + $fieldRelatorio['quantidadeFila'];
        echo "<tr>
            <td style='line-height:17px'>$nomeGrupoProcedimento</td>
            <td align='center'>$quantidadeFila</td>
          </tr>";
      }
      $exibirTotalGeral = number_format($totalGeral, 0, '', '.');

      $sqlPessoas = "SELECT reg_tb_solicitacoes.id_paciente,
        reg_tb_solicitacoes.id_statussolicitacao
        FROM reg_tb_solicitacoes
        $whereRelatorio
        GROUP BY reg_tb_solicitacoes.id_paciente";
      $stmPessoas = $rsConexao->prepare($sqlPessoas);
      $stmPessoas->execute();
      $totalPessoas = number_format($stmPessoas->rowCount(), 0, '', '.');

      $mediaProcedimentoPessoa = number_format($totalGeral / $stmPessoas->rowCount(), 1, ',', '');

      echo "<tr style='background-color:#f1f1f1'>
          <td style='line-height:25px'><b>TOTAL DE PROCEDIMENTOS:</b></td>
          <td align='center'><b>$exibirTotalGeral</b></td>
        </tr>
        <tr style='background-color:#dadada'>
          <td style='line-height:25px'><b>TOTAL DE PESSOA:</b></td>
          <td align='center'><b>$totalPessoas</b></td>
        </tr>
        <tr style='background-color:#f1f1f1'>
          <td style='line-height:25px'><b>MÉDIA DE PROCEDIMENTOS POR PESSOA:</b></td>
          <td align='center'><b>$mediaProcedimentoPessoa</b></td>
        </tr>        ";
    }

    echo "</tbody>
      </table>";
    break;
}

require_once __DIR__ . '../../../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => $orientacaoPagina,
  'margin_header' => 15,
  'margin_top' => 33,
  'default_font' => 'tahoma'
]);


$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet, 1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        LAURO DE FREITAS-BA<br>
        RELATÓRIO DE DEMANDA REPRIMIDA
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$footer = "<table width='100%' style='font-size:8pt'><tr>
  <td align='left'><b>GSaúde - Regulação : Expansão Tecnologia e Consultoria</b></td>
  <td align='right'><b>Página {PAGENO}</b></td>
</tr></table>";

$mpdf->SetHTMLHeader($header);
$mpdf->SetFooter($footer);
$mpdf->SetTitle('Relatório G-SAUDE');
$mpdf->WriteHTML($html);
$mpdf->Output('RelatórioGSaude.pdf', 'I');
$mpdf->AddPage();
exit;
