<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado      = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado    = $_SESSION['nomeUsuarioLogado'];
$idPerfilLogado       = $_SESSION['idPerfilLogado'];
$dataHoraImpressao    = date("d/m/Y H:i");
$htmRelatorio         = "";
$contadorAgendamentos = 0;
$authorizationCode    = explode("#", base64_decode($_GET['authorization']));
$unidadeSaude         = $authorizationCode[1];
$profissinoalSaude    = $authorizationCode[2];
$grupoProcedimento    = $authorizationCode[3];
$nomeProcedimento     = $authorizationCode[4];
$statusAgendamento    = $authorizationCode[5];
$numeroCNSCPF         = $authorizationCode[6];
$numeroProtocolo      = $authorizationCode[7];
$opcaoPeriodo         = $authorizationCode[8];
$dataInicialPesquisa  = $authorizationCode[9];
$dataFinalPesquisa    = $authorizationCode[10];

# --- pegar unidade e profissional do atendiment -- ## 
$whereProfissional = $profissinoalSaude!="" ? "AND (tb_profissional.codigoprofissional_cnes='$profissinoalSaude')" : "";
$sqlUnidadeProfissonal = "SELECT 
tb_estabelecimento.nfantasia_estabelecimento,
tb_profissional.nome_profissional
FROM tb_profissional_vinculo
INNER JOIN tb_estabelecimento ON (tb_profissional_vinculo.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN tb_profissional ON (tb_profissional_vinculo.codigoprofissional_cnes=tb_profissional.codigoprofissional_cnes)
WHERE (tb_estabelecimento.codigoestabelecimento_cnes='$unidadeSaude') $whereProfissional";

$stmUnidadeProfissonal    = $rsConexao->prepare($sqlUnidadeProfissonal);
$stmUnidadeProfissonal    -> execute();
$rsUnidadeProfissonal     = $stmUnidadeProfissonal->fetch(PDO::FETCH_OBJ);
$unidadeSelecionada       = mb_strtoupper($rsUnidadeProfissonal->nfantasia_estabelecimento);
$profissionalSelecionado  = $profissinoalSaude!="" ? mb_strtoupper($rsUnidadeProfissonal->nome_profissional) : "TODOS";
# ------------------------------------------------ ##

$whereSQL = " WHERE (reg_tb_agendamentos.id_agendamento>0) ";
$whereSQL = $unidadeSaude         == "" ? $whereSQL : $whereSQL . " AND (tb_estabelecimento.codigoestabelecimento_cnes='$unidadeSaude')";
$whereSQL = $profissinoalSaude    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agenda.codigoprofissional_cnes='$profissinoalSaude')";
$whereSQL = $grupoProcedimento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_grupo_procedimento='$grupoProcedimento')";
$whereSQL = $nomeProcedimento     == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_procedimento='$nomeProcedimento')";
if ($statusAgendamento != "") {
  if ($statusAgendamento == "A" || $statusAgendamento == "E") {
    $whereSQL = $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='A' OR reg_tb_agendamentos.status_agendamento='E')";
  }else{
    $whereSQL = $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='$statusAgendamento')";
  }
}
$whereSQL = $numeroCNSCPF         == "" ? $whereSQL : $whereSQL . " AND (tb_paciente.cns_paciente='$numeroCNSCPF' OR tb_paciente.cpf_paciente='$numeroCNSCPF')";
$whereSQL = $numeroProtocolo      == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.protocolo_agendamento='$numeroProtocolo')";
$whereSQL = $opcaoPeriodo         != "" && $dataInicialPesquisa!="" ? $whereSQL . " AND (reg_tb_agendamentos.$opcaoPeriodo BETWEEN '$dataInicialPesquisa' AND '$dataFinalPesquisa')" : $whereSQL  ;

$sqlAgendamentos  = "SELECT reg_tb_agendamentos.id_agendamento,
reg_tb_agendamentos.protocolo_agendamento,
reg_tb_agendamentos.tipo_vagaocupada,
reg_tb_agendamentos.id_paciente,
reg_tb_agendamentos.id_solicitacao,
tb_paciente.nome_paciente,
tb_paciente.cns_paciente,
date_format(tb_paciente.datanasc, '%d/%m/%Y') AS dataNascimento,
tb_paciente.celular1,
tb_paciente.celular2,
tb_paciente.celular3,
reg_tb_procedimento.nome_procedimento,
reg_tb_procedimento.codigo_sus,
tb_estabelecimento.nfantasia_estabelecimento,
date_format(reg_tb_agendamentos.datahora_agendamento, '%d/%m/%Y') AS dataAgendamento,
date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
date_format(reg_tb_agendamentos.data_atendimento, '%Y-%m-%d') AS dataAtendimentoConfirmar,
date_format(reg_tb_agendamentos.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada,
reg_tb_agendamentos.data_atendimento,
reg_tb_usuario.nome_usuario,
reg_tb_agendamentos.status_agendamento,
reg_tb_agendamentos.horario_atendimento,
       reg_tb_agendamentos.chave_confirmacao,
       tb_profissional.nome_profissional,
       reg_tb_procedimento.codigo_integracaoesus
FROM reg_tb_agenda
INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
RIGHT OUTER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
INNER JOIN reg_tb_usuario ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_agendou)
LEFT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_agendamentos.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
INNER JOIN reg_tb_agendamentos_laboratorio ON (reg_tb_agendamentos_laboratorio.id_agendamento = reg_tb_agendamentos.id_agendamento)
INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos_laboratorio.id_procedimento_agendado)
LEFT OUTER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
RIGHT OUTER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
$whereSQL
GROUP BY nome_paciente, reg_tb_procedimento.nome_procedimento
ORDER BY tb_paciente.nome_paciente, reg_tb_procedimento.nome_procedimento";

$stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
$stmAgendamentos  -> execute();

ob_start();
    $htmRelatorio = "<table class='tabela-dados-relatorio'>
    <thead>
      <tr>
        <th scope='col' style='text-align: left'>PACIENTE / NOME DO PROCEDIMENTO</th>
        <th scope='col' style='text-align: center'>CÓDIGO</th>
      </tr>
    </thead>
    <tbody>";

  if($stmAgendamentos->rowCount()>0){
    $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);    
    $nomePacienteHeader = "";
    foreach($rsAgendamentos AS $fieldAgendamento){
      $contadorAgendamentos = $contadorAgendamentos+1;
      $idPaciente         = $fieldAgendamento['id_paciente'];
      $idAgendamento      = $fieldAgendamento['id_agendamento'];
      $idSolicitacao      = $fieldAgendamento['id_solicitacao'];
      $cnsPaciente        = $fieldAgendamento['cns_paciente'];
      $dataNascimento     = $fieldAgendamento['dataNascimento'];
      $numerosTelefone    = $fieldAgendamento['celular1'] != "" ? $fieldAgendamento['celular1'] : "";
      $numerosTelefone    = $fieldAgendamento['celular2'] != "" ? $numerosTelefone . "<br>" . $fieldAgendamento['celular2'] : $numerosTelefone;
      $numerosTelefone    = $fieldAgendamento['celular3'] != "" ? $numerosTelefone . "<br>" . $fieldAgendamento['celular3'] : $numerosTelefone;      
      $nomeProcedimento   = mb_strtoupper($fieldAgendamento['nome_procedimento']);
      $codigoSIGTAP       = $fieldAgendamento['codigo_sus'];
      $nomeUnidade        = mb_strtoupper($fieldAgendamento['nfantasia_estabelecimento']);
      $dataAgendamento    = $fieldAgendamento['dataAgendamento'];
      $dataAtendimento    = $fieldAgendamento['dataAtendimento'];
      $dataRetirada       = $fieldAgendamento['dataRetirada'];
      $quemAgendou        = mb_strtoupper($fieldAgendamento['nome_usuario']);
      $horarioAtendimento = $fieldAgendamento['horario_atendimento'];
      $exibirProtocolo    = $fieldAgendamento['protocolo_agendamento'];
      $chaveValidacao     = $fieldAgendamento['chave_confirmacao'];
      
      if($fieldAgendamento['status_agendamento']=="A"){
        $statusAgendamento  = "AGENDADO";
      }else if($fieldAgendamento['status_agendamento']=="E"){
        $statusAgendamento  = "AGENDADO/ENTREGUE";
      }else{
        $statusAgendamento  = "CANCELADO";
      }

      # -- cabeçalho profissional --#
      if($fieldAgendamento['nome_paciente']!=$nomePacienteHeader){

        $nomePaciente = $fieldAgendamento['nome_paciente'];
        $nomePacienteHeader = $nomePaciente;

       $htmRelatorio .= "<tr>
          <td colspan='2' style='background-color:#ebebeb; font-size:10pt; line-height:25px'>
              <b>&bull; PACIENTE: $nomePaciente</b>
          </td>
        </tr>";
      }

      $htmRelatorio  .= "<tr>
        <td style='padding-left:15px'>$nomeProcedimento</td>        
        <td align='center'>$codigoSIGTAP</td>
      </tr>";
    }
  }else{
      $htmRelatorio .= "<tr>
        <td colspan='2'></td>
      </tr>";
  }

  $dataInicialPesquisa  = explode("-",$authorizationCode[9]);
  $dataInicialPesquisa  = $dataInicialPesquisa[2].'/'.$dataInicialPesquisa[1].'/'.$dataInicialPesquisa[0];
  $dataFinalPesquisa  = explode("-",$authorizationCode[10]);
  $dataFinalPesquisa  = $dataFinalPesquisa[2].'/'.$dataFinalPesquisa[1].'/'.$dataFinalPesquisa[0];
  
  
echo "<table style='font-size: 8pt'>
  <tr>
    <td><b>Unidade Selecionada:</b></td>
    <td>$unidadeSelecionada:</td>
  </tr>
  <tr>
    <td><b>Profissional Selecionado:</b></td>
    <td>$profissionalSelecionado:</td>
  </tr>
  <tr>
    <td><b>Data/Período informado:</b></td>
    <td>Entre: $dataInicialPesquisa e $dataFinalPesquisa</td>
  </tr>  
</table><br>";

echo $htmRelatorio."</tbody></table><b>Total de agendamentos listados: $contadorAgendamentos</b>";

require_once ('../../../lib_sistemas/mpdf8/vendor/autoload.php'); // SERVIDOR
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$htmPDF = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        Módulo - Regulação Ambulatorial<br>
        RELATÓRIO DE AGENDAMENTOS
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "<div>Desenvolvido por: Cláudio Magalhães||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Relatório-gSaúde');
$mpdf->WriteHTML($htmPDF);
$mpdf->Output('Relatório-gSaúde.pdf','I');
exit;

?>