<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];
$idPacienteGet  = $_GET['idpac'];

$dataHoraAgendamento  = date("d/m/Y H:i");

$sqlPaciente  = "SELECT tb_paciente.*, 
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, 
tb_cidades.nome_cidade 
FROM tb_paciente 
INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) 
WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente               = $rsPaciente->id_paciente;
$nomePaciente             = $rsPaciente->nome_paciente;
$idadePaciente            = $rsPaciente->idadePaciente;
$sexoPacienteExibir       = $rsPaciente->sexo == "M" ? "MASCULINO" : "FEMININO";
$sexoPaciente             = $rsPaciente->sexo;
$cnsPaciente              = $rsPaciente->cns_paciente;
$cpfPaciente              = $rsPaciente->cpf_paciente;
$municipioPaciente        = $rsPaciente->nome_cidade;
$bairrroPaciente          = $rsPaciente->bairro_paciente;
$ibgeCidadePaciente       = $rsPaciente->codigocidade;
$cartoaSUSAutorizado      = $rsPaciente->cataosusdefora_autorizado;
# -- pegar numeros de telefome e informação de whatsapp -- #
$telefoneCelular1Whatsapp = $rsPaciente->celular1_whatsapp;
$telefoneCelular2Whatsapp = $rsPaciente->celular2_whatsapp;
$telefoneCelular3Whatsapp = $rsPaciente->celular3_whatsapp;
$telefoneCelular1         = $rsPaciente->celular1;
$telefoneCelular1         = str_replace("(", "", $telefoneCelular1);
$telefoneCelular1         = str_replace(")", "", $telefoneCelular1);
$telefoneCelular1         = str_replace(" ", "", $telefoneCelular1);
$telefoneCelular1         = "55" . str_replace("-", "", $telefoneCelular1);
$telefoneCelular2         = $rsPaciente->celular2;
$telefoneCelular2         = str_replace("(", "", $telefoneCelular2);
$telefoneCelular2         = str_replace(")", "", $telefoneCelular2);
$telefoneCelular2         = str_replace(" ", "", $telefoneCelular2);
$telefoneCelular2         = "55" . str_replace("-", "", $telefoneCelular2);
$telefoneCelular3         = $rsPaciente->celular3;
$telefoneCelular3         = str_replace("(", "", $telefoneCelular3);
$telefoneCelular3         = str_replace(")", "", $telefoneCelular3);
$telefoneCelular3         = str_replace(" ", "", $telefoneCelular3);
$telefoneCelular3         = "55" . str_replace("-", "", $telefoneCelular3);
$cataoSUSautorizado       = $rsPaciente->cataosusdefora_autorizado == "S"  ? " - AUTORIZADO" : "";
# -------------------------------------------------------- #

# -- dados de condições de saúde do paciente --#
$pacienteOncologico   = $rsPaciente->condicaosaude_oncolocia == "S" ? " checked" : "";
$pacienteDiabetico    = $rsPaciente->condicaosaude_diabetes == "S" ? " checked" : "";
$pacienteHipertenso   = $rsPaciente->condicaosaude_hipertensao == "S" ? " checked" : "";
$pacienteRenalCronico = $rsPaciente->condicaosaude_renalcronico == "S" ? " checked" : "";
$pacientePCD          = $rsPaciente->condicaosaude_pcd == "S" ? " checked" : "";
$descricaoDeficiencia = $rsPaciente->condicaosaude_pcddescricao;
$bloqueioDescricaoDef = $rsPaciente->condicaosaude_pcd == "S" ? "" : " disabled";
$pacienteAlergico     = $rsPaciente->condicaosaude_alergia == "S" ? " checked" : "";
$descricaoAlergia     = $rsPaciente->condicaosaude_alergiadescricao;
$bloqueioDescricaoAle = $rsPaciente->condicaosaude_alergia == "S" ? "" : " disabled";
# -------------------------------------------------------- #


//Cor alerta fora do município!
$ibgeSedeSistema = $_SESSION['ibgeSedeSistema'];
if ($ibgeCidadePaciente != $_SESSION['ibgeSedeSistema']) {
  $setCorCidade = "style='background-color:#ae0000 !important;color:#fff'";
  $nomeMunicipioSede    = $_SESSION['nomeMunicipioSede'];
} else {
  $setCorCidade         =  "";
  $nomeMunicipioSede    = "";
}

if(isset($_GET['idsol'])){

  $idSolicitacao    = $_GET['idsol'];
  $sqlSolicitacao  = "SELECT * FROM reg_tb_solicitacoes WHERE id_solicitacao='$idSolicitacao'";
  $stmSolicitacao  = $rsConexao->prepare($sqlSolicitacao);
  $stmSolicitacao->execute();
  $rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ);

  $numeroProtocolo        = $rsSolicitacao->numero_procotolo;
  $tokenSolicitacao       = $rsSolicitacao->token_solicitacao;
  $grupoProcedimento      = $rsSolicitacao->id_grupo_procedimento;
  $observacoesSolicitacao = $rsSolicitacao->observacoes_solicitacao;
  $idStatusSolicitacao    = $rsSolicitacao->id_statussolicitacao;
  $liberarBotao           = "";
  $observacoesAnalise     = $rsSolicitacao->observacoes_analise;
  $cidSolicitacao         = $rsSolicitacao->cid_solicitacao == "" ? "R69" : $rsSolicitacao->cid_solicitacao;
  $profissionalSolicitante  = $rsSolicitacao->codigoprofissional_cnes == "" ? "SELECIONE..." : $rsSolicitacao->codigoprofissional_cnes;
  $retornoSolicitacao       = $rsSolicitacao->solicitacao_retorno == "" ? "N" : $rsSolicitacao->solicitacao_retorno;
  $classificacaoRisco       = $rsSolicitacao->id_classificacaorisco;  

}else{
  $numeroProtocolo        = "-------";
  $cidSolicitacao         = "";
  $idSolicitacao          = "";
  $grupoProcedimento      = "";
  $observacoesSolicitacao = "";  
  $tokenSolicitacao       = strtoupper(substr(md5(uniqid(rand(), true)), 0, 20));
  $liberarBotao           = " disabled";
  $profissionalSolicitante  = "SELECIONE...";
  $idStatusSolicitacao    = "";
  $classificacaoRisco     = "";
}

$bloquearControles      = ($idStatusSolicitacao!=1 && $idStatusSolicitacao!=2) ? " disabled" : "";
$bloquearControlesStatus= ($idStatusSolicitacao!=1 && $idStatusSolicitacao!=2) ? " disabled" : "";
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-prescription" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Solicitação
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-dadosAgendamentos" data-toggle="tab" aria-controls="dadosAgendamentos" href="#dadosAgendamentos" aria-expanded="true"><b><i class='icofont icofont-files'></i> SOLICITAÇÕES EXISTENTES&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form" style='margin-top:-10px'>
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="sexoPaciente">Sexo:</label>
                                    <input type="text" id="sexoPaciente" class="form-control text-center" value="<?php echo $sexoPacienteExibir; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="municipioPaciente">Município:</label>
                                    <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $municipioPaciente . $cataoSUSautorizado; ?>" <?php echo $setCorCidade; ?> disabled>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="bairroPaciente">Bairro:</label>
                                    <input type="text" id="municipioPaciente" class="form-control" value="<?php echo $bairrroPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-10px; padding-left:10px; padding-right:10px">
                              <h4 class="form-section">
                                <i class="icofont icofont-pulse"></i><b>Condição de Saúde do Paciente</b>
                              </h4>
                              <div class="row">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <table style='width:100%'>
                                      <tr>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacienteOncologico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteOncologico; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:30px;'>
                                          <label for="pacienteOncologico" style='margin-top:-20px'>Oncologia</label>
                                        </td>
                                        <td width='10px'>&nbsp;</td>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacienteDiabetico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteDiabetico; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:30px;'>
                                          <label for="pacienteDiabetico" style='margin-top:-20px'>Diabetes</label>
                                        </td>
                                        <td width='10px'>&nbsp;</td>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacienteHipertenso" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteHipertenso; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:30px;'>
                                          <label for="pacienteHipertenso" style='margin-top:-20px'>Hipertensão</label>
                                        </td>
                                        <td width='10px'>&nbsp;</td>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacienteRenalCronico" class="form-control checkbox-seleciona-procedimento-grupo" <?php echo $pacienteRenalCronico; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:100px;'>
                                          <label for="pacienteRenalCronico" style='margin-top:-20px'>Renal Crônico</label>
                                        </td>
                                        <td width='10px'>&nbsp;</td>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacientePCD" class="form-control checkbox-seleciona-procedimento-grupo" onchange="habilitaDescricao('pcd',this.checked)" <?php echo $pacientePCD; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:30px;'>
                                          <label for="pacientePCD" style='margin-top:-20px'>PCD</label>
                                        </td>
                                        <td width='5px'>&nbsp;</td>
                                        <td>
                                          <input type="text" id="descricaoDeficiencia" class="form-control" placeholder="DESCREVA A(S) DEFICIÊNCIA(S)" <?php echo $bloqueioDescricaoDef; ?> value="<?php echo $descricaoDeficiencia; ?>">
                                        </td>
                                        <td width='10px'>&nbsp;</td>
                                        <td width='5px'>
                                          <input type="checkbox" id="pacienteAlergico" class="form-control checkbox-seleciona-procedimento-grupo" onchange="habilitaDescricao('alergia',this.checked)" <?php echo $pacienteAlergico; ?>>
                                        </td>
                                        <td style='padding-top:10px; width:30px;'>
                                          <label for="pacienteAlergico" style='margin-top:-20px'>Alergia</label>
                                        </td>
                                        <td width='5px'>&nbsp;</td>
                                        <td>
                                          <input type="text" id="descricaoAlergia" class="form-control" placeholder="DESCREVA A(S) ALERGIA(S)" <?php echo $bloqueioDescricaoAle; ?> value="<?php echo $descricaoAlergia; ?>">
                                        </td>
                                      </tr>
                                    </table>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                              <div class="row" style="margin-top:-10px;">
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="numeroProtocolo">Nº Protocolo:</label>
                                    <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                                    <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label for="profissionalSolicitante">Profissional Solicitante:</label>
                                    <select class="selectivity-input single-select-box" id="profissionalSolicitante" <?php echo $bloquearControles; ?> disabled>
                                      <option value="">SELECIONE...</option>
                                      <option value="<?php echo $ibgeSedeSistema . '0000000000'; ?>">PROFISSIONAL NÃO LISTADO (OU SOLICITAÇÃO EXTERNA)</option>
                                      <option value="<?php echo $ibgeSedeSistema . '0000000001'; ?>">PROFISSIONAL DA POLICLÍNICA REGIONAL</option>
                                      <?php
                                      $sqlProfissional = "SELECT tb_profissional.codigoprofissional_cnes,
                                      ucase(tb_profissional.nome_profissional) AS nomeProfissional,
                                      rl_cbo.codigo_cbo,
                                      ucase(rl_cbo.nome_cbo) AS nomeCBO
                                      FROM tb_profissional_vinculo
                                      INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
                                      INNER JOIN tb_profissional ON (tb_profissional_vinculo.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
                                      GROUP BY tb_profissional.codigoprofissional_cnes
                                      ORDER BY tb_profissional.nome_profissional ASC";
                                      $stmProfissional = $rsConexao->prepare($sqlProfissional);
                                      $stmProfissional->execute();
                                      if ($stmProfissional->rowCount() > 0) {
                                        $rsProfissional  = $stmProfissional->fetchAll(PDO::FETCH_ASSOC);
                                        foreach ($rsProfissional as $fieldProfissional) {
                                          $codigoProfissional = $fieldProfissional['codigoprofissional_cnes'];
                                          $nomeProfissional   = $fieldProfissional['nomeProfissional'];
                                          $nomeCBO            = $fieldProfissional['nomeCBO'];
                                          echo "<option value='$codigoProfissional'>$nomeProfissional - ( $nomeCBO )</option>";
                                        }
                                      }
                                      ?>
                                    </select>
                                    <input type="hidden" id="procedimentoSelecionado" class="form-control" />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cidSolicitacao">CID:</label>
                                    <input type="text" id="cidSolicitacao" class="form-control text-center" value="<?php echo $cidSolicitacao; ?>" <?php echo $bloquearControles; ?> />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="classificacaoPrioridade">Classificação:
                                      <i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover"
                                        data-content="Emergência (Prioridade Zero - Necessidade de atendimento imediato.)
                                    | Muito Urgente (Prioridade 1 - Atendimento o mais rápido possível.
                                    | Pouco Urgente (Prioridade 2 - Não urgente, porém prioritário.
                                    | Eletivo (Prioridade 3 - Atendimento eletivo. Respeitar fila.)"
                                        data-trigger="hover" data-original-title="Classificação de Risco"></i>
                                    </label>
                                    <select id="classificacaoPrioridade" class="form-control" <?php echo $bloquearControles; ?>>
                                      <option value=''>SELECIONE...</option>
                                      <?php
                                      $stmClassificacao = $rsConexao->prepare("SELECT * FROM reg_rl_classificacaorisco ORDER BY nome_classificacaorisco");
                                      $stmClassificacao->execute();
                                      $rsClassificacao  = $stmClassificacao->fetchAll(PDO::FETCH_ASSOC);

                                      foreach ($rsClassificacao as $fieldClassificacao) {
                                        $idClassificacao    = $fieldClassificacao['id_classificacaorisco'];
                                        $nomeClassificacao  = $fieldClassificacao['nome_classificacaorisco'];
                                        echo "<option value='$idClassificacao'>$nomeClassificacao</option>";
                                      }
                                      ?>
                                    </select>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacaoSolicitacao">Observação:</label>
                                    <input type="text" id="observacaoSolicitacao" class="form-control" value="<?php echo $observacoesSolicitacao; ?>" <?php echo $bloquearControles; ?> />
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="grupoProcedimento">Grupo:</label>
                                    <select class="form-control" id="grupoProcedimento">
                                      <option value="">SELECIONE...</option>
                                      <?php
                                      $stmGrupoProcedimento = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo  WHERE nome_grupo_procedimento!='NÃO AGRUPADOS' ORDER BY nome_grupo_procedimento");
                                      $stmGrupoProcedimento->execute();
                                      $rsGrupoProcedimento  = $stmGrupoProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                      foreach ($rsGrupoProcedimento as $fieldGrupoProcedimento) {
                                        $idGrupoProcedimento    = $fieldGrupoProcedimento['id_grupo_procedimento'];
                                        $nomeGrupoProcedimento  = $fieldGrupoProcedimento['nome_grupo_procedimento'];
                                        if (strpos($nomeGrupoProcedimento, "LABORAT") !== false) {
                                          echo "<option value='$idGrupoProcedimento'>GRUPO - $nomeGrupoProcedimento</option>";
                                        }
                                      }
                                      ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type='button' class='btn btn-blue' onClick="filtrarProcedimentos()" style='width: 112px'>
                                      <i class='icofont icofont icofont-list'></i>&nbsp;&nbsp;Listar
                                    </button>&nbsp;&nbsp;
                                    <button type='button' class='btn btn-danger' onClick="limparListaProcedimentos()" style='width: 140px'>
                                      <i class='icofont icofont-refresh'></i>&nbsp;&nbsp;Limpar Listas
                                    </button>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group" style='text-align:right;'>
                                    <label>&nbsp;</label><br>
                                    <table style='width:350px' align='right'>
                                      <tr>
                                        <td align='right'>
                                          <input type="text" class="form-control text-right form-control-novodisabled" id="totalProcedimentosSelecionados" value="Procedimentos selecionados: 0" disabled />
                                        </td>
                                      </tr>
                                    </table>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <hr style='margin-top:-12px; padding-top:5px'>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group" style='border-bottom: 2px gray dashed; line-height: 8px; padding:10px; padding-left:5px; background-color: #8af3d9;'>
                                    <b>PROCEDIMENTOS DISPONÍVEIS:</b>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="form-group" style='border-bottom: 2px gray dashed; line-height: 8px; padding:10px; padding-left:5px; background-color:rgb(111, 205, 252);'>
                                    <b>PROCEDIMENTOS SELECIONADOS:</b>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -15px;">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <select multiple="multiple" size="15" class="duallistbox-multi-selection" id='listaProcedimentosSolicitar' disabled>
                                    </select>
                                  </div>
                                </div>
                              </div>
                              <hr style='margin-top:-12px; padding-top:5px'>
                            </div>
                        </div>
                        <div class="tab-pane" id="dadosSolicitacao" aria-labelledby="base-dadosSolicitacao">
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="solicitacoes_existentes" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th style="text-align:center">DATA/HORA REGISTRO</th>
                                    <th>PROCEDIMENTO</th>
                                    <th>STATUS</th>
                                    <th>PROTOCOLO</th>
                                    <th>PRAZO RETIRADA</th>
                                    <th>REGISTRADO POR</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $sqlSolicitacoes = "SELECT reg_tb_solicitacoes.id_solicitacao, reg_tb_solicitacoes.numero_procotolo, reg_tb_procedimento.nome_procedimento, 
                                  date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y') AS dataHoraRegistro, date_format(reg_tb_solicitacoes.dataprazo_retirada,'%d/%m/%Y') AS dataPrazoRetirada, 
                                  reg_tb_solicitacoes.id_statussolicitacao, reg_rl_statussolicitacao.nome_statusslicitacao, reg_tb_usuario.nome_usuario, tb_estabelecimento.nfantasia_estabelecimento
                                  FROM reg_tb_solicitacoes
                                  INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes.id_usuario_cadastrou = reg_tb_usuario.id_usuario)
                                  INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
                                  INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao = reg_rl_statussolicitacao.id_statussolicitacao)
                                  INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_solicitacoes.id_unidade_cadastrou)
                                  WHERE reg_tb_solicitacoes.id_paciente='$idPaciente'";
                                  $stmSolicitacoes = $rsConexao->prepare($sqlSolicitacoes);
                                  $stmSolicitacoes->execute();
                                  if ($stmSolicitacoes->rowCount() > 0) {
                                    $rsSolicitacao  = $stmSolicitacoes->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsSolicitacao as $fieldSolicitacao) {
                                      $idSolicitacaoImprimir  = $fieldSolicitacao['id_solicitacao'];
                                      $dataHoraRegistro       = $fieldSolicitacao['dataHoraRegistro'];
                                      $nomeProcedimento       = $fieldSolicitacao['nome_procedimento'];
                                      $statusSolicitacao      = $fieldSolicitacao['nome_statusslicitacao'];
                                      $numeroProcotolo        = $fieldSolicitacao['numero_procotolo'];
                                      $dataPrazoRetirada      = $fieldSolicitacao['dataPrazoRetirada'] != "" ? $fieldSolicitacao['dataPrazoRetirada'] : "N/A";
                                      $registradoPor          = mb_strtoupper($fieldSolicitacao['nome_usuario'] . "<br>(" . $fieldSolicitacao['nfantasia_estabelecimento'] . ")");

                                      if ($fieldSolicitacao['id_statussolicitacao'] != 3) {
                                        $comandoImpressao       = 'onClick="window.open(' . "'imprimir_protocolo?idsol=$idSolicitacaoImprimir')" . '"';
                                        $botaoComandoImpressao  = "<i class='icofont icofont-print nova_fonte' title='Imprimir prococolo de solicitação.' $comandoImpressao></i>&nbsp;";
                                      } else {
                                        $botaoComandoImpressao  = "";
                                      }

                                      echo "<tr>
                                          <td align='center' style='width:10%'>$dataHoraRegistro</td>
                                          <td>$nomeProcedimento</td>
                                          <td>$statusSolicitacao</td>
                                          <td align='center'>$numeroProcotolo&nbsp;$botaoComandoImpressao</td>
                                          <td align='center' style='width:10%'>$dataPrazoRetirada</td>
                                          <td>$registradoPor</td>
                                        </tr>";
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante" style='left: 38.5%;'>
  <button type="button" class="btn btn-blue" id="btnConfirmarSolicitacao" onClick="gravarSolicitacao()" <?php echo $liberarBotao . $bloquearControlesStatus; ?>>
    <i class="fa fa-check-square-o"></i> Confirmar
  </button>
  <button type="button" class="btn btn-dark" id="imprimirProtocolo" onClick="imprimirProtocolo()" <?php echo $liberarBotao . $bloquearControlesStatus; ?>>
    <i class="icofont icofont-printer"></i> Protocolo
  </button>
  <button type='button' class='btn btn-green' onClick="novaSolicitacao()">
    <i class='icofont icofont icofont-medical'></i>&nbsp;Nova Solicitação
  </button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.location.href='solicitacao_consultar?op=sc'">
    <i class="ft-log-out botaoOk"></i> Fechar
  </button>  
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liLaboratorioCadastrarSolicitacao").attr('class', 'active');
  $("#liLaboratorioCadastrarSolicitacao").css("border-bottom", "2px solid #c4c8ca");

  $('#solicitacoes_existentes').DataTable({
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function filtrarProcedimentos(opcaoFiltro=null) {

    var listaProcedimentosSolicitar = $('#listaProcedimentosSolicitar');

    if ($("#grupoProcedimento").val() == "") {
      swal("Grupo de Procedimentos", "Selecione o grupo de procedimentos.", "error");
      return false;
    }
    if(opcaoFiltro==null){
      $("#embacado").css("display", "block");
    }
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'laboratorio-solicitar',
        'grupoProcedimento': $("#grupoProcedimento").val()
      }
    }).done(function(resultadoRetorno) {
      listaProcedimentosSolicitar.empty(), listaProcedimentosSolicitar.bootstrapDualListbox("refresh", !0);
      listaProcedimentosSolicitar.append(resultadoRetorno), listaProcedimentosSolicitar.bootstrapDualListbox("refresh", !0);
      $("#embacado").css("display", "none");
    });

  }

  function limparListaProcedimentos() {
    var listaProcedimentosSolicitar = $('#listaProcedimentosSolicitar');
    listaProcedimentosSolicitar.empty(), listaProcedimentosSolicitar.bootstrapDualListbox("refresh", !0);
  }

  function gravarSolicitacao() {


    const listaProcedimentosSolicitar = document.getElementById('listaProcedimentosSolicitar');
    const procedimentoSelecionado = [];
    for (let contarLinhas = 0; contarLinhas < listaProcedimentosSolicitar.options.length; contarLinhas++) {
      const tagOption = listaProcedimentosSolicitar.options[contarLinhas];
      // Verifica se a opção está selecionada
      if (tagOption.selected) {
        procedimentoSelecionado.push(tagOption.value); // Adiciona o valor da opção
      }
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_solicitacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoGravacao': 'solicitacao-laboratorio',
        'idPaciente': $("#idPaciente").val(),
        'idSolicitacao': $("#idSolicitacao").val(),
        'numeroProtocolo': $("#numeroProtocolo").val(),
        'observacaoSolicitacao': $("#observacaoSolicitacao").val(),
        'tokenSolicitacao': "<?php echo $tokenSolicitacao; ?>",
        'cidSolicitacao': $("#cidSolicitacao").val(),
        'profissionalSolicitante': $("#profissionalSolicitante").selectivity("value"),
        'classificacaoPrioridade': $("#classificacaoPrioridade").val(),
        'pacienteOncologico': document.getElementById('pacienteOncologico').checked == true ? "S" : "N",
        'pacienteDiabetico': document.getElementById('pacienteDiabetico').checked == true ? "S" : "N",
        'pacienteHipertenso': document.getElementById('pacienteHipertenso').checked == true ? "S" : "N",
        'pacienteRenalCronico': document.getElementById('pacienteRenalCronico').checked == true ? "S" : "N",
        'pacientePCD': document.getElementById('pacientePCD').checked == true ? "S" : "N",
        'pacienteAlergico': document.getElementById('pacienteAlergico').checked == true ? "S" : "N",
        'descricaoDeficiencia': $("#descricaoDeficiencia").val(),
        'descricaoAlergia': $("#descricaoAlergia").val(),
        'grupoProcedimento': $("#grupoProcedimento").val(),
        'procedimentoSelecionado': procedimentoSelecionado
      }
    }).done(function(resultadoRetorno) {
      if (resultadoRetorno == "JáExiste") {
        $("#embacado").css("display", "none");
        swal("Solicitação Duplicada", "Já existe um registro de solicitação de laboratório pendente de agendamento. Você pode alterar a solicitação anterior e incluir novos procedimentos.", "error");
        return false;
      }
      retornoResultado = resultadoRetorno.split("##");
      $("#idSolicitacao").val(retornoResultado[0]);
      $("#numeroProtocolo").val(retornoResultado[1]);
      $("#imprimirProtocolo").prop('disabled', false);
      $("#embacado").css("display", "none");
      swal("Cadastro de Solicitação", "Solicitação cadastrada com sucesso.", "success");
    });
  }

  $("#grupoProcedimento").change(function() {
    limparListaProcedimentos();
  });

  $("#listaProcedimentosSolicitar").change(function() {

    const listaProcedimentosSolicitar = document.getElementById('listaProcedimentosSolicitar');
    var totalSelecionado = 0;
    $('#listaProcedimentosSolicitar option:selected').each(function() {
      totalSelecionado = totalSelecionado + 1;
    });

    var idStatusSolicitacao = "<?php echo $idStatusSolicitacao;?>";
    if (totalSelecionado == 0) {
      $("#btnConfirmarSolicitacao").prop("disabled", true);
      $("#imprimirProtocolo").prop("disabled", true);
    } else {
      if(idStatusSolicitacao==1 || idStatusSolicitacao==2){
        $("#btnConfirmarSolicitacao").prop("disabled", false);
        $("#imprimirProtocolo").prop("disabled", false);
      }
    }

    $("#totalProcedimentosSelecionados").val("Procedimentos selecionados: " + totalSelecionado);
  });


  function novaSolicitacao() {

    swal({

      title: "Cadastrar Nova Solicitação",
      text: "Informe se a nova solicitação é para o mesmo paciente ou para outro paciente!",
      icon: "warning",

      buttons: {
        confirm: {
          text: "MESMO PACIENTE",
          value: true,
          visible: true,
          className: "btn-blue",
          closeModal: false
        },
        cancel: {
          text: "OUTRO PACIENTE",
          value: null,
          visible: true,
          className: "btn-green",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        window.location.href = "solicitacao_laboratorio?idpac=<?php echo $idPaciente; ?>&op=csl";
      } else {
        window.location.href = "paciente_buscar?op=csl";
      }

    });

  }

  function habilitaDescricao(opcaoDescricao, valorAssinalado) {

    switch (opcaoDescricao) {
      case "pcd":
        if (valorAssinalado == true) {
          $("#descricaoDeficiencia").prop("disabled", false);
        } else {
          $("#descricaoDeficiencia").prop("disabled", true);
          $("#descricaoDeficiencia").val('');
        }
        break;
      case "alergia":
        if (valorAssinalado == true) {
          $("#descricaoAlergia").prop("disabled", false);
        } else {
          $("#descricaoAlergia").prop("disabled", true);
          $("#descricaoAlergia").val('');
        }
        break;
    }
  }

  /* carregar dados em visualização */
  var idSolicitacao = "<?php echo $idSolicitacao;?>";
  var listaProcedimentosSolicitar = $('#listaProcedimentosSolicitar');  
  if(idSolicitacao!=""){
    $("#grupoProcedimento").val("<?php echo $grupoProcedimento;?>");
    setTimeout(function() {
      $("#profissionalSolicitante").selectivity('value', '<?php echo $profissionalSolicitante; ?>');
    }, 500);

    /* carregar procedimentos para edição na lista */
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'laboratorio-solicitar-visualizar',
        'idSolicitacao' : idSolicitacao,
        'idGrupoProcedimento': "<?php echo $grupoProcedimento;?>"
      }
    }).done(function(resultadoRetorno) {
      listaProcedimentosSolicitar.empty(), listaProcedimentosSolicitar.bootstrapDualListbox("refresh", !0);
      listaProcedimentosSolicitar.append(resultadoRetorno), listaProcedimentosSolicitar.bootstrapDualListbox("refresh", !0);
    });
    
    $("#classificacaoPrioridade").val("<?php echo $classificacaoRisco;?>");

    setTimeout(function() {
      var totalSelecionado = 0;
      $('#listaProcedimentosSolicitar option:selected').each(function() {
        totalSelecionado = totalSelecionado + 1;
      });    
      $("#totalProcedimentosSelecionados").val("Procedimentos selecionados: " + totalSelecionado); 
    }, 1000);
  }

  var idStatusSolicitacao = "<?php echo $idStatusSolicitacao;?>";
  if(idStatusSolicitacao!=1 && idStatusSolicitacao!=2 && idStatusSolicitacao!=""){
    swal('Alteração Bloqueada', "O status atual desta solicitação não permite alterações.", 'error');
  }
</script>