<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");
$idUsuario  = $_GET['idu'];

$stmDadosUsuario  =  $rsConexao->prepare("SELECT * FROM reg_tb_usuario WHERE id_usuario='$idUsuario'");
$stmDadosUsuario->execute();
$rsDadosUsuario    = $stmDadosUsuario->fetch(PDO::FETCH_OBJ);
$nomeUsuario      = $rsDadosUsuario->nome_usuario;
$cpfUsuario        = $rsDadosUsuario->cpf_usuario;
$emailUsuario      = $rsDadosUsuario->email_usuario;
$telefoneUsuario  = $rsDadosUsuario->fonecelular;
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-id-card" style='margin-top:-15px !important'></i>&nbsp;Atribuir Perfil de Acesso
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="ft-user"></i>
                      <b>Dados do Usuário</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomeUsuario">Nome do Usuário:</label>
                          <input type="text" id="nomeUsuario" class="form-control" value="<?php echo $nomeUsuario; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cpfUsuario">CPF do Usuário:</label>
                          <input type="text" id="cpfUsuario" class="form-control text-center cpf-inputmask" value="<?php echo $cpfUsuario; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="emailUsuario">Email do Usuário:</label>
                          <input type="text" id="emailUsuario" class="form-control text-lowercase" value="<?php echo $emailUsuario; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="telefoneUsuario">Telefone do Usuário:</label>
                          <input type="text" id="telefoneUsuario" class="form-control text-center" value="<?php echo $telefoneUsuario; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="municipioUsuario">Município:</label>
                          <select id="municipioUsuario" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <?php
                            # -- pega município sede -- #
                            $sqlMunicipioSede = "SELECT reg_tb_configuracoes.ibge_municipiogestor,
															tb_cidades.nome_cidade,
															tb_cidades.sigla_estado
															FROM tb_cidades
															INNER JOIN reg_tb_configuracoes ON (tb_cidades.codigoibge_cidade = reg_tb_configuracoes.ibge_municipiogestor)";
                            $stmMunicipioSede  = $rsConexao->prepare($sqlMunicipioSede);
                            $stmMunicipioSede->execute();
                            $rsMunicipioSede  = $stmMunicipioSede->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($rsMunicipioSede as $fiedMunicipioSede) {
                              $idMuicipio    = $fiedMunicipioSede['ibge_municipiogestor'];
                              $nomeMuicipio  = $fiedMunicipioSede['nome_cidade'] . '-' . $fiedMunicipioSede['sigla_estado'];
                              echo "<option value='$idMuicipio'>$nomeMuicipio</option>";
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="unidadeRelacionada">Unidade Relacionada:</label>
                          <select type="text" id="unidadeRelacionada" class="form-control">
                            <option value="">SELECIONE...</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="perfilAcesso">Perfil de Acesso:</label>
                          <select type="text" id="perfilAcesso" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <?php
                            $sqlPefil    = "SELECT * FROM reg_rl_usuario_perfil WHERE (id_usuario_perfil!=10) AND (status_perfil='A') ORDER BY descricao_usuario_perfil";
                            $stmPerfil  = $rsConexao->prepare($sqlPefil);
                            $stmPerfil->execute();
                            $rsPerfil    = $stmPerfil->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($rsPerfil as $fieldPerfil) {
                              $idPerfil   = $fieldPerfil['id_usuario_perfil'];
                              $nomePerfil  = $fieldPerfil['descricao_usuario_perfil'];
                              echo "<option value='$idPerfil'>$nomePerfil</option>";
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="verVagasDisponiveis">Ver Vagas Disponíveis:</label>
                          <select type="text" id="verVagasDisponiveis" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='S'>SIM</option>
                            <option value='N'>NÃO</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="agendaVisivel">Agenda Visível:</label>
                          <select type="text" id="agendaVisivel" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='G'>GERAL</option>
                            <option value='L'>LOCAL</option>
                          </select>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top:-10px;">
                    <div class="col-md-12">
                      <div class="form-group">
                        <button type="button" class="btn btn-blue" onClick="salvarPerfil()"><i class="icofont icofont-checked"></i> Confirmar</button>
                        <button type="button" class="btn btn-danger" id="btnCancelar" disabled><i class="fa fa-times"></i> Cancelar</button>
                      </div>
                    </div>
                  </div>
                  <hr style='margin-top:-10px'>
                  <div class="row" style="margin-top:-15px;">
                    <div class="col-md-12">
                      <div class="form-group">
                        <input type="hidden" id="idUsuarioPerfil" class="form-control" disabled />
                        <table class="table table-striped table-bordered default-ordering" id="dados_perfil" style="font-size: 9pt !important;">
                          <thead>
                            <tr style="background-repeat: repeat-x; height: 30px !important;">
                              <th style="text-align: center; width:10%">OPÇÕES</th>
                              <th>MUNICÍPIO DE VÍNCULO</th>
                              <th>NOME DA UNIDADE RELACIONADA</th>
                              <th style='width:20%'>NOME DO PERFIL DE ACESSO</th>
                              <th style='width:12%'>VER VAGAS DISPONÍVEIS</th>
                              <th style='width:10%'>AGENDA VISÍVEL</th>
                            </tr>
                          </thead>
                          <tbody style="background-color: #f6f6f6;">
                            <?php
                            $sqlPerfilAcesso = "SELECT reg_tb_usuario_perfil.id_usuarioperfil,
																reg_rl_usuario_perfil.id_usuario_perfil,
																reg_rl_usuario_perfil.descricao_usuario_perfil,
																tb_estabelecimento.codigoestabelecimento_cnes,
																tb_estabelecimento.nfantasia_estabelecimento,
																tb_estabelecimento.cnes_estabelecimento,
																reg_tb_usuario_perfil.ibge_municipioacesso,
																reg_tb_usuario_perfil.visualiza_vagasdisponiveis,
                                CASE
                                  WHEN (reg_tb_usuario_perfil.agenda_visivel='' OR reg_tb_usuario_perfil.agenda_visivel IS NULL) THEN 'N/A'
                                  WHEN (reg_tb_usuario_perfil.agenda_visivel='G') THEN 'GERAL'
                                  WHEN (reg_tb_usuario_perfil.agenda_visivel='L') THEN 'LOCAL'
                                END AS agendaVisivel,
                                reg_tb_usuario_perfil.agenda_visivel,
																tb_cidades.nome_cidade
																FROM reg_tb_usuario_perfil
																INNER JOIN reg_rl_usuario_perfil ON (reg_tb_usuario_perfil.id_pefilusuario = reg_rl_usuario_perfil.id_usuario_perfil)
																INNER JOIN tb_cidades ON (reg_tb_usuario_perfil.ibge_municipioacesso = tb_cidades.codigoibge_cidade)
																INNER JOIN reg_tb_usuario ON (reg_tb_usuario_perfil.id_usuario = reg_tb_usuario.id_usuario)
																INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_usuario_perfil.id_unidadeassociada)
																WHERE reg_tb_usuario.id_usuario='$idUsuario'";
                            $stmPerfilAcesso  = $rsConexao->prepare($sqlPerfilAcesso);
                            $stmPerfilAcesso->execute();
                            if ($stmPerfilAcesso->rowCount() > 0) {
                              $rsPerfilAcesso  = $stmPerfilAcesso->fetchAll(PDO::FETCH_ASSOC);
                              foreach ($rsPerfilAcesso as $fieldPerfilAcesso) {
                                $idPerfilAcesso    = $fieldPerfilAcesso['id_usuario_perfil'];
                                $idUsuarioPerfil  = $fieldPerfilAcesso['id_usuarioperfil'];
                                $nomePerfilAcesso  = mb_strtoupper($fieldPerfilAcesso['descricao_usuario_perfil']);
                                $nomeUnidadeSaude  = mb_strtoupper($fieldPerfilAcesso['nfantasia_estabelecimento']);
                                $cnesUnidadeSaude  = $fieldPerfilAcesso['cnes_estabelecimento'];
                                $idUnidade        = $fieldPerfilAcesso['codigoestabelecimento_cnes'];
                                $codigoCidade      = $fieldPerfilAcesso['ibge_municipioacesso'];
                                $nomeCidade        = $fieldPerfilAcesso['nome_cidade'];
                                $vagaDisponivel    = $fieldPerfilAcesso['visualiza_vagasdisponiveis'];
                                $verVagaDisponivel  = ($idPerfilAcesso != 4 && $idPerfilAcesso != 17 && $idPerfilAcesso != 19) ? "N/A" : ($fieldPerfilAcesso['visualiza_vagasdisponiveis'] == "S" ? "SIM" : "NÃO");
                                $agendaVisivel   = $fieldPerfilAcesso['agendaVisivel'];
                                $agendaVisivelEdit  = $fieldPerfilAcesso['agenda_visivel'];

                                $linkEditarPerfil    = '"editarPerfil(' . "'$idUsuarioPerfil','$codigoCidade','$idUnidade','$idPerfilAcesso','$vagaDisponivel','$agendaVisivelEdit')" . '"';
                                $linkExcluirPerfil  = '"excluirPerfil(' . "'$idUsuarioPerfil')" . '"';

                                echo "<tr>
																			<td align='center'>
																				<i class='icofont icofont-edit nova_fonte' title='Editar dados do perfil de acesso.' onclick=$linkEditarPerfil></i>&nbsp;
																				<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir perfil de acesso.' onclick=$linkExcluirPerfil></i>
																			</td>
																			<td>$nomeCidade</td>
																			<td>$cnesUnidadeSaude - $nomeUnidadeSaude</td>
																			<td>$nomePerfilAcesso</td>
																			<td align='center'>$verVagaDisponivel</td>
                                      <td align='center'>$agendaVisivel</td>
																		</tr>";
                              }
                            }
                            ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
              </div>
              </form>
            </div>
          </div>
        </div>
      </div>
  </div>
  </section>
</div>
</div>
<div class="barra-flutuante">
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>

  $("#municipioUsuario").change(function() {

    $.ajax({
      url: 'filtros/filtrar_unidadesaude',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoFiltro': 'perfil-acesso',
        'idUnidade': this.value
      }
    }).done(function(resultadoRetorno) {
      $('#unidadeRelacionada').html(resultadoRetorno);
    });

  });

  function editarPerfil(idUsuarioPerfil, codigoCidade, idUnidade, idPerfilAcesso, verVagasDisponiveis, agendaVisivel) {
    $("#embacado").css("display", 'block');
    $("#idUsuarioPerfil").val(idUsuarioPerfil);
    $("#municipioUsuario").val(codigoCidade);
    $("#municipioUsuario").trigger('change');
    $("#perfilAcesso").val(idPerfilAcesso);
    $("#verVagasDisponiveis").val(verVagasDisponiveis);
    $("#agendaVisivel").val(agendaVisivel);
    $("#btnCancelar").prop("disabled", false);

    if (idPerfilAcesso != 4 && idPerfilAcesso != 17 && idPerfilAcesso != 19) {
      $("#verVagasDisponiveis").prop('disabled', true);
    } else {
      $("#verVagasDisponiveis").prop('disabled', false);
    }

    if (idPerfilAcesso == 4 || idPerfilAcesso == 17) {
      $("#agendaVisivel").prop('disabled', false);
    } else {
      $("#agendaVisivel").prop('disabled', true);
    }

    setTimeout(function() {
      $("#unidadeRelacionada").val(idUnidade);
      $("#embacado").css("display", 'none');
    }, 1000);
  }

  $("#btnCancelar").click(function() {
    $("#btnCancelar").prop("disabled", false);
    $("#idUsuarioPerfil").val('');
    $("#municipioUsuario").val('');
    $("#municipioUsuario").trigger('change');
    $("#unidadeRelacionada").val('');
    $("#perfilAcesso").val('');
    $("#verVagasDisponiveis").prop('disabled', false);
    $("#verVagasDisponiveis").val('');
    $("#agendaVisivel").prop('disabled', false);
    $("#agendaVisivel").val('');
  });


  $("#perfilAcesso").change(function() {
    if (this.value != 4 && this.value != 17 && this.value != 19) {
      $("#verVagasDisponiveis").prop('disabled', true);
      $("#verVagasDisponiveis").val('');
    } else {
      $("#verVagasDisponiveis").prop('disabled', false);
    }
  
    $("#agendaVisivel").val('');
    if (this.value == 4 || this.value == 17) {
      $("#agendaVisivel").prop('disabled', false);      
    } else {
      $("#agendaVisivel").prop('disabled', true);
    }

  })

  function excluirPerfil(idPerfilAcesso) {

    Swal.fire({
      title: "Exclusão de Perfil",
      html: "<p style='text-align:justify'>O perfil selecionado será excluído. O usuário não poderá acessar mais este perfil. Confirma?</p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'perfil-acesso',
            'idUsuario': "<?php echo $idUsuario; ?>",
            'idRegistroExclusao': idPerfilAcesso
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          swal("Exclusão de Perfil.", "Perfil de acesso excluído com sucesso.", "success");          
          $('#dados_perfil').DataTable().destroy();
          $('#dados_perfil tbody').empty().append(resultadoRetorno);
          $('#dados_perfil').DataTable();
          $("#btnCancelar").prop("disabled", true);

          $("#municipioUsuario").val('');
          $("#municipioUsuario").trigger('change');
          $("#idUsuarioPerfil").val('');
          $("#perfilAcesso").val('');
          $("#btnCancelar").prop("disabled", false);
        });
      }
    });

  }

  function salvarPerfil() {

    if ($("#municipioUsuario").val() == "" || $("#unidadeRelacionada").val() == "" || $("#perfilAcesso").val() == "") {
      swal("Dados Obrigatórios.", "Você deve selecionar o perfil e a unidade relacionada.", "error");
      return false;
    }

    if ($("#perfilAcesso").val() == "4" && $("#agendaVisivel").val() == "") {
      swal("Agenda Visível.", "Você deve selecionar o tipo de visualização de agenda.", "error");
      return false;
    }    

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_usuario_perfil',
      type: 'post',
      dataType: 'html',
      data: {
        'idUsuarioPerfil': $("#idUsuarioPerfil").val(),
        'idUsuario': "<?php echo $idUsuario; ?>",
        'municipioUsuario': $("#municipioUsuario").val(),
        'unidadeRelacionada': $("#unidadeRelacionada").val(),
        'idPerfilAcesso': $("#perfilAcesso").val(),
        'verVagasDisponiveis': $("#verVagasDisponiveis").val(),
        "agendaVisivel" : $("#agendaVisivel").val(),
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno == "jáExiste") {
        swal("Cadastro Duplicado.", "Perfil já cadastrado para este usuário na unidade selecionada.", "error");
        return false;
      }
      $('#dados_perfil').DataTable().destroy();
      $('#dados_perfil tbody').empty().append(resultadoRetorno);
      $('#dados_perfil').DataTable();
      $("#btnCancelar").prop("disabled", true);
      $("#embacado").css("display", "none");
      swal("Cadastro de Perfil.", "Perfil de acesso cadastrado com sucesso.", "success");

      $("#idUsuarioPerfil").val('');
      $("#municipioUsuario").val('');
      $("#municipioUsuario").trigger('change');
      $("#unidadeRelacionada").val('');
      $("#perfilAcesso").val('');
      $("#verVagasDisponiveis").val('');
      $("#agendaVisivel").val('');
    });

  }
</script>