<?php
require("../../database/dbConection.php");

if (isset($_POST['seletorDadosGrafico'])) {

  switch ($_POST['seletorDadosGrafico']) {
    case "linha-15dias-entregues-cancelados":
      $sqlEntregeCancelado = "SELECT 
        CASE 
          WHEN DAYOFWEEK(dataEntrega) = 1 THEN CONCAT('Dom (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 2 THEN CONCAT('Seg (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 3 THEN CONCAT('Ter (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 4 THEN CONCAT('Qua (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 5 THEN CONCAT('Qui (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 6 THEN CONCAT('Sex (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataEntrega) = 7 THEN CONCAT('Sáb (', DATE_FORMAT(dataEntrega, '%d/%m'), ')')
          END AS diaSemanaEntrega,
          IFNULL(SUM(totalRegistroEntrega), 0) AS totalRegistroEntrega,
          IFNULL(SUM(totalRegistroCancelado), 0) AS totalRegistroCancelado
          FROM (
            -- Entregues
            SELECT 
              DATE(tabelaAgendamentos.datahora_entrega) AS dataEntrega,
              COUNT(*) AS totalRegistroEntrega,
              0 AS totalRegistroCancelado
            FROM 
              reg_tb_agendamentos tabelaAgendamentos
            WHERE 
              tabelaAgendamentos.datahora_entrega >= DATE_SUB(NOW(), INTERVAL 30 DAY)
            GROUP BY 
            DATE(tabelaAgendamentos.datahora_entrega)

            UNION ALL
            -- Cancelamento
            SELECT 
              DATE(tabelaAgendamentos2.datahora_cancelamento) AS dataCancelamento,
              0 AS totalRegistroEntrega,
              COUNT(*) AS totalRegistroCancelado
            FROM 
              reg_tb_agendamentos tabelaAgendamentos2
            WHERE 
              tabelaAgendamentos2.datahora_cancelamento >= DATE_SUB(NOW(), INTERVAL 30 DAY) AND tabelaAgendamentos2.status_agendamento = 'C'
            GROUP BY 
              DATE(tabelaAgendamentos2.datahora_cancelamento)
          ) AS dados
          GROUP BY 
            dataEntrega
          ORDER BY 
          dataEntrega ASC";

      $stmEntregeCancelado  = $rsConexao->prepare($sqlEntregeCancelado);
      $stmEntregeCancelado->execute();
      $rsEntregeCancelado   = $stmEntregeCancelado->fetchAll(PDO::FETCH_ASSOC);
      echo json_encode([
        'dadosEntregeCancelado' => $rsEntregeCancelado
      ]);

      break;

    case "linha-12meses-solicitacoes-agendamentos":
      $sqlSolicitacaoAgengamento = "SELECT 
        CASE 
            WHEN MONTH(data_solicitacao) = 1 THEN CONCAT('Jan/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 2 THEN CONCAT('Fev/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 3 THEN CONCAT('Mar/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 4 THEN CONCAT('Abr/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 5 THEN CONCAT('Mai/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 6 THEN CONCAT('Jun/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 7 THEN CONCAT('Jul/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 8 THEN CONCAT('Ago/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 9 THEN CONCAT('Set/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 10 THEN CONCAT('Out/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 11 THEN CONCAT('Nov/', DATE_FORMAT(data_solicitacao, '%Y'))
            WHEN MONTH(data_solicitacao) = 12 THEN CONCAT('Dez/', DATE_FORMAT(data_solicitacao, '%Y'))
          END AS mesSolicitacao,
          IFNULL(SUM(totalSolicitacoes), 0) AS totalRegistroSolicitacoes,
          IFNULL(SUM(totalAgendamentos), 0) AS totalRegistroAgendamentos
          FROM (
              -- Solicitações
              SELECT 
                  DATE(tbSolicitacoes.datahora_cadastro) AS data_solicitacao,
                  COUNT(*) AS totalSolicitacoes,
                  0 AS totalAgendamentos
              FROM reg_tb_solicitacoes tbSolicitacoes
              WHERE tbSolicitacoes.datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
              AND (tbSolicitacoes.id_procedimento!=350)
              GROUP BY DATE(tbSolicitacoes.datahora_cadastro)

              UNION ALL

              -- Agendamentos
              SELECT DATE(tb_Agendamentos.datahora_agendamento) AS data_solicitacao,
                  0 AS totalSolicitacoes,
                  COUNT(*) AS totalAgendamentos
              FROM 
                  reg_tb_agendamentos tb_Agendamentos
              WHERE tb_Agendamentos.datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
              AND (status_agendamento='P' OR status_agendamento='V')
              GROUP BY DATE(tb_Agendamentos.datahora_agendamento)
          ) AS dados
            GROUP BY YEAR(data_solicitacao), MONTH(data_solicitacao)
            ORDER BY data_solicitacao ASC";

      $stmSolicitacaoAgendamento  = $rsConexao->prepare($sqlSolicitacaoAgengamento);
      $stmSolicitacaoAgendamento->execute();
      $rsSolicitacaoAgendamento   = $stmSolicitacaoAgendamento->fetchAll(PDO::FETCH_ASSOC);
      echo json_encode([
        'dadosSolicitacaoAgendamento' => $rsSolicitacaoAgendamento
      ]);
      break;

    case "linha-12meses-agendamento-absenteismo":
      $sqlAgengamentoAbsenteismo = "SELECT 
        CASE 
            WHEN MONTH(data_atendimento) = 1 THEN CONCAT('Jan/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 2 THEN CONCAT('Fev/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 3 THEN CONCAT('Mar/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 4 THEN CONCAT('Abr/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 5 THEN CONCAT('Mai/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 6 THEN CONCAT('Jun/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 7 THEN CONCAT('Jul/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 8 THEN CONCAT('Ago/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 9 THEN CONCAT('Set/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 10 THEN CONCAT('Out/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 11 THEN CONCAT('Nov/', DATE_FORMAT(data_atendimento, '%Y'))
            WHEN MONTH(data_atendimento) = 12 THEN CONCAT('Dez/', DATE_FORMAT(data_atendimento, '%Y'))
          END AS mesAtendimento,
          IFNULL(SUM(totalAgendamentos), 0) AS totalRegistroAgendamentos,
          IFNULL(SUM(totalAbsenteismo), 0) AS totalRegistroAbsenteismo
          
          FROM (
              -- Agentamentos
              SELECT 
                DATE(tbAgendamentos_Ag.data_atendimento) AS data_atendimento,
                COUNT(*) AS totalAgendamentos,
                0 AS totalAbsenteismo
              FROM reg_tb_agendamentos tbAgendamentos_Ag
              WHERE tbAgendamentos_Ag.data_atendimento >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
              AND (status_agendamento='P' OR status_agendamento='V')
              AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
              GROUP BY DATE(tbAgendamentos_Ag.data_atendimento)
              
              UNION ALL

              -- Absenteísmo
              SELECT DATE(tbAgendamentos_Ab.data_atendimento) AS data_absenteismo,
                0 AS totalAgendamentos,
                COUNT(*) AS totalAbsenteismo
              FROM 
                  reg_tb_agendamentos tbAgendamentos_Ab
              WHERE tbAgendamentos_Ab.data_atendimento >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
              AND (status_agendamento='P')
              AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
              GROUP BY DATE(tbAgendamentos_Ab.data_atendimento)
          ) AS dados
            GROUP BY YEAR(data_atendimento), MONTH(data_atendimento)
            ORDER BY data_atendimento ASC";

      $stmAgengamentoAbsenteismo  = $rsConexao->prepare($sqlAgengamentoAbsenteismo);
      $stmAgengamentoAbsenteismo->execute();
      $rsAgengamentoAbsenteismo   = $stmAgengamentoAbsenteismo->fetchAll(PDO::FETCH_ASSOC);
      echo json_encode([
        'dadosAgendamentoAbsenteismo' => $rsAgengamentoAbsenteismo
      ]);
      break;

    case "linha-15dias-solicitacoes":
      $sqlRegistroSolicitacoes = "SELECT 
        CASE 
          WHEN DAYOFWEEK(dataSolicitacao) = 1 THEN CONCAT('Dom (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 2 THEN CONCAT('Seg (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 3 THEN CONCAT('Ter (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 4 THEN CONCAT('Qua (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 5 THEN CONCAT('Qui (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 6 THEN CONCAT('Sex (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          WHEN DAYOFWEEK(dataSolicitacao) = 7 THEN CONCAT('Sáb (', DATE_FORMAT(dataSolicitacao, '%d/%m'), ')')
          END AS diaSemanaSoliciatacao,
          IFNULL(SUM(totalRegistroSolicitacoes), 0) AS totalRegistroSolicitacoes
          FROM (
            SELECT 
              DATE(tabelaSolicitacoes.datahora_cadastro) AS dataSolicitacao,
              COUNT(*) AS totalRegistroSolicitacoes,
              0 AS totalRegistroSolicitacao
            FROM 
              reg_tb_solicitacoes tabelaSolicitacoes
            WHERE 
              tabelaSolicitacoes.datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 30 DAY)
              AND (tabelaSolicitacoes.id_procedimento!=350)
              AND (DAYOFWEEK(tabelaSolicitacoes.datahora_cadastro)!=1)
              AND (DAYOFWEEK(tabelaSolicitacoes.datahora_cadastro)!=7)              
            GROUP BY 
            DATE(tabelaSolicitacoes.datahora_cadastro)
          ) AS dados
          GROUP BY 
            dataSolicitacao
          ORDER BY 
          dataSolicitacao ASC";

      $stmRegistroSolicitacoes  = $rsConexao->prepare($sqlRegistroSolicitacoes);
      $stmRegistroSolicitacoes->execute();
      $rsRegistroSolicitacoes   = $stmRegistroSolicitacoes->fetchAll(PDO::FETCH_ASSOC);
      echo json_encode([
        'dadosRegistroSolicitacoes' => $rsRegistroSolicitacoes
      ]);

      break;
  }
} else {
  $curDateHoje = "CURDATE()";

  try {

    # -- gráfico hoje -- #
    $sqlDadosHoje = "SELECT 
    (SELECT COUNT(*) 
     FROM reg_tb_solicitacoes 
     WHERE date_format(datahora_cadastro,'%Y-%m-%d')=$curDateHoje) AS totalSolicitacoesHoje,   
 
    (SELECT COUNT(*) 
     FROM reg_tb_solicitacoes
     WHERE date_format(datahora_cancelamento,'%Y-%m-%d')=$curDateHoje)
     AS totalCancelamentoHoje,
    
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE date_format(datahora_agendamento,'%Y-%m-%d')=$curDateHoje 
     AND (status_agendamento = 'A' OR status_agendamento = 'E')
     AND (id_solicitacao IS NOT NULL)) AS totalAgendadoFilaHoje,
    
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE date_format(datahora_agendamento,'%Y-%m-%d')=$curDateHoje
     AND (status_agendamento = 'A' OR status_agendamento = 'E')
     AND (id_solicitacao IS NULL)) AS totalAgendadoAvulsoHoje";

    $stmDadosHoje  = $rsConexao->prepare($sqlDadosHoje);
    $stmDadosHoje->execute();
    $rsDadosHoje   = $stmDadosHoje->fetch(PDO::FETCH_ASSOC);

    # -- ranking hoje usuário -- #
    $larguraColuna  = $_GET['larguraColuna'] . 'px';
    $rsDadosHojeRankingUsuario = "";
    $contadorPosicao    = 0;
    $sqlRankingUsuario = "SELECT ucase(reg_tb_usuario.nome_usuario) usuarioSolicitante,
    COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeRegitros
    FROM reg_tb_solicitacoes
    INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes.id_usuario_cadastrou = reg_tb_usuario.id_usuario)
    WHERE date_format(reg_tb_solicitacoes.datahora_cadastro,'%Y-%m-%d')=$curDateHoje
    GROUP BY reg_tb_usuario.nome_usuario
    ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC, reg_tb_usuario.nome_usuario ASC
    LIMIT 15";
    $stmRankingUsuario  = $rsConexao->prepare($sqlRankingUsuario);
    $stmRankingUsuario->execute();

    if ($stmRankingUsuario->rowCount() > 0) {
      $rsRankingUsuario   = $stmRankingUsuario->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsRankingUsuario as $fieldRankingUsuario) {
        $contadorPosicao    = $contadorPosicao + 1;
        $usuarioSolicitante = $fieldRankingUsuario['usuarioSolicitante'];
        $quantidadeRegitros = $fieldRankingUsuario['quantidadeRegitros'];
        $rsDadosHojeRankingUsuario .= "<tr style='font-size:9pt; border-bottom: 1px dotted #289CD4;background-color:#fff !important'>
          <td style='text-align:center; width:5px'>$contadorPosicao&#176;</td>
          <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;' title='$usuarioSolicitante'>
            $usuarioSolicitante</td>
          <td style='padding-left:5px; text-align:center'>$quantidadeRegitros</td>
        </tr>";
      }
      if ($stmRankingUsuario->rowCount() < 15) {
        for ($contarLinha = $stmRankingUsuario->rowCount() + 1; $contarLinha <= 15; $contarLinha++) {
          $rsDadosHojeRankingUsuario .= "<tr style='font-size:9pt; border-bottom: 1px dotted #289CD4;background-color:#fff !important'>
          <td style='text-align:center; width:5px'>$contarLinha&#176;</td>
          <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;'>
          <font color='#e4e4e4'>
            ---------------------------------------------------------------------------------------------------------------------------------
          </font>
          </td>
          <td style='padding-left:5px; text-align:center'>--</td>
          </tr>";
        }
      }
    }

    # -- ranking hoje unidade -- #    
    $rsDadosHojeRankingUnidade = "";
    $contadorPosicao    = 0;
    $sqlRankingUnidade = "SELECT ucase(tb_estabelecimento.nfantasia_estabelecimento) AS unidadeSolicitante,
    COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeRegitros
    FROM tb_estabelecimento
    INNER JOIN reg_tb_solicitacoes ON (tb_estabelecimento.codigoestabelecimento_cnes=reg_tb_solicitacoes.id_unidade_cadastrou)
    WHERE date_format(reg_tb_solicitacoes.datahora_cadastro, '%Y-%m-%d')=$curDateHoje
    AND (reg_tb_solicitacoes.id_procedimento!=350)
    GROUP BY tb_estabelecimento.nfantasia_estabelecimento
    ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC, tb_estabelecimento.nfantasia_estabelecimento ASC LIMIT 15";

    $stmRankingUnidade  = $rsConexao->prepare($sqlRankingUnidade);
    $stmRankingUnidade->execute();

    if ($stmRankingUnidade->rowCount() > 0) {
      $rsRankingUnidade = $stmRankingUnidade->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsRankingUnidade as $fieldRankingUnidade) {
        $contadorPosicao    = $contadorPosicao + 1;
        $unidadeSolicitante = $fieldRankingUnidade['unidadeSolicitante'];
        $quantidadeRegitros = $fieldRankingUnidade['quantidadeRegitros'];
        $rsDadosHojeRankingUnidade .= "<tr style='font-size:9pt; border-bottom: 1px dotted #289CD4;background-color:#fff !important'>
          <td style='text-align:center; width:5px'>$contadorPosicao&#176;</td>
          <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;' title='$unidadeSolicitante'>
            $unidadeSolicitante
          </td>
          <td style='padding-left:5px; text-align:center'>$quantidadeRegitros</td>
        </tr>";
      }

      if ($stmRankingUnidade->rowCount() < 15) {
        for ($contarLinha = $stmRankingUnidade->rowCount() + 1; $contarLinha <= 15; $contarLinha++) {
          $rsDadosHojeRankingUnidade .= "<tr style='font-size:9pt; border-bottom: 1px dotted #37BC9B;background-color:#fff !important'>
          <td style='text-align:center; width:5px'>$contarLinha&#176;</td>
          <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;'>
          <font color='#e4e4e4'>
            ---------------------------------------------------------------------------------------------------------------------------------
          </font>
          </td>
          <td style='padding-left:5px; text-align:center'>--</td>
          </tr>";
        }
      }
    }

    # -- ranking hoje procedimento -- #
    $rsDadosHojeRankingProcedimento = "";
    $contadorPosicao    = 0;
    $sqlRankingProcedimento = "SELECT ucase(reg_tb_procedimento.nome_procedimento) procedimentoSolicitado,
    COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeRegitros
    FROM reg_tb_solicitacoes
    INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
    WHERE date_format(reg_tb_solicitacoes.datahora_cadastro,'%Y-%m-%d')=$curDateHoje
    GROUP BY reg_tb_procedimento.nome_procedimento
    ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC, reg_tb_procedimento.nome_procedimento ASC
    LIMIT 15";

    $stmRankingProcedimento = $rsConexao->prepare($sqlRankingProcedimento);
    $stmRankingProcedimento->execute();

    if ($stmRankingProcedimento->rowCount() > 0) {
      $rsRankingProcedimento = $stmRankingProcedimento->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsRankingProcedimento as $fieldRankingProcedimento) {
        $contadorPosicao        = $contadorPosicao + 1;
        $procedimentoSolicitado = $fieldRankingProcedimento['procedimentoSolicitado'];
        $quantidadeRegitros     = $fieldRankingProcedimento['quantidadeRegitros'];
        $rsDadosHojeRankingProcedimento .= "<tr style='font-size:9pt; border-bottom: 1px dotted #289CD4;background-color:#fff !important'>
      <td style='text-align:center; width:5px'>$contadorPosicao&#176;</td>
      <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;' title='$procedimentoSolicitado'>
        $procedimentoSolicitado
      </td>
      <td style='padding-left:5px; text-align:center'>$quantidadeRegitros</td>
    </tr>";
      }

      if ($stmRankingProcedimento->rowCount() < 15) {
        for ($contarLinha = $stmRankingProcedimento->rowCount() + 1; $contarLinha <= 15; $contarLinha++) {
          $rsDadosHojeRankingProcedimento .= "<tr style='font-size:9pt; border-bottom: 1px dotted #37BC9B;background-color:#fff !important'>
      <td style='text-align:center; width:5px'>$contarLinha&#176;</td>
          <td style='padding-left:5px;text-overflow: ellipsis; table-layout: fixed; ellipsis; white-space: nowrap; width: $larguraColuna; display: inline-block;overflow: hidden; direction: ltr;'>
          <font color='#e4e4e4'>
            ---------------------------------------------------------------------------------------------------------------------------------
          </font>     
          </td>
      <td style='padding-left:5px; text-align:center'>--</td>
      </tr>";
        }
      }
    }

    // 15 dias
    $sqlDados15Dias = "SELECT 
    (SELECT COUNT(*) 
     FROM reg_tb_solicitacoes 
     WHERE datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 30 DAY)) AS total_solicitacoes,
   
    (SELECT SUM(CASE WHEN id_statussolicitacao = 2 THEN 1 ELSE 0 END) 
     FROM reg_tb_solicitacoes 
     WHERE datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 30 DAY)) AS total_aguardando_agendamento,
            
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 30 DAY) 
     AND id_solicitacao IS NOT NULL) AS total_agendadoFila,

    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 30 DAY) 
     AND id_solicitacao IS NULL) AS total_agendadoAvulso,
  
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 30 DAY) 
     AND datahora_agendamento IS NOT NULL) AS total_agendadoGeral,

    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_entrega >= DATE_SUB(NOW(), INTERVAL 30 DAY) 
     AND status_agendamento = 'E') AS total_entregue,

     (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_cancelamento >= DATE_SUB(NOW(), INTERVAL 15 DAY) 
     AND datahora_cancelamento IS NOT NULL) AS total_cancelado";

    $stmDados15Dias  = $rsConexao->prepare($sqlDados15Dias);
    $stmDados15Dias->execute();
    $rsDados15Dias   = $stmDados15Dias->fetch(PDO::FETCH_ASSOC);

    // Absenteísmo - geral
    $sqlAbenteismo = "SELECT 
    -- Marcações Entregues
    (SELECT COUNT(*) 
    FROM reg_tb_agendamentos 
    WHERE (status_agendamento = 'P' or status_agendamento = 'V')
    AND (data_atendimento >= DATE_SUB(NOW(), INTERVAL 12 MONTH))
    AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
    AND (datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 12 MONTH))) AS agendamentosEntregues,
    
    -- Total Geral
    (SELECT COUNT(*) 
    FROM reg_tb_agendamentos 
    WHERE status_agendamento = 'P' 
    AND (id_usuario_confirmou IS NULL)
    AND (data_atendimento IS NOT NULL)
    AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
    AND data_atendimento >= DATE_SUB(NOW(), INTERVAL 12 MONTH)) AS totalAbsenteismo,
 
    -- Total Trimestre
    (SELECT COUNT(*) 
    FROM reg_tb_agendamentos 
    WHERE status_agendamento = 'P' 
    AND id_usuario_confirmou IS NULL 
    AND data_atendimento IS NOT NULL 
    AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
    AND data_atendimento >= DATE_SUB(NOW(), INTERVAL 3 MONTH)) AS totalAbsenteismoTrimestre,

    -- Total Mês Atual
    (SELECT COUNT(*) 
    FROM reg_tb_agendamentos 
    WHERE status_agendamento = 'P' 
    AND id_usuario_confirmou IS NULL 
    AND data_atendimento IS NOT NULL 
    AND (tipo_vagaocupada='PVEZ' OR tipo_vagaocupada='RESERVA' OR tipo_vagaocupada='RETORNO')
    AND YEAR(data_atendimento) = YEAR(NOW())
    AND MONTH(data_atendimento) = MONTH(NOW())) AS totalAbsenteismoMesAtual";

    $stmAbsenteismo     = $rsConexao->prepare($sqlAbenteismo);
    $stmAbsenteismo->execute();
    $rsAbsenteismoGeral = $stmAbsenteismo->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
      'dadosHoje' => $rsDadosHoje,
      'dadosHojeRankingUsuario' => $rsDadosHojeRankingUsuario,
      'dadosHojeRankingUnidade' => $rsDadosHojeRankingUnidade,
      'dadosHojeRankingProcedimento' => $rsDadosHojeRankingProcedimento,
      'dadosCard15Dias' => $rsDados15Dias,
      'dadosAbsenteismoGeral' => $rsAbsenteismoGeral
    ]);
  } catch (PDOException $e) {
    echo json_encode(['erro' => 'Erro ao conectar ao banco: ' . $e->getMessage()]);
  }
}
