<?php
session_start();
require("../../database/dbConection.php");

try {
  $sqlDadosHoje = "SELECT 
    (SELECT COUNT(*) 
     FROM reg_tb_solicitacoes 
     WHERE (datahora_cadastro=NOW()) AS total_solicitacoes,
   
    (SELECT SUM(CASE WHEN id_statussolicitacao = 1 THEN 1 ELSE 0 END) 
     FROM reg_tb_solicitacoes 
     WHERE (datahora_cadastro=NOW()) AS total_em_analise,
    
    (SELECT SUM(CASE WHEN id_statussolicitacao = 2 THEN 1 ELSE 0 END) 
     FROM reg_tb_solicitacoes 
     WHERE (datahora_cadastro=NOW()) AS total_aguardando_agendamento,
    
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos
     WHERE (datahora_agendamento=NOW())
     AND status_agendamento = 'A') AS total_agendado;
    ";
    $stmDadosHoje  = $rsConexao->prepare($sqlDadosHoje);
    $stmDadosHoje  ->execute();
    $rsDadosHoje   = $stmDadosHoje->fetch(PDO::FETCH_ASSOC);

  $sqlDados15Dias = "SELECT 
    (SELECT COUNT(*) 
     FROM reg_tb_solicitacoes 
     WHERE datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 15 DAY)) AS total_solicitacoes,
   
    (SELECT SUM(CASE WHEN id_statussolicitacao = 1 THEN 1 ELSE 0 END) 
     FROM reg_tb_solicitacoes 
     WHERE datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 15 DAY)) AS total_em_analise,
    
    (SELECT SUM(CASE WHEN id_statussolicitacao = 2 THEN 1 ELSE 0 END) 
     FROM reg_tb_solicitacoes 
     WHERE datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 15 DAY)) AS total_aguardando_agendamento,
    
    (SELECT COUNT(*) 
     FROM reg_tb_agendamentos 
     WHERE datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 15 DAY) 
     AND status_agendamento = 'A') AS total_agendado;
    ";

  $stmDados15Dias  = $rsConexao->prepare($sqlDados15Dias);
  $stmDados15Dias  ->execute();
  $rsDados15Dias   = $stmDados15Dias->fetch(PDO::FETCH_ASSOC);

  $sqlDados15DiasGraficoLinha = "SELECT 
    CASE 
        WHEN DAYOFWEEK(data_solicitacao) = 1 THEN CONCAT('DOM (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 2 THEN CONCAT('SEG (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 3 THEN CONCAT('TER (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 4 THEN CONCAT('QUA (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 5 THEN CONCAT('QUI (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 6 THEN CONCAT('SEX (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
        WHEN DAYOFWEEK(data_solicitacao) = 7 THEN CONCAT('SÁB (', DATE_FORMAT(data_solicitacao, '%d/%m/%Y'), ')')
    END AS data_solicitacao_formatada,
    IFNULL(SUM(total_solicitacoes), 0) AS total_solicitacoes,
    IFNULL(SUM(total_agenda), 0) AS total_agenda
FROM (
    -- Solicitações
    SELECT 
        DATE(s.datahora_cadastro) AS data_solicitacao,
        COUNT(*) AS total_solicitacoes,
        0 AS total_agenda
    FROM 
        reg_tb_solicitacoes s
    WHERE 
        s.datahora_cadastro >= DATE_SUB(NOW(), INTERVAL 15 DAY)
    GROUP BY 
        DATE(s.datahora_cadastro)

    UNION ALL

    -- Agendamentos
    SELECT 
        DATE(a.datahora_agendamento) AS data_solicitacao,
        0 AS total_solicitacoes,
        COUNT(*) AS total_agenda
    FROM 
        reg_tb_agendamentos a
    WHERE 
        a.datahora_agendamento >= DATE_SUB(NOW(), INTERVAL 15 DAY) and a.status_agendamento = 'A'
    GROUP BY 
        DATE(a.datahora_agendamento)
) AS dados
GROUP BY 
    data_solicitacao
ORDER BY 
    data_solicitacao ASC;

    ";

$stmDados15DiasGraficoLinha  = $rsConexao->prepare($sqlDados15DiasGraficoLinha);
$stmDados15DiasGraficoLinha  ->execute();
$rsDados15DiasGraficoLinha   = $stmDados15DiasGraficoLinha->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode([
    'dadosHoje'=>$rsDadosHoje,
    'dadosCard' => $rsDados15Dias,
    'dadosDatas' => $rsDados15DiasGraficoLinha
  ]);
} catch (PDOException $e) {
  echo json_encode(['erro' => 'Erro ao conectar ao banco: ' . $e->getMessage()]);
}

?>