<?php
require("../../../database/dbConection.php");
$mesAgenda    = date("Y-m-01");
$diaMesAgenda = date("Y-m-d");

# -- BUSCAR ARQUIVOS VENCIDOS --  APAGAR ARQUIVOS DE AGENDAMENTOS #
$sqlArquivos = "SELECT 
reg_tb_solicitacoes.id_statussolicitacao,
reg_tb_solicitacoes_agendado.pasta_documento,
reg_tb_solicitacoes_agendado.nomearquivo_documento,
reg_tb_solicitacoes_agendado.id_sca_solicitacao
FROM reg_tb_solicitacoes_agendado
RIGHT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_agendado.id_sca_solicitacao = reg_tb_solicitacoes.id_solicitacao)
WHERE (reg_tb_solicitacoes.id_statussolicitacao=3 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_registroagendamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=4 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_solicitoucancelamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=5 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=6 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=7 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=8 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=50) 
ORDER BY id_sca_solicitacao";

$stmArquivos  = $rsConexao->prepare($sqlArquivos);
$stmArquivos->execute();

if ($stmArquivos->rowCount() > 0) {
  $diretorioMes = "../docagendamentos/";
  $rsArquivos = $stmArquivos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsArquivos as $fieldArquivos) {
    if ($fieldArquivos['pasta_documento'] != "") {
      $diretorioMes   = $fieldArquivos['pasta_documento'];
      $nomeArquivo    = $fieldArquivos['nomearquivo_documento'];
      $numeracaoArquivo = str_pad($fieldArquivos['id_sca_solicitacao'], 10, "0");
      $arquivoExcluir = "$diretorioMes/$numeracaoArquivo" . "_" . "$nomeArquivo";
      if (file_exists($arquivoExcluir)) {
        unlink($arquivoExcluir);
      }
    }
  }
}
#************************************************************************************************************************************#

# -- BUSCAR ARQUIVOS VENCIDOS -- APAGAR ARQUIVOS DE SOLICITACOES #
$sqlArquivos = "SELECT 
reg_tb_solicitacoes.id_statussolicitacao,
reg_tb_solicitacoes.datahora_cancelamento,
reg_tb_solicitacoes_anexos.pasta_documento,
reg_tb_solicitacoes_anexos.nomearquivo_documento,
reg_tb_solicitacoes_anexos.token_solicitacao
FROM reg_tb_solicitacoes_anexos
RIGHT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_anexos.id_sca_solicitacao = reg_tb_solicitacoes.id_solicitacao)
WHERE (reg_tb_solicitacoes.id_statussolicitacao=4 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_solicitoucancelamento)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=5 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=6 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=7 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=8 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=45)";

$stmArquivos  = $rsConexao->prepare($sqlArquivos);
$stmArquivos->execute();

if ($stmArquivos->rowCount() > 0) {
  $diretorioMes = "../docsolicitacoes/";
  $rsArquivos = $stmArquivos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsArquivos as $fieldArquivos) {
    if ($fieldArquivos['pasta_documento'] != "") {
      $diretorioMes   = $fieldArquivos['pasta_documento'];
      $nomeArquivo    = $fieldArquivos['nomearquivo_documento'];
      $tokenArquivo   = $fieldArquivos['token_solicitacao'];
      $arquivoExcluir = "$diretorioMes/$tokenArquivo" . "_" . "$nomeArquivo";
      if (file_exists($arquivoExcluir)) {
        unlink($arquivoExcluir);
      }
    }
  }
}
#************************************************************************************************************************************#

# -- ATUALIZAÇÃO DE INFORMAÇÕES DAS AGENDAS -- #

$mesAgenda    = date("Y-m-01");
$diaMesAgenda = date("Y-m-d");

# -- MUDAR STATUS DA AGENDA SUB EXPIRADA -- #
$updateStatusAgendaSub = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-',LPAD(dia_agenda, 2, '0'))<'$diaMesAgenda') AND (status_agenda='A')");
$updateStatusAgendaSub->execute();

# -- MUDAR STATUS DA AGENDA PRINCIPAL EXPIRADA -- #
$updateStatusAgendaPincipal = $rsConexao->prepare("UPDATE reg_tb_agenda SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-01')<'$mesAgenda') AND (status_agenda='A')");
$updateStatusAgendaPincipal->execute();
$updateStatusAgendaPincipal->closeCursor();
# -- Verificar se ainda tem agenda sub no mês atual
$sqlTemAgendaAtiva = "SELECT count(id_agenda_sub) AS totalRegistros 
  FROM reg_tb_agenda_sub 
  WHERE (concat(ano_agenda,'-',mes_agenda,'-',LPAD(dia_agenda, 2, '0'))<'$diaMesAgenda') 
  AND (status_agenda='A')";
$stmTemAgendaAtiva  = $rsConexao->prepare($sqlTemAgendaAtiva);
$stmTemAgendaAtiva->execute();
$rsTemAgendaAtiva   = $stmTemAgendaAtiva->fetch(PDO::FETCH_OBJ);
if ($rsTemAgendaAtiva->totalRegistros == 0) {
  $updateStatusAgendaPincipal = $rsConexao->prepare("UPDATE reg_tb_agenda SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-01')<'$mesAgenda') AND (status_agenda='A')");
  $updateStatusAgendaPincipal->execute();
}

# -- MUDAR STATUS DO AGENDAMENTO PARA PENDENTE -- #
$stmAtualizarAgendamento  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='P' WHERE (date_format(data_atendimento,'%Y-%m-%d')<'$diaMesAgenda') AND (status_agendamento='E') AND (id_usuario_confirmou IS NULL)");
$stmAtualizarAgendamento->execute();
$stmAtualizarAgendamento->closeCursor();

$stmAtualizarAgendamento = $rsConexao->prepare("UPDATE reg_tb_agendamentos INNER JOIN reg_tb_solicitacoes ON reg_tb_agendamentos.id_solicitacao=reg_tb_solicitacoes.id_solicitacao SET reg_tb_solicitacoes.status_agendamento = reg_tb_agendamentos.status_agendamento WHERE (date_format(reg_tb_agendamentos.data_atendimento,'%Y-%m-%d')<'$diaMesAgenda') AND (reg_tb_agendamentos.status_agendamento='A' OR reg_tb_agendamentos.status_agendamento='E')");
$stmAtualizarAgendamento->execute();

# -- DESATIVAR STATUS DO FERIADO
$dataReferenciaFeriado  = date("Y-m-d");
$stmAtualizarFeriado    = $rsConexao->prepare("UPDATE reg_tb_feriados SET status_feriado='I' WHERE (date_format(data_fimferiado,'%Y-%m-%d')<'$dataReferenciaFeriado') AND (status_feriado='A')");
$stmAtualizarFeriado->execute();

#************************************************************************************************************************************#

# -- ATUALIZAÇÃO DE STATUS DO SISTEMA -- #

# --- Atualizar Status do proceso em Agendamento --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_agendamento='N' WHERE em_agendamento='S'");
$stmAtualizarstatus_EmAnalise->execute();

# --- Atualizar Status do proceso em Análise --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_analise='N' WHERE em_analise='S'");
$stmAtualizarstatus_EmAnalise->execute();

# --- Atualizar Status do proceso em Comunicacao --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_comunicacao='N' WHERE em_comunicacao='S'");
$stmAtualizarstatus_EmAnalise->execute();


#************************************************************************************************************************************#

# -- REALIZAR CANCELAMENTO AUTOMÁTICO --#

# -- LIMPAR TABELA DE DADOS TEMPORÁRIOS DE VAGAS RESTAURADAS --#
//$stmLimparVagasRestauradas  = $rsConexao->prepare("DELETE FROM reg_tb_vagasrestauradas");
//$stmLimparVagasRestauradas  -> execute();
//$stmLimparVagasRestauradas  = $rsConexao->prepare("ALTER TABLE reg_tb_vagasrestauradas AUTO_INCREMENT=1");
//$stmLimparVagasRestauradas  -> execute();

# -- BUSCAR TODOS OS AGENDAMENTOS COM PRAZO DE RETIDADA VENCIDOS -- #
/*
$dataHoje   = date("Y-m-d");
$stmAgendamentos  = "SELECT reg_tb_agendamentos.*,
reg_tb_agenda.codigoestabelecimento_cnes,
reg_tb_agenda.codigoprofissional_cnes
FROM reg_tb_agendamentos 
INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda=reg_tb_agendamentos.id_agenda)
WHERE (id_agenda_sub IS NOT NULL AND id_agenda_sub!='')
AND ((status_agendamento='A' AND date_format(dataprazo_retirada,'%Y-%m-%d')<'$dataHoje') OR (status_agendamento='X'))
ORDER BY tipo_vagaocupada";

$stmAgendamentos  = $rsConexao->prepare($stmAgendamentos);
$stmAgendamentos->execute();

if ($stmAgendamentos->rowCount() > 0) {

  $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsAgendamentos as $fieldAgendamento) {
    $idAgendamento        = $fieldAgendamento['id_agendamento'];
    $numeroProtocolo      = $fieldAgendamento['protocolo_agendamento'];
    $idAgenda             = $fieldAgendamento['id_agenda'];
    $idAgendaSub          = $fieldAgendamento['id_agenda_sub'];
    $idSolicitacao        = $fieldAgendamento['id_solicitacao'];
    $tipoVagaOcupada      = $fieldAgendamento['tipo_vagaocupada'];
    $prazoRetirada        = $fieldAgendamento['dataprazo_retirada'];
    $origemAgendamento    = $fieldAgendamento['origem_agendamento'];
    $idGrupoProcedimento  = $fieldAgendamento['id_grupo_procedimento'];
    $idProcedimento       = $fieldAgendamento['id_procedimento'] == "" ? 'null' : $fieldAgendamento['id_procedimento'];
    $codigoUnidade        = $fieldAgendamento['codigoestabelecimento_cnes'];
    $codigoProfissional   = $fieldAgendamento['codigoprofissional_cnes'];
    $dataAtendimento      = $fieldAgendamento['data_atendimento'];
    $horarioAtendimento   = $fieldAgendamento['horario_atendimento'];
    $idAgendaSUB          = $fieldAgendamento['id_agenda_sub'];
    # -- cancelar agendamento -- #
    $sqlCancelarAgendamento = "UPDATE reg_tb_agendamentos 
    SET status_agendamento='C',
    informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
    datahora_cancelamento=NOW()
    WHERE (id_agendamento='$idAgendamento')";
    $stmCancelarAgendamento = $rsConexao->prepare($sqlCancelarAgendamento);
    //$stmCancelarAgendamento->execute();
    $stmCancelarAgendamento->closeCursor();

    # -- cancelar solicitacoes -- #
    if ($idSolicitacao != "") {
      $dataHoraHoje = date("Y-m-d H:i:s");
      $sqlCancelarSolicitacao = "UPDATE reg_tb_solicitacoes 
      SET id_statussolicitacao='2',
      datahora_cadastro='$dataHoraHoje',
      informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
      datahora_cancelamento=NOW()    
      WHERE (id_solicitacao='$idSolicitacao')";
      $stmCancelarSolicitacao = $rsConexao->prepare($sqlCancelarSolicitacao);
      //$stmCancelarSolicitacao->execute();
      $stmCancelarSolicitacao->closeCursor();
    }

    # -- restaurar vagas de primeira vez
    /*
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "PVEZ") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadegendada_pvez FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadegendada_pvez;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadegendada_pvez='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }

    # -- restaurar vagas de retorno
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "RETORNO") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadeagendada_retorno FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadeagendada_retorno;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadeagendada_retorno='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }

    # -- restaurar vagas de reserva
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "RESERVA") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadeagendada_reserva FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadeagendada_reserva;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadeagendada_reserva='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }
    

    # -- adicionar registro temporário de vagas restauradas para envio de notificação -- #
    $sqlGravarVagasrestauradas = "INSERT INTO reg_tb_vagasrestauradas(
      tipo_vaga,
      id_grupoprocedimento,
      id_procedimento,
      codigoestabelecimento_cnes,
      codigoprofissional_cnes,
      data_atendimento,
      horario_agendimento,
      id_agenda_sub
    )VALUES(
      '$tipoVagaOcupada',
      '$idGrupoProcedimento',
      $idProcedimento,
      '$codigoUnidade',
      '$codigoProfissional',
      '$dataAtendimento',
      '$horarioAtendimento',
      '$idAgendaSUB'
    )";
    $stmGravarVagasrestauradas  =  $rsConexao->prepare($sqlGravarVagasrestauradas);
    $stmGravarVagasrestauradas->execute();
    $stmGravarVagasrestauradas->closeCursor();
    
    # gerar histórico de cancelamento do agendamento      
    if($idSolicitacao!=""){
      $sqlMovimento = "INSERT INTO reg_tb_solicitacoes_historico(
          id_solicitacao,
          datahora_registro,
          texto_movimentacao,
          id_statussolicitacao
        )VALUES(
          :setIdSolicitacao,
          :setDataHoraHoje,
          :setTextoMovimento,
          :setStatusSolicitacao
        )";
      $tipoMovimento = "CANCELAMENTO AUTOMÁTICO##SISTEMA";
      $idStatusMovimento = 5;
      $dataHoraHoje = date("Y-m-d H:i:s");
      $stmMovimento = $rsConexao->prepare($sqlMovimento);
      $stmMovimento->bindParam(":setIdSolicitacao", $idSolicitacao, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setTextoMovimento", $tipoMovimento, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
      $stmMovimento->execute();
    }
    
  }
  
}*/

# -- CANCELAR TODAS AS SOLICITAÇÕES COM STATUS CANCELAR -- #
$stmSolicitacao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET id_statussolicitacao='5' WHERE (id_statussolicitacao='4')");
$stmSolicitacao->execute();
$stmSolicitacao->closeCursor();


# -- EXCLUIR AGENDAS REPLICADAS NÃO SALVAS -- #
$stmAgendaReplicada = $rsConexao->prepare("DELETE FROM reg_tb_agenda WHERE (id_statussolicitacao='4')");
$stmSolicitacao->execute();
$stmSolicitacao->closeCursor();


# ---- SELECIONAR PROCEDIMENTOS AGUARDANDO AGENDAMENTO ----  PROCESSAR POSIÇÃO NA FILA #
$stmConfiguracoes	= $rsConexao->prepare("SELECT * FROM reg_tb_configuracoes");
$stmConfiguracoes->execute();
$rsConfiguracoes	= $stmConfiguracoes->fetch(PDO::FETCH_OBJ);
$idadePrioritariaFila = $rsConfiguracoes->idate_prioritaria_fila;  
$numeroPosicao  = 0;

# -- Zerar posição na fila -- #

$stmProcedimentosExistentes = $rsConexao->prepare("SELECT id_procedimento FROM reg_tb_procedimento ORDER BY id_procedimento");
$stmProcedimentosExistentes -> execute();

$ultimaPosicaoidoso = 0;
if($stmProcedimentosExistentes->rowCount()>0){
  $rsProcedimentosExistentes = $stmProcedimentosExistentes->fetchAll(PDO :: FETCH_ASSOC);
  foreach($rsProcedimentosExistentes AS $fieldProcedimento){

    $idProcedimento = $fieldProcedimento['id_procedimento'];

    if($idadePrioritariaFila>0){

      # -- atualizar posição na fila de pacientes prioritários a partir da idade progamada --#
      $sqlSolicitacoes60 = "SELECT reg_tb_solicitacoes.id_solicitacao
      FROM reg_tb_solicitacoes
      INNER JOIN tb_paciente ON tb_paciente.id_paciente=reg_tb_solicitacoes.id_paciente
      WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
      AND (TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW())>='$idadePrioritariaFila')
      AND (reg_tb_solicitacoes.id_procedimento='$idProcedimento')    
      ORDER BY TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) DESC, DATE_FORMAT(datahora_cadastro, '%Y%m%d%H%i') ASC, id_solicitacao";

      $stmAguardando60  = $rsConexao->prepare($sqlSolicitacoes60);
      $stmAguardando60  ->execute();
      if ($stmAguardando60->rowCount() > 0) {
        $rsAguardando60 = $stmAguardando60->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rsAguardando60 as $fieldAguardando60) {
          $numeroPosicao      = $numeroPosicao + 1;
          $idSolicitacao60    = $fieldAguardando60['id_solicitacao'];
          $stmAtualizaPosicao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET posicao_fila='$numeroPosicao' WHERE id_solicitacao='$idSolicitacao60'");
          $stmAtualizaPosicao->execute();
        }
        $ultimaPosicaoidoso = $numeroPosicao;
        $numeroPosicao = 0;
      }

      # -- atualizar posição na fila de pacientes com idade abaixo da idade progamada como prioritária --#  
      $numeroPosicao = $ultimaPosicaoidoso;
      $sqlSolicitacoes59 = "SELECT reg_tb_solicitacoes.id_solicitacao
      FROM reg_tb_solicitacoes
      INNER JOIN tb_paciente ON tb_paciente.id_paciente=reg_tb_solicitacoes.id_paciente
      WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
      AND (TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW())<'$idadePrioritariaFila')
      AND (reg_tb_solicitacoes.id_procedimento='$idProcedimento')    
      ORDER BY DATE_FORMAT(datahora_cadastro, '%Y%m%d%H%i') ASC, id_solicitacao";

      $stmAguardando59  = $rsConexao->prepare($sqlSolicitacoes59);
      $stmAguardando59  ->execute();
      if ($stmAguardando59->rowCount() > 0) {
        $rsAguardando59 = $stmAguardando59->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rsAguardando59 as $fieldAguardando59) {
          $numeroPosicao      = $numeroPosicao + 1;
          $idSolicitacao59      = $fieldAguardando59['id_solicitacao'];
          $stmAtualizaPosicao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET posicao_fila='$numeroPosicao' WHERE id_solicitacao='$idSolicitacao59'");
          $stmAtualizaPosicao->execute();
        }
      }
    
    }else{

      $sqlSolicitacoes60 = "SELECT reg_tb_solicitacoes.id_solicitacao
      FROM reg_tb_solicitacoes
      INNER JOIN tb_paciente ON tb_paciente.id_paciente=reg_tb_solicitacoes.id_paciente
      WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
      AND (reg_tb_solicitacoes.id_procedimento='$idProcedimento')    
      ORDER BY DATE_FORMAT(datahora_cadastro, '%Y%m%d%H%i') ASC, id_solicitacao";

      $stmAguardando60  = $rsConexao->prepare($sqlSolicitacoes60);
      $stmAguardando60  ->execute();
      if ($stmAguardando60->rowCount() > 0) {
        $rsAguardando60 = $stmAguardando60->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rsAguardando60 as $fieldAguardando60) {
          $numeroPosicao      = $numeroPosicao + 1;
          $idSolicitacao60    = $fieldAguardando60['id_solicitacao'];
          $stmAtualizaPosicao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET posicao_fila='$numeroPosicao' WHERE id_solicitacao='$idSolicitacao60'");
          $stmAtualizaPosicao->execute();
        }
        $ultimaPosicaoidoso = $numeroPosicao;
        $numeroPosicao = 0;
      }

    }

  }

}
# -- atualiza estus da solicitação de OCI que já foi agendada mas ainda não chegou aa data do atendimento --#
   $sqlAtualizarStatusOCIFila = "UPDATE reg_tb_solicitacoes 
    SET id_statussolicitacao='6'    
    WHERE (data_atendimento=curdate())
    AND (id_grupo_procedimento=14)
    AND (id_statussolicitacao=2)";
    $stmAtualizarStatusOCIFila = $rsConexao->prepare($sqlAtualizarStatusOCIFila);
    $stmAtualizarStatusOCIFila ->execute();
#************************************************************************************************************************************#

# ---- ATUALIZAR CONFIRMAÇÃO DO ATENDIMENTO FORA DO G-SAÚDE ---- #
$dataHoje = date("Y-m-d");
$sqlStatusAgendamento = "UPDATE reg_tb_agendamentos
SET status_agendamento='V'
WHERE (tipo_vagaocupada!='PVEZ' AND tipo_vagaocupada!='RETORNO' AND tipo_vagaocupada!='RESERVA')
AND (status_agendamento='A')
AND (data_atendimento<'$dataHoje')";
$stmStatusAgendamento = $rsConexao->prepare($sqlStatusAgendamento);
$stmStatusAgendamento -> execute();

?>