<?php
require("../../../database/dbConection.php");
$mesAgenda    = date("Y-m-01");
$diaMesAgenda = date("Y-m-d");

# -- BUSCAR ARQUIVOS VENCIDOS --  APAGAR ARQUIVOS DE AGENDAMENTOS #
$sqlArquivos = "SELECT 
reg_tb_solicitacoes.id_statussolicitacao,
reg_tb_solicitacoes_agendado.pasta_documento,
reg_tb_solicitacoes_agendado.nomearquivo_documento,
reg_tb_solicitacoes_agendado.id_sca_solicitacao
FROM reg_tb_solicitacoes_agendado
RIGHT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_agendado.id_sca_solicitacao = reg_tb_solicitacoes.id_solicitacao)
WHERE (reg_tb_solicitacoes.id_statussolicitacao=3 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_registroagendamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=4 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_solicitoucancelamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=5 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=6 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=7 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=50)
OR (reg_tb_solicitacoes.id_statussolicitacao=8 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=50) 
ORDER BY id_sca_solicitacao";

$stmArquivos  = $rsConexao->prepare($sqlArquivos);
$stmArquivos->execute();

if ($stmArquivos->rowCount() > 0) {
  $diretorioMes = "../docagendamentos/";
  $rsArquivos = $stmArquivos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsArquivos as $fieldArquivos) {
    if ($fieldArquivos['pasta_documento'] != "") {
      $diretorioMes   = $fieldArquivos['pasta_documento'];
      $nomeArquivo    = $fieldArquivos['nomearquivo_documento'];
      $numeracaoArquivo = str_pad($fieldArquivos['id_sca_solicitacao'], 10, "0");
      $arquivoExcluir = "$diretorioMes/$numeracaoArquivo" . "_" . "$nomeArquivo";
      if (file_exists($arquivoExcluir)) {
        unlink($arquivoExcluir);
      }
    }
  }
}
#************************************************************************************************************************************#

# -- BUSCAR ARQUIVOS VENCIDOS -- APAGAR ARQUIVOS DE SOLICITACOES #
$sqlArquivos = "SELECT 
reg_tb_solicitacoes.id_statussolicitacao,
reg_tb_solicitacoes.datahora_cancelamento,
reg_tb_solicitacoes_anexos.pasta_documento,
reg_tb_solicitacoes_anexos.nomearquivo_documento,
reg_tb_solicitacoes_anexos.token_solicitacao
FROM reg_tb_solicitacoes_anexos
RIGHT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_anexos.id_sca_solicitacao = reg_tb_solicitacoes.id_solicitacao)
WHERE (reg_tb_solicitacoes.id_statussolicitacao=4 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_solicitoucancelamento)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=5 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=6 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=7 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_entrega)>=45)
OR (reg_tb_solicitacoes.id_statussolicitacao=8 AND DATEDIFF(CURDATE(), reg_tb_solicitacoes.datahora_cancelamento)>=45)";

$stmArquivos  = $rsConexao->prepare($sqlArquivos);
$stmArquivos->execute();

if ($stmArquivos->rowCount() > 0) {
  $diretorioMes = "../docsolicitacoes/";
  $rsArquivos = $stmArquivos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsArquivos as $fieldArquivos) {
    if ($fieldArquivos['pasta_documento'] != "") {
      $diretorioMes   = $fieldArquivos['pasta_documento'];
      $nomeArquivo    = $fieldArquivos['nomearquivo_documento'];
      $tokenArquivo   = $fieldArquivos['token_solicitacao'];
      $arquivoExcluir = "$diretorioMes/$tokenArquivo" . "_" . "$nomeArquivo";
      if (file_exists($arquivoExcluir)) {
        unlink($arquivoExcluir);
      }
    }
  }
}
#************************************************************************************************************************************#

# ---- SELECIONAR PROCEDIMENTOS AGUARDANDO AGENDAMENTO ----  PROCESSAR POSIÇÃO NA FILA #
$numeroPosicao  = 0;

$sqlAguardando = "SELECT 
reg_tb_solicitacoes.id_procedimento
FROM reg_tb_solicitacoes
WHERE (reg_tb_solicitacoes.id_statussolicitacao=2)
GROUP BY reg_tb_solicitacoes.id_procedimento";
$stmAguardando  = $rsConexao->prepare($sqlAguardando);
$stmAguardando->execute();

if ($stmAguardando->rowCount() > 0) {
  $rsAguardando = $stmAguardando->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsAguardando as $fieldAguardando) {
    $idProcedimento = $fieldAguardando['id_procedimento'];
    $sqlSelecionaRegistros = "SELECT 
    id_solicitacao, 
    id_procedimento,
    posicao_fila,
    datahora_analise, 
    datahora_cadastro, 
    DATE_FORMAT(datahora_cadastro, '%Y%m%d%H%i') AS dataHoraCad 
    FROM reg_tb_solicitacoes 
    WHERE (reg_tb_solicitacoes.id_statussolicitacao=2 AND id_procedimento='$idProcedimento')
    ORDER BY DATE_FORMAT(datahora_cadastro, '%Y%m%d%H%i') ASC";
    $stmSelecionaRegistros  = $rsConexao->prepare($sqlSelecionaRegistros);
    $stmSelecionaRegistros->execute();
    if ($stmSelecionaRegistros->rowCount() > 0) {
      $rsSelecionaRegistros = $stmSelecionaRegistros->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsSelecionaRegistros as $fieldSelecionaRegistros) {
        $numeroPosicao      = $numeroPosicao + 1;
        $idSolicitacao      = $fieldSelecionaRegistros['id_solicitacao'];
        $stmAtualizaPosicao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET posicao_fila='$numeroPosicao' WHERE id_solicitacao='$idSolicitacao'");
        $stmAtualizaPosicao->execute();
      }
      $numeroPosicao  = 0;
    }
  }
}
#************************************************************************************************************************************#

# -- ATUALIZAÇÃO DE INFORMAÇÕES DAS AGENDAS -- #

$mesAgenda    = date("Y-m-01");
$diaMesAgenda = date("Y-m-d");

# -- MUDAR STATUS DA AGENDA SUB EXPIRADA -- #
$updateStatusAgendaSub = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-',LPAD(dia_agenda, 2, '0'))<'$diaMesAgenda') AND (status_agenda='A')");
$updateStatusAgendaSub->execute();

# -- MUDAR STATUS DA AGENDA PRINCIPAL EXPIRADA -- #
$updateStatusAgendaPincipal = $rsConexao->prepare("UPDATE reg_tb_agenda SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-01')<'$mesAgenda') AND (status_agenda='A')");
$updateStatusAgendaPincipal->execute();
$updateStatusAgendaPincipal->closeCursor();
# -- Verificar se ainda tem agenda sub no mês atual
$sqlTemAgendaAtiva = "SELECT count(id_agenda_sub) AS totalRegistros 
  FROM reg_tb_agenda_sub 
  WHERE (concat(ano_agenda,'-',mes_agenda,'-',LPAD(dia_agenda, 2, '0'))<'$diaMesAgenda') 
  AND (status_agenda='A')";
$stmTemAgendaAtiva  = $rsConexao->prepare($sqlTemAgendaAtiva);
$stmTemAgendaAtiva->execute();
$rsTemAgendaAtiva   = $stmTemAgendaAtiva->fetch(PDO::FETCH_OBJ);
if ($rsTemAgendaAtiva->totalRegistros == 0) {
  $updateStatusAgendaPincipal = $rsConexao->prepare("UPDATE reg_tb_agenda SET status_agenda='E' WHERE (concat(ano_agenda,'-',mes_agenda,'-01')<'$mesAgenda') AND (status_agenda='A')");
  $updateStatusAgendaPincipal->execute();
}

# -- MUDAR STATUS DO AGENDAMENTO PARA PENDENTE -- #
$stmAtualizarAgendamento  = $rsConexao->prepare("UPDATE reg_tb_agendamentos SET status_agendamento='P' WHERE (date_format(data_atendimento,'%Y-%m-%d')<'$diaMesAgenda') AND (status_agendamento='A' OR status_agendamento='E')");
$stmAtualizarAgendamento->execute();
$stmAtualizarAgendamento->closeCursor();

$stmAtualizarAgendamento = $rsConexao->prepare("UPDATE reg_tb_agendamentos INNER JOIN reg_tb_solicitacoes ON reg_tb_agendamentos.id_solicitacao=reg_tb_solicitacoes.id_solicitacao SET reg_tb_solicitacoes.status_agendamento = reg_tb_agendamentos.status_agendamento WHERE (date_format(reg_tb_agendamentos.data_atendimento,'%Y-%m-%d')<'$diaMesAgenda') AND (reg_tb_agendamentos.status_agendamento='A' OR reg_tb_agendamentos.status_agendamento='E')");
$stmAtualizarAgendamento->execute();

# -- DESATIVAR STATUS DO FERIADO
$dataReferenciaFeriado  = date("Y-m-d");
$stmAtualizarFeriado    = $rsConexao->prepare("UPDATE reg_tb_feriados SET status_feriado='I' WHERE (date_format(data_fimferiado,'%Y-%m-%d')<'$dataReferenciaFeriado') AND (status_feriado='A')");
$stmAtualizarFeriado->execute();

#************************************************************************************************************************************#

# -- ATUALIZAÇÃO DE STATUS DO SISTEMA -- #

# --- Atualizar Status do proceso em Agendamento --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_agendamento='N' WHERE em_agendamento='S'");
$stmAtualizarstatus_EmAnalise->execute();

# --- Atualizar Status do proceso em Análise --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_analise='N' WHERE em_analise='S'");
$stmAtualizarstatus_EmAnalise->execute();

# --- Atualizar Status do proceso em Comunicacao --- #
$stmAtualizarstatus_EmAnalise = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET em_comunicacao='N' WHERE em_comunicacao='S'");
$stmAtualizarstatus_EmAnalise->execute();


#************************************************************************************************************************************#

# -- REALIZAR CANCELAMENTO AUTOMÁTICO --#

# -- LIMPAR TABELA DE DADOS TEMPORÁRIOS DE VAGAS RESTAURADAS --#
//$stmLimparVagasRestauradas  = $rsConexao->prepare("DELETE FROM reg_tb_vagasrestauradas");
//$stmLimparVagasRestauradas  -> execute();
//$stmLimparVagasRestauradas  = $rsConexao->prepare("ALTER TABLE reg_tb_vagasrestauradas AUTO_INCREMENT=1");
//$stmLimparVagasRestauradas  -> execute();

$dataHoje   = date("Y-m-d");

# -- BUSCAR TODOS OS AGENDAMENTOS COM PRAZO DE RETIDADA VENCIDOS -- #
$stmAgendamentos  = "SELECT reg_tb_agendamentos.*,
reg_tb_agenda.codigoestabelecimento_cnes,
reg_tb_agenda.codigoprofissional_cnes
FROM reg_tb_agendamentos 
INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda=reg_tb_agendamentos.id_agenda)
WHERE (id_agenda_sub IS NOT NULL AND id_agenda_sub!='')
AND ((status_agendamento='A' AND date_format(dataprazo_retirada,'%Y-%m-%d')<'$dataHoje') OR (status_agendamento='X'))
ORDER BY tipo_vagaocupada";

$stmAgendamentos  = $rsConexao->prepare($stmAgendamentos);
$stmAgendamentos->execute();

if ($stmAgendamentos->rowCount() > 0) {

  $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsAgendamentos as $fieldAgendamento) {
    $idAgendamento        = $fieldAgendamento['id_agendamento'];
    $numeroProtocolo      = $fieldAgendamento['protocolo_agendamento'];
    $idAgenda             = $fieldAgendamento['id_agenda'];
    $idAgendaSub          = $fieldAgendamento['id_agenda_sub'];
    $idSolicitacao        = $fieldAgendamento['id_solicitacao'];
    $tipoVagaOcupada      = $fieldAgendamento['tipo_vagaocupada'];
    $prazoRetirada        = $fieldAgendamento['dataprazo_retirada'];
    $origemAgendamento    = $fieldAgendamento['origem_agendamento'];
    $idGrupoProcedimento  = $fieldAgendamento['id_grupo_procedimento'];
    $idProcedimento       = $fieldAgendamento['id_procedimento'] == "" ? 'null' : $fieldAgendamento['id_procedimento'];
    $codigoUnidade        = $fieldAgendamento['codigoestabelecimento_cnes'];
    $codigoProfissional   = $fieldAgendamento['codigoprofissional_cnes'];
    $dataAtendimento      = $fieldAgendamento['data_atendimento'];
    $horarioAtendimento   = $fieldAgendamento['horario_atendimento'];
    $idAgendaSUB          = $fieldAgendamento['id_agenda_sub'];
    # -- cancelar agendamento -- #
    $sqlCancelarAgendamento = "UPDATE reg_tb_agendamentos 
    SET status_agendamento='C',
    informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
    datahora_cancelamento=NOW()
    WHERE (id_agendamento='$idAgendamento')";
    $stmCancelarAgendamento = $rsConexao->prepare($sqlCancelarAgendamento);
    $stmCancelarAgendamento->execute();
    $stmCancelarAgendamento->closeCursor();

    # -- cancelar solicitacoes -- #
    if ($idSolicitacao != "") {
      $sqlCancelarSolicitacao = "UPDATE reg_tb_solicitacoes 
      SET id_statussolicitacao='5',
      informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
      datahora_cancelamento=NOW()    
      WHERE (id_solicitacao='$idSolicitacao')";
      $stmCancelarSolicitacao = $rsConexao->prepare($sqlCancelarSolicitacao);
      $stmCancelarSolicitacao->execute();
      $stmCancelarSolicitacao->closeCursor();
    }

    # -- restaurar vagas de primeira vez
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "PVEZ") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadegendada_pvez FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadegendada_pvez;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadegendada_pvez='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }

    # -- restaurar vagas de retorno
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "RETORNO") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadeagendada_retorno FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadeagendada_retorno;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadeagendada_retorno='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }

    # -- restaurar vagas de reserva
    $novoTotalOcupado = 0;
    if ($tipoVagaOcupada == "RESERVA") {
      $stmTotalOcupado  = $rsConexao->prepare("SELECT quantidadeagendada_reserva FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      $totalOcupado     = $rsTotalOcupado->quantidadeagendada_reserva;
      $novoTotalOcupado = $totalOcupado - 1;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET quantidadeagendada_reserva='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();

      $stmTotalOcupado->closeCursor();
      $stmDevolveVagaAgenda->closeCursor();
    }

    # -- adicionar registro temporário de vagas restauradas para envio de notificação -- #
    $sqlGravarVagasrestauradas = "INSERT INTO reg_tb_vagasrestauradas(
      tipo_vaga,
      id_grupoprocedimento,
      id_procedimento,
      codigoestabelecimento_cnes,
      codigoprofissional_cnes,
      data_atendimento,
      horario_agendimento,
      id_agenda_sub
    )VALUES(
      '$tipoVagaOcupada',
      '$idGrupoProcedimento',
      $idProcedimento,
      '$codigoUnidade',
      '$codigoProfissional',
      '$dataAtendimento',
      '$horarioAtendimento',
      '$idAgendaSUB'
    )";
    $stmGravarVagasrestauradas  =  $rsConexao->prepare($sqlGravarVagasrestauradas);
    $stmGravarVagasrestauradas->execute();
    $stmGravarVagasrestauradas->closeCursor();

    # gerar histórico de cancelamento do agendamento      
    if($idSolicitacao!=""){
      $sqlMovimento = "INSERT INTO reg_tb_solicitacoes_historico(
          id_solicitacao,
          datahora_registro,
          texto_movimentacao,
          id_statussolicitacao
        )VALUES(
          :setIdSolicitacao,
          :setDataHoraHoje,
          :setTextoMovimento,
          :setStatusSolicitacao
        )";
      $tipoMovimento = "CANCELAMENTO AUTOMÁTICO##SISTEMA";
      $idStatusMovimento = 5;
      $dataHoraHoje = date("Y-m-d H:i:s");
      $stmMovimento = $rsConexao->prepare($sqlMovimento);
      $stmMovimento->bindParam(":setIdSolicitacao", $idSolicitacao, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setDataHoraHoje", $dataHoraHoje, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setTextoMovimento", $tipoMovimento, PDO::PARAM_STR);
      $stmMovimento->bindParam(":setStatusSolicitacao", $idStatusMovimento, PDO::PARAM_STR);
      $stmMovimento->execute();
    }
  }
}

# -- CANCELAR TODAS AS SOLICITAÇÕES COM STATUS CANCELAR -- #
$stmSolicitacao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET id_statussolicitacao='5' WHERE (id_statussolicitacao='4')");
$stmSolicitacao->execute();
$stmSolicitacao->closeCursor();
?>