<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado = $_SESSION['idUsuarioLogado'];

$opcaoCadastro  = $_POST['opcaoCadastro'];

switch ($opcaoCadastro) {
  case "cadastro-painel":
    $unidadeAtendimento = $_POST['unidadeAtendimento'];
    $idPainelChamada    = $_POST['idPainelChamada'];
    $nomePainel          = $_POST['nomePainel'];
    if ($idPainelChamada == "") {
      $sqlPainel = "INSERT INTO reg_tb_painelchamada(
        codigoestabelecimento_cnes,
        nome_painel
      )VALUES(
        :setUnidadeAtendimento,
        :setNomePainel
      )";
    } else {
      $sqlPainel = "UPDATE reg_tb_painelchamada SET
        codigoestabelecimento_cnes=:setUnidadeAtendimento,
        nome_painel=:setNomePainel
      WHERE id_painelchamada='$idPainelChamada'";
    }
    $stmPainel = $rsConexao->prepare($sqlPainel);
    $stmPainel->bindParam(":setUnidadeAtendimento", $unidadeAtendimento, PDO::PARAM_STR);
    $stmPainel->bindParam(":setNomePainel", $nomePainel, PDO::PARAM_STR);
    $stmPainel->execute();

    # -- carregar listagem atualizada -- #
    $sqlListaPaineis = "SELECT reg_tb_painelchamada.id_painelchamada,
		reg_tb_painelchamada.codigoestabelecimento_cnes,
		reg_tb_painelchamada.nome_painel,
		tb_estabelecimento.nfantasia_estabelecimento
		FROM tb_estabelecimento
		INNER JOIN reg_tb_painelchamada ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_painelchamada.codigoestabelecimento_cnes)
		ORDER BY tb_estabelecimento.nfantasia_estabelecimento,reg_tb_painelchamada.nome_painel";
    $stmListaPaineis = $rsConexao->prepare($sqlListaPaineis);
    $stmListaPaineis->execute();

    if ($stmListaPaineis->rowCount()) {
      $rsListaPaineis  = $stmListaPaineis->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsListaPaineis as $fieldListaPaineis) {
        $idPainel       = $fieldListaPaineis['id_painelchamada'];
        $codigoUnidade  = mb_strtoupper($fieldListaPaineis['codigoestabelecimento_cnes']);
        $nomePainel     = mb_strtoupper($fieldListaPaineis['nome_painel']);
        $nomeUnidade     = mb_strtoupper($fieldListaPaineis['nfantasia_estabelecimento']);

        $linkEditarPainel    = '"editarPainel(' . "'$idPainel##$codigoUnidade##$nomePainel')" . '"';
        $linkExcluirPainel  = '"excluirPainel(' . "'$idPainel')" . '"';
        $linkAssociarSetor    = '"associarSetorPainel(' . "'$idPainel##$codigoUnidade##$nomePainel##$nomeUnidade')" . '"';

        echo "<tr>
					<td align='center'>
						<i class='icofont icofont-edit nova_fonte' title='Editar registro do painel.' onclick=$linkEditarPainel></i>&nbsp;
						<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro do painel.' onclick=$linkExcluirPainel></i>&nbsp;
						<i class='icofont icofont-architecture-alt nova_fonte_blue' title='Associar setores de atendimento.' onclick=$linkAssociarSetor></i>
					</td>
					<td>$nomePainel</td>
          <td style='text-align:center'>$idPainel</td>
					<td>$nomeUnidade</td>
				</tr>";
      }
    }
    break;

  case "cadastro-painel-setor":
    $idPainelChamada    = $_POST['idPainelChamada'];
    $unidadeAtendimento = $_POST['unidadeAtendimento'];
    $setorPainel        = $_POST['setorPainel'];

    $stmExite = $rsConexao->prepare("SELECT * FROM reg_tb_painelchamada_setor WHERE (id_setoratendimento='$setorPainel') AND (id_painelchamada='$idPainelChamada')");
    $stmExite->execute();
    if ($stmExite->rowCount() > 0) {
      echo "JaExiste";
      exit;
    }

    $sqlPainelSetor = "INSERT INTO reg_tb_painelchamada_setor(
        id_painelchamada,
        id_setoratendimento,
        codigoestabelecimento_cnes
      )VALUES(
        :setIdPainel,
        :setSetorAtendimento,
        :setUnidadeAtendimento
      )";

    $stmSetorPainel = $rsConexao->prepare($sqlPainelSetor);
    $stmSetorPainel->bindParam(":setIdPainel", $idPainelChamada, PDO::PARAM_STR);
    $stmSetorPainel->bindParam(":setSetorAtendimento", $setorPainel, PDO::PARAM_STR);
    $stmSetorPainel->bindParam(":setUnidadeAtendimento", $unidadeAtendimento, PDO::PARAM_STR);
    $stmSetorPainel->execute();

    # -- carregar listagem atualizada -- #
    $sqlSetoresPainel = "SELECT reg_tb_painelchamada_setor.id_painelchamada_setor,
       ucase(reg_tb_setoratendimento.nome_setoratendimento) AS nomeSetor,
       reg_tb_painelchamada_setor.id_painelchamada
       FROM reg_tb_setoratendimento
       INNER JOIN reg_tb_painelchamada_setor ON (reg_tb_setoratendimento.id_setoratendimento = reg_tb_painelchamada_setor.id_setoratendimento)
       WHERE reg_tb_painelchamada_setor.id_painelchamada='$idPainelChamada' AND reg_tb_painelchamada_setor.codigoestabelecimento_cnes='$unidadeAtendimento'
       ORDER BY reg_tb_setoratendimento.nome_setoratendimento";
    $stmSetoresPainel  = $rsConexao->prepare($sqlSetoresPainel);
    $stmSetoresPainel->execute();
    $htmlRetornoListagem  = "";
    if ($stmSetoresPainel->rowCount() > 0) {
      $rsSetoresPainel  = $stmSetoresPainel->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsSetoresPainel as $fiedSetoresPainel) {
        $idSetorPainel    = $fiedSetoresPainel['id_painelchamada_setor'];
        $nomeSetor  = $fiedSetoresPainel['nomeSetor'];

        $linkExcluirSetorPainel  = '"excluirSetorPainel(' . "'$idSetorPainel')" . '"';

        echo "<tr>
            <td style='text-align:center; border:1px solid'>
              <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro do setor.' onclick=$linkExcluirSetorPainel></i>&nbsp;
            </td>
            <td style='border:1px solid'>$nomeSetor</td>
          </tr>";
      }
    } else {
      echo "<td colspan='2' style='text-align:center; border:1px solid'><b>Sem setor cadastrado...</b></td>";
    }
    break;

  case "gerar-senha-atendimento":
    $dataHoje               = date("Y-m-d");
    $unidadeLogada          = $_SESSION['unidadeLogada'];
    $idPaciente             = $_POST['idPaciente'];
    $explodeDataCadastro    = explode("/", $_POST['dataCadastro']);
    $dataCadastro           = $explodeDataCadastro[2] . '-' . $explodeDataCadastro[1] . '-' . $explodeDataCadastro[0];
    $dataHoraCadastro       = $dataCadastro . " " . $_POST['horaCadastro'];
    $setorAtendimento       = $_POST['setorAtendimento'];
    $tipoAtendimento        = $_POST['tipoAtendimento'];
    $observacaoAtendimento  = $_POST['observacaoAtendimento'];
    $numeroSenha            = 0;

    $sqlPegarUltimaSenha = "SELECT COUNT(id_painelchamada_senha) AS numeroSenha FROM reg_tb_painelchamada_senha 
    WHERE (codigoestabelecimento_cadastro='$unidadeLogada')
    AND(id_setoratendimento='$setorAtendimento')
    AND(tipo_atendimento='$tipoAtendimento')
    AND (date_format(datahora_cadastro,'%Y-%m-%d')='$dataCadastro')";
    $stmPegarUltimaSenha  = $rsConexao->prepare($sqlPegarUltimaSenha);
    $stmPegarUltimaSenha->execute();
    if ($stmPegarUltimaSenha->rowCount() == 0) {
      $numeroSenha = 1;
    } else {
      $numeroSenha = $numeroSenha + 1;
    }
    $numeroSenha  = str_pad($numeroSenha, 3, '0', STR_PAD_LEFT);
    $senhaGerada  = $tipoAtendimento == "N" ? "NOR$numeroSenha" : "PRI$numeroSenha";

    $sqlGerarSenha = "INSERT INTO reg_tb_painelchamada_senha(
    codigoestabelecimento_cadastro,
    id_cidadaopaciente,
    id_setoratendimento,    
    tipo_atendimento,
    datahora_cadastro,
    id_usuario_cadastrou,
    senha_atendimento,
    observacao
    )VALUES(
    :setEstabelecimentoCadastro,
    :setIdCidadaPaciente,
    :setSetorAtendimento,    
    :setTipoAtendimento,
    :setDataHoraCadastro,
    :setQuemCadastrou,
    :setSenhaAtendimento,
    :setObservacao)";

    $stmGerarSenha = $rsConexao->prepare($sqlGerarSenha);
    $stmGerarSenha->bindParam(":setEstabelecimentoCadastro", $unidadeLogada, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setIdCidadaPaciente", $idPaciente, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setSetorAtendimento", $setorAtendimento, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setTipoAtendimento", $tipoAtendimento, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setDataHoraCadastro", $dataHoraCadastro, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setQuemCadastrou", $idUsuarioLogado, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setSenhaAtendimento", $senhaGerada, PDO::PARAM_STR);
    $stmGerarSenha->bindParam(":setObservacao", $observacaoAtendimento, PDO::PARAM_STR);
    $stmGerarSenha->execute();

    $unidadeLogada = $_SESSION['unidadeLogada'];
    $unidadeLogada = $_SESSION['unidadeLogada'];
    $sqlSenhas = "SELECT reg_tb_painelchamada_senha.id_painelchamada_senha,
    reg_tb_painelchamada_senha.senha_atendimento,
    reg_tb_painelchamada_senha.tipo_atendimento,
    date_format(reg_tb_painelchamada_senha.datahora_cadastro,'%H:%i') AS horaCadastro,
    reg_tb_setoratendimento.nome_setoratendimento,
    reg_tb_painelchamada_senha.observacao
    FROM reg_tb_painelchamada_senha
    INNER JOIN reg_tb_setoratendimento ON (reg_tb_painelchamada_senha.id_setoratendimento = reg_tb_setoratendimento.id_setoratendimento)
    WHERE (reg_tb_painelchamada_senha.id_cidadaopaciente='$idPaciente')
    AND (date_format(datahora_cadastro,'%Y-%m-%d')='$dataHoje')
    AND (codigoestabelecimento_cadastro='$unidadeLogada')";
    $stmSenhas = $rsConexao->prepare($sqlSenhas);
    $stmSenhas->execute();
    if ($stmSenhas->rowCount() > 0) {
      $rsSenhas = $stmSenhas->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsSenhas as $fieldSenhas) {
        $idSenha      = $fieldSenhas['id_painelchamada_senha'];
        $senhaGerada  = $fieldSenhas['senha_atendimento'];
        $horaCadastro = $fieldSenhas['horaCadastro'];
        $setorSenha   = mb_strtoupper($fieldSenhas['nome_setoratendimento']);
        $tipoSenha    = $fieldSenhas['tipo_atendimento'] == "N" ? "NORMAL" : "PRIORIDADE";
        $observaSenha = mb_strtoupper($fieldSenhas['observacao']);

        $comandoImprimirSenha   = 'onClick="window.open(' . "'imprimir_senhapainel?ids=$idSenha')" . '"';
        $botaoComandoImpressao  = "<i class='icofont icofont-printer nova_fonte_blue' title='Imprimir senha.' $comandoImprimirSenha></i>&nbsp;";
        echo "<tr>
          <td align='center' style='padding:3px;'>
            <table style='width:100%;'>
              <tr>
                <td style='width:10px;font-size:12pt !important;background-color:transparent !important; border:1px !important'>
                  $botaoComandoImpressao
                </td>
                <td style='background-color:transparent !important; border:1px !important;font-size:12pt'>
                  <b>$senhaGerada</b>
                </td>
              </tr>
            </table>                                                  
          </td>
          <td align='center' style='font-size:10pt'>$horaCadastro</td>
          <td style='font-size:10pt'>$setorSenha</td>
          <td style='font-size:10pt'>$tipoSenha</td>
          <td>$observaSenha</td>
        </tr>";
      }
    }
    break;
}

?>