<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");
require("include/funcoes_gsaudereg.php");

$authorizationCode      = explode("#", base64_decode($_GET['authorization']));
$idAgenda               = $authorizationCode[0];

$arrayStatus  = array(
  "A" => "AGENDADO",
  "C" => "CANCELADO",
  "P" => "PENDENTE",
  "V" => "CONFIRMADO",
  "E" => "AGENDADO/ENTREGUE"
);
if ($idAgenda == 0 || $idAgenda == "") {
  $idUnidadeSaude         = $authorizationCode[1];
  $nomeUnidade            = $authorizationCode[2];
  $idProfissinoalSaude    = $authorizationCode[3];
  $nomeProfissinoalSaude  = str_replace("NAO ", "NÃO ", $authorizationCode[4]);
  $idGrupoProcedimento    = $authorizationCode[5];
  $nomeGrupoProcedimento  = str_replace("NAO ", "NÃO ", $authorizationCode[6]);
  $eGrupoSelecionado      = $authorizationCode[7];
  $idProcedimentoSel      = $authorizationCode[8];
  $nomeProcedimentoExibir = $eGrupoSelecionado == "SIM" ? "PROCEDIMENTO EM GRUPO" : $authorizationCode[9];
  $idMesAgenda            = $authorizationCode[10];
  $nomeMesAgenda          = $authorizationCode[11];
  $anoAgenda              = $authorizationCode[12];
  $horarioInicioAgenda    = "";
  $horarioFinalAgenda     = "";
  $intervaloQuebraHorario = "0";
  $mostarAbaGrupo         = $eGrupoSelecionado == "SIM" ? "style='display:block'" : "style='display:none'";
  $bloqueiaEdicaoMesAno   =  " disabled";
  $agendaReplicada        = "N";
  $agendaReplicadaSalva   = "S";
  $bloquearEdicao         = "";
  $selecionarGrupo        = "";
  $statusAgenda           = "";
  $disponibilidadeAgenda  = "";
  $exclusivoOCIAgenda     = "";
} else {
  $sqlAgenda  = "SELECT tb_estabelecimento.nfantasia_estabelecimento,
  tb_profissional.nome_profissional,
  reg_tb_procedimento_grupo.nome_grupo_procedimento,
  reg_tb_procedimento.nome_procedimento,
  reg_tb_agenda.codigoestabelecimento_cnes,
  reg_tb_agenda.codigoprofissional_cnes,
  reg_tb_agenda.id_grupo_procedimento,
  reg_tb_agenda.id_procedimento,
  reg_tb_agenda.mes_agenda,
  reg_tb_agenda.ano_agenda,
  reg_tb_agenda.horario_inicioagenda,
  reg_tb_agenda.horario_finalagenda,
  reg_tb_agenda.intervalo_quebrahorario,
  reg_tb_agenda.quebrar_horarioagenda,
  reg_tb_agenda.status_agenda,
  reg_tb_agenda.disponibilidade_agenda,
  reg_tb_agenda.exclusivo_oci,
  reg_tb_agenda.replicacao_salva,
  reg_tb_agenda.agenda_replicada
  FROM reg_tb_agenda
  LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_agenda.id_procedimento = reg_tb_procedimento.id_procedimento)
  INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
  INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
  INNER JOIN reg_tb_procedimento_grupo ON (reg_tb_agenda.id_grupo_procedimento = reg_tb_procedimento_grupo.id_grupo_procedimento)
  WHERE reg_tb_agenda.id_agenda='$idAgenda'";


  $stmAgenda  = $rsConexao->prepare($sqlAgenda);
  $stmAgenda->execute();
  $rsAgenda   = $stmAgenda->fetch(PDO::FETCH_OBJ);

  $idUnidadeSaude         = $rsAgenda->codigoestabelecimento_cnes;
  $nomeUnidade            = mb_strtoupper($rsAgenda->nfantasia_estabelecimento);
  $nomeProfissinoalSaude  = $rsAgenda->nome_profissional;
  $idProfissinoalSaude    = $rsAgenda->codigoprofissional_cnes;
  $idGrupoProcedimento    = $rsAgenda->id_grupo_procedimento;
  $nomeGrupoProcedimento  = $rsAgenda->nome_grupo_procedimento;
  $idProcedimentoSel      = $rsAgenda->id_procedimento;
  $eGrupoSelecionado      = $rsAgenda->id_procedimento == "" ? "SIM" : "NÃO";
  $nomeProcedimentoExibir = $eGrupoSelecionado == "SIM" ? "PROCEDIMENTO EM GRUPO" : $rsAgenda->nome_procedimento;
  $idMesAgenda            = $rsAgenda->mes_agenda;
  $nomeMesAgenda          = $gerarNomeMes[$rsAgenda->mes_agenda];
  $anoAgenda              = $rsAgenda->ano_agenda;
  $horarioInicioAgenda    = $rsAgenda->horario_inicioagenda;
  $horarioFinalAgenda     = $rsAgenda->horario_finalagenda;
  $intervaloQuebraHorario = $rsAgenda->intervalo_quebrahorario;
  $mostarAbaGrupo         = $eGrupoSelecionado == "SIM" ? "style='display:block'" : "style='display:none'";
  $selecionarGrupo        = $eGrupoSelecionado == "SIM" ? " checked" : "";
  $agendaReplicadaSalva   = $rsAgenda->replicacao_salva == "S" ? " disabled" : "";
  $statusAgenda           = $rsAgenda->status_agenda;
  $disponibilidadeAgenda  = $rsAgenda->disponibilidade_agenda;
  $exclusivoOCIAgenda     = $rsAgenda->exclusivo_oci;
}


# -- verificar se já existem agendamentos da agenda atual -- #
$stmAgendamento   = $rsConexao->prepare("SELECT COUNT(id_agendamento) AS totalAgendamento, tipo_vagaocupada FROM reg_tb_agendamentos WHERE id_agenda='$idAgenda'");
$stmAgendamento->execute();
$rsAgendamento    = $stmAgendamento->fetch(PDO::FETCH_OBJ);
$totalAgendamento = $rsAgendamento->totalAgendamento;
if ($totalAgendamento > 0) {
  $bloquearEdicao = " disabled";
} else {
  $bloquearEdicao = "";
}

//carregar lista de procedimentos do grupo
if ($eGrupoSelecionado == "SIM") {
  $resultadoHTML  = "";
  $sqlProcedimentoGrupo = "SELECT reg_tb_procedimento.nome_procedimento,
  reg_tb_procedimento.id_procedimento,
  reg_tb_procedimento.codigo_sus,
  format(reg_tb_procedimento.valor_vigente, 2, 'de_DE') AS valorProcedimento,
  reg_tb_tetounidade_grupoprocedimento.codigoestabelecimento_cnes
  FROM reg_tb_tetounidade_grupoprocedimento
  INNER JOIN reg_tb_procedimento ON (reg_tb_tetounidade_grupoprocedimento.id_procedimento = reg_tb_procedimento.id_procedimento)
  WHERE (reg_tb_tetounidade_grupoprocedimento.id_grupo_procedimento='$idGrupoProcedimento')
  AND (reg_tb_tetounidade_grupoprocedimento.codigoestabelecimento_cnes='$idUnidadeSaude')
  ORDER BY reg_tb_procedimento.nome_procedimento";

  $stmProcedimentosGrupo  = $rsConexao->prepare($sqlProcedimentoGrupo);
  $stmProcedimentosGrupo->execute();
  $bloquearSelecao        = $stmProcedimentosGrupo->rowCount() < 1 ? "disabled" : "";
  $contaProcedimentos     = 0;
  if ($stmProcedimentosGrupo->rowCount() > 0) {
    $rsProcedimentosGrupo   = $stmProcedimentosGrupo->fetchAll(PDO::FETCH_ASSOC);
    foreach ($rsProcedimentosGrupo as $fiedProcedimentosGrupo) {
      $contaProcedimentos = $contaProcedimentos + 1;
      $idProcedimento     = $fiedProcedimentosGrupo['id_procedimento'];
      $nomeProcedimento   = $fiedProcedimentosGrupo['nome_procedimento'];
      $codigoProcedimento = $fiedProcedimentosGrupo['codigo_sus'];
      $valorProcedimento  = $fiedProcedimentosGrupo['valorProcedimento'];
      $onChangeSelecionar = 'onchange="selecionaProcedimentosTodos(this.checked,' . "'individual')" . '"';

      #selecionar procedimentos adicionados caso seja edição da agenda --#
      if ($idAgenda != 0 && $idAgenda != "") {
        $stmProcedimentos = $rsConexao->prepare("SELECT id_procedimento FROM reg_tb_agenda_grupoprocedimento WHERE id_agenda='$idAgenda' AND id_procedimento='$idProcedimento'");
        $stmProcedimentos->execute();
        if ($stmProcedimentos->rowCount() > 0) {
          $selecionaProcedimento  = " checked";
        } else {
          $selecionaProcedimento  = "";
        }
      } else {
        $selecionaProcedimento  = "";
      }

      $resultadoHTML .= "<tr>
          <td align='center'>
            <input type='checkbox' id='procedimentoGrupo$contaProcedimentos' name='procedimentoGrupo[]' class='form-control checkbox-seleciona-procedimento-grupo' $onChangeSelecionar $selecionaProcedimento>
          </td>
          <td id='td-procedimentoGrupo$contaProcedimentos' style='display:none'>
            $idProcedimento
          </td>
          <td>
            $codigoProcedimento - $nomeProcedimento
          </td>
          <td id='valorUnitario$contaProcedimentos' style='display:none'>
            $valorProcedimento
          </td>
        </tr>";
    }
  }
  #selecionar o campo que indica seleção de todos os procedimentos do grupo --#
  if ($idAgenda != 0 && $idAgenda != "") {
    $stmProcedimentos = $rsConexao->prepare("SELECT COUNT(id_procedimento) as totalProcedimentos FROM reg_tb_agenda_grupoprocedimento WHERE id_agenda='$idAgenda'");
    $stmProcedimentos->execute();
    $rsProcedimentos  = $stmProcedimentos->fetch(PDO::FETCH_OBJ);
    if ($rsProcedimentos->totalProcedimentos == $contaProcedimentos) {
      $checkedTodosProcedimentos  = " checked";
    } else {
      $checkedTodosProcedimentos  = "";
    }
  } else {
    $checkedTodosProcedimentos  = "";
  }
} else {
  $bloquearSelecao            = "";
  $resultadoHTML              = "";
  $contaProcedimentos         = "";
  $checkedTodosProcedimentos  = "";
}
$anoMesAtual  = date("Y-m");
?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-edit" style='margin-top:-15px !important'></i>&nbsp;Configuração de Agendas
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <ul class="nav nav-tabs nav-topline">
                      <li class="nav-item">
                        <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> IDENTIFICAÇÃO DA AGENDA&nbsp;&nbsp;</b></a>
                      </li>
                      <li class="nav-item" id='aba-grupo' <?php echo $mostarAbaGrupo; ?>>
                        <a class="nav-link" id="base-procedimentosGrupo" data-toggle="tab" aria-controls="procedimentosGrupo" href="#procedimentosGrupo" aria-expanded="true"><b><i class='icofont icofont-stethoscope'></i> PROCEDIMENTOS&nbsp;&nbsp;</b></a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="base-pacientesAgendados" data-toggle="tab" aria-controls="pacientesAgendados" href="#pacientesAgendados" aria-expanded="true"><b><i class='icofont icofont-edit'></i> PACIENTES AGENDADOS&nbsp;&nbsp;</b></a>
                      </li>
                    </ul>
                    <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                      <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                        <form class="form">
                          <div class="form-body" style='margin-top:-10px'>
                            <h4 class="form-section"><i class="icofont icofont-info-circle"></i><b>Informações para Configuração</b></h4>
                            <input type="hidden" class="form-control" id="idAgenda" value="<?php echo $idAgenda; ?>">
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label for="unidadeSaude">Unidade de Saúde:</label>
                                  <input type="text" class="form-control" id="unidadeSaude" value="<?php echo rtrim($nomeUnidade); ?>" disabled>
                                </div>
                              </div>
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label for="profissinoalSaude">Profissional:</label>
                                  <input type="text" class="form-control" id="profissinoalSaude" value="<?php echo rtrim($nomeProfissinoalSaude); ?>" disabled>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="grupoProcedimento">Grupo:</label>
                                  <input type="text" class="form-control" id="grupoProcedimento" value="<?php echo $nomeGrupoProcedimento; ?>" disabled>
                                </div>
                              </div>
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="nomeProcedimento">Nome de Procedimento:</label>
                                  <input type="text" class="form-control" id="grupoProcedimento" value="<?php echo $nomeProcedimentoExibir; ?>" disabled>
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="mesAgenda">Mês da Agenda:</label>
                                  <input type="hidden" id="idMesAgenda" class="form-control" value="<?php echo $idMesAgenda; ?>">
                                  <select id="mesAgenda" class="form-control" onchange="gerarCalendarioReplica(this.value)" <?php echo $agendaReplicadaSalva; ?>>
                                    <option value=''>TODOS...</option>
                                    <?php
                                    for ($idMes = 1; $idMes <= 12; $idMes++) {
                                      $codigoMes = str_pad($idMes, 2, "0", STR_PAD_LEFT);
                                      $nomeMes  = $gerarNomeMes[$codigoMes];
                                      echo "<option value='$codigoMes'>$nomeMes</option>";
                                    }
                                    ?>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="anoAgenda">Ano:</label>
                                  <input type="number" class="form-control text-center" id="anoAgenda" value="<?php echo $anoAgenda; ?>" <?php echo $agendaReplicadaSalva; ?>>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="horaInicialAgenda">Horário Início:</label>
                                  <input type="time" class="form-control text-center" id="horaInicialAgenda" value="<?php echo $horarioInicioAgenda; ?>" <?php echo $bloquearEdicao; ?> onchange="$('#horaFinalAgenda').val(this.value)">
                                </div>
                              </div>
                              <div class="col-md-2" style="display:none;">
                                <div class="form-group">
                                  <label for="horaFinalAgenda">Horário Final:</label>
                                  <input type="time" class="form-control text-center" id="horaFinalAgenda" value="<?php echo $horarioFinalAgenda; ?>" <?php echo $bloquearEdicao; ?>>
                                </div>
                              </div>                              
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="quebraHorario">Quebrar Horário <font style='font-size:10pt; color: #0014c9'><b>(em minutos)</b>:</font></label>
                                  <input type="text" class="form-control text-center" value="<?php echo $intervaloQuebraHorario; ?>" id="quebraHorario" onkeypress="return somenteNumero()" <?php echo $bloquearEdicao; ?>>
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="statusAgenda">Status da Agenda:</label>
                                  <select id="statusAgenda" class="form-control">
                                    <option value=''>SELECIONE...</option>
                                    <option value='A'>ATIVA</option>
                                    <option value='I'>INATIVA</option>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="disponibilidadeAgenda">Disponibilidade:
                                    <i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover"
                                      data-content="A opção de disponibilidade da agenda permite dizer se a agenda estará disponível para todas as unidades agendadoras de referência, ou apenas para a própria unidade executora do serviço."
                                      data-trigger="hover" data-original-title="Disponibilidade da Agenda"></i>
                                  </label>
                                  <select id="disponibilidadeAgenda" class="form-control" <?php echo $bloquearEdicao;?>>
                                    <option value=''>SELECIONE...</option>
                                    <option value='G'>GERAL</option>
                                    <option value='L'>LOCAL</option>
                                  </select>
                                  <input type="hidden" id="disponibilidadeAgendaReserva" value="<?php echo $disponibilidadeAgenda; ?>">
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="exclusivoOCIAgenda">Exclusivo OCI:
                                    <i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover"
                                      data-content="Esta opção serve para destinar as vagas da agenda exclusivamente para atendimento de demandas de pacientes da Oferta de Cuidados Integrados-OCI."
                                      data-trigger="hover" data-original-title="Agenda Exclusiva para OCI"></i>
                                  </label>
                                  <select id="exclusivoOCIAgenda" class="form-control" <?php echo $bloquearEdicao;?>>
                                    <option value=''>SELECIONE...</option>
                                    <option value='S'>SIM</option>
                                    <option value='N'>NÃO</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top:-17px;">
                              <div class="col-md-12">
                                <div class="form-group">
                                  <div class="bs-callout-warning callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                    <div class="media align-items-stretch">
                                      <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                                        <i class="icofont icofont-info-circle white font-medium-5"></i>
                                      </div>
                                      <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                        <strong>Observação: Não havendo utilização de quebra de horário para agendamento digite zero ( 0 ).</strong>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top:-17px;">
                              <div class="col-md-12">
                                <div class="form-group">
                                  <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                    <div class="media align-items-stretch">
                                      <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                        <i class="icofont icofont-ui-close white font-medium-5"></i>
                                      </div>
                                      <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                        <strong>
                                          <font style='font-size:13pt'>Dias podem estar bloqueados por 4 motivos:</font><br>
                                          &#10033; Feriados - &#10033; Afastamento do Profissional - &#10033; Afastamento da Unidade - &#10033; Data Expirada
                                        </strong>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="form-body" style="margin-top: -15px;">
                            <h4 class="form-section" style="border-top: 1px dotted gray; padding: 0px !important" ;>
                              <i class="icofont icofont-calendar"></i><b>Dias de Atendimento</b>
                              <table style='margin-top:-40px; width:100%; display:none'>
                                <tr>
                                  <td class='tb-vagas-alocadas' id="textoVagasAlocadas">
                                    Total de vagas já alocadas:
                                  </td>
                                </tr>
                              </table>
                              <input type='hidden' id="totalVagasAlocadas">
                              <input type='hidden' id="totalVagasAlocadasReserva">
                            </h4>
                            <div class="row" style="margin-top: -15px;">
                              <div class="col-md-12">
                                <div class="form-group" id="dvCalendarioAgenda"></div>
                              </div>
                            </div>
                          </div><br><br><br>
                        </form>
                      </div>
                      <div class="tab-pane" id="procedimentosGrupo" aria-labelledby="base-procedimentosGrupo">
                        <form class="form">
                          <div class="form-body" style='margin-top:-10px'>
                            <h4 class="form-section">
                              <i class="icofont icofont-info-circle"></i>
                              <b>Procedimentos relacionados ao grupo (<?php echo $nomeGrupoProcedimento; ?>).</b>
                            </h4>
                            <table style='margin-top:-10px'>
                              <tr>
                                <td>
                                  <label style='color:#046B97; font-weight:bold'>Selecionar todos os procedimentos:</label>&nbsp;&nbsp;
                                </td>
                                <td>
                                  <input type="checkbox" id="chkProcedimentoTodos" class="form-control checkbox-seleciona-procedimento-grupo" style='margin-top:-5px' <?php echo $bloquearSelecao . ' ' . $checkedTodosProcedimentos; ?> onchange="selecionaProcedimentosTodos(this.checked,'todos')">
                                  <input type="checkbox" id="temProcedimentoSelecionado" style='display:none' <?php echo $selecionarGrupo; ?>>
                                </td>
                              </tr>
                            </table>
                          </div><br>
                          <div class="row" style="margin-top:-4px;">
                            <div class="col-md-12">
                              <div class="form-group">
                                <table class='table table-striped table-bordered' style='width:100%; margin-top:-13px' id="lista_procedimentos">
                                  <thead style='background-color:#046B97; color:#fff'>
                                    <tr>
                                      <th style="text-align:center; width:5%">SELECIONAR</th>
                                      <th style="text-align:center; width:5px; display:none">IDP</th>
                                      <th>PROCEDIMENTO</th>
                                    </tr>
                                  </thead>
                                  <tbody style="background-color: #ececec;">
                                    <?php
                                    echo $resultadoHTML;
                                    ?>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                        </form>
                      </div>
                      <div class="tab-pane" id="pacientesAgendados" aria-labelledby="base-pacientesAgendados">
                        <form class="form">
                          <div class="form-body" style='margin-top:-10px'>
                            <h4 class="form-section"><i class="icofont icofont-info-circle"></i><b>Relação de pacientes já agendados.</b></h4>
                          </div>
                          <div class="row" style="margin-top:-4px;">
                            <div class="col-md-12">
                              <div class="form-group">
                                <table class="table table-striped table-bordered default-ordering table-responsive-x" style='width:100%; margin-top:-13px' id="lista_agendamentos">
                                  <thead style='background-color:#046B97; color:#fff'>
                                    <tr>
                                      <th>PACIENTE</th>
                                      <th style="text-align:center;width:3%">CNS</th>
                                      <th>PROCEDIMENTO</th>
                                      <th style="text-align:center;width:6%">DATA AGENDAMENTO</th>
                                      <th style="text-align:center;width:6%">DATA ATENDIMENTO</th>
                                      <th style="text-align:center;width:6%">HORA ATENDIMENTO</th>
                                      <th style="text-align:center;width:3%">STATUS</th>
                                      <th style="text-align:center;width:6%">DATA SOLICITAÇÃO</th>
                                      <th style="text-align:center;width:6%">PROTOCOLO</th>
                                      <th style="text-align:center;width:6%">QUEM AGENDOU</th>
                                    </tr>
                                  </thead>
                                  <tbody style="background-color: #ececec;">
                                    <?php
                                    $sqlPacientesAgendados = "SELECT reg_tb_agendamentos.id_agenda,
                                      reg_tb_agendamentos.id_agendamento,
                                      ucase(tb_paciente.nome_paciente) AS nomePaciente,
                                      tb_paciente.cns_paciente,
                                      ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
                                      date_format(reg_tb_agendamentos.datahora_agendamento,'%d/%m/%Y') AS dataAgendamento,
                                      date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
                                      reg_tb_agendamentos.horario_atendimento,
                                      reg_tb_agendamentos.status_agendamento,
                                      date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y') AS dataSolicitacao,
                                      reg_tb_solicitacoes.numero_procotolo,
                                      reg_tb_agendamentos.protocolo_agendamento,
                                      ucase(reg_tb_usuario.nome_usuario) AS quemAgendou
                                      FROM reg_tb_agendamentos
                                      LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento)
                                      INNER JOIN reg_tb_usuario ON (reg_tb_agendamentos.id_usuario_agendou = reg_tb_usuario.id_usuario)
                                      LEFT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_agendamentos.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
                                      INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
                                      WHERE (reg_tb_agendamentos.id_agenda='$idAgenda')";
                                    $stmPacientesAgendados  = $rsConexao->prepare($sqlPacientesAgendados);
                                    $stmPacientesAgendados->execute();
                                    if ($stmPacientesAgendados->rowCount() > 0) {
                                      $rsPacientesAgendados = $stmPacientesAgendados->fetchAll(PDO::FETCH_ASSOC);
                                      foreach ($rsPacientesAgendados as $fieldAgendamento) {
                                        $idAgendamento      = $fieldAgendamento['id_agendamento'];
                                        $nomePaciente       = $fieldAgendamento['nomePaciente'];
                                        $cnsPaciente        = $fieldAgendamento['cns_paciente'];
                                        $nomeProcedimento   = $fieldAgendamento['nomeProcedimento'] != "" ? $fieldAgendamento['nomeProcedimento'] : "EXAMES DE LABORATÓRIO";
                                        $dataAgendamento    = $fieldAgendamento['dataAgendamento'];
                                        $dataAtendimento    = $fieldAgendamento['dataAtendimento'];
                                        $horaAtendimento    = $fieldAgendamento['horario_atendimento'];
                                        $statusAgendamento  = $arrayStatus[$fieldAgendamento['status_agendamento']];
                                        $dataSolicitacao    = $fieldAgendamento['dataSolicitacao'];
                                        $numeroProcotolo    = $fieldAgendamento['numero_procotolo'] != "" ? $fieldAgendamento['numero_procotolo'] : $fieldAgendamento['protocolo_agendamento'];
                                        $quemAgendou        = $fieldAgendamento['quemAgendou'];
                                        # -- comando para impressão da marcação do sistema -- #
                                        if ($statusAgendamento == "AGENDADO" || $statusAgendamento == "PENDENTE") {
                                          $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG')" . '"';
                                          $botaoImprimirAgendamento   = "<i class='icofont icofont-printer nova_fonte' style='font-size:10pt' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                        } else {
                                          $botaoImprimirAgendamento   = "";
                                        }
                                        # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #

                                        echo "<tr>
                                            <td style='padding-left:3px !important'>
                                              $botaoImprimirAgendamento&nbsp;
                                              $nomePaciente
                                            </td>
                                            <td align='center'>$cnsPaciente</td>
                                            <td>$nomeProcedimento</td>
                                            <td align='center'>$dataAgendamento</td>
                                            <td align='center'>$dataAtendimento</td>
                                            <td align='center'>$horaAtendimento</td>
                                            <td align='center'>$statusAgendamento</td>
                                            <td align='center'>$dataSolicitacao</td>
                                            <td align='center'>$numeroProcotolo</td>
                                            <td>$quemAgendou</td>
                                          </tr>";
                                      }
                                    }
                                    ?>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante" style='margin-left:-150px'>
  <table>
    <tr>
      <td style='padding-right:10px; border-right: dotted 1px gray'>
        <button type="button" class="btn btn-blue" onClick="gravarAgenda()" id="btnGravarAgenda"><i class="icofont icofont-checked"></i> Salvar Agenda</button>
        <button type="button" class="btn btn-green" onClick="replicarAgenda()" id="btnReplicarAgenda"><i class="icofont icofont-meeting-add"></i> Replicar Agenda</button>
      </td>
      <td style='padding-left:10px;'>
        <button type="button" class="btn btn-danger" onClick="window.close()" id="btnFecharJanela"><i class="icofont icofont-exit"></i> Fechar Janela</button>
      </td>
    </tr>
  </table>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>
<script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.4.0/moment.min.js"></script>

<script>
  $("#liAgendaConfigurar").attr('class', 'active');
  $("#liAgendaConfigurar").css("border-bottom", "2px solid #c4c8ca");



  $("#mesAgenda").change(function() {
    $("#idMesAgenda").val(this.value);
    claudio
    var idAgenda = $("#idAgenda").val();
    var idUnidadeSaude = "<?php echo $idUnidadeSaude; ?>";
    var idProfissinoalSaude = "<?php echo $idProfissinoalSaude; ?>";
    var idGrupoProcedimento = "<?php echo $idGrupoProcedimento; ?>";
    var idProcedimento = "<?php echo $idProcedimentoSel; ?>";
    var idMesAgenda = $("#idMesAgenda").val();
    var anoAgenda = this.value;
    gerarCalendarioAgenda(idAgenda, idUnidadeSaude, idProfissinoalSaude, idGrupoProcedimento, idProcedimento, idMesAgenda, anoAgenda);
  })

  $("#anoAgenda").blur(function() {
    var idAgenda = $("#idAgenda").val();
    var idUnidadeSaude = "<?php echo $idUnidadeSaude; ?>";
    var idProfissinoalSaude = "<?php echo $idProfissinoalSaude; ?>";
    var idGrupoProcedimento = "<?php echo $idGrupoProcedimento; ?>";
    var idProcedimento = "<?php echo $idProcedimentoSel; ?>";
    var idMesAgenda = $("#idMesAgenda").val();
    var anoAgenda = this.value;
    gerarCalendarioAgenda(idAgenda, idUnidadeSaude, idProfissinoalSaude, idGrupoProcedimento, idProcedimento, idMesAgenda, anoAgenda);
  });

  function selecionaProcedimentosTodos(selecionarTodos, OpValidador) {

    var contaProcedimentos = "<?php echo $contaProcedimentos; ?>";
    var itemSelecao = 0;
    switch (OpValidador) {
      case "todos":
        for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
          $("#procedimentoGrupo" + itemSelecao).prop("checked", selecionarTodos);
          $("#temProcedimentoSelecionado").prop("checked", selecionarTodos);
        }
        break;
      case "individual":
        var temProcedimentoSel = false;
        var totalSelecionado = 0;

        $("#temProcedimentoSelecionado").prop("checked", false);
        for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
          temProcedimentoSel = $("#procedimentoGrupo" + itemSelecao).is(":checked");
          if (temProcedimentoSel == true) {
            totalSelecionado = totalSelecionado + 1;
            $("#temProcedimentoSelecionado").prop("checked", temProcedimentoSel);
          }
        }
        if (parseInt(totalSelecionado) == parseInt(contaProcedimentos)) {
          $("#chkProcedimentoTodos").prop("checked", true);
        } else {
          $("#chkProcedimentoTodos").prop("checked", false);
        }
        break;
    }
  }

  function gerarCalendarioAgenda(idAgenda, idUnidadeSaude, idProfissinoalSaude, idGrupoProcedimento, idProcedimento, idMesAgenda, anoAgenda) {

    $("#processandoDados").html("Carregando calendário...");
    $("#embacado").css('display', 'block')
    $.ajax({
      url: 'agenda_calendario',
      type: 'post',
      dataType: 'html',
      data: {
        'idAgenda': idAgenda,
        'idUnidadeSaude': idUnidadeSaude,
        'idProfissinoalSaude': idProfissinoalSaude,
        'idGrupoProcedimento': idGrupoProcedimento,
        'idProcedimento': idProcedimento,
        'idMesAgenda': idMesAgenda,
        'anoAgenda': anoAgenda
      }
    }).done(function(resultadoRetorno) {
      $("#dvCalendarioAgenda").html(resultadoRetorno);
      $("#embacado").css('display', 'none')
      $("#processandoDados").html("Aguarde! Processando dados...");
    });
  }

  setTimeout(function() {
    var idAgenda = $("#idAgenda").val();
    var idUnidadeSaude = "<?php echo $idUnidadeSaude; ?>";
    var idProfissinoalSaude = "<?php echo $idProfissinoalSaude; ?>";
    var idGrupoProcedimento = "<?php echo $idGrupoProcedimento; ?>";
    var idProcedimento = "<?php echo $idProcedimentoSel; ?>";
    var idMesAgenda = $("#idMesAgenda").val();
    var anoAgenda = "<?php echo $anoAgenda; ?>";
    gerarCalendarioAgenda(idAgenda, idUnidadeSaude, idProfissinoalSaude, idGrupoProcedimento, idProcedimento, idMesAgenda, anoAgenda);
  }, 400);

  function somenteNumero(getEvento) {
    var oEvento = getEvento || window.event;
    x
    var chaveEvento = oEvento.keyCode || oEvento.which;
    chaveEvento = String.fromCharCode(chaveEvento);

    var expressaoEvento = /^[0-9.]+$/;
    if (!expressaoEvento.test(chaveEvento)) {
      expressaoEvento.returnValue = false;
      if (oEvento.preventDefault) oEvento.preventDefault();
    }
  }

  function validaAlteracaoQuantidade(valorDigitado, diaReferencia) {

    $.ajax({
      url: 'filtros/filtrar_agendamentos_agenda',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoFiltro': 'comparar-agendados-alteracao-agenda',
        'idAgenda': $("#idAgenda").val(),
        'diaReferencia': diaReferencia
      }
    }).done(function(resultadoRetorno) {
      if ((parseInt(resultadoRetorno) > parseInt(valorDigitado)) && valorDigitado != "") {
        $("#btnGravarAgenda").prop('disabled', true);
        swal("Não Autorizado", "A quantidade de vagas para alteração não pode ser inferior a quantidade de pacientes já agendados para este dia.", "error");
      }
    });

  }

  function calcularVagasAlocadas(idCampo) {

    //pegar vagas de primeiravez
    totalVagasAlocadas = 0;
    totalVagasAlocadasPVez = 0;
    totalVagasAlocadasRet = 0;
    totalVagasAlocadasRes = 0;
    $("input[name='numeroVagasPVez[]']").each(function() {
      if ($(this).val() != '' && $(this).val() != 0 && this.id == idCampo) {
        totalVagasAlocadasPVez = totalVagasAlocadasPVez + parseInt($(this).val());
        totalVagasAlocadas = totalVagasAlocadas + totalVagasAlocadasPVez;
      }
    });

    //pegar vagas de retorno
    $("input[name='numeroVagasRetorno[]']").each(function() {
      if ($(this).val() != '' && $(this).val() != 0 && this.id == idCampo) {
        totalVagasAlocadasRet = totalVagasAlocadasRet + parseInt($(this).val());
        totalVagasAlocadas = totalVagasAlocadas + totalVagasAlocadasRet;
      }
    });

    //pegar vagas de retorno
    $("input[name='numeroVagasReserva[]']").each(function() {
      if ($(this).val() != '' && $(this).val() != 0 && this.id == idCampo) {
        totalVagasAlocadasRes = totalVagasAlocadasRes + parseInt($(this).val());
        totalVagasAlocadas = totalVagasAlocadas + totalVagasAlocadasRes;
      }
    })

    $("#textoVagasAlocadas").html("Total de vagas já alocadas: " + totalVagasAlocadas);
    $("#totalVagasAlocadas").val(0);

  }

  function gravarAgenda() {

    var idAgenda = $("#idAgenda").val();
    var idUnidadeSaude = "<?php echo $idUnidadeSaude; ?>";
    var idProfissinoalSaude = "<?php echo $idProfissinoalSaude; ?>";
    var idGrupoProcedimento = "<?php echo $idGrupoProcedimento; ?>";
    var idProcedimentoSel = "<?php echo $idProcedimentoSel; ?>";
    var idMesAgenda = $("#idMesAgenda").val();
    var anoAgenda = $("#anoAgenda").val();
    var temProcedimentoSel = $("#temProcedimentoSelecionado").is(":checked");
    var horaInicialAgenda = $("#horaInicialAgenda").val();
    var quebraHorario = $("#quebraHorario").val();
    var disponibilidadeAgenda = $("#disponibilidadeAgenda").val();
    var exclusivoOCIAgenda = $("#exclusivoOCIAgenda").val();

    if (horaInicialAgenda == "") {
      swal("Horário da Agenda", "Você deve preencher horário de início do atendimento.", "error");
      return false;
    }

    if ($("#statusAgenda").val() == "") {
      swal("Status da Agenda", "Você deve informar o status da agenda.", "error");
      return false;
    }

    if ($("#disponibilidadeAgenda").val() == "") {
      swal("Disponibilidade da Agenda", "Você deve selecionar a disponibilidade da agenda. Local ou Geral?", "error");
      return false;
    }
    
    if ($("#exclusivoOCIAgenda").val() == "") {
      swal("Exclusividade de OCI", "Você deve informar SIM ou NÃO para dizer se a agenda é exclusiva de OCI.", "error");
      return false;
    }    

    var digitouPVez = false;
    var digitouRetorno = false;
    var digitouReserva = false;

    var quantidadeVagasPVez = new Array();
    var quantidadeVagasRetorno = new Array();
    var quantidadeVagasReserva = new Array();

    var recebeMaiorPVez = new Array();
    var recebeMaiorRetorno = new Array();
    var recebeMaiorReserva = new Array();
    var maiorValorPVez = 0;
    var maiorValorRetorno = 0;
    var maiorValorReserva = 0;
    var mostrarMaiorValor = new Array();


    //pegar vagas de primeiravez
    var vagasPVezDigitadas = 0;
    $("input[name='numeroVagasPVez[]']").each(function() {
      vagasPVezDigitadas = $(this).val() != "" ? $(this).val() : 0;
      quantidadeVagasPVez.push($(this).attr('id') + '#' + vagasPVezDigitadas);
      if ($(this).val() != '' && $(this).val() != 0) {
        digitouPVez = true;
        recebeMaiorPVez.push($(this).val());
        maiorValorPVez = Math.max.apply(null, recebeMaiorPVez);
      }
    });

    //pegar vagas de retorno
    var vagasRetornoDigitadas = 0;
    $("input[name='numeroVagasRetorno[]']").each(function() {
      vagasRetornoDigitadas = $(this).val() != "" ? $(this).val() : 0;
      quantidadeVagasRetorno.push($(this).attr('id') + '#' + vagasRetornoDigitadas);
      if ($(this).val() != '' && $(this).val() != 0) {
        digitouRetorno = true;
        recebeMaiorRetorno.push($(this).val());
        maiorValorRetorno = Math.max.apply(null, recebeMaiorRetorno);
      }
    });

    //pegar vagas de reserva
    var vagasReservaDigitadas = 0;
    $("input[name='numeroVagasReserva[]']").each(function() {
      vagasReservaDigitadas = $(this).val() != "" ? $(this).val() : 0;
      quantidadeVagasReserva.push($(this).attr('id') + '#' + vagasReservaDigitadas);
      if ($(this).val() != '' && $(this).val() != 0) {
        digitouReserva = true;
        recebeMaiorReserva.push($(this).val());
        maiorValorReserva = Math.max.apply(null, recebeMaiorReserva);
      }
    });

    // valida digitação de quantitativos válidos de vagas
    if (digitouPVez == false && digitouRetorno == false && digitouReserva == false) {
      swal("Oferta de Vagas", "Você não digitou nenhum quantitativo de vagas a serem ofertados na agenda.", "error");
      return false;
    }

    // valida seleção de procedimentos para agenda em grupo.
    var agendaDeGrupo = "<?php echo $eGrupoSelecionado; ?>";
    if (agendaDeGrupo == "SIM" && temProcedimentoSel == false) {
      swal("Grupo de Procedimentos", "Esta é uma agenda de grupo de procedimentos, e você não selecionou nenhum procedimento para inclusão desta agenda. Utilize a aba PROCEDIMENTOS para selecioná-los.", "error");
      return false;
    }

    // valida alocação de vagas
    /*if ($("#totalVagasAlocadas").val() == "" || $("#totalVagasAlocadas").val() == 0) {
      swal("Vagas Alocadas", "Não foram alocadas vagas gesta agebda. Informe a programação de vagas disponíveis!", "error");
      return false;
    }*/

    // valida vagas distribuída com quebra de horário    
    /*if ($("#quebraHorario").val() != "" && $("#quebraHorario").val() != 0) {

      var totalVagasAlocadas = parseInt($("#totalVagasAlocadas").val());
      
      /*
      var miliSegundos = moment(horaFinalAgenda, "HH:mm").diff(moment(horaInicialAgenda, "HH:mm"));
      var totalMinutos = (miliSegundos / 60000);
      var calculaVagasNoTempo = parseInt(totalMinutos / quebraHorario);

      if (quebraHorario > totalMinutos) {
        swal("Quebra de Horário", "A quantidade de minutos para quebra de horário é maior do que o intervalo informado.", "error");
        return false;
      }
      

      mostrarMaiorValor.push(maiorValorPVez);
      mostrarMaiorValor.push(maiorValorRetorno);
      mostrarMaiorValor.push(maiorValorReserva);
      maiorValorMensagem = Math.max.apply(null, mostrarMaiorValor);
      if (maiorValorMensagem > calculaVagasNoTempo) {
        swal("Tempo Insuficiente", "O intervalo de tempo destinado para a agenda com quebra de horário de " + quebraHorario + " minutos não é suficiente para atendimento  " + maiorValorMensagem + " vagas. Retifique sua agenda!", "error");
        return false;
      }
    }*/

    // pegar procedimentos do grupo
    if (agendaDeGrupo == "SIM") {
      var itemSelecao = 0;
      var temProcedimentoSel = false;
      var arrayProcedimento = new Array();
      var contaProcedimentos = parseInt("<?php echo $contaProcedimentos; ?>");
      for (itemSelecao = 1; itemSelecao <= contaProcedimentos; itemSelecao++) {
        temProcedimentoSel = $("#procedimentoGrupo" + itemSelecao).is(":checked");
        if (temProcedimentoSel == true) {
          arrayProcedimento.push(parseInt($("#td-procedimentoGrupo" + itemSelecao).html()));
        }
        temProcedimentoSel = false;
      }
    } else {
      arrayProcedimento = "";
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_agenda',
      type: 'post',
      dataType: 'html',
      data: {
        'idAgenda': $("#idAgenda").val(),
        'idUnidadeSaude': "<?php echo $idUnidadeSaude; ?>",
        'idProfissinoalSaude': "<?php echo $idProfissinoalSaude; ?>",
        'idGrupoProcedimento': "<?php echo $idGrupoProcedimento; ?>",
        'eGrupoSelecionado': "<?php echo $eGrupoSelecionado; ?>",
        'idProcedimento': "<?php echo $idProcedimentoSel; ?>",
        'idMesAgenda': $("#idMesAgenda").val(),
        'anoAgenda': $("#anoAgenda").val(),
        'horaInicialAgenda': $("#horaInicialAgenda").val(),
        'horaFinalAgenda': $("#horaFinalAgenda").val(),
        'quebraHorario': $("#quebraHorario").val(),
        'quantidadeVagasPVez': quantidadeVagasPVez,
        'quantidadeVagasRetorno': quantidadeVagasRetorno,
        'quantidadeVagasReserva': quantidadeVagasReserva,
        'statusAgenda': $("#statusAgenda").val(),
        'arrayProcedimento': arrayProcedimento,
        'totalVagasAlocadas': $("#totalVagasAlocadas").val(),
        'disponibilidadeAgenda': disponibilidadeAgenda,
        'exclusivoOCIAgenda' : exclusivoOCIAgenda
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      $("#idAgenda").val(resultadoRetorno);
      swal("Cadastro de Agenda", "Agenda de profissional cadastrada com sucesso.", "success");
    });

  }

  function replicarAgenda() {

    Swal.fire({
      title: "Replicar Agenda",
      html: "Esta ação irá criar uma cópia desta agenda. <b>Confirma?</b>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/gravar_agenda_replica',
          type: 'post',
          dataType: 'html',
          data: {
            'idAgenda': $("#idAgenda").val()
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          var concatenaConteudoEncode = btoa(resultadoRetorno + "#REGULAÇÃO AMBULATORIAL-PROFISSIONAL DE SAÚDE-UNIDADE DE SAÚDE");
          window.location.href = "agenda_configurar?authorization=" + concatenaConteudoEncode;
        });
      }
    });
  }

  function gerarCalendarioReplica(idMes) {
    var idAgenda = $("#idAgenda").val();
    var idUnidadeSaude = "<?php echo $idUnidadeSaude; ?>";
    var idProfissinoalSaude = "<?php echo $idProfissinoalSaude; ?>";
    var idGrupoProcedimento = "<?php echo $idGrupoProcedimento; ?>";
    var idProcedimento = "<?php echo $idProcedimentoSel; ?>";
    var idMesAgenda = idMes;
    var anoAgenda = "<?php echo $anoAgenda; ?>";
    gerarCalendarioAgenda(idAgenda, idUnidadeSaude, idProfissinoalSaude, idGrupoProcedimento, idProcedimento, idMesAgenda, anoAgenda);
  }

  // ATRIBUIR VALORES DE COMBO SELECT //
  $("#mesAgenda").val("<?php echo $idMesAgenda; ?>");

  $("#base-pacientesAgendados").click(function() {
    $(".barra-flutuante").css("display", "none");
  })
  $("#base-dadosSolicitacao").click(function() {
    $(".barra-flutuante").css("display", "block");
  })
  $("#base-procedimentosGrupo").click(function() {
    $(".barra-flutuante").css("display", "block");
  })

  /* Exibe mensagem de não permissão de agendamentos */
  var totalAgendamento = "<?php echo $totalAgendamento; ?>";
  var eGrupoSelecionado = "<?php echo $eGrupoSelecionado; ?>";

  if (totalAgendamento > 0) {
    //if(eGrupoSelecionado=="SIM"){
    $("#btnGravarAgenda").prop("disabled", true);
    //}
    swal("Alterações Bloqueadas", "Esta agenda já possui pacientes agendados. Sendo assim, não é permitido realizar qualquer tipo de alteração.", "warning");
  }

  $("#statusAgenda").change(function() {
    var idAgenda = $("#idAgenda").val();
    if (this.value != "" && idAgenda != "" && idAgenda != "0") {
      var anoMesAgenda = $("#anoAgenda").val() + '-' + $("#idMesAgenda").val();
      var anoMesAtual = "<?php echo $anoMesAtual; ?>";
      if ((anoMesAgenda < anoMesAtual) && (this.value == "A")) {
        swal("Status da Agenda", "Não é possível ativar uma agenda de anterior ao mês atual.", "error");
        return false;
      }

      var mensagemStatus = this.value == "A" ? "Agenda ativada com sucesso." : "Agenda desativada com sucesso.";
      $.ajax({
        url: 'action/atualizar_agenda_status',
        type: 'post',
        dataType: 'html',
        data: {
          'idAgenda': $("#idAgenda").val(),
          'statusAgenda': this.value
        }
      }).done(function(resultadoRetorno) {
        swal("Status da Agenda", mensagemStatus, "success");
      });
    }
  });

  $("#disponibilidadeAgenda").change(function() {
    var valorDisponibilidade = $("#disponibilidadeAgendaReserva").val();
    var txtMensagem = "";
    if ($("#idAgenda").val() != "" && $("#idAgenda").val()!=0) {
      if (this.value == "G") {
        txtMensagem = "Atenção! Alterar a disponibilidade para GERAL, permitirá que agendadores de qualquer unidade referenciada possa visualizá-la. <b>Confirma?</b>";
      } else {
        txtMensagem = "Atenção! Alterar a disponibilidade para LOCAL, fará com que apenas agendadores desta unidade possa visualizá-la. <b>Confirma?</b>";
      }
      var setValorDisponibilidade =this.value;
      Swal.fire({
        title: "Disponibilidade da Agenda",
        html: "<p style='text-align:justify'>"+txtMensagem+"</p>",
        type: "question",
        showCancelButton: !0,
        confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
        confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
        cancelButtonText: "<i class='fa fa-times'></i> Não",
        cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
        buttonsStyling: !1,
      }).then(function(retornoComando) {
        if (retornoComando.value) {          
          $.ajax({
            url: 'action/atualizar_agenda_disponibilidade',
            type: 'post',
            dataType: 'html',
            data: {
              'idAgenda': $("#idAgenda").val(),
              'valorDisponibilidade': setValorDisponibilidade
            }
          }).done(function(resultadoRetorno) {
            swal("Disponibilidade da Agenda", "Disponibilidade alterada com sucesso", "success");
          });
        }else{
          $("#disponibilidadeAgenda").val($("#disponibilidadeAgendaReserva").val());
        }
      });

    }
  });

  function aplicarCorVallor(idCampo) {
    if ($("#" + idCampo).val() != "" && parseInt($("#" + idCampo).val()) != 0) {
      $("#" + idCampo).css("background-color", "#d1ffed");
    } else {
      $("#" + idCampo).css("background-color", "#fff");
    }
  }

  $("#statusAgenda").val("<?php echo $statusAgenda; ?>");
  $("#disponibilidadeAgenda").val("<?php echo $disponibilidadeAgenda; ?>");
  $("#exclusivoOCIAgenda").val("<?php echo $exclusivoOCIAgenda;?>");
</script>