<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];

$idPacienteGet  = $_GET['idpac'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade          = $rsPaciente->codigocidade;

$formatarOrigem = array(
  'lista_unica'   => 'LISTA ÚNICA',
  'policlinica'   => 'POLICLÍNICA',
  'sisreg'        => 'SISREG',
  'sistema_vida'  => 'VIDA+'
);

$idAgendamento    = $_GET['idag'];
$sqlAgendamento  = "SELECT *, 
date_format(datahora_agendamento,'%d/%m/%Y - %H:%i') AS dataHoraAgendamento, 
date_format(datahora_solicitoucancelamento,'%d/%m/%Y - %H:%i') AS dataHoraPedidoCancelamento,
reg_tb_procedimento.nome_procedimento, 
reg_tb_usuario.nome_usuario AS quemSolicitouCancelamento, 
tb_estabelecimento.nfantasia_estabelecimento,
date_format(dataprazo_retirada,'%d/%m/%Y') AS prazoRetirada, 
reg_tb_agendamentos.origem_agendamento FROM reg_tb_agendamentos
INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
LEFT OUTER JOIN reg_tb_usuario ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_solicitoucancelamento)
LEFT OUTER JOIN reg_tb_usuario_perfil ON (reg_tb_usuario.id_usuario = reg_tb_usuario_perfil.id_usuarioperfil)
LEFT OUTER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_usuario_perfil.id_unidadeassociada)
WHERE id_agendamento='$idAgendamento'";


$stmAgendamento  = $rsConexao->prepare($sqlAgendamento);
$stmAgendamento->execute();
$rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);

$numeroProtocolo            = $rsAgendamento->protocolo_agendamento;
$dataHoraAgendamento        = $rsAgendamento->dataHoraAgendamento;
$dataHoraPedidoCancelamento = $rsAgendamento->dataHoraPedidoCancelamento == "" ? "NÃO INFORMADO" : $rsAgendamento->dataHoraPedidoCancelamento;
$nomeProcedimento           = $rsAgendamento->nome_procedimento;
$idProcedimento             = $rsAgendamento->id_procedimento;
$justificativaAgendamentoCancelamento  = $rsAgendamento->justificativa_solicitacaocancelamento;
$informacoesCancelamento    = $rsAgendamento->informacoes_cancelamento;
$observacoesProcedimento    = $rsAgendamento->observacao_procedimento;
$tipoVagaOcupada            = $rsAgendamento->tipo_vagaocupada;
$idAgendaSub                = $rsAgendamento->id_agenda_sub;
$habilitaClassificacao      = $idPerfilLogado != "7" && $idPerfilLogado != "8" && $idPerfilLogado != "1"  ? " disabled" : "";
$quemSolicitouCancelamento  = $rsAgendamento->quemSolicitouCancelamento == "" ? "NÃO INFORMADO" : $rsAgendamento->quemSolicitouCancelamento . " (" . $rsAgendamento->nome_unidade . ")";
$prazoRetirada              = $rsAgendamento->prazoRetirada;

if ($rsAgendamento->prazoRetirada != "" && ($rsAgendamento->dataprazo_retirada < date("Y-m-d"))) {
  $prazoVencido = "style='background-color:#860000; color: #fff'";
  $complementoJustificativaAgendamento  = " - (PRAZO PARA RETIRADA VENCEU)";
} else {
  $prazoVencido = "";
  $complementoJustificativaAgendamento  = "";
}

if ($rsAgendamento->tipo_vagaocupada == "PVEZ" || $rsAgendamento->tipo_vagaocupada == "RETORNO" || $rsAgendamento->tipo_vagaocupada == "RESERVA") {
  $origemAgendamento = $rsAgendamento->tipo_vagaocupada == "PVEZ" ? "VAGA SISTEMA - PRIMEIRA VEZ" : "VAGA SISTEMA - " . $rsAgendamento->tipo_vagaocupada;
} else {
  $origemAgendamento = "VAGA EXTERNA - " . $rsAgendamento->tipo_vagaocupada;
}

$dataHoraRegistroCancelamento   = date("d/m/Y H:i");

if ($justificativaAgendamentoCancelamento == "") {
  $mostrarJustificativaCancelamento =  " display:none";
  $mostrarNovaJusticiativa          =  "style='display:block'";
} else {
  $mostrarJustificativaCancelamento =  "";
  $mostrarNovaJusticiativa          =  "style='display:none'";
}

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-close-squared-alt" style='margin-top:-15px !important'></i>&nbsp;Cancelar Agendamento Avulso
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                      <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                      <input type="hidden" id="idAgendamento" value="<?php echo $idAgendamento; ?>" />
                    </h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cpfPaciente">CPF:</label>
                          <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cnsPaciente">Cartão SUS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body" style="margin-top: -15px;">
                    <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="dataSolicitacao">Data/Hora Agendamento:</label>
                          <input type="text" class="form-control text-center" id="dataSolicitacao" value="<?php echo $dataHoraAgendamento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="numeroProtocolo">Nº Protocolo:</label>
                          <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="nomeProcedimento">Nome de Procedimentos:</label>
                          <input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="prazoRetirada">Prazo Retirada:</label>
                          <input type="text" class="form-control text-center" id="prazoRetirada" value="<?php echo $prazoRetirada; ?>" <?php echo $prazoVencido; ?> disabled />
                        </div>
                      </div>
                    </div>
                    <div class="form-body" style="background-color:#d2e2e9; margin-top:-10px">
                      <h4 class="form-section"><i class="icofont icofont-edit"></i><b>Dados do Cancelamento</b></h4>
                      <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                        <div class="col-md-4">
                          <div class="form-group">
                            <label for="dataRegistroCancelamento"><b>Data/Hora do Registro:</b></label>
                            <input type="text" id="dataRegistroCancelamento" class="form-control text-center" value="<?php echo $dataHoraRegistroCancelamento; ?>" disabled />
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <label for="origemAgendamento"><b>Origem do Agendamento:</b></label>
                            <input type="text" id="origemAgendamento" class="form-control text-center" value="<?php echo $origemAgendamento; ?>" disabled />
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <label for="dataHoraSolicitacaoCancelamento"><b>Data/Hora do Pedido:</b></label>
                            <input type="text" id="dataHoraSolicitacaoCancelamento" class="form-control text-center" value="<?php echo $dataHoraPedidoCancelamento; ?>" disabled />
                          </div>
                        </div>
                      </div>
                      <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                        <div class="col-md-12">
                          <div class="form-group">
                            <label for="quemSolicitouCancelamento"><b>Quem Solicitou/Registrou:</b></label>
                            <input type="text" id="quemSolicitouCancelamento" class="form-control" value="<?php echo $quemSolicitouCancelamento; ?>" disabled />
                          </div>
                        </div>
                      </div>
                      <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                        <div class="col-md-12">
                          <div class="form-group">
                            <label for="justificativaSolicitacaoCancelamento"><b>Justificativa da Solicitação de Cancelamento:</b></label>
                            <label id="justificativaSolicitacaoCancelamento" class='form-control label-observacoes' style="margin-top:-5px;"><?php echo $justificativaAgendamentoCancelamento . $complementoJustificativaAgendamento; ?></label>
                          </div>
                        </div>
                      </div>
                      <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                        <div class="col-md-12">
                          <div class="form-group">
                            <label for="informacoesCancelamento"><b>Justificativa do Cancelamento:</b></label>
                            <textarea id="informacoesCancelamento" class="form-control" rows='3'><?php echo $informacoesCancelamento; ?></textarea>
                          </div>
                        </div>
                      </div>
                    </div><br>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" onClick="cancelarAgendamento()"><i class="fa fa-check-square-o"></i> Confirmar</button>
  <button type="button" class="btn btn-danger" id="btnFechar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liAgendamentoConsultar").attr('class', 'active');
  $("#liAgendamentoConsultar").css("border-bottom", "2px solid #c4c8ca");

  $('#documentos_anexos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });


  function cancelarAgendamento() {

    if ($("#informacoesCancelamento").val() == "") {
      swal("Justificativa Obrigatória", "Você deve justificar o cancelamento deste cancelamento.", "error");
      return false;
    }

    Swal.fire({
      title: "Cancelar Agendamento",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> Ao cancelar este agendamento não será possível a impressão de guia de atendimento ou protocolo de solicitação. <b>Confirma?</b></p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/gravar_solicitacao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoGravacao': 'agendamento-confirmar-cancelamento',
            'idAgendamento': $("#idAgendamento").val(),
            'dataRegistroCancelamento': $("#dataRegistroCancelamento").val(),
            'informacoesCancelamento': $("#informacoesCancelamento").val(),
            'tipoVagaOcupada': "<?php echo $tipoVagaOcupada; ?>",
            'idAgendaSub': "<?php echo $idAgendaSub; ?>",
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          swal("Cancelamento de Agendamento", "Agendamento cancelado com sucesso!", "success");
          setTimeout(function() {
            window.close();
          }, 2000);
        });
      } else {
        $("#disponibilidadeAgenda").val($("#disponibilidadeAgendaReserva").val());
      }
    });

  }
</script>