<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
if (isset($_GET['oci'])) {
  include_once("header-clean.php");
  $eOCI = "S";
  $idGrupo = $_GET['idgrp'];
  $idProcedimento = $_GET['idpro'];
  $esconderNovoAgendamento = "style='display:none'";
  $idSolOCI = $_GET['ids'];
  $idProcOCI = $_GET['proci'];
  $idProcAssOCI = $_GET['idpro'];  
} else {
  include_once("header.php");
  $eOCI = "N";
  $idGrupo = "";
  $idProcedimento = "";
  $esconderNovoAgendamento = "";
  $idSolOCI = "";
  $idProcOCI = "";
  $idProcAssOCI = "";
}
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];
$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$dataHoraAgendamento  = date("d/m/Y H:i");

$sqlPaciente  = "SELECT tb_paciente.*, date_format(tb_paciente.datanasc,'%d/%m/%Y') AS nascimentoPaciente, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente               = $rsPaciente->id_paciente;
$nomePaciente             = $rsPaciente->nome_paciente;
$idadePaciente            = $rsPaciente->idadePaciente;
$nascimentoPaciente       = $rsPaciente->nascimentoPaciente;
$sexoPaciente             = $rsPaciente->sexo;
$cnsPaciente              = $rsPaciente->cns_paciente;
$cpfPaciente              = $rsPaciente->cpf_paciente;
$municipioPaciente        = $rsPaciente->nome_cidade;
$bairrroPaciente          = $rsPaciente->bairro_paciente;
$ibgeCidade               = $rsPaciente->codigocidade;
$telefoneCelular1         = $rsPaciente->celular1;
$telefoneCelular1Whatsapp = $rsPaciente->celular1_whatsapp == "S" ? " checked" : "";
$telefoneCelular2         = $rsPaciente->celular2;
$telefoneCelular2Whatsapp = $rsPaciente->celular2_whatsapp == "S" ? " checked" : "";
$telefoneCelular3         = $rsPaciente->celular3;
$telefoneCelular3Whatsapp = $rsPaciente->celular3_whatsapp == "S" ? " checked" : "";

$formatarStatus = array(
  'A' => 'AGENDADO',
  'E' => 'AGENDADO/ENTREGUE',
  'C' => 'CANCELADO',
  'P' => 'PENDENTE',
  'V' => 'ATENDIDO',
  'X' => 'CANCELAR',
  'R' => 'AUT. REAGENDAR'
);
$siteRegulacaoMunicipal = "https://regulacaomunicipal.pmlf.ba.gov.br/";

$liMenu = $_SESSION['agendaVisivel']=="G" ? "liAgendamentoAvulso" : "liSolicitacaoAgendar";
$ocultaAgendadorLocal = $_SESSION['agendaVisivel']=="G" ? "xxx" : "style='display:none'";
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-checked" style='margin-top:-15px !important'></i>&nbsp;Realizar Agendamento 
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-dadosAgendamentos" data-toggle="tab" aria-controls="dadosAgendamentos" href="#dadosAgendamentos" aria-expanded="true"><b><i class='icofont icofont-files'></i> AGENDAMENTOS EXISTENTES&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form" style='margin-top:-10px'>
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                    <input type="hidden" id="protocoloAgendamento" class="form-control"disabled/>
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="nascimentoPaciente">Nascimento:</label>
                                    <input type="text" id="nascimentoPaciente" class="form-control text-center" value="<?php echo $nascimentoPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-10px; padding-left:10px; padding-right:10px">
                              <h4 class="form-section"><i class="icofont icofont-phone"></i> <b>Dados de Contato</b></h4>
                              <div class="row">
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="telefoneCelular1"><b>Telefone 1 | (É Whatsapp?):</b></label>
                                    <div class="input-group">
                                      <input type="text" id="telefoneCelular1" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular1; ?>">
                                      <div class="input-group-append">
                                        <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                          <input type="checkbox" class="switch" id="telefoneCelular1Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular1Whatsapp; ?> />
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="telefoneCelular2"><b>Telefone 2 | (É Whatsapp?):</b></label>
                                    <div class="input-group">
                                      <input type="text" id="telefoneCelular2" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular2; ?>">
                                      <div class="input-group-append">
                                        <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                          <input type="checkbox" class="switch" id="telefoneCelular2Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular2Whatsapp; ?> />
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="telefoneCelular3"><b>Telefone 3 | (É Whatsapp?):</b></label>
                                    <div class="input-group">
                                      <input type="text" id="telefoneCelular3" class="form-control fonecelular-inputmask" value="<?php echo $telefoneCelular3; ?>">
                                      <div class="input-group-append">
                                        <div class="float-left" style="border: 1px solid #D8D8D8; margin-top:-1px">
                                          <input type="checkbox" class="switch" id="telefoneCelular3Whatsapp" data-reverse data-icon-cls="fa" data-on-icon-cls="fa-check-square" data-off-icon-cls="ft-x-circle" <?php echo $telefoneCelular3Whatsapp; ?> />
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div><br>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações para Agendamento</b></h4>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="grupoProcedimento">Grupo:</label>
                                    <select class="form-control" id="grupoProcedimento">
                                      <option value="">SELECIONE...</option>
                                      <?php
                                      $stmGrupoProcedimento = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo WHERE nome_grupo_procedimento='NÃO AGRUPADOS'");
                                      $stmGrupoProcedimento->execute();
                                      $rsGrupoProcedimento  = $stmGrupoProcedimento->fetch(PDO::FETCH_OBJ);
                                      echo "<option value='$rsGrupoProcedimento->id_grupo_procedimento'>$rsGrupoProcedimento->nome_grupo_procedimento</option>";
                                      $stmGrupoProcedimento->closeCursor();
                                      $stmGrupoProcedimento = $rsConexao->prepare('SELECT * FROM reg_tb_procedimento_grupo ORDER BY nome_grupo_procedimento');
                                      $stmGrupoProcedimento->execute();
                                      $rsGrupoProcedimento  = $stmGrupoProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                      foreach ($rsGrupoProcedimento as $fieldGrupoProcedimento) {
                                        $idGrupoProcedimento    = $fieldGrupoProcedimento['id_grupo_procedimento'];
                                        $nomeGrupoProcedimento  = $fieldGrupoProcedimento['nome_grupo_procedimento'];
                                        if ($nomeGrupoProcedimento != "NÃO AGRUPADOS") {
                                          echo "<option value='$idGrupoProcedimento'>GRUPO - $nomeGrupoProcedimento</option>";
                                        }
                                      }
                                      ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-5">
                                  <div class="form-group">
                                    <label for="nomeProcedimento">Nome do Procedimento:</label>
                                    <select class="form-control" id="nomeProcedimento">
                                      <option value="">SELECIONE O GRUPO...</option>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="dataPrazoRetirada">Prazo de Retirada:</label>
                                    <input type="date" class="form-control text-center" id="dataPrazoRetirada" />
                                    <input type="hidden" class="form-control text-center" id="dataVagaReferencia" />
                                    <input type="hidden" class="form-control text-center" id="tipoAvulso" value='A-VS' />
                                  </div>
                                </div>
                              </div>
                              <hr style='margin-top:-12px; padding-top:5px'>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <ul class="nav nav-tabs nav-topline-sub">
                                      <li class="nav-item" id='aba-vagasistema'>
                                        <a class="nav-link active nav-topline-sub" id="base-agendarVagasSistema" data-toggle="tab" aria-controls="agendarVagasSistema" href="#agendarVagasSistema" aria-expanded="true"><b><i class='icofont icofont-social-google-plus'></i> VAGAS DO SISTEMA&nbsp;&nbsp;</b></a>
                                      </li>
                                      <li class="nav-item" id='ava-vagaexterna'>
                                        <a class="nav-link" id="base-policlinicaRegional" data-toggle="tab" aria-controls="policlinicaRegional" href="#policlinicaRegional" aria-expanded="true"><b><i class='icofont icofont-external-link'></i> VAGA EXTERNA&nbsp;&nbsp;</b></a>
                                        
                                      </li>
                                    </ul>
                                    <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                                      <div role="tabpanel" class="tab-pane active" id="agendarVagasSistema" aria-expanded="true" aria-labelledby="base-agendarVagasSistema">
                                        <form class="form">
                                          <div class="form-body">
                                            <div class="row" style='margin-top:-10px'>
                                              <div class="col-sm-9" style="padding-top:10px;">
                                                <div class="form-group">
                                                  <?php
                                                  if ($idPerfilLogado == 1 || $idPerfilLogado == 11 || $idPerfilLogado == 12 || $idPerfilLogado == 20) {
                                                  ?>
                                                    <button type="button" class="btn btn-success" onClick="pesquisarVagaDisponivel('PVez')" id="btnPrimeiraVezA">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>1ª Vez</b>
                                                    </button>
                                                    <button type="button" class="btn btn-info" onClick="pesquisarVagaDisponivel('retorno')" id="btnRetornoA">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Retorno</b>
                                                    </button>
                                                    <button type="button" class="btn btn-warning" onClick="pesquisarVagaDisponivel('reserva')" id="btnReservaA">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Reserva</b>
                                                    </button>
                                                  <?php
                                                  } else if ($idPerfilLogado == 4) {                                                    
                                                  ?>
                                                    <button type="button" class="btn btn-success" onClick="pesquisarVagaDisponivel('PVez')" id="btnPrimeiraVezB">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>1ª Vez</b>                                                      
                                                    </button>
                                                    <button <?php echo $ocultaAgendadorLocal;?> type="button" class="btn btn-info" onClick="pesquisarVagaDisponivel('retorno')" id="btnRetornoB">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Retorno</b>                                                      
                                                    </button>
                                                  <?php
                                                  } else if ($idPerfilLogado == 14) {
                                                  ?>
                                                    <button type="button" class="btn btn-warning" onClick="pesquisarVagaDisponivel('reserva')" id="btnReservaB">
                                                      <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Reserva</b>
                                                    </button>
                                                  <?php
                                                  }
                                                  ?>
                                                </div>
                                              </div>
                                              <div class="col-sm-3" style='text-align:right'>
                                              <textarea id="conteudoMensagemCopiar" class="form-control" rows=2 style='margin-top:-5000px; position:absolute'></textarea>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top: -15px; padding-right:10px; display:none" id='td-com-vagas'>
                                              <div class="col-md-12">
                                                <div class="form-group">
                                                  <div class="bs-callout-success callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                                    <div class="media align-items-stretch">
                                                      <div class="media-left d-flex align-items-center bg-success p-2" style='padding:7px !important;'>
                                                        <i class="icofont icofont-checked white font-medium-5"></i>
                                                      </div>
                                                      <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important; font-size:13pt'>
                                                        <strong>VAGAS DISPONÍVEIS</strong>
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top: -15px; padding-right:10px;display:none" id='td-sem-vagas'>
                                              <div class="col-md-12">
                                                <div class="form-group">
                                                  <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                                    <div class="media align-items-stretch">
                                                      <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                                        <i class="icofont icofont-checked white font-medium-5"></i>
                                                      </div>
                                                      <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important; font-size:13pt'>
                                                        <strong>NÃO HÁ VAGAS DISPONÍVEIS</strong>
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top: -30px; padding-right:10px">
                                              <div class="col-md-12">
                                                <div class="form-group">
                                                </div>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top: -10px;padding-right:10px">
                                              <div class="col-md-12">
                                                <input type='hidden' class="form-control text-center" id="idVagaSelecionada" value="" disabled>
                                                <div class="form-group" id='exibirProcedimentoDisponiveis'>
                                                </div>
                                              </div>
                                            </div><br>
                                          </div>
                                        </form>
                                      </div>
                                      <div class="tab-pane" id="policlinicaRegional" aria-expanded="true" aria-labelledby="base-policlinicaRegional">
                                        <form class="form">
                                          <div class="form-body">
                                            <div class="row">
                                              <div class="col-md-3">
                                                <div class="form-group">
                                                  <label for="dataAtendimento">Data de Atendimento:</label>
                                                  <input type="date" class="form-control text-center" id="dataAtendimento" />
                                                </div>
                                              </div>
                                              <div class="col-md-3">
                                                <div class="form-group">
                                                  <label for="horaAtendimento">Hora do Atendimento:</label>
                                                  <input type="time" class="form-control text-center" id="horaAtendimento" />
                                                </div>
                                              </div>
                                              <div class="col-md-6">
                                                <div class="form-group">
                                                  <label for="origemVaga">Origem da Vaga:</label>
                                                  <select class="form-control" id="origemVaga">
                                                    <option value="">SELECIONE....</option>
                                                    <?php
                                                    $stmOrigemVaga = $rsConexao->prepare("SELECT * FROM reg_rl_origemagendamento WHERE (id_origemagendamento!='A-VS' AND id_origemagendamento!='S-FG') ORDER BY nome_origemagendamento");
                                                    $stmOrigemVaga->execute();
                                                    $rsOrigemVaga  = $stmOrigemVaga->fetchAll(PDO::FETCH_ASSOC);
                                                    foreach ($rsOrigemVaga as $fieldOrigemVaga) {
                                                      $idOrigemVaga    = $fieldOrigemVaga['id_origemagendamento'];
                                                      $nomeOrigemVaga  = $fieldOrigemVaga['nome_origemagendamento'];
                                                      echo "<option value='$idOrigemVaga'>$nomeOrigemVaga</option>";
                                                    }                                                    ?>
                                                  </select>
                                                </div>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top:-10px">
                                              <div class="col-md-4">
                                                <div class="form-group">
                                                  <label for="tipoDocumento">Tipo de Documento:</label>
                                                  <select class="form-control" id="tipoDocumento">
                                                    <option value="">SELECIONE....</option>
                                                    <?php
                                                    $stmTipoDocumento = $rsConexao->prepare("SELECT * FROM reg_rl_tipodocumento WHERE onde_exibir='A' ORDER BY nome_tipodocumento");
                                                    $stmTipoDocumento->execute();
                                                    $rsTipoDocumento  = $stmTipoDocumento->fetchAll(PDO::FETCH_ASSOC);
                                                    foreach ($rsTipoDocumento as $fieldTipoDocumento) {
                                                      $idTipoDocumento    = $fieldTipoDocumento['id_tipodocumento'];
                                                      $nomeTipoDocumento  = $fieldTipoDocumento['nome_tipodocumento'];
                                                      echo "<option value='$idTipoDocumento'>$nomeTipoDocumento</option>";
                                                    }
                                                    ?>
                                                  </select>
                                                </div>
                                              </div>
                                              <div class="col-md-8">
                                                <div class="form-group">
                                                  <label for="documentoMedico">Anexar Arquivo do Agendamento:</label>
                                                  <div class="input-group">
                                                    <input type="text" id="nomeArquivoDocumento" name="nomeArquivoDocumento" class="form-control upload-fake" disabled style='width:100%;'>
                                                    <input type="file" id="arquivoDocumento" name="arquivoDocumento" class="form-control upload-real" accept=".pdf, .PDF">
                                                    <div class="input-group-append">
                                                      <div class="float-left" style="margin-top:-41px">
                                                        <button type="button" class="btn btn-blue" id="btnAdicionarDocumento" onClick="adicionarArquivo()">
                                                          <i class="fa fa-check-square-o"></i>Adicionar
                                                        </button>
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div class="row" style="margin-top: -60px">
                                              <div class="col-md-12">
                                                <div class="form-group">
                                                  <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_agendados" style='width:100%'>
                                                    <thead>
                                                      <tr>
                                                        <th style='text-align: center !important; width:80px'>OPÇÕES</th>
                                                        <th style='display:none'>idtipodoc</th>
                                                        <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                                        <th style='width: 250px;'>TIPO DE DOCUMENTO</th>
                                                        <th>NOME DO ARQUIVO</th>
                                                        <th style='width: 200px;'>INCLUÍDO POR</th>
                                                      </tr>
                                                    </thead>
                                                    <tbody style="background-color: #ececec;">
                                                    </tbody>
                                                  </table>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                        </form>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="dadosAgendamentos" aria-labelledby="base-dadosAgendamentos">
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="agendamentos_existentes" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th>PROCEDIMENTO</th>
                                    <th align='center'>STATUS</th>
                                    <th>PROFISSIONAL</th>
                                    <th>UNIDADE</th>
                                    <th style='text-align:center'>DATA</th>
                                    <th style='text-align:center'>HORÁRIO</th>
                                    <th>ORIGEM</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $sqlAgendamentos  = "SELECT reg_tb_procedimento.nome_procedimento,
                                  tb_estabelecimento.nfantasia_estabelecimento,
                                  tb_profissional.nome_profissional,
                                  reg_tb_agendamentos.id_agendamento,
                                  date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendmento,
                                  date_format(reg_tb_agendamentos.data_atendimento, '%Y%m%d') AS dataAtendmentoOrdem,
                                  reg_tb_agendamentos.data_atendimento,
                                  reg_tb_agendamentos.status_agendamento,
                                  reg_tb_agendamentos.horario_atendimento,
                                  reg_tb_agendamentos.tipo_vagaocupada
                                  FROM reg_tb_agenda
                                  INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes=tb_profissional.codigoprofissional_cnes)
                                  INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
                                  RIGHT OUTER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
                                  INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento)
                                  WHERE (reg_tb_agendamentos.id_paciente='$idPaciente')
                                  ORDER BY reg_tb_agendamentos.data_atendimento ASC,
                                  reg_tb_agendamentos.horario_atendimento ASC";
                                  $stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
                                  $stmAgendamentos->execute();
                                  if ($stmAgendamentos->rowCount() > 0) {
                                    $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsAgendamentos as $fieldAgendamentos) {
                                      $idAgendamento          = $fieldAgendamentos['id_agendamento'];
                                      $nomeProcedimento       = mb_strtoupper($fieldAgendamentos['nome_procedimento']);
                                      $statusAgendamento      = $formatarStatus[$fieldAgendamentos['status_agendamento']];
                                      $nomeProfissional       = mb_strtoupper($fieldAgendamentos['nome_profissional']);
                                      $nomeUnidade            = mb_strtoupper($fieldAgendamentos['nfantasia_estabelecimento']);
                                      $dataAtendimento        = mb_strtoupper($fieldAgendamentos['dataAtendmento']);
                                      $validarDataCMD         = $fieldAgendamentos['data_atendimento'];
                                      $dataAtendmentoOrdem    = $fieldAgendamentos['dataAtendmentoOrdem'];
                                      $horaAtendimento        = mb_strtoupper($fieldAgendamentos['horario_atendimento']);
                                      $tipoVagaOcupada        = mb_strtoupper($fieldAgendamentos['tipo_vagaocupada']);
                                      $styleRegistroCancelado = $fieldAgendamentos['status_agendamento'] != "C" ? "" : "style='background-color: #ffadad;color: #860000;'";

                                      if ($tipoVagaOcupada == 'PVEZ' || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
                                        if ($tipoVagaOcupada == 'PVEZ') {
                                          $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - (PRIMEIRA VEZ)</font></b>";
                                        } else {
                                          $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - ($tipoVagaOcupada)</font></b>";
                                        }
                                        # -- comando para impressão da marcação do sistema -- #
                                        if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
                                          $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG')" . '"';
                                          $botaoImprimirAgendamento   = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                        } else {
                                          $botaoImprimirAgendamento   = "";
                                        }
                                        # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #

                                        if (($statusAgendamento == "AGENDADO" || $statusAgendamento == "PENDENTE") && ($idPerfilLogado == '1' || $idPerfilLogado == '14')) {
                                          $linkAutorizaAgendamento  = 'onclick="autorizarAgendamento(' . "'$idAgendamento')" . '"';
                                          $autorizarAgendamento     = "<i class='icofont icofont-checked nova_fonte_blue' $linkAutorizaAgendamento title='Autorizar agendamento do procedimento.'></i>";
                                        } else {
                                          $autorizarAgendamento = "";
                                        }
                                        echo "<tr>
                                        <td style='padding:5px'>$botaoImprimirAgendamento&nbsp;&nbsp;&nbsp;$nomeProcedimento</td>
                                        <td $styleRegistroCancelado id='autoriza$idAgendamento'>
                                          $autorizarAgendamento
                                          <font style='font-size:9pt'><b>$statusAgendamento</b></font>
                                        </td>
                                        <td>$nomeProfissional</td>
                                        <td>$nomeUnidade</td>
                                        <td align='center'><font style='font-size:0.5px; color:#fff'>$dataAtendmentoOrdem</font>$dataAtendimento</td>
                                        <td align='center'>$horaAtendimento</td>
                                        <td align='center'>$origemAgendamento</td>
                                        </tr>";
                                      } else {
                                        $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
                                        if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
                                          # -- comando para impressão da marcação externa -- #
                                          $numeracaoArquivo   = str_pad($idAgendamento, 8, "0") . "AA";
                                          $stmArquivoExterno  = $rsConexao->prepare("SELECT * FROM reg_tb_solicitacoes_agendado WHERE id_agendamento_direto='$idAgendamento'");
                                          $stmArquivoExterno->execute();
                                          $rsArquivoExterno   = $stmArquivoExterno->fetch(PDO::FETCH_OBJ);
                                          $diretorioArquivo   = "docagendamentos/" . $rsArquivoExterno->pasta_documento . "/" . $numeracaoArquivo . "_" . $rsArquivoExterno->nomearquivo_documento;
                                          $comandoImprimirAgendamento  = 'onClick="window.open(' . "'$diretorioArquivo')" . '"';
                                          $botaoImprimirAgendamento    = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                          # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #
                                        } else {
                                          $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
                                          $botaoImprimirAgendamento = "";
                                        }
                                        echo "<tr>
                                        <td style='padding:5px'>
                                          $botaoImprimirAgendamento
                                          $nomeProcedimento
                                          </td>
                                        <td $styleRegistroCancelado>
                                          $statusAgendamento
                                        </td>
                                        <td>NÃO INFORMADO</td>
                                        <td>NÃO INFORMADO</td>
                                        <td align='center'>NÃO INFORMADO</td>
                                        <td align='center'>NÃO INFORMADO</td>
                                        <td align='center'>$origemAgendamento</td>
                                        </tr>";
                                      }
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" id="btnConfirmarAgendamento" onClick="gravarAgendamento()">
    <i class="fa fa-check-square-o"></i> Confirmar
  </button>
  <button type='button' class='btn btn-green' onClick="window.location.href='paciente_buscar?op=aa'" <?php echo $esconderNovoAgendamento;?>>
    <i class='icofont icofont icofont-medical'></i>&nbsp;&nbsp;Novo Agendamento
  </button>
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>

<?php
include_once("footer.php");
include_once("include/box_obs_agendamento.php");

?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  var liMenu = "<?php echo $liMenu;?>";
  $("#"+liMenu).attr('class', 'active');
  $("#"+liMenu).css("border-bottom", "2px solid #c4c8ca");

  $('#agendamentos_existentes').DataTable({
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#documentos_agendados').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function pegarIdVagaSelecionada(selId) {
    var registroSelecionado = selId.split("#")
    var dataVaga = registroSelecionado[4].substr(0, 10)
    $("#dataVagaReferencia").val(dataVaga);
    $("#idVagaSelecionada").val(selId);
  }

  function filtrarProcedimentos() {

    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'agendamento-avulso',
        'grupoProcedimento': $("#grupoProcedimento").val()
      }
    }).done(function(resultadoRetorno) {
      $("#procedimentoSelecionado").val("");
      $("#nomeProcedimento").html("");
      $("#nomeProcedimento").html(resultadoRetorno);
    });

  }

  function pesquisarVagaDisponivel(tipoVaga) {

    if ($("#grupoProcedimento").val() == "" || $("#nomeProcedimento").val() == "") {
      swal("Dados Obrigatórios", "Você deve selecionar o procedimento que deseja realizar o agendamento.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_vagasdisponiveis',
      type: 'post',
      dataType: 'html',
      data: {
        'tipoVaga': tipoVaga,
        'idProcedimento': $("#nomeProcedimento").val(),
        'idGrupoProcedimento': $("#grupoProcedimento").val(),
        'sexoPaciente': "<?php echo $sexoPaciente; ?>",
        'idadePaciente': $("#idadePaciente").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno != "nenhumaVaga") {
        $("#td-sem-vagas").css('display', 'none');
        $("#td-com-vagas").css('display', 'block');
        $("#exibirProcedimentoDisponiveis").html(resultadoRetorno);
      } else {
        $("#td-com-vagas").css('display', 'none');
        $("#td-sem-vagas").css('display', 'block');
        $("#exibirProcedimentoDisponiveis").html("");
      }
    });

  }

  function gravarAgendamento() {

    var obtemDataHoje = new Date();
    var anoAtual = obtemDataHoje.getFullYear();
    var mesAtual = obtemDataHoje.getMonth() + 1;
    var diaAtual = obtemDataHoje.getDate();
    var dataHoje = anoAtual + '-' + ("00" + mesAtual).slice(-2) + '-' + ("00" + diaAtual).slice(-2);

    var eOCI = "<?php echo $eOCI;?>";
    var getOCI = eOCI=="S" ? "&&oci="+eOCI : "";

    if ($("#nomeProcedimento").val() == "") {
      swal("Procedimento Agendado", "Você deve informar o procedimento que está sendo agendado.", "error");
      return false;
    }

    if ($("#dataPrazoRetirada").val() == "") {
      swal("Prazo de Retirada", "Você deve informar um prazo de retirada da marcação.", "error");
      return false;
    }


    if ($("#tipoAvulso").val() == "A-VS") {

      var splitCodigos = $("#idVagaSelecionada").val().split("#");
      var idAgenda = splitCodigos[1];
      var idAgendaSub = splitCodigos[2];
      var tipoVagaOcupada = splitCodigos[3];

      /*if (($("#dataPrazoRetirada").val() <= dataHoje) || ($("#dataPrazoRetirada").val() >= $("#dataVagaReferencia").val())) {
        swal("Prazo de Retirada", "A data estabelecida como prazo para retirada não é válida. Tempo insuficiente para o paciente retirar a marcação.", "error");
        return false;
      }*/

    } else {

      var idAgenda = "";
      var idAgendaSub = ""
      var tipoVagaOcupada = $('#origemVaga').find(":selected").text();

      /*if (($("#dataPrazoRetirada").val() <= dataHoje) || ($("#dataPrazoRetirada").val() >= $("#dataAtendimento").val())) {
        swal("Prazo de Retirada", "A data estabelecida como prazo para retirada não é válida. Tempo insuficiente para o paciente retirar a marcação.", "error");
        return false;
      }*/

      if ($("#dataAtendimento").val() == "" || $("#horaAtendimento").val() == "") {
        swal("Dados Obrigatórios", "Você deve informar data, hora do atendimento e origem da vaga.", "error");
        return false;
      }

      var totalAnexos = $("#documentos_agendados").dataTable().fnSettings().fnRecordsTotal();
      if (totalAnexos == 0) {
        swal("Documento Obrigatório", "Você ainda não anexou o comprovante do agendamento.", "error");
        return false;
      }

    }

    if ($("#idVagaSelecionada").val() == "" && $("#tipoAvulso").val() == "A-VS") {
      swal("Selecionar Vaga", "Você deve selecionar a vaga disponível para o agendamento.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    if(eOCI=="S"){
      var idSolOCI = "<?php echo $idSolOCI;?>";
      var idProcOCI  = "<?php echo $idProcOCI;?>";
      var idProcAssOCI  = "<?php echo $idProcAssOCI;?>";
      agendamentoOCI=idSolOCI+"##"+idProcOCI+"##"+idProcAssOCI;
    }else{
      agendamentoOCI = "N";
    }
    $.ajax({
      url: 'action/gravar_agendamento_direto',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoOrigem': $("#tipoAvulso").val(),
        'idPaciente': $("#idPaciente").val(),
        'idVaga': idAgenda,
        'idVagaSub': idAgendaSub,
        'tipoVagaOcupada': tipoVagaOcupada,
        'dataAtendimento': $("#dataAtendimento").val(),
        'horaAtendimento': $("#horaAtendimento").val(),
        'prazoRetirada': $("#dataPrazoRetirada").val(),
        'idGrupoProcedimento': $("#grupoProcedimento").val(),
        'idProcedimento': $("#nomeProcedimento").val(),
        'telefoneCelular1': $("#telefoneCelular1").val(),
        'telefoneCelular2': $("#telefoneCelular2").val(),
        'telefoneCelular3': $("#telefoneCelular3").val(),
        'telefoneCelular1Whatsapp': $("#telefoneCelular1Whatsapp").is(':checked') ? "S" : "N",
        'telefoneCelular2Whatsapp': $("#telefoneCelular2Whatsapp").is(':checked') ? "S" : "N",
        'telefoneCelular3Whatsapp': $("#telefoneCelular3Whatsapp").is(':checked') ? "S" : "N",
        'agendamentoOCI' : agendamentoOCI
      }
    }).done(function(resultadoRetorno) {
      /* CARREGAR LISTA DE AGENDAMENTOS ATUALIZADA */
      $.ajax({
        url: 'filtros/filtrar_agendamentos',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoListagem': 'listar-agendamentos-paciente-tela-agendamento',
          'idPaciente': $("#idPaciente").val()
        }
      }).done(function(retornoResultado) {
        $('#agendamentos_existentes').DataTable().destroy();
        $('#agendamentos_existentes tbody').empty().append(retornoResultado);
        $('#agendamentos_existentes').DataTable({
          "filter": false,
          "lengthChange": false,
          "info": false
        });
        $("#protocoloAgendamento").val(resultadoRetorno);
        copiarTextoMensagem(); //copiar mensagem automática
        //notificarAgendamento(resultadoRetorno);
        $("#embacado").css("display", "none");
        swal("Registro de Agendamento", "Agendamento registrado com sucesso e estará disponível para impressão após registro de entrega.", "success");
        setInterval(function() {
          window.location.href = 'agendamento_verimpressao?viewheader=backview'+getOCI;
        }, 2000);
        $("#dataPrazoRetirada").val('');
        $("#grupoProcedimento").val('');
        $("#grupoProcedimento").trigger("change");
        $("#dataAtendimento").val('');
        $("#horaAtendimento").val('');
        $("#origemVaga").val('');
        $("#tipoDocumento").val('');
        $("#nomeArquivoDocumento").val('');
        $("#arquivoDocumento").val('');
        $('#documentos_agendados').DataTable().destroy();
        $('#documentos_agendados tbody').empty().append('');
        $('#documentos_agendados').DataTable({
          "paging": false,
          "filter": false,
          "lengthChange": false,
          "info": false
        });
      });

    });
  }

  $("#grupoProcedimento").change(function() {
    filtrarProcedimentos();
    $("#td-sem-vagas").css('display', 'none');
    $("#td-com-vagas").css('display', 'none');
    $("#exibirProcedimentoDisponiveis").html('');
  })

  $("#nomeProcedimento").change(function() {
    $("#td-sem-vagas").css('display', 'none');
    $("#td-com-vagas").css('display', 'none');
    $("#exibirProcedimentoDisponiveis").html('');
    $.ajax({
      url: 'filtros/filtrar_agendamentos_agenda',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoFiltro': 'comparar-agendados-pendente',
        'idPaciente': $("#idPaciente").val(),
        'idProcedimento': $("#nomeProcedimento").val()
      }
    }).done(function(resultadoRetorno) {

      if (resultadoRetorno == "JáExiste" && idPerfilLogado != "1" && idPerfilLogado != "14") {
        $("#btnConfirmarAgendamento").prop("disabled", true);
        $("#btnAdicionarDocumento").prop("disabled", true);
        $("#btnPrimeiraVezA").prop("disabled", true);
        $("#btnRetornoA").prop("disabled", true);
        $("#btnReservaA").prop("disabled", true);
        $("#btnPrimeiraVezB").prop("disabled", true);
        $("#btnRetornoB").prop("disabled", true);
        $("#btnReservaB").prop("disabled", true);
        swal("Não Autorizado", "Existe agendamento pendente deste paciente para o mesmo procedimento.", "error");
      } else {
        $("#btnConfirmarAgendamento").prop("disabled", false);
        $("#btnAdicionarDocumento").prop("disabled", false);
        $("#btnPrimeiraVezA").prop("disabled", false);
        $("#btnRetornoA").prop("disabled", false);
        $("#btnReservaA").prop("disabled", false);
        $("#btnPrimeiraVezB").prop("disabled", false);
        $("#btnRetornoB").prop("disabled", false);
        $("#btnReservaB").prop("disabled", false);
      }
    });

  })

  $("#aba-vagasistema").click(function() {
    $('#tipoAvulso').val('A-VS');
  })

  $("#ava-vagaexterna").click(function() {
    $('#tipoAvulso').val('A-VE');
    $('#exibirProcedimentoDisponiveis').html('');
    $("#td-sem-vagas").css('display', 'none');
    $("#td-com-vagas").css('display', 'none');
  })

  $("#arquivoDocumento").change(function() {
    var nomeArquivo = this.files[0].name;
    $("#nomeArquivoDocumento").val(nomeArquivo);
  })

  function adicionarArquivo() {

    if ($("#tipoDocumento").val() == "" || $("#nomeArquivoDocumento").val() == "") {
      swal("Documento Obrigatórios", "Você deve informar o tipo de documento e anexar o arquivo do agendamento.", "error");
      return false;
    }

    if ($("#nomeArquivoDocumento").val() != "") {
      let extensoesValidas = /(\.pdf)$/i;
      let nomeArquivo = $('#arquivoDocumento')[0].files[0].name;
      if (extensoesValidas.test(nomeArquivo) == false) {
        swal("Arquivo Inválido", "Tipo de arquivo inválido. Só são permitidos arquivos em formato PDF.", "error");
        return false;
      }
    }

    $('#embacado').css('display', 'block');
    var formData = new FormData();
    formData.append('idPaciente', $("#idPaciente").val());
    formData.append('idSolicitacao', "");
    formData.append('tipoDocumento', $("#tipoDocumento").val());
    formData.append('arquivoDocumento', $('#arquivoDocumento')[0].files[0]);
    $.ajax({
      type: 'POST',
      url: 'action/gravar_solicitacao_agendado',
      data: formData,
      processData: false,
      contentType: false
    }).done(function(resultadoRetorno) {
      $('#embacado').css('display', 'none');
      if (resultadoRetorno == "JáExiste") {
        swal("Documento já Adicionado", "O tipo de documento informado já foi adicionado à lista.", "error");
        return false;
      }
      $('#documentos_agendados').DataTable().destroy();
      $('#documentos_agendados tbody').empty().append(resultadoRetorno);
      $('#documentos_agendados').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#tipoDocumento").val('');
      $("#nomeArquivoDocumento").val('');
    });

  }

  function excluirAnexo(idDocumento, anexoExcluir, idSolicitacao) {

    swal({
      title: "Exclusão de Documento",
      text: "Confirma exclusão do documento selecionado?",
      icon: "../app-assets/images/question.png",

      buttons: {
        confirm: {
          text: "Sim, Confirmar!",
          value: true,
          visible: true,
          className: "btn-success",
          closeModal: false
        },
        cancel: {
          text: "Não, Foi engano!",
          value: null,
          visible: true,
          className: "btn-danger",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'documento_agendado',
            'idRegistroExclusao': idDocumento,
            'anexoExcluir': anexoExcluir,
            'idSolicitacao': idSolicitacao,
          }
        }).done(function(resultadoRetorno) {
          $('#documentos_agendados').DataTable().destroy();
          $('#documentos_agendados tbody').empty().append(resultadoRetorno);
          $('#documentos_agendados').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          $("#embacado").css("display", "none");
          swal("Exclusão de Documento.", "Exclusão de documento realizada com sucesso.", "info");
        });

      } else {
        swal("Operação Cancelada.", "O documento selecionado não foi excluído.", "info");
      }

    });

  }

  $("#origemVaga").change(function() {
    if (this.value == '') {
      $("#tipoAvulso").val('A-VE');
    } else {
      $("#tipoAvulso").val(this.value);
    }
  })


  function notificarAgendamento(numeroProtocolo) {
    var telefoneCelular1Whatsapp = $("#telefoneCelular1Whatsapp").is(':checked') ? "S" : "N";
    var telefoneCelular2Whatsapp = $("#telefoneCelular2Whatsapp").is(':checked') ? "S" : "N";
    var telefoneCelular3Whatsapp = $("#telefoneCelular3Whatsapp").is(':checked') ? "S" : "N";
    var telefoneCelular1 = $("#telefoneCelular1").val();
    telefoneCelular1 = telefoneCelular1.replace("(", "");
    telefoneCelular1 = telefoneCelular1.replace(")", "");
    telefoneCelular1 = telefoneCelular1.replace(" ", "");
    telefoneCelular1 = "55" + telefoneCelular1.replace("-", "");
    var telefoneCelular2 = $("#telefoneCelular2").val();
    telefoneCelular2 = telefoneCelular2.replace("(", "");
    telefoneCelular2 = telefoneCelular2.replace(")", "");
    telefoneCelular2 = telefoneCelular2.replace(" ", "");
    telefoneCelular2 = "55" + telefoneCelular2.replace("-", "");
    var telefoneCelular3 = $("#telefoneCelular3").val();
    telefoneCelular3 = telefoneCelular3.replace("(", "");
    telefoneCelular3 = telefoneCelular3.replace(")", "");
    telefoneCelular3 = telefoneCelular3.replace(" ", "");
    telefoneCelular3 = "55" + telefoneCelular3.replace("-", "");
    var nomeProcedimento = $('#nomeProcedimento').find(":selected").text();
    /* MENSAGEM A SER ENVIADA */
    var prazoRetirada = $("#dataPrazoRetirada").val().split("-");
    prazoRetirada = prazoRetirada[2] + '/' + prazoRetirada[1] + '/' + prazoRetirada[0];
    mensagemAgendamento = "*REGULAÇÃO MUNICIPAL DE LAURO DE FREITAS*\n\n";
    mensagemAgendamento = mensagemAgendamento + "Prezado(a) " + $("#nomePaciente").val() + "\n";
    mensagemAgendamento = mensagemAgendamento + "Informamos que o seguinte procedimento foi autorizado:\n\n";
    mensagemAgendamento = mensagemAgendamento + nomeProcedimento + "\n";
    mensagemAgendamento = mensagemAgendamento + "Protocolo: " + numeroProtocolo + "\n\n";
    mensagemAgendamento = mensagemAgendamento + "*O prazo para a retirada da sua autorização é até o dia " + prazoRetirada + "* \n";
    mensagemAgendamento = mensagemAgendamento + "Informamos que é da responsabilidade do paciente a apresentação dos documentos de identidade com foto, solicitação médica e marcação/autorização para realização de exame ou consulta na unidade de atendimento.\n";
    mensagemAgendamento = mensagemAgendamento + "Caso não retire a autorização até a data informada, a marcação será cancelada, e será necessária uma nova solicitação para a fila de espera.\n\n";
    mensagemAgendamento = mensagemAgendamento + "*Acompanhe suas solicitações no site:*\n <?php echo $siteRegulacaoMunicipal; ?>\n\n";
    mensagemAgendamento = mensagemAgendamento + "*Observação:*\n*Caso você não consiga retirar através do site, dirija-se ao posto de regulação mais próximo a sua residência.*\n\n";
    mensagemAgendamento = mensagemAgendamento + "💡 *Atenção!*\nVocê também pode utilizar os serviços da nossa *Inteligência Artificial*! Ela se chama Laura. Se desejar conhecer as opções de atendimento da Laura, envie um *oi* para ela aqui neste mesmo contato.";

    /** configuração dos dados para acesso à api de envio**/
    const linkImagemNonitifcacao = "https://laurodefreitas.portalgsaude.app.br/regulacao/css/images/gSaude-notificacaozap.png";
    const myHeaders = new Headers();
    myHeaders.append("Content-Type", "application/json");
    myHeaders.append("apikey", "zYzP7ocstxh3Sscefew4FZTCu4ehnM8v436");

    /** executar envio da notificação **/
    if (telefoneCelular1Whatsapp == "S") { // telefone 1 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular1,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Agendamento", "Agendamento registrado com sucesso e estará disponível para impressão após registro de entrega.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }

    if ((telefoneCelular2Whatsapp == "S") && (telefoneCelular2 != telefoneCelular1 && telefoneCelular2 != telefoneCelular3)) { // telefone 2 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular2,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Agendamento", "Agendamento registrado com sucesso e estará disponível para impressão após registro de entrega.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }
    if ((telefoneCelular3Whatsapp == "S") && (telefoneCelular3 != telefoneCelular1 && telefoneCelular3 != telefoneCelular2)) { // telefone 3 se for whatsapp
      const raw = JSON.stringify({
        "number": telefoneCelular3,
        "options": {
          "delay": 600,
          "presence": "composing"
        },
        "mediaMessage": {
          "mediatype": "image",
          "caption": mensagemAgendamento,
          "media": linkImagemNonitifcacao
        }
      });
      const requestOptions = {
        method: "POST",
        headers: myHeaders,
        body: raw,
        redirect: "follow"
      };
      fetch("https://storage.essencialapi.app.br/message/sendMedia/laurodefreitas", requestOptions)
        .then((response) => response.text())
        .then((result) => {
          $("#embacado").css("display", "none");
          swal("Registro de Agendamento", "Agendamento registrado com sucesso e estará disponível para impressão após registro de entrega.", "success");
        })
        .catch((error) => {
          swal('Notificação não Enviada', "Não foi possível enviar a notificação ao telefone do(a) cidadão(ã).", 'error');
        });
    }

    /* LIMPAR SELEÇÃO DE PROCEDIMENTO DE PRAZO DE RETIRADA */
    $("#dataPrazoRetirada").val('');
    $("#grupoProcedimento").val('');
    $("#grupoProcedimento").trigger("change");
    $("#dataAtendimento").val('');
    $("#horaAtendimento").val('');
    $("#origemVaga").val('');
    $("#tipoDocumento").val('');
    $("#nomeArquivoDocumento").val('');
    $("#arquivoDocumento").val('');
    $('#documentos_agendados').DataTable().destroy();
    $('#documentos_agendados tbody').empty().append('');
    $('#documentos_agendados').DataTable({
      "paging": false,
      "filter": false,
      "lengthChange": false,
      "info": false
    });
  }

  function autorizarAgendamento(idAgendamento) {

    swal({
      title: "Autorizar Agendamento",
      text: "Confirma autorização para agendamento deste procedimento?",
      icon: "../app-assets/images/question.png",

      buttons: {
        confirm: {
          text: "Sim, Confirmar!",
          value: true,
          visible: true,
          className: "btn-success",
          closeModal: false
        },
        cancel: {
          text: "Não, Foi engano!",
          value: null,
          visible: true,
          className: "btn-danger",
          closeModal: false,
        }
      }

    }).then((isConfirm) => {

      if (isConfirm) {
        $.ajax({
          url: 'action/autorizar_agendamento',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoAutorizacao': 'autorizar-novoagendamento',
            'idAgendamento': idAgendamento
          }
        }).done(function(resultadoRetorno) {
          swal("Autorização Realizada.", "O procedimento foi confirmado e reagendamento novo autorizado.", "info");
          $("#autoriza" + idAgendamento).html("<font style='font-size:9pt'><b>AUT. REAGENDAR</b></font>");
          $("#btnConfirmarAgendamento").prop("disabled", false);
          $("#btnAdicionarDocumento").prop("disabled", false);
          $("#btnPrimeiraVezA").prop("disabled", false);
          $("#btnRetornoA").prop("disabled", false);
          $("#btnReservaA").prop("disabled", false);
          $("#btnPrimeiraVezB").prop("disabled", false);
          $("#btnRetornoB").prop("disabled", false);
          $("#btnReservaB").prop("disabled", false);
        });

      } else {
        swal("Operação Cancelada.", "Agendamento não autorizado.", "info");
      }

    });
  }

  /* -- validar grupo e procedimento se for OCI -- */
  var eOCI = "<?php echo $eOCI; ?>";
  var idGrupo = "<?php echo $idGrupo; ?>";
  var idProcedimento = "<?php echo $idProcedimento; ?>";

  if (eOCI == "S") {
    $("#grupoProcedimento").prop("disabled", true);
    $("#nomeProcedimento").prop("disabled", true);
    $("#grupoProcedimento").val(idGrupo);
    $("#grupoProcedimento").trigger("change");
    setTimeout(function() {
      $("#nomeProcedimento").val(idProcedimento);
    }, 600);

  }

  function copiarTextoMensagem(){

    var prazoRetirada     = $("#dataPrazoRetirada").val().split("-");
    var nomeProcedimento  = $('#nomeProcedimento option:selected').text();
    prazoRetirada = prazoRetirada[2] + '/' + prazoRetirada[1] + '/' + prazoRetirada[0];
    mensagemAgendamento = "*REGULAÇÃO MUNICIPAL DE LAURO DE FREITAS*\n\n";
    mensagemAgendamento = mensagemAgendamento + "Prezado(a)\n" + $("#nomePaciente").val() + "\n";
    mensagemAgendamento = mensagemAgendamento + "Informamos que o seguinte procedimento foi agendado:\n\n";
    mensagemAgendamento = mensagemAgendamento + "*" + nomeProcedimento + "*\n";
    mensagemAgendamento = mensagemAgendamento + "Protocolo: " + $("#numeroProtocolo").val() + "\n\n";
    mensagemAgendamento = mensagemAgendamento + "*O prazo para a retirada da sua autorização é até o dia " + prazoRetirada + "* \n";
    mensagemAgendamento = mensagemAgendamento + "Informamos que é da responsabilidade do paciente a apresentação dos documentos de identificação com foto, solicitação médica e marcação/autorização para realização de exame ou consulta na unidade de atendimento.\n";
    mensagemAgendamento = mensagemAgendamento + "Caso não retire a autorização até a data informada, a marcação será cancelada, e será necessária uma nova solicitação para a fila de espera.\n\n";
    //mensagemAgendamento = mensagemAgendamento + "*Observação:*\n*Caso você não consiga retirar através do site, dirija-se ao posto de regulação mais próximo a sua residência.*\n\n";
    mensagemAgendamento = mensagemAgendamento + "💡 *Atenção!*\nVocê também pode retirar seu agendamento através da *Inteligência Artificial*! Ela se chama Laura. Se desejar conhecer as opções de atendimento da Laura, basta adicionar o número *71984540356* à sua agenda de contatos e enviar um oi para ela.";

    $("#conteudoMensagemCopiar").val(mensagemAgendamento);
		let textoMensagem = document.querySelector("#conteudoMensagemCopiar");
		textoMensagem.select();
		document.execCommand('copy');
    swal("Mensagem Copiada","","success");

  }
</script>