<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$dataHoje         = date("Y-m-d");
$idPerfilLogado   = $_SESSION['idPerfilLogado'];
$idPacienteGet    = $_GET['idpac'];
$opcaoTela        = $_GET['op'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade          = $rsPaciente->codigocidade;

$idAgendamento      = $_GET['idagendam'];
$qslAgendamento = "SELECT reg_tb_agendamentos.*,
date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
date_format(reg_tb_agendamentos.dataprazo_retirada,'%d/%m/%Y') AS dataPrazoRetirada,
date_format(reg_tb_agendamentos.datahora_entrega,'%d/%m/%Y %H:%i') AS dataRegistroEntrega,
reg_tb_agendamentos.protocolo_agendamento,
ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
ucase(reg_tb_usuario.nome_usuario) AS agendadoPor
FROM reg_tb_procedimento
INNER JOIN reg_tb_agendamentos ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
INNER JOIN reg_tb_usuario ON (reg_tb_agendamentos.id_usuario_agendou = reg_tb_usuario.id_usuario)
WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";
$stmAgendamento = $rsConexao->prepare($qslAgendamento);
$stmAgendamento->execute();
$rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);

$dataAtendimento    = $rsAgendamento->dataAtendimento;
$dataPrazoRetirada  = $rsAgendamento->dataPrazoRetirada;
$numeroProtocolo    = $rsAgendamento->protocolo_agendamento;
$nomeProcedimento   = $rsAgendamento->nomeProcedimento;
$tipoVagaOcupada    = $rsAgendamento->tipo_vagaocupada;
$agendadoPor        = $rsAgendamento->agendadoPor;


$dataHoraRegistro   = $rsAgendamento->dataRegistroEntrega!="" ? $rsAgendamento->dataRegistroEntrega : date("d/m/Y H:i");;
$nomePortador       = $rsAgendamento->nome_portador;
$documentoPortador  = $rsAgendamento->documento_portador;
$telefonePortador   = $rsAgendamento->telefone_portador;
$carroPoliclinica   = $rsAgendamento->carro_policlinica;
$comAcompanhanete   = $rsAgendamento->precisaacompanhante_policlinica;
$nomeAcompanhanete  = $rsAgendamento->nomeacompanhante_policlinica;
$docAcompanhanete   = $rsAgendamento->documentoacompanhante_policlinica;
$maeAcompanhanete   = $rsAgendamento->maeacompanhante_policlinica;
$nascAcompanhanete  = $rsAgendamento->nascimentocompanhante_policlinica;
$localpartidaCarro  = $rsAgendamento->localpartida_policlinica;

$displayCarroPoliclinica  = $tipoVagaOcupada == "POLICLÍNICA" ? " display:block;" : " display:none;";
$mostarComandosimpressao  = $rsAgendamento->marcacao_entregue=="S" ? " display:inline;" : " display:none;";
$mostarComandoConfirmar   = $rsAgendamento->marcacao_entregue=="S" ? " display:none;" : " display:inline;";

$_SESSION['origemAgendamento']  = $rsAgendamento->origem_agendamento;

if ($tipoVagaOcupada == "PVEZ" || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
  $_SESSION['idAgendamento']      = $idAgendamento;
  $cliqueImprimirAgendamento = 'onClick="window.location.href=' . "'agendamento_verimpressao?viewheader=falseview'" . '"';
} else {
  # -- PEGAR DOCUMENTO DO AGENDAMENTO -- #
  $stmDocumento   = $rsConexao->prepare("SELECT * FROM reg_tb_solicitacoes_agendado WHERE id_sca_solicitacao='$idAgendamento'");
  $stmDocumento->execute();
  $rsDocumento    = $stmDocumento->fetch(PDO::FETCH_OBJ);
  $pastaDocumento = $rsDocumento->pasta_documento;
  $nomeArquivo    = $rsDocumento->nomearquivo_documento;

  $numeracaoArquivo   = str_pad($idAgendamento, 8, "0") . "AA_";
  $diretorioBase  = "docagendamentos/$pastaDocumento/$numeracaoArquivo$nomeArquivo";
  # ------------------------------------ #
  $cliqueImprimirAgendamento = 'onClick="window.open(' . "'$diretorioBase')" . '"';
}
$botaoImprimirAgendamento  = "<i id='imprimirMarcacao' class='icofont icofont-printer nova_fonte_blue' title='Imprimir marcação.' style='$mostarComandosimpressao' $cliqueImprimirAgendamento></i>";

if($tipoVagaOcupada == "POLICLÍNICA" ){
  $cliqueBotaoQrCode  = 'onClick="window.open('."'imprimir_qrcode?idagendam=$idAgendamento')" . '"';
  $botaoBotaoQrCode   = "<i id='imprimirQrCorde' class='icofont icofont-qr-code nova_fonte_confirma' style='$mostarComandosimpressao' title='Imprimir comprovante QRCode.' $cliqueBotaoQrCode></i>";
}else{
  $botaoBotaoQrCode   = "";
}

$origemAgendamento = "";
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-checked" style='margin-top:-15px !important'></i>&nbsp;Entrega de Agendamento Avulso
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
            <div class="card-content collapse show">
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <form class="form" style='margin-top:-10px'>
                        <div class="form-body">
                          <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                            <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                            <input type="hidden" id="idAgendamento" value="<?php echo $idAgendamento; ?>" />
                          </h4>
                          <div class="row" style="margin-top: -10px;">
                            <div class="col-md-6">
                              <div class="form-group">
                                <label for="nomePaciente">Nome:</label>
                                <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="cpfPaciente">CPF:</label>
                                <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="cnsPaciente">Cartão SUS:</label>
                                <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente; ?>" disabled />
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="form-body" style="margin-top: -15px;">
                          <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                          <div class="row" style="margin-top: -10px;">
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="dataAtendimento">Data Atendimento:</label>
                                <input type="text" class="form-control text-center" id="dataAtendimento" value="<?php echo $dataAtendimento; ?>" disabled />
                              </div>
                            </div>
                            <div class="col-md-2">
                              <div class="form-group">
                                <label for="numeroProtocolo">Nº Protocolo:</label>
                                <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                              </div>
                            </div>
                            <div class="col-md-7">
                              <div class="form-group">
                                <label for="nomeProcedimento">Nome do Procedimento:</label>
                                <input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento; ?>" disabled />
                              </div>
                            </div>
                          </div>
                          <div class="row" style="margin-top: -10px;">
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="dataHoraRegistro"><b>Data/Hora Registro:</b></label>
                                <input type='text' class="form-control text-center" id="dataHoraRegistro" value="<?php echo $dataHoraRegistro;?>" disabled>
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="nomePortador"><b>Nome Protador:</b></label>
                                <input type='text' class="form-control" id="nomePortador" value="<?php echo $nomePortador;?>">
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="documentoPortador"><b>Documento:</b></label>
                                <input type='text' class="form-control" id="documentoPortador" value="<?php echo $documentoPortador;?>">
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label for="telefonePortador"><b>Telefone Portador:</b></label>
                                <input type='text' class="form-control text-center" id="telefonePortador" value="<?php echo $telefonePortador;?>">
                              </div>
                            </div>
                          </div>
                          <div class="form-body" style="margin-top: -15px;<?php echo $displayCarroPoliclinica; ?>">
                            <div class="row" style="margin-top:-10px;">
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="carroPoliclinica">Carro Policlínica:</label>
                                  <select id="carroPoliclinica" class="form-control">
                                    <option value=''>SELECIONE...</option>
                                    <option value='S'>SIM</option>
                                    <option value='N'>NÃO</option>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-2">
                                <div class="form-group">
                                  <label for="acompanhantePoliclinica">Acompanhante:</label>
                                  <select id="acompanhantePoliclinica" class="form-control" disabled>
                                    <option value=''>SELECIONE...</option>
                                    <option value='S'>SIM</option>
                                    <option value='N'>NÃO</option>
                                  </select>
                                </div>
                              </div>
                              <div class="col-md-5">
                                <div class="form-group">
                                  <label for="nomeAcompanhante">Nome do Acompanhante:</label>
                                  <input type="text" id="nomeAcompanhante" class="form-control" value="<?php echo $nomeAcompanhanete;?>">
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="documentoAcompanhante">RG ou CPF:</label>
                                  <input type="text" id="documentoAcompanhante" class="form-control text-center" value="<?php echo $docAcompanhanete;?>">
                                </div>
                              </div>
                            </div>
                            <div class="row" style="margin-top: -10px;">
                              <div class="col-md-5">
                                <div class="form-group">
                                  <label for="maeAcompanhante">Nome da Mãe / Responsável:</label>
                                  <input type="text" id="maeAcompanhante" class="form-control" value="<?php echo $maeAcompanhanete;?>">
                                </div>
                              </div>
                              <div class="col-md-3">
                                <div class="form-group">
                                  <label for="dataNascimentoAcompanhanete">Data Nascimento:</label>
                                  <input type="date" id="dataNascimentoAcompanhanete" class="form-control text-center" value="<?php echo $nascAcompanhanete;?>">
                                </div>
                              </div>
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label for="localPartidaTransporte">Local de Partida:</label>
                                  <select id="localPartidaTransporte" class="form-control" disabled>
                                    <option value=''>SELECIONE...</option>
                                    <option value='AREIA-BRANCA'>AREIA BRANCA (POSTO DE SAÚDE ACR)</option>
                                    <option value='FINAL-LINHA'>FINAL DE LINHA DE LAURO</option>
                                    <option value='PASSARELA-FLORES'>PASSARELA DAS FLORES - (ANTIGO MAXXI)</option>
                                    <option value='PORTÃO'>PORTÃO</option>
                                    <option value='UPA-ITINGA'>UPA DE ITINGA</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row" style="margin-top:-10px;">
                            <div class="col-md-12">
                              <div class="form-group">
                                <table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='documentos_agendados'>
                                  <thead>
                                    <tr>
                                      <th style='text-align: center; width:150px'>OPÇÕES</th>
                                      <th style='text-align:center; width:250px'>DATA DO AGENDAMENTO</th>
                                      <th style='text-align:center; width:250px'>RETIRAR ATÉ</th>
                                      <th>AGENDADO POR</th>
                                    </tr>
                                  </thead>
                                  <tbody style='background-color: #ececec;'>
                                    <?php
                                    echo "<tr>
                                      <td align='center'>
                                        $botaoImprimirAgendamento&nbsp;
                                        $botaoBotaoQrCode
                                      </td>
                                      <td align='center'>$dataAtendimento</td>
                                      <td align='center'>$dataPrazoRetirada</td>
                                      <td>$agendadoPor</td>
                                    </tr></tbody></table>";
                                    ?>
                              </div>
                            </div>
                          </div>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" onClick="gravarEntrega()" id='btnConfirmarEntrega' style="<?php echo $mostarComandoConfirmar;?>"><i class="fa fa-check-square-o"></i> Confirmar</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  
  $('#documentos_agendados').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });


  function gravarEntrega() {

    var tipoVagaOcupada = "<?php echo $tipoVagaOcupada; ?>";

    if ($("#nomePortador").val() == "" || $("#documentoPortador").val() == "" || $("#telefonePortador").val() == "") {
      swal("Dados do Portador", "Os dados do portador são de preenchimento obrigatório.", "error");
      return false;
    }

    if (tipoVagaOcupada == "POLICLÍNICA") {
      if ($("#carroPoliclinica").val() == "") {
        swal("Carro da Policlínica", "Você deve informar se o paciente precisará carro para a policlínica.", "error");
        return false;
      }
      if ($("#carroPoliclinica").val() == "S" && $("#acompanhantePoliclinica").val() == "") {
        swal("Dados do Acompanhante", "Você deve informar se o paciente precisará de acompanhanete.", "error");
        return false;
      }
      if ($("#acompanhantePoliclinica").val() == "S" && $("#nomeAcompanhante").val() == "" && $("#documentoAcompanhante").val() == "" && $("#maeAcompanhante").val() == "" && $("#dataNascimentoAcompanhanete").val() == "") {
        swal("Dados do Acompanhante", "Todos os dados do acompanhanete são obrigatórios", "error");
        return false;
      }
      if ($("#carroPoliclinica").val() == "S" && $("#localPartidaTransporte").val() == "") {
        swal("Local de Partida", "O preenchimento do local de partida é obrigatório.", "error");
        return false;
      }
    }

    $("#embacado").css("display", "block");

    $.ajax({
      url: 'action/gravar_entrega_avulso',
      type: 'post',
      dataType: 'html',
      data: {
        'idAgendamento': $("#idAgendamento").val(),
        'nomePortador': $("#nomePortador").val(),
        'documentoPortador': $("#documentoPortador").val(),
        'telefonePortador': $("#telefonePortador").val(),
        'carroPoliclinica': $("#carroPoliclinica").val(),
        'acompanhantePoliclinica': $("#acompanhantePoliclinica").val(),
        'nomeAcompanhante': $("#nomeAcompanhante").val(),
        'documentoAcompanhante': $("#documentoAcompanhante").val(),
        'maeAcompanhante': $("#maeAcompanhante").val(),
        'dataNascimentoAcompanhanete': $("#dataNascimentoAcompanhanete").val(),
        'localPartidaTransporte': $("#localPartidaTransporte").val()
      }
    }).done(function(resultadoRetorno) {
      $("#btnCancelarSolicitacao").prop("disabled", true);
      $("#btnConfirmarEntrega").prop("disabled", true);
      $("#embacado").css("display", "none");
      swal("Entrega de Marcação", "Entrega de marcação registrado com sucesso. Pode realizar a impressão!", "success");
      $("#imprimirMarcacao").css("display", "inline");
      if (tipoVagaOcupada == "POLICLÍNICA") {
        $("#imprimirQrCorde").css("display", "inline");
      }
    });

  }

  $('#carroPoliclinica').change(function() {

    if (this.value == "S") {
      $("#acompanhantePoliclinica").prop("disabled", false);
      $("#nomeAcompanhante").prop("disabled", false);
      $("#documentoAcompanhante").prop("disabled", false);
      $("#maeAcompanhante").prop("disabled", false);
      $("#dataNascimentoAcompanhanete").prop("disabled", false);
      $("#localPartidaTransporte").prop("disabled", false);
    } else {
      $("#acompanhantePoliclinica").prop("disabled", true);
      $("#nomeAcompanhante").prop("disabled", true);
      $("#documentoAcompanhante").prop("disabled", true);
      $("#maeAcompanhante").prop("disabled", true);
      $("#dataNascimentoAcompanhanete").prop("disabled", true);
      $("#localPartidaTransporte").prop("disabled", true);
    }

    if (this.value == "N") {
      $("#acompanhantePoliclinica").val('');
      $("#nomeAcompanhante").val('');
      $("#documentoAcompanhante").val('');
      $("#maeAcompanhante").val('');
      $("#dataNascimentoAcompanhanete").val('');
      $("#localPartidaTransporte").val('');
    }

  });

  $('#acompanhantePoliclinica').change(function() {
    if (this.value == 'S') {
      $("#nomeAcompanhante").prop("disabled", false);
      $("#documentoAcompanhante").prop("disabled", false);
      $("#maeAcompanhante").prop("disabled", false);
      $("#dataNascimentoAcompanhanete").prop("disabled", false);
    } else {
      $("#nomeAcompanhante").prop("disabled", true);
      $("#documentoAcompanhante").prop("disabled", true);
      $("#maeAcompanhante").prop("disabled", true);
      $("#dataNascimentoAcompanhanete").prop("disabled", true);
      $("#nomeAcompanhante").val("");
      $("#documentoAcompanhante").val("");
      $("#maeAcompanhante").val("");
      $("#dataNascimentoAcompanhanete").val("");
    }
  });

  /* DADOS RELACIONADO AO TRANSPORTE */  
  $("#carroPoliclinica").val("<?php echo $carroPoliclinica;?>");
  $("#carroPoliclinica").trigger("change");
  $("#acompanhantePoliclinica").val("<?php echo $comAcompanhanete;?>");
  $("#carroPoliclinica").trigger("change");
  $("#localPartidaTransporte").val("<?php echo $localpartidaCarro;?>");

  /* ------------------------------- */
</script>