<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || $_SESSION['idPerfilLogado'] != '1') {
  header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");

$formatarPerfil = array(
  'A'  => 'AMBOS',
  'E'  => 'EXECUTANTE',
  'S'  => 'SOLICITANTE',
  ''  => 'NÃO INFORMADO'
);

$idEstabelecimento        = $_GET['id'];
$stmDadosEstabelecimento  =  $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE codigoestabelecimento_cnes='$idEstabelecimento'");
$stmDadosEstabelecimento->execute();
$rsDadosEstabelecimento    = $stmDadosEstabelecimento->fetch(PDO::FETCH_OBJ);
$nomeEstabelecimento      = mb_strtoupper($rsDadosEstabelecimento->nfantasia_estabelecimento);
$cnesEstabelecimento      = $rsDadosEstabelecimento->cnes_estabelecimento;
$perfilEstabelecimento    = $formatarPerfil[$rsDadosEstabelecimento->perfil_estabelecimento];
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-architecture-alt" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Setores
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="icofont icofont-edit"></i><b>Dados do Setor</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomeEstabelecimento">Nome do Estabelecimento:</label>
                          <input type="text" id="nomeEstabelecimento" class="form-control text-uppercase" value="<?php echo $nomeEstabelecimento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cnesEstabelecimento">Nº do CNES:</label>
                          <input type="text" id="cnesEstabelecimento" class="form-control text-center" value="<?php echo $cnesEstabelecimento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="perfilEstabelecimento">Perfil do Estabelecimento:</label>
                          <input type="text" id="perfilEstabelecimento" class="form-control" value="<?php echo $perfilEstabelecimento; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="nomeSetor">Nome do Setor:</label>
                          <input type="text" id="nomeSetor" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="servicoSetor">Serviços do Setor:</label>
                          <input type="text" id="servicoSetor" class="form-control" />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="referirSetor">Como se Referir:</label>
                          <select type="text" id="referirSetor" class="form-control">
                            <option value="">SELECIONE...</option>
                            <option value="À">À</option>
                            <option value="AO">AO</option>
                            <option value="NA">NÃO AGRUPADOS</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-4">
                        <div class="form-group">
                          <button type="button" class="btn btn-blue" onClick="salvarSetor()"><i class="icofont icofont-checked"></i> Confirmar</button>
                          <button type="button" class="btn btn-danger" id="btnCancelar" disabled><i class="fa fa-times"></i> Cancelar</button>
                        </div>
                      </div>
                    </div>
                    <hr style='margin-top:-10px'>
                    <div class="row" style="margin-top:-15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <input type="hidden" id="idSetorEstabelecimento" class="form-control" disabled />
                          <table class="table table-striped table-bordered default-ordering" id="dados_setores" style="font-size: 9pt !important;">
                            <thead>
                              <tr style="background-repeat: repeat-x; height: 30px !important;">
                                <th style="text-align: center; width:12%">OPÇÕES</th>
                                <th style="width:25%">NOME DO SETOR</th>
                                <th>SERVIÇOS REALIZADOS</th>
                                <th style="text-align: center; width:12%">COMO SE REFERIR</th>
                              </tr>
                            </thead>
                            <tbody style="background-color: #f6f6f6;">
                              <?php
                              $stmSetorEstabelecimento  = $rsConexao->prepare("SELECT * FROM reg_tb_setoratendimento WHERE codigo_estabelecimento='$idEstabelecimento'");
                              $stmSetorEstabelecimento->execute();
                              if ($stmSetorEstabelecimento->rowCount() > 0) {
                                $rsSetorEstabelecimento  = $stmSetorEstabelecimento->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($rsSetorEstabelecimento as $fieldSetorEstabelecimento) {
                                  $idSetor        = $fieldSetorEstabelecimento['id_setoratendimento'];
                                  $nomeSertor      = mb_strtoupper($fieldSetorEstabelecimento['nome_setoratendimento']);
                                  $servicoSetor    = mb_strtoupper($fieldSetorEstabelecimento['servico_realizado']);
                                  $comoSeReferir  = $fieldSetorEstabelecimento['comochamar_setor'];
                                  $statusSetor    = $fieldSetorEstabelecimento['status_setor'] == "I" ? "style='background-color: #ffadad;color: #860000;'" : "";


                                  $linkEditarSetor  = '"editarSetor(' . "'$idSetor##$nomeSertor##$servicoSetor##$comoSeReferir')" . '"';

                                  if ($fieldSetorEstabelecimento['status_setor'] == "I") {
                                    $linkBloquearSetor  = '"bloqueioSetor(' . "'$idSetor','A')" . '"';
                                    $comandoBloqueio  = "<i class='icofont icofont-tick-boxed nova_fonte_blue' title='Bloquear setor.' onclick=$linkBloquearSetor></i>";
                                  } else {
                                    $linkBloquearSetor  = '"bloqueioSetor(' . "'$idSetor','I')" . '"';
                                    $comandoBloqueio  = "<i class='icofont icofont-not-allowed nova_fonte_delete' title='Bloquear setor.' onclick=$linkBloquearSetor></i>";
                                  }
                                  echo "<tr $statusSetor>
																			<td align='center'>
																				<i class='icofont icofont-edit nova_fonte' title='Editar dados do perfil de acesso.' onclick=$linkEditarSetor></i>&nbsp;
																				$comandoBloqueio
																			</td>
																			<td>$nomeSertor</td>
																			<td>$servicoSetor</td>
																			<td align='center'>$comoSeReferir</td>
																		</tr>";
                                }
                              }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $('#dados_setores').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function editarSetor(dadosEditar) {
    var splitDados = dadosEditar.split("##");
    $("#idSetorEstabelecimento").val(splitDados[0]);
    $("#nomeSetor").val(splitDados[1]);
    $("#servicoSetor").val(splitDados[2]);
    $("#referirSetor").val(splitDados[3]);
    $("#btnCancelar").prop("disabled", false);
  }

  $("#btnCancelar").click(function() {
    $("#idSetorEstabelecimento").val('');
    $("#nomeSetor").val('');
    $("#servicoSetor").val('');
    $("#referirSetor").val('');
    $("#btnCancelar").prop("disabled", true);
  });

  function bloqueioSetor(idSetor, statusSetor) {
    if (statusSetor == "A") {
      var tituloMensagem = "Desbloquear de Setor";
      var textoMensagem = "O setor selecionado será desbloqueado. O usuário já poderá associar o acesso a este setor. Confirma?";
      var textoCandelou = "O setor selecionado não foi desbloqueado.";
      var textoSucesso = "Setor desbloqueado com sucesso."
    } else {
      var tituloMensagem = "Bloquear de Setor";
      var textoMensagem = "O setor selecionado será bloqueado. O usuário não poderá associar o acesso a este setor. Confirma?";
      var textoCandelou = "O setor selecionado não foi bloqueado.";
      var textoSucesso = "Setor bloqueado com sucesso."
    }
      
    Swal.fire({
      title: tituloMensagem,
      html: "<p style='text-align:justify'>"+textoMensagem+"</p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $('#embacado').css("display", 'block');
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'setor-estabelecimento',
            'idRegistroExclusao': idSetor,
            'idEstabelecimento': "<?php echo $idEstabelecimento; ?>",
            'statusSetor': statusSetor
          }
        }).done(function(resultadoRetorno) {

          $('#dados_setores').DataTable().destroy();
          $('#dados_setores tbody').empty().append(resultadoRetorno);
          $('#dados_setores').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          $("#btnCancelar").prop("disabled", true);
          $("#embacado").css("display", "none");
          swal(tituloMensagem, textoSucesso, "success");

          $("#idUsuarioPerfil").val('');
          $("#perfilAcesso").val('');
          $("#perfilAcesso").trigger('change');
          $("#btnCancelar").prop("disabled", false);
        });
      }
    });


  }

  function salvarSetor() {

    if ($("#nomeSetor").val() == "" || $("#referirSetor").val() == "") {
      swal("Dados Obrigatórios.", "Você deve informar nome do setor e como se referir ao mesmo.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_estabelecimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoCadastro': 'cadastrar-setor-estabelecimento',
        'idEstabelecimento': "<?php echo $idEstabelecimento; ?>",
        'idSetorEstabelecimento': $("#idSetorEstabelecimento").val(),
        'nomeSetor': $("#nomeSetor").val(),
        'servicoSetor': $("#servicoSetor").val(),
        'referirSetor': $("#referirSetor").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno == "jáExiste") {
        swal("Cadastro Duplicado.", "Setor já cadastrado para este estabelecimento.", "error");
        return false;
      }
      $('#dados_setores').DataTable().destroy();
      $('#dados_setores tbody').empty().append(resultadoRetorno);
      $('#dados_setores').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#btnCancelar").prop("disabled", true);
      $("#embacado").css("display", "none");
      swal("Cadastro de Setor.", "Setor cadastrado com sucesso.", "success");
      $("#idSetorEstabelecimento").val('');
      $("#nomeSetor").val('');
      $("#servicoSetor").val('');
      $("#referirSetor").val('');
    });

  }
</script>