<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-calendar" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Feriado
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="ft-info"></i> <b>Dados para Registro</b>
											<input type="hidden" id="idFeriado">
										</h4>
										<div class="row">
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicialFeriado">Data Inicial:</label>
													<input type="date" id="dataInicialFeriado" class="form-control">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataFinalFeriado">Data Final:</label>
													<input type="date" id="dataFinalFeriado" class="form-control">
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="descricaoFeriado">Descrição do Feriado:</label>
													<input type="text" id="descricaoFeriado" class="form-control">
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-3">
												<div class="form-group">
													<button type="button" class="btn btn-info" onClick="cadastrarFeriado()">
														<i class="fa fa-check-square-o"></i> Salvar
													</button>
													<button type="button" class="btn btn-danger" id="btnCancelar" onClick="cancelarEdicao()" disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
												</div>
											</div>
										</div>
									</div><br>
									<div class="form-body" style="border-top:1px dotted gray; margin-top:-20px">
										<h4 class="form-section"><i class="ft-list"></i> <b>Lista de feriados cadastrados</b></h4>
										<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering" id='dados_feriados'>
									<thead>
										<th style='text-align:center' width='100px'>&nbsp;OPÇÕES&nbsp;</th>
										<th style='text-align:center' width='100px'>DATA INICIAL</th>
										<th style='text-align:center' width='100px'>DATA FINAL</th>
										<th style='text-align:center'>DESCRIÇÃO</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
										<?php
										$sqlFeriado	= "SELECT *, id_feriado, date_format(data_inicioferiado,'%d/%m/%Y') as dataInicial, date_format(data_fimferiado,'%d/%m/%Y') as dataFinal, date_format(data_fimferiado,'%Y-%m-%d') as dataFimValidacao, descricao_feriado FROM reg_tb_feriados ORDER BY data_fimferiado DESC";
										$stmFeriado	= $rsConexao->prepare($sqlFeriado);
										$stmFeriado->execute();
										if ($stmFeriado->rowCount() > 0) {
											$rsFeriado	= $stmFeriado->fetchAll(PDO::FETCH_ASSOC);
											foreach ($rsFeriado as $fieldFeriado) {
												$idFeriado					= $fieldFeriado['id_feriado'];
												$dataInicial				= $fieldFeriado['dataInicial'];
												$dataFinal					= $fieldFeriado['dataFinal'];
												$dataInicioFeriado	= $fieldFeriado['data_inicioferiado'];
												$dataFinalFeriado		= $fieldFeriado['data_fimferiado'];
												$descricaoFeriado		= mb_strtoupper($fieldFeriado['descricao_feriado']);

												$esconderComando      = $fieldFeriado['dataFimValidacao'] < date("Y-m-d") ? "style='display:none'" : "";
												$corFundoDatafinal    = $fieldFeriado['dataFimValidacao'] < date("Y-m-d") ? "style='background-color: #e2aaaa !important; color: #700000'" : "";

												$linkEditarFeriado	= '"editarFeriado(' . "'$idFeriado##$dataInicioFeriado##$dataFinalFeriado##$descricaoFeriado')" . '"';
												$linkExcluirFeriado	= '"excluirFeriado(' . "'$idFeriado')" . '"';
												echo "<tr>
																			<td style='text-align:center'>
																				<i class='icofont icofont-edit nova_fonte' title='Editar registro de feriado.' $esconderComando onclick=$linkEditarFeriado></i>&nbsp;
																				<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de feriado.' $esconderComando onclick=$linkExcluirFeriado></i>
																			</td>
																			<td align='center'>$dataInicial</td>
																			<td align='center' $corFundoDatafinal>$dataFinal</td>
																			<td>$descricaoFeriado</td>
																		</tr>";
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liFeriados").attr('class', 'active');
	$("#liFeriados").css("border-bottom", "2px solid #c4c8ca");

	function cadastrarFeriado() {

		var dataInicialFeriado = $("#dataInicialFeriado").val();
		var dataFinalFeriado = $("#dataFinalFeriado").val();
		var descricaoFeriado = $("#descricaoFeriado").val();

		if (dataInicialFeriado == "" && dataFinalFeriado == "") {
			swal("Dados Obrigatórios", "Você deve preencher as informações de datas do feriado.", "error");
			return false;
		}

		if ((dataInicialFeriado != "" && dataFinalFeriado != "") && (dataInicialFeriado > dataFinalFeriado)) {
			swal("Período Inváido", "A data inicial não pode ser maior do que a data final", "error");
			return false;
		}

		if ((dataInicialFeriado != "" && dataFinalFeriado == "") || (dataInicialFeriado == "" && dataFinalFeriado != "")) {
			swal("Período Inváido", "Para cadastrar o período de feriado, você deve informar data inicial de final. Caso seja um único dia, digite a mesa data nos dois campos.", "error");
			return false;
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'action/gravar_feriado',
			type: 'post',
			dataType: 'html',
			data: {
				'idFeriado': $("#idFeriado").val(),
				'dataInicialFeriado': dataInicialFeriado,
				'dataFinalFeriado': dataFinalFeriado,
				'descricaoFeriado': $("#descricaoFeriado").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			$("#btnCancelar").prop("disabled", true);
			if (resultadoRetorno == "JaExiste") {
				swal("Registro Existente", "Já existe um feriado cadastrado no período informado.", "error");
				return false;
			} else {
				$('#dados_feriados').DataTable().destroy();
				$('#dados_feriados tbody').empty().append(resultadoRetorno);
				$('#dados_feriados').DataTable();
				$("#idFeriado").val('');
				$("#dataInicialFeriado").val('');
				$("#dataFinalFeriado").val('');
				$("#descricaoFeriado").val('');
			}
		});

	}

	function cancelarEdicao() {
		$("#idFeriado").val('');
		$("#dataInicialFeriado").val('');
		$("#dataFinalFeriado").val('');
		$("#descricaoFeriado").val('');
		$("#dataInicialFeriado").focus();
		$("#btnCancelar").prop("disabled", true);
	}


	function editarFeriado(conteudoEdicao) {

		var splitCoteudo = conteudoEdicao.split("##");
		$("#idFeriado").val(splitCoteudo[0]);
		$("#dataInicialFeriado").val(splitCoteudo[1]);
		$("#dataFinalFeriado").val(splitCoteudo[2]);
		$("#descricaoFeriado").val(splitCoteudo[3]);
		$("#dataInicialFeriado").focus();
		$("#btnCancelar").prop("disabled", false);

	}

	function excluirFeriado(idFeriado) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do feriado selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'feriado_cadastrado',
						'idRegistroExclusao': idFeriado
					}
				}).done(function(resultadoRetorno) {

					$('#dados_feriados').DataTable().destroy();
					$('#dados_feriados tbody').empty().append(resultadoRetorno);
					$('#dados_feriados').DataTable();
					$("#btnCancelar").prop("disabled", true);
					$("#embacado").css("display", "none");
					swal("Exclusão de Registro.", "Registro do feriado excluído com sucesso.", "success");

					$("#idFeriado").val('');
					$("#dataInicialFeriado").val('');
					$("#dataFinalFeriado").val('');
					$("#descricaoFeriado").val('');
					$("#dataInicialFeriado").focus();
					$("#btnCancelar").prop("disabled", true);

				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}
</script>