<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-stethoscope" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Grupo de Procedimentos
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="ft-info"></i> <b>Dados de Idetificação</b>
											<input type="hidden" id="idGrupo">
										</h4>
										<div class="row">
											<div class="col-md-5">
												<div class="form-group">
													<label for="nomeGrupo">Nome do Grupo:</label>
													<input type="text" id="nomeGrupo" class="form-control">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="grupoDisponivelGuiche">Exibir no Ghichê/Unidades:</label>
													<select id="grupoDisponivelGuiche" class="form-control">
														<option value="">SELECIONE...</option>
														<option value="S">SIM</option>
														<option value="N">NÃO</option>
													</select>
												</div>
											</div>
											<div class="col-md-4" style='padding-top:5px'>
												<label></label><br>
												<button type="button" class="btn btn-info" onClick="cadastrarGrupo()">
													<i class="fa fa-check-square-o"></i> Salvar
												</button>
												<button type="button" class="btn btn-danger" id="btnCancelar" onClick="cancelarEdicao()" disabled>
													<i class="fa fa-times"></i> Cancelar
												</button>
											</div>
										</div>
									</div><br>
									<div class="form-body" style="border-top:1px dotted gray; margin-top:-20px">
										<h4 class="form-section"><i class="ft-list"></i> <b>Lista de grupos cadastrados</b></h4>
										<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering" id='dados_grupos'>
									<thead>
										<th style='text-align:center' width='100px'>&nbsp;OPÇÕES&nbsp;</th>
										<th>NOME DO GRUPO</th>
										<th style='text-align:center' width='100px'>GUICHÊ</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
										<?php
										$stmGrupo    = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo");
										$stmGrupo->execute();
										$rsGrupo     = $stmGrupo->fetchAll(PDO::FETCH_ASSOC);
										$totalGrupo = $stmGrupo->rowCount();

										if ($totalGrupo > 0) {
											foreach ($rsGrupo as $fieldGrupo) {
												$idGrupo				= $fieldGrupo['id_grupo_procedimento'];
												$nomeGrupo			= mb_strtoupper($fieldGrupo['nome_grupo_procedimento']);
												$grupoNoGuiche	= mb_strtoupper($fieldGrupo['disponivel_guiche']);

												$grupoNoGuicheExibir = $fieldGrupo['disponivel_guiche'] == "S" ? "SIM" : "NÃO";

												$linkEditarGrupo	= '"editarGrupo(' . "'$idGrupo##$nomeGrupo##$grupoNoGuiche')" . '"';
												$linkExcluirGrupo	= '"excluirGrupo(' . "'$idGrupo')" . '"';
												echo "<tr>
																		<td style='text-align:center'>
																			<i class='icofont icofont-edit nova_fonte' title='Editar registro de Grupo.' onclick=$linkEditarGrupo></i>&nbsp;
																			<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de Grupo.'  onclick=$linkExcluirGrupo></i>
																		</td>
																		<td>$nomeGrupo</td>
																		<td style='text-align:center'>$grupoNoGuicheExibir</td>
																	</tr>";
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liGrupos").attr('class', 'active');
	$("#liGrupos").css("border-bottom", "2px solid #c4c8ca");

	function cadastrarGrupo() {

		var nomeGrupo = $("#nomeGrupo").val();

		if (nomeGrupo == "") {
			swal("Dados Obrigatórios", "Você deve preencher o nome do grupo de procedimentos.", "error");
			return false;
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'action/gravar_grupo',
			type: 'post',
			dataType: 'html',
			data: {
				'idGrupo': $("#idGrupo").val(),
				'nomeGrupo': nomeGrupo,
				'grupoDisponivelGuiche': $("#grupoDisponivelGuiche").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			$("#btnCancelar").prop("disabled", true);
			if (resultadoRetorno == "JaExiste") {
				swal("Registro Existente", "Já existe um grupo com o nome informado.", "error");
				return false;
			} else {
				$('#dados_grupos').DataTable().destroy();
				$('#dados_grupos tbody').empty().append(resultadoRetorno);
				$('#dados_grupos').DataTable();
				$("#idGrupo").val('');
				$("#nomeGrupo").val('');
				$("#grupoDisponivelGuiche").val('');
			}
		});

	}

	function cancelarEdicao() {
		$("#idGrupo").val('');
		$("#nomeGrupo").val('');
		$("#grupoDisponivelGuiche").val('');
		$("#nomeGrupo").focus();
		$("#btnCancelar").prop("disabled", true);
	}


	function editarGrupo(conteudoEdicao) {

		var splitCoteudo = conteudoEdicao.split("##");
		$("#idGrupo").val(splitCoteudo[0]);
		$("#nomeGrupo").val(splitCoteudo[1]);
		$("#grupoDisponivelGuiche").val(splitCoteudo[2]);
		$("#nomeGrupo").focus();
		$("#btnCancelar").prop("disabled", false);
	}

	function excluirGrupo(idGrupo) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do grupo selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'grupo_cadastrado',
						'idRegistroExclusao': idGrupo
					}
				}).done(function(resultadoRetorno) {

					if (resultadoRetorno == "ExisteProcedimento") {
						swal("Registro Existente", "Não é possível excluir o cadastro do grupo. Já existe procedimento associado.", "info");
						return false;
					} else {
						$('#dados_grupos').DataTable().destroy();
						$('#dados_grupos tbody').empty().append(resultadoRetorno);
						$('#dados_grupos').DataTable();
						$("#btnCancelar").prop("disabled", true);
						$("#embacado").css("display", "none");
						swal("Exclusão de Registro.", "Grupo de Procedimentos excluído com sucesso.", "success");
					}
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}
</script>