<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

$htmlRetorno = "";
?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-doctor" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Profissionais
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section">
											<i class="icofont icofont-edit"></i> <b>Dados de Idetificação</b>
											<input type="hidden" id="idProfissional" />
											<input type="hidden" id="idEstabelecimento" />
										</h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-3">
												<div class="form-group">
													<fieldset id='field-cpf'>
														<label for="cpfProfissional">CPF:</label>
														<div class="input-group">
															<input type="text" id="cpfProfissional" class="form-control text-center cpf-inputmask" autofocus onblur="validaCPF(this.value)">
															<div class="input-group-prepend">
																<button class="btn btn-blue" type="button" onclick="buscarProfissionalCPF()">
																	<i class="icofont icofont-document-search"></i>
																</button>
															</div>
														</div>
													</fieldset>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="cnsProfissional">CNS:</label>
													<input type="text" id="cnsProfissional" class="form-control text-center" disabled>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="nomeProfissional">Nome do Profissional:</label>
													<input type="text" id="nomeProfissional" class="form-control" disabled>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-info" onClick="salvarProfissional()" id="btnSalvarProfissional" style='width:120px'>
														<i class="icofont icofont-checked"></i> Confirmar
													</button>
													<button type="button" class="btn btn-danger" id="btnCancelarEdicao" style='width:120px' disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_profissionais'>
									<thead>
										<tr>
											<th style="text-align:center; width:80px">VÍNCULO</th>
											<th>NOME PROFISSIONAL</th>
											<th style="text-align:center; width:200px">CPF</th>
											<th style="text-align:center; width:200px">CNS</th>
										</tr>
									</thead>
									<tbody style="background-color:#f5f5f5">
										<?php
										$sqlProfissinoal  = "SELECT tb_profissional.codigoprofissional_cnes,
										tb_profissional.nome_profissional,
										tb_profissional.cpf_profissional,
										tb_profissional.cns_profissional
										FROM tb_profissional
										ORDER BY nome_profissional";
										$stmProfissinoal  = $rsConexao->prepare($sqlProfissinoal);
										$stmProfissinoal->execute();

										if ($stmProfissinoal->rowCount() > 0) {
											$rsProfissinoal   = $stmProfissinoal->fetchAll(PDO::FETCH_ASSOC);
											foreach ($rsProfissinoal as $fiedProfissinoal) {
												$idProfissional         = $fiedProfissinoal['codigoprofissional_cnes'];
												$nomeProfissinoal       = $fiedProfissinoal['nome_profissional'];
												$cpfProfissinoal        = $fiedProfissinoal['cpf_profissional'];
												$cnsProfissinoal        = $fiedProfissinoal['cns_profissional'];
												$linkProfissionalPerfil	= '"window.open(' . "'cadastrar_profissional_vinculo?idp=$idProfissional')" . '"';

												# -- relacionar vínculos do profissional --#
												$sqlVinculo = "SELECT rl_cbo.codigo_cbo,
												rl_cbo.nome_cbo,
												tb_profissional_vinculo.codigoestabelecimento_cnes,
												tb_estabelecimento.nfantasia_estabelecimento,
                        tb_estabelecimento.cnes_estabelecimento,
												tb_profissional_vinculo.registro_conselho
												FROM tb_profissional_vinculo
												INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
												INNER JOIN tb_estabelecimento
												ON (tb_profissional_vinculo.codigoestabelecimento_cnes =
												tb_estabelecimento.codigoestabelecimento_cnes) 
												WHERE (tb_profissional_vinculo.codigoprofissional_cnes='$idProfissional')";
												$stmVinculo	= $rsConexao->prepare($sqlVinculo);
												$stmVinculo->execute();
												if ($stmVinculo->rowCount() > 0) {
													$rsVinculo		= $stmVinculo->fetchAll(PDO::FETCH_ASSOC);
													$nomeUnidade	= "";
													$nomeCBO			= "";
													foreach ($rsVinculo as $fieldVinculo) {
														$nomeCBO	= mb_strtoupper($fieldVinculo['codigo_cbo'] . '-' . $fieldVinculo['nome_cbo']);
														if ($nomeUnidade == "") {
															$nomeUnidade	= "&bull; " . $fieldVinculo['cnes_estabelecimento'] . ' - ' . mb_strtoupper($fieldVinculo['nfantasia_estabelecimento']) . " - (CBO: $nomeCBO)";
														} else {
															$nomeUnidade	= "$nomeUnidade<br>&bull; " . $fieldVinculo['cnes_estabelecimento'] . ' - ' . mb_strtoupper($fieldVinculo['nfantasia_estabelecimento']) . " - (CBO: $nomeCBO)";
														}
													}
													$corFontVinculo = "#027fbe";
												}else{
													$nomeUnidade	= "&bull; PROFISSIONAL SEM VÍNCULO CADASTRADO";
													$corFontVinculo = "#830202";
												}
												# --------------- #
												echo "<tr>
												<td align='center'>
													<i class='icofont icofont-contact-add nova_fonte blue' style='font-size:16pt' title='Vincular profissional.' onclick=$linkProfissionalPerfil></i>
												</td>
												<td>
													<b>$nomeProfissinoal</b>
													<div style='width:auto; padding:2px; color:$corFontVinculo'>
														$nomeUnidade
													</div>
												</td>
												<td align='center'>$cpfProfissinoal</td>
												<td align='center'>$cnsProfissinoal</td>
											</tr>";
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_pesquisa_cbo_profissional.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	setClassTable("dados_profissionais");
	$("#liProfissionais").attr('class', 'active');
	$("#liProfissionais").css("border-bottom", "2px solid #c4c8ca");

	$("#cpfProfissional").blur(function() {
		if (this.value == "") {
			$("#cnsProfissional").val("");
			$("#nomeProfissional").val("");
		}
	});

	function validaCPF(numeroCPF) {


		var numeros, digitos, soma, i, resultado, digitos_iguais;
		digitos_iguais = 1;

		var cpfLimpo = numeroCPF.replace(/[^a-z0-9]/gi, '');

		if (cpfLimpo != "") {
			for (i = 0; i < cpfLimpo.length - 1; i++)
				if (cpfLimpo.charAt(i) != cpfLimpo.charAt(i + 1)) {
					digitos_iguais = 0;
					break;
				}
			if (!digitos_iguais) {
				numeros = cpfLimpo.substring(0, 9);
				digitos = cpfLimpo.substring(9);
				soma = 0;
				for (i = 10; i > 1; i--)
					soma += numeros.charAt(10 - i) * i;
				resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
				if (resultado != digitos.charAt(0)) {
					swal("CPF Inválido", "O CPF digitado não é válido. [" + numeroCPF + "]", 'error');
					$("#cpfProfissional").val('');
					return false;
				}
				numeros = cpfLimpo.substring(0, 10);
				soma = 0;
				for (i = 11; i > 1; i--)
					soma += numeros.charAt(11 - i) * i;
				resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
				if (resultado != digitos.charAt(1)) {
					swal("CPF Inválido", "O CPF digitado não é válido. [" + numeroCPF + "]", 'error');
					$("#cpfProfissional").val('');
					return false;
				} else {
					return true;
				}
			} else {
				swal("CPF Inválido", "O CPF digitado não é válido. [" + numeroCPF + "]", 'error');
				$("#cpfProfissional").val('');
				return false;
			}
			return false;
		} else {
			return true;
		}
	}

	function buscarProfissionalCPF() {

		if ($("#cpfProfissional").val() == "") {
			swal("CPF Obrigatório", "Você deve informar o CPF do profissional para carregar os dados da base nacional.", 'error');
			return false;
		}
		$("#embacado").css("display", "block");
		$("#cnsProfissional").val('')
		$("#nomeProfissional").val('')
		$.ajax({
			url: 'filtros/filtrar_profissional',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoFiltro': 'profissional-webservice-cns',
				'idReferencia': $("#cpfProfissional").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			var objetoJson = JSON.parse(resultadoRetorno);
			if (objetoJson['mensagemRetorno'] == "sucesso") {
				$("#cnsProfissional").val(objetoJson['jsonCNSProfissional'])
				$("#nomeProfissional").val(objetoJson['jsonNomeProfissional'])
			} else {
				swal("CPF Obrigatório", "Você deve informar o CPF do profissional para carregar os dados da base nacional.", 'error');
				return false;
			}
		});
	}

	function salvarProfissional() {

		if ($("#nomeProfissional").val() == "" || $("#cpfProfissional").val() == "" || $("#cnsProfissional").val() == "") {
			swal("Dados Obrigatórios", "Você deve preencher todas as informações para cadastrar o profissional.", 'error');
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_profissional',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'dados-profissional',
				'idProfissional': $("#idProfissional").val(),
				'cpfProfissional': $("#cpfProfissional").val(),
				'cnsProfissional': $("#cnsProfissional").val(),
				'nomeProfissional': $("#nomeProfissional").val(),
				'codigoCBOProfissional': $("#codigoCBOProfissional").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			if (resultadoRetorno == "JaExiste") {
				swal('Profissional Existente', "Já existe um profissinal cadastrado com este CPF na mesma unidade.", 'error');
				return false;
			}

			$('#dados_profissionais').DataTable().destroy();
			$('#dados_profissionais tbody').empty().append(resultadoRetorno);
			$('#dados_profissionais').DataTable();

			$("#cpfProfissional").val('');
			$("#cnsProfissional").val('');
			$("#nomeProfissional").val('');
			$("#nomeCBOProfissional").val('');
			$("#codigoCBOProfissional").val('');

		});

	}

	function editarProfissional(idEstabelecimento, idProfissional) {

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/buscar_dados_edicao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoBusca': 'editar-profissional',
				'idEstabelecimento': idEstabelecimento,
				'idProfissional': idProfissional
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			$("#idProfissional").val(idProfissional);
			$("#idEstabelecimento").val(idEstabelecimento);
			var objetoJson = JSON.parse(resultadoRetorno);
			$("#cpfProfissional").val(objetoJson['cpfProfissional']);
			$("#cnsProfissional").val(objetoJson['cnsProfissional']);
			$("#nomeProfissional").val(objetoJson['nomeProfissional']);
			$("#codigoCBOProfissional").val(objetoJson['codigoCBOProfissional']);
			$("#nomeCBOProfissional").val(objetoJson['nomeCBOProfissional']);
			$('#btnCancelarEdicao').prop('disabled', false);
		});

	}

	function excluirParametro(idParametro, idUnidade) {

		swal({
			title: "Exclusão de Parâmetro",
			text: "Confirma exclusão do parâmetro selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'parametro-profissional',
						'idUnidade': idUnidade,
						'idRegistroExclusao': idParametro
					}
				}).done(function(resultadoRetorno) {
					$("#embacado").css("display", "none");
					$('#dados_profissionais').DataTable().destroy();
					$('#dados_profissionais tbody').empty().append(resultadoRetorno);
					$('#dados_profissionais').DataTable();
					swal("Exclusão de Parâmetro.", "O parâmetro selecionado foi excluído com sucesso.", "success");
				});

			} else {
				swal("Operação Cancelada.", "O parâmetro selecionado não foi excluído.", "info");
			}

		});
	}

	function statusProfissional(codigoEstabelecimento, codigoProfissional, statusProfissional) {

		var tituloMensagem = statusProfissional == "ativar" ? "Ativação do Cadastro" : "Detivação do Cadastro";
		var mensagemConfirmacao = statusProfissional == "ativar" ? "Confirma ativação do cadastro do profissional?" : "Confirma desativação do cadastro do profissional?";
		var mensagemResultado = statusProfissional == "ativar" ? "Cadastro do profissional ativado com sucesso." : "Cadastro do profissional desativado com sucesso.";

		swal({
			title: tituloMensagem,
			text: mensagemConfirmacao,
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$("#embacado").css("display", "block");
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'status-profissional-saude',
						'idRegistroExclusao': codigoProfissional,
						'codigoEstabelecimento': codigoEstabelecimento,
						'statusProfissional': statusProfissional
					}
				}).done(function(resultadoRetorno) {
					$('#dados_profissionais').DataTable().destroy();
					$('#dados_profissionais tbody').empty().append(resultadoRetorno);
					$('#dados_profissionais').DataTable();
					swal(tituloMensagem, mensagemResultado, "success");
					$("#embacado").css("display", "none");
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi alterado.", "info");
			}

		});

	}

	function abrirJanelaCBO() {
		$("#conteudoPesquisa").val('')
		$("#resultadoRetornoCBO").html('');
		$('#box_pesquisa_cbo_profissional').modal();
	}

	$("#btnCancelarEdicao").click(function() {
		$("#idProfissional").val('');
		$("#cpfProfissional").val('');
		$("#cnsProfissional").val('');
		$("#nomeProfissional").val('');
		$("#nomeCBOProfissional").val('');
		$("#codigoCBOProfissional").val('');
		$("#btnCancelarEdicao").prop("disabled", true);
	})
</script>