<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");
$idProfissional  = $_GET['idp'];

$stmProfissional  =  $rsConexao->prepare("SELECT * FROM tb_profissional WHERE codigoprofissional_cnes='$idProfissional'");
$stmProfissional->execute();
$rsProfissional    = $stmProfissional->fetch(PDO::FETCH_OBJ);
$nomeProfissional  = $rsProfissional->nome_profissional;
$cpfProfissional  = $rsProfissional->cpf_profissional;
$cnsProfissional  = $rsProfissional->cns_profissional;
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-contact-add" style='margin-top:-15px !important'></i>&nbsp;Atribuir Vínculo do Profissional
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="ft-user"></i>
                      <b>Dados do Usuário</b>
                    </h4>
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomeProfissional">Nome do Profissional:</label>
                          <input type="text" id="nomeProfissional" class="form-control" value="<?php echo $nomeProfissional; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cpfProfissional">CPF do Profissional:</label>
                          <input type="text" id="cpfProfissional" class="form-control text-center cpf-inputmask" value="<?php echo $cpfProfissional; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cnsProfissional">CNS do Profissional:</label>
                          <input type="text" id="cnsProfissional" class="form-control text-center cns-inputmask" value="<?php echo $cnsProfissional; ?>" disabled />
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cboProfissional" id='lblcboProfissional'>CBO - Especialidade:</label>
                          <fieldset>
                            <div class="input-group">
                              <div class="input-group-prepend">
                                <button class="btn btn-blue" type="button" onClick="$('#box_pesquisa_cbo_profissional').modal()" title="Consultar CBO do profissional"><i class="ft-search"></i></button>
                              </div>
                              <input type="text" id="nomeCBOProfissional" class="form-control" disabled>
                            </div>
                            <input type="hidden" id="opcaoGravacao" value="novo" disabled>
                            <input type="hidden" id="codigoCBOProfissional" class="form-control" disabled>
                            <input type="hidden" id="edicaoCBO" class="form-control" disabled>
                            <input type="hidden" id="edicaoUnidade" class="form-control" disabled>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="unidadeVinculada">Estabelecimento Vinculada:</label>
                          <select type="text" id="unidadeVinculada" class="form-control">
                            <option value="">SELECIONE...</option>
                            <?php
                            $sqlUnidade = "SELECT * FROM tb_estabelecimento WHERE codigoestabelecimento_cnes!='9999999999999' ORDER BY nfantasia_estabelecimento";
                            $stmUnidade  = $rsConexao->prepare($sqlUnidade);
                            $stmUnidade->execute();
                            $rsUnidade  = $stmUnidade->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($rsUnidade as $fieldUnidade) {
                              $idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
                              $nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
                              echo "<option value='$idUnidade'>$nomeUnidade</option>";
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="registroConselho" id='lblregistroConselho'>Reg Conselho:</label>
                          <input type="text" id="registroConselho" class="form-control text-center">
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label>&nbsp;</label><br>
                          <button type="button" class="btn btn-blue" onClick="salvarVinculo()"><i class="icofont icofont-checked"></i> Confirmar</button>
                          <button type="button" class="btn btn-danger" id="btnCancelar" disabled><i class="fa fa-times"></i> Cancelar</button>
                        </div>
                      </div>
                    </div>
                    <hr style='margin-top:-10px'>
                    <div class="row" style="margin-top:-15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <input type="hidden" id="idUsuarioPerfil" class="form-control" disabled />
                          <table class="table table-striped table-bordered default-ordering" id="dados_vinculo" style="font-size: 9pt !important;">
                            <thead>
                              <tr style="background-repeat: repeat-x; height: 30px !important;">
                                <th style="text-align: center; width:10%">OPÇÕES</th>
                                <th style='width:30%'>CBO/ESPECIALIDADE</th>
                                <th>NOME DO ESTAVELECIMENTO VINCULADA</th>
                                <th style="text-align: center; width:12%">REGISTRO CONSELHO</th>
                              </tr>
                            </thead>
                            <tbody style="background-color: #f6f6f6;">
                              <?php
                              $sqlVinculo = "SELECT rl_cbo.codigo_cbo,
															rl_cbo.nome_cbo,
															tb_profissional_vinculo.codigoestabelecimento_cnes,
															tb_estabelecimento.nfantasia_estabelecimento,
															tb_profissional_vinculo.registro_conselho,
															tb_profissional_vinculo.status_vinculos_profissional
															FROM tb_profissional_vinculo
															INNER JOIN rl_cbo ON (tb_profissional_vinculo.codigo_cbo = rl_cbo.codigo_cbo)
															INNER JOIN tb_estabelecimento tb_estabelecimento
															ON (tb_profissional_vinculo.codigoestabelecimento_cnes =
															tb_estabelecimento.codigoestabelecimento_cnes) 
															WHERE (tb_profissional_vinculo.codigoprofissional_cnes='$idProfissional')";
                              $stmVinculo  = $rsConexao->prepare($sqlVinculo);
                              $stmVinculo->execute();
                              if ($stmVinculo->rowCount() > 0) {
                                $rsVinculo  = $stmVinculo->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($rsVinculo as $fieldVinculo) {
                                  $codigoCBO          = $fieldVinculo['codigo_cbo'];
                                  $nomeCBO            = mb_strtoupper($fieldVinculo['nome_cbo']);
                                  $codigoUnidade      = mb_strtoupper($fieldVinculo['codigoestabelecimento_cnes']);
                                  $nomeUnidade        = mb_strtoupper($fieldVinculo['nfantasia_estabelecimento']);
                                  $registroConselho    = mb_strtoupper($fieldVinculo['registro_conselho']);
                                  $statusVinculo      = $fieldVinculo['status_vinculos_profissional'];
                                  $linkEditarVinculo  = '"editarVinculo(' . "'$codigoCBO','$nomeCBO','$codigoUnidade',$registroConselho)" . '"';

                                  if ($statusVinculo == "I") {
                                    $corLinha = "style='background-color:#f3b5b5 !important; color: #700000'";
                                    $linkAcaoVinculo  = '"ativarDesativarVinculo(' . "'ativar','$codigoCBO','$codigoUnidade')" . '"';
                                    $iconeComando      = "icofont icofont-tick-boxed nova_fonte_blue";
                                  } else {
                                    $corLinha = "style=";
                                    $linkAcaoVinculo  = '"ativarDesativarVinculo(' . "'desativar','$codigoCBO','$codigoUnidade')" . '"';
                                    $iconeComando      = "icofont icofont-ui-block nova_fonte_delete";
                                  }
                                  echo "<tr $corLinha>
																			<td align='center'>
																				<i class='icofont icofont-edit nova_fonte' title='Editar dados do vínculo do profissional.' onclick=$linkEditarVinculo></i>&nbsp;
																				<i class='$iconeComando' title='desativar vínculo do profissional.' onclick=$linkAcaoVinculo></i>
																			</td>
																			<td>$codigoCBO - $nomeCBO</td>
																			<td>$nomeUnidade</td>
																			<td align='center'>$registroConselho</td>
																		</tr>";
                                }
                              }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>
<?php
include_once("footer.php");
include_once("include/box_pesquisa_cbo_profissional.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $('#dados_vinculo').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function pesquisaCBO() {

    if ($("#conteudoPesquisa").val() == "") {
      swal("Informação Obrigatória", "Você deve informar o CBO que deseja pesquisar.", 'error');
      return false;
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_cbo',
      type: 'post',
      dataType: 'html',
      data: {
        'conteudoPesquisa': $("#conteudoPesquisa").val()
      }
    }).done(function(resultadoRetorno) {
      $("#resultadoRetornoCBO").html(resultadoRetorno);
      $("#embacado").css("display", "none");
    });
  }


  function editarVinculo(codigoCBO, nomeCBO, codigoUnidade, regConselho) {
    $("#codigoCBOProfissional").val(codigoCBO);
    $("#nomeCBOProfissional").val(nomeCBO);
    $("#unidadeVinculada").val(codigoUnidade);
    $("#registroConselho").val(regConselho);
    $("#edicaoCBO").val(codigoCBO);
    $("#edicaoUnidade").val(codigoUnidade);
    $("#opcaoGravacao").val('editar')
    $("#btnCancelar").prop("disabled", false);
  }

  $("#btnCancelar").click(function() {
    $("#btnCancelar").prop("disabled", false);
    $("#codigoCBOProfissional").val('');
    $("#nomeCBOProfissional").val('');
    $("#unidadeVinculada").val('');
    $("#registroConselho").val('');
    $("#edicaoCBO").val('');
    $("#edicaoUnidade").val('');
    $("#opcaoGravacao").val('novo')
    $("#btnCancelar").prop("disabled", false);
  });

  function salvarVinculo() {

    if ($("#codigoCBOProfissional").val() == "" || $("#unidadeVinculada").val() == "") {
      swal("Dados Obrigatórios.", "Você deve informar pelo menos CBO e estabelecimento de saúde.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_profissional',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoCadastro': 'dados-vinculo',
        'opcaoGravacao': $("#opcaoGravacao").val(),
        'idProfissional': "<?php echo $idProfissional; ?>",
        'codigoCBOProfissional': $("#codigoCBOProfissional").val(),
        'unidadeVinculada': $("#unidadeVinculada").val(),
        'registroConselho': $("#registroConselho").val(),
        'edicaoCBO': $("#edicaoCBO").val(),
        'edicaoUnidade': $("#edicaoUnidade").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno == "jáExiste") {
        swal("Cadastro Duplicado.", "Vínculo já cadastrado para este profissional na unidade selecionada.", "error");
        return false;
      }
      $('#dados_vinculo').DataTable().destroy();
      $('#dados_vinculo tbody').empty().append(resultadoRetorno);
      $('#dados_vinculo').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });

      $("#btnCancelar").prop("disabled", true);
      $("#embacado").css("display", "none");
      swal("Cadastro de Vínculo.", "Vínculo do profissional cadastrado com sucesso.", "success");

      $("#codigoCBOProfissional").val('');
      $("#nomeCBOProfissional").val('');
      $("#unidadeVinculada").val('');
      $("#registroConselho").val('');
      $("#edicaoCBO").val('');
      $("#edicaoUnidade").val('');
      $("#opcaoGravacao").val('novo');


    });

  }

  function ativarDesativarVinculo(acaoRegistro, codigoCBO, unidadeVinculada) {

    var idProfissional = "<?php echo $idProfissional; ?>";

    if (acaoRegistro == "ativar") {
      var tituloMensagem = "Ativavação de Vínculo";
      var textoMensagem = "O vínculo selecionado será ativado. Confirma?";
      var mensagemReterno = "Vínculo ativado com sucesso.";
    } else {
      var tituloMensagem = "Desativação de Vínculo";
      var textoMensagem = "O vínculo selecionado será desativado. Confirma?";
      var mensagemReterno = "Vínculo desativado com sucesso.";
    }

    Swal.fire({
      title: tituloMensagem,
      text: "<p style='text-align:justify'>"+textoMensagem+"</p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $('#embacado').css("display", 'block');
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'vinculo-profissional',
            'idRegistroExclusao': idProfissional,
            'codigoCBO': codigoCBO,
            'unidadeVinculada': unidadeVinculada,
            'valorRegistro': acaoRegistro == "ativar" ? "A" : "I"
          }
        }).done(function(resultadoRetorno) {

          $('#dados_vinculo').DataTable().destroy();
          $('#dados_vinculo tbody').empty().append(resultadoRetorno);
          $('#dados_vinculo').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          $("#embacado").css("display", "none");
          swal(tituloMensagem, mensagemReterno, "success");

          $("#btnCancelar").prop("disabled", true);
          $("#codigoCBOProfissional").val('');
          $("#nomeCBOProfissional").val('');
          $("#unidadeVinculada").val('');
          $("#registroConselho").val('');
          $("#edicaoCBO").val('');
          $("#edicaoUnidade").val('');
          $("#opcaoGravacao").val('novo')
        });
      }
    });

  }
</script>