<?php

session_start();

// Função para gerar texto aleatório
function gerarTextoAleatorio($length = 5) {
    $caracteres = '0123456789';
    return substr(str_shuffle($caracteres), 0, $length);
}

// Configuração do CAPTCHA
$largura = 160;
$altura = 50;
$quantidadeCaracteres = 5;
$texto = gerarTextoAleatorio($quantidadeCaracteres);

// Armazena o texto na sessão
$_SESSION['captcha'] = $texto;

// Cria a imagem
$imagem = imagecreate($largura, $altura);

// Definir cores
$fundo = imagecolorallocate($imagem, 255, 255, 255); // Branco
$corTexto = imagecolorallocate($imagem, 0, 0, 0); // Preto
$corRuido1 = imagecolorallocate($imagem, 255, 255, 255); // Azul claro
$corRuido2 = imagecolorallocate($imagem, 255, 255, 255); // Vermelho claro

// Adiciona ruído ao fundo
for ($i = 0; $i < 1000; $i++) {
    imagesetpixel($imagem, mt_rand(0, $largura), mt_rand(0, $altura), $corRuido1);
}
for ($i = 0; $i < 1000; $i++) {
    imagesetpixel($imagem, mt_rand(0, $largura), mt_rand(0, $altura), $corRuido2);
}

// Adiciona o texto ao CAPTCHA
$fonte = '../app-assets/fonts/calibri.ttf'; // Substitua pelo caminho da sua fonte TTF
if (!file_exists($fonte)) {
    die('A fonte TTF não foi encontrada!');
}

for ($i = 0; $i < strlen($texto); $i++) {
    $tamanhoFonte = mt_rand(20, 35);
    $angulo = mt_rand(-10, 30);
    $x = 20 + ($i * 30);
    $y = mt_rand(25, 47);
    imagettftext($imagem, $tamanhoFonte, $angulo, $x, $y, $corTexto, $fonte, $texto[$i]);
}

// Envia os cabeçalhos da imagem
header('Content-Type: image/png');
imagepng($imagem);

// Limpa a memória
imagedestroy($imagem);

?>