<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || $_SESSION['idPerfilLogado'] != 1) {
	header("location: sair.php");
}

include_once("header.php");
$usuarioLogado = $_SESSION['idUsuarioLogado'];



# -- carregar dados da configuração do sistema -- #
$stmConfiguracoes = "SELECT reg_tb_configuracoes.*,
ucase(tb_cidades.nome_cidade) nomeMunicipio,
tb_cidades.sigla_estado
FROM tb_cidades
INNER JOIN reg_tb_configuracoes ON (tb_cidades.codigoibge_cidade = reg_tb_configuracoes.ibge_municipiogestor)";
$stmConfiguracoes	= $rsConexao->prepare($stmConfiguracoes);
$stmConfiguracoes->execute();

if ($stmConfiguracoes->rowCount() > 0) {
	$rsConfiguracoes	= $stmConfiguracoes->fetch(PDO::FETCH_OBJ);
	$ibgeMunicipio                  = $rsConfiguracoes->ibge_municipiogestor;
	$nomeMunicipio                  = $rsConfiguracoes->nomeMunicipio . " - " . $rsConfiguracoes->sigla_estado;
	$estabelecimentoCentral         = $rsConfiguracoes->codigoestabelecimento_regulacao;
	$municipioExecutorSede          = $rsConfiguracoes->municipio_executorfora;
	$diasAberturaPrimeiraVez        = $rsConfiguracoes->diasabertura_pvez;
	$diasAberturaRetorno            = $rsConfiguracoes->diasabertura_retorno;
	$diasAberturaReserva            = $rsConfiguracoes->diasabertura_reserva;
	$bloquearSabDomFeriado          = $rsConfiguracoes->bloqueia_municipiopactuado;
	$bloquearPactuadoHoraInicio     = $rsConfiguracoes->bloqueia_municipiopactuado_inicio;
	$bloquearPactuadoHoraFim        = $rsConfiguracoes->bloqueia_municipiopactuado_fim;
	$solicitacaoExigeDocumentoAnexo = $rsConfiguracoes->exigirdocumento_identificacao;
	$exigirRequisicao								= $rsConfiguracoes->exigir_requisitaoapac;
	$usgMaraExigeMamografia         = $rsConfiguracoes->exigirmamografia_parausgmama;
	$mamografiaExigeFormulario      = $rsConfiguracoes->exigirformulario_mamografia;
	$exigirRelatorioMedico          = $rsConfiguracoes->exigir_relatoriomedico;
	$analiseSolicitacoes            = $rsConfiguracoes->solicitacao_paraanalise;
	$quemAnalisaSolicitacoes        = $rsConfiguracoes->quemanalisa_emergencia;
	$bloqueioPorFalta               = $rsConfiguracoes->diasbloqueio_porfalta;
	$limitacaoCotas                 = $rsConfiguracoes->controlar_cota;
	$bloquearPacienteFora           = $rsConfiguracoes->bloqueio_pacientefora;
	$idadePrioritariaFila						= $rsConfiguracoes->idate_prioritaria_fila;
	$numeroTelefoneBot							= $rsConfiguracoes->numero_telefone_bot;
	$numeroTelefoneLigacao					= $rsConfiguracoes->numero_telefone_ligacao;
} else {
	$ibgeMunicipio                  = "";
	$nomeMunicipio                  = "";
	$estabelecimentoCentral         = "";
	$municipioExecutorSede          = "";
	$diasAberturaPrimeiraVez        = "";
	$diasAberturaRetorno            = "";
	$diasAberturaReserva            = "";
	$bloquearSabDomFeriado          = "";
	$bloquearPactuadoHoraInicio     = "";
	$bloquearPactuadoHoraFim        = "";
	$solicitacaoExigeDocumentoAnexo = "";
	$exigirRequisicao								= "";
	$usgMaraExigeMamografia         = "";
	$mamografiaExigeFormulario      = "";
	$exigirRelatorioMedico          = "";
	$analiseSolicitacoes            = "";
	$quemAnalisaSolicitacoes        = "";
	$bloqueioPorFalta               = "";
	$limitacaoCotas                 = "";
	$bloquearPacienteFora           = "";
	$idadePrioritariaFila						= "";
	$numeroTelefoneBot							= "";
	$numeroTelefoneLigacao					= "";
}

# ------------------------------------------------#
?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-settings" style='margin-top:-15px !important'></i>&nbsp;Configurações Gerais do Sistema
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" id="form-configuracao-geral">
									<div class="form-body" style='margin-top:-10px'>
										<h4 class="form-section"><i class="icofont icofont-info-square"></i><b>Informações do Gestor</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-5">
												<div class="form-group">
													<label for="ibgeMunicipio" id='label-ibgeMunicipio'>Nome do Município Gestor:</label>
													<fieldset>
														<div class="input-group">
															<div class="input-group-prepend">
																<button class="btn btn-blue" type="button" onClick="abrirPesquisaMunicipio()" title="Consultar município."><i class="icofont icofont-search"></i></button>
															</div>
															<input type="text" id="nomeMunicipio" class="form-control" disabled value="<?php echo $nomeMunicipio; ?>">
														</div>
														<input type="hidden" id="ibgeMunicipio" class="form-control" disabled value="<?php echo $ibgeMunicipio; ?>">
													</fieldset>
												</div>
											</div>
											<div class="col-md-5">
												<div class="form-group">
													<label for="estabelecimentoCentral" id='label-estabelecimentoCentral'>Estabelecimento Central:</label>
													<select id="estabelecimentoCentral" class="form-control">
														<option value="">SELECIONE...</option>
														<?php
														$sqlUnidade = "SELECT * FROM tb_estabelecimento WHERE codigoestabelecimento_cnes!='9999999999999' ORDER BY nfantasia_estabelecimento";
														$stmUnidade	= $rsConexao->prepare($sqlUnidade);
														$stmUnidade->execute();
														$rsUnidade	= $stmUnidade->fetchAll(PDO::FETCH_ASSOC);
														foreach ($rsUnidade as $fieldUnidade) {
															$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
															$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
															echo "<option value='$idUnidade'>$nomeUnidade</option>";
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="municipioExecutorSede" id='label-municipioExecutorSede'>
														Executor para Fora:
														<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Selecione SIM cado seu municípios tenha pactuação como executor para outros municípios." data-trigger="hover" data-original-title="Pactuação como Executor"></i>
													</label>
													<select id="municipioExecutorSede" class="form-control">
														<option value="">SELECIONE...</option>
														<option value="S">SIM</option>
														<option value="N">NÃO</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-6">
												<div class="form-group">
													<h4 class="form-section"><i class="icofont icofont-calendar"></i><b>Dias para Abertura de Agendamentos</b></h4>
													<div class="row" style='margin-top:-10px;'>
														<div class="col-md-4">
															<div class="form-group">
																<label for="diasAberturaPrimeiraVez" id='label-diasAberturaPrimeiraVez'>Primeira Vez:</label>
																<input type="number" id="diasAberturaPrimeiraVez" class="form-control text-center" value="<?php echo $diasAberturaPrimeiraVez; ?>">
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="diasAberturaRetorno" id='label-diasAberturaRetorno'>Retorno:</label>
																<input type="number" id="diasAberturaRetorno" class="form-control text-center" value="<?php echo $diasAberturaRetorno; ?>">
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="diasAberturaReserva" id='label-diasAberturaReserva'>Reserva:</label>
																<input type="number" id="diasAberturaReserva" class="form-control text-center" value="<?php echo $diasAberturaReserva; ?>">
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<h4 class="form-section"><i class="fa fa-calendar-times-o"></i><b>Bloqueio de Município Pactuado</b></h4>
													<div class="row" style='margin-top:-10px;'>
														<div class="col-md-4">
															<div class="form-group">
																<label for="bloquearSabDomFeriado" id='label-bloquearSabDomFeriado'>Sábado/Domingo/Feriado:</label>
																<select id="bloquearSabDomFeriado" class="form-control">
																	<option value="">SELECIONE...</option>
																	<option value="S">SIM</option>
																	<option value="N">NÃO</option>
																</select>
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="bloquearPactuadoHoraInicio" id='label-bloquearPactuadoHoraInicio'>Horário Inicial:</label>
																<input type="time" id="bloquearPactuadoHoraInicio" class="form-control text-center" disabled value="<?php echo $bloquearPactuadoHoraInicio; ?>">
															</div>
														</div>
														<div class="col-md-4">
															<div class="form-group">
																<label for="bloquearPactuadoHoraFim" id='label-bloquearPactuadoHoraFim'>Horário Final:</label>
																<input type="time" id="bloquearPactuadoHoraFim" class="form-control text-center" disabled value="<?php echo $bloquearPactuadoHoraFim; ?>">
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<h4 class="form-section" style='margin-top:-30px'><i class="icofont icofont-upload-alt"></i><b>Exigir documentos anexos e outras configurações</b></h4>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="solicitacaoExigeDocumentoAnexo" id="label-solicitacaoExigeDocumentoAnexo">
															Exigir Doc. de Identificação:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Esta informação serve para determinar se o sistema deve exigir que seja anexado um documento de identificação com foto escaneado em PDF no ato do registro da solicitação na fila." data-trigger="hover" data-original-title="Documento de Identificação"></i>
														</label>
														<select id="solicitacaoExigeDocumentoAnexo" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="exigirRequisicao" id='label-exigirRequisicao'>
															Exigir Requisição:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Configurando esta opção com SIM será exigido pelo sistema que seja anexado o arquivo PDF da requisição, formuário de APAC ou outro formuáro que comprove a requisição da solicitação." data-trigger="hover" data-original-title="Requisição de Exame"></i>
														</label>
														<select id="exigirRequisicao" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="usgMaraExigeMamografia" id='label-usgMaraExigeMamografia'>
															USG de Mama Exige Mamografia:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Configurando como SIM o sistema exigirá que seja anexado em PDF o resultado da mamografia para realizar inclusão da solicitação de ultrassonografia mamária." data-trigger="hover" data-original-title="Resultado da Mamografia"></i>
														</label>
														<select id="usgMaraExigeMamografia" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="mamografiaExigeFormulario" id='label-mamografiaExigeFormulario'>
															Exigir Form de Mamografia:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Configurando como SIM o sistema exigirá que seja anexado em PDF o formulário padrão para mamografia no ato da inclusão da solicitação na fila." data-trigger="hover" data-original-title="Formulário de Mamografia"></i>
														</label>
														<select id="mamografiaExigeFormulario" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="analiseSolicitacoes" id="label-analiseSolicitacoes">
															Solicitação em Análise:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Determina qual tipo de solicitação deverá aguardar com status EM ANÁLISE para após avaliação ser encaminhada para a fila com o status AGUARDANDO AGENDAMENTO." data-trigger="hover" data-original-title="Status da Análise de Solicitação"></i>
														</label>
														<select id="analiseSolicitacoes" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="nenhuma">NENHUMA SOLICITAÇÃO</option>
															<option value="emergência">SOMENTE EMERGÊNCIA</option>
															<option value="emergência-murgente">EMERGÊNCIA E MUITO URGENTE</option>
															<option value="todas">TODAS AS SOLICITAÇÕES</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="exigirRelatorioMedico" id='label-exigirRelatorioMedico'>
															Exigir Relatório Médico:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Configurando esta opção com SIM será exigido pelo sistema que seja anexado o relatório médico que comprove a classificação de prioridade de agendamento como emergência." data-trigger="hover" data-original-title="Relatório Médico"></i>
														</label>
														<select id="exigirRelatorioMedico" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="quemAnalisaSolicitacoes" id="label-quemAnalisaSolicitacoes">
															Quem Analisa Solicitações:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Determina qual perfil de acesso poderá realizar análise de solicitações de emergência com relatório médico anexado no ato do registro da solicitação." data-trigger="hover" data-original-title="Perfil que Análisa a Solicitação"></i>
														</label>
														<select id="quemAnalisaSolicitacoes" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="nãoexigido">NÃO EXIGIDO</option>
															<option value="analista">PERFIL ANALISTA COMUM</option>
															<option value="regulador">QUALQUER USUÁRIO REGULADOR</option>
															<option value="médico">APENAS MÉDICO</option>
															<option value="medico_enfermeiro">MÉDICO OU ENFERMEIRO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="bloqueioPorFalta" id="label-bloqueioPorFalta">
															Bloqueio por Falta <b>(em dias)</b>:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Determina quanto tempo um CPF ou CNS ficará bloqueado para novo agendamento do mesmo procedimento em caso de falta ao atendimento. Informe zero para não bloquear." data-trigger="hover" data-original-title="Bloqueio por Ausência"></i>
														</label>
														<input type="number" id="bloqueioPorFalta" class="form-control text-center">
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="limitacaoCotas" id="label-limitacaoCotas">
															Controle de Cotas:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Esta configuração diz ao sistema como ele deve utilizar a gestão de cotas para controlar a inclusão da solicitação na fila, no ato do agendamento ou deixar livre como uma fila geral do município para as unidades solicitantes." data-trigger="hover" data-original-title="Gerenciar as Cotas"></i>
														</label>
														<select id="limitacaoCotas" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="nenhum">NENHUM</option>
															<option value="na-fila">NA INCLUSÃO DA FILA</option>
															<option value="no-agendamento">NO ATO DO AGENDAMENTO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="bloquearPacienteFora" id="label-bloquearPacienteFora">
															Bloquear Paciente de Fora:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Esta funcionalidade deve ser utilizada para informar ao G-SAÚDE Regulação se ele deve permitir ou bloquear includão na fila / agendamento de pacientes que o cartão SUS esteja endereçado em outro município." data-trigger="hover" data-original-title="Paciente de Fora do Município"></i>
														</label>
														<select id="bloquearPacienteFora" class="form-control">
															<option value="">SELECIONE...</option>
															<option value="S">SIM</option>
															<option value="N">NÃO</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="idadePrioritariaFila" id="label-idadePrioritariaFila">
															Idade Prioritária Inicial:
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Utilize este parâmetro para estabelecer a idade inicial que o sistema deve considerar como prioridade (ex. A partir de 60 anos -> digite 60). Idade mínima é de 60 anos, ou  Informe 0 (ZERO) para ignorar." data-trigger="hover" data-original-title="Posição Prioritária na fila."></i>
														</label>
														<input type="number" id="idadePrioritariaFila" class="form-control text-center" value="<?php echo $idadePrioritariaFila; ?>">
													</div>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<div class="form-group">
														<label for="numeroTelefoneBot" id="label-numeroTelefoneBot">
															Telefone do Bot
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Este é o número que será utilizado para gerar o QRCode do número de telefone do Bot de atendimento automático que aparecerá no protocolo de encaminhamento." data-trigger="hover" data-original-title="Nº de telefone do Bot."></i>
														</label>
														<input type="text" id="numeroTelefoneBot" class="form-control text-center fonecelular-inputmask" value="<?php echo $numeroTelefoneBot; ?>">
													</div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="form-group">
													<div class="form-group">
														<label for="numeroTelefoneLigacao" id="lbl-numeroTelefoneLigacao">
															Números de telefones que a Regulação Municipal utiliza para ligar ( <b>separa por ';' </b>)
															<i class="icofont icofont-info-square nova_fonte blue" style='font-size:14pt' data-toggle="popover" data-content="Os números registrados no campo abaixo aparecerão no protocolo da solicitação entregu ao cidadão alertanto para que atenda a ligação." data-trigger="hover" data-original-title="Números de ligação."></i>
														</label>
														<input type="text" id="numeroTelefoneLigacao" class="form-control text-center" value="<?php echo $numeroTelefoneLigacao; ?>">
													</div>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-15px'>
											<div class="col-md-12">
												<div class="form-group">
													<div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
														<div class="media align-items-stretch">
															<div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
																<i class="icofont icofont-info-circle white font-medium-5"></i>
															</div>
															<div class="media-body p-1" style='padding:7px !important; padding-left:10px !important; font-family:Arial, Helvetica, sans-serif'>
																<strong>
																	ATENÇÃO! Configurar a idade mínima para ordem da fila fará com que o sistema ordene a posição na fila de acordo com a seguinte ordem:<br>
																	1º) - Classificação de Prioridade<br>
																	2º) - Critério de idade (idosos a partir de 60 em ordem decrescente)<br>
																	3º) - Data/hora/minuto de registro da solicitação na fila.
																</strong>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<div class="barra-flutuante">
	<button type="button" class="btn btn-blue" onClick="salvarConfiguracao()" id="salvarConfiguracao"><i class="fa fa-check-square-o"></i> Salvar Configurações</button>
</div>

<?php
include_once("footer.php");
include_once("include/box_pesquisa_municipio.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liConfiguracoes").attr('class', 'active');
	$("#liConfiguracoes").css("border-bottom", "2px solid #c4c8ca");

	$('#dados_vinculo').DataTable({
		"paging": false,
		"filter": false,
		"lengthChange": false,
		"info": false
	});

	function pesquisaMunicipio() {

		if ($("#conteudoPesquisa").val() == "") {
			swal("Informação Obrigatória", "Você deve informar cidade que deseja pesquisar.", 'error');
			return false;
		}
		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/filtrar_municipio',
			type: 'post',
			dataType: 'html',
			data: {
				'conteudoPesquisa': $("#conteudoPesquisa").val()
			}
		}).done(function(resultadoRetorno) {
			$("#resultadoRetornoIBGE").html(resultadoRetorno);
			$("#embacado").css("display", "none");
		});
	}

	$("#bloquearSabDomFeriado").change(function() {
		if (this.value == "S") {
			$("#bloquearPactuadoHoraInicio").prop("disabled", false);
			$("#bloquearPactuadoHoraFim").prop("disabled", false);
		} else {
			$("#bloquearPactuadoHoraInicio").val("");
			$("#bloquearPactuadoHoraFim").val("");
			$("#bloquearPactuadoHoraInicio").prop("disabled", true);
			$("#bloquearPactuadoHoraFim").prop("disabled", true);
		}
	});

	function salvarConfiguracao() {

		var formCadastroProcesso = $('#form-configuracao-geral');

		$.each(formCadastroProcesso[0].elements, function(index, elementoForm) {
			var idElementoForm = elementoForm.id;
			var tipoElemento = elementoForm.type;

			if (idElementoForm != "") {
				if (tipoElemento != "button" && $("#" + idElementoForm).val() == "") {
					$("#label-" + idElementoForm).addClass("destaque-sem-dados");
				} else {
					$("#label-" + idElementoForm).removeClass("destaque-sem-dados");
				}
			}
		});

		if ($("#bloquearSabDomFeriado").val() != "S") {
			$("#label-bloquearPactuadoHoraInicio").removeClass("destaque-sem-dados");
			$("#label-bloquearPactuadoHoraFim").removeClass("destaque-sem-dados");
		}
		var classValidacao = document.getElementsByClassName("destaque-sem-dados").length;
		if (classValidacao > 0) {
			swal("Dados Obrigatórios", "Existem dados obrigatórios não preenchidos. Verifique os itens marcados em vermelho!", "error");
			return false;
		}

		if ($("#analiseSolicitacoes").val() != "nenhuma" && $("#quemAnalisaSolicitacoes").val() == "nãoexigido") {
			swal("Analisador Inválido", "Se algum tipo de solicitação será enviada para análise, você deve informar quem analisará.", "error");
			return false;
		}

		var idadePrioritariaFila = parseInt($("#idadePrioritariaFila").val());
		if (idadePrioritariaFila < 60 && idadePrioritariaFila != 0) {
			swal("Idade Mínica Inválida", "A idade informada para classificação de prioridade é inválida. A idade não pode ser inferior a 60 anos. Informe 0 (ZERO) para o sistema ignorar prioridade por idade.", "error");
			return false;
		}

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'action/gravar_configuracoes',
			type: 'post',
			dataType: 'html',
			data: {
				'ibgeMunicipio': $('#ibgeMunicipio').val(),
				'estabelecimentoCentral': $('#estabelecimentoCentral').val(),
				'municipioExecutorSede': $('#municipioExecutorSede').val(),
				'diasAberturaPrimeiraVez': $('#diasAberturaPrimeiraVez').val(),
				'diasAberturaRetorno': $('#diasAberturaRetorno').val(),
				'diasAberturaReserva': $('#diasAberturaReserva').val(),
				'bloquearSabDomFeriado': $('#bloquearSabDomFeriado').val(),
				'bloquearPactuadoHoraInicio': $('#bloquearPactuadoHoraInicio').val(),
				'bloquearPactuadoHoraFim': $('#bloquearPactuadoHoraFim').val(),
				'solicitacaoExigeDocumentoAnexo': $('#solicitacaoExigeDocumentoAnexo').val(),
				'exigirRequisicao': $('#exigirRequisicao').val(),
				'usgMaraExigeMamografia': $('#usgMaraExigeMamografia').val(),
				'mamografiaExigeFormulario': $('#mamografiaExigeFormulario').val(),
				'exigirRelatorioMedico': $('#exigirRelatorioMedico').val(),
				'analiseSolicitacoes': $('#analiseSolicitacoes').val(),
				'quemAnalisaSolicitacoes': $('#quemAnalisaSolicitacoes').val(),
				'bloqueioPorFalta': $('#bloqueioPorFalta').val(),
				'limitacaoCotas': $('#limitacaoCotas').val(),
				'bloquearPacienteFora': $('#bloquearPacienteFora').val(),
				'idadePrioritariaFila': $('#idadePrioritariaFila').val(),
				'numeroTelefoneBot': $('#numeroTelefoneBot').val(),
				'numeroTelefoneLigacao' : $('#numeroTelefoneLigacao').val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			swal("Configurarções do Sistema", "As configurações dos parâmetros do sistema foram salvas com sucesso.", "success");
		});

	}

	$("#analiseSolicitacoes").change(function() {
		if (this.value == "emergência" || this.value == "emergência-murgente" || this.value == "todas") {
			$('#exigirRelatorioMedico').val("S");
		} else {
			$('#exigirRelatorioMedico').val("");
		}
	});

	function abrirPesquisaMunicipio() {
		$('#box_pesquisa_municipio').modal();
		setTimeout(function() {
			$("#conteudoPesquisa").focus();
		}, 500);
	}


	/* atribuir valores ao campos select option */
	$("#estabelecimentoCentral").val("<?php echo $estabelecimentoCentral; ?>");
	$("#municipioExecutorSede").val("<?php echo $municipioExecutorSede; ?>");
	$("#bloquearSabDomFeriado").val("<?php echo $bloquearSabDomFeriado; ?>");
	if ($("#bloquearSabDomFeriado").val() == "S") {
		$("#bloquearPactuadoHoraInicio").prop("disabled", false);
		$("#bloquearPactuadoHoraFim").prop("disabled", false);
	}
	$('#bloquearPactuadoHoraFim').val("<?php echo $bloquearPactuadoHoraFim; ?>");
	$('#solicitacaoExigeDocumentoAnexo').val("<?php echo $solicitacaoExigeDocumentoAnexo; ?>");
	$('#exigirRequisicao').val("<?php echo $exigirRequisicao; ?>");
	$('#usgMaraExigeMamografia').val("<?php echo $usgMaraExigeMamografia; ?>");
	$('#mamografiaExigeFormulario').val("<?php echo $mamografiaExigeFormulario; ?>");
	$('#exigirRelatorioMedico').val("<?php echo $exigirRelatorioMedico; ?>");
	$('#analiseSolicitacoes').val("<?php echo $analiseSolicitacoes; ?>");
	$('#quemAnalisaSolicitacoes').val("<?php echo $quemAnalisaSolicitacoes; ?>");
	$('#bloqueioPorFalta').val("<?php echo $bloqueioPorFalta; ?>");
	$('#limitacaoCotas').val("<?php echo $limitacaoCotas; ?>");
	$('#bloquearPacienteFora').val("<?php echo $bloquearPacienteFora; ?>")
</script>