<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$idAgendamento  = $_GET['idagendam'];

$sqlPaciente  = "SELECT tb_paciente.*, 
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, 
tb_cidades.nome_cidade ,
date_format(reg_tb_agendamentos.datahora_agendamento,'%d/%m/%Y') AS dataAgendamento,
date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
reg_tb_agendamentos.horario_atendimento AS horaAtendimento
FROM tb_paciente 
INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade)
INNER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
WHERE reg_tb_agendamentos.id_agendamento='$idAgendamento'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade         = $rsPaciente->codigocidade;
$dataAgendamento    = $rsPaciente->dataAgendamento;
$dataAtendimento    = $rsPaciente->dataAtendimento;
$horaAtendimento    = $rsPaciente->horaAtendimento;

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-prescription" style='margin-top:-15px !important'></i>&nbsp;Editar Procedimentos Agendados
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                      <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                    </h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cpfPaciente">CPF:</label>
                          <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cnsPaciente">Cartão SUS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="dataAgendamento">Data do Agendamento:</label>
                          <input type="text" id="dataAgendamento" class="form-control text-center" value="<?php echo $dataAgendamento; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="dataAtendimento">Data do Atedimento:</label>
                          <input type="text" id="dataAtendimento" class="form-control text-center" value="<?php echo $dataAtendimento; ?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body" style="margin-top: -15px;">
                    <h4 class="form-section"><i class="icofont icofont-paper"></i><b>Procedimentos agendados para o paciente</b></h4>
                    <div class="row" style="margin-top:-15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='dados_agendamentos'>
                            <thead>
                              <tr>
                                <th style='width:50%; padding-left:15px'>PROCEDIMENTO AGENDADO</th>
                                <th style='width:50%; padding-left:15px'>PROCEDIMENTO REALIZADO (SE PRECISAR ALTERAR)</th>
                              </tr>
                            </thead>
                            <tbody style='background-color: #ececec;'>
                              <?php
                              $sqlProcedimentos = "SELECT reg_tb_agendamentos_laboratorio.id_agendamento_laboratorio,
                              reg_tb_agendamentos_laboratorio.id_procedimento_agendado AS idProcedimentoAgendado,
                              reg_tb_agendamentos_laboratorio.id_procedimento_executado AS idProcedimentoExecutado,
                              reg_tb_procedimento.codigo_sus,
                              ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento
                              FROM reg_tb_agendamentos_laboratorio
                              INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos_laboratorio.id_procedimento_agendado = reg_tb_procedimento.id_procedimento)
                              AND (reg_tb_agendamentos_laboratorio.id_agendamento='$idAgendamento')
                              ORDER BY reg_tb_procedimento.nome_procedimento ASC";
                              $stmProcedimentos = $rsConexao->prepare($sqlProcedimentos);
                              $stmProcedimentos->execute();
                              if ($stmProcedimentos->rowCount() > 0) {
                                $rsProcedimentos  = $stmProcedimentos->fetchAll(PDO::FETCH_ASSOC);
                                $setSelected = "";
                                foreach ($rsProcedimentos as $fieldProcedimentos) {
                                  $idAgendamentoLab = $fieldProcedimentos['id_agendamento_laboratorio'];
                                  $idProcedimentoAgendado = $fieldProcedimentos['idProcedimentoAgendado'];
                                  $idProcedimentoExecutado = $fieldProcedimentos['idProcedimentoExecutado'];
                                  $nomeProcedimentoAgendado = $fieldProcedimentos['codigo_sus']." - " . $fieldProcedimentos['nomeProcedimento'];
                                  $linkAtualizarProced = 'onChange="atualizarProcedimento(' . "'$idAgendamentoLab',this.value)" . '"';

                                  # -- alterar cor da linha se o procedimento executado for diferente
                                  if($idProcedimentoAgendado!=$idProcedimentoExecutado && $idProcedimentoExecutado!=""){
                                    $setCorLinha = "style='background-color: #f0efaeff !important;'";
                                  }else{
                                    $setCorLinha = "";
                                  }
                                  # -- PREENCHIMENTO DO SELECT -- #
                                    $optionProcedimentosLaboratorio="<option value=''>SELECIONE...</option>";
                                    $sqlProcedimento = "SELECT reg_tb_procedimento.id_procedimento,
                                    reg_tb_procedimento.nome_procedimento
                                    FROM reg_tb_tetounidade
                                    INNER JOIN reg_tb_procedimento ON (reg_tb_tetounidade.id_grupo_procedimento = reg_tb_procedimento.id_grupo_procedimento)
                                    WHERE reg_tb_tetounidade.codigoestabelecimento_cnes='" . $_SESSION['unidadeLogada'] . "' ORDER BY nome_procedimento";
                                    $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
                                    $stmProcedimento ->execute();
                                    if($stmProcedimento->rowcount()>0){
                                      $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                      foreach($rsProcedimento AS $fiedProcedimento){
                                        $idProcedimento   = $fiedProcedimento['id_procedimento'];
                                        if($idProcedimento==$idProcedimentoExecutado){
                                          $setSelected = " selected";                                          
                                        }else{
                                          $setSelected = "";                                        
                                        }
                                        $nomeProcedimento = $fiedProcedimento['nome_procedimento'];
                                        $optionProcedimentosLaboratorio.="<option value='$idProcedimento' $setSelected>$nomeProcedimento</option>";  
                                      }
                                    }else{
                                      $optionProcedimentosLaboratorio="<option value=''>SEM PROCEDIMENTOS...</option>";
                                    }
                                  # ------------------------------#
                                  $comboProcedimento = "<select id='setProcedimento$idAgendamentoLab' class='form-control-personalizado' style='cursor:pointer' $linkAtualizarProced>
                                    $optionProcedimentosLaboratorio
                                  </select>";
                                  echo "<tr $setCorLinha id='linha$idAgendamentoLab'>
                                      <td style='padding-left:10px'>
                                        $nomeProcedimentoAgendado
                                      </td>
                                      <td style='padding:1px'>$comboProcedimento</td>
                                    </tr>";
                                }
                              }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-danger" id="btnFechar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $('#dados_agendamentos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false,
    "ordering": false
  });

  /* atualizar status do agendamento*/
  function atualizarProcedimento(idAgendaentoLaboratorio, idProcedimento) {

    $.ajax({
      url: 'action/gravar_agendamento_laboratorio',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAgendamento': 'alterar-procedimento-agendado',
        'idAgendaentoLaboratorio': idAgendaentoLaboratorio,
        'idProcedimento': idProcedimento
      }
    }).done(function(resultadoRetorno) {
      if(idProcedimento!=""){
        $("#linha" + idAgendaentoLaboratorio).css("background-color","#f0efaeff!important; color: #000")
      }else{
        $("#linha" + idAgendaentoLaboratorio).css("background-color","#fff !important;")
      }
    });

  }
</script>