<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
					<div class="card-header titulo-telas">
							<i class="icofont icofont-search" style='margin-top:-15px !important'></i>&nbsp;Pesquisar Agendamento do Paciente
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section"><i class="ft-user"></i> <b>Informações para pesquisa</b></h4>
										<div class="row">
											<div class="col-md-6 col-sm-12">
												<fieldset class="text-left">
													<label for="radio-cns">Por CNS</label>
													<input type="radio" name="jui-radio-buttons" id="radio-cns" class="jui-radio-buttons" checked onChange="selecionaBuscaPaciente(this.id)">
													<label for="radio-cpf">Por CPF</label>
													<input type="radio" name="jui-radio-buttons" id="radio-cpf" class="jui-radio-buttons" onChange="selecionaBuscaPaciente(this.id)">
													<input type="hidden" id="opcaoPesquisa" class="form-control" value="radio-cns">
												</fieldset>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="pesquisaCNS">Nº Cartão SUS:</label>
													<input type="text" id="pesquisaCNS" class="form-control cns-inputmask" autofocus>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="pesquisaCPF">Nº CPF:</label>
													<input type="text" id="pesquisaCPF" class="form-control cpf-inputmask" disabled>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="statusAgendamento">Status do Agendamento</label>
													<select id="statusAgendamento" class="form-control">
														<option value=''>SELECIONE...</option>
														<option value='todos'>TODOS</option>
														<option value='Agendado'>AGENDADO</option>
														<option value='Confirmado'>CONFIRMADO</option>
														<option value='JaRealizou'>JÁ REALIZOU</option>
														<option value='Cancelar'>CANCELAR</option>
													</select>
												</div>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<table style="width:100%">
													<tr>
														<td style="width:130px">
															<label></label><br>
															<button type="button" class="btn btn-info" onClick="buscarMarcacaoPaciente(opcaoPesquisa.value)">
																<i class="fa fa-search"></i> Pesquisar
															</button>
														</td>
														<td>
															<label for="nomePacientePesquisado">Nome do Paciente Pesquisado:</label>
															<input type="text" id="nomePacientePesquisado" class="form-control" style='background-color:#bdf2ff'>
														</td>
														<td style="width:5px"></td>
														<td style="width:200px">
															<label for="nascimentoPacientePesquisado">Data de Nascimento:</label>
															<input type="text" id="nascimentoPacientePesquisado" class="form-control text-center" style='background-color:#bdf2ff'>
														</td>
													</tr>
												</table>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_marcacaopaciente'>
									<thead>

										<th style="text-align:center; width:100px">OPÇÕES</th>
										<th style="text-align:center; width:150px">Nº SOLICITAÇÃO</th>
										<th>NOME DO PROCEDIMENTO</th>
										<th style="text-align:center; width:150px">PRAZO RETIRADA</th>
										<th style="width:150px">STATUS</th>
										<th style="width:150px">ORIGEM</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");

?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liEntregaExames").attr('class', 'active');
	$("#liEntregaExames").css("border-bottom", "2px solid #c4c8ca");

	//Função para realizar busca do cadastro do cidadão.
	function buscarMarcacaoPaciente(selOpcao) {

		var cnsPaciente = $('#pesquisaCNS').val();
		var cpfPaciente = $('#pesquisaCPF').val();
		var statusAgendamento = $('#statusAgendamento').val();
		switch (selOpcao) {
			case "radio-cns":
				if (cnsPaciente == "") {
					swal("Cartão SUS", "Informe o número do cartão SUS para pesquisa!", "info");
					return false;
				}
				break;

			case "radio-cpf":
				if (cpfPaciente == "") {
					swal("Número de CPF", "Informe o número do CPF para pesquisa!", "info");
					return false;
				}
				break;
		}

		if (statusAgendamento == "") {
			swal("Status do Agendamento", "Informe o status do agendamento ou selecione todos.", "info");
			return false;
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'filtros/filtrar_pacienteagendamento',
			type: 'post',
			dataType: 'html',
			data: {
				'selOpcao': selOpcao,
				'opcaoBuscaAgenfamento': 'encontrar-paciente',
				'cnsPaciente': cnsPaciente,
				'cpfPaciente': cpfPaciente,
			}
		}).done(function(resultadoRetorno) {

			if (resultadoRetorno == "NaoExistePaciente") {
				$("#embacado").css("display", "none");
				swal("Paciente não Encontrado", "Nenhum paciente encontrado com o documento informado.", "info");
				return false;
			}
			retornoResultado = resultadoRetorno.split("##");
			$("#nomePacientePesquisado").val(retornoResultado[1]);
			$("#nascimentoPacientePesquisado").val(retornoResultado[2]);

			var idPaciente = retornoResultado[0];

			$.ajax({
				url: 'filtros/filtrar_pacienteagendamento',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoBuscaAgenfamento': 'encontrar-agendamentos',
					'idPaciente': idPaciente,
					'statusAgendamento': statusAgendamento
				}
			}).done(function(resultadoRetornoAgendamento) {

				if (resultadoRetornoAgendamento == "NaoExisteAgendamento") {
					$("#embacado").css("display", "none");
					$('#dados_marcacaopaciente').DataTable().destroy();
					$('#dados_marcacaopaciente tbody').empty().append();
					$('#dados_marcacaopaciente').DataTable();
					swal("Sem Agendamentos", "Nenhum agendamento encontrado para o paciente.", "info");
					return false;
				}
				$('#dados_marcacaopaciente').DataTable().destroy();
				$('#dados_marcacaopaciente tbody').empty().append(resultadoRetornoAgendamento);
				$('#dados_marcacaopaciente').DataTable();
				$("#embacado").css("display", "none");
			});

		});

	}
</script>