<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-file-psd" style='margin-top:-15px !important'></i>&nbsp;Exportação de BPA
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section"><i class="icofont icofont-edit"></i> <b>Informações para pesquisa</b>
											<input type='hidden' id="idTetoMensal" disabled>
										</h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-6">
												<div class="form-group">
													<label for="unidadeSaude">Unidade de Saúde:</label>
													<select type="text" id="unidadeSaude" class="form-control">
														<option value=''>TODAS...</option>
														<?php
														$stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label>Mes de Competência:</label>
													<select class="form-control" id="mesCompetencia" onchange="filtrarProcedimentos()">
														<option value=''>SELECIONE...</option>
														<?php
															for($contarMes = 1; $contarMes<=12;$contarMes++){
																$numeroMes	= str_pad($contarMes,2,"0",STR_PAD_LEFT);
																$nomeMes		= $gerarNomeMes[$numeroMes];
																echo "<option value='$numeroMes'>$nomeMes</option>";
															}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label>Ano de Competência:</label>
													<input type='number' class="form-control text-center" id="anoCompetencia" value="<?php echo date('Y');?>">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-info" onClick="exportarProducao()">
														<i class="icofont icofont-checked"></i> Confirmar Exportação
													</button>
													<button type="button" class="btn btn-success" onClick="baixarArquivoProducao()" disabled>
														<i class="icofont icofont-download-alt"></i> Baixar arquivo gerado
													</button>													
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering" id='dados_tetomensal'>
									<thead>
										<th>NOME DO ARQUIVO</th>
										<th style='text-align:center' width='20%'>COMPETÊNCIA (MÊS/ANO)</th>
										<th style='text-align:center' width='20%'>QUANT REGISTROS</th>
										<th style='text-align:center' width='15%'>CONTROLE</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liExportarBPA").attr('class', 'active');
	$("#liExportarBPA").css("border-bottom", "2px solid #c4c8ca");

	function filtrarProcedimentos() {

		if ($("#grupoProcedimento").val() != "") {

			var bloqueioProcedimento = $("#grupoProcedimento").val() != 1 ? true : false;
			$.ajax({
				url: 'filtros/filtrar_procedimento',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoPesquisa': 'cadastrar-teto',
					'ECadastroTeto': "S",
					'grupoProcedimento': $("#grupoProcedimento").val()
				}
			}).done(function(resultadoRetorno) {
				$("#procedimentoSelecionado").val("");
				$("#nomeProcedimento").html("");
				$("#nomeProcedimento").html(resultadoRetorno);
				$("#nomeProcedimento").prop("disabled", bloqueioProcedimento);
			});

		} else {
			$("#nomeProcedimento").html("<option value=''>SELECIONE O GRUPO...</option>");
			$("#nomeProcedimento").prop("disabled", true);
		}

	}

	$("#tipoApuracaoTeto").change(function() {
		switch (this.value) {
			case "":
				$('#valorTeto').prop('disabled', true);
				$('#valorTeto').val('');
				$('#valorTeto').css('display', 'none');
				$('#quantidadeTeto').prop('disabled', true);
				$('#quantidadeTeto').css('display', 'block');
				$('#quantidadeTeto').val('');
				break;
			case "fisico":
				$('#valorTeto').prop('disabled', true);
				$('#valorTeto').val('');
				$('#valorTeto').css('display', 'none');
				$('#quantidadeTeto').prop('disabled', false);
				$('#quantidadeTeto').css('display', 'block');
				$('#quantidadeTeto').focus();
				break;
			case "financeiro":
				$('#quantidadeTeto').prop('disabled', true);
				$('#quantidadeTeto').val('');
				$('#quantidadeTeto').css('display', 'none');
				$('#valorTeto').prop('disabled', false);
				$('#valorTeto').css('display', 'block');
				$('#valorTeto').focus();
				break;
		}
	});

	$("#unidadeSaude").change(function() {

		if (this.value != "") {
			$('#embacado').css('display', 'block');
			$.ajax({
				url: 'filtros/filtrar_tetomensal',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro': 'teto-procedimento-unidade',
					'unidadeSaude': this.value
				}
			}).done(function(resultadoRetorno) {
				$('#embacado').css('display', 'none');
				$('#dados_tetomensal').DataTable().destroy();
				if (resultadoRetorno != "semRegistro") {
					$('#dados_tetomensal tbody').empty().append(resultadoRetorno);
				} else {
					$('#dados_tetomensal tbody').empty().append('');
				}
				$('#dados_tetomensal').DataTable();
			});
		} else {
			$('#dados_tetomensal').DataTable().destroy();
			$('#dados_tetomensal tbody').empty().append('');
			$('#dados_tetomensal').DataTable();
		}

	});


	function cadastrarTetoMensal() {

		if ($("#nomeProcedimento").val()) {
			var procedimentoSelecionado = $("#nomeProcedimento").val().split("##");
			var idProcedimento = procedimentoSelecionado[1];
		} else {
			var idProcedimento = null;
		}

		if ($("#unidadeSaude").val() == "") {
			swal("Dados Obriratórios", "Selecione a unidade executante!", "error");
			return false;
		}
		if ($("#grupoProcedimento").val() == "") {
			swal("Dados Obriratórios", "Selecione o grupo de procedimentos!", "error");
			return false;
		}
		if ($("#grupoProcedimento").val() == "1" && $("#nomeProcedimento").val() == "") {
			swal("Dados Obriratórios", "Para o grupo selecionado você deve informar o procedimento.", "error");
			return false;
		}

		if ($("#tipoApuracaoTeto").val()=="") {
			swal("Dados Obriratórios", "Selecione o tipo de apuração para o cadastro do teto a ser registrado.", "error");
			return false;
		}else if ($("#tipoApuracaoTeto").val()=="fisico" && $("#quantidadeTeto").val()=="") {
			swal("Dados Obriratórios", "Informe a quantidade para o grupo/procedimento selecinoado.", "error");
			return false;
		}else if ($("#tipoApuracaoTeto").val()=="financeiro" && $("#valorTeto").val()=="") {
			swal("Dados Obriratórios", "Informe o valor para o grupo/procedimento selecinoado.", "error");
			return false;
		}
				

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'action/gravar_tetomensal',
			type: 'post',
			dataType: 'html',
			data: {
				'idTetoMensal': $("#idTetoMensal").val(),
				'unidadeSaude': $("#unidadeSaude").val(),
				'grupoProcedimento': $("#grupoProcedimento").val(),
				'idProcedimento': idProcedimento,
				'tipoApuracaoTeto': $("#tipoApuracaoTeto").val(),
				'quantidadeTeto': $("#quantidadeTeto").val(),
				'valorTeto': $("#valorTeto").val()
			}
		}).done(function(resultadoRetorno) {
			
			$("#embacado").css("display", "none");
			
			if(resultadoRetorno=="JaExiste"){
				swal("Procedimento Duplicado", "O teto para teste grupo/procedimento já foi registrado na unidade selecionada.", "error");
				return false;
			}

			$('#dados_tetomensal').DataTable().destroy();
			$('#dados_tetomensal tbody').empty().append(resultadoRetorno);
			$('#dados_tetomensal').DataTable();

			$('#grupoProcedimento').val('');
			$('#grupoProcedimento').trigger('change');
			$('#nomeProcedimento').val('');
			$('#valorUnitario').val('N/A');
			$('#tipoApuracaoTeto').val('');
			$('#quantidadeTeto').val('');
			$('#valorTeto').val('');
			$('#quantidadeTeto').prop('disabled', 'true');
			$('#valorTeto').prop('disabled', 'true');
		});
	}

	function editarTeto(dadosEdicao) {
		var splitDados = dadosEdicao.split("--");
		$("#idTetoMensal").val(splitDados[0]);
		$("#grupoProcedimento").val(splitDados[1]);
		$("#grupoProcedimento").trigger("change");
		if (splitDados[1] == '1') {
			setTimeout(function() {
				$("#nomeProcedimento").val(splitDados[2]);
				$("#nomeProcedimento").trigger("change");
			}, 1000);
		}
		$("#tipoApuracaoTeto").val(splitDados[3]);
		if (splitDados[3] == "fisico") {
			$('#valorTeto').prop('disabled', true);
			$('#valorTeto').val('');
			$('#valorTeto').css('display', 'none');
			$('#quantidadeTeto').prop('disabled', false);
			$('#quantidadeTeto').css('display', 'block');
			$('#quantidadeTeto').val(splitDados[4]);
		} else {
			$('#quantidadeTeto').prop('disabled', true);
			$('#quantidadeTeto').val('');
			$('#quantidadeTeto').css('display', 'none');
			$('#valorTeto').prop('disabled', false);
			$('#valorTeto').css('display', 'block');
			$('#valorTeto').val(splitDados[4]);
		}
		$("#btnCancelar").prop('disabled', false);
	}

	function excluirTeto(idTeto) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do registro selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'teto-procedimento-unidadde',
						'idRegistroExclusao': idTeto,
						'unidadeSaude': $("#unidadeSaude").val()
					}
				}).done(function(resultadoRetorno) {

					$('#dados_tetomensal').DataTable().destroy();
					$('#dados_tetomensal tbody').empty().append(resultadoRetorno);
					$('#dados_tetomensal').DataTable();
					swal("Exclusão de Registro", "Registro do teto de procedimento excluído com sucesso.", "success");
					$("#embacado").css("display", "none");

				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}

	$("#btnCancelar").click(function() {
		$('#grupoProcedimento').val('');
		$('#grupoProcedimento').trigger('change');
		$('#nomeProcedimento').val('');
		$('#valorUnitario').val('N/A');
		$('#tipoApuracaoTeto').val('');
		$('#quantidadeTeto').val('');
		$('#valorTeto').val('');
		$('#quantidadeTeto').prop('disabled', 'true');
		$('#valorTeto').prop('disabled', 'true');
		$("#btnCancelar").prop('disabled', true);
	});

	$("#nomeProcedimento").change(function() {
		var valorUnitario = this.value.split("##");
		$("#valorUnitario").val(valorUnitario[0] ?? '');
	});

	$('#valorTeto').mask('#.##0,00', {
		reverse: true
	});
</script>