<?php
session_start();
require("../../database/dbConection.php");

$dataHoje     = date("Y-m-d");
$htmlRetorno  = "";
$opcaoListagem = $_POST['opcaoListagem'];
$idPerfilLogado = $_SESSION['idPerfilLogado'];
$unidadeLogada      = $_SESSION['unidadeLogada'];

$formatarOrigem = array(
  'lista_unica' => 'LISTA ÚNICA',
  'policlinica' => 'POLICLÍNICA',
  'sisreg' => 'SISREG',
  'sistema_vida' => 'VIDA+',
);

$formatarStatus = array(
  'A' => 'AGENDADO',
  'C' => 'CANCELADO',
  'V' => 'CONFIRMADO',
  'P' => 'PENDENTE',
  'E' => 'AGENDADO/ENTREGUE',
  'X' => 'CANCELAR'
);


switch ($opcaoListagem) {

  case "comunicacao-pacientes-whatsapp":
    $sqlAgendamento  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.data_retirada, reg_tb_agendamentos.data_retirada, date_format(data_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente) INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE status_agendamento='Agendado' AND em_comunicacao='N' AND encaminhado_ligacao='N' GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.data_retirada, tb_paciente.cns_paciente ORDER BY data_retirada, nome_paciente";
    $stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->execute();
    $rsAgendamento      = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
    $totalAgendamentos  = $stmAgendamento->rowCount();

    if ($totalAgendamentos > 0) {
      foreach ($rsAgendamento as $fieldAgendamento) {
        $idPaciente        = $fieldAgendamento['id_paciente'];
        $dataRetirada      = $fieldAgendamento['dataRetirada'];
        $nomePaciente      = $fieldAgendamento['nome_paciente'];
        $cnsPaciente      = $fieldAgendamento['cns_paciente'];
        $dataretiradaEnc  = $fieldAgendamento['data_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registracomunicacao?idp=$idPaciente&opc=wp')" . '"';
        echo "<tr>
          <td style='text-align:center'>
          <i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
            <i class='icofont icofont-social-whatsapp nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
          </td>
          <td style='text-align:center'>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
        </tr>";
      }
    }
    break;

  case "comunicacao-pacientes-ligacoes":
    $sqlAgendamento  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.data_retirada, reg_tb_agendamentos.data_retirada, date_format(data_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente) INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE status_agendamento='Agendado' AND encaminhado_ligacao='S' AND data_retirada>='$dataHoje' GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.data_retirada, tb_paciente.cns_paciente ORDER BY data_retirada, nome_paciente";
    $stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->execute();
    $rsAgendamento      = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
    $totalAgendamentos  = $stmAgendamento->rowCount();

    if ($totalAgendamentos > 0) {
      foreach ($rsAgendamento as $fieldAgendamento) {
        $idPaciente        = $fieldAgendamento['id_paciente'];
        $dataRetirada      = $fieldAgendamento['dataRetirada'];
        $nomePaciente      = $fieldAgendamento['nome_paciente'];
        $cnsPaciente      = $fieldAgendamento['cns_paciente'];
        $dataretiradaEnc  = $fieldAgendamento['data_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registraligacao?idp=$idPaciente&opc=tel')" . '"';
        //$linkRegistrarComunicaco      = '"abrirRegistroComunicacao(' . "'$idPaciente')" . '"';        
        echo "<tr>
          <td style='text-align:center'>
          <i class='icofont icofont-ui-contact-list nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
          <i class='icofont icofont-curved-double-right nova_fonte_blue' title='Encaminhar para tela de comunicação pelo whatsapp.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
          </td>
          <td style='text-align:center'>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
        </tr>";
      }
    }
    break;

  case "comunicacao-pacientes-cancelar":
    $sqlAgendamento  = "SELECT reg_tb_agendamentos.id_agendamento, reg_tb_agendamentos.numero_solicitacao, reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.data_retirada, reg_tb_agendamentos.data_retirada, date_format(data_retirada,'%d/%m/%Y') AS dataRetirada, 
    tb_paciente.nome_paciente, tb_paciente.cns_paciente, reg_tb_agendamentos.status_agendamento, reg_tb_procedimento.nome_procedimento, reg_tb_agendamentos.origem_agendamento, reg_tb_agendamentos.observacoes_comunicacao  FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente) 
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE status_agendamento='Cancelar' OR 
    (data_retirada<'$dataHoje' AND status_agendamento!='Entregue' AND status_agendamento!='Cancelado' AND status_agendamento!='Devolvido') GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.data_retirada, tb_paciente.cns_paciente 
    ORDER BY data_retirada, nome_paciente";
    $stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->execute();
    $rsAgendamento      = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
    $totalAgendamentos  = $stmAgendamento->rowCount();

    if ($totalAgendamentos > 0) {
      foreach ($rsAgendamento as $fieldAgendamento) {
        $idAgendamento      = $fieldAgendamento['id_agendamento'];
        $idPaciente          = $fieldAgendamento['id_paciente'];
        $numeroSolicitacao  = $fieldAgendamento['numero_solicitacao'];
        $dataRetirada        = $fieldAgendamento['dataRetirada'];
        $nomePaciente        = $fieldAgendamento['nome_paciente'];
        $cnsPaciente        = $fieldAgendamento['cns_paciente'];
        $nomeProcedimento   = $fieldAgendamento['nome_procedimento'];
        $dataretiradaEnc    = $fieldAgendamento['data_retirada'];
        $origemAgendamento  = $formatarOrigem[$fieldAgendamento['origem_agendamento']];
        $obsAgendamento      = mb_strtoupper($fieldAgendamento['observacoes_comunicacao']);
        $statusAgengamentoX = mb_strtoupper($fieldAgendamento['status_agendamento']);

        $linkConfirmarCancelamento  = 'onclick="confirmarCancelamento(' . "'$idAgendamento')" . '"';
        $linkInformacao             = 'onclick="window.open(' . "'informacoesagendamento?ida=$idAgendamento')" . '"';

        if ($dataHoje > $dataretiradaEnc && $obsAgendamento == "") {
          $obsAgendamento  = "PRAZO VENCIDO PARA RETIRADA, OU SEM OBSERVAÇÃO";
        } else {
          $obsAgendamento = $obsAgendamento;
        }

        $devolverParaEntrega  = '"devolverParaEntrega(' . "'$idAgendamento')" . '"';

        echo "<tr style='font-size:9pt !important'>
          <td style='text-align:center'>
            <i class='icofont icofont-checked nova_fonte' title='Confirmar cancelamento de marcação.' $linkConfirmarCancelamento></i>
            <i class='icofont icofont-info-square nova_fonte_blue' title='Visualizar informações sobre este agendamento.' $linkInformacao></i>
            <i class='icofont icofont-curved-double-right nova_fonte_blue' style='color:#860000' title='Devolver para setor de entregas.' onclick=$devolverParaEntrega></i>
          </td>
          <td style='text-align:center'>$numeroSolicitacao</td>
          <td style='text-align:center'>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
          <td>$nomeProcedimento</td>
          <td>$origemAgendamento</td>
          <td>$statusAgengamentoX</td>
          <td>$obsAgendamento</td>
        </tr>";
      }
    }
    break;

  case "comunicacao-pacientes-confirmados":
    if ($_SESSION['idPerfilLogado'] == '1') {
      $whereSQL = " WHERE status_agendamento='Confirmado' ";
    } else {
      $whereSQL = " WHERE status_agendamento='Confirmado' AND idusuario_comunicacao='" . $_SESSION['idUsuarioLogado'] . "' ";
    }
    $sqlAgendamento  = "SELECT reg_tb_agendamentos.id_agendamento, 
    reg_tb_agendamentos.numero_solicitacao, 
    reg_tb_agendamentos.id_paciente, 
    reg_tb_agendamentos.data_retirada, 
    reg_tb_agendamentos.data_retirada, 
    date_format(data_retirada,'%d/%m/%Y') AS dataRetirada, 
    tb_paciente.nome_paciente, 
    tb_paciente.cns_paciente, 
    reg_tb_agendamentos.status_agendamento, 
    reg_tb_procedimento.nome_procedimento, 
    reg_tb_agendamentos.origem_agendamento, 
    reg_tb_agendamentos.observacoes_comunicacao, 
    tb_usuario.nome_usuario AS operadorConfirmou 
    FROM reg_tb_agendamentos 
    INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente) 
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) 
    INNER JOIN tb_usuario ON (reg_tb_agendamentos.idusuario_comunicacao=tb_usuario.id_usuario)
    $whereSQL 
    GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.data_retirada, tb_paciente.cns_paciente 
    ORDER BY data_retirada, nome_paciente";
    $stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->execute();
    $rsAgendamento      = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
    $totalAgendamentos  = $stmAgendamento->rowCount();


    if ($totalAgendamentos > 0) {
      $contadorOrdemData = 0;
      foreach ($rsAgendamento as $fieldAgendamento) {
        $contadorOrdemData  = $contadorOrdemData + 1;
        $idAgendamento      = $fieldAgendamento['id_agendamento'];
        $idPaciente         = $fieldAgendamento['id_paciente'];
        $numeroSolicitacao  = $fieldAgendamento['numero_solicitacao'];
        $dataRetirada       = $fieldAgendamento['dataRetirada'];
        $nomePaciente       = $fieldAgendamento['nome_paciente'];
        $cnsPaciente        = $fieldAgendamento['cns_paciente'];
        $nomeProcedimento   = $fieldAgendamento['nome_procedimento'];
        $dataretiradaEnc    = $fieldAgendamento['data_retirada'];
        $origemAgendamento  = $formatarOrigem[$fieldAgendamento['origem_agendamento']];
        $obsAgendamento     = mb_strtoupper($fieldAgendamento['observacoes_comunicacao']);
        $statusAgengamentoX = mb_strtoupper($fieldAgendamento['status_agendamento']);
        $operadorConfirmou  = mb_strtoupper($fieldAgendamento['operadorConfirmou']);

        if ($dataHoje > $dataretiradaEnc && $obsAgendamento == "") {
          $obsAgendamento  = "PRAZO VENCIDO PARA RETIRADA, OU SEM OBSERVAÇÃO";
        } else {
          $obsAgendamento = $obsAgendamento;
        }

        $encaminharParaLigacao  = '"encaminharParaLigacao(' . "'$idAgendamento')" . '"';

        echo "<tr style='font-size:9pt !important'>
          <td style='text-align:center'>
            <i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$encaminharParaLigacao></i>&nbsp;
          </td>
          <td style='text-align:center'>$numeroSolicitacao</td>
          <td style='text-align:center'><font style='font-size:0.1px'>$contadorOrdemData</font>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
          <td>$nomeProcedimento</td>
          <td>$origemAgendamento</td>
          <td>$obsAgendamento</td>
          <td>$operadorConfirmou</td>
        </tr>";
      }
    }
    break;

  case "buscar-agendamentos-filaG-admin":
  case "buscar-agendamentos-filaG-executante":
    $unidadeSaude         = $_POST["unidadeSaude"];
    $profissinoalSaude    = $_POST["profissinoalSaude"];
    $grupoProcedimento    = $_POST["grupoProcedimento"];
    $nomeProcedimento     = $_POST["nomeProcedimento"];
    $statusAgendamento    = $_POST["statusAgendamento"];
    $recebeCNSCPF         = str_replace("-","",$_POST["numeroCNSCPF"]);
    $numeroCNSCPF         = str_replace(".","",$recebeCNSCPF);
    $numeroCNSCPF         = str_replace(" ","",$numeroCNSCPF);
    $numeroProtocolo      = $_POST["numeroProtocolo"];
    $opcaoPeriodo         = $_POST["opcaoPeriodo"];
    $dataInicialPesquisa  = $_POST["dataInicialPesquisa"];
    $dataFinalPesquisa    = $_POST["dataFinalPesquisa"];

    $whereSQL = " WHERE (id_agendamento>0) ";
    $whereSQL = $unidadeSaude         == "" ? $whereSQL : $whereSQL . " AND (tb_estabelecimento.codigoestabelecimento_cnes='$unidadeSaude')";
    $whereSQL = $profissinoalSaude    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agenda.codigoprofissional_cnes='$profissinoalSaude')";
    $whereSQL = $grupoProcedimento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_grupo_procedimento='$grupoProcedimento')";
    $whereSQL = $nomeProcedimento     == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_procedimento='$nomeProcedimento')";
    if ($idPerfilLogado == 13) {
      if ($statusAgendamento == "A" || $statusAgendamento == "E") {
        $whereSQL = $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='A' OR reg_tb_agendamentos.status_agendamento='E')";
      } else {
        $whereSQL = $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='$statusAgendamento')";
      }
    } else {
      $whereSQL = $statusAgendamento == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='$statusAgendamento')";
    }

    $whereSQL = $numeroCNSCPF         == "" ? $whereSQL : $whereSQL . " AND (tb_paciente.cns_paciente='$numeroCNSCPF' OR tb_paciente.cpf_paciente='$numeroCNSCPF')";
    $whereSQL = $numeroProtocolo      == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.protocolo_agendamento='$numeroProtocolo')";
    $whereSQL = $opcaoPeriodo         != "" && $dataInicialPesquisa != "" ? $whereSQL . " AND (reg_tb_agendamentos.$opcaoPeriodo BETWEEN '$dataInicialPesquisa' AND '$dataFinalPesquisa')" : $whereSQL;

    $sqlAgendamentos  = "SELECT reg_tb_agendamentos.id_agendamento,
    reg_tb_agendamentos.origem_agendamento,
    reg_tb_agendamentos.protocolo_agendamento,
    reg_tb_agendamentos.tipo_vagaocupada,
    reg_tb_agendamentos.id_paciente,
    reg_tb_agendamentos.id_solicitacao,
    tb_paciente.nome_paciente,
    tb_paciente.cns_paciente,
    date_format(tb_paciente.datanasc, '%d/%m/%Y') AS dataNascimento,
    tb_paciente.celular1,
    tb_paciente.celular2,
    tb_paciente.celular3,
    ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
    tb_estabelecimento.nfantasia_estabelecimento,
    date_format(reg_tb_agendamentos.datahora_agendamento, '%d/%m/%Y') AS dataAgendamento,
    date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
    date_format(reg_tb_agendamentos.data_atendimento, '%Y-%m-%d') AS dataAtendimentoConfirmar,
    date_format(reg_tb_agendamentos.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada,
    reg_tb_agendamentos.data_atendimento,
    reg_tb_usuario.nome_usuario,
    reg_tb_agendamentos.status_agendamento,
    reg_tb_agendamentos.horario_atendimento,
    reg_tb_agendamentos.chave_confirmacao
    FROM reg_tb_agendamentos
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento)
    INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
    INNER JOIN reg_tb_usuario ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_agendou)
    LEFT OUTER JOIN reg_tb_agenda ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
    LEFT OUTER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
    LEFT OUTER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
    LEFT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_agendamentos.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
    $whereSQL
    GROUP BY reg_tb_agendamentos.protocolo_agendamento
    ORDER BY tb_paciente.nome_paciente";

    $stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
    $stmAgendamentos->execute();
    if ($stmAgendamentos->rowCount() > 0) {
      $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAgendamentos as $fieldAgendamento) {
        $corFontChave       = "";
        $idPaciente         = $fieldAgendamento['id_paciente'];
        $idAgendamento      = $fieldAgendamento['id_agendamento'];
        $idSolicitacao      = $fieldAgendamento['id_solicitacao'];
        $nomePaciente       = mb_strtoupper($fieldAgendamento['nome_paciente']);
        $cnsPaciente        = $fieldAgendamento['cns_paciente'];
        $dataNascimento     = $fieldAgendamento['dataNascimento'];
        $numerosTelefone    = $fieldAgendamento['celular1'] != "" ? $fieldAgendamento['celular1'] : "";
        $numerosTelefone    = $fieldAgendamento['celular2'] != "" ? $numerosTelefone . "<br>" . $fieldAgendamento['celular2'] : $numerosTelefone;
        $numerosTelefone    = $fieldAgendamento['celular3'] != "" ? $numerosTelefone . "<br>" . $fieldAgendamento['celular3'] : $numerosTelefone;      
        $nomeProcedimento   = $fieldAgendamento['nomeProcedimento']=="" ? "PROCEDIMENTOS DE LABORATÓRIO" : $fieldAgendamento['nomeProcedimento'];
        $nomeUnidade        = mb_strtoupper($fieldAgendamento['nfantasia_estabelecimento']);
        $dataAgendamento    = $fieldAgendamento['dataAgendamento'];
        $dataAtendimento    = $fieldAgendamento['dataAtendimento'];
        $dataRetirada       = $fieldAgendamento['dataRetirada'];
        $quemAgendou        = mb_strtoupper($fieldAgendamento['nome_usuario']);
        $horarioAtendimento = $fieldAgendamento['horario_atendimento'];
        $exibirProtocolo    = $fieldAgendamento['protocolo_agendamento'];
        $statusAgendamento  = $formatarStatus[$fieldAgendamento['status_agendamento']];
        $chaveConfirmacao   = $fieldAgendamento['status_agendamento'] != "V" ? "" : $fieldAgendamento['chave_confirmacao'];
        $chaveValidacao     = $fieldAgendamento['chave_confirmacao'];
        $desativaChave      = (($fieldAgendamento['status_agendamento'] != "A" && $fieldAgendamento['status_agendamento'] != "E" && $fieldAgendamento['status_agendamento'] != 
        "P") || $fieldAgendamento['dataAtendimentoConfirmar'] > date('Y-m-d'))   ? " disabled" : "";
        $paginaImpressao    = $fieldAgendamento['origem_agendamento']=="LAB-D" ? "&tpag=lab" : "";
        $tipoVagaOcupada      = mb_strtoupper($fieldAgendamento['tipo_vagaocupada']);
        $validarDataCMD       = $fieldAgendamento['data_atendimento'];
        $verStatusAgendamento = $fieldAgendamento['status_agendamento'];
        if ($fieldAgendamento['status_agendamento'] == "P") {
          $corFontChave = "style:color:#720000; font-weight: bold;";
        } else if ($fieldAgendamento['status_agendamento'] == "V") {
          $corFontChave = "style:color:#02751f; font-weight: bold;";
        }

        if ($opcaoListagem == "buscar-agendamentos-filaG-admin") {

          # -- acessar solicitação -- #
          $comandoAcessarSolicitacao  = 'onClick="window.open(' . "'solicitacao_cadastro?idpac=$idPaciente&idsol=$idSolicitacao&op=sc')" . '"';
          $botaoAcessarSolicitacao    = "<i class='icofont icofont-search nova_fonte_blue' title='Visualizar soliciação.' $comandoAcessarSolicitacao></i>&nbsp;";
          # -- acessar agendamento --#
          $comandoAcessarAgendamento  = 'onClick="window.open(' . "'direcionar?opdir=agendamento&idagendamento=$idAgendamento$paginaImpressao')" . '"';
          $botaoAcessarAgendamento    = "<i class='icofont icofont-document-search nova_fonte' title='Visualizar soliciação.' $comandoAcessarAgendamento></i>";

          if ($tipoVagaOcupada == 'PVEZ' || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
            $origemAgendamento  = "VAGA DO SISTEMA: <b><font style='color:#00509F'>AGENDA - ($tipoVagaOcupada)</font></b>";

            # -- comando para impressão da marcação do sistema -- #
            if ($validarDataCMD >= date("Y-m-d")) {

              if ($fieldAgendamento['status_agendamento'] == "E") {
                $botaoComandoEntrega      = "";
              } else {
                $comandoEntrega       = 'onClick="window.open(' . "'agendamento_entregar?idpac=$idPaciente&idagendam=$idAgendamento&op=sc')" . '"';
                $botaoComandoEntrega  = "<i class='icofont icofont-paper nova_fonte' title='Registrar entrega de marcação.' $comandoEntrega></i>&nbsp;";
              }
            } else {
              $botaoComandoEntrega      = "";
            }
            # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #
            $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG$paginaImpressao')" . '"';
            $botaoImprimirAgendamento = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
            if ($statusAgendamento == "AGENDADO" || $statusAgendamento == "AGENDADO/ENTREGUE" || $statusAgendamento == "CANCELAR" || $statusAgendamento == "PENDENTE") {
              $comandoCancelar = 'onClick="window.open(' . "'agendamento_cancelar?idpac=$idPaciente&idag=$idAgendamento')" . '"';
              $botaoCancelar   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar agendamento.' $comandoCancelar></i>&nbsp;";
            } else {
              $botaoCancelar  = "";
            }
          } else {
            $origemAgendamento        = "VAGA EXTERNA: <b><font style='color:#00509F'>$tipoVagaOcupada</font></b>";
            $botaoComandoEntrega      = "";
            # -- comando para impressão da marcação externa -- #
            $numeracaoArquivo   = str_pad($idAgendamento, 8, "0") . "AA";
            $stmArquivoExterno  = $rsConexao->prepare("SELECT * FROM reg_tb_solicitacoes_agendado WHERE id_agendamento_direto='$idAgendamento'");
            $stmArquivoExterno->execute();
            $rsArquivoExterno   = $stmArquivoExterno->fetch(PDO::FETCH_OBJ);
            $diretorioArquivo   = "docagendamentos/" . $rsArquivoExterno->pasta_documento . "/" . $numeracaoArquivo . "_" . $rsArquivoExterno->nomearquivo_documento;
            $comandoImprimirAgendamento  = 'onClick="window.open(' . "'$diretorioArquivo')" . '"';
            $botaoImprimirAgendamento = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
            # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #                
          }

          $htmlRetorno      .= "<tr>
            <td align='center'>
              $botaoImprimirAgendamento
              $botaoComandoEntrega
              $botaoCancelar
            </td>
            <td>$nomePaciente</td>
            <td align='center'>$cnsPaciente</td>
            <td>$nomeProcedimento</td>
            <td align='center'>$dataAgendamento</td>
            <td align='center'>$dataAtendimento</td>
            <td align='center'>$dataRetirada</td>
            <td align='center'>$exibirProtocolo</td>
            <td align='center'>$chaveValidacao</td>
            <td align='center'>$statusAgendamento</td>
            <td>$quemAgendou</td>
          </tr>";
        }

        if ($opcaoListagem == "buscar-agendamentos-filaG-executante") {

          
          if($fieldAgendamento['nomeProcedimento']==""){
            $linkEditar = 'onClick="window.open(' . "'editar_procedimentoagendado?idagendam=$idAgendamento')" . '"';
            $comandoEditar   = "<i class='icofont icofont-edit nova_fonte' sttle='font-size:8pt !important' title='Editar procedimento agendado.' $linkEditar></i>";
            $comandoEditarProc  = "<br>
              <div style='width:auto; padding:2px; color:#027fbe; cursor:pointer; font-size:9pt' $linkEditar>
                <i class='icofont icofont-edit nova_fonte_blue' style='font-size:9pt !important' title='Editar procedimento agendado.'></i><b>&nbsp;Editar Procedimento</b>
              </div>";
            $editarProcedimento = "$comandoEditarProc";
          }else{
            $editarProcedimento = "";
          }

          $inputChave  = "<input type='text' name='chaveValidarPresenta[]' id='idCampoChave$idAgendamento' value='$chaveConfirmacao' class='form-control text-center' maxlength='8' $desativaChave $corFontChave>";
          $htmlRetorno      .= "<tr>
            <td align='center' style='padding:5px'>$inputChave</td>
            <td align='center'>$exibirProtocolo</td>          
            <td>$nomePaciente</td>
            <td align='center'>$cnsPaciente</td>
            <td align='center'>$dataNascimento</td>
            <td align='center'>$numerosTelefone</td>
            <td>
              $nomeProcedimento$editarProcedimento
            </td>
            <td align='center'>$dataAtendimento</td>
            <td>$statusAgendamento</td>            
            <td align='center'>$horarioAtendimento</td>
          </tr>";
        }
      }
    } else {
      $htmlRetorno = "NaoExiste";
    }
    echo $htmlRetorno;
    break;

  case "listar-agendamentos-paciente-tela-agendamento";
    $idPaciente       = $_POST['idPaciente'];
    $htmlRetorno      = "";
    $sqlAgendamentos  = "SELECT reg_tb_procedimento.nome_procedimento,
    tb_estabelecimento.nfantasia_estabelecimento,
    tb_profissional.nome_profissional,
    reg_tb_agendamentos.id_agendamento,
    date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendmento,
    reg_tb_agendamentos.data_atendimento,
    reg_tb_agendamentos.status_agendamento,
    reg_tb_agendamentos.horario_atendimento,
    reg_tb_agendamentos.tipo_vagaocupada
    FROM reg_tb_agenda
    INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes=tb_profissional.codigoprofissional_cnes)
    INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
    RIGHT OUTER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento)
    WHERE (reg_tb_agendamentos.id_paciente='$idPaciente')
    ORDER BY reg_tb_agendamentos.data_atendimento ASC,
    reg_tb_agendamentos.horario_atendimento ASC";

    $stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
    $stmAgendamentos->execute();
    if ($stmAgendamentos->rowCount() > 0) {
      $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAgendamentos as $fieldAgendamentos) {
        $idAgendamento          = $fieldAgendamentos['id_agendamento'];
        $nomeProcedimento       = mb_strtoupper($fieldAgendamentos['nome_procedimento']);
        $statusAgendamento      = $formatarStatus[$fieldAgendamentos['status_agendamento']];
        $nomeProfissional       = mb_strtoupper($fieldAgendamentos['nome_profissional']);
        $nomeUnidade            = mb_strtoupper($fieldAgendamentos['nfantasia_estabelecimento']);
        $dataAtendimento        = mb_strtoupper($fieldAgendamentos['dataAtendmento']);
        $validarDataCMD         = $fieldAgendamentos['data_atendimento'];
        $horaAtendimento        = mb_strtoupper($fieldAgendamentos['horario_atendimento']);
        $tipoVagaOcupada        = mb_strtoupper($fieldAgendamentos['tipo_vagaocupada']);
        $styleRegistroCancelado = $fieldAgendamentos['status_agendamento'] != "C" ? "" : "style='background-color: #ffadad;color: #860000;'";

        if ($tipoVagaOcupada == 'PVEZ' || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
          if ($tipoVagaOcupada == 'PVEZ') {
            $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - (PRIMEIRA VEZ)</font></b>";
          } else {
            $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - ($tipoVagaOcupada)</font></b>";
          }
          # -- comando para impressão da marcação do sistema -- #
          if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
            $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG$paginaImpressao')" . '"';
            $botaoImprimirAgendamento   = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
          } else {
            $botaoImprimirAgendamento   = "";
          }
          # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #                  
          $htmlRetorno .= "<tr>
          <td style='padding:5px'>$botaoImprimirAgendamento&nbsp;&nbsp;&nbsp;$nomeProcedimento</td>
          <td $styleRegistroCancelado>$statusAgendamento</td>
          <td>$nomeProfissional</td>
          <td>$nomeUnidade</td>
          <td align='center'>$dataAtendimento</td>
          <td align='center'>$horaAtendimento</td>
          <td align='center'>$origemAgendamento</td>
          </tr>";
        } else {
          $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
          if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
            # -- comando para impressão da marcação externa -- #
            $numeracaoArquivo   = str_pad($idAgendamento, 8, "0") . "AA";
            $stmArquivoExterno  = $rsConexao->prepare("SELECT * FROM reg_tb_solicitacoes_agendado WHERE id_agendamento_direto='$idAgendamento'");
            $stmArquivoExterno->execute();
            $rsArquivoExterno   = $stmArquivoExterno->fetch(PDO::FETCH_OBJ);
            $diretorioArquivo   = "docagendamentos/" . $rsArquivoExterno->pasta_documento . "/" . $numeracaoArquivo . "_" . $rsArquivoExterno->nomearquivo_documento;
            $comandoImprimirAgendamento  = 'onClick="window.open(' . "'$diretorioArquivo')" . '"';
            $botaoImprimirAgendamento    = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
            # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #
          } else {
            $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
            $botaoImprimirAgendamento = "";
          }
          $htmlRetorno .= "<tr>
          <td style='padding:5px'>$botaoImprimirAgendamento&nbsp;&nbsp;&nbsp;$nomeProcedimento</td>
          <td $styleRegistroCancelado>$statusAgendamento</td>
          <td>NÃO INFORMADO</td>
          <td>NÃO INFORMADO</td>
          <td align='center'>NÃO INFORMADO</td>
          <td align='center'>NÃO INFORMADO</td>
          <td align='center'>$origemAgendamento</td>
          </tr>";
        }
      }
    }
    echo $htmlRetorno;
    break;

  case "agendamentos-executante-painel":
    $unidadeLogada      = $_SESSION['unidadeLogada'];
    $sqlAgendamentos = "SELECT tb_paciente.id_paciente,
    ucase(tb_paciente.nome_paciente) AS nomePaciente,
    TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
    tb_paciente.celular1,
    tb_paciente.celular2,
    tb_paciente.celular3,
    tb_paciente.cns_paciente,
    tb_paciente.sexo,
    tb_paciente.condicaosaude_pcd,
    tb_paciente.condicaosaude_pcddescricao,
    ucase(tb_profissional.nome_profissional) AS nomeProfissional,
    tb_profissional.codigoprofissional_cnes,
    reg_tb_agendamentos.horario_atendimento,
    reg_tb_agendamentos_atender.status_atendimento_painel,
    reg_tb_agendamentos_atender.tipo_atendimento_painel,
    reg_tb_agendamentos_atender.observacao_recepcao_painel,
    reg_tb_agenda.id_agenda
    FROM reg_tb_agenda
    INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
    INNER JOIN reg_tb_agendamentos ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
    INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
    LEFT OUTER JOIN reg_tb_agendamentos_atender ON (reg_tb_agendamentos.id_paciente = reg_tb_agendamentos_atender.id_paciente)
    WHERE (reg_tb_agenda.codigoestabelecimento_cnes = '$unidadeLogada')
    AND (reg_tb_agendamentos.status_agendamento = 'E' OR reg_tb_agendamentos.status_agendamento = 'V' OR reg_tb_agendamentos.status_agendamento = 'A')
    AND (reg_tb_agendamentos.data_atendimento = '$dataHoje')
    GROUP BY tb_paciente.nome_paciente
    ORDER BY reg_tb_agendamentos.horario_atendimento ASC, tb_paciente.nome_paciente ASC";

    $stmAtendimentos = $rsConexao->prepare($sqlAgendamentos);
    $stmAtendimentos->execute();

    if ($stmAtendimentos->rowCount() > 0) {
      $rsAtendimentos = $stmAtendimentos->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAtendimentos as $fieldAtendimentos) {
        $idPaciente         = $fieldAtendimentos['id_paciente'];
        $idAgenda           = $fieldAtendimentos['id_agenda'];
        $nomePaciente       = $fieldAtendimentos['nomePaciente'];
        $cnsPaciente        = $fieldAtendimentos['cns_paciente'];
        $idadePaciente      = $fieldAtendimentos['idadePaciente'];
        $sexoPaciente       = $fieldAtendimentos['sexo'] == "M" ? "MASCULINO" : "FEMININO";
        $telefonePaciente   = $fieldAtendimentos['celular1'] != "" ? $fieldAtendimentos['celular1'] : "";
        $telefonePaciente   = $fieldAtendimentos['celular2'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentos['celular2'] : $telefonePaciente;
        $telefonePaciente   = $fieldAtendimentos['celular3'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentos['celular3'] : $telefonePaciente;
        $horaAtendimento    = $fieldAtendimentos['horario_atendimento'];
        $chaveHorarioAtend  = str_replace(":", "", $fieldAtendimentos['horario_atendimento']);
        $nomeProfissional   = $fieldAtendimentos['nomeProfissional'];
        $codigoProfissional = $fieldAtendimentos['codigoprofissional_cnes'];
        $descricaoPCD       = $fieldAtendimentos['condicaosaude_pcddescricao'];
        $pacientePCD        = $fieldAtendimentos['condicaosaude_pcd'] == "S" ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
        $statusAtendimentoPainel = $fieldAtendimentos['status_atendimento_painel'];

        $tipoAtendimentopainel  = $fieldAtendimentos['tipo_atendimento_painel'];
        $observacaorecepcao     = $fieldAtendimentos['observacao_recepcao_painel'];

        # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
        switch ($statusAtendimentoPainel) {
          case "":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
            Status: Não Confirmado
          </div>";
            break;
          case "Aguardando":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
          case "Em Atendimento":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
          case "Atendido":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
        }

        $cmdConfirmarPresenca = 'onClick="confirmarPresenca(' . "'abrir-popup','$idPaciente##$idAgenda##$nomePaciente')" . '"';
        $btnConfirmarPresenca = "<i id='btnConfirma$idPaciente' class='icofont icofont-checked nova_fonte_blue' style='font-size:18pt !important' title='Confirmar presença.' $cmdConfirmarPresenca></i>";

        if ($fieldAtendimentos['status_atendimento_painel'] != "Em Atendimento" && $fieldAtendimentos['status_atendimento_painel'] != "Finalizado") {
          $cmdCancelarConfirmacao = 'onclick="cancelarConfirmacaoPresenca(' . "'$idPaciente')" . '"';
          $btnCancelarConfirmacao = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' style='font-size:17pt !important' title='Cancelar confirmação de presença.' $cmdCancelarConfirmacao></i>";
        } else {
          $btnCancelarConfirmacao = "";
        }

        # -- CARREGAR PROCEDIMENTOS AGENDADOS --#
        $sqlProcedimento = "SELECT reg_tb_procedimento.nome_procedimento,
      reg_tb_agendamentos.id_paciente,
      reg_tb_agendamentos.id_agendamento
      FROM reg_tb_procedimento
      INNER JOIN reg_tb_agendamentos ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
      INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
      INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
      INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
      WHERE (reg_tb_agenda.codigoestabelecimento_cnes='$unidadeLogada')
      AND (reg_tb_agendamentos.status_agendamento='E' OR reg_tb_agendamentos.status_agendamento='V')
      AND (reg_tb_agendamentos.data_atendimento='$dataHoje')
      AND (reg_tb_agendamentos.horario_atendimento='$horaAtendimento')        
      AND (reg_tb_agendamentos.id_paciente='$idPaciente')
      GROUP BY (reg_tb_procedimento.nome_procedimento)
      ORDER BY (reg_tb_procedimento.nome_procedimento)";
        $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
        $stmProcedimento->execute();
        if ($stmProcedimento->rowCount()) {
          $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
          $nomeProcedimento    = "";
          foreach ($rsProcedimento as $fieldProcedimento) {
            if ($nomeProcedimento == "") {
              $nomeProcedimento  = "&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            } else {
              $nomeProcedimento  = "$nomeProcedimento<br>&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            }
          }
        }

        echo "<tr style='background-color:#fff'>
        <td align='center' style='width:100px'>
          $btnConfirmarPresenca
          $btnCancelarConfirmacao
        </td>
        <td align='center' style='font-size:10pt;width:40px'>$horaAtendimento</td>
        <td style='font-size:9pt; padding:8px;'>
          <b>
            <table width='100%' style='background-color:transparent !important;'>
              <tr>
                <td style='background-color:transparent; border:0px; padding:0px; font-size:11pt'>
                  Paciente: $nomePaciente $pacientePCD
                </td>
                <td style='background-color:transparent; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                  <table align='right'>
                    <tr>
                      <td style='padding:2px; border:0px' id='tdStatus$idPaciente-$idAgenda'>
                        $htmlAtendimentoPainel
                      </td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>              
          <hr style='margin-top:1px; border-top: 1px dashed #860000'>
          <div style='width:auto; padding:2px; color:#027fbe;margin-top:-10px'>
            Profissional: $nomeProfissional
          </div>
          <div style='width:auto; padding:2px; color:#0d5e03'>
              $nomeProcedimento
          </div>
        </b>
      </td>
        <td align='center' style='font-size:9pt; width:100px'>$cnsPaciente</td>
        <td align='center' style='font-size:9pt; width:50px'>$idadePaciente</td>
        <td align='center' style='font-size:9pt; width:80px'>$sexoPaciente</td>
        <td align='center' style='font-size:8pt; width:100px'>$telefonePaciente</td>
    </tr>";
      }
    }
    # -- exibir pacientes de atendimento extra -- #
    $sqlAtendimentoExtra = "SELECT tb_paciente.id_paciente,
    ucase(tb_paciente.nome_paciente) AS nomePaciente,
    tb_paciente.cns_paciente,
    timestampdiff(year,tb_paciente.datanasc,curdate()) AS idadePaciente,
    tb_paciente.sexo,
    tb_paciente.celular1,
    tb_paciente.celular2,
    tb_paciente.celular3,
    tb_paciente.condicaosaude_pcd,
    tb_paciente.condicaosaude_pcddescricao,
    ucase(tb_profissional.nome_profissional) AS nomeProfissional,
    tb_profissional.codigoprofissional_cnes,
    reg_tb_agendamentos_atender.id_agenda,
    reg_tb_agendamentos_atender.status_atendimento_painel,
    reg_tb_agendamentos_atender.tipo_atendimento_painel,
    reg_tb_agendamentos_atender.observacao_recepcao_painel,
    reg_tb_agendamentos_atender.horario_atendimento
    FROM tb_paciente
    INNER JOIN reg_tb_agendamentos_atender ON (tb_paciente.id_paciente = reg_tb_agendamentos_atender.id_paciente)
    INNER JOIN tb_profissional ON (tb_profissional.codigoprofissional_cnes = reg_tb_agendamentos_atender.codigoprofissional_cnes)
    WHERE (reg_tb_agendamentos_atender.codigoestabelecimento_cnes = '$unidadeLogada')
    AND (reg_tb_agendamentos_atender.data_atendimento = '$dataHoje')
    AND (reg_tb_agendamentos_atender.origem_atendimento = 'extra')
    GROUP BY tb_paciente.nome_paciente
    ORDER BY reg_tb_agendamentos_atender.horario_atendimento ASC, tb_paciente.nome_paciente ASC";
    $stmAtendimentoExtra = $rsConexao->prepare($sqlAtendimentoExtra);
    $stmAtendimentoExtra->execute();

    if ($stmAtendimentoExtra->rowCount() > 0) {
      $rsAtendimentoExtra = $stmAtendimentoExtra->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAtendimentoExtra as $fieldAtendimentoExtra) {
        $idPaciente         = $fieldAtendimentoExtra['id_paciente'];
        $idAgenda           = $fieldAtendimentoExtra['id_agenda'];
        $nomePaciente       = $fieldAtendimentoExtra['nomePaciente'];
        $cnsPaciente        = $fieldAtendimentoExtra['cns_paciente'];
        $idadePaciente      = $fieldAtendimentoExtra['idadePaciente'];
        $sexoPaciente       = $fieldAtendimentoExtra['sexo'] == "M" ? "MASCULINO" : "FEMININO";
        $telefonePaciente   = $fieldAtendimentoExtra['celular1'] != "" ? $fieldAtendimentoExtra['celular1'] : "";
        $telefonePaciente   = $fieldAtendimentoExtra['celular2'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentoExtra['celular2'] : $telefonePaciente;
        $telefonePaciente   = $fieldAtendimentoExtra['celular3'] != "" ? $telefonePaciente . "<br>" . $fieldAtendimentoExtra['celular3'] : $telefonePaciente;
        $horaAtendimento    = $fieldAtendimentoExtra['horario_atendimento'];
        $nomeProfissional   = $fieldAtendimentoExtra['nomeProfissional'];
        $codigoProfissional = $fieldAtendimentoExtra['codigoprofissional_cnes'];
        $descricaoPCD       = $fieldAtendimentoExtra['condicaosaude_pcddescricao'];
        $pacientePCD        = $fieldAtendimentoExtra['condicaosaude_pcd'] == "S" ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
        $statusAtendimentoPainel = $fieldAtendimentoExtra['status_atendimento_painel'];

        $tipoAtendimentopainel  = $fieldAtendimentoExtra['tipo_atendimento_painel'];
        $observacaorecepcao     = $fieldAtendimentoExtra['observacao_recepcao_painel'];

        # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
        switch ($statusAtendimentoPainel) {
          case "":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
            Status: Não Confirmado
          </div>";
            break;
          case "Aguardando":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
          case "Em Atendimento":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
          case "Atendido":
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
            Status: $statusAtendimentoPainel
          </div>";
            break;
        }

        $cmdConfirmarPresenca = 'onClick="confirmarPresenca(' . "'abrir-popup','$idPaciente##$idAgenda##$nomePaciente')" . '"';
        $btnConfirmarPresenca = "<i id='btnConfirma$idPaciente' class='icofont icofont-checked nova_fonte_blue' style='font-size:18pt !important' title='Confirmar presença.' $cmdConfirmarPresenca></i>";

        if ($fieldAtendimentoExtra['status_atendimento_painel'] != "Em Atendimento" && $fieldAtendimentoExtra['status_atendimento_painel'] != "Finalizado") {
          $cmdCancelarConfirmacao = 'onclick="cancelarConfirmacaoPresenca(' . "'$idPaciente')" . '"';
          $btnCancelarConfirmacao = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' style='font-size:17pt !important' title='Cancelar confirmação de presença.' $cmdCancelarConfirmacao></i>";
        } else {
          $btnCancelarConfirmacao = "";
        }

        echo "<tr style='background-color:#fde3e3'>
          <td align='center'>
            $btnConfirmarPresenca
            $btnCancelarConfirmacao
          </td>
          <td align='center' style='font-size:10pt'>$horaAtendimento</td>
          <td style='font-size:9pt; padding:8px;'>
            <b>
              <table width='100%' style='background-color:transparent !important;'>
                <tr>
                  <td style='background-color:#fde3e3; border:0px; padding:0px; font-size:11pt'>
                    Paciente: $nomePaciente $pacientePCD - <font color='#860000'><b>EXTRA</b></font>
                  </td>                
                  <td style='background-color:#fde3e3; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                    <table align='right'>
                      <tr>
                        <td style='padding:2px; border:0px;background-color:#fde3e3' id='tdStatus$idPaciente-$idAgenda'>
                          $htmlAtendimentoPainel
                        </td>
                    </tr>
                  </table>                    
                </td>
              </tr>
            </table>              
            <hr style='margin-top:1px; border-top: 1px dashed #860000'>
            <div style='width:auto; padding:2px; color:#027fbe;margin-top:-10px'>
              Profissional: $nomeProfissional
            </div>
          </b>
        </td>
        <td align='center' style='font-size:9pt'>$cnsPaciente</td>
        <td align='center' style='font-size:9pt'>$idadePaciente</td>
        <td align='center' style='font-size:9pt'>$sexoPaciente</td>
        <td align='center' style='font-size:8pt'>$telefonePaciente</td>
      </tr>";
      }
    }
    break;

  case "agendamentos-executante-painel-atualizastatus":
    $cpfValidaProfissional = $_SESSION['cpfValidaProfissional'];
    $sqlAgendamentos = "SELECT reg_tb_agendamentos_atender.id_agendamentos_atender,
    reg_tb_agendamentos_atender.tipo_atendimento_painel,
    reg_tb_agendamentos_atender.horario_atendimento,
    ucase(tb_paciente.nome_paciente) AS nomePaciente,
    TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
    tb_paciente.sexo,
    tb_paciente.condicaosaude_pcd,
    tb_paciente.condicaosaude_pcddescricao,
    tb_paciente.id_paciente,
    reg_tb_agendamentos_atender.status_atendimento_painel,
    reg_tb_agendamentos_atender.status_atendimento_painel_mostrar,
    reg_tb_agendamentos_atender.observacao_recepcao_painel,
    reg_tb_agendamentos_atender.origem_atendimento
    FROM tb_paciente
    INNER JOIN reg_tb_agendamentos_atender ON (tb_paciente.id_paciente = reg_tb_agendamentos_atender.id_paciente)
    WHERE (reg_tb_agendamentos_atender.codigoestabelecimento_cnes='$unidadeLogada')
    AND (reg_tb_agendamentos_atender.codigoprofissional_cnes='00000$cpfValidaProfissional')
    AND (reg_tb_agendamentos_atender.data_atendimento='$dataHoje')
    GROUP BY reg_tb_agendamentos_atender.data_atendimento,tb_paciente.nome_paciente
    ORDER BY reg_tb_agendamentos_atender.horario_atendimento ASC,
    reg_tb_agendamentos_atender.tipo_atendimento_painel DESC,
    nome_paciente ASC";
    //AND (reg_tb_agendamentos_atender.status_atendimento_painel='Aguardando' OR reg_tb_agendamentos_atender.status_atendimento_painel='Chamando')

    $stmAtendimentos = $rsConexao->prepare($sqlAgendamentos);
    $stmAtendimentos->execute();
    if ($stmAtendimentos->rowCount() > 0) {
      $rsAtendimentos = $stmAtendimentos->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsAtendimentos as $fieldAtendimentos) {
        $idPaciente         = $fieldAtendimentos['id_paciente'];
        $idAgendamento      = $fieldAtendimentos['id_agendamentos_atender'];
        $nomePaciente       = $fieldAtendimentos['nomePaciente'];
        $idadePaciente      = $fieldAtendimentos['idadePaciente'];
        $sexoPaciente       = $fieldAtendimentos['sexo'] == 'M' ? 'MASCULINO' : 'FEMININO';
        $horaAtendimento    = $fieldAtendimentos['horario_atendimento'];
        $descricaoPCD       = $fieldAtendimentos['condicaosaude_pcddescricao'];
        $pacientePCD        = $fieldAtendimentos['condicaosaude_pcd'] == 'S' ? $pacientePCD = "- <b><i title='$descricaoPCD' style='color:red; font-size:11pt' class='icofont icofont-paralysis-disability'></i></b>" : "";
        $statusAtendimentoPainel  = $fieldAtendimentos['status_atendimento_painel_mostrar'];
        $tipoAtendimento          = $fieldAtendimentos['tipo_atendimento_painel'] == "N" ? "NORMAL" : "PRIORIDADE";
        $corTipoAtendimento       = $fieldAtendimentos['tipo_atendimento_painel'] == "P" ? "style='background-color: #fde3e3; color: #860000; font-weight: bold'" : "";
        $observacaoAtendimento    = mb_strtoupper($fieldAtendimentos['observacao_recepcao_painel']);
        # -- VERIFICAR STATUS DO ATENDIMENTO NO PAINEL --#
        switch ($statusAtendimentoPainel) {
          case '':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-NaoConfirmado'>
              Status: Ausente
            </div>";
            break;
          case 'Aguardando':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Aguardando'>
                Status: $statusAtendimentoPainel
            </div>";
            break;

          case 'Chamando':
          case 'Chamado':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Chamado'>
                Status: Chamado
            </div>";
            break;

          case 'Em Atendimento':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-EmAtendimento'>
              Status: $statusAtendimentoPainel
            </div>";
            break;
          case 'Atendido':
            $htmlAtendimentoPainel = "<div class='div-statuPainel-Atendido'>
              Status: $statusAtendimentoPainel
            </div>";
            break;
        }
        if ($fieldAtendimentos['status_atendimento_painel'] != "Atendido") {
          $cmdChamarPaciente = 'onClick="chamarPaciente(' . "'abrir-popup','$idPaciente#$horaAtendimento#$nomePaciente')" . '"';
          $btnChamarPaciente = "<i id='btnChamar$idPaciente' class='icofont icofont-megaphone-alt nova_fonte_blue' style='font-size:18pt !important' title='Chamar paciente.' $cmdChamarPaciente></i>";
        }else{
          $btnChamarPaciente = "";
        }

        if ($fieldAtendimentos['status_atendimento_painel'] == "Em Atendimento") {
          $cmdFinalizarAtendimento = 'onclick="confirmacaoAtendimento(' . "'$idPaciente#$horaAtendimento#$nomePaciente')" . '"';
          $btnFinalizarAtendimento = "<i class='icofont icofont-checked nova_fonte' style='font-size:17pt !important' title='Finalizar atendimento do paciente.' $cmdFinalizarAtendimento></i>";
        } else {
          $btnFinalizarAtendimento = "";
        }

        # -- CARREGAR PROCEDIMENTOS AGENDADOS --#
        $sqlProcedimento = "SELECT reg_tb_procedimento.nome_procedimento,
        reg_tb_agendamentos.id_paciente,
        reg_tb_agendamentos.id_agendamento
        FROM reg_tb_procedimento
        INNER JOIN reg_tb_agendamentos ON (reg_tb_procedimento.id_procedimento = reg_tb_agendamentos.id_procedimento)
        INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente)
        INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
        INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
        WHERE (reg_tb_agenda.codigoestabelecimento_cnes='$unidadeLogada')
        AND (reg_tb_agenda.codigoprofissional_cnes='00000$cpfValidaProfissional')
        AND (reg_tb_agendamentos.data_atendimento='$dataHoje')
        AND (reg_tb_agendamentos.horario_atendimento='$horaAtendimento')
        AND (reg_tb_agendamentos.id_paciente='$idPaciente')
        GROUP BY (reg_tb_procedimento.nome_procedimento)
        ORDER BY reg_tb_procedimento.nome_procedimento";
        $stmProcedimento = $rsConexao->prepare($sqlProcedimento);
        $stmProcedimento->execute();
        if ($stmProcedimento->rowCount()) {
          $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
          $nomeProcedimento    = "";
          foreach ($rsProcedimento as $fieldProcedimento) {
            if ($nomeProcedimento == "") {
              $nomeProcedimento  = "&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            } else {
              $nomeProcedimento  = "$nomeProcedimento<br>&bull; " . mb_strtoupper($fieldProcedimento['nome_procedimento']);
            }
          }
        }

        $corLinhaExtra = $fieldAtendimentos['origem_atendimento'] != "extra" ?  "style='background-color:#fff'" : "style='background-color:#fde3e3'";
        echo "<tr $corLinhaExtra>
              <td align='center' style='width:60px'>
                $btnChamarPaciente
                $btnFinalizarAtendimento
              </td>
              <td align='center' style='font-size:8pt; width:40px'>$horaAtendimento</td>
              <td align='center' $corTipoAtendimento style='width:40px'>$tipoAtendimento</td>
              <td style='font-size:9pt; padding:8px'>
                <b>
                  <table width='100%' style='background-color:transparent !important;'>
                    <tr>
                      <td style='background-color:transparent; border:0px; padding:0px; font-size:11pt'>
                        Paciente: $nomePaciente $pacientePCD
                      </td>                
                      <td style='background-color:transparent; border:0px; padding:0px; text-align:right; font-size:9pt;'>
                        <table align='right'>
                          <tr>
                          <td style='padding:2px; border:0px' id='tdStatus$idPaciente'>
                            $htmlAtendimentoPainel
                          </td>
                          </tr>
                        </table>                    
                      </td>
                    </tr>
                  </table>              
                  <hr style='margin-top:1px; border-top: 1px dashed #860000'>
                  <div style='width:auto; padding:2px; color:#027fbe; margin-top:-10px'>
                    $nomeProcedimento
                  </div>
                </b>
              </td>
              <td align='center' style='font-size:9pt; width:30px'>$idadePaciente</td>
              <td align='center' style='font-size:9pt; width:30px'>$sexoPaciente</td>
              <td style='font-size:8pt;; width:200px'>$observacaoAtendimento</td>
            </tr>";
      }
    }
    break;
}
