<?php
session_start();
require("../../database/dbConection.php");

$UsuarioLogado  = $_SESSION['idUsuarioLogado'];
$idPerfilLogado = $_SESSION['idPerfilLogado'];
$dataHoje       = date("Y-m-d");
$htmlRetorno    = "";
$opcaoBusca     = $_POST['opcaoBusca'];
$temRegistro    = false;

# ---------- BOTÕES DE COMANDO ----------- #
$botaoComandoAnalisar = "";
# ---------------------------------------- #
switch ($opcaoBusca) {

  case "listar-solicitacao":

    $getOp= $_POST['getOp'];
    $grupoProcedimento    = $_POST['grupoProcedimento'];
    $nomeProcedimento     = $_POST['nomeProcedimento'];
    $statusSolicitacao    = $_POST['statusSolicitacao'];
    $recebeCNSCPF         = str_replace(".", "", $_POST['numeroCNSCPF']);
    $numeroCNSCPF         = str_replace("-", "", $recebeCNSCPF);
    $numeroCNSCPF         = str_replace(" ", "", $recebeCNSCPF);
    $numeroProtocolo      = $_POST['numeroProtocolo'];
    $dataInicialPesquisa  = $_POST['dataInicialPesquisa'];
    $dataFinalPesquisa    = $_POST['dataFinalPesquisa'];
    $retornoPesquisa      = $_POST['retornoPesquisa'];
    $unidadeSolicitantePesquisa = $_POST['unidadeSolicitantePesquisa'];

    # --- DEFINIR WHERE PARA SELEÇÃO DO PERIODO --- #
    switch ($statusSolicitacao) {
      case 1:
      case 2:
        $campoDataFiltro      = "datahora_cadastro";
        $campoUsuarioRegistro = 'id_usuario_cadastrou';

        break;
      case 3:
        $campoDataFiltro      = "datahora_registroagendamento";
        $campoUsuarioRegistro = 'idusuario_registrouagendamento';
        break;
      case 4:
        $campoDataFiltro      = "datahora_solicitoucancelamento";
        $campoUsuarioRegistro = 'id_usuario_solicitoucancelamento';
        break;
      case 5:
        $campoDataFiltro      = "datahora_cancelamento";
        $campoUsuarioRegistro = 'id_usuario_cancelou';
        break;
      case 6:
      case 7:
        $campoDataFiltro      = "datahora_entrega";
        $campoUsuarioRegistro = 'id_usuario_entregou';
        break;
      case 9:
      case 10:
        $campoDataFiltro      = "datahora_analise";
        $campoUsuarioRegistro = 'id_usuario_analisou';
        break;
    }

    #------- PREPARAR WHERE -------#
    $setWhare = "WHERE (reg_tb_solicitacoes.id_solicitacao>0) ";
    if ($numeroCNSCPF != "") {

      if ($idPerfilLogado == 3 || $idPerfilLogado == 6) { // solicitante ou  assistente social
        $whereStatus = " AND (tb_paciente.cpf_paciente='$numeroCNSCPF' OR tb_paciente.cns_paciente='$numeroCNSCPF')";
      } else {
        $whereStatus = $statusSolicitacao == "" ? " AND (tb_paciente.cpf_paciente='$numeroCNSCPF' OR tb_paciente.cns_paciente='$numeroCNSCPF')" : "  AND (tb_paciente.cpf_paciente='$numeroCNSCPF' OR tb_paciente.cns_paciente='$numeroCNSCPF') AND (reg_tb_solicitacoes.id_statussolicitacao='$statusSolicitacao')";

        $whereStatus = $nomeProcedimento == "" ? $whereStatus = $whereStatus : $whereStatus .  " AND (reg_tb_solicitacoes.id_procedimento='$nomeProcedimento')";
      }
      $setWhare = $setWhare . $whereStatus;
    } else if ($numeroProtocolo != "") {

      if ($idPerfilLogado == 3 || $idPerfilLogado == 6) { // solicitante ou  assistente social
        $whereStatus = " AND (reg_tb_solicitacoes.numero_procotolo='$numeroProtocolo')";
      } else {
        $whereStatus = $statusSolicitacao == "" ? " AND (reg_tb_solicitacoes.numero_procotolo='$numeroProtocolo')" : " AND (reg_tb_solicitacoes.numero_procotolo='$numeroProtocolo') AND (reg_tb_solicitacoes.id_statussolicitacao='$statusSolicitacao')";
      }

      $setWhare = $setWhare . $whereStatus;
    } else {
      $setWhare = $grupoProcedimento    == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_grupo_procedimento='$grupoProcedimento')";
      $setWhare = $nomeProcedimento     == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_procedimento='$nomeProcedimento')";
      if ($statusSolicitacao != 4) {
        $setWhare = $statusSolicitacao    == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_statussolicitacao='$statusSolicitacao')";
      } else {
        $dataValidarEntrega = date("Y-m-d");
        $setWhare = $statusSolicitacao    == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_statussolicitacao='$statusSolicitacao' OR (reg_tb_solicitacoes.id_statussolicitacao='3' && reg_tb_solicitacoes.dataprazo_retirada<'$dataValidarEntrega'))";
      }

      $setWhare = $dataInicialPesquisa  == "" ? $setWhare : $setWhare . " AND (date_format(reg_tb_solicitacoes.$campoDataFiltro,'%Y-%m-%d') BETWEEN '$dataInicialPesquisa' and '$dataFinalPesquisa')";
      $setWhare = $idPerfilLogado       == 5  ? $setWhare . " AND (reg_tb_solicitacoes.tem_relatoriomedico = 'N')" : $setWhare;
      $setWhare .= " AND (em_analise='N')";

      $setWhare = $retornoPesquisa=="" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.solicitacao_retorno='$retornoPesquisa')";
      $setWhare = $unidadeSolicitantePesquisa=="" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_unidade_cadastrou='$unidadeSolicitantePesquisa')";
    }

    if($idPerfilLogado!=1){
      $setWhare .= " AND (tb_paciente.devolvido_atualizar='N')";
    }
    #------------------------------#

    $sqlSolicitacoes = "SELECT reg_tb_solicitacoes.id_solicitacao, 
    reg_tb_solicitacoes.id_paciente,
    reg_tb_solicitacoes.id_grupo_procedimento,
    reg_tb_solicitacoes.id_procedimento,
    reg_tb_solicitacoes.id_classificacaorisco, 
    reg_rl_classificacaorisco.nome_classificacaorisco, 
    reg_rl_classificacaorisco.cor_classificacaorisco, 
    date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y') AS dataCadastro,
    tb_paciente.nome_paciente, tb_paciente.cns_paciente, 
    TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente, 
    reg_tb_procedimento.nome_procedimento, 
    reg_tb_solicitacoes.numero_procotolo, 
    date_format(reg_tb_solicitacoes.datahora_cadastro,'%H:%i') AS horaCadastro, 
    DATEDIFF(CURDATE(),date_format(reg_tb_solicitacoes.datahora_cadastro,'%Y-%m-%d')) AS diasEspera,
    reg_tb_solicitacoes.tem_relatoriomedico, 
    reg_rl_statussolicitacao.nome_statusslicitacao,
    reg_tb_solicitacoes.id_statussolicitacao, 
    reg_tb_solicitacoes.observacaoextra_agendamento,
    date_format(dataprazo_retirada,'%Y-%m-%d') AS prazoRetiradaVencido, 
    reg_tb_solicitacoes.posicao_fila, 
    reg_tb_solicitacoes.origem_agendamento, 
    date_format(dataprazo_retirada,'%d/%m/%Y') AS dataPrazoRetirada,
    tb_paciente.celular1,
    tb_paciente.celular2,
    tb_paciente.celular3,
    ucase(tb_paciente.bairro_paciente) AS bairroPaciente,
    ucase(tb_estabelecimento.nfantasia_estabelecimento) As unidadeSolicitante
    FROM reg_tb_solicitacoes
    INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente) 
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento) 
    INNER JOIN reg_rl_classificacaorisco ON (reg_tb_solicitacoes.id_classificacaorisco = reg_rl_classificacaorisco.id_classificacaorisco) 
    INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao = reg_rl_statussolicitacao.id_statussolicitacao) 
    INNER JOIN tb_estabelecimento ON (reg_tb_solicitacoes.id_unidade_cadastrou = tb_estabelecimento.codigoestabelecimento_cnes) 
    $setWhare 
    ORDER BY reg_tb_solicitacoes.id_classificacaorisco ASC, posicao_fila ASC";

    $stmSolicitacoes    = $rsConexao->prepare($sqlSolicitacoes);
    $stmSolicitacoes->execute();
    $totalSolicitacoes  = $stmSolicitacoes->rowCount();
    $rsSolicitacoes     = $stmSolicitacoes->fetchAll(PDO::FETCH_ASSOC);

    if ($totalSolicitacoes > 0) {
      $temRegistro = true;
      foreach ($rsSolicitacoes as $fieldSolicitacoes) {
        $idProcedimento         = $fieldSolicitacoes['id_procedimento'];
        $idSolicitacao          = $fieldSolicitacoes['id_solicitacao'];
        $idPaciente             = $fieldSolicitacoes['id_paciente'];
        $classificacaoRisco     = mb_strtoupper($fieldSolicitacoes['nome_classificacaorisco']);
        $corClassificacao       = $fieldSolicitacoes['cor_classificacaorisco'];
        $corLetraClassificacao  = $corClassificacao == "#B60E16" ? " color:#FFF" : "color: #000";
        $dataCadastro           = $fieldSolicitacoes['dataCadastro'];
        $horaCadastro           = $fieldSolicitacoes['horaCadastro'];
        $nomePaciente           = $fieldSolicitacoes['nome_paciente'];
        $idadePaciente          = $fieldSolicitacoes['idadePaciente'];
        $CNSPaciente            = $fieldSolicitacoes['cns_paciente'];
        $telefonePaciente       = $fieldSolicitacoes['celular1'] . "<br>" . $fieldSolicitacoes['celular2'] . "<br>" . $fieldSolicitacoes['celular3'];
        $bairroPaciente         = $fieldSolicitacoes['bairroPaciente'];
        $nomeProcedimento       = $fieldSolicitacoes['id_procedimento'] != "" ? mb_strtoupper($fieldSolicitacoes['nome_procedimento']) : "EXAMES DE LABORATÓRIO";
        $numeroProtocolo        = $fieldSolicitacoes['numero_procotolo'];
        $nomeStatusSolicitacao  = $fieldSolicitacoes['nome_statusslicitacao'];
        $idStatusSolicitacao    = $fieldSolicitacoes['id_statussolicitacao'];
        $obsExtraAgendamento    = $fieldSolicitacoes['observacaoextra_agendamento'] != "" ? mb_strtoupper($fieldSolicitacoes['observacaoextra_agendamento']) : "";
        $temRelatorioMedico     = $fieldSolicitacoes['tem_relatoriomedico'] == "S" ? "style=background-color:#b6e4c2; padding:50px !important" : "";
        $posicaoFila            = $fieldSolicitacoes['posicao_fila'];
        $origemAgendamento      = $fieldSolicitacoes['origem_agendamento'];
        $dataPrazoRetirada      = $fieldSolicitacoes['dataPrazoRetirada'];
        $diasEspera             = $fieldSolicitacoes['id_statussolicitacao'] == 2 ? "<br><b>Dias (" . $fieldSolicitacoes['diasEspera'] . ")</b>" : "";
        $unidadeSolicitante     = $fieldSolicitacoes['unidadeSolicitante'];
        if ($fieldSolicitacoes['prazoRetiradaVencido'] != "" && $fieldSolicitacoes['prazoRetiradaVencido'] < $dataHoje && $fieldSolicitacoes['id_statussolicitacao'] == 3) {
          $prazoRetiradaVencido     = "style='background-color:#860000; color: #fff; padding:5px !important'";
          $statusTextoComplementar  = "<font style='font-size:8pt'><br>(prazo retirada)</font>";
        } else {
          $prazoRetiradaVencido     = "";
          $statusTextoComplementar  = "";
        }

        # ----- CONFIGURAÇÃO DOS BOTÕES DE COMANDO ----- #
        $comandoAcesso          = "";
        $botaoComandoAcesso     = "";
        $comandoImpressao       = "";
        $botaoComandoImpressao  = "";

        if ($idPerfilLogado == 1) {
          if ($fieldSolicitacoes['id_procedimento'] != "") {
            $comandoConsultar       = 'onClick="window.location.href=' . "'solicitacao_cadastro?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp'" . '"';
            $botaoComandoConsultar  = "<i class='icofont icofont-search nova_fonte_blue' title='Visualizar soliciação.' $comandoConsultar></i>&nbsp;";
          } else {
            $comandoConsultar       = 'onClick="window.location.href=' . "'solicitacao_laboratorio?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp'" . '"';
            $botaoComandoConsultar  = "<i class='icofont icofont-search nova_fonte_blue' title='Visualizar soliciação.' $comandoConsultar></i>&nbsp;";
          }

          if ($idStatusSolicitacao != 1 && $idStatusSolicitacao != 3 && $idStatusSolicitacao != 4 && $idStatusSolicitacao != 6) {
            $comandoAgendarPoliclinca       = 'onClick="window.open(' . "'solicitacao_agendarexterno?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoComandoAgendarPoliclinica = "<i class='icofont icofont-external nova_fonte' title='Realizar agendamento de vaga externa.' $comandoAgendarPoliclinca></i>&nbsp;";
            $comandoAgendarGSaude           = 'onClick="window.open(' . "'solicitacao_agendar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoAgendarGSaude             = "<i class='icofont icofont-checked nova_fonte' title='Realizar agendamento.' $comandoAgendarGSaude></i>&nbsp;";
          } else {
            $botaoComandoAgendarPoliclinica = "";
            $botaoAgendarGSaude             = "";
            $botaoComandoAnalisar           = "";
          }

          if ($idStatusSolicitacao != 3 && $idStatusSolicitacao != 4 && $idStatusSolicitacao != 6) {

            $comandoAnalisar        = 'onClick="window.open(' . "'solicitacao_analisar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoComandoAnalisar   = "<i class='icofont icofont-document-search nova_fonte_blue' title='Analisar soliciação.' $comandoAnalisar></i>&nbsp;";
          }
        } else {

          if ($idPerfilLogado == 5 || $idPerfilLogado == 7 || $idPerfilLogado == 8 || $idPerfilLogado == 14) {
            if ($idStatusSolicitacao != 3 && $idStatusSolicitacao != 4 && $idStatusSolicitacao != 6) {
              $comandoAnalisar        = 'onClick="window.open(' . "'solicitacao_analisar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
              $botaoComandoAnalisar   = "<i class='icofont icofont-document-search nova_fonte_blue' title='Analisar soliciação.' $comandoAnalisar></i>&nbsp;";
            } else {
              $botaoComandoAnalisar   = "";
            }
            $botaoComandoConsultar  = "";
            $botaoComandoAgendarPoliclinica    = "";
            $botaoAgendarGSaude = "";
          } else if ($idPerfilLogado != 5 && $idPerfilLogado != 7 && $idPerfilLogado != 8 && $idPerfilLogado != 14) {

            if ($idPerfilLogado != 4) {
              if ($fieldSolicitacoes['id_procedimento'] != "") {
    $comandoConsultar       = 'onClick="window.location.href=' . "'solicitacao_cadastro?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp'" . '"';
    $botaoComandoConsultar  = "<i class='icofont icofont-search nova_fonte_blue' title='Visualizar soliciação.' $comandoConsultar></i>&nbsp;";
                  } else {
    $comandoConsultar       = 'onClick="window.location.href=' . "'solicitacao_laboratorio?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp'" . '"';
    $botaoComandoConsultar  = "<i class='icofont icofont-search nova_fonte_blue' title='Visualizar soliciação.' $comandoConsultar></i>&nbsp;";
              }
              $botaoComandoAnalisar   = "";
              $botaoComandoAgendarPoliclinica    = "";
              $botaoAgendarGSaude = "";

              if ($idPerfilLogado == 6) {
    if ($idStatusSolicitacao != 3 && $idStatusSolicitacao != 6) {
      $comandoAnalisar        = 'onClick="window.open(' . "'solicitacao_analise_as?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
      $botaoComandoAnalisar   = "<i class='icofont icofont-document-search nova_fonte_blue' title='Analisar soliciação.' $comandoAnalisar></i>&nbsp;";
    }
              }
            } else {
              if (($idStatusSolicitacao != 1 && $idStatusSolicitacao != 3 && $idStatusSolicitacao != 5 && ($idStatusSolicitacao >= 6 && $idStatusSolicitacao <= 9))) {
    $comandoAgendarPoliclinca = 'onClick="window.open(' . "'solicitacao_agendarexterno?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
    $botaoComandoAgendarPoliclinica = "<i class='icofont icofont-external nova_fonte_blue' title='Realizar agendamento de vaga externa.' $comandoAgendarPoliclinca></i>&nbsp;";
    $comandoAgendarGSaude           = 'onClick="window.open(' . "'solicitacao_agendar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
    $botaoAgendarGSaude             = "<i class='icofont icofont-checked nova_fonte_blue' title='Realizar agendamento.' $comandoAgendarGSaude></i>&nbsp;";
              } else {
    if ($idStatusSolicitacao == 5 || $idStatusSolicitacao == 14) {
      $comandoAnalisar        = 'onClick="window.open(' . "'solicitacao_analisar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
      $botaoComandoAnalisar   = "<i class='icofont icofont-document-search nova_fonte_blue' title='Analisar soliciação.' $comandoAnalisar></i>&nbsp;";
    }

    $botaoComandoAgendarPoliclinica = "";
    $botaoAgendarGSaude = "";
              }
              $botaoComandoConsultar  = "";
              $botaoComandoAnalisar   = "";
            }
          }
        }

        # ----- comando enviar para cancelamento ----- #        
        if ($idStatusSolicitacao != 3 && $idPerfilLogado != 1) {
          $conteudoSolicitacaoCancelar  = $idSolicitacao . "#" . $nomePaciente . "#" . $nomeProcedimento;
          $comandoCancelar = 'onclick="solicitarCancelamento(' . "'$conteudoSolicitacaoCancelar')" . '"';
          $botaoCancelar   = "<i class='icofont icofont-exchange nova_fonte_delete' title='Enviar solicitação para cancelamento.' $comandoCancelar></i>&nbsp;";
        } else {
          $comandoCancelar = "";
          $botaoCancelar   = "";
        }
        # ----- -------------------------------- ----- #

        # ----- comando cancelar solicitação ----- #
        if ($idPerfilLogado == 1) {
          $conteudoCancelarSoliitacao = $idSolicitacao . "#" . $idPaciente;
          if ($idStatusSolicitacao != 5 && $idStatusSolicitacao != 7 && $idStatusSolicitacao != 8) {
            $comandoCancelar = 'onClick="window.open(' . "'solicitacao_cancelar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoCancelar   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar solicitação do paciente.' $comandoCancelar></i>&nbsp;";
          } else {
            $botaoCancelar  = "";
          }
        } else {
          if ($idStatusSolicitacao == 4) {
            $conteudoCancelarSoliitacao = $idSolicitacao . "#" . $idPaciente;
            $comandoCancelar = 'onClick="window.open(' . "'solicitacao_cancelar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoCancelar   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar solicitação do paciente.' $comandoCancelar></i>&nbsp;";
          } else {
            if ($idPerfilLogado == 3 || $idPerfilLogado == 4 || $idPerfilLogado == 6) {
              $conteudoCancelarSoliitacao = $idSolicitacao . "#" . $idPaciente;
              $comandoCancelar = 'onClick="window.open(' . "'solicitacao_cancelar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
              $botaoCancelar   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar solicitação do paciente.' $comandoCancelar></i>&nbsp;";
            } else {
              $comandoCancelar = "";
              $botaoCancelar   = "";
            }
          }
        }
        # ----- -------------------------------- ----- #

        if ($idStatusSolicitacao != 4 && $idStatusSolicitacao != 5) {

          if ($idStatusSolicitacao != 3) {
            $comandoImpressao       = 'onClick="window.open(' . "'imprimir_protocolo?idsol=$idSolicitacao')" . '"';
            $botaoComandoImpressao  = "<i class='icofont icofont-print nova_fonte_blue' title='Imprimir prococolo de solicitação.' $comandoImpressao></i>&nbsp;";
            $botaoComandoEntrega    = "";

            if ($idStatusSolicitacao == 6) {
              $comandoEntrega       = 'onClick="window.open(' . "'solicitacao_entregar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
              $botaoComandoEntrega  = "<i class='icofont icofont-paper nova_fonte' title='Registrar entrega de marcação.' $comandoEntrega></i>&nbsp;";
            } else {
              $botaoComandoEntrega    = "";
            }
          } else {

            if ($idPerfilLogado != 5) {
              $comandoEntrega       = 'onClick="window.open(' . "'solicitacao_entregar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
              $botaoComandoEntrega  = "<i class='icofont icofont-paper nova_fonte' title='Registrar entrega de marcação.' $comandoEntrega></i>&nbsp;";
            } else {
              $botaoComandoEntrega    = "";
            }
            $botaoComandoImpressao  = "";
          }
        } else {
          $botaoComandoEntrega    = "";
        }

        if ($idPerfilLogado == 4 || $idPerfilLogado == 11 || $idPerfilLogado == 12 || $idPerfilLogado == 14 || $idPerfilLogado == 17) {
          if ($idStatusSolicitacao != 1 && $idStatusSolicitacao != 3 && $idStatusSolicitacao != 6) {

            if ($idPerfilLogado != 11 && $idPerfilLogado != 12) {
              $comandoAgendarPoliclinca       = 'onClick="window.open(' . "'solicitacao_agendarexterno?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
              $botaoComandoAgendarPoliclinica = "<i class='icofont icofont-external nova_fonte_blue' title='Realizar agendamento de vaga externa.' $comandoAgendarPoliclinca></i>&nbsp;";
            } else {
              $botaoComandoAgendarPoliclinica = "";
            }

            $comandoAgendarGSaude           = 'onClick="window.open(' . "'solicitacao_agendar?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoAgendarGSaude             = "<i class='icofont icofont-checked nova_fonte' title='Realizar agendamento.' $comandoAgendarGSaude></i>&nbsp;";
          } else {
            $botaoComandoAgendarPoliclinica = "";
            $botaoAgendarGSaude             = "";
          }
        }

        if ($idPerfilLogado == 6) {
          if ($idStatusSolicitacao != 3 && $idStatusSolicitacao != 4 && $idStatusSolicitacao != 5 && $idStatusSolicitacao != 6) {
            $comandoAnalisar        = 'onClick="window.open(' . "'solicitacao_analise_as?idpac=$idPaciente&idsol=$idSolicitacao&op=$getOp')" . '"';
            $botaoComandoAnalisar   = "<i class='icofont icofont-document-search nova_fonte_blue' title='Analisar soliciação.' $comandoAnalisar></i>&nbsp;";
          }
        }


        if ($idStatusSolicitacao != 5) {
          $concatenaComandos  = $botaoComandoConsultar . " " . $botaoComandoAnalisar . " " . $botaoCancelar;
        } else {
          $concatenaComandos  = $botaoComandoConsultar . " " . $botaoComandoAnalisar;
          $botaoComandoAgendarPoliclinica = "";
          $botaoAgendarGSaude = "";
        }
        # ----- ----------------------------------- ----- #
        if ($idPerfilLogado == 1 || $idPerfilLogado == 4) {
          $tdObsExtraAgendamento = "<td>$obsExtraAgendamento</td>";
        } else {
          $tdObsExtraAgendamento = "";
        }

        # -- Exibir status do procedimento --#
        if ($idStatusSolicitacao == 2) {
          $mostarPosicaoFila  = $posicaoFila != "" && $posicaoFila != 0 ? "<br><b>Posição fila: $posicaoFila</b>" : "";
        } else {
          $mostarPosicaoFila  = "";
        }
        # -- Exibir status do procedimento --#
        if ($idStatusSolicitacao == 3 || $idStatusSolicitacao == 4) {
          $mostarOrigemAgendamento  = "<br><b>Origem: <font style='color:#0062a3'>$origemAgendamento</font></b>";
        } else {
          $mostarOrigemAgendamento  = "";
        }

        if ($idPerfilLogado == 1 || $idPerfilLogado == 4 || $idPerfilLogado == 11 || $idPerfilLogado == 12) {
          if ($idStatusSolicitacao == 3) {
            $comandoPrazoEntrega  = 'onClick="alterarPrazoEntrega(' . "'solicitacao','$idSolicitacao')" . '"';
            $botaoPrazoEntrega    = "<i class='fa fa-edit nova_fonte_blue' title='Alterar prazo de retirada.' $comandoPrazoEntrega></i>&nbsp;";
          } else {
            $botaoPrazoEntrega    = "";
          }
        } else {
          $botaoPrazoEntrega    = "";
        }

        $cmdConfirmaAtendidoMutirao = 'onClick="window.open(' . "'confirmar_atendimento_mutirao?idpac=$idPaciente')" . '"';
        $btnConfirmaAtendidoMutirao = "<i class='icofont icofont-prescription nova_fonte_blue' title='Confirmar atendimento em mutirão.' $cmdConfirmaAtendidoMutirao></i>";

        # -- icone para envio do paciente para atuaização do telefone --#
        if ($idPerfilLogado == 1 || $idPerfilLogado == 4 || $idPerfilLogado == 14) {
          $icoEnviarPaciente = 'onClick="enviarPacienteAtualizacao(' . "'$idPaciente','$nomePaciente','idLinha$idPaciente')" . '"';
          $icoEnviarPaciente = "<i class='icofont icofont-id-card nova_fonte' style='font-size:15pt' title='Enviar paciente para atualização.' $icoEnviarPaciente></i>";
        } else {
          $icoEnviarPaciente = "";
        }

        $htmlRetorno .= "<tr id='idLinha$idPaciente'>
          <th style='text-align:center; width:150px'>
            $icoEnviarPaciente
            $concatenaComandos
            $botaoComandoImpressao
            $botaoComandoEntrega
            $botaoComandoAgendarPoliclinica
            $botaoAgendarGSaude
            $botaoPrazoEntrega
            $btnConfirmaAtendidoMutirao            
          </td>
          <td style='background-color:$corClassificacao; $corLetraClassificacao'>$classificacaoRisco</td>
          <td align='center'>$dataCadastro$diasEspera</td>
          <td>
            <div style='width:auto; padding:2px; color: #00408a; font-size:9pt'><b>$nomePaciente</b></div>            
            <div style='width:auto; padding:2px; color:rgb(15, 128, 0); font-size:7pt'><b>Bairro: $bairroPaciente</b></div>
          </td>
          <td align='center'>$idadePaciente</td>
          <td align='center'>$CNSPaciente</td>
          <td>$nomeProcedimento $mostarPosicaoFila$mostarOrigemAgendamento</td>
          <td align='center'>$telefonePaciente</td>
          <td align='center'>$numeroProtocolo</td>
          <td align='center' id='tdStatusSolicitacao$idSolicitacao' $temRelatorioMedico $prazoRetiradaVencido>$nomeStatusSolicitacao$statusTextoComplementar</td>
          <td align='center'>$unidadeSolicitante</td>
          $tdObsExtraAgendamento
        </tr>";
      }
    } else {
      $temRegistro = false;
    }

    # -- carregar agendamentos avulso -- #
    if (($statusSolicitacao == 3 || $statusSolicitacao == 4 || $statusSolicitacao == 5 || $statusSolicitacao == 6) || ($statusSolicitacao == "" && ($numeroCNSCPF != "" || $numeroProtocolo != ""))) {
      $grupoProcedimento    = $_POST['grupoProcedimento'];
      $nomeProcedimento     = $_POST['nomeProcedimento'];
      $numeroCNSCPF         = $_POST['numeroCNSCPF'];
      $numeroProtocoloAAV   = $_POST['numeroProtocolo'];
      $dataInicialPesquisa  = $_POST['dataInicialPesquisa'];
      $dataFinalPesquisa    = $_POST['dataFinalPesquisa'];
      $marcacaoEntregue     = $statusSolicitacao == 6 ? "='S'" : " IS NULL";

      $formatarStatus = array(
        3 => 'A',
        4 => 'X',
        5 => 'C',
        6 => 'E'
      );

      if ($numeroProtocoloAAV == "") {
        $whereSQL = " WHERE (id_agendamento>0)";
        $whereSQL = $grupoProcedimento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_grupo_procedimento='$grupoProcedimento')";
        $whereSQL = $nomeProcedimento     == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_procedimento='$nomeProcedimento')";
        $whereSQL = $numeroCNSCPF         == "" ? $whereSQL : $whereSQL . " AND (tb_paciente.cns_paciente='$numeroCNSCPF' OR tb_paciente.cpf_paciente='$numeroCNSCPF')";
        $whereSQL = $dataInicialPesquisa  != "" && $dataInicialPesquisa != "" ? $whereSQL . " AND (reg_tb_agendamentos.data_atendimento BETWEEN '$dataInicialPesquisa' AND '$dataFinalPesquisa')" : $whereSQL;
        $whereSQL = $whereSQL . "AND (reg_tb_agendamentos.origem_agendamento!='S-FG') AND (reg_tb_agendamentos.marcacao_entregue$marcacaoEntregue)";
      } else {
        $whereSQL = "WHERE (reg_tb_agendamentos.protocolo_agendamento='$numeroProtocoloAAV') AND (reg_tb_agendamentos.origem_agendamento!='S-FG')";
      }

      if ($statusSolicitacao != "") {
        $statusAgendamento  = $formatarStatus[$statusSolicitacao];
        $whereSQL .= " AND (reg_tb_agendamentos.status_agendamento='$statusAgendamento')";
      } else {
        $whereSQL = $whereSQL;
      }

      $sqlAgendamentos  = "SELECT reg_tb_agendamentos.id_agendamento,
          reg_tb_agendamentos.protocolo_agendamento,
          reg_tb_agendamentos.tipo_vagaocupada,
          reg_tb_agendamentos.id_paciente,
          reg_tb_agendamentos.id_solicitacao,
          reg_tb_agendamentos.marcacao_entregue,
          tb_paciente.nome_paciente,
          tb_paciente.cns_paciente,
          date_format(tb_paciente.datanasc, '%d/%m/%Y') AS dataNascimento,
          TIMESTAMPDIFF(YEAR, tb_paciente.datanasc, NOW()) AS idadePaciente,
          tb_paciente.celular1,
          tb_paciente.celular2,
          tb_paciente.celular3,
          reg_tb_agendamentos.id_procedimento,
          reg_tb_procedimento.nome_procedimento,
          tb_estabelecimento.nfantasia_estabelecimento,
          date_format(reg_tb_agendamentos.datahora_agendamento, '%d/%m/%Y') AS dataAgendamento,
          date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
          date_format(reg_tb_agendamentos.data_atendimento, '%Y-%m-%d') AS dataAtendimentoConfirmar,
          date_format(reg_tb_agendamentos.dataprazo_retirada, '%d/%m/%Y') AS dataRetirada,
          reg_tb_agendamentos.data_atendimento,
          reg_tb_usuario.nome_usuario,
          reg_tb_agendamentos.status_agendamento,
          reg_tb_agendamentos.horario_atendimento,
          reg_tb_agendamentos.chave_confirmacao
          FROM reg_tb_agendamentos
          INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento)
          INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
          INNER JOIN reg_tb_usuario ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_agendou)
          LEFT OUTER JOIN reg_tb_agenda ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
          LEFT OUTER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
          LEFT OUTER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
          $whereSQL
          GROUP BY reg_tb_usuario.nome_usuario, reg_tb_agendamentos.id_agendamento
          ORDER BY reg_tb_usuario.nome_usuario";

      $stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
      $stmAgendamentos->execute();

      if ($stmAgendamentos->rowCount() > 0) {
        $temRegistro = true;
        $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rsAgendamentos as $fieldAgendamento) {
          $corFontChave       = "";
          $idPaciente         = $fieldAgendamento['id_paciente'];
          $idAgendamento      = $fieldAgendamento['id_agendamento'];
          $idSolicitacao      = $fieldAgendamento['id_solicitacao'];
          $nomePaciente       = mb_strtoupper($fieldAgendamento['nome_paciente']);
          $cnsPaciente        = $fieldAgendamento['cns_paciente'];
          $dataNascimento     = $fieldAgendamento['dataNascimento'];
          $idadePaciente      = $fieldAgendamento['idadePaciente'];
          $numerosTelefone    = $fieldAgendamento['celular1'] . ', ' . $fieldAgendamento['celular2'] . ', ' . $fieldAgendamento['celular3'];
          $nomeProcedimento   = mb_strtoupper($fieldAgendamento['nome_procedimento']);
          $nomeUnidade        = mb_strtoupper($fieldAgendamento['nfantasia_estabelecimento']);
          $dataAgendamento    = $fieldAgendamento['dataAgendamento'];
          $dataAtendimento    = $fieldAgendamento['dataAtendimento'];
          $exibirProtocolo    = $fieldAgendamento['protocolo_agendamento'];
          $tipoVagaOcupada    = mb_strtoupper($fieldAgendamento['tipo_vagaocupada']);
          $validarDataCMD     = $fieldAgendamento['data_atendimento'];
          $dataPrazoRetirada  = $fieldAgendamento['dataRetirada'];
          $classificaoGET     = "avulso";

          if ($fieldAgendamento['status_agendamento'] == "P") {
            $corFontChave = "style:color:#720000; font-weight: bold;";
          } else if ($fieldAgendamento['status_agendamento'] == "V") {
            $corFontChave = "style:color:#02751f; font-weight: bold;";
          }

          $formatarStatus = array(
            'A' => 'AGENDADO',
            'E' => 'AGENDADO/ENTREGUE',
            'C' => 'CANCELADO',
            'P' => 'PENDENTE',
            'V' => 'ATENDIDO',
            'X' => 'CANCELAR',
          );
          $nomeStatusSolicitacao  = $formatarStatus[$fieldAgendamento['status_agendamento']];

          if ($tipoVagaOcupada == 'PVEZ' || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
            $origemAgendamento  = "<b>Origem: <font style='color:#00509F'>AGENDA - ($tipoVagaOcupada)</font></b>";
          } else {
            $origemAgendamento        = "<b>Origem: VAGA EXTERNA: <b><font style='color:#00509F'>$tipoVagaOcupada</font></b>";
          }
          $botaoImprimirAgendamento = "";
          if ($fieldAgendamento['status_agendamento'] == "A" || $fieldAgendamento['status_agendamento'] == "E" || $fieldAgendamento['status_agendamento'] == "X") {
            if ($fieldAgendamento['status_agendamento'] == "A") {
              $comandoEntrega       = 'onClick="window.open(' . "'agendamento_entregar?idpac=$idPaciente&idagendam=$idAgendamento&op=sc')" . '"';
              $botaoComandoEntrega  = "<i class='icofont icofont-paper nova_fonte' title='Registrar entrega de marcação.' $comandoEntrega></i>&nbsp;";
            } else if ($fieldAgendamento['status_agendamento'] == "E") {
              if ($idSolicitacao == "") {
              $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG')" . '"';
              $botaoImprimirAgendamento = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
            } else {
              $botaoImprimirAgendamento = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
              }
              $botaoComandoEntrega = "";
            } else {
              $botaoComandoEntrega  = "";
              $botaoImprimirAgendamento = "";
            }
            if ($idPerfilLogado == 1 || $idPerfilLogado == 14) {
              $comandoCancelar = 'onClick="window.open(' . "'agendamento_cancelar?idpac=$idPaciente&idagendam=$idAgendamento')" . '"';
              $botaoCancelar   = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar agendamento.' $comandoCancelar></i>&nbsp;";
            } else {
              $botaoCancelar    = "";
              $botaoImprimirAgendamento = "";
            }
          } else {
            $botaoComandoEntrega  = "";
            $botaoCancelar        = "";
            $botaoImprimirAgendamento = "";
          }
          $classificaoAgendamento = "AVULSO<br>ELETIVO";

          if ($idPerfilLogado == 1 || $idPerfilLogado == 4 || $idPerfilLogado == 11 || $idPerfilLogado == 12 || $idPerfilLogado == 14) {
            if ($fieldAgendamento['status_agendamento'] == "A") {
              $comandoPrazoEntrega  = 'onClick="alterarPrazoEntrega(' . "'agendamento-avulso','$idAgendamento')" . '"';
              $botaoPrazoEntrega    = "<i class='fa fa-edit nova_fonte_blue' title='Alterar prazo de retirada.' $comandoPrazoEntrega></i>&nbsp;";
            } else {
              $botaoPrazoEntrega    = "";
            }
          } else {
            $botaoPrazoEntrega    = "";
          }

          if ($idProcedimento == "350") {
            $cmdConfirmaAtendidoMutirao = 'onClick="window.open(' . "'confirmar_atendimento_mutirao?idpac=$idPaciente')" . '"';
            $btnConfirmaAtendidoMutirao = "<i class='icofont icofont-prescription nova_fonte_blue' title='Confirmar atendimento em mutirão.' $cmdConfirmaAtendidoMutirao></i>";
          } else {
            $btnConfirmaAtendidoMutirao = "";
          }

          $htmlRetorno .= "<tr>
    <td align='center'>
      $botaoComandoEntrega
      $botaoCancelar
      $botaoPrazoEntrega
      $botaoImprimirAgendamento
      $btnConfirmaAtendidoMutirao
    </td>
    <td style='background-color: #46C8FF; color:#000'>$classificaoAgendamento</td>
    <td align='center'>$dataAgendamento</td>
    <td>$nomePaciente</td>
    <td align='center'>$idadePaciente</td>
    <td align='center'>$cnsPaciente</td>
    <td>$nomeProcedimento<br>$origemAgendamento</td>
    <td align='center'>$exibirProtocolo</td>
    <td align='center'>$nomeStatusSolicitacao</td>
    <td align='center'>-----</td>
    <td></td>
    <td></td>
              </tr>";
        }
      }
    }
    # -----------------------------------#
    if ($temRegistro == true) {
      echo $htmlRetorno;
    } else {
      echo "NaoExiste";
    }
    break;

  case "historico-movimento":
    $idSolicitacao  = $_POST['idSolicitacao'];
    $sqlMovimento = "SELECT reg_tb_solicitacoes.*, date_format(reg_tb_solicitacoes_historico.datahora_registro,'%d/%m/%Y %H:%i') AS dataHoraRegistro, 
    reg_tb_solicitacoes_historico.texto_movimentacao, reg_rl_statussolicitacao.nome_statusslicitacao, reg_tb_usuario.nome_usuario AS registradoPor, 
    reg_tb_solicitacoes_historico.id_statussolicitacao AS statusSolicitacaoHistorico 
    FROM reg_tb_solicitacoes_historico 
    INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes_historico.id_statussolicitacao=reg_rl_statussolicitacao.id_statussolicitacao)
    INNER JOIN reg_tb_solicitacoes ON (reg_tb_solicitacoes_historico.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
    INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes_historico.idusuario_registrou = reg_tb_usuario.id_usuario) 
    WHERE reg_tb_solicitacoes_historico.id_solicitacao='$idSolicitacao'";
    $stmMovimento = $rsConexao->prepare($sqlMovimento);
    $stmMovimento->execute();
    if ($stmMovimento->rowCount() > 0) {
      $rsMovimento  = $stmMovimento->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsMovimento as $fieldMovimento) {
        $dataHoraRegistro   = $fieldMovimento['dataHoraRegistro'];
        $tipoMovimento      = $fieldMovimento['texto_movimentacao'];
        $statusSolicitacao  = $fieldMovimento['nome_statusslicitacao'];
        $registradoPor      = $fieldMovimento['registradoPor'];
        $textoObservacoes   = "";
        $idTeste = $fieldMovimento['statusSolicitacaoHistorico'];
        switch ($fieldMovimento['statusSolicitacaoHistorico']) {
          case 1:
            $textoObservacoes = mb_strtoupper($fieldMovimento['observacoes_solicitacao']);
            break;
          case 2:
          case 9:
          case 10:
            $textoObservacoes = mb_strtoupper($fieldMovimento['observacoes_analise']);
            break;
          case 3:
            $textoObservacoes = mb_strtoupper($fieldMovimento['observacao_agendamento']);
            break;
          case 4:
          case 5:
            $textoObservacoes = mb_strtoupper($fieldMovimento['justificativa_solicitacaocancelamento']);
            break;
        }

        echo "<tr>
          <td align='center' style='width:15%'>$dataHoraRegistro</td>
          <td>$tipoMovimento</td>
          <td>$statusSolicitacao</td>
          <td style='width:40%'>$textoObservacoes</td>
          <td>$registradoPor</td>
        </tr>";
      }
    }
    break;

  case "comunicacao-pacientes-whatsapp":
    $htmlRetorno = "";
    # -- pegar agendamentos da fila -- #
    $sqlSolicitacao  = "SELECT reg_tb_solicitacoes.id_paciente, reg_tb_solicitacoes.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
    FROM reg_tb_solicitacoes INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE id_statussolicitacao='3' 
    AND em_comunicacao='N' 
    AND encaminhado_ligacao='N' 
    AND dataprazo_retirada>='$dataHoje' 
    AND status_comunicacao is null
    GROUP BY tb_paciente.nome_paciente, reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.cns_paciente ORDER BY dataprazo_retirada, nome_paciente";
    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
    $stmSolicitacao->execute();
    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

    if ($stmSolicitacao->rowCount() > 0) {
      foreach ($rsSolicitacao as $fieldSolicitacao) {
        $idPaciente        = $fieldSolicitacao['id_paciente'];
        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registracomunicacao?idp=$idPaciente&opc=wp')" . '"';
        $htmlRetorno .= "<tr>
        <td style='text-align:center'>
        <i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
          <i class='icofont icofont-social-whatsapp nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
        </td>
        <td style='text-align:center'>$dataRetirada</td>
        <td>$nomePaciente</td>
        <td style='text-align:center'>$cnsPaciente</td>
      </tr>";
      }
    }

    # -- pegar agendamentos avulso -- #
    $sqlSolicitacao  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
    FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE status_agendamento='A'
    AND origem_agendamento!='S-FG' 
    AND em_comunicacao='N'
    AND encaminhado_ligacao='N' 
    AND dataprazo_retirada>='$dataHoje' 
    AND status_comunicacao is null
    GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.dataprazo_retirada, tb_paciente.cns_paciente 
    ORDER BY dataprazo_retirada, nome_paciente";
    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
    $stmSolicitacao->execute();
    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

    if ($stmSolicitacao->rowCount() > 0) {
      foreach ($rsSolicitacao as $fieldSolicitacao) {
        $idPaciente        = $fieldSolicitacao['id_paciente'];
        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registracomunicacao?idp=$idPaciente&opc=wp')" . '"';
        $htmlRetorno .= "<tr>
        <td style='text-align:center'>
        <i class='icofont icofont-ui-contact-list nova_fonte_blue' title='Encaminhar para tela de ligações.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
          <i class='icofont icofont-social-whatsapp nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
        </td>
        <td style='text-align:center'>$dataRetirada</td>
        <td>$nomePaciente</td>
        <td style='text-align:center'>$cnsPaciente</td>
      </tr>";
      }
    }
    echo $htmlRetorno;
    break;

  case "comunicacao-pacientes-ligacoes":
    $htmlRetorno = "";
    # -- pegar agendamentos da fila -- #
    $sqlSolicitacao  = "SELECT reg_tb_solicitacoes.id_paciente, reg_tb_solicitacoes.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
    FROM reg_tb_solicitacoes INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE id_statussolicitacao='3' 
    AND em_comunicacao='N'
    AND encaminhado_ligacao='S' 
    AND dataprazo_retirada>='$dataHoje' 
    AND status_comunicacao is null
    GROUP BY tb_paciente.nome_paciente, reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.cns_paciente 
    ORDER BY dataprazo_retirada, nome_paciente";

    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
    $stmSolicitacao->execute();
    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);
    if ($stmSolicitacao->rowCount() > 0) {
      foreach ($rsSolicitacao as $fieldSolicitacao) {
        $idPaciente        = $fieldSolicitacao['id_paciente'];
        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registraligacao?idp=$idPaciente&opc=tel')" . '"';
        $htmlRetorno .= "<tr>
        <td style='text-align:center'>
          <i class='icofont icofont-ui-contact-list nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
          <i class='icofont icofont-curved-double-right nova_fonte_blue' title='Encaminhar para tela de comunicação pelo whatsapp.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
        </td>
        <td style='text-align:center'>$dataRetirada</td>
        <td>$nomePaciente</td>
        <td style='text-align:center'>$cnsPaciente</td>
      </tr>";
      }
    }

    # -- pegar agendamentos avulso -- #
    $sqlSolicitacao  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente 
    FROM reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE status_agendamento='A'
    AND origem_agendamento!='S-FG'
    AND em_comunicacao='N'
    AND encaminhado_ligacao='S' 
    AND dataprazo_retirada>='$dataHoje' 
    AND status_comunicacao is null
    GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.dataprazo_retirada, tb_paciente.cns_paciente 
    ORDER BY dataprazo_retirada, nome_paciente";
    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
    $stmSolicitacao->execute();
    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

    if ($stmSolicitacao->rowCount() > 0) {
      foreach ($rsSolicitacao as $fieldSolicitacao) {
        $idPaciente        = $fieldSolicitacao['id_paciente'];
        $dataRetirada      = $fieldSolicitacao['dataRetirada'];
        $nomePaciente      = $fieldSolicitacao['nome_paciente'];
        $cnsPaciente      = $fieldSolicitacao['cns_paciente'];
        $dataretiradaEnc  = $fieldSolicitacao['dataprazo_retirada'];

        $atualizarRegistrosComunicacao  = '"atualizarRegistrosComunicacao(' . "'$idPaciente','$dataretiradaEnc')" . '"';
        $linkRegistrarComunicaco        = '"window.open(' . "'registraligacao?idp=$idPaciente&opc=tel')" . '"';
        $htmlRetorno .= "<tr>
        <td style='text-align:center'>
          <i class='icofont icofont-ui-contact-list nova_fonte' title='Registrar contrato com o paciente.' onclick=$linkRegistrarComunicaco></i>&nbsp;
          <i class='icofont icofont-curved-double-right nova_fonte_blue' title='Encaminhar para tela de comunicação pelo whatsapp.' onclick=$atualizarRegistrosComunicacao></i>&nbsp;
        </td>
        <td style='text-align:center'>$dataRetirada</td>
        <td>$nomePaciente</td>
        <td style='text-align:center'>$cnsPaciente</td>
      </tr>";
      }
    }
    echo $htmlRetorno;
    break;

  case "agendamento-paciente-policlinica":
    $htmlRetorno = "";
    $sqlSolicitacao  = "SELECT reg_tb_solicitacoes.id_paciente, reg_tb_solicitacoes.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente, date_format(dataprazo_retirada,'%Y%m%d') AS dataPrazoRetirada
    FROM reg_tb_solicitacoes 
    INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE (id_statussolicitacao='6' OR id_statussolicitacao='7')
    AND carro_policlinica='S'
    AND transporte_gerado='N'
    GROUP BY tb_paciente.nome_paciente, reg_tb_solicitacoes.dataprazo_retirada, tb_paciente.cns_paciente ORDER BY dataprazo_retirada, nome_paciente";
    $stmSolicitacao    = $rsConexao->prepare($sqlSolicitacao);
    $stmSolicitacao->execute();
    $rsSolicitacao      = $stmSolicitacao->fetchAll(PDO::FETCH_ASSOC);

    if ($stmSolicitacao->rowCount() > 0) {
      foreach ($rsSolicitacao as $fieldSolicitacao) {
        $idPaciente          = $fieldSolicitacao['id_paciente'];
        $dataRetirada        = $fieldSolicitacao['dataRetirada'];
        $nomePaciente        = $fieldSolicitacao['nome_paciente'];
        $cnsPaciente        = $fieldSolicitacao['cns_paciente'];
        $dataretiradaEnc    = $fieldSolicitacao['dataprazo_retirada'];
        $dataPrazoRetirada  = $fieldSolicitacao['dataPrazoRetirada'];
        $linkRegistrarTransporte  = '"window.open(' . "'registratransporte?idp=$idPaciente&dr=$dataPrazoRetirada&op=sol')" . '"';

        $htmlRetorno .= "<tr>
          <td style='text-align:center'>
            <i class='icofont icofont-edit nova_fonte' title='Registrar Transporte Policlínica.' onclick=$linkRegistrarTransporte></i>
          </td>
          <td style='text-align:center'>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
        </tr>";
      }
    }
    $sqlAgendamento  = "SELECT reg_tb_agendamentos.id_paciente, reg_tb_agendamentos.dataprazo_retirada, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente, date_format(dataprazo_retirada,'%Y%m%d') AS dataPrazoRetirada
    FROM reg_tb_agendamentos 
    INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento) 
    WHERE (origem_agendamento!='S-FG' AND status_agendamento='A')
    AND carro_policlinica='S'
    AND transporte_gerado='N'
    GROUP BY tb_paciente.nome_paciente, reg_tb_agendamentos.dataprazo_retirada, tb_paciente.cns_paciente ORDER BY dataprazo_retirada, nome_paciente";
    $stmAgendamento    = $rsConexao->prepare($sqlAgendamento);
    $stmAgendamento->execute();
    $rsAgendamento      = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);

    if ($stmAgendamento->rowCount() > 0) {
      foreach ($rsAgendamento as $fieldAgendamento) {
        $idPaciente          = $fieldAgendamento['id_paciente'];
        $dataRetirada        = $fieldAgendamento['dataRetirada'];
        $nomePaciente        = $fieldAgendamento['nome_paciente'];
        $cnsPaciente        = $fieldAgendamento['cns_paciente'];
        $dataretiradaEnc    = $fieldAgendamento['dataprazo_retirada'];
        $dataPrazoRetirada  = $fieldAgendamento['dataPrazoRetirada'];
        $linkRegistrarTransporte  = '"window.open(' . "'registratransporte?idp=$idPaciente&dr=$dataPrazoRetirada&op=agend')" . '"';

        $htmlRetorno  .= "<tr>
          <td style='text-align:center'>
            <i class='icofont icofont-edit nova_fonte' title='Registrar Transporte Policlínica.' onclick=$linkRegistrarTransporte></i>
          </td>
          <td style='text-align:center'>$dataRetirada</td>
          <td>$nomePaciente</td>
          <td style='text-align:center'>$cnsPaciente</td>
        </tr>";
      }
    }
    echo $htmlRetorno;

    break;

  case "solicitacao-paciente-oci":

    $unidadeSaude       = $_POST['unidadeSaude'];
    $procedimentoOCI    = $_POST['procedimentoOCI'];
    $cpfCNSPaciente     = $_POST['cpfCNSPaciente'];
    $nomePaciente       = $_POST['nomePaciente'];
    $classificacaoRisco = $_POST['classificacaoRisco'];
    
    $setWhare = "WHERE (reg_tb_procedimento_grupo.nome_grupo_procedimento LIKE '%OCI%') AND (reg_tb_solicitacoes.id_solicitacao>0)";
    $setWhare = $procedimentoOCI == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_procedimento='$procedimentoOCI')";
    $setWhare = $cpfCNSPaciente == "" ? $setWhare : $setWhare . " AND (tb_paciente.cpf_paciente='$cpfCNSPaciente' OR tb_paciente.cns_paciente='$cpfCNSPaciente')";
    $setWhare = $nomePaciente == "" ? $setWhare : $setWhare . " AND (tb_paciente.nome_paciente LIKE '%$nomePaciente%')";
    $setWhare = $unidadeSaude == "" ? $setWhare : $setWhare . " AND (reg_tb_tetounidade.codigoestabelecimento_cnes='$unidadeSaude')";
    $setWhare = $classificacaoRisco == "" ? $setWhare : $setWhare . " AND (reg_tb_solicitacoes.id_classificacaorisco='$classificacaoRisco')";

    $sqlPacienteOCI = "SELECT tb_paciente.id_paciente,
    tb_paciente.nome_paciente,
    timestampdiff(year,tb_paciente.datanasc,curdate()) AS idadePaciente,
    tb_paciente.sexo,
    tb_paciente.cpf_paciente,
    tb_paciente.cns_paciente,
    reg_tb_solicitacoes.id_solicitacao,
    reg_tb_solicitacoes.id_statussolicitacao,
    reg_tb_solicitacoes.id_grupo_procedimento,
    reg_tb_solicitacoes.id_procedimento,
    reg_tb_solicitacoes.posicao_fila,
    reg_tb_solicitacoes.oci_migrou_paraesus,
    reg_tb_solicitacoes.datahora_cadastro,
    date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y') As dataSolicitacao,
    date_format(reg_tb_solicitacoes.data_atendimento,'%d/%m/%Y') As dataAtendimento,
    reg_tb_solicitacoes.data_atendimento AS dataRecerenciaAtendimento,
    reg_tb_procedimento.nome_procedimento,
    reg_tb_procedimento_grupo.nome_grupo_procedimento,
    reg_rl_classificacaorisco.nome_classificacaorisco, 
    reg_rl_classificacaorisco.cor_classificacaorisco
    FROM reg_tb_solicitacoes
    INNER JOIN reg_rl_classificacaorisco ON (reg_tb_solicitacoes.id_classificacaorisco = reg_rl_classificacaorisco.id_classificacaorisco)
    INNER JOIN tb_paciente ON (reg_tb_solicitacoes.id_paciente = tb_paciente.id_paciente)
    INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
    INNER JOIN reg_tb_procedimento_grupo ON (reg_tb_procedimento_grupo.id_grupo_procedimento = reg_tb_solicitacoes.id_grupo_procedimento)
    INNER JOIN reg_tb_tetounidade ON (reg_tb_tetounidade.id_procedimento = reg_tb_procedimento.id_procedimento)
    $setWhare
    ORDER BY reg_tb_procedimento.nome_procedimento ASC, reg_tb_solicitacoes.id_classificacaorisco, reg_tb_solicitacoes.posicao_fila ASC";

    $stmPacienteOCI  = $rsConexao->prepare($sqlPacienteOCI);
    $stmPacienteOCI->execute();

    if ($stmPacienteOCI->rowCount() > 0) {
      $rsPacienteOCI   = $stmPacienteOCI->fetchAll(PDO::FETCH_ASSOC);
      foreach ($rsPacienteOCI as $fieldPacienteOCI) {
        $idPaciente     = $fieldPacienteOCI['id_paciente'];
        $idSolicitacao  = $fieldPacienteOCI['id_solicitacao'];
        $posicaoFila    = $fieldPacienteOCI['posicao_fila'];
        $nomePaciente   = $fieldPacienteOCI['nome_paciente'];
        $sexoPaciente   = $fieldPacienteOCI['sexo'];
        $idadePaciente  = $fieldPacienteOCI['idadePaciente'];
        $cpfPaciente    = $fieldPacienteOCI['cpf_paciente'];
        $cnsPaciente    = $fieldPacienteOCI['cns_paciente'];
        $statusSolicitacao = $fieldPacienteOCI['id_statussolicitacao'];
        $dataSolicitacaoOrdem  = $fieldPacienteOCI['datahora_cadastro'];
        $dataSolicitacao  = $fieldPacienteOCI['dataSolicitacao'];
        $dataAtendimento = $fieldPacienteOCI['dataAtendimento'];
        $dataRecerenciaAtendimento = $fieldPacienteOCI['dataRecerenciaAtendimento'];
        $setChecked     = $fieldPacienteOCI['oci_migrou_paraesus'] == "S" ? "checked" : "";
        $classificacaoRisco     = mb_strtoupper($fieldPacienteOCI['nome_classificacaorisco']);
        $corClassificacao       = $fieldPacienteOCI['cor_classificacaorisco'];
        $corLetraClassificacao  = $corClassificacao == "#B60E16" ? " color:#FFF" : "color: #000";

        # -- relacionar vínculos do profissional --#
        $sqlOCI = "SELECT reg_tb_procedimento.codigo_sus,
        ucase(reg_tb_procedimento.nome_procedimento) as nomeProcedimento
        FROM reg_tb_solicitacoes
        INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
        WHERE id_solicitacao='$idSolicitacao'";

        $stmOCI  = $rsConexao->prepare($sqlOCI);
        $stmOCI->execute();
        if ($stmOCI->rowCount() > 0) {
          $rsOCI    = $stmOCI->fetchAll(PDO::FETCH_ASSOC);
          $codigiProcedimento = "";
          $nomeProcedimento    = "";
          foreach ($rsOCI as $fieldOCI) {
            $codigoProcedimento  = $fieldOCI['codigo_sus'];
            $nomeProcedimento   = $fieldOCI['nomeProcedimento'];
            $nomeProcedimento  = "&bull; " . $codigoProcedimento . " - " . $nomeProcedimento;
          }
          $corFontProcedimento = "#027fbe";
        }


        # ----Definição da mensagem de início do ciclo da OCI #
        if ($statusSolicitacao == 2) {
          $cicloCuidadoIniciado = "<div class='aviso-OCINGC-naoiniciada'>
            <i class='icofont icofont-hour-glass'></i> Ciclo do cuidado não iniciado
          </div>";
        } else if ($statusSolicitacao == 5) {
          $cicloCuidadoIniciado = "<div class='aviso-OCINGC-cancelada'>
            <i class='icofont icofont-close-squared'></i> Solicitação de OCI cancelada
          </div>";
        } else {
          # -- calcular prazo para faturar -- #
          $dataCalculoPrazo = new DateTime("$dataRecerenciaAtendimento");
          $explodeDataReferencia = explode("-", $dataRecerenciaAtendimento);
          $mesAtendimento = $explodeDataReferencia[1];
          $anoAtendimento = $explodeDataReferencia[0];
          $ultimoDiaMesAtendimento   = new DateTime("last day of $anoAtendimento-$mesAtendimento");
          $diferencaDias  = $dataCalculoPrazo->diff($ultimoDiaMesAtendimento);
          $diasRestantes  = (int)$diferencaDias->days;
          $dataLimiteMesSeguinte = (clone $ultimoDiaMesAtendimento)->modify('+29 days');
          $dataFaturarLimite     = $dataLimiteMesSeguinte->format('d/m/Y');
          # -- --------------------------- -- #
          if ($dataRecerenciaAtendimento <= date('Y-m-d') && $dataAtendimento != '') {
            $textoCiclo = "Ciclo do cuidado iniciado em: $dataAtendimento; Concluir até $dataFaturarLimite para faturar.";
          } else {
            $textoCiclo = "Ciclo do cuidado a iniciar em: $dataAtendimento; Concluir até $dataFaturarLimite para faturar.";
          }
          $cicloCuidadoIniciado = "<div class='aviso-OCINGC-iniciada'>
            <i class='icofont icofont-checked'></i> $textoCiclo
          </div>";
        }

        $checkESUSReg = "<input type='checkbox' $setChecked onclick='assinalarfoiParaESUS($idSolicitacao,this.checked)' class='form-control checkbox-novo;' style='width:25px !important'>";
        # --------------------------------------------------------------------------- #

        # -- comandos de clique -- #
        $linkPcienteOCI  = '"window.open(' . "'ngc_pacienteoci?ids=$idSolicitacao&idp=$idPaciente')" . '"';
        if ($statusSolicitacao != 3 && $statusSolicitacao != 5 && $statusSolicitacao != 6) {
          $comandoCancelar = 'onClick="window.open(' . "'solicitacao_cancelar?idpac=$idPaciente&idsol=$idSolicitacao&op=sc')" . '"';
          $comandoCancelar = "<i class='icofont icofont-close-squared-alt nova_fonte_delete' title='Cancelar solicitação de OCI do paciente.' $comandoCancelar></i>";
        } else {
          $comandoCancelar = "";
        }
        echo "<tr>
          <td align='center' style='padding:0px !important;width:60px'>
            $checkESUSReg
          </td>
          <td align='center' style='width:80px'>
            <i class='icofont icofont-job-search nova_fonte blue' style='font-size:16pt' title='Acompanhar paciente.' onclick=$linkPcienteOCI></i>
            $comandoCancelar
          </td>
          <td style='background-color:$corClassificacao; $corLetraClassificacao'>$classificacaoRisco</td>
          <td align='center' style='width:50px'>$posicaoFila</td>
          <td align='center'>$dataSolicitacao</td>
          <td style='font-size:10pt'>
            <b>$nomePaciente</b>
            <div style='width:auto; padding:2px; color:$corFontProcedimento'>$nomeProcedimento</div>
            $cicloCuidadoIniciado
          </td>
          <td align='center'>$cpfPaciente</td>
          <td align='center'>$cnsPaciente</td>
          <td align='center'>$idadePaciente</td>
          <td align='center'>$sexoPaciente</td>
        </tr>";
      }
    }
    break;
}
